# openapi-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    create_aioa_cloud_waitlist = openapi_client.CreateAioaCloudWaitlist() # CreateAioaCloudWaitlist | 

    try:
        # Add To Waitlist
        api_response = api_instance.add_to_waitlist_api_v2_aioa_cloud_waitlist_post(create_aioa_cloud_waitlist)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->add_to_waitlist_api_v2_aioa_cloud_waitlist_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**add_to_waitlist_api_v2_aioa_cloud_waitlist_post**](docs/DefaultApi.md#add_to_waitlist_api_v2_aioa_cloud_waitlist_post) | **POST** /api/v2/aioa_cloud_waitlist/ | Add To Waitlist
*DefaultApi* | [**alter_organization_collaborator_api_v2_organization_collaborators_identity_id_put**](docs/DefaultApi.md#alter_organization_collaborator_api_v2_organization_collaborators_identity_id_put) | **PUT** /api/v2/organization_collaborators/{identity_id} | Alter Organization Collaborator
*DefaultApi* | [**alter_project_collaborator_api_v2_projects_project_id_collaborators_role_or_identity_id_put**](docs/DefaultApi.md#alter_project_collaborator_api_v2_projects_project_id_collaborators_role_or_identity_id_put) | **PUT** /api/v2/projects/{project_id}/collaborators/{role_or_identity_id} | Alter Project Collaborator
*DefaultApi* | [**apply_service_api_v2_services_v2_apply_put**](docs/DefaultApi.md#apply_service_api_v2_services_v2_apply_put) | **PUT** /api/v2/services-v2/apply | Apply Service
*DefaultApi* | [**archive_aica_endpoint_api_v2_aica_endpoints_endpoint_id_delete**](docs/DefaultApi.md#archive_aica_endpoint_api_v2_aica_endpoints_endpoint_id_delete) | **DELETE** /api/v2/aica_endpoints/{endpoint_id} | Archive Aica Endpoint
*DefaultApi* | [**archive_cluster_api_v2_decorated_sessions_cluster_id_archive_post**](docs/DefaultApi.md#archive_cluster_api_v2_decorated_sessions_cluster_id_archive_post) | **POST** /api/v2/decorated_sessions/{cluster_id}/archive | Archive Cluster
*DefaultApi* | [**archive_cluster_environment_api_v2_application_templates_application_template_id_archive_post**](docs/DefaultApi.md#archive_cluster_environment_api_v2_application_templates_application_template_id_archive_post) | **POST** /api/v2/application_templates/{application_template_id}/archive | Archive Cluster Environment
*DefaultApi* | [**archive_compute_template_api_v2_compute_templates_compute_template_id_archive_post**](docs/DefaultApi.md#archive_compute_template_api_v2_compute_templates_compute_template_id_archive_post) | **POST** /api/v2/compute_templates/{compute_template_id}/archive | Archive Compute Template
*DefaultApi* | [**archive_job_api_v2_decorated_ha_jobs_production_job_id_archive_post**](docs/DefaultApi.md#archive_job_api_v2_decorated_ha_jobs_production_job_id_archive_post) | **POST** /api/v2/decorated_ha_jobs/{production_job_id}/archive | Archive Job
*DefaultApi* | [**attach_machine_pool_to_cloud_api_v2_machine_pools_attach_post**](docs/DefaultApi.md#attach_machine_pool_to_cloud_api_v2_machine_pools_attach_post) | **POST** /api/v2/machine_pools/attach | Attach Machine Pool To Cloud
*DefaultApi* | [**batch_create_invitations_api_v2_organization_invitations_batch_create_post**](docs/DefaultApi.md#batch_create_invitations_api_v2_organization_invitations_batch_create_post) | **POST** /api/v2/organization_invitations/batch_create | Batch Create Invitations
*DefaultApi* | [**batch_get_job_api_v2_decorated_ha_jobs_batch_get_post**](docs/DefaultApi.md#batch_get_job_api_v2_decorated_ha_jobs_batch_get_post) | **POST** /api/v2/decorated_ha_jobs/batch_get | Batch Get Job
*DefaultApi* | [**begin_cluster_startup_api_v2_cluster_startups_post**](docs/DefaultApi.md#begin_cluster_startup_api_v2_cluster_startups_post) | **POST** /api/v2/cluster_startups/ | Begin Cluster Startup
*DefaultApi* | [**change_password_api_v2_users_change_password_post**](docs/DefaultApi.md#change_password_api_v2_users_change_password_post) | **POST** /api/v2/users/change_password | Change Password
*DefaultApi* | [**check_availability_api_v2_organizations_check_availability_get**](docs/DefaultApi.md#check_availability_api_v2_organizations_check_availability_get) | **GET** /api/v2/organizations/check_availability | Check Availability
*DefaultApi* | [**check_is_feature_flag_on_api_v2_userinfo_check_is_feature_flag_on_get**](docs/DefaultApi.md#check_is_feature_flag_on_api_v2_userinfo_check_is_feature_flag_on_get) | **GET** /api/v2/userinfo/check_is_feature_flag_on | Check Is Feature Flag On
*DefaultApi* | [**check_one_time_password_api_v2_users_request_otp_token_otp_get**](docs/DefaultApi.md#check_one_time_password_api_v2_users_request_otp_token_otp_get) | **GET** /api/v2/users/request_otp_token/{otp} | Check One Time Password
*DefaultApi* | [**cli_api_v2_machines_cli_get**](docs/DefaultApi.md#cli_api_v2_machines_cli_get) | **GET** /api/v2/machines/cli | Cli
*DefaultApi* | [**clone_workspace_api_v2_experimental_workspaces_from_workspace_post**](docs/DefaultApi.md#clone_workspace_api_v2_experimental_workspaces_from_workspace_post) | **POST** /api/v2/experimental_workspaces/from_workspace | Clone Workspace
*DefaultApi* | [**create_aica_endpoint_api_v2_aica_endpoints_post**](docs/DefaultApi.md#create_aica_endpoint_api_v2_aica_endpoints_post) | **POST** /api/v2/aica_endpoints/ | Create Aica Endpoint
*DefaultApi* | [**create_api_key_api_v2_users_create_api_key_post**](docs/DefaultApi.md#create_api_key_api_v2_users_create_api_key_post) | **POST** /api/v2/users/create_api_key | Create Api Key
*DefaultApi* | [**create_application_template_api_v2_application_templates_post**](docs/DefaultApi.md#create_application_template_api_v2_application_templates_post) | **POST** /api/v2/application_templates/ | Create Application Template
*DefaultApi* | [**create_bug_report_api_v2_machines_create_bug_report_post**](docs/DefaultApi.md#create_bug_report_api_v2_machines_create_bug_report_post) | **POST** /api/v2/machines/create_bug_report | Create Bug Report
*DefaultApi* | [**create_build_api_v2_builds_post**](docs/DefaultApi.md#create_build_api_v2_builds_post) | **POST** /api/v2/builds/ | Create Build
*DefaultApi* | [**create_byod_build_api_v2_builds_byod_post**](docs/DefaultApi.md#create_byod_build_api_v2_builds_byod_post) | **POST** /api/v2/builds/byod | Create Byod Build
*DefaultApi* | [**create_byod_cluster_environment_api_v2_application_templates_byod_post**](docs/DefaultApi.md#create_byod_cluster_environment_api_v2_application_templates_byod_post) | **POST** /api/v2/application_templates/byod | Create Byod Cluster Environment
*DefaultApi* | [**create_cloud_api_v2_clouds_post**](docs/DefaultApi.md#create_cloud_api_v2_clouds_post) | **POST** /api/v2/clouds/ | Create Cloud
*DefaultApi* | [**create_cloud_collaborator_api_v2_clouds_cloud_id_collaborators_users_post**](docs/DefaultApi.md#create_cloud_collaborator_api_v2_clouds_cloud_id_collaborators_users_post) | **POST** /api/v2/clouds/{cloud_id}/collaborators/users | Create Cloud Collaborator
*DefaultApi* | [**create_cloud_collaborator_api_v2_projects_project_id_collaborators_cloud_post**](docs/DefaultApi.md#create_cloud_collaborator_api_v2_projects_project_id_collaborators_cloud_post) | **POST** /api/v2/projects/{project_id}/collaborators/cloud | Create Cloud Collaborator
*DefaultApi* | [**create_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_post**](docs/DefaultApi.md#create_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_post) | **POST** /api/v2/clouds_with_cloud_resource_router/ | Create Cloud With Cloud Resource
*DefaultApi* | [**create_compute_template_api_v2_compute_templates_post**](docs/DefaultApi.md#create_compute_template_api_v2_compute_templates_post) | **POST** /api/v2/compute_templates/ | Create Compute Template
*DefaultApi* | [**create_connect_session_api_v2_sessions_create_connect_session_post**](docs/DefaultApi.md#create_connect_session_api_v2_sessions_create_connect_session_post) | **POST** /api/v2/sessions/create_connect_session | Create Connect Session
*DefaultApi* | [**create_endpoint_user_for_org_api_v2_organizations_organization_id_create_endpoint_user_post**](docs/DefaultApi.md#create_endpoint_user_for_org_api_v2_organizations_organization_id_create_endpoint_user_post) | **POST** /api/v2/organizations/{organization_id}/create_endpoint_user | Create Endpoint User For Org
*DefaultApi* | [**create_fine_tuning_job_api_v2_fine_tuning_jobs_create_post**](docs/DefaultApi.md#create_fine_tuning_job_api_v2_fine_tuning_jobs_create_post) | **POST** /api/v2/fine_tuning/jobs/create | Create Fine Tuning Job
*DefaultApi* | [**create_invitation_api_v2_organization_invitations_post**](docs/DefaultApi.md#create_invitation_api_v2_organization_invitations_post) | **POST** /api/v2/organization_invitations/ | Create Invitation
*DefaultApi* | [**create_job_api_v2_decorated_ha_jobs_create_post**](docs/DefaultApi.md#create_job_api_v2_decorated_ha_jobs_create_post) | **POST** /api/v2/decorated_ha_jobs/create | Create Job
*DefaultApi* | [**create_machine_api_v2_machines_create_post**](docs/DefaultApi.md#create_machine_api_v2_machines_create_post) | **POST** /api/v2/machines/create | Create Machine
*DefaultApi* | [**create_machine_pool_api_v2_machine_pools_create_post**](docs/DefaultApi.md#create_machine_pool_api_v2_machine_pools_create_post) | **POST** /api/v2/machine_pools/create | Create Machine Pool
*DefaultApi* | [**create_new_session_api_v2_sessions_create_new_session_post**](docs/DefaultApi.md#create_new_session_api_v2_sessions_create_new_session_post) | **POST** /api/v2/sessions/create_new_session | Create New Session
*DefaultApi* | [**create_one_time_password_api_v2_users_create_otp_token_get**](docs/DefaultApi.md#create_one_time_password_api_v2_users_create_otp_token_get) | **GET** /api/v2/users/create_otp_token | Create One Time Password
*DefaultApi* | [**create_or_update_job_api_v2_experimental_cron_jobs_put**](docs/DefaultApi.md#create_or_update_job_api_v2_experimental_cron_jobs_put) | **PUT** /api/v2/experimental_cron_jobs/ | Create Or Update Job
*DefaultApi* | [**create_organization_collaborator_api_v2_projects_project_id_collaborators_organization_post**](docs/DefaultApi.md#create_organization_collaborator_api_v2_projects_project_id_collaborators_organization_post) | **POST** /api/v2/projects/{project_id}/collaborators/organization | Create Organization Collaborator
*DefaultApi* | [**create_project_api_v2_projects_post**](docs/DefaultApi.md#create_project_api_v2_projects_post) | **POST** /api/v2/projects/ | Create Project
*DefaultApi* | [**create_project_collaborator_api_v2_projects_project_id_collaborators_users_post**](docs/DefaultApi.md#create_project_collaborator_api_v2_projects_project_id_collaborators_users_post) | **POST** /api/v2/projects/{project_id}/collaborators/users | Create Project Collaborator
*DefaultApi* | [**create_session_command_api_v2_sessions_session_id_create_session_command_post**](docs/DefaultApi.md#create_session_command_api_v2_sessions_session_id_create_session_command_post) | **POST** /api/v2/sessions/{session_id}/create_session_command | Create Session Command
*DefaultApi* | [**create_web_terminal_api_v2_sessions_session_id_web_terminals_post**](docs/DefaultApi.md#create_web_terminal_api_v2_sessions_session_id_web_terminals_post) | **POST** /api/v2/sessions/{session_id}/web_terminals | Create Web Terminal
*DefaultApi* | [**create_workspace_api_v2_experimental_workspaces_post**](docs/DefaultApi.md#create_workspace_api_v2_experimental_workspaces_post) | **POST** /api/v2/experimental_workspaces/ | Create Workspace
*DefaultApi* | [**create_workspace_from_job_api_v2_experimental_workspaces_from_job_post**](docs/DefaultApi.md#create_workspace_from_job_api_v2_experimental_workspaces_from_job_post) | **POST** /api/v2/experimental_workspaces/from_job | Create Workspace From Job
*DefaultApi* | [**create_workspace_from_template_api_v2_experimental_workspaces_from_template_post**](docs/DefaultApi.md#create_workspace_from_template_api_v2_experimental_workspaces_from_template_post) | **POST** /api/v2/experimental_workspaces/from_template | Create Workspace From Template
*DefaultApi* | [**delete_application_template_api_v2_application_templates_application_template_id_delete**](docs/DefaultApi.md#delete_application_template_api_v2_application_templates_application_template_id_delete) | **DELETE** /api/v2/application_templates/{application_template_id} | Delete Application Template
*DefaultApi* | [**delete_cloud_api_v2_clouds_cloud_id_delete**](docs/DefaultApi.md#delete_cloud_api_v2_clouds_cloud_id_delete) | **DELETE** /api/v2/clouds/{cloud_id} | Delete Cloud
*DefaultApi* | [**delete_cloud_collaborator_api_v2_clouds_cloud_id_collaborators_identity_id_delete**](docs/DefaultApi.md#delete_cloud_collaborator_api_v2_clouds_cloud_id_collaborators_identity_id_delete) | **DELETE** /api/v2/clouds/{cloud_id}/collaborators/{identity_id} | Delete Cloud Collaborator
*DefaultApi* | [**delete_compute_template_api_v2_compute_templates_template_id_delete**](docs/DefaultApi.md#delete_compute_template_api_v2_compute_templates_template_id_delete) | **DELETE** /api/v2/compute_templates/{template_id} | Delete Compute Template
*DefaultApi* | [**delete_machine_api_v2_machines_delete_post**](docs/DefaultApi.md#delete_machine_api_v2_machines_delete_post) | **POST** /api/v2/machines/delete | Delete Machine
*DefaultApi* | [**delete_machine_pool_api_v2_machine_pools_delete_post**](docs/DefaultApi.md#delete_machine_pool_api_v2_machine_pools_delete_post) | **POST** /api/v2/machine_pools/delete | Delete Machine Pool
*DefaultApi* | [**delete_project_api_v2_projects_project_id_delete**](docs/DefaultApi.md#delete_project_api_v2_projects_project_id_delete) | **DELETE** /api/v2/projects/{project_id} | Delete Project
*DefaultApi* | [**delete_project_collaborator_api_v2_projects_project_id_collaborators_role_or_identity_id_delete**](docs/DefaultApi.md#delete_project_collaborator_api_v2_projects_project_id_collaborators_role_or_identity_id_delete) | **DELETE** /api/v2/projects/{project_id}/collaborators/{role_or_identity_id} | Delete Project Collaborator
*DefaultApi* | [**delete_session_api_v2_sessions_session_id_delete**](docs/DefaultApi.md#delete_session_api_v2_sessions_session_id_delete) | **DELETE** /api/v2/sessions/{session_id} | Delete Session
*DefaultApi* | [**delete_web_terminals_api_v2_sessions_session_id_web_terminals_terminal_id_delete**](docs/DefaultApi.md#delete_web_terminals_api_v2_sessions_session_id_web_terminals_terminal_id_delete) | **DELETE** /api/v2/sessions/{session_id}/web_terminals/{terminal_id} | Delete Web Terminals
*DefaultApi* | [**delete_workspace_api_v2_experimental_workspaces_workspace_id_delete**](docs/DefaultApi.md#delete_workspace_api_v2_experimental_workspaces_workspace_id_delete) | **DELETE** /api/v2/experimental_workspaces/{workspace_id} | Delete Workspace
*DefaultApi* | [**deregister_autosync_session_api_v2_autosync_sessions_autosync_session_id_delete**](docs/DefaultApi.md#deregister_autosync_session_api_v2_autosync_sessions_autosync_session_id_delete) | **DELETE** /api/v2/autosync_sessions/{autosync_session_id} | Deregister Autosync Session
*DefaultApi* | [**describe_session_api_v2_sessions_session_id_describe_get**](docs/DefaultApi.md#describe_session_api_v2_sessions_session_id_describe_get) | **GET** /api/v2/sessions/{session_id}/describe | Describe Session
*DefaultApi* | [**detach_machine_pool_from_cloud_api_v2_machine_pools_detach_post**](docs/DefaultApi.md#detach_machine_pool_from_cloud_api_v2_machine_pools_detach_post) | **POST** /api/v2/machine_pools/detach | Detach Machine Pool From Cloud
*DefaultApi* | [**dismiss_user_card_api_v2_onboarding_cards_card_id_dismiss_post**](docs/DefaultApi.md#dismiss_user_card_api_v2_onboarding_cards_card_id_dismiss_post) | **POST** /api/v2/onboarding_cards/{card_id}/dismiss | Dismiss User Card
*DefaultApi* | [**echo_ip_api_v2_health_echo_ip_get**](docs/DefaultApi.md#echo_ip_api_v2_health_echo_ip_get) | **GET** /api/v2/health/echo_ip | Echo Ip
*DefaultApi* | [**edit_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_patch**](docs/DefaultApi.md#edit_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_patch) | **PATCH** /api/v2/clouds_with_cloud_resource_gcp_router/{cloud_id} | Edit Cloud Resource
*DefaultApi* | [**edit_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_patch**](docs/DefaultApi.md#edit_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_patch) | **PATCH** /api/v2/clouds_with_cloud_resource_router/{cloud_id} | Edit Cloud Resource
*DefaultApi* | [**execute_interactive_command_api_v2_sessions_session_id_execute_interactive_command_post**](docs/DefaultApi.md#execute_interactive_command_api_v2_sessions_session_id_execute_interactive_command_post) | **POST** /api/v2/sessions/{session_id}/execute_interactive_command | Execute Interactive Command
*DefaultApi* | [**execute_shell_command_api_v2_sessions_session_id_execute_shell_command_post**](docs/DefaultApi.md#execute_shell_command_api_v2_sessions_session_id_execute_shell_command_post) | **POST** /api/v2/sessions/{session_id}/execute_shell_command | Execute Shell Command
*DefaultApi* | [**find_cloud_by_name_api_v2_clouds_find_by_name_post**](docs/DefaultApi.md#find_cloud_by_name_api_v2_clouds_find_by_name_post) | **POST** /api/v2/clouds/find_by_name | Find Cloud By Name
*DefaultApi* | [**find_project_by_project_name_api_v2_projects_find_by_name_get**](docs/DefaultApi.md#find_project_by_project_name_api_v2_projects_find_by_name_get) | **GET** /api/v2/projects/find_by_name | Find Project By Project Name
*DefaultApi* | [**find_with_invitation_api_v2_organizations_find_with_invitation_get**](docs/DefaultApi.md#find_with_invitation_api_v2_organizations_find_with_invitation_get) | **GET** /api/v2/organizations/find_with_invitation | Find With Invitation
*DefaultApi* | [**find_with_public_identifier_api_v2_organizations_find_with_public_identifier_get**](docs/DefaultApi.md#find_with_public_identifier_api_v2_organizations_find_with_public_identifier_get) | **GET** /api/v2/organizations/find_with_public_identifier | Find With Public Identifier
*DefaultApi* | [**find_with_user_api_v2_organizations_find_with_user_get**](docs/DefaultApi.md#find_with_user_api_v2_organizations_find_with_user_get) | **GET** /api/v2/organizations/find_with_user | Find With User
*DefaultApi* | [**fine_tuning_job_callback_api_v2_fine_tuning_jobs_internal_finish_post**](docs/DefaultApi.md#fine_tuning_job_callback_api_v2_fine_tuning_jobs_internal_finish_post) | **POST** /api/v2/fine_tuning/jobs/internal/finish | Fine Tuning Job Callback
*DefaultApi* | [**fine_tuning_job_callback_v2_api_v2_fine_tuning_v2_jobs_internal_finish_post**](docs/DefaultApi.md#fine_tuning_job_callback_v2_api_v2_fine_tuning_v2_jobs_internal_finish_post) | **POST** /api/v2/fine_tuning_v2/jobs/internal/finish | Fine Tuning Job Callback V2
*DefaultApi* | [**finish_session_command_api_v2_session_commands_session_command_id_finish_post**](docs/DefaultApi.md#finish_session_command_api_v2_session_commands_session_command_id_finish_post) | **POST** /api/v2/session_commands/{session_command_id}/finish | Finish Session Command
*DefaultApi* | [**generate_cloud_data_bucket_presigned_upload_url_api_v2_clouds_cloud_id_generate_cloud_data_bucket_presigned_upload_url_post**](docs/DefaultApi.md#generate_cloud_data_bucket_presigned_upload_url_api_v2_clouds_cloud_id_generate_cloud_data_bucket_presigned_upload_url_post) | **POST** /api/v2/clouds/{cloud_id}/generate_cloud_data_bucket_presigned_upload_url | Generate Cloud Data Bucket Presigned Upload Url
*DefaultApi* | [**get_active_autosync_sessions_for_session_api_v2_autosync_sessions_get**](docs/DefaultApi.md#get_active_autosync_sessions_for_session_api_v2_autosync_sessions_get) | **GET** /api/v2/autosync_sessions/ | Get Active Autosync Sessions For Session
*DefaultApi* | [**get_active_billing_version_api_v2_organization_billing_active_billing_version_get**](docs/DefaultApi.md#get_active_billing_version_api_v2_organization_billing_active_billing_version_get) | **GET** /api/v2/organization_billing/active_billing_version | Get Active Billing Version
*DefaultApi* | [**get_anyscale_aws_account_api_v2_clouds_anyscale_aws_account_get**](docs/DefaultApi.md#get_anyscale_aws_account_api_v2_clouds_anyscale_aws_account_get) | **GET** /api/v2/clouds/anyscale/aws_account | Get Anyscale Aws Account
*DefaultApi* | [**get_anyscale_version_api_v2_userinfo_anyscale_version_get**](docs/DefaultApi.md#get_anyscale_version_api_v2_userinfo_anyscale_version_get) | **GET** /api/v2/userinfo/anyscale_version | Get Anyscale Version
*DefaultApi* | [**get_application_template_api_v2_application_templates_application_template_id_get**](docs/DefaultApi.md#get_application_template_api_v2_application_templates_application_template_id_get) | **GET** /api/v2/application_templates/{application_template_id} | Get Application Template
*DefaultApi* | [**get_billing_information_api_v2_organization_billing_billing_information_get**](docs/DefaultApi.md#get_billing_information_api_v2_organization_billing_billing_information_get) | **GET** /api/v2/organization_billing/billing_information | Get Billing Information
*DefaultApi* | [**get_billing_versions_by_organization_api_v2_organization_billing_billing_versions_get**](docs/DefaultApi.md#get_billing_versions_by_organization_api_v2_organization_billing_billing_versions_get) | **GET** /api/v2/organization_billing/billing_versions | Get Billing Versions By Organization
*DefaultApi* | [**get_build_api_v2_builds_build_id_get**](docs/DefaultApi.md#get_build_api_v2_builds_build_id_get) | **GET** /api/v2/builds/{build_id} | Get Build
*DefaultApi* | [**get_build_logs_api_v2_builds_build_id_logs_get**](docs/DefaultApi.md#get_build_logs_api_v2_builds_build_id_logs_get) | **GET** /api/v2/builds/{build_id}/logs | Get Build Logs
*DefaultApi* | [**get_cloud_api_v2_clouds_cloud_id_get**](docs/DefaultApi.md#get_cloud_api_v2_clouds_cloud_id_get) | **GET** /api/v2/clouds/{cloud_id} | Get Cloud
*DefaultApi* | [**get_cloud_project_collaborator_api_v2_projects_project_id_collaborators_clouds_get**](docs/DefaultApi.md#get_cloud_project_collaborator_api_v2_projects_project_id_collaborators_clouds_get) | **GET** /api/v2/projects/{project_id}/collaborators/clouds | Get Cloud Project Collaborator
*DefaultApi* | [**get_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_get**](docs/DefaultApi.md#get_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_get) | **GET** /api/v2/clouds_with_cloud_resource_gcp_router/{cloud_id} | Get Cloud With Cloud Resource
*DefaultApi* | [**get_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_get**](docs/DefaultApi.md#get_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_get) | **GET** /api/v2/clouds_with_cloud_resource_router/{cloud_id} | Get Cloud With Cloud Resource
*DefaultApi* | [**get_cluster_product_autoscaler_flag_api_v2_logs_cluster_product_autoscaler_flag_session_id_get**](docs/DefaultApi.md#get_cluster_product_autoscaler_flag_api_v2_logs_cluster_product_autoscaler_flag_session_id_get) | **GET** /api/v2/logs/cluster_product_autoscaler_flag/{session_id} | Get Cluster Product Autoscaler Flag
*DefaultApi* | [**get_compute_template_api_v2_compute_templates_template_id_get**](docs/DefaultApi.md#get_compute_template_api_v2_compute_templates_template_id_get) | **GET** /api/v2/compute_templates/{template_id} | Get Compute Template
*DefaultApi* | [**get_cron_job_api_v2_experimental_cron_jobs_cron_job_id_get**](docs/DefaultApi.md#get_cron_job_api_v2_experimental_cron_jobs_cron_job_id_get) | **GET** /api/v2/experimental_cron_jobs/{cron_job_id} | Get Cron Job
*DefaultApi* | [**get_decorated_cluster_api_v2_decorated_sessions_cluster_id_get**](docs/DefaultApi.md#get_decorated_cluster_api_v2_decorated_sessions_cluster_id_get) | **GET** /api/v2/decorated_sessions/{cluster_id} | Get Decorated Cluster
*DefaultApi* | [**get_decorated_interactive_session_api_v2_decorated_interactive_sessions_interactive_session_id_get**](docs/DefaultApi.md#get_decorated_interactive_session_api_v2_decorated_interactive_sessions_interactive_session_id_get) | **GET** /api/v2/decorated_interactive_sessions/{interactive_session_id} | Get Decorated Interactive Session
*DefaultApi* | [**get_decorated_interactive_session_logs_api_v2_decorated_interactive_sessions_interactive_session_id_logs_get**](docs/DefaultApi.md#get_decorated_interactive_session_logs_api_v2_decorated_interactive_sessions_interactive_session_id_logs_get) | **GET** /api/v2/decorated_interactive_sessions/{interactive_session_id}/logs | Get Decorated Interactive Session Logs
*DefaultApi* | [**get_decorated_job_api_v2_decorated_jobs_job_id_get**](docs/DefaultApi.md#get_decorated_job_api_v2_decorated_jobs_job_id_get) | **GET** /api/v2/decorated_jobs/{job_id} | Get Decorated Job
*DefaultApi* | [**get_decorated_job_logs_api_v2_decorated_jobs_job_id_logs_get**](docs/DefaultApi.md#get_decorated_job_logs_api_v2_decorated_jobs_job_id_logs_get) | **GET** /api/v2/decorated_jobs/{job_id}/logs | Get Decorated Job Logs
*DefaultApi* | [**get_decorated_job_submission_api_v2_decorated_job_submissions_ray_job_submission_db_id_get**](docs/DefaultApi.md#get_decorated_job_submission_api_v2_decorated_job_submissions_ray_job_submission_db_id_get) | **GET** /api/v2/decorated_job_submissions/{ray_job_submission_db_id} | Get Decorated Job Submission
*DefaultApi* | [**get_decorated_job_submission_logs_api_v2_decorated_job_submissions_ray_job_submission_db_id_logs_get**](docs/DefaultApi.md#get_decorated_job_submission_logs_api_v2_decorated_job_submissions_ray_job_submission_db_id_logs_get) | **GET** /api/v2/decorated_job_submissions/{ray_job_submission_db_id}/logs | Get Decorated Job Submission Logs
*DefaultApi* | [**get_decorated_runtime_env_api_v2_decorated_runtime_envs_runtime_env_id_get**](docs/DefaultApi.md#get_decorated_runtime_env_api_v2_decorated_runtime_envs_runtime_env_id_get) | **GET** /api/v2/decorated_runtime_envs/{runtime_env_id} | Get Decorated Runtime Env
*DefaultApi* | [**get_decorated_serve_deployment_api_v2_decorated_serve_deployments_serve_deloyment_id_get**](docs/DefaultApi.md#get_decorated_serve_deployment_api_v2_decorated_serve_deployments_serve_deloyment_id_get) | **GET** /api/v2/decorated_serve_deployments/{serve_deloyment_id} | Get Decorated Serve Deployment
*DefaultApi* | [**get_decorated_serve_deployment_logs_api_v2_decorated_serve_deployments_serve_deployment_id_logs_get**](docs/DefaultApi.md#get_decorated_serve_deployment_logs_api_v2_decorated_serve_deployments_serve_deployment_id_logs_get) | **GET** /api/v2/decorated_serve_deployments/{serve_deployment_id}/logs | Get Decorated Serve Deployment Logs
*DefaultApi* | [**get_decorated_support_request_for_user_organization_api_v2_support_requests_get**](docs/DefaultApi.md#get_decorated_support_request_for_user_organization_api_v2_support_requests_get) | **GET** /api/v2/support_requests/ | Get Decorated Support Request For User Organization
*DefaultApi* | [**get_default_cluster_env_build_api_v2_builds_default_py_version_ray_version_get**](docs/DefaultApi.md#get_default_cluster_env_build_api_v2_builds_default_py_version_ray_version_get) | **GET** /api/v2/builds/default/{py_version}/{ray_version} | Get Default Cluster Env Build
*DefaultApi* | [**get_default_compute_config_api_v2_compute_templates_default_cloud_id_get**](docs/DefaultApi.md#get_default_compute_config_api_v2_compute_templates_default_cloud_id_get) | **GET** /api/v2/compute_templates/default/{cloud_id} | Get Default Compute Config
*DefaultApi* | [**get_default_project_api_v2_projects_default_project_get**](docs/DefaultApi.md#get_default_project_api_v2_projects_default_project_get) | **GET** /api/v2/projects/default_project | Get Default Project
*DefaultApi* | [**get_edit_payment_information_url_api_v2_organization_billing_edit_payment_information_url_get**](docs/DefaultApi.md#get_edit_payment_information_url_api_v2_organization_billing_edit_payment_information_url_get) | **GET** /api/v2/organization_billing/edit_payment_information_url | Get Edit Payment Information Url
*DefaultApi* | [**get_endpoint_api_v2_aica_endpoints_endpoint_id_get**](docs/DefaultApi.md#get_endpoint_api_v2_aica_endpoints_endpoint_id_get) | **GET** /api/v2/aica_endpoints/{endpoint_id} | Get Endpoint
*DefaultApi* | [**get_events_api_v2_sessions_session_id_events_get**](docs/DefaultApi.md#get_events_api_v2_sessions_session_id_events_get) | **GET** /api/v2/sessions/{session_id}/events | Get Events
*DefaultApi* | [**get_execution_logs_api_v2_session_commands_session_command_id_execution_logs_get**](docs/DefaultApi.md#get_execution_logs_api_v2_session_commands_session_command_id_execution_logs_get) | **GET** /api/v2/session_commands/{session_command_id}/execution_logs | Get Execution Logs
*DefaultApi* | [**get_execution_logs_archived_api_v2_session_commands_session_command_id_execution_logs_archived_get**](docs/DefaultApi.md#get_execution_logs_archived_api_v2_session_commands_session_command_id_execution_logs_archived_get) | **GET** /api/v2/session_commands/{session_command_id}/execution_logs_archived | Get Execution Logs Archived
*DefaultApi* | [**get_feature_compatibility_api_v2_product_features_get**](docs/DefaultApi.md#get_feature_compatibility_api_v2_product_features_get) | **GET** /api/v2/product_features/ | Get Feature Compatibility
*DefaultApi* | [**get_file_api_v2_files_file_id_get**](docs/DefaultApi.md#get_file_api_v2_files_file_id_get) | **GET** /api/v2/files/{file_id} | Get File
*DefaultApi* | [**get_file_upload_url_api_v2_files_upload_url_post**](docs/DefaultApi.md#get_file_upload_url_api_v2_files_upload_url_post) | **POST** /api/v2/files/upload_url | Get File Upload Url
*DefaultApi* | [**get_fine_tuning_job_api_v2_fine_tuning_jobs_fine_tuning_job_id_get**](docs/DefaultApi.md#get_fine_tuning_job_api_v2_fine_tuning_jobs_fine_tuning_job_id_get) | **GET** /api/v2/fine_tuning/jobs/{fine_tuning_job_id} | Get Fine Tuning Job
*DefaultApi* | [**get_invitation_api_v2_organization_invitations_invitation_id_get**](docs/DefaultApi.md#get_invitation_api_v2_organization_invitations_invitation_id_get) | **GET** /api/v2/organization_invitations/{invitation_id} | Get Invitation
*DefaultApi* | [**get_job_api_v2_decorated_ha_jobs_production_job_id_get**](docs/DefaultApi.md#get_job_api_v2_decorated_ha_jobs_production_job_id_get) | **GET** /api/v2/decorated_ha_jobs/{production_job_id} | Get Job
*DefaultApi* | [**get_job_api_v2_decorated_unified_jobs_job_id_get**](docs/DefaultApi.md#get_job_api_v2_decorated_unified_jobs_job_id_get) | **GET** /api/v2/decorated_unified_jobs/{job_id} | Get Job
*DefaultApi* | [**get_job_logs_download_api_v2_logs_job_logs_download_job_id_get**](docs/DefaultApi.md#get_job_logs_download_api_v2_logs_job_logs_download_job_id_get) | **GET** /api/v2/logs/job_logs_download/{job_id} | Get Job Logs Download
*DefaultApi* | [**get_job_logs_download_v2_api_v2_logs_job_logs_download_v2_job_id_get**](docs/DefaultApi.md#get_job_logs_download_v2_api_v2_logs_job_logs_download_v2_job_id_get) | **GET** /api/v2/logs/job_logs_download_v2/{job_id} | Get Job Logs Download V2
*DefaultApi* | [**get_job_logs_query_info_api_v2_decorated_ha_jobs_production_job_id_logs_query_get**](docs/DefaultApi.md#get_job_logs_query_info_api_v2_decorated_ha_jobs_production_job_id_logs_query_get) | **GET** /api/v2/decorated_ha_jobs/{production_job_id}/logs_query | Get Job Logs Query Info
*DefaultApi* | [**get_job_logs_stream_api_v2_logs_job_logs_stream_job_id_get**](docs/DefaultApi.md#get_job_logs_stream_api_v2_logs_job_logs_stream_job_id_get) | **GET** /api/v2/logs/job_logs_stream/{job_id} | Get Job Logs Stream
*DefaultApi* | [**get_lb_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_get_lb_resource_post**](docs/DefaultApi.md#get_lb_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_get_lb_resource_post) | **POST** /api/v2/clouds_with_cloud_resource_gcp_router/{cloud_id}/get_lb_resource | Get Lb Resource
*DefaultApi* | [**get_log_files_api_v2_logs_get_log_files_post**](docs/DefaultApi.md#get_log_files_api_v2_logs_get_log_files_post) | **POST** /api/v2/logs/get_log_files | Get Log Files
*DefaultApi* | [**get_log_files_api_v2_sessions_session_id_get_log_files_post**](docs/DefaultApi.md#get_log_files_api_v2_sessions_session_id_get_log_files_post) | **POST** /api/v2/sessions/{session_id}/get_log_files | Get Log Files
*DefaultApi* | [**get_manage_billing_url_api_v2_organization_billing_manage_billing_url_get**](docs/DefaultApi.md#get_manage_billing_url_api_v2_organization_billing_manage_billing_url_get) | **GET** /api/v2/organization_billing/manage_billing_url | Get Manage Billing Url
*DefaultApi* | [**get_metronome_embedded_usage_dashboard_api_v2_organization_billing_metronome_embedded_dashboard_url_dashboard_type_get**](docs/DefaultApi.md#get_metronome_embedded_usage_dashboard_api_v2_organization_billing_metronome_embedded_dashboard_url_dashboard_type_get) | **GET** /api/v2/organization_billing/metronome_embedded_dashboard_url/{dashboard_type} | Get Metronome Embedded Usage Dashboard
*DefaultApi* | [**get_model_configuration_api_v2_aica_endpoints_model_config_get**](docs/DefaultApi.md#get_model_configuration_api_v2_aica_endpoints_model_config_get) | **GET** /api/v2/aica_endpoints/model_config | Get Model Configuration
*DefaultApi* | [**get_model_schema_api_v2_aica_endpoints_model_schema_get**](docs/DefaultApi.md#get_model_schema_api_v2_aica_endpoints_model_schema_get) | **GET** /api/v2/aica_endpoints/model_schema | Get Model Schema
*DefaultApi* | [**get_monitor_logs_api_v2_sessions_session_id_monitor_logs_get**](docs/DefaultApi.md#get_monitor_logs_api_v2_sessions_session_id_monitor_logs_get) | **GET** /api/v2/sessions/{session_id}/monitor_logs | Get Monitor Logs
*DefaultApi* | [**get_monitor_logs_archived_api_v2_sessions_session_id_monitor_logs_archived_get**](docs/DefaultApi.md#get_monitor_logs_archived_api_v2_sessions_session_id_monitor_logs_archived_get) | **GET** /api/v2/sessions/{session_id}/monitor_logs_archived | Get Monitor Logs Archived
*DefaultApi* | [**get_monitor_logs_download_api_v2_logs_monitor_logs_download_session_id_get**](docs/DefaultApi.md#get_monitor_logs_download_api_v2_logs_monitor_logs_download_session_id_get) | **GET** /api/v2/logs/monitor_logs_download/{session_id} | Get Monitor Logs Download
*DefaultApi* | [**get_monitor_logs_stream_api_v2_logs_monitor_logs_stream_session_id_get**](docs/DefaultApi.md#get_monitor_logs_stream_api_v2_logs_monitor_logs_stream_session_id_get) | **GET** /api/v2/logs/monitor_logs_stream/{session_id} | Get Monitor Logs Stream
*DefaultApi* | [**get_organization_metronome_usage_alerts_api_v2_organization_billing_alerts_get**](docs/DefaultApi.md#get_organization_metronome_usage_alerts_api_v2_organization_billing_alerts_get) | **GET** /api/v2/organization_billing/alerts | Get Organization Metronome Usage Alerts
*DefaultApi* | [**get_ping_external_services_api_v2_sessions_session_id_ping_external_services_get**](docs/DefaultApi.md#get_ping_external_services_api_v2_sessions_session_id_ping_external_services_get) | **GET** /api/v2/sessions/{session_id}/ping_external_services | Get Ping External Services
*DefaultApi* | [**get_project_api_v2_projects_project_id_get**](docs/DefaultApi.md#get_project_api_v2_projects_project_id_get) | **GET** /api/v2/projects/{project_id} | Get Project
*DefaultApi* | [**get_project_default_session_name_api_v2_projects_project_id_default_session_name_get**](docs/DefaultApi.md#get_project_default_session_name_api_v2_projects_project_id_default_session_name_get) | **GET** /api/v2/projects/{project_id}/default_session_name | Get Project Default Session Name
*DefaultApi* | [**get_project_latest_cluster_config_api_v2_projects_project_id_latest_cluster_config_get**](docs/DefaultApi.md#get_project_latest_cluster_config_api_v2_projects_project_id_latest_cluster_config_get) | **GET** /api/v2/projects/{project_id}/latest_cluster_config | Get Project Latest Cluster Config
*DefaultApi* | [**get_provider_metadata_api_v2_clouds_provider_metadata_cloud_id_get**](docs/DefaultApi.md#get_provider_metadata_api_v2_clouds_provider_metadata_cloud_id_get) | **GET** /api/v2/clouds/provider_metadata/{cloud_id} | Get Provider Metadata
*DefaultApi* | [**get_public_identifier_api_v2_organizations_public_identifier_get**](docs/DefaultApi.md#get_public_identifier_api_v2_organizations_public_identifier_get) | **GET** /api/v2/organizations/public_identifier | Get Public Identifier
*DefaultApi* | [**get_ray_result_files_api_v2_sessions_session_id_get_ray_result_files_get**](docs/DefaultApi.md#get_ray_result_files_api_v2_sessions_session_id_get_ray_result_files_get) | **GET** /api/v2/sessions/{session_id}/get_ray_result_files | Get Ray Result Files
*DefaultApi* | [**get_recent_cluster_compute_configs_api_v2_recent_activity_cluster_compute_configs_get**](docs/DefaultApi.md#get_recent_cluster_compute_configs_api_v2_recent_activity_cluster_compute_configs_get) | **GET** /api/v2/recent_activity/cluster_compute_configs | Get Recent Cluster Compute Configs
*DefaultApi* | [**get_recent_cluster_environments_api_v2_recent_activity_cluster_environment_builds_get**](docs/DefaultApi.md#get_recent_cluster_environments_api_v2_recent_activity_cluster_environment_builds_get) | **GET** /api/v2/recent_activity/cluster_environment_builds | Get Recent Cluster Environments
*DefaultApi* | [**get_recent_projects_api_v2_recent_activity_projects_get**](docs/DefaultApi.md#get_recent_projects_api_v2_recent_activity_projects_get) | **GET** /api/v2/recent_activity/projects | Get Recent Projects
*DefaultApi* | [**get_regions_and_zones_api_v2_aws_info_regions_and_zones_get**](docs/DefaultApi.md#get_regions_and_zones_api_v2_aws_info_regions_and_zones_get) | **GET** /api/v2/aws_info/regions_and_zones | Get Regions And Zones
*DefaultApi* | [**get_regions_and_zones_api_v2_clouds_gcp_regions_and_zones_get**](docs/DefaultApi.md#get_regions_and_zones_api_v2_clouds_gcp_regions_and_zones_get) | **GET** /api/v2/clouds/gcp/regions_and_zones | Get Regions And Zones
*DefaultApi* | [**get_runtime_env_logs_api_v2_sessions_session_id_runtime_env_logs_get**](docs/DefaultApi.md#get_runtime_env_logs_api_v2_sessions_session_id_runtime_env_logs_get) | **GET** /api/v2/sessions/{session_id}/runtime_env_logs | Get Runtime Env Logs
*DefaultApi* | [**get_runtime_env_logs_download_api_v2_logs_runtime_env_logs_download_session_id_get**](docs/DefaultApi.md#get_runtime_env_logs_download_api_v2_logs_runtime_env_logs_download_session_id_get) | **GET** /api/v2/logs/runtime_env_logs_download/{session_id} | Get Runtime Env Logs Download
*DefaultApi* | [**get_runtime_env_logs_stream_api_v2_logs_runtime_env_logs_stream_session_id_get**](docs/DefaultApi.md#get_runtime_env_logs_stream_api_v2_logs_runtime_env_logs_stream_session_id_get) | **GET** /api/v2/logs/runtime_env_logs_stream/{session_id} | Get Runtime Env Logs Stream
*DefaultApi* | [**get_serve_logs_download_api_v2_logs_serve_logs_download_cluster_id_get**](docs/DefaultApi.md#get_serve_logs_download_api_v2_logs_serve_logs_download_cluster_id_get) | **GET** /api/v2/logs/serve_logs_download/{cluster_id} | Get Serve Logs Download
*DefaultApi* | [**get_service_api_v2_services_v2_service_id_get**](docs/DefaultApi.md#get_service_api_v2_services_v2_service_id_get) | **GET** /api/v2/services-v2/{service_id} | Get Service
*DefaultApi* | [**get_service_event_verbose_message_api_v2_services_v2_events_event_id_verbose_message_get**](docs/DefaultApi.md#get_service_event_verbose_message_api_v2_services_v2_events_event_id_verbose_message_get) | **GET** /api/v2/services-v2/events/{event_id}/verbose_message | Get Service Event Verbose Message
*DefaultApi* | [**get_service_events_api_v2_services_v2_service_id_events_get**](docs/DefaultApi.md#get_service_events_api_v2_services_v2_service_id_events_get) | **GET** /api/v2/services-v2/{service_id}/events | Get Service Events
*DefaultApi* | [**get_service_versions_api_v2_services_v2_service_id_versions_get**](docs/DefaultApi.md#get_service_versions_api_v2_services_v2_service_id_versions_get) | **GET** /api/v2/services-v2/{service_id}/versions | Get Service Versions
*DefaultApi* | [**get_session_api_v2_sessions_session_id_get**](docs/DefaultApi.md#get_session_api_v2_sessions_session_id_get) | **GET** /api/v2/sessions/{session_id} | Get Session
*DefaultApi* | [**get_session_autoscaler_credentials_api_v2_sessions_session_id_autoscaler_credentials_get**](docs/DefaultApi.md#get_session_autoscaler_credentials_api_v2_sessions_session_id_autoscaler_credentials_get) | **GET** /api/v2/sessions/{session_id}/autoscaler_credentials | Get Session Autoscaler Credentials
*DefaultApi* | [**get_session_cluster_config_api_v2_sessions_session_id_cluster_config_get**](docs/DefaultApi.md#get_session_cluster_config_api_v2_sessions_session_id_cluster_config_get) | **GET** /api/v2/sessions/{session_id}/cluster_config | Get Session Cluster Config
*DefaultApi* | [**get_session_cluster_config_with_session_idle_timeout_api_v2_sessions_session_id_cluster_config_with_session_idle_timeout_get**](docs/DefaultApi.md#get_session_cluster_config_with_session_idle_timeout_api_v2_sessions_session_id_cluster_config_with_session_idle_timeout_get) | **GET** /api/v2/sessions/{session_id}/cluster_config_with_session_idle_timeout | Get Session Cluster Config With Session Idle Timeout
*DefaultApi* | [**get_session_command_logs_download_api_v2_logs_session_command_logs_session_id_session_command_id_get**](docs/DefaultApi.md#get_session_command_logs_download_api_v2_logs_session_command_logs_session_id_session_command_id_get) | **GET** /api/v2/logs/session_command_logs/{session_id}/{session_command_id} | Get Session Command Logs Download
*DefaultApi* | [**get_session_commands_history_api_v2_session_commands_get**](docs/DefaultApi.md#get_session_commands_history_api_v2_session_commands_get) | **GET** /api/v2/session_commands/ | Get Session Commands History
*DefaultApi* | [**get_session_details_api_v2_sessions_session_id_details_get**](docs/DefaultApi.md#get_session_details_api_v2_sessions_session_id_details_get) | **GET** /api/v2/sessions/{session_id}/details | Get Session Details
*DefaultApi* | [**get_session_event_log_api_v2_session_events_get**](docs/DefaultApi.md#get_session_event_log_api_v2_session_events_get) | **GET** /api/v2/session_events/ | Get Session Event Log
*DefaultApi* | [**get_session_head_ip_api_v2_sessions_session_id_head_ip_get**](docs/DefaultApi.md#get_session_head_ip_api_v2_sessions_session_id_head_ip_get) | **GET** /api/v2/sessions/{session_id}/head_ip | Get Session Head Ip
*DefaultApi* | [**get_session_history_api_v2_sessions_session_id_history_get**](docs/DefaultApi.md#get_session_history_api_v2_sessions_session_id_history_get) | **GET** /api/v2/sessions/{session_id}/history | Get Session History
*DefaultApi* | [**get_session_ssh_key_api_v2_sessions_session_id_ssh_key_get**](docs/DefaultApi.md#get_session_ssh_key_api_v2_sessions_session_id_ssh_key_get) | **GET** /api/v2/sessions/{session_id}/ssh_key | Get Session Ssh Key
*DefaultApi* | [**get_socket_message_types_api_v2_userinfo_socket_messages_type_get**](docs/DefaultApi.md#get_socket_message_types_api_v2_userinfo_socket_messages_type_get) | **GET** /api/v2/userinfo/socket_messages_type | Get Socket Message Types
*DefaultApi* | [**get_socket_types_type_api_v2_userinfo_socket_types_type_get**](docs/DefaultApi.md#get_socket_types_type_api_v2_userinfo_socket_types_type_get) | **GET** /api/v2/userinfo/socket_types_type | Get Socket Types Type
*DefaultApi* | [**get_startup_logs_api_v2_sessions_session_id_startup_logs_get**](docs/DefaultApi.md#get_startup_logs_api_v2_sessions_session_id_startup_logs_get) | **GET** /api/v2/sessions/{session_id}/startup_logs | Get Startup Logs
*DefaultApi* | [**get_startup_logs_archived_api_v2_sessions_session_id_startup_logs_archived_get**](docs/DefaultApi.md#get_startup_logs_archived_api_v2_sessions_session_id_startup_logs_archived_get) | **GET** /api/v2/sessions/{session_id}/startup_logs_archived | Get Startup Logs Archived
*DefaultApi* | [**get_template_readme_api_v2_experimental_workspaces_template_readme_template_id_get**](docs/DefaultApi.md#get_template_readme_api_v2_experimental_workspaces_template_readme_template_id_get) | **GET** /api/v2/experimental_workspaces/template/readme/{template_id} | Get Template Readme
*DefaultApi* | [**get_templatized_cluster_environments_api_v2_application_templates_templatized_get**](docs/DefaultApi.md#get_templatized_cluster_environments_api_v2_application_templates_templatized_get) | **GET** /api/v2/application_templates/templatized/ | Get Templatized Cluster Environments
*DefaultApi* | [**get_templatized_compute_configs_api_v2_compute_templates_templatized_cloud_id_get**](docs/DefaultApi.md#get_templatized_compute_configs_api_v2_compute_templates_templatized_cloud_id_get) | **GET** /api/v2/compute_templates/templatized/{cloud_id} | Get Templatized Compute Configs
*DefaultApi* | [**get_user_info_api_v2_userinfo_get**](docs/DefaultApi.md#get_user_info_api_v2_userinfo_get) | **GET** /api/v2/userinfo/ | Get User Info
*DefaultApi* | [**get_workspace_api_v2_experimental_workspaces_workspace_id_get**](docs/DefaultApi.md#get_workspace_api_v2_experimental_workspaces_workspace_id_get) | **GET** /api/v2/experimental_workspaces/{workspace_id} | Get Workspace
*DefaultApi* | [**get_workspace_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_dataplane_artifacts_get**](docs/DefaultApi.md#get_workspace_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_dataplane_artifacts_get) | **GET** /api/v2/experimental_workspaces/{workspace_id}/dataplane_artifacts | Get Workspace Dataplane Artifacts
*DefaultApi* | [**get_workspace_events_api_v2_experimental_workspaces_workspace_id_events_get**](docs/DefaultApi.md#get_workspace_events_api_v2_experimental_workspaces_workspace_id_events_get) | **GET** /api/v2/experimental_workspaces/{workspace_id}/events | Get Workspace Events
*DefaultApi* | [**get_workspace_proxied_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_proxied_dataplane_artifacts_get**](docs/DefaultApi.md#get_workspace_proxied_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_proxied_dataplane_artifacts_get) | **GET** /api/v2/experimental_workspaces/{workspace_id}/proxied_dataplane_artifacts | Get Workspace Proxied Dataplane Artifacts
*DefaultApi* | [**get_workspace_readme_api_v2_experimental_workspaces_workspace_id_readme_get**](docs/DefaultApi.md#get_workspace_readme_api_v2_experimental_workspaces_workspace_id_readme_get) | **GET** /api/v2/experimental_workspaces/{workspace_id}/readme | Get Workspace Readme
*DefaultApi* | [**get_workspace_template_cluster_environment_api_v2_experimental_workspaces_template_template_id_cluster_environment_get**](docs/DefaultApi.md#get_workspace_template_cluster_environment_api_v2_experimental_workspaces_template_template_id_cluster_environment_get) | **GET** /api/v2/experimental_workspaces/template/{template_id}/cluster_environment | Get Workspace Template Cluster Environment
*DefaultApi* | [**get_workspace_template_compute_config_api_v2_experimental_workspaces_template_template_id_compute_config_get**](docs/DefaultApi.md#get_workspace_template_compute_config_api_v2_experimental_workspaces_template_template_id_compute_config_get) | **GET** /api/v2/experimental_workspaces/template/{template_id}/compute_config | Get Workspace Template Compute Config
*DefaultApi* | [**handle_cloud_metrics_auth_api_v2_authentication_cloud_id_cloud_persistent_metrics_get**](docs/DefaultApi.md#handle_cloud_metrics_auth_api_v2_authentication_cloud_id_cloud_persistent_metrics_get) | **GET** /api/v2/authentication/{cloud_id}/cloud_persistent_metrics | Handle Cloud Metrics Auth
*DefaultApi* | [**handle_cluster_auth_api_v2_authentication_cluster_id_cluster_get**](docs/DefaultApi.md#handle_cluster_auth_api_v2_authentication_cluster_id_cluster_get) | **GET** /api/v2/authentication/{cluster_id}/cluster | Handle Cluster Auth
*DefaultApi* | [**handle_webhook_api_v2_metronome_webhooks_handle_webhook_post**](docs/DefaultApi.md#handle_webhook_api_v2_metronome_webhooks_handle_webhook_post) | **POST** /api/v2/metronome_webhooks/handle_webhook | Handle Webhook
*DefaultApi* | [**health_check_api_v2_health_get**](docs/DefaultApi.md#health_check_api_v2_health_get) | **GET** /api/v2/health/ | Health Check
*DefaultApi* | [**heartbeat_api_v2_autosync_sessions_autosync_session_id_heartbeat_post**](docs/DefaultApi.md#heartbeat_api_v2_autosync_sessions_autosync_session_id_heartbeat_post) | **POST** /api/v2/autosync_sessions/{autosync_session_id}/heartbeat | Heartbeat
*DefaultApi* | [**import_model_api_v2_aica_endpoints_import_model_post**](docs/DefaultApi.md#import_model_api_v2_aica_endpoints_import_model_post) | **POST** /api/v2/aica_endpoints/import_model | Import Model
*DefaultApi* | [**invalidate_invitation_api_v2_organization_invitations_invitation_id_invalidate_post**](docs/DefaultApi.md#invalidate_invitation_api_v2_organization_invitations_invitation_id_invalidate_post) | **POST** /api/v2/organization_invitations/{invitation_id}/invalidate | Invalidate Invitation
*DefaultApi* | [**is_valid_api_v2_authentication_hex_token_id_is_valid_post**](docs/DefaultApi.md#is_valid_api_v2_authentication_hex_token_id_is_valid_post) | **POST** /api/v2/authentication/{hex_token_id}/is_valid | Is Valid
*DefaultApi* | [**kill_session_command_api_v2_session_commands_session_command_id_kill_post**](docs/DefaultApi.md#kill_session_command_api_v2_session_commands_session_command_id_kill_post) | **POST** /api/v2/session_commands/{session_command_id}/kill | Kill Session Command
*DefaultApi* | [**list_aica_endpoint_events_api_v2_aica_endpoints_endpoint_id_events_get**](docs/DefaultApi.md#list_aica_endpoint_events_api_v2_aica_endpoints_endpoint_id_events_get) | **GET** /api/v2/aica_endpoints/{endpoint_id}/events | List Aica Endpoint Events
*DefaultApi* | [**list_aica_endpoints_api_v2_aica_endpoints_get**](docs/DefaultApi.md#list_aica_endpoints_api_v2_aica_endpoints_get) | **GET** /api/v2/aica_endpoints/ | List Aica Endpoints
*DefaultApi* | [**list_application_templates_api_v2_application_templates_get**](docs/DefaultApi.md#list_application_templates_api_v2_application_templates_get) | **GET** /api/v2/application_templates/ | List Application Templates
*DefaultApi* | [**list_builds_api_v2_builds_get**](docs/DefaultApi.md#list_builds_api_v2_builds_get) | **GET** /api/v2/builds/ | List Builds
*DefaultApi* | [**list_clouds_api_v2_clouds_get**](docs/DefaultApi.md#list_clouds_api_v2_clouds_get) | **GET** /api/v2/clouds/ | List Clouds
*DefaultApi* | [**list_cron_jobs_api_v2_experimental_cron_jobs_get**](docs/DefaultApi.md#list_cron_jobs_api_v2_experimental_cron_jobs_get) | **GET** /api/v2/experimental_cron_jobs/ | List Cron Jobs
*DefaultApi* | [**list_decorated_clusters_api_v2_decorated_sessions_get**](docs/DefaultApi.md#list_decorated_clusters_api_v2_decorated_sessions_get) | **GET** /api/v2/decorated_sessions/ | List Decorated Clusters
*DefaultApi* | [**list_decorated_interactive_sessions_api_v2_decorated_interactive_sessions_get**](docs/DefaultApi.md#list_decorated_interactive_sessions_api_v2_decorated_interactive_sessions_get) | **GET** /api/v2/decorated_interactive_sessions/ | List Decorated Interactive Sessions
*DefaultApi* | [**list_decorated_job_submissions_api_v2_decorated_job_submissions_get**](docs/DefaultApi.md#list_decorated_job_submissions_api_v2_decorated_job_submissions_get) | **GET** /api/v2/decorated_job_submissions/ | List Decorated Job Submissions
*DefaultApi* | [**list_decorated_jobs_api_v2_decorated_ha_jobs_get**](docs/DefaultApi.md#list_decorated_jobs_api_v2_decorated_ha_jobs_get) | **GET** /api/v2/decorated_ha_jobs/ | List Decorated Jobs
*DefaultApi* | [**list_decorated_jobs_api_v2_decorated_jobs_get**](docs/DefaultApi.md#list_decorated_jobs_api_v2_decorated_jobs_get) | **GET** /api/v2/decorated_jobs/ | List Decorated Jobs
*DefaultApi* | [**list_decorated_runtime_envs_api_v2_decorated_runtime_envs_get**](docs/DefaultApi.md#list_decorated_runtime_envs_api_v2_decorated_runtime_envs_get) | **GET** /api/v2/decorated_runtime_envs/ | List Decorated Runtime Envs
*DefaultApi* | [**list_decorated_serve_deployments_api_v2_decorated_serve_deployments_get**](docs/DefaultApi.md#list_decorated_serve_deployments_api_v2_decorated_serve_deployments_get) | **GET** /api/v2/decorated_serve_deployments/ | List Decorated Serve Deployments
*DefaultApi* | [**list_fine_tuning_jobs_api_v2_fine_tuning_jobs_get**](docs/DefaultApi.md#list_fine_tuning_jobs_api_v2_fine_tuning_jobs_get) | **GET** /api/v2/fine_tuning/jobs | List Fine Tuning Jobs
*DefaultApi* | [**list_invitations_api_v2_organization_invitations_get**](docs/DefaultApi.md#list_invitations_api_v2_organization_invitations_get) | **GET** /api/v2/organization_invitations/ | List Invitations
*DefaultApi* | [**list_job_states_api_v2_decorated_ha_job_states_get**](docs/DefaultApi.md#list_job_states_api_v2_decorated_ha_job_states_get) | **GET** /api/v2/decorated_ha_job_states/ | List Job States
*DefaultApi* | [**list_jobs_api_v2_decorated_unified_jobs_get**](docs/DefaultApi.md#list_jobs_api_v2_decorated_unified_jobs_get) | **GET** /api/v2/decorated_unified_jobs/ | List Jobs
*DefaultApi* | [**list_machine_pools_api_v2_machine_pools_get**](docs/DefaultApi.md#list_machine_pools_api_v2_machine_pools_get) | **GET** /api/v2/machine_pools/ | List Machine Pools
*DefaultApi* | [**list_machines_api_v2_machines_get**](docs/DefaultApi.md#list_machines_api_v2_machines_get) | **GET** /api/v2/machines/ | List Machines
*DefaultApi* | [**list_models_api_v2_aica_endpoints_models_get**](docs/DefaultApi.md#list_models_api_v2_aica_endpoints_models_get) | **GET** /api/v2/aica_endpoints/models | List Models
*DefaultApi* | [**list_organization_collaborators_api_v2_organization_collaborators_get**](docs/DefaultApi.md#list_organization_collaborators_api_v2_organization_collaborators_get) | **GET** /api/v2/organization_collaborators/ | List Organization Collaborators
*DefaultApi* | [**list_organization_project_collaborators_api_v2_projects_project_id_collaborators_organizations_get**](docs/DefaultApi.md#list_organization_project_collaborators_api_v2_projects_project_id_collaborators_organizations_get) | **GET** /api/v2/projects/{project_id}/collaborators/organizations | List Organization Project Collaborators
*DefaultApi* | [**list_project_collaborators_api_v2_projects_project_id_collaborators_users_get**](docs/DefaultApi.md#list_project_collaborators_api_v2_projects_project_id_collaborators_users_get) | **GET** /api/v2/projects/{project_id}/collaborators/users | List Project Collaborators
*DefaultApi* | [**list_projects_api_v2_projects_get**](docs/DefaultApi.md#list_projects_api_v2_projects_get) | **GET** /api/v2/projects/ | List Projects
*DefaultApi* | [**list_services_api_v2_services_v2_get**](docs/DefaultApi.md#list_services_api_v2_services_v2_get) | **GET** /api/v2/services-v2/ | List Services
*DefaultApi* | [**list_sessions_api_v2_sessions_get**](docs/DefaultApi.md#list_sessions_api_v2_sessions_get) | **GET** /api/v2/sessions/ | List Sessions
*DefaultApi* | [**list_versions_api_v2_aica_endpoints_versions_get**](docs/DefaultApi.md#list_versions_api_v2_aica_endpoints_versions_get) | **GET** /api/v2/aica_endpoints/versions | List Versions
*DefaultApi* | [**list_web_terminals_api_v2_sessions_session_id_web_terminals_get**](docs/DefaultApi.md#list_web_terminals_api_v2_sessions_session_id_web_terminals_get) | **GET** /api/v2/sessions/{session_id}/web_terminals | List Web Terminals
*DefaultApi* | [**list_workspace_templates_api_v2_experimental_workspaces_templates_get**](docs/DefaultApi.md#list_workspace_templates_api_v2_experimental_workspaces_templates_get) | **GET** /api/v2/experimental_workspaces/templates | List Workspace Templates
*DefaultApi* | [**list_workspaces_api_v2_experimental_workspaces_get**](docs/DefaultApi.md#list_workspaces_api_v2_experimental_workspaces_get) | **GET** /api/v2/experimental_workspaces/ | List Workspaces
*DefaultApi* | [**login_user_api_v2_users_login_post**](docs/DefaultApi.md#login_user_api_v2_users_login_post) | **POST** /api/v2/users/login | Login User
*DefaultApi* | [**logout_user_api_v2_users_logout_post**](docs/DefaultApi.md#logout_user_api_v2_users_logout_post) | **POST** /api/v2/users/logout | Logout User
*DefaultApi* | [**model_s3_mirror_credentials_api_v2_aica_endpoints_model_s3_credentials_post**](docs/DefaultApi.md#model_s3_mirror_credentials_api_v2_aica_endpoints_model_s3_credentials_post) | **POST** /api/v2/aica_endpoints/model_s3_credentials | Model S3 Mirror Credentials
*DefaultApi* | [**organization_valid_for_migration_api_v2_access_controls_migration_organization_id_organization_valid_for_migration_get**](docs/DefaultApi.md#organization_valid_for_migration_api_v2_access_controls_migration_organization_id_organization_valid_for_migration_get) | **GET** /api/v2/access_controls_migration/{organization_id}/organization_valid_for_migration | Organization Valid For Migration
*DefaultApi* | [**patch_project_api_v2_projects_project_id_patch**](docs/DefaultApi.md#patch_project_api_v2_projects_project_id_patch) | **PATCH** /api/v2/projects/{project_id} | Patch Project
*DefaultApi* | [**patch_session_api_v2_sessions_session_id_patch**](docs/DefaultApi.md#patch_session_api_v2_sessions_session_id_patch) | **PATCH** /api/v2/sessions/{session_id} | Patch Session
*DefaultApi* | [**patch_workspace_api_v2_experimental_workspaces_workspace_id_patch**](docs/DefaultApi.md#patch_workspace_api_v2_experimental_workspaces_workspace_id_patch) | **PATCH** /api/v2/experimental_workspaces/{workspace_id} | Patch Workspace
*DefaultApi* | [**pause_cron_job_api_v2_experimental_cron_jobs_cron_job_id_pause_post**](docs/DefaultApi.md#pause_cron_job_api_v2_experimental_cron_jobs_cron_job_id_pause_post) | **POST** /api/v2/experimental_cron_jobs/{cron_job_id}/pause | Pause Cron Job
*DefaultApi* | [**produce_analytics_event_api_v2_analytics_post**](docs/DefaultApi.md#produce_analytics_event_api_v2_analytics_post) | **POST** /api/v2/analytics/ | Produce Analytics Event
*DefaultApi* | [**projects_violating_tree_hierarchy_api_v2_access_controls_migration_organization_id_projects_violating_tree_hierarchy_get**](docs/DefaultApi.md#projects_violating_tree_hierarchy_api_v2_access_controls_migration_organization_id_projects_violating_tree_hierarchy_get) | **GET** /api/v2/access_controls_migration/{organization_id}/projects_violating_tree_hierarchy | Projects Violating Tree Hierarchy
*DefaultApi* | [**publish_api_v2_streams_publish_post**](docs/DefaultApi.md#publish_api_v2_streams_publish_post) | **POST** /api/v2/streams/publish | Publish
*DefaultApi* | [**put_job_wandb_run_details_api_v2_integrations_job_wandb_run_details_job_id_put**](docs/DefaultApi.md#put_job_wandb_run_details_api_v2_integrations_job_wandb_run_details_job_id_put) | **PUT** /api/v2/integrations/job_wandb_run_details/{job_id} | Put Job Wandb Run Details
*DefaultApi* | [**put_production_job_wandb_run_details_api_v2_integrations_production_job_wandb_run_details_production_job_id_put**](docs/DefaultApi.md#put_production_job_wandb_run_details_api_v2_integrations_production_job_wandb_run_details_production_job_id_put) | **PUT** /api/v2/integrations/production_job_wandb_run_details/{production_job_id} | Put Production Job Wandb Run Details
*DefaultApi* | [**put_session_cluster_config_with_session_idle_timeout_api_v2_sessions_session_id_cluster_config_with_session_idle_timeout_put**](docs/DefaultApi.md#put_session_cluster_config_with_session_idle_timeout_api_v2_sessions_session_id_cluster_config_with_session_idle_timeout_put) | **PUT** /api/v2/sessions/{session_id}/cluster_config_with_session_idle_timeout | Put Session Cluster Config With Session Idle Timeout
*DefaultApi* | [**put_workspace_proxied_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_proxied_dataplane_artifacts_put**](docs/DefaultApi.md#put_workspace_proxied_dataplane_artifacts_api_v2_experimental_workspaces_workspace_id_proxied_dataplane_artifacts_put) | **PUT** /api/v2/experimental_workspaces/{workspace_id}/proxied_dataplane_artifacts | Put Workspace Proxied Dataplane Artifacts
*DefaultApi* | [**put_workspace_wandb_run_details_api_v2_integrations_workspace_wandb_run_details_workspace_id_put**](docs/DefaultApi.md#put_workspace_wandb_run_details_api_v2_integrations_workspace_wandb_run_details_workspace_id_put) | **PUT** /api/v2/integrations/workspace_wandb_run_details/{workspace_id} | Put Workspace Wandb Run Details
*DefaultApi* | [**query_aggregated_logs_api_v2_logs_query_aggregated_logs_get**](docs/DefaultApi.md#query_aggregated_logs_api_v2_logs_query_aggregated_logs_get) | **GET** /api/v2/logs/query_aggregated_logs | Query Aggregated Logs
*DefaultApi* | [**redirect_to_service_api_v2_sessions_cluster_id_services_get**](docs/DefaultApi.md#redirect_to_service_api_v2_sessions_cluster_id_services_get) | **GET** /api/v2/sessions/{cluster_id}/services | Redirect To Service
*DefaultApi* | [**redirect_to_tools_api_v2_services_v2_service_id_tools_get**](docs/DefaultApi.md#redirect_to_tools_api_v2_services_v2_service_id_tools_get) | **GET** /api/v2/services-v2/{service_id}/tools | Redirect To Tools
*DefaultApi* | [**register_autosync_session_api_v2_autosync_sessions_post**](docs/DefaultApi.md#register_autosync_session_api_v2_autosync_sessions_post) | **POST** /api/v2/autosync_sessions/ | Register Autosync Session
*DefaultApi* | [**register_buffer_api_v2_anyscaled_register_buffer_post**](docs/DefaultApi.md#register_buffer_api_v2_anyscaled_register_buffer_post) | **POST** /api/v2/anyscaled/register_buffer | Register Buffer
*DefaultApi* | [**register_build_api_v2_anyscaled_register_build_post**](docs/DefaultApi.md#register_build_api_v2_anyscaled_register_build_post) | **POST** /api/v2/anyscaled/register_build | Register Build
*DefaultApi* | [**register_user_api_v2_users_post**](docs/DefaultApi.md#register_user_api_v2_users_post) | **POST** /api/v2/users/ | Register User
*DefaultApi* | [**register_user_from_stripe_api_v2_users_user_from_stripe_post**](docs/DefaultApi.md#register_user_from_stripe_api_v2_users_user_from_stripe_post) | **POST** /api/v2/users/user_from_stripe | Register User From Stripe
*DefaultApi* | [**register_v2_api_v2_anyscaled_register_v2_post**](docs/DefaultApi.md#register_v2_api_v2_anyscaled_register_v2_post) | **POST** /api/v2/anyscaled/register_v2 | Register V2
*DefaultApi* | [**remove_organization_collaborator_api_v2_organization_collaborators_identity_id_delete**](docs/DefaultApi.md#remove_organization_collaborator_api_v2_organization_collaborators_identity_id_delete) | **DELETE** /api/v2/organization_collaborators/{identity_id} | Remove Organization Collaborator
*DefaultApi* | [**request_email_magic_link_api_v2_users_email_magic_link_post**](docs/DefaultApi.md#request_email_magic_link_api_v2_users_email_magic_link_post) | **POST** /api/v2/users/email_magic_link | Request Email Magic Link
*DefaultApi* | [**request_password_reset_api_v2_users_request_password_reset_post**](docs/DefaultApi.md#request_password_reset_api_v2_users_request_password_reset_post) | **POST** /api/v2/users/request_password_reset | Request Password Reset
*DefaultApi* | [**reset_password_api_v2_users_reset_password_post**](docs/DefaultApi.md#reset_password_api_v2_users_reset_password_post) | **POST** /api/v2/users/reset_password | Reset Password
*DefaultApi* | [**restart_service_api_v2_services_v2_service_id_restart_post**](docs/DefaultApi.md#restart_service_api_v2_services_v2_service_id_restart_post) | **POST** /api/v2/services-v2/{service_id}/restart | Restart Service
*DefaultApi* | [**resubmit_fine_tuning_job_api_v2_fine_tuning_jobs_internal_resubmit_post**](docs/DefaultApi.md#resubmit_fine_tuning_job_api_v2_fine_tuning_jobs_internal_resubmit_post) | **POST** /api/v2/fine_tuning/jobs/internal/resubmit | Resubmit Fine Tuning Job
*DefaultApi* | [**rollback_service_api_v2_services_v2_service_id_rollback_post**](docs/DefaultApi.md#rollback_service_api_v2_services_v2_service_id_rollback_post) | **POST** /api/v2/services-v2/{service_id}/rollback | Rollback Service
*DefaultApi* | [**rotate_api_key_api_v2_users_rotate_api_key_get**](docs/DefaultApi.md#rotate_api_key_api_v2_users_rotate_api_key_get) | **GET** /api/v2/users/rotate_api_key | Rotate Api Key
*DefaultApi* | [**rotate_api_key_for_user_api_v2_organization_collaborators_rotate_api_key_for_user_user_id_post**](docs/DefaultApi.md#rotate_api_key_for_user_api_v2_organization_collaborators_rotate_api_key_for_user_user_id_post) | **POST** /api/v2/organization_collaborators/rotate_api_key_for_user/{user_id} | Rotate Api Key For User
*DefaultApi* | [**saml_acs_api_v2_organizations_organization_id_saml_acs_post**](docs/DefaultApi.md#saml_acs_api_v2_organizations_organization_id_saml_acs_post) | **POST** /api/v2/organizations/{organization_id}/saml_acs | Saml Acs
*DefaultApi* | [**search_cloud_collaborators_api_v2_clouds_cloud_id_collaborators_users_search_post**](docs/DefaultApi.md#search_cloud_collaborators_api_v2_clouds_cloud_id_collaborators_users_search_post) | **POST** /api/v2/clouds/{cloud_id}/collaborators/users/search | Search Cloud Collaborators
*DefaultApi* | [**search_cluster_environments_api_v2_application_templates_search_post**](docs/DefaultApi.md#search_cluster_environments_api_v2_application_templates_search_post) | **POST** /api/v2/application_templates/search | Search Cluster Environments
*DefaultApi* | [**search_compute_templates_api_v2_compute_templates_search_post**](docs/DefaultApi.md#search_compute_templates_api_v2_compute_templates_search_post) | **POST** /api/v2/compute_templates/search | Search Compute Templates
*DefaultApi* | [**search_invoices_api_v2_organization_billing_invoices_post**](docs/DefaultApi.md#search_invoices_api_v2_organization_billing_invoices_post) | **POST** /api/v2/organization_billing/invoices | Search Invoices
*DefaultApi* | [**search_support_requests_api_v2_support_requests_search_post**](docs/DefaultApi.md#search_support_requests_api_v2_support_requests_search_post) | **POST** /api/v2/support_requests/search | Search Support Requests
*DefaultApi* | [**search_user_cards_api_v2_onboarding_cards_search_post**](docs/DefaultApi.md#search_user_cards_api_v2_onboarding_cards_search_post) | **POST** /api/v2/onboarding_cards/search | Search User Cards
*DefaultApi* | [**set_organization_to_be_blocked_api_v2_organizations_block_post**](docs/DefaultApi.md#set_organization_to_be_blocked_api_v2_organizations_block_post) | **POST** /api/v2/organizations/block | Set Organization To Be Blocked
*DefaultApi* | [**set_organization_to_be_unblocked_api_v2_organizations_organization_id_unblock_post**](docs/DefaultApi.md#set_organization_to_be_unblocked_api_v2_organizations_organization_id_unblock_post) | **POST** /api/v2/organizations/{organization_id}/unblock | Set Organization To Be Unblocked
*DefaultApi* | [**setup_and_initialize_session_api_v2_sessions_session_id_setup_and_initialize_session_post**](docs/DefaultApi.md#setup_and_initialize_session_api_v2_sessions_session_id_setup_and_initialize_session_post) | **POST** /api/v2/sessions/{session_id}/setup_and_initialize_session | Setup And Initialize Session
*DefaultApi* | [**show_one_time_password_source_api_v2_users_show_otp_source_post**](docs/DefaultApi.md#show_one_time_password_source_api_v2_users_show_otp_source_post) | **POST** /api/v2/users/show_otp_source | Show One Time Password Source
*DefaultApi* | [**sso_login_info_api_v2_users_sso_login_info_get**](docs/DefaultApi.md#sso_login_info_api_v2_users_sso_login_info_get) | **GET** /api/v2/users/sso_login_info | Sso Login Info
*DefaultApi* | [**sso_login_test_api_v2_users_sso_login_test_get**](docs/DefaultApi.md#sso_login_test_api_v2_users_sso_login_test_get) | **GET** /api/v2/users/sso_login_test | Sso Login Test
*DefaultApi* | [**start_endpoint_api_v2_aica_endpoints_endpoint_id_start_post**](docs/DefaultApi.md#start_endpoint_api_v2_aica_endpoints_endpoint_id_start_post) | **POST** /api/v2/aica_endpoints/{endpoint_id}/start | Start Endpoint
*DefaultApi* | [**start_session_api_v2_sessions_session_id_start_post**](docs/DefaultApi.md#start_session_api_v2_sessions_session_id_start_post) | **POST** /api/v2/sessions/{session_id}/start | Start Session
*DefaultApi* | [**stop_session_api_v2_sessions_session_id_stop_post**](docs/DefaultApi.md#stop_session_api_v2_sessions_session_id_stop_post) | **POST** /api/v2/sessions/{session_id}/stop | Stop Session
*DefaultApi* | [**terminate_job_api_v2_decorated_ha_jobs_production_job_id_terminate_post**](docs/DefaultApi.md#terminate_job_api_v2_decorated_ha_jobs_production_job_id_terminate_post) | **POST** /api/v2/decorated_ha_jobs/{production_job_id}/terminate | Terminate Job
*DefaultApi* | [**terminate_service_api_v2_services_v2_service_id_terminate_post**](docs/DefaultApi.md#terminate_service_api_v2_services_v2_service_id_terminate_post) | **POST** /api/v2/services-v2/{service_id}/terminate | Terminate Service
*DefaultApi* | [**test_saml_acs_api_v2_organizations_organization_id_test_saml_acs_post**](docs/DefaultApi.md#test_saml_acs_api_v2_organizations_organization_id_test_saml_acs_post) | **POST** /api/v2/organizations/{organization_id}/test_saml_acs | Test Saml Acs
*DefaultApi* | [**trigger_cron_job_api_v2_experimental_cron_jobs_cron_job_id_trigger_post**](docs/DefaultApi.md#trigger_cron_job_api_v2_experimental_cron_jobs_cron_job_id_trigger_post) | **POST** /api/v2/experimental_cron_jobs/{cron_job_id}/trigger | Trigger Cron Job
*DefaultApi* | [**try_login_api_v2_users_try_login_post**](docs/DefaultApi.md#try_login_api_v2_users_try_login_post) | **POST** /api/v2/users/try-login | Try Login
*DefaultApi* | [**undismiss_user_card_api_v2_onboarding_cards_card_id_undismiss_post**](docs/DefaultApi.md#undismiss_user_card_api_v2_onboarding_cards_card_id_undismiss_post) | **POST** /api/v2/onboarding_cards/{card_id}/undismiss | Undismiss User Card
*DefaultApi* | [**update_aica_endpoint_api_v2_aica_endpoints_put**](docs/DefaultApi.md#update_aica_endpoint_api_v2_aica_endpoints_put) | **PUT** /api/v2/aica_endpoints/ | Update Aica Endpoint
*DefaultApi* | [**update_cloud_auto_add_user_api_v2_clouds_cloud_id_auto_add_user_put**](docs/DefaultApi.md#update_cloud_auto_add_user_api_v2_clouds_cloud_id_auto_add_user_put) | **PUT** /api/v2/clouds/{cloud_id}/auto_add_user | Update Cloud Auto Add User
*DefaultApi* | [**update_cloud_config_api_v2_clouds_cloud_id_config_put**](docs/DefaultApi.md#update_cloud_config_api_v2_clouds_cloud_id_config_put) | **PUT** /api/v2/clouds/{cloud_id}/config | Update Cloud Config
*DefaultApi* | [**update_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_put**](docs/DefaultApi.md#update_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_gcp_router_cloud_id_put) | **PUT** /api/v2/clouds_with_cloud_resource_gcp_router/{cloud_id} | Update Cloud With Cloud Resource
*DefaultApi* | [**update_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_put**](docs/DefaultApi.md#update_cloud_with_cloud_resource_api_v2_clouds_with_cloud_resource_router_cloud_id_put) | **PUT** /api/v2/clouds_with_cloud_resource_router/{cloud_id} | Update Cloud With Cloud Resource
*DefaultApi* | [**update_compute_template_api_v2_compute_templates_compute_template_id_put**](docs/DefaultApi.md#update_compute_template_api_v2_compute_templates_compute_template_id_put) | **PUT** /api/v2/compute_templates/{compute_template_id} | Update Compute Template
*DefaultApi* | [**update_default_cloud_api_v2_organizations_update_default_cloud_post**](docs/DefaultApi.md#update_default_cloud_api_v2_organizations_update_default_cloud_post) | **POST** /api/v2/organizations/update_default_cloud | Update Default Cloud
*DefaultApi* | [**update_dns_api_v2_dns_post**](docs/DefaultApi.md#update_dns_api_v2_dns_post) | **POST** /api/v2/dns/ | Update Dns
*DefaultApi* | [**upload_file_api_v2_files_post**](docs/DefaultApi.md#upload_file_api_v2_files_post) | **POST** /api/v2/files | Upload File
*DefaultApi* | [**upload_session_command_logs_api_v2_session_commands_session_command_id_upload_logs_post**](docs/DefaultApi.md#upload_session_command_logs_api_v2_session_commands_session_command_id_upload_logs_post) | **POST** /api/v2/session_commands/{session_command_id}/upload_logs | Upload Session Command Logs
*DefaultApi* | [**upsert_billing_version_api_v2_organization_billing_billing_versions_put**](docs/DefaultApi.md#upsert_billing_version_api_v2_organization_billing_billing_versions_put) | **PUT** /api/v2/organization_billing/billing_versions | Upsert Billing Version
*DefaultApi* | [**upsert_support_request_for_user_organization_api_v2_support_requests_support_request_put**](docs/DefaultApi.md#upsert_support_request_for_user_organization_api_v2_support_requests_support_request_put) | **PUT** /api/v2/support_requests/support_request | Upsert Support Request For User Organization
*DefaultApi* | [**user_resend_email_api_v2_users_resend_email_post**](docs/DefaultApi.md#user_resend_email_api_v2_users_resend_email_post) | **POST** /api/v2/users/resend_email | User Resend Email
*DefaultApi* | [**user_verify_api_v2_users_verify_token_get**](docs/DefaultApi.md#user_verify_api_v2_users_verify_token_get) | **GET** /api/v2/users/verify/{token} | User Verify
*DefaultApi* | [**validate_cluster_api_v2_sessions_validate_cluster_post**](docs/DefaultApi.md#validate_cluster_api_v2_sessions_validate_cluster_post) | **POST** /api/v2/sessions/validate_cluster | Validate Cluster
*DefaultApi* | [**validate_invite_code_api_v2_users_validate_invite_code_invite_code_post**](docs/DefaultApi.md#validate_invite_code_api_v2_users_validate_invite_code_invite_code_post) | **POST** /api/v2/users/validate_invite_code/{invite_code} | Validate Invite Code
*DefaultApi* | [**validate_one_time_password_api_v2_users_validate_otp_token_post**](docs/DefaultApi.md#validate_one_time_password_api_v2_users_validate_otp_token_post) | **POST** /api/v2/users/validate_otp_token | Validate One Time Password
*DefaultApi* | [**verify_access_api_v2_cloudsverify_access_cloud_id_get**](docs/DefaultApi.md#verify_access_api_v2_cloudsverify_access_cloud_id_get) | **GET** /api/v2/cloudsverify_access/{cloud_id} | Verify Access
*DefaultApi* | [**verify_migration_complete_api_v2_access_controls_migration_organization_id_verify_migration_complete_get**](docs/DefaultApi.md#verify_migration_complete_api_v2_access_controls_migration_organization_id_verify_migration_complete_get) | **GET** /api/v2/access_controls_migration/{organization_id}/verify_migration_complete | Verify Migration Complete
*DefaultApi* | [**verify_reset_password_token_api_v2_users_reset_password_token_get**](docs/DefaultApi.md#verify_reset_password_token_api_v2_users_reset_password_token_get) | **GET** /api/v2/users/reset_password/{token} | Verify Reset Password Token


## Documentation For Models

 - [AWSCredentials](docs/AWSCredentials.md)
 - [AWSMemoryDBClusterConfig](docs/AWSMemoryDBClusterConfig.md)
 - [AWSNodeOptions](docs/AWSNodeOptions.md)
 - [AWSTag](docs/AWSTag.md)
 - [AWSTagSpecification](docs/AWSTagSpecification.md)
 - [AccessConfig](docs/AccessConfig.md)
 - [AccessMode](docs/AccessMode.md)
 - [AicaEndpoint](docs/AicaEndpoint.md)
 - [AicaEndpointEvent](docs/AicaEndpointEvent.md)
 - [AicaEndpointEventLevel](docs/AicaEndpointEventLevel.md)
 - [AicaEndpointEventType](docs/AicaEndpointEventType.md)
 - [AicaEndpointScope](docs/AicaEndpointScope.md)
 - [AicaModel](docs/AicaModel.md)
 - [AicaModelAcceleratorMap](docs/AicaModelAcceleratorMap.md)
 - [AicaModelConfiguration](docs/AicaModelConfiguration.md)
 - [AicaObservabilityUrls](docs/AicaObservabilityUrls.md)
 - [AicaendpointListResponse](docs/AicaendpointListResponse.md)
 - [AicaendpointResponse](docs/AicaendpointResponse.md)
 - [AicaendpointeventListResponse](docs/AicaendpointeventListResponse.md)
 - [AicamodelListResponse](docs/AicamodelListResponse.md)
 - [AicamodelResponse](docs/AicamodelResponse.md)
 - [AioaCloudWaitlistRecord](docs/AioaCloudWaitlistRecord.md)
 - [AioacloudwaitlistrecordResponse](docs/AioacloudwaitlistrecordResponse.md)
 - [AlertType](docs/AlertType.md)
 - [AnyscaleAWSAccount](docs/AnyscaleAWSAccount.md)
 - [AnyscaleVersionResponse](docs/AnyscaleVersionResponse.md)
 - [AnyscaleawsaccountResponse](docs/AnyscaleawsaccountResponse.md)
 - [AnyscaledCredentialResponse](docs/AnyscaledCredentialResponse.md)
 - [AnyscaledcredentialresponseResponse](docs/AnyscaledcredentialresponseResponse.md)
 - [AnyscaleversionresponseResponse](docs/AnyscaleversionresponseResponse.md)
 - [ApiKeyParameters](docs/ApiKeyParameters.md)
 - [AppConfig](docs/AppConfig.md)
 - [AppConfigConfigSchema](docs/AppConfigConfigSchema.md)
 - [AppconfigListResponse](docs/AppconfigListResponse.md)
 - [AppconfigResponse](docs/AppconfigResponse.md)
 - [AppliedSnapshot](docs/AppliedSnapshot.md)
 - [ApplyProductionServiceV2Model](docs/ApplyProductionServiceV2Model.md)
 - [ArchiveStatus](docs/ArchiveStatus.md)
 - [ArchivedLogsInfo](docs/ArchivedLogsInfo.md)
 - [ArchivedlogsinfoResponse](docs/ArchivedlogsinfoResponse.md)
 - [AttachMachinePoolToCloudRequest](docs/AttachMachinePoolToCloudRequest.md)
 - [AttachmachinepooltocloudresponseResponse](docs/AttachmachinepooltocloudresponseResponse.md)
 - [AutoscalerCredentials](docs/AutoscalerCredentials.md)
 - [AutoscalercredentialsResponse](docs/AutoscalercredentialsResponse.md)
 - [AutosyncSessionId](docs/AutosyncSessionId.md)
 - [AutosyncsessionidListResponse](docs/AutosyncsessionidListResponse.md)
 - [AutosyncsessionidResponse](docs/AutosyncsessionidResponse.md)
 - [AviaryModelConfigV2](docs/AviaryModelConfigV2.md)
 - [AwsRegionAndZones](docs/AwsRegionAndZones.md)
 - [AwsRegionInfo](docs/AwsRegionInfo.md)
 - [AwsregionandzonesResponse](docs/AwsregionandzonesResponse.md)
 - [BASEIMAGESENUM](docs/BASEIMAGESENUM.md)
 - [BankAccountInformation](docs/BankAccountInformation.md)
 - [BaseJobStatus](docs/BaseJobStatus.md)
 - [BatchResponseBatchedResultOrganizationInvitationBase](docs/BatchResponseBatchedResultOrganizationInvitationBase.md)
 - [BatchedResultOrganizationInvitationBase](docs/BatchedResultOrganizationInvitationBase.md)
 - [BillingInformation](docs/BillingInformation.md)
 - [BillingVersionCode](docs/BillingVersionCode.md)
 - [BlockDeviceMapping](docs/BlockDeviceMapping.md)
 - [BodyUploadFileApiV2FilesPost](docs/BodyUploadFileApiV2FilesPost.md)
 - [BufferRegistration](docs/BufferRegistration.md)
 - [Build](docs/Build.md)
 - [BuildLogResponse](docs/BuildLogResponse.md)
 - [BuildRegistration](docs/BuildRegistration.md)
 - [BuildResponse](docs/BuildResponse.md)
 - [BuildStatus](docs/BuildStatus.md)
 - [BuildlogresponseResponse](docs/BuildlogresponseResponse.md)
 - [Card](docs/Card.md)
 - [CardId](docs/CardId.md)
 - [CardListResponse](docs/CardListResponse.md)
 - [ChangePasswordParams](docs/ChangePasswordParams.md)
 - [CloneExperimentalWorkspace](docs/CloneExperimentalWorkspace.md)
 - [Cloud](docs/Cloud.md)
 - [CloudAnalyticsEvent](docs/CloudAnalyticsEvent.md)
 - [CloudAnalyticsEventCloudProviderError](docs/CloudAnalyticsEventCloudProviderError.md)
 - [CloudAnalyticsEventCloudResource](docs/CloudAnalyticsEventCloudResource.md)
 - [CloudAnalyticsEventCommandName](docs/CloudAnalyticsEventCommandName.md)
 - [CloudAnalyticsEventError](docs/CloudAnalyticsEventError.md)
 - [CloudAnalyticsEventName](docs/CloudAnalyticsEventName.md)
 - [CloudCollaborator](docs/CloudCollaborator.md)
 - [CloudCollaboratorValue](docs/CloudCollaboratorValue.md)
 - [CloudCollaboratorsQuery](docs/CloudCollaboratorsQuery.md)
 - [CloudConfig](docs/CloudConfig.md)
 - [CloudDataBucketFileType](docs/CloudDataBucketFileType.md)
 - [CloudDataBucketPresignedUploadInfo](docs/CloudDataBucketPresignedUploadInfo.md)
 - [CloudDataBucketPresignedUploadRequest](docs/CloudDataBucketPresignedUploadRequest.md)
 - [CloudListResponse](docs/CloudListResponse.md)
 - [CloudNameOptions](docs/CloudNameOptions.md)
 - [CloudProjectCollaborator](docs/CloudProjectCollaborator.md)
 - [CloudProjectCollaboratorValue](docs/CloudProjectCollaboratorValue.md)
 - [CloudProvider](docs/CloudProvider.md)
 - [CloudProviders](docs/CloudProviders.md)
 - [CloudRegionAndZones](docs/CloudRegionAndZones.md)
 - [CloudRegionInfo](docs/CloudRegionInfo.md)
 - [CloudResource](docs/CloudResource.md)
 - [CloudResourceGCP](docs/CloudResourceGCP.md)
 - [CloudResponse](docs/CloudResponse.md)
 - [CloudState](docs/CloudState.md)
 - [CloudStatus](docs/CloudStatus.md)
 - [CloudTypes](docs/CloudTypes.md)
 - [CloudVersion](docs/CloudVersion.md)
 - [CloudWithCloudResource](docs/CloudWithCloudResource.md)
 - [CloudWithCloudResourceGCP](docs/CloudWithCloudResourceGCP.md)
 - [CloudcollaboratorListResponse](docs/CloudcollaboratorListResponse.md)
 - [ClouddatabucketpresigneduploadinfoResponse](docs/ClouddatabucketpresigneduploadinfoResponse.md)
 - [CloudregionandzonesResponse](docs/CloudregionandzonesResponse.md)
 - [CloudresourceResponse](docs/CloudresourceResponse.md)
 - [CloudresourcegcpResponse](docs/CloudresourcegcpResponse.md)
 - [CloudwithcloudresourceResponse](docs/CloudwithcloudresourceResponse.md)
 - [CloudwithcloudresourcegcpResponse](docs/CloudwithcloudresourcegcpResponse.md)
 - [ClusterAuthResponse](docs/ClusterAuthResponse.md)
 - [ClusterConfig](docs/ClusterConfig.md)
 - [ClusterConfigWithSessionIdleTimeout](docs/ClusterConfigWithSessionIdleTimeout.md)
 - [ClusterEnvironmentsQuery](docs/ClusterEnvironmentsQuery.md)
 - [ClusterEvent](docs/ClusterEvent.md)
 - [ClusterEventsOutput](docs/ClusterEventsOutput.md)
 - [ClusterFeatures](docs/ClusterFeatures.md)
 - [ClusterManagementStackVersions](docs/ClusterManagementStackVersions.md)
 - [ClusterStartup](docs/ClusterStartup.md)
 - [ClusterStatus](docs/ClusterStatus.md)
 - [ClusterStatusDetails](docs/ClusterStatusDetails.md)
 - [ClusterauthresponseResponse](docs/ClusterauthresponseResponse.md)
 - [ClusterconfigResponse](docs/ClusterconfigResponse.md)
 - [ClusterconfigwithsessionidletimeoutResponse](docs/ClusterconfigwithsessionidletimeoutResponse.md)
 - [ClustereventsoutputResponse](docs/ClustereventsoutputResponse.md)
 - [ClusterfeaturesResponse](docs/ClusterfeaturesResponse.md)
 - [ComputeNodeType](docs/ComputeNodeType.md)
 - [ComputeTemplate](docs/ComputeTemplate.md)
 - [ComputeTemplateConfig](docs/ComputeTemplateConfig.md)
 - [ComputeTemplateQuery](docs/ComputeTemplateQuery.md)
 - [ComputetemplateResponse](docs/ComputetemplateResponse.md)
 - [ComputetemplateconfigResponse](docs/ComputetemplateconfigResponse.md)
 - [CreateAicaEndpoint](docs/CreateAicaEndpoint.md)
 - [CreateAioaCloudWaitlist](docs/CreateAioaCloudWaitlist.md)
 - [CreateAnalyticsEvent](docs/CreateAnalyticsEvent.md)
 - [CreateAppConfig](docs/CreateAppConfig.md)
 - [CreateAppConfigConfigurationSchema](docs/CreateAppConfigConfigurationSchema.md)
 - [CreateBYODAppConfig](docs/CreateBYODAppConfig.md)
 - [CreateBYODAppConfigConfigurationSchema](docs/CreateBYODAppConfigConfigurationSchema.md)
 - [CreateBYODBuild](docs/CreateBYODBuild.md)
 - [CreateBillingVersion](docs/CreateBillingVersion.md)
 - [CreateBugReportResponse](docs/CreateBugReportResponse.md)
 - [CreateBuild](docs/CreateBuild.md)
 - [CreateCloudCollaborator](docs/CreateCloudCollaborator.md)
 - [CreateCloudResource](docs/CreateCloudResource.md)
 - [CreateCloudResourceGCP](docs/CreateCloudResourceGCP.md)
 - [CreateCloudWithCloudResource](docs/CreateCloudWithCloudResource.md)
 - [CreateClusterComputeConfig](docs/CreateClusterComputeConfig.md)
 - [CreateComputeTemplate](docs/CreateComputeTemplate.md)
 - [CreateComputeTemplateConfig](docs/CreateComputeTemplateConfig.md)
 - [CreateExperimentalWorkspace](docs/CreateExperimentalWorkspace.md)
 - [CreateExperimentalWorkspaceFromJob](docs/CreateExperimentalWorkspaceFromJob.md)
 - [CreateFineTuningHyperparameters](docs/CreateFineTuningHyperparameters.md)
 - [CreateFineTuningJobProductRequest](docs/CreateFineTuningJobProductRequest.md)
 - [CreateInternalProductionJob](docs/CreateInternalProductionJob.md)
 - [CreateJobQueueConfig](docs/CreateJobQueueConfig.md)
 - [CreateMachinePoolRequest](docs/CreateMachinePoolRequest.md)
 - [CreateMachinePoolResponse](docs/CreateMachinePoolResponse.md)
 - [CreateMachineRequest](docs/CreateMachineRequest.md)
 - [CreateMachineResponse](docs/CreateMachineResponse.md)
 - [CreateMetronomeWebhookNotification](docs/CreateMetronomeWebhookNotification.md)
 - [CreateOTPReturnApiModel](docs/CreateOTPReturnApiModel.md)
 - [CreateOrganizationInvitation](docs/CreateOrganizationInvitation.md)
 - [CreateProductionJobConfig](docs/CreateProductionJobConfig.md)
 - [CreateSchedule](docs/CreateSchedule.md)
 - [CreateSessionFromSnapshotOptions](docs/CreateSessionFromSnapshotOptions.md)
 - [CreateSessionInDb](docs/CreateSessionInDb.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [CreateUser](docs/CreateUser.md)
 - [CreateUserProjectCollaborator](docs/CreateUserProjectCollaborator.md)
 - [CreateUserProjectCollaboratorValue](docs/CreateUserProjectCollaboratorValue.md)
 - [CreateWorkspaceFromTemplate](docs/CreateWorkspaceFromTemplate.md)
 - [CreatebugreportresponseResponse](docs/CreatebugreportresponseResponse.md)
 - [CreatecomputetemplateconfigResponse](docs/CreatecomputetemplateconfigResponse.md)
 - [CreatemachinepoolresponseResponse](docs/CreatemachinepoolresponseResponse.md)
 - [CreatemachineresponseResponse](docs/CreatemachineresponseResponse.md)
 - [CreateotpreturnapimodelResponse](docs/CreateotpreturnapimodelResponse.md)
 - [CreatesessionresponseResponse](docs/CreatesessionresponseResponse.md)
 - [CreditCardInformation](docs/CreditCardInformation.md)
 - [CustomerAlertStatus](docs/CustomerAlertStatus.md)
 - [DataplaneServices](docs/DataplaneServices.md)
 - [DecoratedApplicationTemplate](docs/DecoratedApplicationTemplate.md)
 - [DecoratedBuild](docs/DecoratedBuild.md)
 - [DecoratedComputeTemplate](docs/DecoratedComputeTemplate.md)
 - [DecoratedComputeTemplateConfig](docs/DecoratedComputeTemplateConfig.md)
 - [DecoratedInteractiveSession](docs/DecoratedInteractiveSession.md)
 - [DecoratedJob](docs/DecoratedJob.md)
 - [DecoratedJobSubmission](docs/DecoratedJobSubmission.md)
 - [DecoratedListServiceAPIModel](docs/DecoratedListServiceAPIModel.md)
 - [DecoratedProductionJob](docs/DecoratedProductionJob.md)
 - [DecoratedProductionJobStateTransition](docs/DecoratedProductionJobStateTransition.md)
 - [DecoratedProductionServiceV2APIModel](docs/DecoratedProductionServiceV2APIModel.md)
 - [DecoratedProductionServiceV2VersionAPIModel](docs/DecoratedProductionServiceV2VersionAPIModel.md)
 - [DecoratedRuntimeEnv](docs/DecoratedRuntimeEnv.md)
 - [DecoratedSchedule](docs/DecoratedSchedule.md)
 - [DecoratedServeDeployment](docs/DecoratedServeDeployment.md)
 - [DecoratedServiceEventAPIModel](docs/DecoratedServiceEventAPIModel.md)
 - [DecoratedSession](docs/DecoratedSession.md)
 - [DecoratedSupportRequest](docs/DecoratedSupportRequest.md)
 - [DecoratedUnifiedJob](docs/DecoratedUnifiedJob.md)
 - [DecoratedapplicationtemplateListResponse](docs/DecoratedapplicationtemplateListResponse.md)
 - [DecoratedapplicationtemplateResponse](docs/DecoratedapplicationtemplateResponse.md)
 - [DecoratedbuildListResponse](docs/DecoratedbuildListResponse.md)
 - [DecoratedbuildResponse](docs/DecoratedbuildResponse.md)
 - [DecoratedcomputetemplateListResponse](docs/DecoratedcomputetemplateListResponse.md)
 - [DecoratedcomputetemplateResponse](docs/DecoratedcomputetemplateResponse.md)
 - [DecoratedinteractivesessionListResponse](docs/DecoratedinteractivesessionListResponse.md)
 - [DecoratedinteractivesessionResponse](docs/DecoratedinteractivesessionResponse.md)
 - [DecoratedjobListResponse](docs/DecoratedjobListResponse.md)
 - [DecoratedjobResponse](docs/DecoratedjobResponse.md)
 - [DecoratedjobsubmissionListResponse](docs/DecoratedjobsubmissionListResponse.md)
 - [DecoratedjobsubmissionResponse](docs/DecoratedjobsubmissionResponse.md)
 - [DecoratedlistserviceapimodelListResponse](docs/DecoratedlistserviceapimodelListResponse.md)
 - [DecoratedproductionjobListResponse](docs/DecoratedproductionjobListResponse.md)
 - [DecoratedproductionjobResponse](docs/DecoratedproductionjobResponse.md)
 - [DecoratedproductionjobstatetransitionListResponse](docs/DecoratedproductionjobstatetransitionListResponse.md)
 - [Decoratedproductionservicev2ApimodelResponse](docs/Decoratedproductionservicev2ApimodelResponse.md)
 - [Decoratedproductionservicev2VersionapimodelListResponse](docs/Decoratedproductionservicev2VersionapimodelListResponse.md)
 - [DecoratedruntimeenvListResponse](docs/DecoratedruntimeenvListResponse.md)
 - [DecoratedruntimeenvResponse](docs/DecoratedruntimeenvResponse.md)
 - [DecoratedscheduleListResponse](docs/DecoratedscheduleListResponse.md)
 - [DecoratedscheduleResponse](docs/DecoratedscheduleResponse.md)
 - [DecoratedservedeploymentListResponse](docs/DecoratedservedeploymentListResponse.md)
 - [DecoratedservedeploymentResponse](docs/DecoratedservedeploymentResponse.md)
 - [DecoratedserviceeventapimodelListResponse](docs/DecoratedserviceeventapimodelListResponse.md)
 - [DecoratedsessionListResponse](docs/DecoratedsessionListResponse.md)
 - [DecoratedsessionResponse](docs/DecoratedsessionResponse.md)
 - [DecoratedsupportrequestListResponse](docs/DecoratedsupportrequestListResponse.md)
 - [DecoratedsupportrequestResponse](docs/DecoratedsupportrequestResponse.md)
 - [DecoratedunifiedjobListResponse](docs/DecoratedunifiedjobListResponse.md)
 - [DecoratedunifiedjobResponse](docs/DecoratedunifiedjobResponse.md)
 - [DeleteMachinePoolRequest](docs/DeleteMachinePoolRequest.md)
 - [DeleteMachineRequest](docs/DeleteMachineRequest.md)
 - [DeletemachinepoolresponseResponse](docs/DeletemachinepoolresponseResponse.md)
 - [DetachMachinePoolFromCloudRequest](docs/DetachMachinePoolFromCloudRequest.md)
 - [DetachmachinepoolfromcloudresponseResponse](docs/DetachmachinepoolfromcloudresponseResponse.md)
 - [DismissalType](docs/DismissalType.md)
 - [EbsBlockDevice](docs/EbsBlockDevice.md)
 - [EditableCloudResource](docs/EditableCloudResource.md)
 - [EditableCloudResourceGCP](docs/EditableCloudResourceGCP.md)
 - [Error](docs/Error.md)
 - [EventLevel](docs/EventLevel.md)
 - [ExecuteCommandResponse](docs/ExecuteCommandResponse.md)
 - [ExecuteInteractiveCommandOptions](docs/ExecuteInteractiveCommandOptions.md)
 - [ExecuteShellCommandOptions](docs/ExecuteShellCommandOptions.md)
 - [ExecutecommandresponseResponse](docs/ExecutecommandresponseResponse.md)
 - [ExperimentalWorkspace](docs/ExperimentalWorkspace.md)
 - [ExperimentalworkspaceListResponse](docs/ExperimentalworkspaceListResponse.md)
 - [ExperimentalworkspaceResponse](docs/ExperimentalworkspaceResponse.md)
 - [ExternalServiceStatus](docs/ExternalServiceStatus.md)
 - [ExternalServiceStatusResponse](docs/ExternalServiceStatusResponse.md)
 - [ExternalTerminalCommand](docs/ExternalTerminalCommand.md)
 - [ExternalservicestatusresponseResponse](docs/ExternalservicestatusresponseResponse.md)
 - [FeatureCompatibility](docs/FeatureCompatibility.md)
 - [FeatureFlagResponse](docs/FeatureFlagResponse.md)
 - [FeatureflagresponseResponse](docs/FeatureflagresponseResponse.md)
 - [FileModel](docs/FileModel.md)
 - [FilemodelResponse](docs/FilemodelResponse.md)
 - [FineTuningJobStatus](docs/FineTuningJobStatus.md)
 - [FinishFTJobRequest](docs/FinishFTJobRequest.md)
 - [FinishFTJobRequestV2](docs/FinishFTJobRequestV2.md)
 - [GCPFileStoreConfig](docs/GCPFileStoreConfig.md)
 - [GCPMemorystoreInstanceConfig](docs/GCPMemorystoreInstanceConfig.md)
 - [GCPNodeDisk](docs/GCPNodeDisk.md)
 - [GCPNodeOptions](docs/GCPNodeOptions.md)
 - [GrpcProtocolConfig](docs/GrpcProtocolConfig.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HaJobGoalStates](docs/HaJobGoalStates.md)
 - [HaJobStates](docs/HaJobStates.md)
 - [HaJobType](docs/HaJobType.md)
 - [HaJobsSortField](docs/HaJobsSortField.md)
 - [HeadIp](docs/HeadIp.md)
 - [HeadipResponse](docs/HeadipResponse.md)
 - [HttpProtocolConfig](docs/HttpProtocolConfig.md)
 - [IamInstanceProfileSpecification](docs/IamInstanceProfileSpecification.md)
 - [IdleTerminationStatus](docs/IdleTerminationStatus.md)
 - [ImportAicaModel](docs/ImportAicaModel.md)
 - [IntegrationDetails](docs/IntegrationDetails.md)
 - [InteractiveSessionLogs](docs/InteractiveSessionLogs.md)
 - [InteractivesessionlogsResponse](docs/InteractivesessionlogsResponse.md)
 - [InternalProductionJob](docs/InternalProductionJob.md)
 - [InternalproductionjobResponse](docs/InternalproductionjobResponse.md)
 - [Invoice](docs/Invoice.md)
 - [InvoiceListResponse](docs/InvoiceListResponse.md)
 - [InvoiceStatus](docs/InvoiceStatus.md)
 - [InvoicesQuery](docs/InvoicesQuery.md)
 - [JobAccess](docs/JobAccess.md)
 - [JobQueueConfig](docs/JobQueueConfig.md)
 - [JobQueueExecutionMode](docs/JobQueueExecutionMode.md)
 - [JobQueueSpec](docs/JobQueueSpec.md)
 - [JobRunType](docs/JobRunType.md)
 - [JobStateLogLevelTypes](docs/JobStateLogLevelTypes.md)
 - [JobStatus](docs/JobStatus.md)
 - [JobSubmissionsSortField](docs/JobSubmissionsSortField.md)
 - [JobsLogs](docs/JobsLogs.md)
 - [JobsLogsQueryInfo](docs/JobsLogsQueryInfo.md)
 - [JobsSortField](docs/JobsSortField.md)
 - [JobslogsResponse](docs/JobslogsResponse.md)
 - [JobslogsqueryinfoResponse](docs/JobslogsqueryinfoResponse.md)
 - [JsonPatchOperation](docs/JsonPatchOperation.md)
 - [LBResource](docs/LBResource.md)
 - [LbresourceResponse](docs/LbresourceResponse.md)
 - [ListMachinePoolsResponse](docs/ListMachinePoolsResponse.md)
 - [ListMachinesResponse](docs/ListMachinesResponse.md)
 - [ListResponseMetadata](docs/ListResponseMetadata.md)
 - [ListmachinepoolsresponseResponse](docs/ListmachinepoolsresponseResponse.md)
 - [ListmachinesresponseResponse](docs/ListmachinesresponseResponse.md)
 - [LogDetail](docs/LogDetail.md)
 - [LogDetails](docs/LogDetails.md)
 - [LogDownloadConfig](docs/LogDownloadConfig.md)
 - [LogDownloadRequest](docs/LogDownloadRequest.md)
 - [LogDownloadResult](docs/LogDownloadResult.md)
 - [LogFileChunk](docs/LogFileChunk.md)
 - [LogFilter](docs/LogFilter.md)
 - [LogItem](docs/LogItem.md)
 - [LogItemBatch](docs/LogItemBatch.md)
 - [LogLevelTypes](docs/LogLevelTypes.md)
 - [LogStream](docs/LogStream.md)
 - [LogdetailsResponse](docs/LogdetailsResponse.md)
 - [LogdownloadresultResponse](docs/LogdownloadresultResponse.md)
 - [LoginUserParams](docs/LoginUserParams.md)
 - [LogitembatchResponse](docs/LogitembatchResponse.md)
 - [LogsOutput](docs/LogsOutput.md)
 - [LogsoutputResponse](docs/LogsoutputResponse.md)
 - [LogstreamResponse](docs/LogstreamResponse.md)
 - [MachineAllocationState](docs/MachineAllocationState.md)
 - [MachineConnectionState](docs/MachineConnectionState.md)
 - [MachineInfo](docs/MachineInfo.md)
 - [MachinePool](docs/MachinePool.md)
 - [MetronomeDashboardType](docs/MetronomeDashboardType.md)
 - [MiniBuild](docs/MiniBuild.md)
 - [MiniCloud](docs/MiniCloud.md)
 - [MiniCluster](docs/MiniCluster.md)
 - [MiniComputeTemplate](docs/MiniComputeTemplate.md)
 - [MiniComputeTemplateConfig](docs/MiniComputeTemplateConfig.md)
 - [MiniJobRun](docs/MiniJobRun.md)
 - [MiniNamespace](docs/MiniNamespace.md)
 - [MiniOrganization](docs/MiniOrganization.md)
 - [MiniProductionJob](docs/MiniProductionJob.md)
 - [MiniProject](docs/MiniProject.md)
 - [MiniRuntimeEnvironment](docs/MiniRuntimeEnvironment.md)
 - [MiniSchedule](docs/MiniSchedule.md)
 - [MiniUser](docs/MiniUser.md)
 - [MinibuildListResponse](docs/MinibuildListResponse.md)
 - [MinicomputetemplateListResponse](docs/MinicomputetemplateListResponse.md)
 - [MiniprojectListResponse](docs/MiniprojectListResponse.md)
 - [MonitorLogsExtension](docs/MonitorLogsExtension.md)
 - [NamedEntity](docs/NamedEntity.md)
 - [NetworkInterface](docs/NetworkInterface.md)
 - [NodeRegistrationAWS](docs/NodeRegistrationAWS.md)
 - [NodeRegistrationGCP](docs/NodeRegistrationGCP.md)
 - [NodeRegistrationProvisioned](docs/NodeRegistrationProvisioned.md)
 - [NodeRegistrationSagemaker](docs/NodeRegistrationSagemaker.md)
 - [NodeRegistrationV2](docs/NodeRegistrationV2.md)
 - [NodeType](docs/NodeType.md)
 - [OnboardingUserCardsQuery](docs/OnboardingUserCardsQuery.md)
 - [Organization](docs/Organization.md)
 - [OrganizationAvailability](docs/OrganizationAvailability.md)
 - [OrganizationCollaborator](docs/OrganizationCollaborator.md)
 - [OrganizationInvitation](docs/OrganizationInvitation.md)
 - [OrganizationInvitationBase](docs/OrganizationInvitationBase.md)
 - [OrganizationPermissionLevel](docs/OrganizationPermissionLevel.md)
 - [OrganizationProjectCollaborator](docs/OrganizationProjectCollaborator.md)
 - [OrganizationProjectCollaboratorValue](docs/OrganizationProjectCollaboratorValue.md)
 - [OrganizationPublicIdentifier](docs/OrganizationPublicIdentifier.md)
 - [OrganizationResponse](docs/OrganizationResponse.md)
 - [OrganizationSummary](docs/OrganizationSummary.md)
 - [OrganizationUsageAlert](docs/OrganizationUsageAlert.md)
 - [OrganizationUsageAlertSeverity](docs/OrganizationUsageAlertSeverity.md)
 - [OrganizationavailabilityResponse](docs/OrganizationavailabilityResponse.md)
 - [OrganizationcollaboratorListResponse](docs/OrganizationcollaboratorListResponse.md)
 - [OrganizationinvitationListResponse](docs/OrganizationinvitationListResponse.md)
 - [OrganizationinvitationResponse](docs/OrganizationinvitationResponse.md)
 - [OrganizationinvitationbaseResponse](docs/OrganizationinvitationbaseResponse.md)
 - [OrganizationprojectcollaboratorListResponse](docs/OrganizationprojectcollaboratorListResponse.md)
 - [OrganizationpublicidentifierResponse](docs/OrganizationpublicidentifierResponse.md)
 - [OrganizationusagealertListResponse](docs/OrganizationusagealertListResponse.md)
 - [PageQuery](docs/PageQuery.md)
 - [PauseSchedule](docs/PauseSchedule.md)
 - [PermissionLevel](docs/PermissionLevel.md)
 - [PlatformFineTuningJob](docs/PlatformFineTuningJob.md)
 - [PlatformfinetuningjobListResponse](docs/PlatformfinetuningjobListResponse.md)
 - [PlatformfinetuningjobResponse](docs/PlatformfinetuningjobResponse.md)
 - [PresignedUploadFile](docs/PresignedUploadFile.md)
 - [PresignedUploadFileRequest](docs/PresignedUploadFileRequest.md)
 - [ProductAutoscalerFlag](docs/ProductAutoscalerFlag.md)
 - [ProductType](docs/ProductType.md)
 - [ProductautoscalerflagResponse](docs/ProductautoscalerflagResponse.md)
 - [ProductionJob](docs/ProductionJob.md)
 - [ProductionJobConfig](docs/ProductionJobConfig.md)
 - [ProductionJobStateTransition](docs/ProductionJobStateTransition.md)
 - [ProductionjobResponse](docs/ProductionjobResponse.md)
 - [Project](docs/Project.md)
 - [ProjectBase](docs/ProjectBase.md)
 - [ProjectCollaborator](docs/ProjectCollaborator.md)
 - [ProjectCollaboratorValue](docs/ProjectCollaboratorValue.md)
 - [ProjectCollaboratorsPutMessage](docs/ProjectCollaboratorsPutMessage.md)
 - [ProjectCreateMessage](docs/ProjectCreateMessage.md)
 - [ProjectDefaultSessionName](docs/ProjectDefaultSessionName.md)
 - [ProjectDeleteMessage](docs/ProjectDeleteMessage.md)
 - [ProjectListResponse](docs/ProjectListResponse.md)
 - [ProjectPatchMessage](docs/ProjectPatchMessage.md)
 - [ProjectResponse](docs/ProjectResponse.md)
 - [ProjectbaseResponse](docs/ProjectbaseResponse.md)
 - [ProjectcollaboratorListResponse](docs/ProjectcollaboratorListResponse.md)
 - [ProjectdefaultsessionnameResponse](docs/ProjectdefaultsessionnameResponse.md)
 - [ProjectsSortField](docs/ProjectsSortField.md)
 - [ProjectsViolatingTreeHierarchyResponse](docs/ProjectsViolatingTreeHierarchyResponse.md)
 - [ProjectsviolatingtreehierarchyresponseResponse](docs/ProjectsviolatingtreehierarchyresponseResponse.md)
 - [Protocols](docs/Protocols.md)
 - [ProviderMetadata](docs/ProviderMetadata.md)
 - [ProvidermetadataResponse](docs/ProvidermetadataResponse.md)
 - [PythonModules](docs/PythonModules.md)
 - [RayGCSExternalStorageConfig](docs/RayGCSExternalStorageConfig.md)
 - [RayRuntimeEnvConfig](docs/RayRuntimeEnvConfig.md)
 - [ReadBillingVersion](docs/ReadBillingVersion.md)
 - [ReadbillingversionListResponse](docs/ReadbillingversionListResponse.md)
 - [ReplicaDetails](docs/ReplicaDetails.md)
 - [ReplicaState](docs/ReplicaState.md)
 - [RequestEmailMagicLinkResponse](docs/RequestEmailMagicLinkResponse.md)
 - [RequestOTPReturnApiModel](docs/RequestOTPReturnApiModel.md)
 - [RequestPasswordResetParams](docs/RequestPasswordResetParams.md)
 - [RequestemailmagiclinkresponseResponse](docs/RequestemailmagiclinkresponseResponse.md)
 - [RequestotpreturnapimodelResponse](docs/RequestotpreturnapimodelResponse.md)
 - [ResetPasswordParams](docs/ResetPasswordParams.md)
 - [Resources](docs/Resources.md)
 - [ResubmitFTJobRequest](docs/ResubmitFTJobRequest.md)
 - [RollbackServiceModel](docs/RollbackServiceModel.md)
 - [RolloutStrategy](docs/RolloutStrategy.md)
 - [S3DownloadLocation](docs/S3DownloadLocation.md)
 - [SSOLoginInfo](docs/SSOLoginInfo.md)
 - [SUPPORTEDBASEIMAGESENUM](docs/SUPPORTEDBASEIMAGESENUM.md)
 - [ScheduleConfig](docs/ScheduleConfig.md)
 - [ServeDeploymentGrafanaDashboardStatus](docs/ServeDeploymentGrafanaDashboardStatus.md)
 - [ServeDeploymentLogs](docs/ServeDeploymentLogs.md)
 - [ServeDeploymentState](docs/ServeDeploymentState.md)
 - [ServedeploymentlogsResponse](docs/ServedeploymentlogsResponse.md)
 - [ServerSessionToken](docs/ServerSessionToken.md)
 - [ServersessiontokenResponse](docs/ServersessiontokenResponse.md)
 - [ServiceAccount](docs/ServiceAccount.md)
 - [ServiceConfig](docs/ServiceConfig.md)
 - [ServiceEventCurrentState](docs/ServiceEventCurrentState.md)
 - [ServiceEventLevel](docs/ServiceEventLevel.md)
 - [ServiceEventOrigin](docs/ServiceEventOrigin.md)
 - [ServiceEventScope](docs/ServiceEventScope.md)
 - [ServiceEventScopeFilter](docs/ServiceEventScopeFilter.md)
 - [ServiceEventType](docs/ServiceEventType.md)
 - [ServiceEventVerboseMessageModel](docs/ServiceEventVerboseMessageModel.md)
 - [ServiceGoalStates](docs/ServiceGoalStates.md)
 - [ServiceObservabilityUrls](docs/ServiceObservabilityUrls.md)
 - [ServiceSortField](docs/ServiceSortField.md)
 - [ServiceType](docs/ServiceType.md)
 - [ServiceUsage](docs/ServiceUsage.md)
 - [ServiceVersionState](docs/ServiceVersionState.md)
 - [ServiceeventverbosemessagemodelListResponse](docs/ServiceeventverbosemessagemodelListResponse.md)
 - [Session](docs/Session.md)
 - [SessionAccess](docs/SessionAccess.md)
 - [SessionAutosyncSessionsUpdateMessage](docs/SessionAutosyncSessionsUpdateMessage.md)
 - [SessionCommand](docs/SessionCommand.md)
 - [SessionCommandFinishOptions](docs/SessionCommandFinishOptions.md)
 - [SessionCommandId](docs/SessionCommandId.md)
 - [SessionCommandTypes](docs/SessionCommandTypes.md)
 - [SessionCreateMessage](docs/SessionCreateMessage.md)
 - [SessionDeleteMessage](docs/SessionDeleteMessage.md)
 - [SessionDescribe](docs/SessionDescribe.md)
 - [SessionDetails](docs/SessionDetails.md)
 - [SessionEvent](docs/SessionEvent.md)
 - [SessionEventCause](docs/SessionEventCause.md)
 - [SessionEventTypes](docs/SessionEventTypes.md)
 - [SessionExecuteMessage](docs/SessionExecuteMessage.md)
 - [SessionFinishCommandMessage](docs/SessionFinishCommandMessage.md)
 - [SessionHistoryItem](docs/SessionHistoryItem.md)
 - [SessionKillCommandMessage](docs/SessionKillCommandMessage.md)
 - [SessionListResponse](docs/SessionListResponse.md)
 - [SessionPatchMessage](docs/SessionPatchMessage.md)
 - [SessionResponse](docs/SessionResponse.md)
 - [SessionSshKey](docs/SessionSshKey.md)
 - [SessionStartingUpData](docs/SessionStartingUpData.md)
 - [SessionState](docs/SessionState.md)
 - [SessionStateChangeMessage](docs/SessionStateChangeMessage.md)
 - [SessionStateData](docs/SessionStateData.md)
 - [SessionStoppingData](docs/SessionStoppingData.md)
 - [SessioncommandListResponse](docs/SessioncommandListResponse.md)
 - [SessioncommandidResponse](docs/SessioncommandidResponse.md)
 - [SessiondescribeResponse](docs/SessiondescribeResponse.md)
 - [SessiondetailsResponse](docs/SessiondetailsResponse.md)
 - [SessioneventListResponse](docs/SessioneventListResponse.md)
 - [SessionhistoryitemListResponse](docs/SessionhistoryitemListResponse.md)
 - [SessionsSortField](docs/SessionsSortField.md)
 - [SessionsshkeyResponse](docs/SessionsshkeyResponse.md)
 - [SetupInitializeSessionOptions](docs/SetupInitializeSessionOptions.md)
 - [ShowOTPSourceReturnApiModel](docs/ShowOTPSourceReturnApiModel.md)
 - [ShowotpsourcereturnapimodelResponse](docs/ShowotpsourcereturnapimodelResponse.md)
 - [SnapshotCreateMessage](docs/SnapshotCreateMessage.md)
 - [SnapshotDeleteMessage](docs/SnapshotDeleteMessage.md)
 - [SnapshotPatchMessage](docs/SnapshotPatchMessage.md)
 - [SocketMessageSchemas](docs/SocketMessageSchemas.md)
 - [SocketMessageTypes](docs/SocketMessageTypes.md)
 - [SocketmessageschemasResponse](docs/SocketmessageschemasResponse.md)
 - [SocketmessagetypesResponse](docs/SocketmessagetypesResponse.md)
 - [SortOrder](docs/SortOrder.md)
 - [SsologininfoResponse](docs/SsologininfoResponse.md)
 - [StartSessionOptions](docs/StartSessionOptions.md)
 - [StopSessionOptions](docs/StopSessionOptions.md)
 - [StreamPublishRequest](docs/StreamPublishRequest.md)
 - [StripeCheckoutSessionURLResponse](docs/StripeCheckoutSessionURLResponse.md)
 - [SubnetIdWithAvailabilityZoneAWS](docs/SubnetIdWithAvailabilityZoneAWS.md)
 - [SupportRequestsQuery](docs/SupportRequestsQuery.md)
 - [TemplatizedComputeConfigs](docs/TemplatizedComputeConfigs.md)
 - [TemplatizedDecoratedApplicationTemplates](docs/TemplatizedDecoratedApplicationTemplates.md)
 - [TemplatizedcomputeconfigsResponse](docs/TemplatizedcomputeconfigsResponse.md)
 - [TemplatizeddecoratedapplicationtemplatesResponse](docs/TemplatizeddecoratedapplicationtemplatesResponse.md)
 - [TextQuery](docs/TextQuery.md)
 - [TimestampedLogsOutput](docs/TimestampedLogsOutput.md)
 - [TimestampedlogsoutputResponse](docs/TimestampedlogsoutputResponse.md)
 - [Tool](docs/Tool.md)
 - [TryLoginEmailResponse](docs/TryLoginEmailResponse.md)
 - [TryloginemailresponseResponse](docs/TryloginemailresponseResponse.md)
 - [UnifiedJobSortField](docs/UnifiedJobSortField.md)
 - [UnifiedJobStatus](docs/UnifiedJobStatus.md)
 - [UnifiedJobType](docs/UnifiedJobType.md)
 - [UpdateCloudWithCloudResource](docs/UpdateCloudWithCloudResource.md)
 - [UpdateCloudWithCloudResourceGCP](docs/UpdateCloudWithCloudResourceGCP.md)
 - [UpdateClusterDns](docs/UpdateClusterDns.md)
 - [UpdateComputeTemplate](docs/UpdateComputeTemplate.md)
 - [UpdateComputeTemplateConfig](docs/UpdateComputeTemplateConfig.md)
 - [UpdateEndpoint](docs/UpdateEndpoint.md)
 - [UpdateModelDeployment](docs/UpdateModelDeployment.md)
 - [UpdateOrganizationCollaborator](docs/UpdateOrganizationCollaborator.md)
 - [UpdateProjectCollaborator](docs/UpdateProjectCollaborator.md)
 - [UploadSessionCommandLogsLocations](docs/UploadSessionCommandLogsLocations.md)
 - [UploadsessioncommandlogslocationsResponse](docs/UploadsessioncommandlogslocationsResponse.md)
 - [UserInfo](docs/UserInfo.md)
 - [UserResendEmailOptions](docs/UserResendEmailOptions.md)
 - [UserServiceAccessTypes](docs/UserServiceAccessTypes.md)
 - [UserinfoResponse](docs/UserinfoResponse.md)
 - [ValidateOTPParamsApiModel](docs/ValidateOTPParamsApiModel.md)
 - [ValidationError](docs/ValidationError.md)
 - [VerifyResponse](docs/VerifyResponse.md)
 - [VerifyresponseResponse](docs/VerifyresponseResponse.md)
 - [Visibility](docs/Visibility.md)
 - [WaitlistStatusType](docs/WaitlistStatusType.md)
 - [WandBRunDetails](docs/WandBRunDetails.md)
 - [WebTerminal](docs/WebTerminal.md)
 - [WebterminalListResponse](docs/WebterminalListResponse.md)
 - [WebterminalResponse](docs/WebterminalResponse.md)
 - [WorkerNodeType](docs/WorkerNodeType.md)
 - [WorkspaceDataplaneArtifact](docs/WorkspaceDataplaneArtifact.md)
 - [WorkspaceDataplaneArtifacts](docs/WorkspaceDataplaneArtifacts.md)
 - [WorkspaceDataplaneProxiedArtifacts](docs/WorkspaceDataplaneProxiedArtifacts.md)
 - [WorkspaceEvent](docs/WorkspaceEvent.md)
 - [WorkspaceEventSource](docs/WorkspaceEventSource.md)
 - [WorkspaceEventSourceFilter](docs/WorkspaceEventSourceFilter.md)
 - [WorkspaceReadme](docs/WorkspaceReadme.md)
 - [WorkspaceSnapshotStates](docs/WorkspaceSnapshotStates.md)
 - [WorkspaceTemplate](docs/WorkspaceTemplate.md)
 - [WorkspaceTemplateClusterEnvironmentMetadata](docs/WorkspaceTemplateClusterEnvironmentMetadata.md)
 - [WorkspacedataplaneartifactsResponse](docs/WorkspacedataplaneartifactsResponse.md)
 - [WorkspacedataplaneproxiedartifactsResponse](docs/WorkspacedataplaneproxiedartifactsResponse.md)
 - [WorkspaceeventListResponse](docs/WorkspaceeventListResponse.md)
 - [WorkspacereadmeResponse](docs/WorkspacereadmeResponse.md)
 - [WorkspacetemplateListResponse](docs/WorkspacetemplateListResponse.md)
 - [WorkspacetemplateclusterenvironmentmetadataResponse](docs/WorkspacetemplateclusterenvironmentmetadataResponse.md)
 - [WriteCloud](docs/WriteCloud.md)
 - [WriteClusterConfig](docs/WriteClusterConfig.md)
 - [WriteProject](docs/WriteProject.md)
 - [WriteSession](docs/WriteSession.md)
 - [WriteSupportRequest](docs/WriteSupportRequest.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




