import logging
from typing import Any, Optional, Dict, List, Tuple
from .model.agent_card import AgentCard

class AgentResolver:
    def __init__(self):
        pass

    async def resolve(
        self,
        arguments: Optional[Dict[str, Any]] = None,
        agents: Optional[List[AgentCard]] = None
    ) -> Tuple[Optional[AgentCard], Optional[str]]:
        if agents is None or len(agents) == 0:
            logging.error('The agents list is empty!')
            # Return a default AgentCard and empty string to match the return type
            return (None, "")
        if arguments is None or len(arguments) == 0:
            logging.warning('The arguments is empty!')
        agent = agents[0]
        tool_name = None
        return (agent, tool_name)
