from typing import List, Optional, Any
from pydantic import BaseModel


class Skill(BaseModel):
    name: str
    description: str


class Provider(BaseModel):
    name: str
    url: str

class Authentication(BaseModel):
    auth_method: str
    header: Optional[str]
    secret: Optional[str]

from typing import ClassVar

class AgentCard(BaseModel):
    TYPE_A2A: ClassVar[str] = 'type_a2a'
    TYPE_MCP: ClassVar[str] = 'type_mcp'
    TYPE_LLM: ClassVar[str] = 'type_llm'
    url: str
    id: str
    name: str
    org_id: Optional[str] = None
    alias: Optional[str] = None
    type: Optional[str] = None
    authentication: Optional[Authentication] = None
    tag: Optional[str] = None
    github: Optional[str] = None
    skills: Optional[List[Skill]] = None
    tools: Optional[List[Any]] = None
    status: Optional[str] = None
    version: Optional[str] = None
    examples: Optional[List[str]] = None
    provider: Optional[Provider] = None
    description: Optional[str] = None
    lastRelease: Optional[str] = None
    availability: Optional[str] = None
    monthlyCalls: Optional[str] = None
    documentation: Optional[str] = None
