from dataclasses import dataclass, field, asdict
from typing import Any, Optional, Dict
from datetime import datetime
import uuid

@dataclass
class Message:
    sender: str
    receiver: str
    role: str
    model: str
    content: Any
    created_at: str = field(default_factory=lambda: datetime.utcnow().isoformat())
    message_id: str = field(default_factory=lambda: str(uuid.uuid4()))
    metadata: dict[str, Any] = field(default_factory=dict)
    agent_id: Optional[str] = None
    agent_name: Optional[str] = None

    # def to_dict(self) -> dict:
    #     return {"sender": self.sender, "receiver": self.receiver, "role": self.role, "model": self.model, "content": self.content, "created_at": self.created_at}

    # def __str__(self):
    #     return f"Message(sender={self.sender}, receiver={self.receiver}, role={self.role}, model={self.model}, content={self.content}, created_at={self.created_at})"

    # def __repr__(self):
    #     return str(self)