
If you wish to customize the claims contained in web tokens which are
generated by the `SimpleJWTDefaultController` and `SimpleJWTSlidingController`
views, create a subclass for the desired controller as well as a subclass for
its corresponding serializer. Here\'s an example :

``` {.sourceCode .python}
from ninja_jwt.schema import TokenObtainPairSerializer
from ninja_jwt.controller import TokenObtainPairController, router, route
from ninja_schema import Schema


class UserSchema(Schema):
    first_name: str
    email: str
    
    
class MyTokenObtainPairOutSchema(Schema):
    refresh: str
    access: str
    user: UserSchema


class MyTokenObtainPairSchema(TokenObtainPairSerializer):
    def output_schema(self):
        out_dict = self.dict(exclude={"password"})
        out_dict.update(user=UserSchema.from_orm(self._user))
        return MyTokenObtainPairOutSchema(**out_dict)

@router('/token', tags=['Auth'])
class MyTokenObtainPairController(TokenObtainPairController):
    @route.post(
        "/pair", response=schema.MyTokenObtainPairOutSchema, url_name="token_obtain_pair"
    )
    def obtain_token(self, user_token: MyTokenObtainPairSchema):
        return user_token.output_schema()
    
```

As with the standard controller, you\'ll also need to include register the controller as shown in `getting_started`

#### Use Django Ninja Router
If you interested in using functions rather than classes, then you are also covered.
Here is an example

``` {.sourceCode .python}
from ninja import router
from ninja_schema import Schema

router = router('/token')

@router.post(
    "/pair", response=schema.MyTokenObtainPairOutSchema, url_name="token_obtain_pair"
)
def obtain_token(self, user_token: MyTokenObtainPairSchema):
    return user_token.output_schema()
```

Register the `router` to the django-ninja `api` like so:
``` {.sourceCode .python}
from ninja import NinjaAPI

api = NinjaAPI()
api.add_router('', tags=['Auth'], router=router)
```