# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddAITemplateRequest(TeaModel):
    def __init__(self, template_config=None, template_name=None, template_type=None):
        # The detailed configurations of the AI template. The value must be a JSON string. For more information, see [AITemplateConfig](~~89863#title-vd3-499-o36~~).
        self.template_config = template_config  # type: str
        # The name of the AI template. The name can be up to 128 bytes in length.
        self.template_name = template_name  # type: str
        # The type of the AI template. Valid values:
        # 
        # *   **AIMediaAudit**: automated review
        # *   **AIImage**: smart thumbnail
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAITemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class AddAITemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAITemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddAITemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAITemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAITemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAITemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCategoryRequest(TeaModel):
    def __init__(self, cate_name=None, parent_id=None, type=None):
        # The name of the category.
        # 
        # - The value can be up to 64 bytes in length.
        # - The string must be encoded in the UTF-8 format.
        self.cate_name = cate_name  # type: str
        # The ID of the parent category. If you do not set this parameter, a level 1 category is generated by default. The parent category ID of a level 1 category is **-1**.
        # 
        # > Level 1 material categories are built in the system and cannot be changed. If you set the Type parameter to material, you must set the ParentId parameter.
        self.parent_id = parent_id  # type: long
        # The type of the category. Valid values:
        # 
        # - **default** (default): default category
        # - **material**: material category
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBodyCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, type=None):
        # The ID of the video category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        # 
        # - The value can be up to 64 bytes in length.
        # - The string must be encoded in the UTF-8 format.
        self.cate_name = cate_name  # type: str
        # The level of the category. A value of **0** indicates a level 1 category.
        self.level = level  # type: long
        # The ID of the parent category. The parent category ID of a level 1 category is **-1**.
        self.parent_id = parent_id  # type: long
        # The type of the category. Valid values:
        # 
        # - **default** (default): default category
        # - **material**: material category
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCategoryResponseBodyCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBody(TeaModel):
    def __init__(self, category=None, request_id=None):
        # The information about the video category.
        self.category = category  # type: AddCategoryResponseBodyCategory
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.category:
            self.category.validate()

    def to_map(self):
        _map = super(AddCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = AddCategoryResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCategoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCategoryResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEditingProjectRequest(TeaModel):
    def __init__(self, cover_url=None, description=None, division=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, timeline=None, title=None):
        # The thumbnail URL of the online editing project. If you do not specify this parameter and the video track in the timeline has mezzanine files, the thumbnail of the first mezzanine file in the timeline is used.
        self.cover_url = cover_url  # type: str
        # The description of the online editing project.
        self.description = description  # type: str
        # The region where you want to create the online editing project.
        self.division = division  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str
        # The timeline of the online editing project, in JSON format. For more information about the structure, see [Timeline](~~52839~~).
        # 
        # If you do not specify this parameter, an empty timeline is created and the duration of the online editing project is zero.
        self.timeline = timeline  # type: str
        # The title of the online editing project.
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.division is not None:
            result['Division'] = self.division
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Division') is not None:
            self.division = m.get('Division')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class AddEditingProjectResponseBodyProject(TeaModel):
    def __init__(self, creation_time=None, description=None, modified_time=None, project_id=None, status=None,
                 title=None):
        # The time when the online editing project was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the online editing project.
        self.description = description  # type: str
        # The last time when the online editing project was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modified_time = modified_time  # type: str
        # The ID of the online editing project.
        self.project_id = project_id  # type: str
        # The status of the online editing project. Valid values:
        # 
        # - **Normal**: indicates that the online editing project is in draft.
        # - **Producing**: indicates that the video is being produced.
        # - **Produced**: indicates that the video was produced.
        # - **ProduceFailed**: indicates that the video failed to be produced.
        self.status = status  # type: str
        # The title of the online editing project.
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectResponseBodyProject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class AddEditingProjectResponseBody(TeaModel):
    def __init__(self, project=None, request_id=None):
        # The information about the online editing project. For more information about the structure, see [EditingProject](~~52839~~).
        self.project = project  # type: AddEditingProjectResponseBodyProject
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super(AddEditingProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = AddEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddEditingProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddEditingProjectResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddEditingProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, material_ids=None, material_type=None, owner_account=None, owner_id=None, project_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.material_ids = material_ids  # type: str
        self.material_type = material_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.project_id = project_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_ids is not None:
            result['MaterialIds'] = self.material_ids
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialIds') is not None:
            self.material_ids = m.get('MaterialIds')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddEditingProjectMaterialsResponseBodyMaterialList(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, cover_url=None, create_time=None, customer_id=None,
                 description=None, duration=None, material_id=None, material_type=None, modify_time=None, size=None,
                 snapshots=None, sprite_config=None, sprites=None, status=None, tags=None, title=None):
        self.cate_id = cate_id  # type: int
        self.cate_name = cate_name  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.customer_id = customer_id  # type: long
        self.description = description  # type: str
        self.duration = duration  # type: float
        self.material_id = material_id  # type: str
        self.material_type = material_type  # type: str
        self.modify_time = modify_time  # type: str
        self.size = size  # type: long
        self.snapshots = snapshots  # type: list[str]
        self.sprite_config = sprite_config  # type: str
        self.sprites = sprites  # type: list[str]
        self.status = status  # type: str
        self.tags = tags  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyMaterialList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.customer_id is not None:
            result['CustomerId'] = self.customer_id
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.sprite_config is not None:
            result['SpriteConfig'] = self.sprite_config
        if self.sprites is not None:
            result['Sprites'] = self.sprites
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CustomerId') is not None:
            self.customer_id = m.get('CustomerId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('SpriteConfig') is not None:
            self.sprite_config = m.get('SpriteConfig')
        if m.get('Sprites') is not None:
            self.sprites = m.get('Sprites')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class AddEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, material_list=None, request_id=None):
        self.material_list = material_list  # type: list[AddEditingProjectMaterialsResponseBodyMaterialList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.material_list:
            for k in self.material_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MaterialList'] = []
        if self.material_list is not None:
            for k in self.material_list:
                result['MaterialList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.material_list = []
        if m.get('MaterialList') is not None:
            for k in m.get('MaterialList'):
                temp_model = AddEditingProjectMaterialsResponseBodyMaterialList()
                self.material_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddEditingProjectMaterialsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTranscodeTemplateGroupRequest(TeaModel):
    def __init__(self, app_id=None, name=None, transcode_template_group_id=None, transcode_template_list=None):
        # The application ID. Default value: **app-1000000**. For more information, see [Use the multi-application service](~~113600~~).
        self.app_id = app_id  # type: str
        # The name of the transcoding template group.
        # 
        # *   The name can be up to 128 bytes in length.
        # *   The value must be encoded in UTF-8.
        # 
        # > You must specify TranscodeTemplateGroupId or Name in the request.
        self.name = name  # type: str
        # The ID of the transcoding template group. If a transcoding template group ID is specified, you can add transcoding templates to the template group.
        # 
        # > You must specify TranscodeTemplateGroupId or Name in the request.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The configurations of the transcoding template. The value is a string in JSON format. For more information about the data structure, see [TranscodeTemplate](~~52839~~).
        # 
        # > *   If you do not specify this parameter, the transcoding job cannot be automatically created after you upload a video.
        # > *   If you do not need to set Width or Height, do not specify the corresponding parameter. You cannot set the value to an empty string, such as "Height":"".
        self.transcode_template_list = transcode_template_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTranscodeTemplateGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.name is not None:
            result['Name'] = self.name
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        if self.transcode_template_list is not None:
            result['TranscodeTemplateList'] = self.transcode_template_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        if m.get('TranscodeTemplateList') is not None:
            self.transcode_template_list = m.get('TranscodeTemplateList')
        return self


class AddTranscodeTemplateGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_template_group_id=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTranscodeTemplateGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        return self


class AddTranscodeTemplateGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTranscodeTemplateGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTranscodeTemplateGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTranscodeTemplateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVodDomainRequest(TeaModel):
    def __init__(self, check_url=None, domain_name=None, owner_account=None, owner_id=None, scope=None,
                 security_token=None, sources=None, top_level_domain=None):
        # The URL that is used for health checks.
        self.check_url = check_url  # type: str
        # The domain name that you want to accelerate. Wildcard domain names that start with periods (.) are supported. Example: .example.com.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # This parameter is applicable to users of level 3 or higher in the Chinese mainland and users outside the Chinese mainland. Default value: domestic. Valid values:
        # 
        # *   **domestic**: Chinese mainland
        # *   **overseas**: outside the Chinese mainland
        # *   **global**: regions in and outside the Chinese mainland
        self.scope = scope  # type: str
        self.security_token = security_token  # type: str
        # The information about the addresses of origin servers. For more information, see the **Sources** table in this topic.
        self.sources = sources  # type: str
        # The top-level domain.
        self.top_level_domain = top_level_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sources is not None:
            result['Sources'] = self.sources
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Sources') is not None:
            self.sources = m.get('Sources')
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddVodDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVodDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddVodDomainResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddVodDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVodDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVodStorageForAppRequest(TeaModel):
    def __init__(self, app_id=None, storage_location=None, storage_type=None):
        # The IDs of applications. You can obtain the application ID from the `AppId` parameter in the response to the [CreateAppInfo](~~CreateAppInfo~~) or [ListAppInfo](~~ListAppInfo~~) operation.
        self.app_id = app_id  # type: str
        # The address of an Object Storage Service (OSS) bucket. This parameter does not take effect. You can call this operation to add only VOD buckets.
        self.storage_location = storage_location  # type: str
        # The storage class. Default value: **vod_oss_bucket**.
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodStorageForAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class AddVodStorageForAppResponseBody(TeaModel):
    def __init__(self, request_id=None, storage_location=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The address of the VOD bucket.
        self.storage_location = storage_location  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodStorageForAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        return self


class AddVodStorageForAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddVodStorageForAppResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddVodStorageForAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVodStorageForAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVodTemplateRequest(TeaModel):
    def __init__(self, app_id=None, name=None, template_config=None, template_type=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Multi-application service](~~113600~~).
        self.app_id = app_id  # type: str
        # The name of the template.
        # 
        # *   The name cannot exceed 128 bytes.
        # *   The value must be encoded in UTF-8.
        self.name = name  # type: str
        # The configurations of the snapshot template. The value must be a JSON string. For more information about the data structure, see [SnapshotTemplateConfig](~~98618~~).
        self.template_config = template_config  # type: str
        # The type of the template. Set the value to **Snapshot**.
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class AddVodTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, vod_template_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the snapshot template. You can call the [SubmitSnapshotJob](~~72213~~) operation to submit snapshot jobs.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVodTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class AddVodTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddVodTemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddVodTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVodTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWatermarkRequest(TeaModel):
    def __init__(self, app_id=None, file_url=None, name=None, type=None, watermark_config=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The Object Storage Service (OSS) URL of the watermark file. This parameter is required if you add image watermarks.
        self.file_url = file_url  # type: str
        # The name of the watermark. The name can contain only letters and digits.
        # 
        # *   The name can be up to 128 bytes in length.
        # *   The value must be encoded in UTF-8.
        self.name = name  # type: str
        # The type of the watermark. Valid values:
        # 
        # *   **Image** (default)
        # *   **Text**\
        self.type = type  # type: str
        # The configurations such as the position and effect of the text watermark or image watermark. The value must be a JSON string.
        # 
        # > The value of this parameter varies based on the watermark type. For more information about the data structure, see [WatermarkConfig](~~98618~~).
        self.watermark_config = watermark_config  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.watermark_config is not None:
            result['WatermarkConfig'] = self.watermark_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WatermarkConfig') is not None:
            self.watermark_config = m.get('WatermarkConfig')
        return self


class AddWatermarkResponseBodyWatermarkInfo(TeaModel):
    def __init__(self, creation_time=None, file_url=None, is_default=None, name=None, type=None,
                 watermark_config=None, watermark_id=None):
        # The time when the watermark was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The OSS URL or Alibaba Cloud CDN URL of the watermark file. This parameter does not apply to text watermarks.
        self.file_url = file_url  # type: str
        # Indicates whether the default watermark was used. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # The name of the watermark.
        self.name = name  # type: str
        # The type of the watermark. Valid values:
        # 
        # *   **Image** (default)
        # *   **Text**\
        self.type = type  # type: str
        # The configurations such as the position and effect of the text watermark or image watermark. The value is a JSON string.
        # 
        # > The value of this parameter varies based on the watermark type. For more information about the data structure, see [WatermarkConfig](~~98618~~).
        self.watermark_config = watermark_config  # type: str
        # The ID of the watermark.
        self.watermark_id = watermark_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWatermarkResponseBodyWatermarkInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.watermark_config is not None:
            result['WatermarkConfig'] = self.watermark_config
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WatermarkConfig') is not None:
            self.watermark_config = m.get('WatermarkConfig')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        return self


class AddWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None, watermark_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the watermark.
        self.watermark_info = watermark_info  # type: AddWatermarkResponseBodyWatermarkInfo

    def validate(self):
        if self.watermark_info:
            self.watermark_info.validate()

    def to_map(self):
        _map = super(AddWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.watermark_info is not None:
            result['WatermarkInfo'] = self.watermark_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WatermarkInfo') is not None:
            temp_model = AddWatermarkResponseBodyWatermarkInfo()
            self.watermark_info = temp_model.from_map(m['WatermarkInfo'])
        return self


class AddWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddWatermarkResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachAppPolicyToIdentityRequest(TeaModel):
    def __init__(self, app_id=None, identity_name=None, identity_type=None, policy_names=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Multi-application service](~~113600~~).
        # 
        # > This parameter is optional only if you set the policy name to VODAppAdministratorAccess.
        self.app_id = app_id  # type: str
        # The ID of the RAM user or the name of the RAM role.
        # 
        # *   Specify the ID of the RAM user when the IdentityType parameter is set to RamUser.
        # *   Specify the name of the RAM role when the IdentityType parameter is set to RamRole.
        self.identity_name = identity_name  # type: str
        # The type of the identity. Valid values:
        # 
        # *   **RamUser**: a RAM user
        # *   **RamRole**: a RAM role
        self.identity_type = identity_type  # type: str
        # The name of the policy. Only system policies are supported. Separate multiple policy names with commas (,). Valid values:
        # 
        # *   **VODAppFullAccess**: permissions to manage all resources in an application.
        # *   **VODAppReadOnlyAccess**: permissions to read all resources in an application.
        # *   **VODAppAdministratorAccess**: permissions of the application administrator.
        self.policy_names = policy_names  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachAppPolicyToIdentityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.identity_name is not None:
            result['IdentityName'] = self.identity_name
        if self.identity_type is not None:
            result['IdentityType'] = self.identity_type
        if self.policy_names is not None:
            result['PolicyNames'] = self.policy_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('IdentityName') is not None:
            self.identity_name = m.get('IdentityName')
        if m.get('IdentityType') is not None:
            self.identity_type = m.get('IdentityType')
        if m.get('PolicyNames') is not None:
            self.policy_names = m.get('PolicyNames')
        return self


class AttachAppPolicyToIdentityResponseBody(TeaModel):
    def __init__(self, failed_policy_names=None, non_exist_policy_names=None, request_id=None):
        # The names of the policies that failed to be granted to the RAM user or RAM role.
        self.failed_policy_names = failed_policy_names  # type: list[str]
        # The names of the policies that were not found.
        self.non_exist_policy_names = non_exist_policy_names  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachAppPolicyToIdentityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_policy_names is not None:
            result['FailedPolicyNames'] = self.failed_policy_names
        if self.non_exist_policy_names is not None:
            result['NonExistPolicyNames'] = self.non_exist_policy_names
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedPolicyNames') is not None:
            self.failed_policy_names = m.get('FailedPolicyNames')
        if m.get('NonExistPolicyNames') is not None:
            self.non_exist_policy_names = m.get('NonExistPolicyNames')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachAppPolicyToIdentityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachAppPolicyToIdentityResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachAppPolicyToIdentityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachAppPolicyToIdentityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetVodDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, functions=None, owner_account=None, owner_id=None, security_token=None):
        # The domain name for CDN. Separate multiple domain names with commas (,).
        self.domain_names = domain_names  # type: str
        # The features to configure.
        # 
        # *   Set this parameter in the following format: `[{"functionArgs":[{"argName":"domain_name","argValue":"www.example.com"}],"functionName":"set_req_host_header"}]`.
        # *   Specific features, such as filetype_based_ttl_set, support more than one configuration record. To update one of the configuration records, use the configId field to specify the record. `[{"functionArgs":[{"argName":"file_type","argValue":"jpg"},{"argName":"ttl","argValue":"18"},{"argName":"weight","argValue":"30"}],"functionName":"filetype_based_ttl_set","configId":5068995}]`
        # *   For more information, see the **Feature description** section.
        self.functions = functions  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetVodDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetVodDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetVodDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetVodDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetVodDomainConfigsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetVodDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetVodDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchStartVodDomainRequest(TeaModel):
    def __init__(self, domain_names=None, owner_id=None, security_token=None):
        # The accelerated domain name. Separate multiple domain names with commas (,).
        self.domain_names = domain_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchStartVodDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchStartVodDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchStartVodDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchStartVodDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchStartVodDomainResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchStartVodDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchStartVodDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchStopVodDomainRequest(TeaModel):
    def __init__(self, domain_names=None, owner_id=None, security_token=None):
        # The accelerated domain name. Separate multiple domain names with commas (,).
        self.domain_names = domain_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchStopVodDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchStopVodDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchStopVodDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchStopVodDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchStopVodDomainResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchStopVodDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchStopVodDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelUrlUploadJobsRequest(TeaModel):
    def __init__(self, job_ids=None, upload_urls=None):
        # The IDs of the upload jobs. You can obtain the job IDs from PlayInfo in the response to the [GetPlayInfo](~~56124~~) operation.
        # 
        # *   You can specify a maximum of 10 IDs.
        # *   Separate multiple IDs with commas (,).
        # 
        # >  You must specify either JobIds or UploadUrls. If you specify both the JobIds and UploadUrls parameters, only the value of the JobIds parameter takes effect.
        self.job_ids = job_ids  # type: str
        # The upload URLs of source video files. Separate multiple URLs with commas (,). You can specify a maximum of 10 URLs.
        # 
        # > *   You must encode the URLs before you use the URLs.
        # > *   You must specify either JobIds or UploadUrls. If you specify both the JobIds and UploadUrls parameters, only the value of the JobIds parameter takes effect.
        self.upload_urls = upload_urls  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelUrlUploadJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.upload_urls is not None:
            result['UploadUrls'] = self.upload_urls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('UploadUrls') is not None:
            self.upload_urls = m.get('UploadUrls')
        return self


class CancelUrlUploadJobsResponseBody(TeaModel):
    def __init__(self, canceled_jobs=None, non_exists=None, request_id=None):
        # The IDs of canceled jobs.
        self.canceled_jobs = canceled_jobs  # type: list[str]
        # The jobs that do not exist.
        self.non_exists = non_exists  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelUrlUploadJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.canceled_jobs is not None:
            result['CanceledJobs'] = self.canceled_jobs
        if self.non_exists is not None:
            result['NonExists'] = self.non_exists
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanceledJobs') is not None:
            self.canceled_jobs = m.get('CanceledJobs')
        if m.get('NonExists') is not None:
            self.non_exists = m.get('NonExists')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelUrlUploadJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelUrlUploadJobsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelUrlUploadJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelUrlUploadJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAppInfoRequest(TeaModel):
    def __init__(self, app_name=None, description=None):
        # The name of the application. The application name must be unique.
        # 
        # *   The name can contain letters, digits, periods (.), hyphens (-), and at signs (@). The name can be up to 128 characters in length.
        # *   The value must be encoded in UTF-8.
        self.app_name = app_name  # type: str
        # The description of the application.
        # 
        # *   The description can contain up to 512 characters in length.
        # *   The value must be encoded in UTF-8.
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAppInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateAppInfoResponseBody(TeaModel):
    def __init__(self, app_id=None, request_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAppInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAppInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAppInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAppInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAppInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAuditRequest(TeaModel):
    def __init__(self, audit_content=None):
        # The review content. You can specify up to **100** audio or video files in a request. The value must be converted to a string.\
        # For more information about this parameter, see the **AuditContent** section of this topic.
        self.audit_content = audit_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAuditRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit_content is not None:
            result['AuditContent'] = self.audit_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuditContent') is not None:
            self.audit_content = m.get('AuditContent')
        return self


class CreateAuditResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAuditResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAuditResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAuditResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAuditResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadAttachedMediaRequest(TeaModel):
    def __init__(self, app_id=None, business_type=None, cate_ids=None, description=None, file_name=None,
                 file_size=None, media_ext=None, storage_location=None, tags=None, title=None, user_data=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The type of the media asset. Valid values:
        # 
        # *   **watermark**\
        # *   **subtitle**\
        # *   **material**\
        self.business_type = business_type  # type: str
        # The one or more category IDs of the auxiliary media asset. Separate multiple category IDs with commas (,). A maximum of five category IDs can be specified. You can use one of the following methods to obtain the category ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Categories**. On the Categories page, you can view the category ID.
        # *   View the value of the CateId parameter returned by the [AddCategory](~~56401~~) operation that you called to create a category.
        # *   View the value of the CateId parameter returned by the [GetCategories](~~56406~~) operation that you called to query a category.
        self.cate_ids = cate_ids  # type: str
        # The description of the auxiliary media asset. Take note of the following items:
        # 
        # *   The description can be up to 1,024 bytes in length.
        # *   The value must be encoded in UTF-8.
        self.description = description  # type: str
        # The name of the source file.
        self.file_name = file_name  # type: str
        # The size of the auxiliary media asset. Unit: byte.
        self.file_size = file_size  # type: str
        # The file name extension. Valid values:
        # 
        # *   Valid values for watermarks: **png, gif, apng, and mov**\
        # *   Valid values for subtitles: **srt, ass, stl, ttml, and vtt**\
        # *   Valid values for materials: **jpg, gif, png, mp4, mat, zip, and apk**\
        self.media_ext = media_ext  # type: str
        # The storage location. You can use one of the following methods to obtain the storage location:
        # 
        # Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Storage**. On the Storage page, you can view the storage location.
        # 
        # >  If this parameter is set to a specific value, the auxiliary media asset is uploaded to the specified storage location.
        self.storage_location = storage_location  # type: str
        # The one or more tags of the auxiliary media asset. Take note of the following items:
        # 
        # *   You can specify a maximum of 16 tags.
        # *   If you need to specify multiple tags, separate the tags with commas (,).
        # *   Each tag can be up to 32 characters in length.
        # *   The value must be encoded in UTF-8.
        self.tags = tags  # type: str
        # The title of the media asset. Take note of the following items:
        # 
        # *   The title can be up to 128 bytes in length.
        # *   The value must be encoded in UTF-8.
        self.title = title  # type: str
        # The custom configurations, including callback configurations and upload acceleration configurations. The value is a JSON string. For more information, see the "UserData: specifies the custom configurations for media upload" section of the [Request parameters](~~86952~~) topic.
        # 
        # > *   The callback configurations take effect only after you specify the HTTP callback URL and select the specific callback events in the ApsaraVideo VOD console. For more information about how to configure an HTTP callback in the ApsaraVideo VOD console, see [Configure callback settings](~~86071~~).
        # >*   To use the upload acceleration feature, submit a [ticket](https://ticket-intl.console.aliyun.com/#/ticket/createIndex) to enable this feature. For more information, see [Overview](~~55396~~).
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadAttachedMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_ids is not None:
            result['CateIds'] = self.cate_ids
        if self.description is not None:
            result['Description'] = self.description
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.media_ext is not None:
            result['MediaExt'] = self.media_ext
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateIds') is not None:
            self.cate_ids = m.get('CateIds')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('MediaExt') is not None:
            self.media_ext = m.get('MediaExt')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadAttachedMediaResponseBody(TeaModel):
    def __init__(self, file_url=None, media_id=None, media_url=None, request_id=None, upload_address=None,
                 upload_auth=None):
        # The OSS URL of the file. The URL does not contain the information used for URL signing. You can set the FileUrl parameter to this URL when you call the [AddWatermark](~~98617~~) operation.
        self.file_url = file_url  # type: str
        # The ID of the auxiliary media asset.
        self.media_id = media_id  # type: str
        # The URL of the auxiliary media asset. If a domain name for Alibaba Cloud CDN (CDN) is specified, a CDN URL is returned. Otherwise, an OSS URL is returned.
        # 
        # >  If you enable the URL signing feature of ApsaraVideo VOD, you may be unable to access the returned URL of the auxiliary media asset by using a browser and the HTTP status code 403 may be returned. You can disable the [URL signing](~~86090~~) feature or [generate an authentication signature](~~57007~~).
        self.media_url = media_url  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The upload URL.
        # 
        # >  The upload URL returned by this operation is Base64-encoded. Before you can use an SDK or an API operation to upload a media asset based on the upload URL, you must decode the upload URL by using the Base64 algorithm. You must parse the upload URL only if you use native OSS SDKs or OSS API for uploads.
        self.upload_address = upload_address  # type: str
        # The upload credential.
        # 
        # >  The upload credential returned by this operation is Base64-encoded. Before you can use an SDK or an API operation to upload a media asset based on the upload credential, you must decode the upload credential by using the Base64 algorithm. You must parse the upload credential only if you use native OSS SDKs or OSS API for uploads.
        self.upload_auth = upload_auth  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadAttachedMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadAttachedMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUploadAttachedMediaResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUploadAttachedMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadAttachedMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadImageRequest(TeaModel):
    def __init__(self, app_id=None, cate_id=None, description=None, image_ext=None, image_type=None,
                 original_file_name=None, storage_location=None, tags=None, title=None, user_data=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The category ID of the image. You can use one of the following methods to obtain the category ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Categories**. On the Categories page, you can view the category ID of the image.
        # *   Obtain the value of CateId from the response to the [AddCategory](~~56401~~) operation.
        # *   Obtain the value of CateId from the response to the [GetCategories](~~56406~~) operation.
        self.cate_id = cate_id  # type: long
        # The description of the image.
        # 
        # *   The description can be up to 1,024 characters in length.
        # *   The value must be encoded in UTF-8.
        self.description = description  # type: str
        # The file name extension of the image. Valid values:
        # 
        # *   **png** (default)
        # *   **jpg**\
        # *   **jpeg**\
        # *   **gif**\
        self.image_ext = image_ext  # type: str
        # The type of the image. Valid values:
        # 
        # *   **default**: the default image type.
        # *   **cover**: the thumbnail.
        # 
        # > You can manage only images of the **default** type in the ApsaraVideo VOD console.
        self.image_type = image_type  # type: str
        # The name of the source file.
        # 
        # > The name must contain a file name extension. The file name extension is not case-sensitive.
        self.original_file_name = original_file_name  # type: str
        # The storage address. Perform the following operations to obtain the storage address: Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Storage**. On the Storage page, view the storage address.
        # 
        # > If you specify a storage address, media files are uploaded to the specified address.
        self.storage_location = storage_location  # type: str
        # The tags of the image. The following rules apply:
        # 
        # *   Each tag can be up to 32 characters in length.
        # *   You can specify a maximum of 16 tags for an image.
        # *   Separate multiple tags with commas (,).
        # *   The value must be encoded in UTF-8.
        self.tags = tags  # type: str
        # The title of the image. The following rules apply:
        # 
        # *   The title can be up to 128 characters in length.
        # *   The value must be encoded in UTF-8.
        self.title = title  # type: str
        # The custom configurations, including callback configurations and upload acceleration configurations. The value must be a JSON string. For more information, see the "UserData: specifies the custom configurations for media upload" section of the [Request parameters](~~86952~~) topic.
        # 
        # > *   The callback configurations take effect only after you specify the HTTP callback URL and select specific callback events in the ApsaraVideo VOD console. For more information about how to configure HTTP callback settings in the ApsaraVideo VOD console, see [Configure callback settings](~~86071~~).
        # >*   If you want to enable the upload acceleration feature, [submit a request on Yida](https://yida.alibaba-inc.com/o/ticketapply). For more information, see [Overview](~~55396~~).
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.description is not None:
            result['Description'] = self.description
        if self.image_ext is not None:
            result['ImageExt'] = self.image_ext
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.original_file_name is not None:
            result['OriginalFileName'] = self.original_file_name
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageExt') is not None:
            self.image_ext = m.get('ImageExt')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('OriginalFileName') is not None:
            self.original_file_name = m.get('OriginalFileName')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadImageResponseBody(TeaModel):
    def __init__(self, file_url=None, image_id=None, image_url=None, request_id=None, upload_address=None,
                 upload_auth=None):
        # The OSS URL of the file. The URL does not contain the information used for URL signing. You can specify FileUrl when you call the [AddWatermark](~~98617~~) operation.
        self.file_url = file_url  # type: str
        # The ID of the image file.
        self.image_id = image_id  # type: str
        # The URL of the image.
        # 
        # > If the returned URL is inaccessible from a browser and the HTTP 403 status code is returned, the URL signing feature in ApsaraVideo VOD is enabled. To resolve this issue, you can disable the [URL signing](~~86090~~) feature or [generate a signed URL](~~57007~~).
        self.image_url = image_url  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The upload URL.
        # 
        # > The returned upload URL is a Base64-encoded URL. You must decode the Base64-encoded URL before you use an SDK or call an API operation to upload auxiliary media assets. You need to parse UploadAddress only if you use the OSS SDK or call an OSS API operation to upload auxiliary media assets.
        self.upload_address = upload_address  # type: str
        # The upload credential.
        # 
        # > The returned upload credential is a Base64-encoded value. You must decode the Base64-encoded credential before you use an SDK or call an API operation to upload auxiliary media assets. You need to parse UploadAuth only if you use the OSS SDK or call an OSS API operation to upload auxiliary media assets.
        self.upload_auth = upload_auth  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_url is not None:
            result['ImageURL'] = self.image_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageURL') is not None:
            self.image_url = m.get('ImageURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUploadImageResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUploadImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadVideoRequest(TeaModel):
    def __init__(self, app_id=None, cate_id=None, cover_url=None, description=None, file_name=None, file_size=None,
                 storage_location=None, tags=None, template_group_id=None, title=None, user_data=None, workflow_id=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The category ID of the media file. You can use one of the following methods to obtain the category ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Categories** to view the category ID of the media file.
        # *   Obtain the value of CateId from the response to the [AddCategory](~~56401~~) operation.
        # *   Obtain the value of CateId from the response to the [GetCategories](~~56406~~) operation.
        self.cate_id = cate_id  # type: long
        # The URL of the custom video thumbnail.
        self.cover_url = cover_url  # type: str
        # The description of the audio or video file.
        # 
        # *   The value can be up to 1,024 characters in length.
        # *   The value must be encoded in UTF-8.
        self.description = description  # type: str
        # The name of the audio or video file.
        # 
        # *   The name must contain a file name extension, which is not case-sensitive.
        # *   For more information about file name extensions supported by ApsaraVideo VOD, see [Overview](~~55396~~).
        self.file_name = file_name  # type: str
        # The size of the audio or video file. Unit: bytes.
        self.file_size = file_size  # type: long
        # The storage address. To obtain the storage address, log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Storage**.
        # 
        # > If you specify a storage address, media files are uploaded to the specified address.
        self.storage_location = storage_location  # type: str
        # The tags of the audio or video file.
        # 
        # *   You can specify a maximum of 16 tags.
        # *   If you want to specify multiple tags, separate the tags with commas (,).
        # *   Each tag can be up to 32 characters in length.
        # *   The value must be encoded in UTF-8.
        self.tags = tags  # type: str
        # The ID of the transcoding template group. You can use one of the following methods to obtain the ID of the transcoding template group:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Processing** > **Transcoding Template Groups** to view the ID of the transcoding template group.
        # *   Obtain the value of TranscodeTemplateGroupId in the response to the [AddTranscodeTemplateGroup](~~102665~~) operation.
        # *   Obtain the value of TranscodeTemplateGroupId in the response to the [ListTranscodeTemplateGroup](~~102669~~) operation.
        # 
        # > If you leave this parameter empty, the default transcoding template group is used. If you specify this parameter, the specified transcoding template group is used for transcoding.
        self.template_group_id = template_group_id  # type: str
        # The title of the audio or video file.
        # 
        # *   The title can be up to 128 characters in length.
        # *   The value must be encoded in UTF-8.
        self.title = title  # type: str
        # The custom configurations such as callback configurations and upload acceleration configurations. The value must be a JSON string. For more information, see [Request parameters](~~86952~~).
        # 
        # > *   The callback configurations take effect only after you specify the HTTP callback URL and select specific callback events in the ApsaraVideo VOD console. For more information about how to configure HTTP callback settings in the ApsaraVideo VOD console, see [Configure callback settings](~~86071~~).
        # >*   If you want to enable the upload acceleration feature, [submit a request on Yida](https://yida.alibaba-inc.com/o/ticketapply). For more information, see [Overview](~~55396~~).
        self.user_data = user_data  # type: str
        # The ID of the workflow. To view the ID of the workflow, log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Processing** > **Workflows**.
        # 
        # > If you specify the WorkflowId and TemplateGroupId parameters, the value of the WorkflowId parameter takes effect. For more information, see [Workflows](~~115347~~).
        self.workflow_id = workflow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadVideoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.template_group_id is not None:
            result['TemplateGroupId'] = self.template_group_id
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.workflow_id is not None:
            result['WorkflowId'] = self.workflow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TemplateGroupId') is not None:
            self.template_group_id = m.get('TemplateGroupId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('WorkflowId') is not None:
            self.workflow_id = m.get('WorkflowId')
        return self


class CreateUploadVideoResponseBody(TeaModel):
    def __init__(self, request_id=None, upload_address=None, upload_auth=None, video_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The upload URL.
        # 
        # > The returned upload URL is a Base64-encoded URL. You must decode the Base64-encoded URL before you use an SDK or call an API operation to upload media files. You need to parse UploadAddress only if you use the Object Storage Service (OSS) SDK or call an OSS API operation to upload media files.
        self.upload_address = upload_address  # type: str
        # The upload credential.
        # 
        # > The returned upload credential is a Base64-encoded value. You must decode the Base64-encoded credential before you use an SDK or call an API operation to upload media files. You need to parse UploadAuth only if you use the OSS SDK or call an OSS API operation to upload media files.
        self.upload_auth = upload_auth  # type: str
        # The ID of the audio or video file. VideoId can be used as a request parameter when you call an operation for media asset management, media processing, or media review.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadVideoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class CreateUploadVideoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUploadVideoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUploadVideoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadVideoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecryptKMSDataKeyRequest(TeaModel):
    def __init__(self, cipher_text=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.cipher_text = cipher_text  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DecryptKMSDataKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cipher_text is not None:
            result['CipherText'] = self.cipher_text
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CipherText') is not None:
            self.cipher_text = m.get('CipherText')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DecryptKMSDataKeyResponseBody(TeaModel):
    def __init__(self, key_id=None, plaintext=None, request_id=None):
        self.key_id = key_id  # type: str
        self.plaintext = plaintext  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DecryptKMSDataKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DecryptKMSDataKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DecryptKMSDataKeyResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DecryptKMSDataKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DecryptKMSDataKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAIImageInfosRequest(TeaModel):
    def __init__(self, aiimage_info_ids=None):
        # The IDs of the images that are submitted for AI processing. You can obtain the value of AIImageInfoId from the response to the [ListAIImageInfo](~~ListAIImageInfo~~) operation.
        # 
        # - You can specify a maximum of 10 IDs.
        # - Separate multiple IDs with commas (,).
        self.aiimage_info_ids = aiimage_info_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAIImageInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiimage_info_ids is not None:
            result['AIImageInfoIds'] = self.aiimage_info_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIImageInfoIds') is not None:
            self.aiimage_info_ids = m.get('AIImageInfoIds')
        return self


class DeleteAIImageInfosResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAIImageInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAIImageInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAIImageInfosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAIImageInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAIImageInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAITemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        # The ID of the AI template. You can use one of the following methods to obtain the ID of the AI template:
        # 
        # *   Call the [AddAITemplate](~~102930~~) operation to add an AI template if no AI template exists. The value of TemplateId in the response is the ID of the AI template.
        # *   Call the [ListAITemplate](~~102936~~) operation if the template already exists. The value of TemplateId in the response is the ID of the AI template.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAITemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteAITemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAITemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteAITemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAITemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAITemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAITemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAppInfoRequest(TeaModel):
    def __init__(self, app_id=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAppInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteAppInfoResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAppInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAppInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAppInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAppInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAppInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAttachedMediaRequest(TeaModel):
    def __init__(self, media_ids=None):
        # The list of auxiliary media asset IDs.
        # 
        # *   Separate multiple IDs with commas (,).
        # *   A maximum of 20 IDs can be specified.
        self.media_ids = media_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAttachedMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class DeleteAttachedMediaResponseBody(TeaModel):
    def __init__(self, non_exist_media_ids=None, request_id=None):
        # The ID of the auxiliary media asset that failed to be deleted.
        self.non_exist_media_ids = non_exist_media_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAttachedMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_media_ids is not None:
            result['NonExistMediaIds'] = self.non_exist_media_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExistMediaIds') is not None:
            self.non_exist_media_ids = m.get('NonExistMediaIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAttachedMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAttachedMediaResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAttachedMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAttachedMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCategoryRequest(TeaModel):
    def __init__(self, cate_id=None):
        # The ID of the category.
        self.cate_id = cate_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        return self


class DeleteCategoryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCategoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCategoryResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDynamicImageRequest(TeaModel):
    def __init__(self, dynamic_image_ids=None, video_id=None):
        # The IDs of the animated stickers.
        # 
        # - Separate multiple IDs with commas (,). You can specify a maximum of 10 IDs.
        # - If you do not set this parameter, the system finds the video specified by the VideoId parameter and deletes the information about the animated stickers associated with the video. If more than 10 animated stickers are associated with the video specified by the VideoId parameter, the deletion request is denied.
        self.dynamic_image_ids = dynamic_image_ids  # type: str
        # The ID of the video associated with the animated stickers whose information you want to delete.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDynamicImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_image_ids is not None:
            result['DynamicImageIds'] = self.dynamic_image_ids
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicImageIds') is not None:
            self.dynamic_image_ids = m.get('DynamicImageIds')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DeleteDynamicImageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDynamicImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDynamicImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDynamicImageResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDynamicImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDynamicImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, project_ids=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        # The ID of the online editing project. Separate multiple IDs with commas (,).
        self.project_ids = project_ids  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteEditingProjectResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEditingProjectResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEditingProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, material_ids=None, material_type=None, owner_account=None, owner_id=None, project_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.material_ids = material_ids  # type: str
        self.material_type = material_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.project_id = project_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_ids is not None:
            result['MaterialIds'] = self.material_ids
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialIds') is not None:
            self.material_ids = m.get('MaterialIds')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEditingProjectMaterialsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageRequest(TeaModel):
    def __init__(self, delete_image_type=None, image_ids=None, image_type=None, image_urls=None, video_id=None):
        # The method that is used to delete images. Valid values:
        # 
        # *   **ImageURL**: deletes images based on URLs.
        # *   **ImageId**: deletes images based on image IDs.
        # *   **VideoId**: deletes images associated with a video based on the video ID.
        self.delete_image_type = delete_image_type  # type: str
        # The ID of the image file. You can specify multiple image IDs. Separate multiple IDs with commas (,). You can use one of the following methods to obtain the image ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Media Files** > **Image** to view the image ID. This method is applicable to images that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of the ImageId parameter from the response to the [CreateUploadImage](~~55619~~) operation.
        # *   Obtain the value of the ImageId parameter from the response to the [SearchMedia](~~86044~~) operation after you upload images.
        # 
        # > This parameter is required only if you set **DeleteImageType** to **ImageId**.
        self.image_ids = image_ids  # type: str
        # The type of images that you want to delete. The images are associated with the video. This parameter is required only if you set **DeleteImageType** to **VideoId**. Valid values:
        # 
        # *   **CoverSnapshot**: thumbnail snapshot.
        # *   **NormalSnapshot**: normal snapshot.
        # *   **SpriteSnapshot**: sprite snapshot.
        # *   **SpriteOriginSnapshot**: sprite source snapshot.
        # *   **All**: images of all the preceding types. If this parameter is not set to All, you can specify multiple types and separate the types with commas (,).
        self.image_type = image_type  # type: str
        # The URL of the image. You can obtain the value of ImageURL from the response to the [CreateUploadImage](~~55619~~) operation. You can specify multiple URLs. Separate multiple URLs with commas (,).
        # 
        # > This parameter is required only if you set **DeleteImageType** to **ImageURL**.
        self.image_urls = image_urls  # type: str
        # The ID of the video file. You can use one of the following methods to obtain the video ID:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the media file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of the VideoId parameter from the response to the [CreateUploadVideo](~~55407~~) operation.
        # *   Obtain the value of the VideoId parameter from the response to the [SearchMedia](~~86044~~) operation after you upload media files.
        # 
        # > This parameter is required only if you set **DeleteImageType** to **VideoId**.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_image_type is not None:
            result['DeleteImageType'] = self.delete_image_type
        if self.image_ids is not None:
            result['ImageIds'] = self.image_ids
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.image_urls is not None:
            result['ImageURLs'] = self.image_urls
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeleteImageType') is not None:
            self.delete_image_type = m.get('DeleteImageType')
        if m.get('ImageIds') is not None:
            self.image_ids = m.get('ImageIds')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('ImageURLs') is not None:
            self.image_urls = m.get('ImageURLs')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DeleteImageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteImageResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMessageCallbackRequest(TeaModel):
    def __init__(self, app_id=None, owner_account=None):
        # The ID of the application. If you do not set this parameter, the default value **app-1000000** is used.
        self.app_id = app_id  # type: str
        self.owner_account = owner_account  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMessageCallbackRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteMessageCallbackResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMessageCallbackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMessageCallbackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMessageCallbackResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMessageCallbackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMessageCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMezzaninesRequest(TeaModel):
    def __init__(self, force=None, video_ids=None):
        # Specifies whether to forcibly delete the source file. Valid values:
        # 
        # *   **false** (default)
        # *   **true**\
        # 
        # >  If a video is uploaded without transcoding or is asynchronously transcoded, the source file of the video is used for original-quality playback. By default, the source file of the video cannot be deleted. To forcibly delete the mezzanine file, set this parameter to **true**.
        self.force = force  # type: bool
        # The IDs of audio or video files whose source files that you want to delete. You can specify up to 20 IDs. Separate multiple IDs with commas (,). You can use one of the following methods to obtain the ID:
        # 
        # *   After you upload a video in the [ApsaraVideo VOD console](https://vod.console.aliyun.com), you can log on to the ApsaraVideo VOD console and choose **Media Files** > **Audio/Video** to view the ID of the video.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you called to obtain the upload URL and credential.
        # *   Obtain the value of VideoId from the response to the [SearchMedia](~~86044~~) operation that you called to query media information after the audio or video file is uploaded.
        self.video_ids = video_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMezzaninesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.video_ids is not None:
            result['VideoIds'] = self.video_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('VideoIds') is not None:
            self.video_ids = m.get('VideoIds')
        return self


class DeleteMezzaninesResponseBody(TeaModel):
    def __init__(self, non_exist_video_ids=None, request_id=None, un_removeable_video_ids=None):
        # The IDs of the audio or video files that do not exist.
        self.non_exist_video_ids = non_exist_video_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The IDs of the audio or video files whose source files cannot be deleted.
        # 
        # >  In most cases, source files cannot be deleted if they are used for original-quality playback or you do not have required permissions to delete them. For more information, see [Overview](~~113600~~).
        self.un_removeable_video_ids = un_removeable_video_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMezzaninesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_video_ids is not None:
            result['NonExistVideoIds'] = self.non_exist_video_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.un_removeable_video_ids is not None:
            result['UnRemoveableVideoIds'] = self.un_removeable_video_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExistVideoIds') is not None:
            self.non_exist_video_ids = m.get('NonExistVideoIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UnRemoveableVideoIds') is not None:
            self.un_removeable_video_ids = m.get('UnRemoveableVideoIds')
        return self


class DeleteMezzaninesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMezzaninesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMezzaninesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMezzaninesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMultipartUploadRequest(TeaModel):
    def __init__(self, media_id=None, media_type=None, owner_account=None):
        # The ID of the media file (VideoId). You can use one of the following methods to obtain the ID:
        # 
        # *   After you upload a video in the [ApsaraVideo VOD console](https://vod.console.aliyun.com), you can log on to the ApsaraVideo VOD console and choose **Media Files** > **Audio/Video** to view the ID of the video.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you called to obtain the upload URL and credential.
        # *   Obtain the value of VideoId from the response to the [SearchMedia](~~86044~~) operation that you called to query media information after the audio or video file is uploaded.
        self.media_id = media_id  # type: str
        # The type of the media file. Set the value to **video**. video indicates audio and video files.
        self.media_type = media_type  # type: str
        self.owner_account = owner_account  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMultipartUploadRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteMultipartUploadResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMultipartUploadResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMultipartUploadResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMultipartUploadResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMultipartUploadResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMultipartUploadResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStreamRequest(TeaModel):
    def __init__(self, job_ids=None, video_id=None):
        # The job IDs for deleting media streams.
        # 
        # *   Separate multiple IDs with commas (,). A maximum of 20 IDs can be specified for one video.
        # *   You can obtain job IDs from the PlayInfo parameter that is returned after you call the [GetPlayInfo](~~56124~~) operation. Each media stream has a unique job ID.
        self.job_ids = job_ids  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStreamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DeleteStreamResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStreamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStreamResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStreamResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStreamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTranscodeTemplateGroupRequest(TeaModel):
    def __init__(self, force_del_group=None, transcode_template_group_id=None, transcode_template_ids=None):
        # Specifies whether to forcibly delete the transcoding template group. Valid values:
        # 
        # *   **true**: deletes the transcoding template group and all the transcoding templates in the group.
        # *   **false** (default): deletes only the specified transcoding templates from the transcoding template group.
        self.force_del_group = force_del_group  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The IDs of the transcoding templates that you want to delete.
        # 
        # *   Separate multiple IDs with commas (,).
        # *   You can specify a maximum of 10 IDs.
        # *   This parameter is required if you set ForceDelGroup to false or leave ForceDelGroup empty.
        self.transcode_template_ids = transcode_template_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTranscodeTemplateGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_del_group is not None:
            result['ForceDelGroup'] = self.force_del_group
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        if self.transcode_template_ids is not None:
            result['TranscodeTemplateIds'] = self.transcode_template_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForceDelGroup') is not None:
            self.force_del_group = m.get('ForceDelGroup')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        if m.get('TranscodeTemplateIds') is not None:
            self.transcode_template_ids = m.get('TranscodeTemplateIds')
        return self


class DeleteTranscodeTemplateGroupResponseBody(TeaModel):
    def __init__(self, non_exist_transcode_template_ids=None, request_id=None):
        # The IDs of transcoding templates that were not found.
        self.non_exist_transcode_template_ids = non_exist_transcode_template_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTranscodeTemplateGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_transcode_template_ids is not None:
            result['NonExistTranscodeTemplateIds'] = self.non_exist_transcode_template_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExistTranscodeTemplateIds') is not None:
            self.non_exist_transcode_template_ids = m.get('NonExistTranscodeTemplateIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTranscodeTemplateGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTranscodeTemplateGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTranscodeTemplateGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTranscodeTemplateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVideoRequest(TeaModel):
    def __init__(self, video_ids=None):
        # The list of video IDs. Separate multiple IDs with commas (,). A maximum of 20 IDs can be specified. You can obtain a video ID in one of the following ways:
        # 
        # *   If the video is uploaded by using the [ApsaraVideo VOD console](https://vod.console.aliyun.com), log on to the console and choose **Media Files** > **Audio/Video** to view the ID of the video.
        # *   If the video is uploaded by calling the [CreateUploadVideo](~~55407~~) operation, the video ID is the VideoId value in the response.
        # *   You can also call the [SearchMedia](~~86044~~) operation to obtain the video ID, which is the VideoId value in the response.
        self.video_ids = video_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVideoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_ids is not None:
            result['VideoIds'] = self.video_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoIds') is not None:
            self.video_ids = m.get('VideoIds')
        return self


class DeleteVideoResponseBody(TeaModel):
    def __init__(self, forbidden_video_ids=None, non_exist_video_ids=None, request_id=None):
        # The IDs of the videos that cannot be deleted.
        # > Generally, videos cannot be deleted if you do not have the required [permissions](~~113600~~).
        self.forbidden_video_ids = forbidden_video_ids  # type: list[str]
        # The IDs of the videos that do not exist.
        # > If the list of videos to be deleted contains one or more videos that do not exist, the IDs of these non-existing videos are returned. If none of the videos in the list exists, a 404 error is returned.
        self.non_exist_video_ids = non_exist_video_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVideoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_video_ids is not None:
            result['ForbiddenVideoIds'] = self.forbidden_video_ids
        if self.non_exist_video_ids is not None:
            result['NonExistVideoIds'] = self.non_exist_video_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForbiddenVideoIds') is not None:
            self.forbidden_video_ids = m.get('ForbiddenVideoIds')
        if m.get('NonExistVideoIds') is not None:
            self.non_exist_video_ids = m.get('NonExistVideoIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVideoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVideoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVideoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVideoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodDomainRequest(TeaModel):
    def __init__(self, domain_name=None, owner_account=None, owner_id=None, security_token=None):
        # The domain name for CDN that you want to delete.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteVodDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVodDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVodDomainResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVodDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodSpecificConfigRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, env=None, owner_id=None, security_token=None):
        # The ID of the configuration.
        self.config_id = config_id  # type: str
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        # The environment of configuration. 
        # 
        # Value:
        # 
        # online: production environment
        # 
        # gray: simulation environment
        self.env = env  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodSpecificConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.env is not None:
            result['Env'] = self.env
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Env') is not None:
            self.env = m.get('Env')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteVodSpecificConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodSpecificConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVodSpecificConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVodSpecificConfigResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVodSpecificConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodSpecificConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodTemplateRequest(TeaModel):
    def __init__(self, vod_template_id=None):
        # The ID of the snapshot template.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class DeleteVodTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, vod_template_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the snapshot template.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVodTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class DeleteVodTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVodTemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVodTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWatermarkRequest(TeaModel):
    def __init__(self, watermark_id=None):
        # The ID of the watermark.
        self.watermark_id = watermark_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        return self


class DeleteWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWatermarkResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayTopVideosRequest(TeaModel):
    def __init__(self, biz_date=None, owner_id=None, page_no=None, page_size=None):
        # The time to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.biz_date = biz_date  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_no = page_no  # type: long
        # The number of entries to return on each page. Default value: **100**. Maximum value: **1000**.
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayTopVideosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePlayTopVideosResponseBodyTopPlayVideosTopPlayVideoStatis(TeaModel):
    def __init__(self, play_duration=None, title=None, uv=None, vv=None, video_id=None):
        # The playback duration. Unit: milliseconds.
        self.play_duration = play_duration  # type: str
        # The title of the video.
        self.title = title  # type: str
        # The number of unique visitors.
        self.uv = uv  # type: str
        # The number of video views.
        self.vv = vv  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayTopVideosResponseBodyTopPlayVideosTopPlayVideoStatis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.title is not None:
            result['Title'] = self.title
        if self.uv is not None:
            result['UV'] = self.uv
        if self.vv is not None:
            result['VV'] = self.vv
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UV') is not None:
            self.uv = m.get('UV')
        if m.get('VV') is not None:
            self.vv = m.get('VV')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DescribePlayTopVideosResponseBodyTopPlayVideos(TeaModel):
    def __init__(self, top_play_video_statis=None):
        self.top_play_video_statis = top_play_video_statis  # type: list[DescribePlayTopVideosResponseBodyTopPlayVideosTopPlayVideoStatis]

    def validate(self):
        if self.top_play_video_statis:
            for k in self.top_play_video_statis:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayTopVideosResponseBodyTopPlayVideos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TopPlayVideoStatis'] = []
        if self.top_play_video_statis is not None:
            for k in self.top_play_video_statis:
                result['TopPlayVideoStatis'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.top_play_video_statis = []
        if m.get('TopPlayVideoStatis') is not None:
            for k in m.get('TopPlayVideoStatis'):
                temp_model = DescribePlayTopVideosResponseBodyTopPlayVideosTopPlayVideoStatis()
                self.top_play_video_statis.append(temp_model.from_map(k))
        return self


class DescribePlayTopVideosResponseBody(TeaModel):
    def __init__(self, page_no=None, page_size=None, request_id=None, top_play_videos=None, total_num=None):
        # The page number of the returned page.
        self.page_no = page_no  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The daily playback statistics on each top video.
        self.top_play_videos = top_play_videos  # type: DescribePlayTopVideosResponseBodyTopPlayVideos
        # The total number of entries that were collected in playback statistics on top videos.
        self.total_num = total_num  # type: long

    def validate(self):
        if self.top_play_videos:
            self.top_play_videos.validate()

    def to_map(self):
        _map = super(DescribePlayTopVideosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.top_play_videos is not None:
            result['TopPlayVideos'] = self.top_play_videos.to_map()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TopPlayVideos') is not None:
            temp_model = DescribePlayTopVideosResponseBodyTopPlayVideos()
            self.top_play_videos = temp_model.from_map(m['TopPlayVideos'])
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribePlayTopVideosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayTopVideosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayTopVideosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayTopVideosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayUserAvgRequest(TeaModel):
    def __init__(self, end_time=None, owner_id=None, start_time=None):
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayUserAvgRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribePlayUserAvgResponseBodyUserPlayStatisAvgsUserPlayStatisAvg(TeaModel):
    def __init__(self, avg_play_count=None, avg_play_duration=None, date=None):
        # The average number of video views.
        self.avg_play_count = avg_play_count  # type: str
        # The average playback duration. Unit: milliseconds.
        self.avg_play_duration = avg_play_duration  # type: str
        # The date when the statistics were generated. The date follows the *yyyy-MM-dd* format.
        self.date = date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayUserAvgResponseBodyUserPlayStatisAvgsUserPlayStatisAvg, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_play_count is not None:
            result['AvgPlayCount'] = self.avg_play_count
        if self.avg_play_duration is not None:
            result['AvgPlayDuration'] = self.avg_play_duration
        if self.date is not None:
            result['Date'] = self.date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgPlayCount') is not None:
            self.avg_play_count = m.get('AvgPlayCount')
        if m.get('AvgPlayDuration') is not None:
            self.avg_play_duration = m.get('AvgPlayDuration')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        return self


class DescribePlayUserAvgResponseBodyUserPlayStatisAvgs(TeaModel):
    def __init__(self, user_play_statis_avg=None):
        self.user_play_statis_avg = user_play_statis_avg  # type: list[DescribePlayUserAvgResponseBodyUserPlayStatisAvgsUserPlayStatisAvg]

    def validate(self):
        if self.user_play_statis_avg:
            for k in self.user_play_statis_avg:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayUserAvgResponseBodyUserPlayStatisAvgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UserPlayStatisAvg'] = []
        if self.user_play_statis_avg is not None:
            for k in self.user_play_statis_avg:
                result['UserPlayStatisAvg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user_play_statis_avg = []
        if m.get('UserPlayStatisAvg') is not None:
            for k in m.get('UserPlayStatisAvg'):
                temp_model = DescribePlayUserAvgResponseBodyUserPlayStatisAvgsUserPlayStatisAvg()
                self.user_play_statis_avg.append(temp_model.from_map(k))
        return self


class DescribePlayUserAvgResponseBody(TeaModel):
    def __init__(self, request_id=None, user_play_statis_avgs=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The statistics on average playback each day.
        self.user_play_statis_avgs = user_play_statis_avgs  # type: DescribePlayUserAvgResponseBodyUserPlayStatisAvgs

    def validate(self):
        if self.user_play_statis_avgs:
            self.user_play_statis_avgs.validate()

    def to_map(self):
        _map = super(DescribePlayUserAvgResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_play_statis_avgs is not None:
            result['UserPlayStatisAvgs'] = self.user_play_statis_avgs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserPlayStatisAvgs') is not None:
            temp_model = DescribePlayUserAvgResponseBodyUserPlayStatisAvgs()
            self.user_play_statis_avgs = temp_model.from_map(m['UserPlayStatisAvgs'])
        return self


class DescribePlayUserAvgResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayUserAvgResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayUserAvgResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayUserAvgResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayUserTotalRequest(TeaModel):
    def __init__(self, end_time=None, owner_id=None, start_time=None):
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayUserTotalRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalUV(TeaModel):
    def __init__(self, android=None, flash=None, html5=None, i_os=None):
        # The total number of unique visitors who use ApsaraVideo Player SDK for Android.
        self.android = android  # type: str
        # The total number of unique visitors who use the Flash player.
        self.flash = flash  # type: str
        # The total number of unique visitors who use the HTML5 player.
        self.html5 = html5  # type: str
        # The total number of unique visitors who use ApsaraVideo Player SDK for iOS.
        self.i_os = i_os  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalUV, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.android is not None:
            result['Android'] = self.android
        if self.flash is not None:
            result['Flash'] = self.flash
        if self.html5 is not None:
            result['HTML5'] = self.html5
        if self.i_os is not None:
            result['iOS'] = self.i_os
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Android') is not None:
            self.android = m.get('Android')
        if m.get('Flash') is not None:
            self.flash = m.get('Flash')
        if m.get('HTML5') is not None:
            self.html5 = m.get('HTML5')
        if m.get('iOS') is not None:
            self.i_os = m.get('iOS')
        return self


class DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalVV(TeaModel):
    def __init__(self, android=None, flash=None, html5=None, i_os=None):
        # The total number of video views played by using ApsaraVideo Player SDK for Android.
        self.android = android  # type: str
        # The total number of video views played by using the Flash player.
        self.flash = flash  # type: str
        # The total number of video views played by using the HTML5 player.
        self.html5 = html5  # type: str
        # The total number of video views played by using ApsaraVideo Player SDK for iOS.
        self.i_os = i_os  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalVV, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.android is not None:
            result['Android'] = self.android
        if self.flash is not None:
            result['Flash'] = self.flash
        if self.html5 is not None:
            result['HTML5'] = self.html5
        if self.i_os is not None:
            result['iOS'] = self.i_os
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Android') is not None:
            self.android = m.get('Android')
        if m.get('Flash') is not None:
            self.flash = m.get('Flash')
        if m.get('HTML5') is not None:
            self.html5 = m.get('HTML5')
        if m.get('iOS') is not None:
            self.i_os = m.get('iOS')
        return self


class DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotal(TeaModel):
    def __init__(self, date=None, play_duration=None, play_range=None, uv=None, vv=None):
        # The date. The date is displayed in the *yyyy-MM-dd* format.
        self.date = date  # type: str
        # The total playback duration. Unit: milliseconds.
        self.play_duration = play_duration  # type: str
        # The distribution of the playback duration.
        self.play_range = play_range  # type: str
        # The total number of unique visitors.
        self.uv = uv  # type: DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalUV
        # The total number of video views.
        self.vv = vv  # type: DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalVV

    def validate(self):
        if self.uv:
            self.uv.validate()
        if self.vv:
            self.vv.validate()

    def to_map(self):
        _map = super(DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotal, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.play_range is not None:
            result['PlayRange'] = self.play_range
        if self.uv is not None:
            result['UV'] = self.uv.to_map()
        if self.vv is not None:
            result['VV'] = self.vv.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('PlayRange') is not None:
            self.play_range = m.get('PlayRange')
        if m.get('UV') is not None:
            temp_model = DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalUV()
            self.uv = temp_model.from_map(m['UV'])
        if m.get('VV') is not None:
            temp_model = DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotalVV()
            self.vv = temp_model.from_map(m['VV'])
        return self


class DescribePlayUserTotalResponseBodyUserPlayStatisTotals(TeaModel):
    def __init__(self, user_play_statis_total=None):
        self.user_play_statis_total = user_play_statis_total  # type: list[DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotal]

    def validate(self):
        if self.user_play_statis_total:
            for k in self.user_play_statis_total:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayUserTotalResponseBodyUserPlayStatisTotals, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UserPlayStatisTotal'] = []
        if self.user_play_statis_total is not None:
            for k in self.user_play_statis_total:
                result['UserPlayStatisTotal'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user_play_statis_total = []
        if m.get('UserPlayStatisTotal') is not None:
            for k in m.get('UserPlayStatisTotal'):
                temp_model = DescribePlayUserTotalResponseBodyUserPlayStatisTotalsUserPlayStatisTotal()
                self.user_play_statis_total.append(temp_model.from_map(k))
        return self


class DescribePlayUserTotalResponseBody(TeaModel):
    def __init__(self, request_id=None, user_play_statis_totals=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The daily playback statistics.
        self.user_play_statis_totals = user_play_statis_totals  # type: DescribePlayUserTotalResponseBodyUserPlayStatisTotals

    def validate(self):
        if self.user_play_statis_totals:
            self.user_play_statis_totals.validate()

    def to_map(self):
        _map = super(DescribePlayUserTotalResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_play_statis_totals is not None:
            result['UserPlayStatisTotals'] = self.user_play_statis_totals.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserPlayStatisTotals') is not None:
            temp_model = DescribePlayUserTotalResponseBodyUserPlayStatisTotals()
            self.user_play_statis_totals = temp_model.from_map(m['UserPlayStatisTotals'])
        return self


class DescribePlayUserTotalResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayUserTotalResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayUserTotalResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayUserTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayVideoStatisRequest(TeaModel):
    def __init__(self, end_time=None, owner_id=None, start_time=None, video_id=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The video ID.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayVideoStatisRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DescribePlayVideoStatisResponseBodyVideoPlayStatisDetailsVideoPlayStatisDetail(TeaModel):
    def __init__(self, date=None, play_duration=None, play_range=None, title=None, uv=None, vv=None):
        # The date. The date is displayed in the *yyyy-MM-dd* format.
        self.date = date  # type: str
        # The playback duration. Unit: millisecond.
        self.play_duration = play_duration  # type: str
        # The distribution of the playback duration.
        self.play_range = play_range  # type: str
        # The video title.
        self.title = title  # type: str
        # The number of unique visitors.
        self.uv = uv  # type: str
        # The number of video views.
        self.vv = vv  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayVideoStatisResponseBodyVideoPlayStatisDetailsVideoPlayStatisDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.play_range is not None:
            result['PlayRange'] = self.play_range
        if self.title is not None:
            result['Title'] = self.title
        if self.uv is not None:
            result['UV'] = self.uv
        if self.vv is not None:
            result['VV'] = self.vv
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('PlayRange') is not None:
            self.play_range = m.get('PlayRange')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UV') is not None:
            self.uv = m.get('UV')
        if m.get('VV') is not None:
            self.vv = m.get('VV')
        return self


class DescribePlayVideoStatisResponseBodyVideoPlayStatisDetails(TeaModel):
    def __init__(self, video_play_statis_detail=None):
        self.video_play_statis_detail = video_play_statis_detail  # type: list[DescribePlayVideoStatisResponseBodyVideoPlayStatisDetailsVideoPlayStatisDetail]

    def validate(self):
        if self.video_play_statis_detail:
            for k in self.video_play_statis_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayVideoStatisResponseBodyVideoPlayStatisDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoPlayStatisDetail'] = []
        if self.video_play_statis_detail is not None:
            for k in self.video_play_statis_detail:
                result['VideoPlayStatisDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_play_statis_detail = []
        if m.get('VideoPlayStatisDetail') is not None:
            for k in m.get('VideoPlayStatisDetail'):
                temp_model = DescribePlayVideoStatisResponseBodyVideoPlayStatisDetailsVideoPlayStatisDetail()
                self.video_play_statis_detail.append(temp_model.from_map(k))
        return self


class DescribePlayVideoStatisResponseBody(TeaModel):
    def __init__(self, request_id=None, video_play_statis_details=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The daily playback statistics on the video.
        self.video_play_statis_details = video_play_statis_details  # type: DescribePlayVideoStatisResponseBodyVideoPlayStatisDetails

    def validate(self):
        if self.video_play_statis_details:
            self.video_play_statis_details.validate()

    def to_map(self):
        _map = super(DescribePlayVideoStatisResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.video_play_statis_details is not None:
            result['VideoPlayStatisDetails'] = self.video_play_statis_details.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VideoPlayStatisDetails') is not None:
            temp_model = DescribePlayVideoStatisResponseBodyVideoPlayStatisDetails()
            self.video_play_statis_details = temp_model.from_map(m['VideoPlayStatisDetails'])
        return self


class DescribePlayVideoStatisResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayVideoStatisResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayVideoStatisResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayVideoStatisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodAIDataRequest(TeaModel):
    def __init__(self, aitype=None, end_time=None, owner_id=None, region=None, start_time=None):
        # The type of video AI. If you leave this parameter empty, statistics on video AI of all types are returned. Separate multiple types with commas (,). Valid values:
        # 
        # *   **AIVideoCensor**: automated review
        # *   **AIVideoFPShot**: media fingerprinting
        # *   **AIVideoTag**: smart tagging
        self.aitype = aitype  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The region in which you want to query data. If you leave this parameter empty, data in all regions is returned. Separate multiple regions with commas (,). Valid values:
        # 
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-beijing**: China (Beijing)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **ap-southeast-1**: Singapore
        self.region = region  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodAIDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aitype is not None:
            result['AIType'] = self.aitype
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIType') is not None:
            self.aitype = m.get('AIType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodAIDataResponseBodyAIDataAIDataItemDataDataItem(TeaModel):
    def __init__(self, name=None, value=None):
        # The type of video AI. Valid values:
        # 
        # *   **AIVideoCensor**: automated review
        # *   **AIVideoFPShot**: media fingerprinting
        # *   **AIVideoTag**: smart tagging
        self.name = name  # type: str
        # The processing duration. Unit: seconds.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodAIDataResponseBodyAIDataAIDataItemDataDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodAIDataResponseBodyAIDataAIDataItemData(TeaModel):
    def __init__(self, data_item=None):
        self.data_item = data_item  # type: list[DescribeVodAIDataResponseBodyAIDataAIDataItemDataDataItem]

    def validate(self):
        if self.data_item:
            for k in self.data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodAIDataResponseBodyAIDataAIDataItemData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataItem'] = []
        if self.data_item is not None:
            for k in self.data_item:
                result['DataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_item = []
        if m.get('DataItem') is not None:
            for k in m.get('DataItem'):
                temp_model = DescribeVodAIDataResponseBodyAIDataAIDataItemDataDataItem()
                self.data_item.append(temp_model.from_map(k))
        return self


class DescribeVodAIDataResponseBodyAIDataAIDataItem(TeaModel):
    def __init__(self, data=None, time_stamp=None):
        # The statistics on video AI of each type.
        self.data = data  # type: DescribeVodAIDataResponseBodyAIDataAIDataItemData
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeVodAIDataResponseBodyAIDataAIDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeVodAIDataResponseBodyAIDataAIDataItemData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeVodAIDataResponseBodyAIData(TeaModel):
    def __init__(self, aidata_item=None):
        self.aidata_item = aidata_item  # type: list[DescribeVodAIDataResponseBodyAIDataAIDataItem]

    def validate(self):
        if self.aidata_item:
            for k in self.aidata_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodAIDataResponseBodyAIData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AIDataItem'] = []
        if self.aidata_item is not None:
            for k in self.aidata_item:
                result['AIDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aidata_item = []
        if m.get('AIDataItem') is not None:
            for k in m.get('AIDataItem'):
                temp_model = DescribeVodAIDataResponseBodyAIDataAIDataItem()
                self.aidata_item.append(temp_model.from_map(k))
        return self


class DescribeVodAIDataResponseBody(TeaModel):
    def __init__(self, aidata=None, data_interval=None, request_id=None):
        # The statistics on video AI.
        self.aidata = aidata  # type: DescribeVodAIDataResponseBodyAIData
        # The time granularity at which the data was queried. Valid values:
        # 
        # *   **hour**\
        # *   **day**\
        self.data_interval = data_interval  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aidata:
            self.aidata.validate()

    def to_map(self):
        _map = super(DescribeVodAIDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aidata is not None:
            result['AIData'] = self.aidata.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIData') is not None:
            temp_model = DescribeVodAIDataResponseBodyAIData()
            self.aidata = temp_model.from_map(m['AIData'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodAIDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodAIDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodAIDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodAIDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodCertificateListRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodCertificateListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeVodCertificateListResponseBodyCertificateListModelCertListCert(TeaModel):
    def __init__(self, cert_id=None, cert_name=None, common=None, fingerprint=None, issuer=None, last_time=None):
        # The ID of the certificate.
        self.cert_id = cert_id  # type: long
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The common name of the certificate.
        self.common = common  # type: str
        # The fingerprint of the certificate.
        self.fingerprint = fingerprint  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.issuer = issuer  # type: str
        # The time when the certificate was issued. Unit: seconds.
        self.last_time = last_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodCertificateListResponseBodyCertificateListModelCertListCert, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.common is not None:
            result['Common'] = self.common
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Common') is not None:
            self.common = m.get('Common')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        return self


class DescribeVodCertificateListResponseBodyCertificateListModelCertList(TeaModel):
    def __init__(self, cert=None):
        self.cert = cert  # type: list[DescribeVodCertificateListResponseBodyCertificateListModelCertListCert]

    def validate(self):
        if self.cert:
            for k in self.cert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodCertificateListResponseBodyCertificateListModelCertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cert'] = []
        if self.cert is not None:
            for k in self.cert:
                result['Cert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert = []
        if m.get('Cert') is not None:
            for k in m.get('Cert'):
                temp_model = DescribeVodCertificateListResponseBodyCertificateListModelCertListCert()
                self.cert.append(temp_model.from_map(k))
        return self


class DescribeVodCertificateListResponseBodyCertificateListModel(TeaModel):
    def __init__(self, cert_list=None, count=None):
        # The details of each certificate.
        self.cert_list = cert_list  # type: DescribeVodCertificateListResponseBodyCertificateListModelCertList
        # The number of certificates.
        self.count = count  # type: int

    def validate(self):
        if self.cert_list:
            self.cert_list.validate()

    def to_map(self):
        _map = super(DescribeVodCertificateListResponseBodyCertificateListModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_list is not None:
            result['CertList'] = self.cert_list.to_map()
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertList') is not None:
            temp_model = DescribeVodCertificateListResponseBodyCertificateListModelCertList()
            self.cert_list = temp_model.from_map(m['CertList'])
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeVodCertificateListResponseBody(TeaModel):
    def __init__(self, certificate_list_model=None, request_id=None):
        # The information about the returned certificates.
        self.certificate_list_model = certificate_list_model  # type: DescribeVodCertificateListResponseBodyCertificateListModel
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.certificate_list_model:
            self.certificate_list_model.validate()

    def to_map(self):
        _map = super(DescribeVodCertificateListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate_list_model is not None:
            result['CertificateListModel'] = self.certificate_list_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertificateListModel') is not None:
            temp_model = DescribeVodCertificateListResponseBodyCertificateListModel()
            self.certificate_list_model = temp_model.from_map(m['CertificateListModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodCertificateListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodCertificateListResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodCertificateListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodCertificateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        # The domain name to be queried. If you do not specify this parameter, the merged data of all your domain names for CDN is returned. You can specify multiple domain names. Separate them with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The query interval. Unit: seconds. Valid values: **300**, **3600**, and **86400**.
        # 
        # *   If the time range to query is less than 3 days, valid values are **300**, **3600**, and **86400**. The default value is 300.
        # *   If the time range to query is from 3 to less than 31 days, valid values are **3600** and **86400**. The default value is 3600.
        # *   If the time range to query is from 31 to 90 days, the valid value is **86400**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP). If you do not specify this parameter, the data of all ISPs is returned.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region. If you do not specify this parameter, the data in all regions is returned. Only data in the China (Shanghai) region can be queried.
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > The minimum query interval is 5 minutes. If you do not specify this parameter, the data in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, domestic_value=None, https_domestic_value=None, https_overseas_value=None, https_value=None,
                 overseas_value=None, time_stamp=None, value=None):
        # The bandwidth in mainland China. Unit: bit/s. When the bandwidth data is queried by ISP, no value is returned.
        self.domestic_value = domestic_value  # type: str
        # The HTTPS bandwidth on L1 nodes in mainland China. Unit: bit/s. When the bandwidth data is queried by ISP, no value is returned.
        self.https_domestic_value = https_domestic_value  # type: str
        # The HTTPS bandwidth on L1 nodes outside mainland China. Unit: bit/s. When the bandwidth data is queried by ISP, no value is returned.
        self.https_overseas_value = https_overseas_value  # type: str
        # The total HTTPS bandwidth on L1 nodes. Unit: bit/s.
        self.https_value = https_value  # type: str
        # The bandwidth outside mainland China. Unit: bit/s. When the bandwidth data is queried by ISP, no value is returned.
        self.overseas_value = overseas_value  # type: str
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str
        # The bandwidth. Unit: bit/s.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domestic_value is not None:
            result['DomesticValue'] = self.domestic_value
        if self.https_domestic_value is not None:
            result['HttpsDomesticValue'] = self.https_domestic_value
        if self.https_overseas_value is not None:
            result['HttpsOverseasValue'] = self.https_overseas_value
        if self.https_value is not None:
            result['HttpsValue'] = self.https_value
        if self.overseas_value is not None:
            result['OverseasValue'] = self.overseas_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomesticValue') is not None:
            self.domestic_value = m.get('DomesticValue')
        if m.get('HttpsDomesticValue') is not None:
            self.https_domestic_value = m.get('HttpsDomesticValue')
        if m.get('HttpsOverseasValue') is not None:
            self.https_overseas_value = m.get('HttpsOverseasValue')
        if m.get('HttpsValue') is not None:
            self.https_value = m.get('HttpsValue')
        if m.get('OverseasValue') is not None:
            self.overseas_value = m.get('OverseasValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodDomainBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeVodDomainBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeVodDomainBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeVodDomainBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 isp_name_en=None, location_name_en=None, request_id=None, start_time=None):
        # The bandwidth data that is collected for each interval.
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeVodDomainBpsDataResponseBodyBpsDataPerInterval
        # The time interval between the returned entries. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        # The end of the time range in which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The name of the ISP. By default, the data of all ISPs is returned.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region. By default, the data in all regions is returned.
        self.location_name_en = location_name_en  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range in which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeVodDomainBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeVodDomainBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainBpsDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainCertificateInfoRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainCertificateInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeVodDomainCertificateInfoResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(self, cert_domain_name=None, cert_expire_time=None, cert_life=None, cert_name=None, cert_org=None,
                 cert_type=None, domain_name=None, server_certificate_status=None, status=None):
        # The domain name that matches the certificate.
        self.cert_domain_name = cert_domain_name  # type: str
        # The time at which the certificate expires. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.cert_expire_time = cert_expire_time  # type: str
        # The validity period of the certificate. Unit: months or years.
        self.cert_life = cert_life  # type: str
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.cert_org = cert_org  # type: str
        # The type of the certificate. Valid values:
        # 
        # *   **free**: a free certificate.
        # *   **cas**: a certificate that is purchased from Certificate Management Service.
        # *   **upload**: a user-uploaded certificate.
        self.cert_type = cert_type  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # Indicates whether the SSL certificate is enabled.
        # 
        # *   **on**\
        # *   **off**\
        self.server_certificate_status = server_certificate_status  # type: str
        # The status of the certificate. Valid values:
        # 
        # *   **success**: The certificate is in effect.
        # *   **checking**: The system is checking whether the domain name is added to ApsaraVideo VOD.
        # *   **cname_error**: The domain name is not added to ApsaraVideo VOD.
        # *   **domain_invalid**: The domain name contains invalid characters.
        # *   **unsupport_wildcard**: The domain name is a wildcard domain name. Wildcard domain names are not supported.
        # *   **applying**: The certificate application is in progress.
        # *   **failed**: The certificate application failed.
        # 
        # > A value is returned for this parameter only if `free` is returned for `CertType`. If a value other than free is returned for CertType, an empty string is returned for this parameter.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainCertificateInfoResponseBodyCertInfosCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_domain_name is not None:
            result['CertDomainName'] = self.cert_domain_name
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_life is not None:
            result['CertLife'] = self.cert_life
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_org is not None:
            result['CertOrg'] = self.cert_org
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.server_certificate_status is not None:
            result['ServerCertificateStatus'] = self.server_certificate_status
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertDomainName') is not None:
            self.cert_domain_name = m.get('CertDomainName')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertLife') is not None:
            self.cert_life = m.get('CertLife')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertOrg') is not None:
            self.cert_org = m.get('CertOrg')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ServerCertificateStatus') is not None:
            self.server_certificate_status = m.get('ServerCertificateStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeVodDomainCertificateInfoResponseBodyCertInfos(TeaModel):
    def __init__(self, cert_info=None):
        self.cert_info = cert_info  # type: list[DescribeVodDomainCertificateInfoResponseBodyCertInfosCertInfo]

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainCertificateInfoResponseBodyCertInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeVodDomainCertificateInfoResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeVodDomainCertificateInfoResponseBody(TeaModel):
    def __init__(self, cert_infos=None, request_id=None):
        # The certificate information about the domain name.
        self.cert_infos = cert_infos  # type: DescribeVodDomainCertificateInfoResponseBodyCertInfos
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        _map = super(DescribeVodDomainCertificateInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertInfos') is not None:
            temp_model = DescribeVodDomainCertificateInfoResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodDomainCertificateInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainCertificateInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainCertificateInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainCertificateInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainConfigsRequest(TeaModel):
    def __init__(self, domain_name=None, function_names=None, owner_id=None, security_token=None):
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        # The feature name. Separate multiple names with commas (,). For more information, see **Feature description**.
        self.function_names = function_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        # The parameter name.
        self.arg_name = arg_name  # type: str
        # The parameter value.
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs(TeaModel):
    def __init__(self, function_arg=None):
        self.function_arg = function_arg  # type: list[DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg]

    def validate(self):
        if self.function_arg:
            for k in self.function_arg:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FunctionArg'] = []
        if self.function_arg is not None:
            for k in self.function_arg:
                result['FunctionArg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.function_arg = []
        if m.get('FunctionArg') is not None:
            for k in m.get('FunctionArg'):
                temp_model = DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg()
                self.function_arg.append(temp_model.from_map(k))
        return self


class DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfig(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, status=None):
        # The configuration ID.
        self.config_id = config_id  # type: str
        # The feature parameters.
        self.function_args = function_args  # type: DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs
        # The feature name.
        self.function_name = function_name  # type: str
        # The configuration status. Valid values:
        # 
        # *   **success**\
        # *   **testing**\
        # *   **failed**\
        # *   **configuring**\
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            self.function_args.validate()

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.function_args is not None:
            result['FunctionArgs'] = self.function_args.to_map()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('FunctionArgs') is not None:
            temp_model = DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs()
            self.function_args = temp_model.from_map(m['FunctionArgs'])
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeVodDomainConfigsResponseBodyDomainConfigs(TeaModel):
    def __init__(self, domain_config=None):
        self.domain_config = domain_config  # type: list[DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfig]

    def validate(self):
        if self.domain_config:
            for k in self.domain_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfig'] = []
        if self.domain_config is not None:
            for k in self.domain_config:
                result['DomainConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_config = []
        if m.get('DomainConfig') is not None:
            for k in m.get('DomainConfig'):
                temp_model = DescribeVodDomainConfigsResponseBodyDomainConfigsDomainConfig()
                self.domain_config.append(temp_model.from_map(k))
        return self


class DescribeVodDomainConfigsResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        # The configurations of the domain name.
        self.domain_configs = domain_configs  # type: DescribeVodDomainConfigsResponseBodyDomainConfigs
        # The request ID.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            self.domain_configs.validate()

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_configs is not None:
            result['DomainConfigs'] = self.domain_configs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainConfigs') is not None:
            temp_model = DescribeVodDomainConfigsResponseBodyDomainConfigs()
            self.domain_configs = temp_model.from_map(m['DomainConfigs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainConfigsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeVodDomainDetailResponseBodyDomainDetailSourcesSource(TeaModel):
    def __init__(self, content=None, enabled=None, port=None, priority=None, type=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The status of the origin server. Valid values:
        # *   **online**: indicates that the origin server is enabled.
        # *   **offline**: indicates that the origin server is disabled.
        self.enabled = enabled  # type: str
        # The port number. Valid values: 443 and 80.
        self.port = port  # type: int
        # The priority of the origin server.
        self.priority = priority  # type: str
        # The type of the origin server. Valid values:
        # *   **ipaddr**: a server that you can access by using an IP address.
        # *   **domain**: a server that you can access by using a domain name.
        # *   **oss**: the URL of an Object Storage Service (OSS) bucket.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainDetailResponseBodyDomainDetailSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVodDomainDetailResponseBodyDomainDetailSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeVodDomainDetailResponseBodyDomainDetailSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainDetailResponseBodyDomainDetailSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeVodDomainDetailResponseBodyDomainDetailSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeVodDomainDetailResponseBodyDomainDetail(TeaModel):
    def __init__(self, cert_name=None, cname=None, description=None, domain_name=None, domain_status=None,
                 gmt_created=None, gmt_modified=None, sslprotocol=None, sslpub=None, scope=None, sources=None, weight=None):
        # The name of the certificate. The value of this parameter is returned if HTTPS is enabled.
        self.cert_name = cert_name  # type: str
        # The CNAME that is assigned to the domain name for CDN. You must add a CNAME record in the system of your Domain Name System (DNS) service provider to map the domain name for CDN to the CNAME.
        self.cname = cname  # type: str
        # The description of the domain name for CDN.
        self.description = description  # type: str
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        # The status of the domain name for CDN. Value values:
        # *   **online**: indicates that the domain name is enabled.
        # *   **offline**: indicates that the domain name is disabled.
        # *   **configuring**: indicates that the domain name is being configured.
        # *   **configure_failed**: indicates that the domain name failed to be configured.
        # *   **checking**: indicates that the domain name is under review.
        # *   **check_failed**: indicates that the domain name failed the review.
        self.domain_status = domain_status  # type: str
        # The time when the domain name for CDN was added. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.gmt_created = gmt_created  # type: str
        # The last time when the domain name for CDN was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # Indicates whether the Secure Sockets Layer (SSL) certificate is enabled. Valid values:
        # *   **on**: indicates that the SSL certificate is enabled.
        # *   **off**: indicates that the SSL certificate is disabled.
        self.sslprotocol = sslprotocol  # type: str
        # The public key of the certificate. The value of this parameter is returned if HTTPS is enabled.
        self.sslpub = sslpub  # type: str
        # This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
        # *   **domestic**: mainland China. This is the default value.
        # *   **overseas**: outside mainland China.
        # *   **global**: regions in and outside mainland China.
        self.scope = scope  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeVodDomainDetailResponseBodyDomainDetailSources
        # The weight of the origin server.
        self.weight = weight  # type: str

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeVodDomainDetailResponseBodyDomainDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Sources') is not None:
            temp_model = DescribeVodDomainDetailResponseBodyDomainDetailSources()
            self.sources = temp_model.from_map(m['Sources'])
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeVodDomainDetailResponseBody(TeaModel):
    def __init__(self, domain_detail=None, request_id=None):
        # The basic information about the domain name for CDN.
        self.domain_detail = domain_detail  # type: DescribeVodDomainDetailResponseBodyDomainDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_detail:
            self.domain_detail.validate()

    def to_map(self):
        _map = super(DescribeVodDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_detail is not None:
            result['DomainDetail'] = self.domain_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainDetail') is not None:
            temp_model = DescribeVodDomainDetailResponseBodyDomainDetail()
            self.domain_detail = temp_model.from_map(m['DomainDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainDetailResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainLogRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, page_number=None, page_size=None,
                 start_time=None):
        # The domain name.
        # 
        # >  You can specify only one domain name in each query.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. The maximum time range that can be specified is one year. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The page number. Default value: **1**.
        self.page_number = page_number  # type: long
        # The number of entries per page.
        # 
        # *   Default value: **300**.
        # *   Valid values: **1 to 1000**.
        self.page_size = page_size  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail(TeaModel):
    def __init__(self, end_time=None, log_name=None, log_path=None, log_size=None, start_time=None):
        # The end of the time range during which data was queried. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The name of the log file.
        self.log_name = log_name  # type: str
        # The path of the log file.
        self.log_path = log_path  # type: str
        # The size of the log file.
        self.log_size = log_size  # type: long
        # The beginning of the time range during which data was queried. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos(TeaModel):
    def __init__(self, log_info_detail=None):
        self.log_info_detail = log_info_detail  # type: list[DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail]

    def validate(self):
        if self.log_info_detail:
            for k in self.log_info_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogInfoDetail'] = []
        if self.log_info_detail is not None:
            for k in self.log_info_detail:
                result['LogInfoDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_info_detail = []
        if m.get('LogInfoDetail') is not None:
            for k in m.get('LogInfoDetail'):
                temp_model = DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail()
                self.log_info_detail.append(temp_model.from_map(k))
        return self


class DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos(TeaModel):
    def __init__(self, page_number=None, page_size=None, total=None):
        # The page number.
        self.page_number = page_number  # type: long
        # The number of entries per page.
        self.page_size = page_size  # type: long
        # The total number of entries returned.
        self.total = total  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetail(TeaModel):
    def __init__(self, domain_name=None, log_count=None, log_infos=None, page_infos=None):
        # The domain name.
        self.domain_name = domain_name  # type: str
        # The total number of entries returned on the current page.
        self.log_count = log_count  # type: long
        # The queried CDN logs.
        self.log_infos = log_infos  # type: DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos
        # The pagination information.
        self.page_infos = page_infos  # type: DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos

    def validate(self):
        if self.log_infos:
            self.log_infos.validate()
        if self.page_infos:
            self.page_infos.validate()

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.log_count is not None:
            result['LogCount'] = self.log_count
        if self.log_infos is not None:
            result['LogInfos'] = self.log_infos.to_map()
        if self.page_infos is not None:
            result['PageInfos'] = self.page_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LogCount') is not None:
            self.log_count = m.get('LogCount')
        if m.get('LogInfos') is not None:
            temp_model = DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos()
            self.log_infos = temp_model.from_map(m['LogInfos'])
        if m.get('PageInfos') is not None:
            temp_model = DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos()
            self.page_infos = temp_model.from_map(m['PageInfos'])
        return self


class DescribeVodDomainLogResponseBodyDomainLogDetails(TeaModel):
    def __init__(self, domain_log_detail=None):
        self.domain_log_detail = domain_log_detail  # type: list[DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetail]

    def validate(self):
        if self.domain_log_detail:
            for k in self.domain_log_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBodyDomainLogDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainLogDetail'] = []
        if self.domain_log_detail is not None:
            for k in self.domain_log_detail:
                result['DomainLogDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_log_detail = []
        if m.get('DomainLogDetail') is not None:
            for k in m.get('DomainLogDetail'):
                temp_model = DescribeVodDomainLogResponseBodyDomainLogDetailsDomainLogDetail()
                self.domain_log_detail.append(temp_model.from_map(k))
        return self


class DescribeVodDomainLogResponseBody(TeaModel):
    def __init__(self, domain_log_details=None, request_id=None):
        # The details of CDN logs.
        self.domain_log_details = domain_log_details  # type: DescribeVodDomainLogResponseBodyDomainLogDetails
        # The request ID.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_log_details:
            self.domain_log_details.validate()

    def to_map(self):
        _map = super(DescribeVodDomainLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_log_details is not None:
            result['DomainLogDetails'] = self.domain_log_details.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainLogDetails') is not None:
            temp_model = DescribeVodDomainLogResponseBodyDomainLogDetails()
            self.domain_log_details = temp_model.from_map(m['DomainLogDetails'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodDomainLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainLogResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainSrcBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, owner_id=None, start_time=None):
        # The accelerated domain name. You can specify a maximum of 500 domain names in a request. Separate multiple domain names with commas (,). If you specify multiple domain names in a request, aggregation results are returned.
        # 
        # If you leave this parameter empty, the origin bandwidth data for all accelerated domain names is queried by default.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds. Valid values:
        # 
        # *   **300**: 5 minutes
        # *   **3600**: 1 hour
        # *   **86400**: 1 day
        # 
        # > The time granularity supported by the Interval parameter varies based on the time range per query specified by using `StartTime` and `EndTime`. For more information, see the **Time granularity** section of this topic.
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # If you leave this parameter empty, the origin bandwidth data that is generated in the last 24 hours is queried by default.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainSrcBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, https_value=None, time_stamp=None, value=None):
        # The bandwidth values of origin HTTPS requests.
        self.https_value = https_value  # type: str
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str
        # The bandwidth value at each time interval.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.https_value is not None:
            result['HttpsValue'] = self.https_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpsValue') is not None:
            self.https_value = m.get('HttpsValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeVodDomainSrcBpsDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None,
                 src_bps_data_per_interval=None, start_time=None):
        # The time interval between the entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Details about the origin bandwidth data returned at each time interval. Unit: bit/s.
        self.src_bps_data_per_interval = src_bps_data_per_interval  # type: DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerInterval
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.src_bps_data_per_interval:
            self.src_bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.src_bps_data_per_interval is not None:
            result['SrcBpsDataPerInterval'] = self.src_bps_data_per_interval.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SrcBpsDataPerInterval') is not None:
            temp_model = DescribeVodDomainSrcBpsDataResponseBodySrcBpsDataPerInterval()
            self.src_bps_data_per_interval = temp_model.from_map(m['SrcBpsDataPerInterval'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainSrcBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainSrcBpsDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainSrcBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainSrcTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, owner_id=None, start_time=None):
        # The accelerated domain name. You can specify a maximum of 500 domain names in a request. Separate multiple domain names with commas (,). If you specify multiple domain names in a request, aggregation results are returned.
        # 
        # If you leave this parameter empty, the origin traffic data for all accelerated domain names is queried by default.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds. Valid values:
        # 
        # *   **300**: 5 minutes
        # *   **3600**: 1 hour
        # *   **86400**: 1 day
        # 
        # > The time granularity supported by the Interval parameter varies based on the time range per query specified by using `StartTime` and `EndTime`. For more information, see the **Time granularity** section of this topic.
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # If you leave this parameter empty, the origin traffic data that is generated in the last 24 hours is queried by default.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainSrcTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, https_value=None, time_stamp=None, value=None):
        # The amount of traffic generated by origin HTTPS requests.
        self.https_value = https_value  # type: str
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str
        # The traffic value at each time interval.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.https_value is not None:
            result['HttpsValue'] = self.https_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpsValue') is not None:
            self.https_value = m.get('HttpsValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeVodDomainSrcTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None,
                 src_traffic_data_per_interval=None, start_time=None, total_traffic=None):
        # The time interval between the entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Details about the origin traffic returned at each time interval. Unit: bytes.
        self.src_traffic_data_per_interval = src_traffic_data_per_interval  # type: DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerInterval
        # The start of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The total traffic. Unit: bytes.
        self.total_traffic = total_traffic  # type: str

    def validate(self):
        if self.src_traffic_data_per_interval:
            self.src_traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.src_traffic_data_per_interval is not None:
            result['SrcTrafficDataPerInterval'] = self.src_traffic_data_per_interval.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_traffic is not None:
            result['TotalTraffic'] = self.total_traffic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SrcTrafficDataPerInterval') is not None:
            temp_model = DescribeVodDomainSrcTrafficDataResponseBodySrcTrafficDataPerInterval()
            self.src_traffic_data_per_interval = temp_model.from_map(m['SrcTrafficDataPerInterval'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalTraffic') is not None:
            self.total_traffic = m.get('TotalTraffic')
        return self


class DescribeVodDomainSrcTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainSrcTrafficDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainSrcTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainSrcTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        # The accelerated domain name that you want to query. If you leave this parameter empty, the merged data of all your accelerated domain names is returned. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The interval at which to return data. Unit: seconds. Valid values: **300**, **3600**, and **86400**. If you leave this parameter empty or specify an invalid value, the default value is used.
        # 
        # *   Valid values if the time range to query is less than 3 days: **300**, **3600**, and **86400**. Default value: 300.
        # *   Valid values if the time range to query is 3 to less than 31 days: **3600** and **86400**. Default value: 3600.
        # *   Valid value if the time range to query is 31 to 90 days: **86400**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP). If you leave this parameter empty, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region. If you leave this parameter empty, all regions are queried. You can specify only the China (Shanghai) region.
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > The minimum time granularity to query data is 5 minutes. If you leave this parameter empty, the data in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeVodDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, domestic_value=None, https_domestic_value=None, https_overseas_value=None, https_value=None,
                 overseas_value=None, time_stamp=None, value=None):
        # The amount of network traffic in the Chinese mainland. Unit: bytes.
        self.domestic_value = domestic_value  # type: str
        # The amount of HTTPS network traffic on points of presence (POPs) in the Chinese mainland. Unit: bytes.
        self.https_domestic_value = https_domestic_value  # type: str
        # The amount of HTTPS network traffic on POPs outside the Chinese mainland. Unit: bytes.
        self.https_overseas_value = https_overseas_value  # type: str
        # The total amount of HTTPS network traffic on POPs. Unit: bytes.
        self.https_value = https_value  # type: str
        # The amount of network traffic outside the Chinese mainland. Unit: bytes.
        self.overseas_value = overseas_value  # type: str
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str
        # The total amount of network traffic. Unit: bytes.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domestic_value is not None:
            result['DomesticValue'] = self.domestic_value
        if self.https_domestic_value is not None:
            result['HttpsDomesticValue'] = self.https_domestic_value
        if self.https_overseas_value is not None:
            result['HttpsOverseasValue'] = self.https_overseas_value
        if self.https_value is not None:
            result['HttpsValue'] = self.https_value
        if self.overseas_value is not None:
            result['OverseasValue'] = self.overseas_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomesticValue') is not None:
            self.domestic_value = m.get('DomesticValue')
        if m.get('HttpsDomesticValue') is not None:
            self.https_domestic_value = m.get('HttpsDomesticValue')
        if m.get('HttpsOverseasValue') is not None:
            self.https_overseas_value = m.get('HttpsOverseasValue')
        if m.get('HttpsValue') is not None:
            self.https_value = m.get('HttpsValue')
        if m.get('OverseasValue') is not None:
            self.overseas_value = m.get('OverseasValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodDomainTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeVodDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeVodDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeVodDomainTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 total_traffic=None, traffic_data_per_interval=None):
        # The time interval between the entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The total amount of network traffic.
        self.total_traffic = total_traffic  # type: str
        # The network traffic that was collected at each interval.
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeVodDomainTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeVodDomainTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_traffic is not None:
            result['TotalTraffic'] = self.total_traffic
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalTraffic') is not None:
            self.total_traffic = m.get('TotalTraffic')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeVodDomainTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeVodDomainTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainTrafficDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodDomainUsageDataRequest(TeaModel):
    def __init__(self, area=None, domain_name=None, end_time=None, field=None, interval=None, owner_id=None,
                 start_time=None, type=None):
        # The region in which you want to query data. Valid values:
        # 
        # *   **CN**: Chinese mainland
        # *   **OverSeas**: outside the Chinese mainland
        self.area = area  # type: str
        # The accelerated domain name. If you leave this parameter empty, the merged data of all your accelerated domain names is returned. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The type of the data to return. Valid values:
        # 
        # *   **bps**: bandwidth
        # *   **traf**: traffic
        self.field = field  # type: str
        # The time interval between the data entries to return. Unit: seconds. Valid values: **300** (5 minutes), **3600** (1 hour), and **86400** (1 day).
        # 
        # *   If **Interval** is set to **300**, you can query usage data in the last six months. The maximum time range per query that can be specified is three days.
        # *   If **Interval** is set to **3600** or **86400**, you can query usage data of the previous year.
        # *   If you do not set the **Interval** parameter, the maximum time range that you can query is one month. If you specify a time range of 1 to 3 days, the time interval between the entries that are returned is 1 hour. If you specify a time range of at least 4 days, the time interval between the entries that are returned is 1 day.
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The type of content that you want to query. Valid values:
        # 
        # *   **static**: static content
        # *   **dynamic**: dynamic requests
        # *   **all**: all content
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.field is not None:
            result['Field'] = self.field
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVodDomainUsageDataResponseBodyUsageDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the returned data. The time is in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str
        # The traffic or bandwidth data. Unit: bit/s.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodDomainUsageDataResponseBodyUsageDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodDomainUsageDataResponseBodyUsageDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeVodDomainUsageDataResponseBodyUsageDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodDomainUsageDataResponseBodyUsageDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeVodDomainUsageDataResponseBodyUsageDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeVodDomainUsageDataResponseBody(TeaModel):
    def __init__(self, area=None, data_interval=None, domain_name=None, end_time=None, request_id=None,
                 start_time=None, type=None, usage_data_per_interval=None):
        # The billable region where the data was collected.
        self.area = area  # type: str
        # The time interval between the entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The type of the data. Valid values:
        # 
        # *   **bps**: bandwidth
        # *   **traf**: traffic
        self.type = type  # type: str
        # The traffic or bandwidth data returned at each interval.
        self.usage_data_per_interval = usage_data_per_interval  # type: DescribeVodDomainUsageDataResponseBodyUsageDataPerInterval

    def validate(self):
        if self.usage_data_per_interval:
            self.usage_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeVodDomainUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.usage_data_per_interval is not None:
            result['UsageDataPerInterval'] = self.usage_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UsageDataPerInterval') is not None:
            temp_model = DescribeVodDomainUsageDataResponseBodyUsageDataPerInterval()
            self.usage_data_per_interval = temp_model.from_map(m['UsageDataPerInterval'])
        return self


class DescribeVodDomainUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodDomainUsageDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodDomainUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodDomainUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodRefreshQuotaRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodRefreshQuotaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeVodRefreshQuotaResponseBody(TeaModel):
    def __init__(self, block_quota=None, dir_quota=None, dir_remain=None, preload_quota=None, preload_remain=None,
                 request_id=None, url_quota=None, url_remain=None, block_remain=None):
        # The maximum number of Object Storage Service (OSS) buckets that can be refreshed each day.
        self.block_quota = block_quota  # type: str
        # The maximum number of directories of files that can be refreshed each day.
        self.dir_quota = dir_quota  # type: str
        # The remaining number of directories of files that can be refreshed on the current day.
        self.dir_remain = dir_remain  # type: str
        # The maximum number of URLs of files that can be prefetched each day.
        self.preload_quota = preload_quota  # type: str
        # The remaining number of URLs of files that can be prefetched on the current day.
        self.preload_remain = preload_remain  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The maximum number of URLs of files that can be refreshed each day.
        self.url_quota = url_quota  # type: str
        # The remaining number of URLs of files that can be refreshed on the current day.
        self.url_remain = url_remain  # type: str
        # The remaining number of OSS buckets that can be refreshed on the current day.
        self.block_remain = block_remain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodRefreshQuotaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_quota is not None:
            result['BlockQuota'] = self.block_quota
        if self.dir_quota is not None:
            result['DirQuota'] = self.dir_quota
        if self.dir_remain is not None:
            result['DirRemain'] = self.dir_remain
        if self.preload_quota is not None:
            result['PreloadQuota'] = self.preload_quota
        if self.preload_remain is not None:
            result['PreloadRemain'] = self.preload_remain
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url_quota is not None:
            result['UrlQuota'] = self.url_quota
        if self.url_remain is not None:
            result['UrlRemain'] = self.url_remain
        if self.block_remain is not None:
            result['blockRemain'] = self.block_remain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockQuota') is not None:
            self.block_quota = m.get('BlockQuota')
        if m.get('DirQuota') is not None:
            self.dir_quota = m.get('DirQuota')
        if m.get('DirRemain') is not None:
            self.dir_remain = m.get('DirRemain')
        if m.get('PreloadQuota') is not None:
            self.preload_quota = m.get('PreloadQuota')
        if m.get('PreloadRemain') is not None:
            self.preload_remain = m.get('PreloadRemain')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UrlQuota') is not None:
            self.url_quota = m.get('UrlQuota')
        if m.get('UrlRemain') is not None:
            self.url_remain = m.get('UrlRemain')
        if m.get('blockRemain') is not None:
            self.block_remain = m.get('blockRemain')
        return self


class DescribeVodRefreshQuotaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodRefreshQuotaResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodRefreshQuotaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodRefreshQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodRefreshTasksRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, object_path=None, object_type=None, owner_id=None,
                 page_number=None, page_size=None, security_token=None, start_time=None, status=None, task_id=None):
        # The domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The path of the object. The path is used as a condition for exact matching.
        self.object_path = object_path  # type: str
        # The type of the task. Valid values:
        # 
        # *   **file**: refreshes one or more files.
        # *   **directory**: refreshes files in the specified directories.
        # *   **preload**: prefetches one or more files.
        # 
        # > If you specify the DomainName or Status parameter, you must also specify the ObjectType parameter.
        self.object_type = object_type  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **20**. Maximum value: **50**.
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > You can query data that is collected in the last three days.
        self.start_time = start_time  # type: str
        # The status of the task. Valid values:
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status  # type: str
        # The ID of the task that you want to query.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodRefreshTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeVodRefreshTasksResponseBodyTasksTask(TeaModel):
    def __init__(self, creation_time=None, description=None, object_path=None, object_type=None, process=None,
                 status=None, task_id=None):
        # The time when the task was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The type of error returned when the refresh or prefetch task failed. Valid values: Valid values:
        # 
        # *   **Internal Error**: An internal error occurred.
        # *   **Origin Timeout**: The response from the origin server timed out.
        # *   **Origin Return StatusCode 5XX**: The origin server returned an HTTP status code 5xx.
        self.description = description  # type: str
        # The URL of the object refreshed.
        self.object_path = object_path  # type: str
        # The type of the task. Default value: file. Valid values:
        # 
        # *   **file**: refreshes one or more files.
        # *   **directory**: refreshes files in the specified directory.
        # *   **preload**: prefetches one or more files.
        self.object_type = object_type  # type: str
        # The progress of the task in percentage.
        self.process = process  # type: str
        # The status of the task. Valid values:
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        # *   **Pending**: The task is pending.
        self.status = status  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodRefreshTasksResponseBodyTasksTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.process is not None:
            result['Process'] = self.process
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeVodRefreshTasksResponseBodyTasks(TeaModel):
    def __init__(self, task=None):
        self.task = task  # type: list[DescribeVodRefreshTasksResponseBodyTasksTask]

    def validate(self):
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodRefreshTasksResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.task = []
        if m.get('Task') is not None:
            for k in m.get('Task'):
                temp_model = DescribeVodRefreshTasksResponseBodyTasksTask()
                self.task.append(temp_model.from_map(k))
        return self


class DescribeVodRefreshTasksResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, tasks=None, total_count=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the returned tasks.
        self.tasks = tasks  # type: DescribeVodRefreshTasksResponseBodyTasks
        # The total number of entries returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.tasks:
            self.tasks.validate()

    def to_map(self):
        _map = super(DescribeVodRefreshTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tasks is not None:
            result['Tasks'] = self.tasks.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Tasks') is not None:
            temp_model = DescribeVodRefreshTasksResponseBodyTasks()
            self.tasks = temp_model.from_map(m['Tasks'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVodRefreshTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodRefreshTasksResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodRefreshTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodRefreshTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodStorageDataRequest(TeaModel):
    def __init__(self, end_time=None, owner_id=None, region=None, start_time=None, storage=None, storage_type=None):
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The region in which you want to query storage data. If you leave this parameter empty, data in all regions is returned. Separate multiple regions with commas (,). Valid values:
        # 
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-beijing**: China (Beijing)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **ap-southeast-1**: Singapore
        self.region = region  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The name of the Object Storage Service (OSS) bucket. If you leave this parameter empty, data of all buckets is returned. Separate multiple bucket names with commas (,).
        self.storage = storage  # type: str
        # The storage type. Set the value to **OSS**.
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodStorageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.storage is not None:
            result['Storage'] = self.storage
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeVodStorageDataResponseBodyStorageDataStorageDataItem(TeaModel):
    def __init__(self, network_out=None, storage_utilization=None, time_stamp=None):
        # The outbound traffic. Unit: bytes. The outbound traffic is generated when videos are directly downloaded or played from OSS buckets without Alibaba Cloud CDN acceleration.
        self.network_out = network_out  # type: str
        # The detailed usage data of storage-related resources. Unit: bytes.
        self.storage_utilization = storage_utilization  # type: str
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodStorageDataResponseBodyStorageDataStorageDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_out is not None:
            result['NetworkOut'] = self.network_out
        if self.storage_utilization is not None:
            result['StorageUtilization'] = self.storage_utilization
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkOut') is not None:
            self.network_out = m.get('NetworkOut')
        if m.get('StorageUtilization') is not None:
            self.storage_utilization = m.get('StorageUtilization')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeVodStorageDataResponseBodyStorageData(TeaModel):
    def __init__(self, storage_data_item=None):
        self.storage_data_item = storage_data_item  # type: list[DescribeVodStorageDataResponseBodyStorageDataStorageDataItem]

    def validate(self):
        if self.storage_data_item:
            for k in self.storage_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodStorageDataResponseBodyStorageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StorageDataItem'] = []
        if self.storage_data_item is not None:
            for k in self.storage_data_item:
                result['StorageDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.storage_data_item = []
        if m.get('StorageDataItem') is not None:
            for k in m.get('StorageDataItem'):
                temp_model = DescribeVodStorageDataResponseBodyStorageDataStorageDataItem()
                self.storage_data_item.append(temp_model.from_map(k))
        return self


class DescribeVodStorageDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, request_id=None, storage_data=None):
        # The time granularity at which the data was queried. Valid values:
        # 
        # *   **hour**\
        # *   **day**\
        self.data_interval = data_interval  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The storage usage data returned.
        self.storage_data = storage_data  # type: DescribeVodStorageDataResponseBodyStorageData

    def validate(self):
        if self.storage_data:
            self.storage_data.validate()

    def to_map(self):
        _map = super(DescribeVodStorageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.storage_data is not None:
            result['StorageData'] = self.storage_data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StorageData') is not None:
            temp_model = DescribeVodStorageDataResponseBodyStorageData()
            self.storage_data = temp_model.from_map(m['StorageData'])
        return self


class DescribeVodStorageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodStorageDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodStorageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodStorageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodTranscodeDataRequest(TeaModel):
    def __init__(self, app_id=None, end_time=None, interval=None, owner_id=None, region=None, specification=None,
                 start_time=None, storage=None):
        self.app_id = app_id  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The interval at which you want to query data. Valid values:
        # 
        # *   **day**: days
        # *   **hour**: hours
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        # The region in which you want to query data. If you leave this parameter empty, data in all regions is returned. Separate multiple regions with commas (,). Valid values:
        # 
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-beijing**: China (Beijing)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **ap-southeast-1**: Singapore
        self.region = region  # type: str
        # The transcoding specification. If you leave this parameter empty, data of all transcoding specifications is returned. Separate multiple transcoding specifications with commas (,). Valid values:
        # 
        # *   **Audio**: audio transcoding
        # *   **Segmentation**: container format conversion
        # *   **H264.LD**, **H264.SD**, **H264.HD**, **H264.2K**, **H264.4K**, and more
        self.specification = specification  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The name of the Object Storage Service (OSS) bucket. If you leave this parameter empty, data of all buckets is returned. Separate multiple bucket names with commas (,).
        self.storage = storage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodTranscodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemDataDataItem(TeaModel):
    def __init__(self, name=None, value=None):
        # The transcoding specification. Valid values:
        # 
        # *   **Audio**: audio transcoding
        # *   **Segmentation**: container format conversion
        # *   **H264.LD, H264.SD, H264.HD, H264.2K, H264.4K, and more**\
        self.name = name  # type: str
        # The transcoding duration. Unit: seconds.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemDataDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemData(TeaModel):
    def __init__(self, data_item=None):
        self.data_item = data_item  # type: list[DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemDataDataItem]

    def validate(self):
        if self.data_item:
            for k in self.data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataItem'] = []
        if self.data_item is not None:
            for k in self.data_item:
                result['DataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_item = []
        if m.get('DataItem') is not None:
            for k in m.get('DataItem'):
                temp_model = DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemDataDataItem()
                self.data_item.append(temp_model.from_map(k))
        return self


class DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItem(TeaModel):
    def __init__(self, data=None, time_stamp=None):
        # The statistics on transcoding of different specifications.
        self.data = data  # type: DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemData
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItemData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeVodTranscodeDataResponseBodyTranscodeData(TeaModel):
    def __init__(self, transcode_data_item=None):
        self.transcode_data_item = transcode_data_item  # type: list[DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItem]

    def validate(self):
        if self.transcode_data_item:
            for k in self.transcode_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponseBodyTranscodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TranscodeDataItem'] = []
        if self.transcode_data_item is not None:
            for k in self.transcode_data_item:
                result['TranscodeDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.transcode_data_item = []
        if m.get('TranscodeDataItem') is not None:
            for k in m.get('TranscodeDataItem'):
                temp_model = DescribeVodTranscodeDataResponseBodyTranscodeDataTranscodeDataItem()
                self.transcode_data_item.append(temp_model.from_map(k))
        return self


class DescribeVodTranscodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, request_id=None, transcode_data=None):
        # The interval at which the data was queried. Valid values:
        # 
        # *   **hour**\
        # *   **day**\
        self.data_interval = data_interval  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The transcoding statistics returned.
        self.transcode_data = transcode_data  # type: DescribeVodTranscodeDataResponseBodyTranscodeData

    def validate(self):
        if self.transcode_data:
            self.transcode_data.validate()

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_data is not None:
            result['TranscodeData'] = self.transcode_data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeData') is not None:
            temp_model = DescribeVodTranscodeDataResponseBodyTranscodeData()
            self.transcode_data = temp_model.from_map(m['TranscodeData'])
        return self


class DescribeVodTranscodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodTranscodeDataResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodTranscodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodTranscodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodUserDomainsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of tag N. Valid values of N: **1** to **20**.
        # 
        # If you do not specify this parameter, all tag keys are queried.
        self.key = key  # type: str
        # The value of tag N. Valid values of N: **1** to **20**.
        # 
        # If you do not specify this parameter, all tag values are queried.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodUserDomainsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVodUserDomainsRequest(TeaModel):
    def __init__(self, domain_name=None, domain_search_type=None, domain_status=None, owner_id=None,
                 page_number=None, page_size=None, security_token=None, tag=None):
        # The domain name. The value of this parameter is used as a filter condition for a fuzzy match.
        self.domain_name = domain_name  # type: str
        # The search method. Valid values:
        # *   **fuzzy_match**: fuzzy match. This is the default value.
        # *   **pre_match**: prefix match.
        # *   **suf_match**: suffix match.
        # *   **full_match**: exact match.
        self.domain_search_type = domain_search_type  # type: str
        # The status of the domain name. The value of this parameter is used as a condition to filter domain names. Value values:
        # *   **online**: indicates that the domain name is enabled.
        # *   **offline**: indicates that the domain name is disabled.
        # *   **configuring**: indicates that the domain name is being configured.
        # *   **configure_failed**: indicates that the domain name failed to be configured.
        # *   **checking**: indicates that the domain name is under review.
        # *   **check_failed**: indicates that the domain name failed the review.
        self.domain_status = domain_status  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **20**. Maximum value: **50**. Valid values: integers in the range of **1** to **50**.
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str
        # Tag.
        self.tag = tag  # type: list[DescribeVodUserDomainsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_search_type is not None:
            result['DomainSearchType'] = self.domain_search_type
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainSearchType') is not None:
            self.domain_search_type = m.get('DomainSearchType')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeVodUserDomainsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeVodUserDomainsResponseBodyDomainsPageDataSourcesSource(TeaModel):
    def __init__(self, content=None, port=None, priority=None, type=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The port number. Valid values: **443** and **80**.
        self.port = port  # type: int
        # The priority of the origin server.
        self.priority = priority  # type: str
        # The type of the origin server. Valid values:
        # 
        # *   **ipaddr**: a server that you can access by using an IP address.
        # *   **domain**: a server that you can access by using a domain name.
        # *   **oss**: an Object Storage Service (OSS) bucket.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponseBodyDomainsPageDataSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVodUserDomainsResponseBodyDomainsPageDataSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeVodUserDomainsResponseBodyDomainsPageDataSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponseBodyDomainsPageDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeVodUserDomainsResponseBodyDomainsPageDataSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeVodUserDomainsResponseBodyDomainsPageData(TeaModel):
    def __init__(self, cname=None, description=None, domain_name=None, domain_status=None, gmt_created=None,
                 gmt_modified=None, sandbox=None, sources=None, ssl_protocol=None):
        # The canonical domain name that is assigned to the domain name for CDN.
        self.cname = cname  # type: str
        # The remarks.
        self.description = description  # type: str
        # The domain name for CDN.
        self.domain_name = domain_name  # type: str
        # The status of the domain name for CDN. Valid values:
        # 
        # *   **online**: indicates that the domain name is enabled.
        # *   **offline**: indicates that the domain name is disabled.
        # *   **configuring**: indicates that the domain name is being configured.
        # *   **configure_failed**: indicates that the domain name failed to be configured.
        # *   **checking**: indicates that the domain name is under review.
        # *   **check_failed**: indicates that the domain name failed the review.
        self.domain_status = domain_status  # type: str
        # The time when the domain name for CDN was added. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.gmt_created = gmt_created  # type: str
        # The last time when the domain name for CDN was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # Indicates whether the domain name for CDN is in a sandbox environment.
        self.sandbox = sandbox  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeVodUserDomainsResponseBodyDomainsPageDataSources
        # Indicates whether HTTPS is enabled.
        # 
        # - **on**: indicates that HTTPS is enabled.
        # - **off**: indicates that HTTPS is disabled.
        self.ssl_protocol = ssl_protocol  # type: str

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponseBodyDomainsPageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.sandbox is not None:
            result['Sandbox'] = self.sandbox
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        if self.ssl_protocol is not None:
            result['SslProtocol'] = self.ssl_protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Sandbox') is not None:
            self.sandbox = m.get('Sandbox')
        if m.get('Sources') is not None:
            temp_model = DescribeVodUserDomainsResponseBodyDomainsPageDataSources()
            self.sources = temp_model.from_map(m['Sources'])
        if m.get('SslProtocol') is not None:
            self.ssl_protocol = m.get('SslProtocol')
        return self


class DescribeVodUserDomainsResponseBodyDomains(TeaModel):
    def __init__(self, page_data=None):
        self.page_data = page_data  # type: list[DescribeVodUserDomainsResponseBodyDomainsPageData]

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeVodUserDomainsResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeVodUserDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The detailed information about each domain name for CDN. The returned information is displayed in the format that is specified by the PageData parameter.
        self.domains = domains  # type: DescribeVodUserDomainsResponseBodyDomains
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeVodUserDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVodUserDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodUserDomainsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodUserDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodUserDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVodVerifyContentRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        # The domain name for which you want to query the ownership verification content. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodVerifyContentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeVodVerifyContentResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The verification content.
        self.content = content  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVodVerifyContentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVodVerifyContentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeVodVerifyContentResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVodVerifyContentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVodVerifyContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachAppPolicyFromIdentityRequest(TeaModel):
    def __init__(self, app_id=None, identity_name=None, identity_type=None, policy_names=None):
        # The ID of the application. This parameter is optional when the PolicyNames parameter is set to VODAppAdministratorAccess. This parameter is required when the PolicyNames parameter is set to other values.
        # *   Default value: **app-1000000**.
        # *   For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The name of the identity.
        # *   Specifies the ID of the RAM user when the IdentityType parameter is set to RamUser.
        # *   Specifies the name of the RAM role when the IdentityType parameter is set to RamRole.
        self.identity_name = identity_name  # type: str
        # The type of the identity. Valid values:
        # *   **RamUser**: a RAM user.
        # *   **RamRole**: a RAM role.
        self.identity_type = identity_type  # type: str
        # The name of the policy. Separate multiple policies with commas (,). Only system policies are supported.
        # *   **VODAppFullAccess**: authorizes an identity to manage all resources in an application.
        # *   **VODAppReadOnlyAccess**: authorizes an identity to access all resources in an application in read-only mode.
        # *   **VODAppAdministratorAccess**: assigns the application administrator role to an identity.
        self.policy_names = policy_names  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachAppPolicyFromIdentityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.identity_name is not None:
            result['IdentityName'] = self.identity_name
        if self.identity_type is not None:
            result['IdentityType'] = self.identity_type
        if self.policy_names is not None:
            result['PolicyNames'] = self.policy_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('IdentityName') is not None:
            self.identity_name = m.get('IdentityName')
        if m.get('IdentityType') is not None:
            self.identity_type = m.get('IdentityType')
        if m.get('PolicyNames') is not None:
            self.policy_names = m.get('PolicyNames')
        return self


class DetachAppPolicyFromIdentityResponseBody(TeaModel):
    def __init__(self, failed_policy_names=None, non_exist_policy_names=None, request_id=None):
        # The name of the policy that failed to be detached from the identity.
        self.failed_policy_names = failed_policy_names  # type: list[str]
        # The name of the policy that was not found.
        self.non_exist_policy_names = non_exist_policy_names  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachAppPolicyFromIdentityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_policy_names is not None:
            result['FailedPolicyNames'] = self.failed_policy_names
        if self.non_exist_policy_names is not None:
            result['NonExistPolicyNames'] = self.non_exist_policy_names
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedPolicyNames') is not None:
            self.failed_policy_names = m.get('FailedPolicyNames')
        if m.get('NonExistPolicyNames') is not None:
            self.non_exist_policy_names = m.get('NonExistPolicyNames')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachAppPolicyFromIdentityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DetachAppPolicyFromIdentityResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DetachAppPolicyFromIdentityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachAppPolicyFromIdentityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDownloadSecretKeyRequest(TeaModel):
    def __init__(self, app_decrypt_key=None, app_identification=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # A custom string of 16 to 32 characters in length. The string must contain uppercase letters, lowercase letters, and digits.
        self.app_decrypt_key = app_decrypt_key  # type: str
        # The unique identifier of the app.
        # 
        # *   Android: the SHA-1 fingerprint of the keystore. The value is a string that contains a colon (:).
        # *   iOS: the bundle ID of the app.
        # *   Windows: the serial number in the digital signature certificate.
        # 
        # For more information about how to obtain the unique identifier of an app, see [Obtain the unique app identifier](~~86107#section-wtj-9d7-lg2~~).
        self.app_identification = app_identification  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDownloadSecretKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_decrypt_key is not None:
            result['AppDecryptKey'] = self.app_decrypt_key
        if self.app_identification is not None:
            result['AppIdentification'] = self.app_identification
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppDecryptKey') is not None:
            self.app_decrypt_key = m.get('AppDecryptKey')
        if m.get('AppIdentification') is not None:
            self.app_identification = m.get('AppIdentification')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GenerateDownloadSecretKeyResponseBody(TeaModel):
    def __init__(self, app_encrypt_key=None, request_id=None):
        # The key file for secure download.
        self.app_encrypt_key = app_encrypt_key  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDownloadSecretKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_encrypt_key is not None:
            result['AppEncryptKey'] = self.app_encrypt_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppEncryptKey') is not None:
            self.app_encrypt_key = m.get('AppEncryptKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateDownloadSecretKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateDownloadSecretKeyResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateDownloadSecretKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateDownloadSecretKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateKMSDataKeyRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateKMSDataKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GenerateKMSDataKeyResponseBody(TeaModel):
    def __init__(self, ciphertext_blob=None, key_id=None, plaintext=None, request_id=None):
        self.ciphertext_blob = ciphertext_blob  # type: str
        self.key_id = key_id  # type: str
        self.plaintext = plaintext  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateKMSDataKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphertext_blob is not None:
            result['CiphertextBlob'] = self.ciphertext_blob
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CiphertextBlob') is not None:
            self.ciphertext_blob = m.get('CiphertextBlob')
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateKMSDataKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateKMSDataKeyResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateKMSDataKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateKMSDataKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAIImageJobsRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the image AI processing job. You can obtain the value of JobId from the response to the [SubmitAIImageJob](~~SubmitAIImageJob~~) operation.
        # *   You can specify a maximum of 10 IDs.
        # *   Separate multiple IDs with commas (,).
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIImageJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetAIImageJobsResponseBodyAIImageJobList(TeaModel):
    def __init__(self, aiimage_result=None, code=None, creation_time=None, job_id=None, message=None, status=None,
                 template_config=None, template_id=None, user_data=None, video_id=None):
        # The Object Storage Service (OSS) URL of the image file.
        # 
        # > This parameter does not include the complete authentication information. To obtain the authentication information, you must generate a signed URL. Alternatively, you can call the [ListAIImageInfo](~~ListAIImageInfo~~) operation to obtain the image information.
        self.aiimage_result = aiimage_result  # type: str
        # The error code.
        self.code = code  # type: str
        # The time when the image AI processing job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The ID of the image AI processing job.
        self.job_id = job_id  # type: str
        # The error message.
        self.message = message  # type: str
        # The status of the job. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status  # type: str
        # The configurations of the AI template that was used to submit the job.
        self.template_config = template_config  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str
        # The user data.
        # 
        # *   The value must be a JSON string.
        # *   The MessageCallback or Extend parameter is returned.
        # *   The value contains a maximum of 512 bytes.
        # 
        # For more information, see the "UserData: specifies the custom configurations for media upload" section of the [Request parameters](~~86952~~) topic.
        self.user_data = user_data  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIImageJobsResponseBodyAIImageJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiimage_result is not None:
            result['AIImageResult'] = self.aiimage_result
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIImageResult') is not None:
            self.aiimage_result = m.get('AIImageResult')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetAIImageJobsResponseBody(TeaModel):
    def __init__(self, aiimage_job_list=None, request_id=None):
        # The image AI processing jobs.
        self.aiimage_job_list = aiimage_job_list  # type: list[GetAIImageJobsResponseBodyAIImageJobList]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aiimage_job_list:
            for k in self.aiimage_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIImageJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AIImageJobList'] = []
        if self.aiimage_job_list is not None:
            for k in self.aiimage_job_list:
                result['AIImageJobList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aiimage_job_list = []
        if m.get('AIImageJobList') is not None:
            for k in m.get('AIImageJobList'):
                temp_model = GetAIImageJobsResponseBodyAIImageJobList()
                self.aiimage_job_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAIImageJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAIImageJobsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAIImageJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAIImageJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAIMediaAuditJobRequest(TeaModel):
    def __init__(self, job_id=None):
        # The ID of the intelligent review job.
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataAudioResult(TeaModel):
    def __init__(self, label=None, scene=None, score=None, suggestion=None):
        # The category of the review result. Valid values:
        # 
        # *   **normal**\
        # *   **spam**\
        # *   **ad**\
        # *   **politics**\
        # *   **terrorism**\
        # *   **abuse**\
        # *   **porn**\
        # *   **flood**: spam posts
        # *   **contraband**\
        # *   **meaningless**\
        self.label = label  # type: str
        # The review scenario. Valid value: **antispam**.
        self.scene = scene  # type: str
        # The score.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataAudioResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResultResult(TeaModel):
    def __init__(self, label=None, scene=None, score=None, suggestion=None):
        # The category of the review result.
        # 
        # Valid values if scene is **porn**:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        # 
        # Valid values if scene is **terrorism**:
        # 
        # *   **normal**\
        # *   **bloody**\
        # *   **explosion**\
        # *   **outfit**\
        # *   **logo**\
        # *   **weapon**\
        # *   **politics**\
        # *   **violence**\
        # *   **crowd**\
        # *   **parade**\
        # *   **carcrash**\
        # *   **flag**\
        # *   **location**\
        # *   **others**\
        # 
        # Valid values if scene is **ad**:
        # 
        # *   **normal**\
        # *   **ad**\
        # *   **politics**\
        # *   **porn**\
        # *   **abuse**\
        # *   **terrorism**\
        # *   **contraband**\
        # *   **spam**\
        # *   **npx**: illegal ad
        # *   **qrcode**: QR code
        # *   **programCode**\
        # 
        # Valid values if scene is **live**:
        # 
        # *   **normal**\
        # *   **meaningless**\
        # *   **PIP**\
        # *   **smoking**\
        # *   **drivelive**\
        # 
        # Valid values if scene is **logo**:
        # 
        # *   **normal**\
        # *   **TV**\
        # *   **trademark**\
        self.label = label  # type: str
        # The review scenario. Valid values:
        # 
        # *   **porn**\
        # *   **terrorism**\
        # *   **ad**\
        # *   **live**: undesirable scenes
        # *   **logo**\
        self.scene = scene  # type: str
        # The score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The score is representative of the confidence.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResultResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResult(TeaModel):
    def __init__(self, label=None, result=None, suggestion=None, type=None, url=None):
        # The category of the review result. Separate multiple values with commas (,). Valid values:
        # 
        # *   **porn**\
        # *   **terrorism**\
        # *   **ad**\
        # *   **live**: undesirable scenes
        # *   **logo**\
        # *   **audio**: audio anti-spam
        # *   **normal**\
        self.label = label  # type: str
        # Details of image review results.
        self.result = result  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResultResult]
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The type of the image. Valid value: **cover**.
        self.type = type  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResultResult()
                self.result.append(temp_model.from_map(k))
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataTextResult(TeaModel):
    def __init__(self, content=None, label=None, scene=None, score=None, suggestion=None, type=None):
        # The text.
        self.content = content  # type: str
        # The category of the review result. Valid values:
        # 
        # *   **spam**\
        # *   **ad**\
        # *   **abuse**\
        # *   **flood**: spam posts
        # *   **contraband**\
        # *   **meaningless**\
        # *   **normal**\
        self.label = label  # type: str
        # The review scenario. Valid value: **antispam**.
        self.scene = scene  # type: str
        # The score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The score is representative of the confidence.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The type of the text. The value is **title**.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataTextResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of images.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # *   **ad**\
        # *   **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # *   **ad**\
        # *   **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultCounterList]
        # The category of the review result. Valid values:
        # 
        # *   **ad**\
        # *   **normal**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of images.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # *   **live**: The content contains undesirable scenes.
        # *   **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # *   **live**: The content contains undesirable scenes.
        # *   **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The categories of the review results and the number of images.
        self.counter_list = counter_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultCounterList]
        # The category of the review result. Valid values:
        # 
        # *   **live**: The content contains undesirable scenes.
        # *   **normal**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of images.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # *   **logo**\
        # *   **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # *   **logo**\
        # *   **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the images of the category that is indicated by Label.
        self.average_score = average_score  # type: str
        # The categories of the review results and the number of images.
        self.counter_list = counter_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultCounterList]
        # The category of the review result. Valid values:
        # 
        # *   **logo**\
        # *   **normal**\
        self.label = label  # type: str
        # The highest score of the image of the category that is indicated by Label.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of images.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the images of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.average_score = average_score  # type: str
        # The categories of the review results and the number of images.
        self.counter_list = counter_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultCounterList]
        # The category of the review result. Valid values:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        self.label = label  # type: str
        # The highest score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of images.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # *   **terrorism**\
        # *   **outfit**\
        # *   **logo**\
        # *   **weapon**\
        # *   **politics**\
        # *   **others**\
        # *   **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # *   **normal**\
        # *   **bloody**\
        # *   **explosion**\
        # *   **outfit**\
        # *   **logo**\
        # *   **weapon**\
        # *   **politics**\
        # *   **violence**\
        # *   **crowd**\
        # *   **parade**\
        # *   **carcrash**\
        # *   **flag**\
        # *   **location**\
        # *   **others**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the images of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.average_score = average_score  # type: str
        # The categories of the review results and the number of images.
        self.counter_list = counter_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultCounterList]
        # The category of the review result. Valid values:
        # 
        # *   **normal**\
        # *   **bloody**\
        # *   **explosion**\
        # *   **outfit**\
        # *   **logo**\
        # *   **weapon**\
        # *   **politics**\
        # *   **violence**\
        # *   **crowd**\
        # *   **parade**\
        # *   **carcrash**\
        # *   **flag**\
        # *   **location**\
        # *   **others**\
        self.label = label  # type: str
        # The highest score of the image of the category that is indicated by Label. Valid values: `[0, 100]`. The value is accurate to 10 decimal places. The score is representative of the confidence.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResult(TeaModel):
    def __init__(self, ad_result=None, label=None, live_result=None, logo_result=None, porn_result=None,
                 suggestion=None, terrorism_result=None):
        # The results of ad review.
        self.ad_result = ad_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResult
        # The category of the review result. Valid values:
        # 
        # *   **ad**\
        # *   **normal**\
        self.label = label  # type: str
        # The results of undesired content review.
        self.live_result = live_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResult
        # The results of logo review.
        self.logo_result = logo_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResult
        # The results of pornography content review.
        self.porn_result = porn_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResult
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The results of terrorism content review.
        self.terrorism_result = terrorism_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResult

    def validate(self):
        if self.ad_result:
            self.ad_result.validate()
        if self.live_result:
            self.live_result.validate()
        if self.logo_result:
            self.logo_result.validate()
        if self.porn_result:
            self.porn_result.validate()
        if self.terrorism_result:
            self.terrorism_result.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_result is not None:
            result['AdResult'] = self.ad_result.to_map()
        if self.label is not None:
            result['Label'] = self.label
        if self.live_result is not None:
            result['LiveResult'] = self.live_result.to_map()
        if self.logo_result is not None:
            result['LogoResult'] = self.logo_result.to_map()
        if self.porn_result is not None:
            result['PornResult'] = self.porn_result.to_map()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.terrorism_result is not None:
            result['TerrorismResult'] = self.terrorism_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultAdResult()
            self.ad_result = temp_model.from_map(m['AdResult'])
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('LiveResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLiveResult()
            self.live_result = temp_model.from_map(m['LiveResult'])
        if m.get('LogoResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultLogoResult()
            self.logo_result = temp_model.from_map(m['LogoResult'])
        if m.get('PornResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultPornResult()
            self.porn_result = temp_model.from_map(m['PornResult'])
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TerrorismResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResultTerrorismResult()
            self.terrorism_result = temp_model.from_map(m['TerrorismResult'])
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJobData(TeaModel):
    def __init__(self, abnormal_modules=None, audio_result=None, image_result=None, label=None, suggestion=None,
                 text_result=None, video_result=None):
        # The content that violates the regulations. Separate multiple values with commas (,). Valid values:
        # 
        # *   **video**: the video.
        # *   **image-cover**: the cover.
        # *   **text-title**: the title.
        self.abnormal_modules = abnormal_modules  # type: str
        # The results of audio review.
        self.audio_result = audio_result  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataAudioResult]
        # The results of image review.
        self.image_result = image_result  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResult]
        # The category of the review result. Separate multiple values with commas (,). Valid values:
        # 
        # *   **porn**\
        # *   **terrorism**\
        # *   **ad**\
        # *   **live**: undesirable scenes
        # *   **logo**\
        # *   **audio**: audio anti-spam
        # *   **normal**\
        self.label = label  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**: The content violates the regulations.
        # *   **review**: The content may violate the regulations.
        # *   **pass**: The content passes the review.
        self.suggestion = suggestion  # type: str
        # The results of text review.
        self.text_result = text_result  # type: list[GetAIMediaAuditJobResponseBodyMediaAuditJobDataTextResult]
        # The results of video review.
        self.video_result = video_result  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResult

    def validate(self):
        if self.audio_result:
            for k in self.audio_result:
                if k:
                    k.validate()
        if self.image_result:
            for k in self.image_result:
                if k:
                    k.validate()
        if self.text_result:
            for k in self.text_result:
                if k:
                    k.validate()
        if self.video_result:
            self.video_result.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJobData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_modules is not None:
            result['AbnormalModules'] = self.abnormal_modules
        result['AudioResult'] = []
        if self.audio_result is not None:
            for k in self.audio_result:
                result['AudioResult'].append(k.to_map() if k else None)
        result['ImageResult'] = []
        if self.image_result is not None:
            for k in self.image_result:
                result['ImageResult'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TextResult'] = []
        if self.text_result is not None:
            for k in self.text_result:
                result['TextResult'].append(k.to_map() if k else None)
        if self.video_result is not None:
            result['VideoResult'] = self.video_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbnormalModules') is not None:
            self.abnormal_modules = m.get('AbnormalModules')
        self.audio_result = []
        if m.get('AudioResult') is not None:
            for k in m.get('AudioResult'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataAudioResult()
                self.audio_result.append(temp_model.from_map(k))
        self.image_result = []
        if m.get('ImageResult') is not None:
            for k in m.get('ImageResult'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataImageResult()
                self.image_result.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.text_result = []
        if m.get('TextResult') is not None:
            for k in m.get('TextResult'):
                temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataTextResult()
                self.text_result.append(temp_model.from_map(k))
        if m.get('VideoResult') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobDataVideoResult()
            self.video_result = temp_model.from_map(m['VideoResult'])
        return self


class GetAIMediaAuditJobResponseBodyMediaAuditJob(TeaModel):
    def __init__(self, code=None, complete_time=None, creation_time=None, data=None, job_id=None, media_id=None,
                 message=None, status=None, type=None):
        # The error code. This parameter is returned if the value of Status is fail.
        self.code = code  # type: str
        # The time when the job is complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the job started to run. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The job result data.
        self.data = data  # type: GetAIMediaAuditJobResponseBodyMediaAuditJobData
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The ID of the video.
        self.media_id = media_id  # type: str
        # The error message. This parameter is returned if the value of Status is fail.
        self.message = message  # type: str
        # The status of the job. Valid values:
        # 
        # *   **success**: The job is successful.
        # *   **fail**: The job failed.
        # *   **init**: The job is being initialized.
        # *   **Processing**: The job is in progress.
        self.status = status  # type: str
        # Only the job type is supported.
        self.type = type  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBodyMediaAuditJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Data') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJobData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAIMediaAuditJobResponseBody(TeaModel):
    def __init__(self, media_audit_job=None, request_id=None):
        # The information about the intelligent review job.
        self.media_audit_job = media_audit_job  # type: GetAIMediaAuditJobResponseBodyMediaAuditJob
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_audit_job:
            self.media_audit_job.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_audit_job is not None:
            result['MediaAuditJob'] = self.media_audit_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaAuditJob') is not None:
            temp_model = GetAIMediaAuditJobResponseBodyMediaAuditJob()
            self.media_audit_job = temp_model.from_map(m['MediaAuditJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAIMediaAuditJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAIMediaAuditJobResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAIMediaAuditJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAIMediaAuditJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAITemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        # The ID of the AI template. You can use one of the following methods to obtain the ID:
        # 
        # *   Call the [AddAITemplate](~~102930~~) operation to add an AI template if no AI template exists. The value of TemplateId in the response is the ID of the AI template.
        # *   Call the [ListAITemplate](~~102936~~) operation if the template already exists. The value of TemplateId in the response is the ID of the AI template.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAITemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetAITemplateResponseBodyTemplateInfo(TeaModel):
    def __init__(self, creation_time=None, is_default=None, modify_time=None, source=None, template_config=None,
                 template_id=None, template_name=None, template_type=None):
        # The time when the AI template was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template is the default AI template. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # The time when the AI template was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The source of the AI template. Valid values:
        # 
        # *   **System**\
        # *   **Custom**\
        self.source = source  # type: str
        # The detailed configurations of the AI template. The value is a JSON string. For more information, see [AITemplateConfig](~~89863#title-vd3-499-o36~~).
        self.template_config = template_config  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str
        # The name of the AI template.
        self.template_name = template_name  # type: str
        # The type of the AI template. Valid values:
        # 
        # *   **AIMediaAudit**: automated review
        # *   **AIImage**: smart thumbnail
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAITemplateResponseBodyTemplateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.source is not None:
            result['Source'] = self.source
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class GetAITemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the AI template.
        self.template_info = template_info  # type: GetAITemplateResponseBodyTemplateInfo

    def validate(self):
        if self.template_info:
            self.template_info.validate()

    def to_map(self):
        _map = super(GetAITemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_info is not None:
            result['TemplateInfo'] = self.template_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateInfo') is not None:
            temp_model = GetAITemplateResponseBodyTemplateInfo()
            self.template_info = temp_model.from_map(m['TemplateInfo'])
        return self


class GetAITemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAITemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAITemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAITemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAIVideoTagResultRequest(TeaModel):
    def __init__(self, media_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the media file. You can use one of the following methods to obtain the ID:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you call to upload media files.
        # *   Obtain the value of VideoId from the response to the [SearchMedia](~~86044~~) operation after you upload media files.
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResultCategory(TeaModel):
    def __init__(self, tag=None):
        # The tag string.
        self.tag = tag  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResultCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResultKeyword(TeaModel):
    def __init__(self, tag=None, times=None):
        # The tag string.
        self.tag = tag  # type: str
        # The points in time when the tags are displayed. Unit: milliseconds.
        self.times = times  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResultKeyword, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResultLocation(TeaModel):
    def __init__(self, tag=None, times=None):
        # The tag string.
        self.tag = tag  # type: str
        # The points in time when the tags are displayed. Unit: milliseconds.
        self.times = times  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResultLocation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResultPerson(TeaModel):
    def __init__(self, face_url=None, tag=None, times=None):
        # The URL of the profile photo.
        # 
        # > This parameter is returned only when a figure tag was used.
        self.face_url = face_url  # type: str
        # The tag string.
        self.tag = tag  # type: str
        # The points in time when the tags are displayed. Unit: milliseconds.
        self.times = times  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResultPerson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResultTime(TeaModel):
    def __init__(self, tag=None, times=None):
        # The tag string.
        self.tag = tag  # type: str
        # The points in time when the tags are displayed. Unit: milliseconds.
        self.times = times  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResultTime, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class GetAIVideoTagResultResponseBodyVideoTagResult(TeaModel):
    def __init__(self, category=None, keyword=None, location=None, person=None, time=None):
        # The video categories.
        self.category = category  # type: list[GetAIVideoTagResultResponseBodyVideoTagResultCategory]
        # The keyword tags.
        self.keyword = keyword  # type: list[GetAIVideoTagResultResponseBodyVideoTagResultKeyword]
        # The location tags.
        self.location = location  # type: list[GetAIVideoTagResultResponseBodyVideoTagResultLocation]
        # The figure tags.
        self.person = person  # type: list[GetAIVideoTagResultResponseBodyVideoTagResultPerson]
        # The time tags.
        self.time = time  # type: list[GetAIVideoTagResultResponseBodyVideoTagResultTime]

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()
        if self.keyword:
            for k in self.keyword:
                if k:
                    k.validate()
        if self.location:
            for k in self.location:
                if k:
                    k.validate()
        if self.person:
            for k in self.person:
                if k:
                    k.validate()
        if self.time:
            for k in self.time:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBodyVideoTagResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        result['Keyword'] = []
        if self.keyword is not None:
            for k in self.keyword:
                result['Keyword'].append(k.to_map() if k else None)
        result['Location'] = []
        if self.location is not None:
            for k in self.location:
                result['Location'].append(k.to_map() if k else None)
        result['Person'] = []
        if self.person is not None:
            for k in self.person:
                result['Person'].append(k.to_map() if k else None)
        result['Time'] = []
        if self.time is not None:
            for k in self.time:
                result['Time'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = GetAIVideoTagResultResponseBodyVideoTagResultCategory()
                self.category.append(temp_model.from_map(k))
        self.keyword = []
        if m.get('Keyword') is not None:
            for k in m.get('Keyword'):
                temp_model = GetAIVideoTagResultResponseBodyVideoTagResultKeyword()
                self.keyword.append(temp_model.from_map(k))
        self.location = []
        if m.get('Location') is not None:
            for k in m.get('Location'):
                temp_model = GetAIVideoTagResultResponseBodyVideoTagResultLocation()
                self.location.append(temp_model.from_map(k))
        self.person = []
        if m.get('Person') is not None:
            for k in m.get('Person'):
                temp_model = GetAIVideoTagResultResponseBodyVideoTagResultPerson()
                self.person.append(temp_model.from_map(k))
        self.time = []
        if m.get('Time') is not None:
            for k in m.get('Time'):
                temp_model = GetAIVideoTagResultResponseBodyVideoTagResultTime()
                self.time.append(temp_model.from_map(k))
        return self


class GetAIVideoTagResultResponseBody(TeaModel):
    def __init__(self, request_id=None, video_tag_result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The returned result.
        self.video_tag_result = video_tag_result  # type: GetAIVideoTagResultResponseBodyVideoTagResult

    def validate(self):
        if self.video_tag_result:
            self.video_tag_result.validate()

    def to_map(self):
        _map = super(GetAIVideoTagResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.video_tag_result is not None:
            result['VideoTagResult'] = self.video_tag_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VideoTagResult') is not None:
            temp_model = GetAIVideoTagResultResponseBodyVideoTagResult()
            self.video_tag_result = temp_model.from_map(m['VideoTagResult'])
        return self


class GetAIVideoTagResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAIVideoTagResultResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAIVideoTagResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAIVideoTagResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAppInfosRequest(TeaModel):
    def __init__(self, app_ids=None):
        # The ID of the application. You can specify a maximum of 10 application IDs. Separate them with commas (,).
        self.app_ids = app_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAppInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_ids is not None:
            result['AppIds'] = self.app_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppIds') is not None:
            self.app_ids = m.get('AppIds')
        return self


class GetAppInfosResponseBodyAppInfoList(TeaModel):
    def __init__(self, app_id=None, app_name=None, creation_time=None, description=None, modification_time=None,
                 status=None, type=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The name of the application.
        self.app_name = app_name  # type: str
        # The time when the application was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the application.
        self.description = description  # type: str
        # The last time when the application was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The status of the application. Valid values:
        # - **Normal**\
        # - **Disable**\
        self.status = status  # type: str
        # The type of the application. Valid values:
        # - **System**\
        # - **Custom**\
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAppInfosResponseBodyAppInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAppInfosResponseBody(TeaModel):
    def __init__(self, app_info_list=None, code=None, non_exist_app_ids=None, request_id=None):
        # The details of each application.
        self.app_info_list = app_info_list  # type: list[GetAppInfosResponseBodyAppInfoList]
        # The HTTP status code that is returned.
        self.code = code  # type: str
        # The ID of the application that was not found.
        self.non_exist_app_ids = non_exist_app_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.app_info_list:
            for k in self.app_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAppInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AppInfoList'] = []
        if self.app_info_list is not None:
            for k in self.app_info_list:
                result['AppInfoList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.non_exist_app_ids is not None:
            result['NonExistAppIds'] = self.non_exist_app_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.app_info_list = []
        if m.get('AppInfoList') is not None:
            for k in m.get('AppInfoList'):
                temp_model = GetAppInfosResponseBodyAppInfoList()
                self.app_info_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('NonExistAppIds') is not None:
            self.non_exist_app_ids = m.get('NonExistAppIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAppInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAppInfosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAppInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAppInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAttachedMediaInfoRequest(TeaModel):
    def __init__(self, auth_timeout=None, media_ids=None, output_type=None):
        # The validity period of the URL of the auxiliary media asset. Unit: seconds.
        # > *   If the OutputType parameter is set to **cdn**:
        # >     *   The URL of the auxiliary media asset has a validity period only if URL signing is enabled. Otherwise, the URL of the auxiliary media asset is permanently valid.
        # >     *   Minimum value: **1**.
        # >     *   Maximum value: unlimited.
        # >     *   Default value: If you do not set this parameter, the default validity period that is specified in URL signing is used.
        # > *   If the OutputType parameter is set to **oss**:
        # >     *   The URL of the auxiliary media asset has a validity period only if the permissions on the Object Storage Service (OSS) bucket are private. Otherwise, the URL of the auxiliary media asset is permanently valid.
        # >     *   Minimum value: **1**.
        # >     *   Maximum value: **2592000** (30 days). The maximum value is limited to reduce security risks of the origin.
        # >     *   Default value: If you do not set this parameter, the default value is **3600**.
        self.auth_timeout = auth_timeout  # type: long
        # The ID of the auxiliary media asset. Separate multiple IDs with commas (,). A maximum of 20 IDs can be specified.
        self.media_ids = media_ids  # type: str
        # The type of the URL of the auxiliary media asset. Valid values:
        # *   **oss**: OSS URL
        # *   **cdn** (default): Content Delivery Network (CDN) URL
        self.output_type = output_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAttachedMediaInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        return self


class GetAttachedMediaInfoResponseBodyAttachedMediaListCategories(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None):
        # The ID of the video category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        # - The value can be up to 64 bytes in length.
        # - The string must be encoded in the UTF-8 format.
        self.cate_name = cate_name  # type: str
        # The level of the category. A value of 0 indicates a level 1 category.
        self.level = level  # type: long
        # The ID of the parent category. The parent category ID of a level 1 category is -1.
        self.parent_id = parent_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAttachedMediaInfoResponseBodyAttachedMediaListCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class GetAttachedMediaInfoResponseBodyAttachedMediaList(TeaModel):
    def __init__(self, app_id=None, categories=None, creation_time=None, description=None, media_id=None,
                 modification_time=None, status=None, storage_location=None, tags=None, title=None, type=None, url=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The list of categories.
        self.categories = categories  # type: list[GetAttachedMediaInfoResponseBodyAttachedMediaListCategories]
        # The time when the auxiliary media asset was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the auxiliary media asset.
        self.description = description  # type: str
        # The ID of the auxiliary media asset.
        self.media_id = media_id  # type: str
        # The time when the auxiliary media asset was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The status of the auxiliary media asset. Valid values:
        # - **Uploading**: The auxiliary media asset is being uploaded. This is the initial status.
        # - **Normal**: The auxiliary media asset is uploaded.
        # - **UploadFail**: The auxiliary media asset fails to be uploaded.
        self.status = status  # type: str
        # The OSS bucket where the auxiliary media asset is stored.
        self.storage_location = storage_location  # type: str
        # The tags of the auxiliary media asset.
        self.tags = tags  # type: str
        # The title of the auxiliary media asset.
        self.title = title  # type: str
        # The type of the auxiliary media asset. Valid values:
        # - **watermark**\
        # - **subtitle**\
        # - **material**\
        self.type = type  # type: str
        # The URL of the auxiliary media asset.
        # > If a CDN domain name is specified, a CDN URL is returned. Otherwise, an OSS URL is returned.
        self.url = url  # type: str

    def validate(self):
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAttachedMediaInfoResponseBodyAttachedMediaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        result['Categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['Categories'].append(k.to_map() if k else None)
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        self.categories = []
        if m.get('Categories') is not None:
            for k in m.get('Categories'):
                temp_model = GetAttachedMediaInfoResponseBodyAttachedMediaListCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class GetAttachedMediaInfoResponseBody(TeaModel):
    def __init__(self, attached_media_list=None, non_exist_media_ids=None, request_id=None):
        # The information about the media asset.
        self.attached_media_list = attached_media_list  # type: list[GetAttachedMediaInfoResponseBodyAttachedMediaList]
        # The IDs of the auxiliary media assets that do not exist.
        self.non_exist_media_ids = non_exist_media_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.attached_media_list:
            for k in self.attached_media_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAttachedMediaInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachedMediaList'] = []
        if self.attached_media_list is not None:
            for k in self.attached_media_list:
                result['AttachedMediaList'].append(k.to_map() if k else None)
        if self.non_exist_media_ids is not None:
            result['NonExistMediaIds'] = self.non_exist_media_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.attached_media_list = []
        if m.get('AttachedMediaList') is not None:
            for k in m.get('AttachedMediaList'):
                temp_model = GetAttachedMediaInfoResponseBodyAttachedMediaList()
                self.attached_media_list.append(temp_model.from_map(k))
        if m.get('NonExistMediaIds') is not None:
            self.non_exist_media_ids = m.get('NonExistMediaIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAttachedMediaInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAttachedMediaInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAttachedMediaInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAttachedMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAuditHistoryRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, sort_by=None, video_id=None):
        # The number of the page to return. Default value: **1**.
        self.page_no = page_no  # type: long
        # The number of entries to return on each page. Default value: **10**. Maximum value: **100**.
        self.page_size = page_size  # type: long
        # The sorting rule of the results. Valid values:
        # *   **CreationTime:Desc**: sorts the results based on the creation time in descending order. This is the default value.
        # *   **CreationTime:Asc**: sorts the results based on the creation time in ascending order.
        self.sort_by = sort_by  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAuditHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetAuditHistoryResponseBodyHistories(TeaModel):
    def __init__(self, auditor=None, comment=None, creation_time=None, reason=None, status=None):
        # The reviewer.
        self.auditor = auditor  # type: str
        # The review comments, which are provided by the reviewer.
        self.comment = comment  # type: str
        # The time when the review record was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The reason why the video failed the review. If the video failed the review, specify the reason.
        self.reason = reason  # type: str
        # The manual review result. Valid values:
        # - **Normal**: The video can be played.
        # - **Blocked**: The video is blocked.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAuditHistoryResponseBodyHistories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auditor is not None:
            result['Auditor'] = self.auditor
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Auditor') is not None:
            self.auditor = m.get('Auditor')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetAuditHistoryResponseBody(TeaModel):
    def __init__(self, histories=None, request_id=None, status=None, total=None):
        # The review records.
        self.histories = histories  # type: list[GetAuditHistoryResponseBodyHistories]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The manual review result. Valid values:
        # - **Normal**: The video can be played.
        # - **Blocked**: The video is blocked.
        self.status = status  # type: str
        # The total number of review records.
        self.total = total  # type: long

    def validate(self):
        if self.histories:
            for k in self.histories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAuditHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Histories'] = []
        if self.histories is not None:
            for k in self.histories:
                result['Histories'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.histories = []
        if m.get('Histories') is not None:
            for k in m.get('Histories'):
                temp_model = GetAuditHistoryResponseBodyHistories()
                self.histories.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAuditHistoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAuditHistoryResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAuditHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAuditHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCategoriesRequest(TeaModel):
    def __init__(self, cate_id=None, page_no=None, page_size=None, sort_by=None, type=None):
        # The ID of the category. Default value: **-1**, which indicates the parent category ID of a level 1 category.
        self.cate_id = cate_id  # type: long
        # The number of the page where the subcategories to be returned are listed. Default value: **1**.
        self.page_no = page_no  # type: long
        # The number of entries to return on each page of the subcategory list. Default value: **10**. Maximum value: **100**.
        self.page_size = page_size  # type: long
        # The method for sorting the results. Valid values:
        # 
        # *   **CreationTime:Desc** (default): The results are sorted in reverse chronological order based on the creation time.
        # *   **CreationTime:Asc**: The results are sorted in chronological order based on the creation time.
        self.sort_by = sort_by  # type: str
        # The type of the category. Valid values:
        # 
        # *   **default** (default): default category
        # *   **material**: material category
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodyCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, type=None):
        # The ID of the video category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        # *   The value can be up to 64 bytes in length.
        # *   The string must be encoded in the UTF-8 format.
        self.cate_name = cate_name  # type: str
        # The level of the category. A value of **0** indicates a level 1 category.
        self.level = level  # type: long
        # The ID of the parent category. The parent category ID of a level 1 category is **-1**.
        self.parent_id = parent_id  # type: long
        # The type of the category. Valid values:
        # *   **default** (default): default category
        # *   **material**: material category
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesResponseBodyCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategoriesCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, sub_total=None, type=None):
        # The ID of the video category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        # *   The value can be up to 64 bytes in length.
        # *   The string must be encoded in the UTF-8 format.
        self.cate_name = cate_name  # type: str
        # The level of the category. A value of **0** indicates a level 1 category.
        self.level = level  # type: long
        # The ID of the parent category. The parent category ID of a level 1 category is **-1**.
        self.parent_id = parent_id  # type: long
        # The total number of subcategories.
        self.sub_total = sub_total  # type: long
        # The type of the category. Valid values:
        # 
        # *   **default** (default): default category
        # *   **material**: material category
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesResponseBodySubCategoriesCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategories(TeaModel):
    def __init__(self, category=None):
        self.category = category  # type: list[GetCategoriesResponseBodySubCategoriesCategory]

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCategoriesResponseBodySubCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = GetCategoriesResponseBodySubCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class GetCategoriesResponseBody(TeaModel):
    def __init__(self, category=None, request_id=None, sub_categories=None, sub_total=None):
        # The information about the specified category.
        self.category = category  # type: GetCategoriesResponseBodyCategory
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The list of subcategories.
        self.sub_categories = sub_categories  # type: GetCategoriesResponseBodySubCategories
        # The total number of subcategories.
        self.sub_total = sub_total  # type: long

    def validate(self):
        if self.category:
            self.category.validate()
        if self.sub_categories:
            self.sub_categories.validate()

    def to_map(self):
        _map = super(GetCategoriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_categories is not None:
            result['SubCategories'] = self.sub_categories.to_map()
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = GetCategoriesResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubCategories') is not None:
            temp_model = GetCategoriesResponseBodySubCategories()
            self.sub_categories = temp_model.from_map(m['SubCategories'])
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        return self


class GetCategoriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCategoriesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCategoriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDefaultAITemplateRequest(TeaModel):
    def __init__(self, template_type=None):
        # The type of the AI template. Set the value to **AIMediaAudit**, which specifies the automated review.
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDefaultAITemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class GetDefaultAITemplateResponseBodyTemplateInfo(TeaModel):
    def __init__(self, creation_time=None, is_default=None, modify_time=None, source=None, template_config=None,
                 template_id=None, template_name=None, template_type=None):
        # The time when the AI template was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template is the default AI template. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # The time when the AI template was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The source of the AI template. Valid values:
        # 
        # *   **System**\
        # *   **Custom**\
        self.source = source  # type: str
        # The detailed configurations of the AI template. The value is a JSON string. For more information, see [AITemplateConfig](~~89863#title-vd3-499-o36~~).
        self.template_config = template_config  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str
        # The name of the AI template.
        self.template_name = template_name  # type: str
        # The type of the AI template. The value is **AIMediaAudit**, which indicates automated review.
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDefaultAITemplateResponseBodyTemplateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.source is not None:
            result['Source'] = self.source
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class GetDefaultAITemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the AI template.
        self.template_info = template_info  # type: GetDefaultAITemplateResponseBodyTemplateInfo

    def validate(self):
        if self.template_info:
            self.template_info.validate()

    def to_map(self):
        _map = super(GetDefaultAITemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_info is not None:
            result['TemplateInfo'] = self.template_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateInfo') is not None:
            temp_model = GetDefaultAITemplateResponseBodyTemplateInfo()
            self.template_info = temp_model.from_map(m['TemplateInfo'])
        return self


class GetDefaultAITemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDefaultAITemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDefaultAITemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDefaultAITemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDigitalWatermarkExtractResultRequest(TeaModel):
    def __init__(self, extract_type=None, job_id=None, media_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The type of the digital watermark. Valid values:
        # 
        # *   TraceMark: tracing watermark
        # *   CopyrightMark: copyright watermark
        self.extract_type = extract_type  # type: str
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The ID of the video file. You can query the video ID by using the ApsaraVideo VOD console or calling the SearchMedia operation.
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDigitalWatermarkExtractResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extract_type is not None:
            result['ExtractType'] = self.extract_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtractType') is not None:
            self.extract_type = m.get('ExtractType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetDigitalWatermarkExtractResultResponseBodyAiExtractResultList(TeaModel):
    def __init__(self, create_time=None, error_message=None, job_id=None, modify_time=None, status=None,
                 water_mark_text=None):
        # The time when the job was created.
        self.create_time = create_time  # type: str
        # The error message.
        self.error_message = error_message  # type: str
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The time when the job was modified.
        self.modify_time = modify_time  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Success**\
        # *   **Failed**\
        # *   **Processing**\
        self.status = status  # type: str
        # The extracted watermark text.
        self.water_mark_text = water_mark_text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDigitalWatermarkExtractResultResponseBodyAiExtractResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.status is not None:
            result['Status'] = self.status
        if self.water_mark_text is not None:
            result['WaterMarkText'] = self.water_mark_text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WaterMarkText') is not None:
            self.water_mark_text = m.get('WaterMarkText')
        return self


class GetDigitalWatermarkExtractResultResponseBody(TeaModel):
    def __init__(self, ai_extract_result_list=None, request_id=None):
        # The information about the job.
        self.ai_extract_result_list = ai_extract_result_list  # type: list[GetDigitalWatermarkExtractResultResponseBodyAiExtractResultList]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.ai_extract_result_list:
            for k in self.ai_extract_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDigitalWatermarkExtractResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AiExtractResultList'] = []
        if self.ai_extract_result_list is not None:
            for k in self.ai_extract_result_list:
                result['AiExtractResultList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ai_extract_result_list = []
        if m.get('AiExtractResultList') is not None:
            for k in m.get('AiExtractResultList'):
                temp_model = GetDigitalWatermarkExtractResultResponseBodyAiExtractResultList()
                self.ai_extract_result_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDigitalWatermarkExtractResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDigitalWatermarkExtractResultResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDigitalWatermarkExtractResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDigitalWatermarkExtractResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, project_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        # The ID of the online editing project.
        self.project_id = project_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetEditingProjectResponseBodyProject(TeaModel):
    def __init__(self, cover_url=None, creation_time=None, description=None, modified_time=None, project_id=None,
                 region_id=None, status=None, storage_location=None, timeline=None, title=None):
        # The thumbnail URL of the online editing project.
        self.cover_url = cover_url  # type: str
        # The time when the online editing project was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the online editing project.
        self.description = description  # type: str
        # The last time when the online editing project was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modified_time = modified_time  # type: str
        # The ID of the online editing project.
        self.project_id = project_id  # type: str
        # The region where the online editing project was created.
        self.region_id = region_id  # type: str
        # The status of the online editing project. Separate multiple states with commas (,). By default, all online editing projects were queried. Valid values:
        # 
        # *   **Normal**: indicates that the online editing project is in draft.
        # *   **Producing**: indicates that the video is being produced.
        # *   **Produced**: indicates that the video was produced.
        # *   **ProduceFailed**: indicates that the video failed to be produced.
        self.status = status  # type: str
        # The path of the Object Storage Service (OSS) bucket where the online editing project is stored.
        # 
        # > To view the path of the OSS bucket, log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com/?spm=a2c4g.11186623.2.15.6948257eaZ4m54#/vod/settings/censored), and choose **Configuration Management** > **Media Management** > **Storage**. On the Storage page, you can view the path of the OSS bucket.
        self.storage_location = storage_location  # type: str
        # The timeline of the online editing project.
        self.timeline = timeline  # type: str
        # The title of the online editing project.
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectResponseBodyProject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetEditingProjectResponseBody(TeaModel):
    def __init__(self, project=None, request_id=None):
        # The information about the online editing project.
        self.project = project  # type: GetEditingProjectResponseBodyProject
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super(GetEditingProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = GetEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEditingProjectResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEditingProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, material_type=None, owner_account=None, owner_id=None, project_id=None,
                 resource_owner_account=None, resource_owner_id=None, type=None):
        # The type of the material. Valid values:
        # 
        # *   **video**\
        # *   **audio**\
        # *   **image**\
        self.material_type = material_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        # The ID of the online editing project. You can use one of the following methods to obtain the ID of the online editing project:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Production Center** > **Video Editing** to obtain the ID of the specified online editing project.
        # *   Call the **AddEditingProject** operation. The value of the response parameter ProjectId is the ID of the specified online editing project.
        self.project_id = project_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str
        # The type of the material. Valid values:
        # 
        # *   **video**\
        # *   **audio**\
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEditingProjectMaterialsResponseBodyMaterialListMaterialSnapshots(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMaterialListMaterialSnapshots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot is not None:
            result['Snapshot'] = self.snapshot
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Snapshot') is not None:
            self.snapshot = m.get('Snapshot')
        return self


class GetEditingProjectMaterialsResponseBodyMaterialListMaterialSprites(TeaModel):
    def __init__(self, sprite=None):
        self.sprite = sprite  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMaterialListMaterialSprites, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sprite is not None:
            result['Sprite'] = self.sprite
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Sprite') is not None:
            self.sprite = m.get('Sprite')
        return self


class GetEditingProjectMaterialsResponseBodyMaterialListMaterial(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, cover_url=None, creation_time=None, description=None,
                 duration=None, material_id=None, material_type=None, modified_time=None, size=None, snapshots=None,
                 source=None, sprite_config=None, sprites=None, status=None, tags=None, title=None):
        # The category ID of the material.
        self.cate_id = cate_id  # type: int
        # The category name of the material.
        self.cate_name = cate_name  # type: str
        # The thumbnail URL of the material.
        self.cover_url = cover_url  # type: str
        # The time when the material was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the material.
        self.description = description  # type: str
        # The duration of the material. The value is rounded to four decimal places. Unit: seconds.
        self.duration = duration  # type: float
        # The ID of the material.
        self.material_id = material_id  # type: str
        # The type of the material. Valid values:
        # 
        # *   **video**\
        # *   **audio**\
        # *   **image**\
        self.material_type = material_type  # type: str
        # The time when the material was last updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modified_time = modified_time  # type: str
        # The size of the mezzanine file. Unit: byte.
        self.size = size  # type: long
        # The URLs of material snapshots. The value is an array.
        self.snapshots = snapshots  # type: GetEditingProjectMaterialsResponseBodyMaterialListMaterialSnapshots
        # The source of the sprite.
        self.source = source  # type: str
        # The configuration of the sprite.
        self.sprite_config = sprite_config  # type: str
        # The URLs of material sprites. The value is an array.
        self.sprites = sprites  # type: GetEditingProjectMaterialsResponseBodyMaterialListMaterialSprites
        # The status of the material. Valid values:
        # 
        # *   **Normal**: The material is in draft.
        # *   **Producing**: The material is being produced.
        # *   **Produced**: The material was produced.
        # *   **ProduceFailed**: The material failed to be produced.
        self.status = status  # type: str
        # The tag of the material. Multiple tags are separated by commas (,).
        self.tags = tags  # type: str
        # The title of the material.
        self.title = title  # type: str

    def validate(self):
        if self.snapshots:
            self.snapshots.validate()
        if self.sprites:
            self.sprites.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMaterialListMaterial, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots.to_map()
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_config is not None:
            result['SpriteConfig'] = self.sprite_config
        if self.sprites is not None:
            result['Sprites'] = self.sprites.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMaterialListMaterialSnapshots()
            self.snapshots = temp_model.from_map(m['Snapshots'])
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteConfig') is not None:
            self.sprite_config = m.get('SpriteConfig')
        if m.get('Sprites') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMaterialListMaterialSprites()
            self.sprites = temp_model.from_map(m['Sprites'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetEditingProjectMaterialsResponseBodyMaterialList(TeaModel):
    def __init__(self, material=None):
        self.material = material  # type: list[GetEditingProjectMaterialsResponseBodyMaterialListMaterial]

    def validate(self):
        if self.material:
            for k in self.material:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMaterialList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Material'] = []
        if self.material is not None:
            for k in self.material:
                result['Material'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.material = []
        if m.get('Material') is not None:
            for k in m.get('Material'):
                temp_model = GetEditingProjectMaterialsResponseBodyMaterialListMaterial()
                self.material.append(temp_model.from_map(k))
        return self


class GetEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, material_list=None, request_id=None):
        # The materials.
        self.material_list = material_list  # type: GetEditingProjectMaterialsResponseBodyMaterialList
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.material_list:
            self.material_list.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_list is not None:
            result['MaterialList'] = self.material_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialList') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMaterialList()
            self.material_list = temp_model.from_map(m['MaterialList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEditingProjectMaterialsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetImageInfoRequest(TeaModel):
    def __init__(self, auth_timeout=None, image_id=None, output_type=None):
        # The validity period of the image URL. Unit: seconds.
        # 
        # > *   If the OutputType parameter is set to **cdn**:
        # >     *   The image URL has a validity period only if URL signing is enabled. Otherwise, the image URL is permanently valid.
        # >     *   Minimum value: **1**.
        # >     *   Maximum value: unlimited.
        # >     *   Default value: If you do not set this parameter, the default validity period that is specified in URL signing is used.
        # > *   If the OutputType parameter is set to **oss**:
        # >     *   The image URL has a validity period only if the permissions on the Object Storage Service (OSS) bucket are private. Otherwise, the image URL is permanently valid.
        # >     *   Minimum value: **1**.
        # >     *   Maximum value: **2592000** (30 days). The maximum value is limited to reduce security risks of the origin.
        # >     *   Default value: If you do not set this parameter, the default value is **3600**.
        self.auth_timeout = auth_timeout  # type: long
        # The ID of the image.
        self.image_id = image_id  # type: str
        # The type of the image URL. Valid values:
        # 
        # *   **oss**: OSS URL
        # *   **cdn** (default): Content Delivery Network (CDN) URL
        self.output_type = output_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetImageInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        return self


class GetImageInfoResponseBodyImageInfoMezzanine(TeaModel):
    def __init__(self, file_size=None, file_url=None, height=None, original_file_name=None, width=None):
        # The size of the file. Unit: byte.
        self.file_size = file_size  # type: str
        # The OSS URL of the image.
        self.file_url = file_url  # type: str
        # The height of the image. Unit: pixel.
        self.height = height  # type: int
        # The name of the uploaded file.
        self.original_file_name = original_file_name  # type: str
        # The width of the image. Unit: pixel.
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetImageInfoResponseBodyImageInfoMezzanine, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.height is not None:
            result['Height'] = self.height
        if self.original_file_name is not None:
            result['OriginalFileName'] = self.original_file_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OriginalFileName') is not None:
            self.original_file_name = m.get('OriginalFileName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetImageInfoResponseBodyImageInfo(TeaModel):
    def __init__(self, app_id=None, cate_id=None, cate_name=None, creation_time=None, description=None,
                 image_id=None, image_type=None, mezzanine=None, status=None, storage_location=None, tags=None, title=None,
                 url=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The ID of the category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        self.cate_name = cate_name  # type: str
        # The time when the image file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the image.
        self.description = description  # type: str
        # The ID of the image.
        self.image_id = image_id  # type: str
        # The type of the image. Valid values:
        # 
        # - **CoverSnapshot**: thumbnail snapshot.
        # - **NormalSnapshot**: normal snapshot.
        # - **SpriteSnapshot**: sprite snapshot.
        # - **SpriteOriginSnapshot**: sprite source snapshot.
        # - **All**: images of all the preceding types. If this parameter is not set to All, you can specify multiple types and separate them with commas (,).
        self.image_type = image_type  # type: str
        # The information about the image mezzanine file.
        self.mezzanine = mezzanine  # type: GetImageInfoResponseBodyImageInfoMezzanine
        # The status of the image. Valid values:
        # 
        # - **Uploading**: The image is being uploaded. This is the initial status.
        # - **Normal**: The image is uploaded.
        # - **UploadFail**: The image fails to be uploaded.
        self.status = status  # type: str
        # The OSS bucket where the image is stored.
        self.storage_location = storage_location  # type: str
        # The tag of the image. Multiple tags are separated by commas (,).
        self.tags = tags  # type: str
        # The title of the image.
        self.title = title  # type: str
        # The URL of the image. If a CDN domain name is specified, a CDN URL is returned. Otherwise, an OSS URL is returned.
        self.url = url  # type: str

    def validate(self):
        if self.mezzanine:
            self.mezzanine.validate()

    def to_map(self):
        _map = super(GetImageInfoResponseBodyImageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.mezzanine is not None:
            result['Mezzanine'] = self.mezzanine.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('Mezzanine') is not None:
            temp_model = GetImageInfoResponseBodyImageInfoMezzanine()
            self.mezzanine = temp_model.from_map(m['Mezzanine'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class GetImageInfoResponseBody(TeaModel):
    def __init__(self, image_info=None, request_id=None):
        # The information about the image.
        self.image_info = image_info  # type: GetImageInfoResponseBodyImageInfo
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.image_info:
            self.image_info.validate()

    def to_map(self):
        _map = super(GetImageInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_info is not None:
            result['ImageInfo'] = self.image_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageInfo') is not None:
            temp_model = GetImageInfoResponseBodyImageInfo()
            self.image_info = temp_model.from_map(m['ImageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetImageInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetImageInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetImageInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetImageInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetImageInfosRequest(TeaModel):
    def __init__(self, auth_timeout=None, image_ids=None, output_type=None):
        # The time when the image URL expires. Unit: seconds.
        # 
        # *   If the OutputType parameter is set to cdn:
        # 
        #     *   This parameter takes effect only if URL authentication is enabled. Otherwise, the image URL does not expire.
        #     *   Minimum value: 1.
        #     *   Maximum value: unlimited.
        #     *   Default value: The default validity period that is specified in URL authentication is used.
        # 
        # *   If the OutputType parameter is set to oss:
        # 
        #     *   This parameter takes effect only when the ACL of the Object Storage Service (OSS) bucket is private. Otherwise, the image URL does not expire.
        #     *   Minimum value: 1.
        #     *   Maximum value: 2592000 (30 days). This limit is imposed to reduce security risks of the origin server.
        #     *   Default value: 3600.
        self.auth_timeout = auth_timeout  # type: long
        # The image IDs. Separate multiple IDs with commas (,). You can specify a maximum of 20 image IDs. You can use one of the following methods to obtain the image ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com/) and choose Media Files > Images in the left-side navigation pane. This method is applicable to images that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of ImageId from the response to the [CreateUploadImage](~~436544~~) operation that you call to obtain the upload URL and credential.
        # *   Obtain the value of ImageId from the response to the [SearchMedia](~~436559~~) operation after you upload images.
        self.image_ids = image_ids  # type: str
        # The type of the output image URL. Valid values:
        # 
        # *   oss: OSS URL
        # *   cdn: CDN URL
        self.output_type = output_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetImageInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.image_ids is not None:
            result['ImageIds'] = self.image_ids
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('ImageIds') is not None:
            self.image_ids = m.get('ImageIds')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        return self


class GetImageInfosResponseBodyImageInfoMezzanine(TeaModel):
    def __init__(self, file_size=None, file_url=None, height=None, original_file_name=None, width=None):
        # The size of the image file. Unit: bytes.
        self.file_size = file_size  # type: str
        # The OSS URL of the image file.
        self.file_url = file_url  # type: str
        # The height of the image. Unit: pixels.
        self.height = height  # type: int
        # The name of the source file.
        self.original_file_name = original_file_name  # type: str
        # The width of the image. Unit: pixels.
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetImageInfosResponseBodyImageInfoMezzanine, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.height is not None:
            result['Height'] = self.height
        if self.original_file_name is not None:
            result['OriginalFileName'] = self.original_file_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OriginalFileName') is not None:
            self.original_file_name = m.get('OriginalFileName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetImageInfosResponseBodyImageInfo(TeaModel):
    def __init__(self, app_id=None, cate_id=None, cate_name=None, creation_time=None, description=None,
                 image_id=None, image_type=None, mezzanine=None, status=None, storage_location=None, tags=None, title=None,
                 url=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The ID of the category to which the image belongs.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        self.cate_name = cate_name  # type: str
        # The time when the image was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the image.
        self.description = description  # type: str
        # The ID of the image file.
        self.image_id = image_id  # type: str
        # The type of the image. Valid values:
        # 
        # *   **CoverSnapshot**: thumbnail snapshot
        # *   **NormalSnapshot**: normal snapshot
        # *   **SpriteSnapshot**: sprite snapshot
        # *   **SpriteOriginSnapshot**: sprite source snapshot
        # *   **All**: images of all the preceding types. If this parameter is not set to All, you can specify multiple types and separate the types with commas (,).
        self.image_type = image_type  # type: str
        # The source information about the image.
        self.mezzanine = mezzanine  # type: GetImageInfosResponseBodyImageInfoMezzanine
        # The status of the image file. Valid values:
        # 
        # *   **Uploading**: The image is being uploaded. This is the initial status.
        # *   **Normal**: The image is uploaded.
        # *   **UploadFail**: The image fails to be uploaded.
        self.status = status  # type: str
        # The bucket in which the image is stored.
        self.storage_location = storage_location  # type: str
        # The tags of the image. Separate multiple tags with commas (,).
        self.tags = tags  # type: str
        # The title of the image.
        self.title = title  # type: str
        # The image URL. If a domain name for CDN is specified, a CDN URL is returned. Otherwise, an OSS URL is returned.
        self.url = url  # type: str

    def validate(self):
        if self.mezzanine:
            self.mezzanine.validate()

    def to_map(self):
        _map = super(GetImageInfosResponseBodyImageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.mezzanine is not None:
            result['Mezzanine'] = self.mezzanine.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('Mezzanine') is not None:
            temp_model = GetImageInfosResponseBodyImageInfoMezzanine()
            self.mezzanine = temp_model.from_map(m['Mezzanine'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class GetImageInfosResponseBody(TeaModel):
    def __init__(self, image_info=None, non_exist_image_ids=None, request_id=None):
        # The image information.
        self.image_info = image_info  # type: list[GetImageInfosResponseBodyImageInfo]
        # The IDs of the images that do not exist.
        self.non_exist_image_ids = non_exist_image_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.image_info:
            for k in self.image_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetImageInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageInfo'] = []
        if self.image_info is not None:
            for k in self.image_info:
                result['ImageInfo'].append(k.to_map() if k else None)
        if self.non_exist_image_ids is not None:
            result['NonExistImageIds'] = self.non_exist_image_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_info = []
        if m.get('ImageInfo') is not None:
            for k in m.get('ImageInfo'):
                temp_model = GetImageInfosResponseBodyImageInfo()
                self.image_info.append(temp_model.from_map(k))
        if m.get('NonExistImageIds') is not None:
            self.non_exist_image_ids = m.get('NonExistImageIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetImageInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetImageInfosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetImageInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetImageInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditAudioResultDetailRequest(TeaModel):
    def __init__(self, media_id=None, owner_account=None, owner_id=None, page_no=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the video. You can query the video ID by using the ApsaraVideo VOD console or calling the [SearchMedia](~~86044~~) operation.
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        # The number of the page to return. This parameter is optional. If you do not specify this parameter, all results are returned without pagination.
        self.page_no = page_no  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditAudioResultDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetailList(TeaModel):
    def __init__(self, end_time=None, label=None, start_time=None, text=None):
        # The end time of the audio that failed the review. Unit: seconds.
        self.end_time = end_time  # type: long
        # The review results. Valid values:
        # *   **spam**\
        # *   **ad**\
        # *   **abuse**\
        # *   **flood**\
        # *   **contraband**\
        # *   **meaningless**\
        # *   **normal**\
        self.label = label  # type: str
        # The start time of the audio that failed the review. Unit: seconds.
        self.start_time = start_time  # type: long
        # The text that corresponds to the audio.
        self.text = text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.label is not None:
            result['Label'] = self.label
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetail(TeaModel):
    def __init__(self, list=None, page_total=None, total=None):
        # The list of results.
        self.list = list  # type: list[GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetailList]
        # The page number of the returned page.
        self.page_total = page_total  # type: int
        # The total number of pages returned.
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_total is not None:
            result['PageTotal'] = self.page_total
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetailList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageTotal') is not None:
            self.page_total = m.get('PageTotal')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetMediaAuditAudioResultDetailResponseBody(TeaModel):
    def __init__(self, media_audit_audio_result_detail=None, request_id=None):
        # Details of review results.
        self.media_audit_audio_result_detail = media_audit_audio_result_detail  # type: GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_audit_audio_result_detail:
            self.media_audit_audio_result_detail.validate()

    def to_map(self):
        _map = super(GetMediaAuditAudioResultDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_audit_audio_result_detail is not None:
            result['MediaAuditAudioResultDetail'] = self.media_audit_audio_result_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaAuditAudioResultDetail') is not None:
            temp_model = GetMediaAuditAudioResultDetailResponseBodyMediaAuditAudioResultDetail()
            self.media_audit_audio_result_detail = temp_model.from_map(m['MediaAuditAudioResultDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaAuditAudioResultDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaAuditAudioResultDetailResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaAuditAudioResultDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditAudioResultDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditResultRequest(TeaModel):
    def __init__(self, media_id=None):
        # The ID of the video or image.
        self.media_id = media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultAudioResult(TeaModel):
    def __init__(self, label=None, scene=None, score=None, suggestion=None):
        # The category of the review result.
        # 
        # *   **normal**\
        # *   **spam**\
        # *   **ad**\
        # *   **politics**\
        # *   **terrorism**\
        # *   **abuse**\
        # *   **porn**\
        # *   **flood**\
        # *   **contraband**\
        # *   **meaningless**\
        self.label = label  # type: str
        # The review scenario. The value is **antispam**.
        self.scene = scene  # type: str
        # The score.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**\
        # *   **review**\
        # *   **pass**\
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultAudioResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultImageResultResult(TeaModel):
    def __init__(self, label=None, scene=None, score=None, suggestion=None):
        # The category of the review result.
        # 
        # Valid values if scene is **porn**:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        # 
        # Valid values if scene is **terrorism**:
        # 
        # *   **normal**\
        # *   **bloody**\
        # *   **explosion**\
        # *   **outfit**\
        # *   **logo**\
        # *   **weapon**\
        # *   **politics**\
        # *   **violence**\
        # *   **crowd**\
        # *   **parade**\
        # *   **carcrash**\
        # *   **flag**\
        # *   **location**\
        # *   **others**\
        self.label = label  # type: str
        # The review scenario. Valid values:
        # 
        # *   **terrorism**\
        # *   **porn**\
        self.scene = scene  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**\
        # *   **review**\
        # *   **pass**\
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultImageResultResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultImageResult(TeaModel):
    def __init__(self, label=None, result=None, suggestion=None, type=None, url=None):
        # The category of the review result. Separate multiple values with commas (,). Valid values:
        # 
        # *   **porn**\
        # *   **terrorism**\
        # *   **normal**\
        self.label = label  # type: str
        # Details of image review results.
        self.result = result  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultImageResultResult]
        # The recommendation for review results. Valid values:
        # 
        # *   **block**\
        # *   **review**\
        # *   **pass**\
        self.suggestion = suggestion  # type: str
        # The type of the image. The value is **cover**.
        self.type = type  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultImageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultImageResultResult()
                self.result.append(temp_model.from_map(k))
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultTextResult(TeaModel):
    def __init__(self, content=None, label=None, scene=None, score=None, suggestion=None, type=None):
        # The text content for review.
        self.content = content  # type: str
        # The category of the review result. Valid values:
        # 
        # - **spam**\
        # - **ad**\
        # - **abuse**\
        # - **flood**\
        # - **contraband**\
        # - **meaningless**\
        # - **normal**\
        self.label = label  # type: str
        # The review scenario. The value is **antispam**.
        self.scene = scene  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The type of the text. The value is **title**.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultTextResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of frames.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # - **ad**\
        # - **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. 
        # 
        # - **ad**\
        # - **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultCounterList]
        # The category of the review result. Valid values:
        # 
        # - **ad**\
        # - **normal**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of frames.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # - **live**: The content contains undesirable scenes.
        # - **normal**: normal content.
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # - **live**: The content contains undesirable scenes.
        # - **normal**: normal content.
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultCounterList]
        # The category of the review result. Valid values:
        # 
        # - **live**: The content contains undesirable scenes.
        # - **normal**: normal content.
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of frames.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # - **logo**\
        # - **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result.
        # 
        # - **logo**\
        # - **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultCounterList]
        # The category of the review result. Valid values:
        # 
        # - **logo**\
        # - **normal**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of frames.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # - **porn**\
        # - **sexy**\
        # - **normal**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # - **porn**\
        # - **sexy**\
        # - **normal**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultCounterList]
        # The category of the review result. Valid values:
        # 
        # - **porn**\
        # - **sexy**\
        # - **normal**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results.
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultCounterList(TeaModel):
    def __init__(self, count=None, label=None):
        # The number of frames.
        self.count = count  # type: int
        # The category of the review result. Valid values:
        # 
        # - **normal**\
        # - **bloody**\
        # - **explosion**\
        # - **outfit**\
        # - **logo**\
        # - **weapon**\
        # - **politics**\
        # - **violence**\
        # - **crowd**\
        # - **parade**\
        # - **carcrash**\
        # - **flag**\
        # - **location**\
        # - **others**\
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultTopList(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None, url=None):
        # The category of the review result. Valid values:
        # 
        # - **normal**\
        # - **bloody**\
        # - **explosion**\
        # - **outfit**\
        # - **logo**\
        # - **weapon**\
        # - **politics**\
        # - **violence**\
        # - **crowd**\
        # - **parade**\
        # - **carcrash**\
        # - **flag**\
        # - **location**\
        # - **others**\
        self.label = label  # type: str
        # The score of the image of the category that is indicated by Label.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResult(TeaModel):
    def __init__(self, average_score=None, counter_list=None, label=None, max_score=None, suggestion=None,
                 top_list=None):
        # The average score of the review results.
        self.average_score = average_score  # type: str
        # The statistics about tag frames.
        self.counter_list = counter_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultCounterList]
        # The category of the review result. Valid values:
        # 
        # - **normal**\
        # - **bloody**\
        # - **explosion**\
        # - **outfit**\
        # - **logo**\
        # - **weapon**\
        # - **politics**\
        # - **violence**\
        # - **crowd**\
        # - **parade**\
        # - **carcrash**\
        # - **flag**\
        # - **location**\
        # - **others**\
        self.label = label  # type: str
        # The highest review score.
        self.max_score = max_score  # type: str
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The information about the image with the highest score of the category that is indicated by Label.
        self.top_list = top_list  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultTopList]

    def validate(self):
        if self.counter_list:
            for k in self.counter_list:
                if k:
                    k.validate()
        if self.top_list:
            for k in self.top_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        result['CounterList'] = []
        if self.counter_list is not None:
            for k in self.counter_list:
                result['CounterList'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TopList'] = []
        if self.top_list is not None:
            for k in self.top_list:
                result['TopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        self.counter_list = []
        if m.get('CounterList') is not None:
            for k in m.get('CounterList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultCounterList()
                self.counter_list.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.top_list = []
        if m.get('TopList') is not None:
            for k in m.get('TopList'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResultTopList()
                self.top_list.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultResponseBodyMediaAuditResultVideoResult(TeaModel):
    def __init__(self, ad_result=None, label=None, live_result=None, logo_result=None, porn_result=None,
                 suggestion=None, terrorism_result=None):
        # The results of ad review.
        self.ad_result = ad_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResult
        # The category of the review result. Separate multiple values with commas (,). Valid values: 
        # 
        # - **porn**\
        # - **terrorism**\
        # - **normal**\
        self.label = label  # type: str
        # The results of undesired content review.
        self.live_result = live_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResult
        # The results of logo review.
        self.logo_result = logo_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResult
        # The results of pornographic content review.
        self.porn_result = porn_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResult
        # The recommendation for review results. Valid values:
        # 
        # - **block**\
        # - **review**\
        # - **pass**\
        self.suggestion = suggestion  # type: str
        # The results of terrorist content review.
        self.terrorism_result = terrorism_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResult

    def validate(self):
        if self.ad_result:
            self.ad_result.validate()
        if self.live_result:
            self.live_result.validate()
        if self.logo_result:
            self.logo_result.validate()
        if self.porn_result:
            self.porn_result.validate()
        if self.terrorism_result:
            self.terrorism_result.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResultVideoResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_result is not None:
            result['AdResult'] = self.ad_result.to_map()
        if self.label is not None:
            result['Label'] = self.label
        if self.live_result is not None:
            result['LiveResult'] = self.live_result.to_map()
        if self.logo_result is not None:
            result['LogoResult'] = self.logo_result.to_map()
        if self.porn_result is not None:
            result['PornResult'] = self.porn_result.to_map()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.terrorism_result is not None:
            result['TerrorismResult'] = self.terrorism_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultAdResult()
            self.ad_result = temp_model.from_map(m['AdResult'])
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('LiveResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLiveResult()
            self.live_result = temp_model.from_map(m['LiveResult'])
        if m.get('LogoResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultLogoResult()
            self.logo_result = temp_model.from_map(m['LogoResult'])
        if m.get('PornResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultPornResult()
            self.porn_result = temp_model.from_map(m['PornResult'])
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TerrorismResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResultTerrorismResult()
            self.terrorism_result = temp_model.from_map(m['TerrorismResult'])
        return self


class GetMediaAuditResultResponseBodyMediaAuditResult(TeaModel):
    def __init__(self, abnormal_modules=None, audio_result=None, image_result=None, label=None, suggestion=None,
                 text_result=None, video_result=None):
        # The content that violates the regulations. Separate multiple values with commas (,). Valid values:
        # 
        # *   **video**\
        # *   **image-cover**\
        # *   **text-title**\
        self.abnormal_modules = abnormal_modules  # type: str
        # The results of audio review.
        self.audio_result = audio_result  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultAudioResult]
        # The results of image review.
        self.image_result = image_result  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultImageResult]
        # The category of the review result. Separate multiple values with commas (,). Valid values:
        # 
        # *   **porn**\
        # *   **terrorism**\
        # *   **normal**\
        self.label = label  # type: str
        # The recommendation for review results. Valid values:
        # 
        # *   **block**\
        # *   **review**\
        # *   **pass**\
        self.suggestion = suggestion  # type: str
        # The results of text review.
        self.text_result = text_result  # type: list[GetMediaAuditResultResponseBodyMediaAuditResultTextResult]
        # The results of video review.
        self.video_result = video_result  # type: GetMediaAuditResultResponseBodyMediaAuditResultVideoResult

    def validate(self):
        if self.audio_result:
            for k in self.audio_result:
                if k:
                    k.validate()
        if self.image_result:
            for k in self.image_result:
                if k:
                    k.validate()
        if self.text_result:
            for k in self.text_result:
                if k:
                    k.validate()
        if self.video_result:
            self.video_result.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBodyMediaAuditResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_modules is not None:
            result['AbnormalModules'] = self.abnormal_modules
        result['AudioResult'] = []
        if self.audio_result is not None:
            for k in self.audio_result:
                result['AudioResult'].append(k.to_map() if k else None)
        result['ImageResult'] = []
        if self.image_result is not None:
            for k in self.image_result:
                result['ImageResult'].append(k.to_map() if k else None)
        if self.label is not None:
            result['Label'] = self.label
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['TextResult'] = []
        if self.text_result is not None:
            for k in self.text_result:
                result['TextResult'].append(k.to_map() if k else None)
        if self.video_result is not None:
            result['VideoResult'] = self.video_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbnormalModules') is not None:
            self.abnormal_modules = m.get('AbnormalModules')
        self.audio_result = []
        if m.get('AudioResult') is not None:
            for k in m.get('AudioResult'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultAudioResult()
                self.audio_result.append(temp_model.from_map(k))
        self.image_result = []
        if m.get('ImageResult') is not None:
            for k in m.get('ImageResult'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultImageResult()
                self.image_result.append(temp_model.from_map(k))
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.text_result = []
        if m.get('TextResult') is not None:
            for k in m.get('TextResult'):
                temp_model = GetMediaAuditResultResponseBodyMediaAuditResultTextResult()
                self.text_result.append(temp_model.from_map(k))
        if m.get('VideoResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResultVideoResult()
            self.video_result = temp_model.from_map(m['VideoResult'])
        return self


class GetMediaAuditResultResponseBody(TeaModel):
    def __init__(self, media_audit_result=None, request_id=None):
        # The review results.
        self.media_audit_result = media_audit_result  # type: GetMediaAuditResultResponseBodyMediaAuditResult
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_audit_result:
            self.media_audit_result.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_audit_result is not None:
            result['MediaAuditResult'] = self.media_audit_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaAuditResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResult()
            self.media_audit_result = temp_model.from_map(m['MediaAuditResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaAuditResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaAuditResultResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditResultDetailRequest(TeaModel):
    def __init__(self, media_id=None, page_no=None):
        # The ID of the video.
        self.media_id = media_id  # type: str
        # The page number of the review result to return. The default value is **1**. A maximum of **20** records can be returned on each page.
        self.page_no = page_no  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        return self


class GetMediaAuditResultDetailResponseBodyMediaAuditResultDetailList(TeaModel):
    def __init__(self, ad_label=None, ad_score=None, live_label=None, live_score=None, logo_label=None,
                 logo_score=None, porn_label=None, porn_score=None, terrorism_label=None, terrorism_score=None, timestamp=None,
                 url=None):
        # The category of the ad review result. Valid values:
        # 
        # *   **normal**: normal content
        # *   **ad**: ad or text violation
        self.ad_label = ad_label  # type: str
        # The score of the review result category. It is representative of the confidence. Valid values: `[0.00-100.00].` The value is rounded down to 10 decimal places.
        self.ad_score = ad_score  # type: str
        # The category of the undesirable scene review result. Valid values:
        # 
        # *   **normal**: The video does not contain undesirable scenes.
        # *   **live**: The video contains undesirable scenes.
        self.live_label = live_label  # type: str
        # The score of the review result category. It is representative of the confidence. Valid values: `[0.00-100.00].` The value is rounded down to 10 decimal places.
        self.live_score = live_score  # type: str
        # The category of the logo review result. Valid values:
        # 
        # *   **normal**\
        # *   **tlogo**\
        self.logo_label = logo_label  # type: str
        # The score of the review result category. It is representative of the confidence. Valid values: `[0.00-100.00].` The value is rounded down to 10 decimal places.
        self.logo_score = logo_score  # type: str
        # The category of the pornographic content review result. Valid values:
        # 
        # *   **normal**\
        # *   **porn**\
        # *   **sexy**\
        self.porn_label = porn_label  # type: str
        # The score of the review result category. It is representative of the confidence. Valid values: `[0.00-100.00].` The value is rounded down to 10 decimal places.
        self.porn_score = porn_score  # type: str
        # The category of the terrorist content review result.
        # 
        # *   **normal**: normal
        # *   **terrorism**: terrorist content
        # *   **outfit**: special costume
        # *   **logo**: special logo
        # *   **weapon**: weapon
        # *   **politics**: politically sensitive content
        # *   **others**: other terrorist content and politically sensitive content
        self.terrorism_label = terrorism_label  # type: str
        # The score of the review result category. It is representative of the confidence. Valid values: `[0.00-100.00].` The value is rounded down to 10 decimal places.
        self.terrorism_score = terrorism_score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str
        # The URL of the image.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultDetailResponseBodyMediaAuditResultDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_label is not None:
            result['AdLabel'] = self.ad_label
        if self.ad_score is not None:
            result['AdScore'] = self.ad_score
        if self.live_label is not None:
            result['LiveLabel'] = self.live_label
        if self.live_score is not None:
            result['LiveScore'] = self.live_score
        if self.logo_label is not None:
            result['LogoLabel'] = self.logo_label
        if self.logo_score is not None:
            result['LogoScore'] = self.logo_score
        if self.porn_label is not None:
            result['PornLabel'] = self.porn_label
        if self.porn_score is not None:
            result['PornScore'] = self.porn_score
        if self.terrorism_label is not None:
            result['TerrorismLabel'] = self.terrorism_label
        if self.terrorism_score is not None:
            result['TerrorismScore'] = self.terrorism_score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdLabel') is not None:
            self.ad_label = m.get('AdLabel')
        if m.get('AdScore') is not None:
            self.ad_score = m.get('AdScore')
        if m.get('LiveLabel') is not None:
            self.live_label = m.get('LiveLabel')
        if m.get('LiveScore') is not None:
            self.live_score = m.get('LiveScore')
        if m.get('LogoLabel') is not None:
            self.logo_label = m.get('LogoLabel')
        if m.get('LogoScore') is not None:
            self.logo_score = m.get('LogoScore')
        if m.get('PornLabel') is not None:
            self.porn_label = m.get('PornLabel')
        if m.get('PornScore') is not None:
            self.porn_score = m.get('PornScore')
        if m.get('TerrorismLabel') is not None:
            self.terrorism_label = m.get('TerrorismLabel')
        if m.get('TerrorismScore') is not None:
            self.terrorism_score = m.get('TerrorismScore')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultDetailResponseBodyMediaAuditResultDetail(TeaModel):
    def __init__(self, list=None, total=None):
        # The review results returned.
        self.list = list  # type: list[GetMediaAuditResultDetailResponseBodyMediaAuditResultDetailList]
        # The total number of snapshots returned.
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultDetailResponseBodyMediaAuditResultDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetMediaAuditResultDetailResponseBodyMediaAuditResultDetailList()
                self.list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetMediaAuditResultDetailResponseBody(TeaModel):
    def __init__(self, media_audit_result_detail=None, request_id=None):
        # Details about review results.
        self.media_audit_result_detail = media_audit_result_detail  # type: GetMediaAuditResultDetailResponseBodyMediaAuditResultDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_audit_result_detail:
            self.media_audit_result_detail.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_audit_result_detail is not None:
            result['MediaAuditResultDetail'] = self.media_audit_result_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaAuditResultDetail') is not None:
            temp_model = GetMediaAuditResultDetailResponseBodyMediaAuditResultDetail()
            self.media_audit_result_detail = temp_model.from_map(m['MediaAuditResultDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaAuditResultDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaAuditResultDetailResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditResultDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditResultTimelineRequest(TeaModel):
    def __init__(self, media_id=None):
        # The ID of the video.
        self.media_id = media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineAd(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None):
        # The category of the review result. Valid values:
        # 
        # *   **normal**: normal content
        # *   **ad**: ad or text violation
        self.label = label  # type: str
        # The score of the review result category. Valid values: `[0, 100]`. The value is rounded down to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineAd, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLive(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None):
        # The category of the review result. Valid values:
        # 
        # *   **normal**\
        # *   **terrorism**\
        self.label = label  # type: str
        # The score of the review result category. Valid values: `[0, 100]`. The value is rounded down to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLive, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLogo(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None):
        # The category of the review result. Valid values:
        # 
        # *   **normal**\
        # *   **logo**\
        self.label = label  # type: str
        # The score of the review result category. Valid values: `[0, 100]`. The value is rounded down to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLogo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelinePorn(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None):
        # The category of the review result. Valid values:
        # 
        # *   **porn**\
        # *   **sexy**\
        # *   **normal**\
        self.label = label  # type: str
        # The score of the review result category. Valid values: `[0, 100]`. The value is rounded down to 10 decimal places. The score is representative of the confidence.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelinePorn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineTerrorism(TeaModel):
    def __init__(self, label=None, score=None, timestamp=None):
        # The category of the review result. Valid values:
        # 
        # *   **terrorism**: terrorist content
        # *   **outfit**: special costume
        # *   **logo**: special logo
        # *   **weapon**: weapon
        # *   **politics**: politically sensitive content
        # *   **others**: other terrorist and politically sensitive content
        # *   **normal**: normal content
        self.label = label  # type: str
        # The score of the review result category.
        self.score = score  # type: str
        # The position in the video. Unit: milliseconds.
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineTerrorism, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimeline(TeaModel):
    def __init__(self, ad=None, live=None, logo=None, porn=None, terrorism=None):
        # The collection of ad timelines.
        self.ad = ad  # type: list[GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineAd]
        # The collection of undesirable scene timelines.
        self.live = live  # type: list[GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLive]
        # The collection of logo timelines.
        self.logo = logo  # type: list[GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLogo]
        # The collection of pornographic content timelines.
        self.porn = porn  # type: list[GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelinePorn]
        # The collection of terrorist content timelines.
        self.terrorism = terrorism  # type: list[GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineTerrorism]

    def validate(self):
        if self.ad:
            for k in self.ad:
                if k:
                    k.validate()
        if self.live:
            for k in self.live:
                if k:
                    k.validate()
        if self.logo:
            for k in self.logo:
                if k:
                    k.validate()
        if self.porn:
            for k in self.porn:
                if k:
                    k.validate()
        if self.terrorism:
            for k in self.terrorism:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ad'] = []
        if self.ad is not None:
            for k in self.ad:
                result['Ad'].append(k.to_map() if k else None)
        result['Live'] = []
        if self.live is not None:
            for k in self.live:
                result['Live'].append(k.to_map() if k else None)
        result['Logo'] = []
        if self.logo is not None:
            for k in self.logo:
                result['Logo'].append(k.to_map() if k else None)
        result['Porn'] = []
        if self.porn is not None:
            for k in self.porn:
                result['Porn'].append(k.to_map() if k else None)
        result['Terrorism'] = []
        if self.terrorism is not None:
            for k in self.terrorism:
                result['Terrorism'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ad = []
        if m.get('Ad') is not None:
            for k in m.get('Ad'):
                temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineAd()
                self.ad.append(temp_model.from_map(k))
        self.live = []
        if m.get('Live') is not None:
            for k in m.get('Live'):
                temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLive()
                self.live.append(temp_model.from_map(k))
        self.logo = []
        if m.get('Logo') is not None:
            for k in m.get('Logo'):
                temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineLogo()
                self.logo.append(temp_model.from_map(k))
        self.porn = []
        if m.get('Porn') is not None:
            for k in m.get('Porn'):
                temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelinePorn()
                self.porn.append(temp_model.from_map(k))
        self.terrorism = []
        if m.get('Terrorism') is not None:
            for k in m.get('Terrorism'):
                temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimelineTerrorism()
                self.terrorism.append(temp_model.from_map(k))
        return self


class GetMediaAuditResultTimelineResponseBody(TeaModel):
    def __init__(self, media_audit_result_timeline=None, request_id=None):
        # The collection of review result timelines.
        self.media_audit_result_timeline = media_audit_result_timeline  # type: GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimeline
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_audit_result_timeline:
            self.media_audit_result_timeline.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_audit_result_timeline is not None:
            result['MediaAuditResultTimeline'] = self.media_audit_result_timeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaAuditResultTimeline') is not None:
            temp_model = GetMediaAuditResultTimelineResponseBodyMediaAuditResultTimeline()
            self.media_audit_result_timeline = temp_model.from_map(m['MediaAuditResultTimeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaAuditResultTimelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaAuditResultTimelineResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaAuditResultTimelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditResultTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaDNAResultRequest(TeaModel):
    def __init__(self, media_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the video.
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaDNAResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetMediaDNAResultResponseBodyDNAResultVideoDNADetailDuplication(TeaModel):
    def __init__(self, duration=None, start=None):
        # The duration of the video. Unit: seconds.
        self.duration = duration  # type: str
        # The start time of the video. Unit: seconds.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBodyDNAResultVideoDNADetailDuplication, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetMediaDNAResultResponseBodyDNAResultVideoDNADetailInput(TeaModel):
    def __init__(self, duration=None, start=None):
        # The duration of the video. Unit: seconds.
        self.duration = duration  # type: str
        # The start time of the video. Unit: seconds.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBodyDNAResultVideoDNADetailInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetMediaDNAResultResponseBodyDNAResultVideoDNADetail(TeaModel):
    def __init__(self, duplication=None, input=None):
        # The start time and duration of the matched video.
        self.duplication = duplication  # type: GetMediaDNAResultResponseBodyDNAResultVideoDNADetailDuplication
        # The start time and duration of the input video.
        self.input = input  # type: GetMediaDNAResultResponseBodyDNAResultVideoDNADetailInput

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBodyDNAResultVideoDNADetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = GetMediaDNAResultResponseBodyDNAResultVideoDNADetailDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Input') is not None:
            temp_model = GetMediaDNAResultResponseBodyDNAResultVideoDNADetailInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class GetMediaDNAResultResponseBodyDNAResultVideoDNA(TeaModel):
    def __init__(self, detail=None, primary_key=None, similarity=None):
        # The details of the matched video. Information such as the location and duration of the video is returned.
        self.detail = detail  # type: list[GetMediaDNAResultResponseBodyDNAResultVideoDNADetail]
        # The ID of the video that has a similar fingerprint.
        self.primary_key = primary_key  # type: str
        # The similarity between the fingerprints of the input video and the matched video. 1 indicates that the fingerprints of the two videos are the same.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBodyDNAResultVideoDNA, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = GetMediaDNAResultResponseBodyDNAResultVideoDNADetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class GetMediaDNAResultResponseBodyDNAResult(TeaModel):
    def __init__(self, video_dna=None):
        # The video fingerprint recognition result.
        self.video_dna = video_dna  # type: list[GetMediaDNAResultResponseBodyDNAResultVideoDNA]

    def validate(self):
        if self.video_dna:
            for k in self.video_dna:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBodyDNAResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoDNA'] = []
        if self.video_dna is not None:
            for k in self.video_dna:
                result['VideoDNA'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_dna = []
        if m.get('VideoDNA') is not None:
            for k in m.get('VideoDNA'):
                temp_model = GetMediaDNAResultResponseBodyDNAResultVideoDNA()
                self.video_dna.append(temp_model.from_map(k))
        return self


class GetMediaDNAResultResponseBody(TeaModel):
    def __init__(self, dnaresult=None, request_id=None):
        # The media fingerprinting results.
        self.dnaresult = dnaresult  # type: GetMediaDNAResultResponseBodyDNAResult
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dnaresult:
            self.dnaresult.validate()

    def to_map(self):
        _map = super(GetMediaDNAResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnaresult is not None:
            result['DNAResult'] = self.dnaresult.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DNAResult') is not None:
            temp_model = GetMediaDNAResultResponseBodyDNAResult()
            self.dnaresult = temp_model.from_map(m['DNAResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaDNAResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaDNAResultResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaDNAResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaDNAResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaRefreshJobsRequest(TeaModel):
    def __init__(self, media_id=None, media_refresh_job_id=None):
        # The ID of the media file. It is the value of the `MediaIds` parameter that you specify when you call the [RefreshMediaPlayUrls](~~RefreshMediaPlayUrls~~) operation. You can specify only one media ID.
        # 
        # If you leave this parameter empty, information about all media files in the refresh or prefetch job specified by `MediaRefreshJobId` is returned. If you set this parameter, only the information about the specified media file is returned.``
        self.media_id = media_id  # type: str
        # The ID of the refresh or prefetch job. It is the value of the MediaRefreshJobId parameter that is returned from the call to the [RefreshMediaPlayUrls](~~RefreshMediaPlayUrls~~) operation.
        self.media_refresh_job_id = media_refresh_job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaRefreshJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_refresh_job_id is not None:
            result['MediaRefreshJobId'] = self.media_refresh_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaRefreshJobId') is not None:
            self.media_refresh_job_id = m.get('MediaRefreshJobId')
        return self


class GetMediaRefreshJobsResponseBodyMediaRefreshJobs(TeaModel):
    def __init__(self, error_code=None, error_message=None, filter_policy=None, gmt_create=None, gmt_modified=None,
                 media_id=None, media_refresh_job_id=None, status=None, success_play_urls=None, task_ids=None,
                 task_type=None, user_data=None):
        # The error code. This parameter is returned if the refresh or prefetch task fails.
        self.error_code = error_code  # type: str
        # The error message. This parameter is returned if the refresh or prefetch task fails.
        self.error_message = error_message  # type: str
        # The filtering conditions for stream playback. The value is a JSON string. This parameter is used as a request parameter of the [RefreshMediaPlayUrls](~~RefreshMediaPlayUrls~~) operation.
        self.filter_policy = filter_policy  # type: str
        # The time when the task was created.
        self.gmt_create = gmt_create  # type: str
        # The time when the task was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the media file.
        self.media_id = media_id  # type: str
        # The ID of the job.
        self.media_refresh_job_id = media_refresh_job_id  # type: str
        # The status of the job. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status  # type: str
        # The playback URLs that were refreshed or prefetched.
        self.success_play_urls = success_play_urls  # type: str
        # The IDs of the refresh or prefetch tasks for the playback URLs of media files. Only one URL can be refreshed or prefetched in a task. This value is used in the [DescribeVodRefreshTasks](~~DescribeVodRefreshTasks~~) operation, which queries the status of refresh or prefetch tasks for playback URLs of media files.
        self.task_ids = task_ids  # type: str
        # The type of the job. Valid values:
        # 
        # *   **Refresh**\
        # *   **Preload**\
        self.task_type = task_type  # type: str
        # The user data that you passed when you submit a refresh or prefetch task.
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaRefreshJobsResponseBodyMediaRefreshJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.filter_policy is not None:
            result['FilterPolicy'] = self.filter_policy
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_refresh_job_id is not None:
            result['MediaRefreshJobId'] = self.media_refresh_job_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success_play_urls is not None:
            result['SuccessPlayUrls'] = self.success_play_urls
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FilterPolicy') is not None:
            self.filter_policy = m.get('FilterPolicy')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaRefreshJobId') is not None:
            self.media_refresh_job_id = m.get('MediaRefreshJobId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SuccessPlayUrls') is not None:
            self.success_play_urls = m.get('SuccessPlayUrls')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetMediaRefreshJobsResponseBody(TeaModel):
    def __init__(self, media_refresh_jobs=None, request_id=None):
        # The media refresh or prefetch jobs.
        self.media_refresh_jobs = media_refresh_jobs  # type: list[GetMediaRefreshJobsResponseBodyMediaRefreshJobs]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_refresh_jobs:
            for k in self.media_refresh_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaRefreshJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaRefreshJobs'] = []
        if self.media_refresh_jobs is not None:
            for k in self.media_refresh_jobs:
                result['MediaRefreshJobs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_refresh_jobs = []
        if m.get('MediaRefreshJobs') is not None:
            for k in m.get('MediaRefreshJobs'):
                temp_model = GetMediaRefreshJobsResponseBodyMediaRefreshJobs()
                self.media_refresh_jobs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaRefreshJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaRefreshJobsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaRefreshJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaRefreshJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMessageCallbackRequest(TeaModel):
    def __init__(self, app_id=None, owner_account=None):
        # The ID of the application. If you do not set this parameter, the default value **app-1000000** is used.
        self.app_id = app_id  # type: str
        self.owner_account = owner_account  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMessageCallbackRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class GetMessageCallbackResponseBodyMessageCallback(TeaModel):
    def __init__(self, app_id=None, auth_key=None, auth_switch=None, callback_type=None, callback_url=None,
                 event_type_list=None, mns_endpoint=None, mns_queue_name=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The cryptographic key. This parameter is returned only for HTTP callbacks.
        self.auth_key = auth_key  # type: str
        # Indicates whether callback authentication is enabled. This parameter is returned only for HTTP callbacks. Valid values:
        # 
        # *   **on**\
        # *   **off**\
        self.auth_switch = auth_switch  # type: str
        # The callback method. Valid values:
        # 
        # *   **HTTP**\
        # *   **MNS**\
        self.callback_type = callback_type  # type: str
        # The callback URL. This parameter is returned only for HTTP callbacks.
        self.callback_url = callback_url  # type: str
        # The type of the callback event.
        self.event_type_list = event_type_list  # type: str
        # The public endpoint of MNS. This parameter is returned only for MNS callbacks.
        self.mns_endpoint = mns_endpoint  # type: str
        # The name of the Message Service (MNS) queue. This parameter is returned only for MNS callbacks.
        self.mns_queue_name = mns_queue_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMessageCallbackResponseBodyMessageCallback, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auth_switch is not None:
            result['AuthSwitch'] = self.auth_switch
        if self.callback_type is not None:
            result['CallbackType'] = self.callback_type
        if self.callback_url is not None:
            result['CallbackURL'] = self.callback_url
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        if self.mns_endpoint is not None:
            result['MnsEndpoint'] = self.mns_endpoint
        if self.mns_queue_name is not None:
            result['MnsQueueName'] = self.mns_queue_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AuthSwitch') is not None:
            self.auth_switch = m.get('AuthSwitch')
        if m.get('CallbackType') is not None:
            self.callback_type = m.get('CallbackType')
        if m.get('CallbackURL') is not None:
            self.callback_url = m.get('CallbackURL')
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        if m.get('MnsEndpoint') is not None:
            self.mns_endpoint = m.get('MnsEndpoint')
        if m.get('MnsQueueName') is not None:
            self.mns_queue_name = m.get('MnsQueueName')
        return self


class GetMessageCallbackResponseBody(TeaModel):
    def __init__(self, message_callback=None, request_id=None):
        # The configuration of the event notification.
        self.message_callback = message_callback  # type: GetMessageCallbackResponseBodyMessageCallback
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.message_callback:
            self.message_callback.validate()

    def to_map(self):
        _map = super(GetMessageCallbackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_callback is not None:
            result['MessageCallback'] = self.message_callback.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageCallback') is not None:
            temp_model = GetMessageCallbackResponseBodyMessageCallback()
            self.message_callback = temp_model.from_map(m['MessageCallback'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMessageCallbackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMessageCallbackResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMessageCallbackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMessageCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMezzanineInfoRequest(TeaModel):
    def __init__(self, addition_type=None, auth_timeout=None, output_type=None, video_id=None):
        # The type of additional information. Separate multiple values with commas (,). By default, only the basic information is returned. Valid values:
        # 
        # *   **video**: video stream information
        # *   **audio**: audio stream information
        self.addition_type = addition_type  # type: str
        # The validity period of the mezzanine file URL. Unit: seconds. Default value: **1800**. Minimum value: **1**.
        # 
        # *   If the OutputType parameter is set to **cdn**:
        # 
        #     *   The mezzanine file URL has a validity period only if URL signing is enabled. Otherwise, the mezzanine file URL is permanently valid.
        #     *   Minimum value: **1**.
        #     *   Maximum Value: unlimited.
        #     *   Default value: If you do not set this parameter, the default validity period that is specified in URL signing is used.
        # 
        # <!---->
        # 
        # *   If the OutputType parameter is set to **oss**:
        # 
        #     *   The mezzanine file URL has a validity period only if the permissions on the Object Storage Service (OSS) bucket are private. Otherwise, the mezzanine file URL is permanently valid.
        #     *   Minimum value: **1**.
        #     *   Maximum value: **2592000** (30 days). The maximum value is limited to reduce security risks of the origin.
        #     *   Default value: If you do not set this parameter, the default value is **3600**.
        self.auth_timeout = auth_timeout  # type: long
        # The type of the mezzanine file URL. Valid values:
        # 
        # - **oss**: OSS URL
        # - **cdn** (default): Content Delivery Network (CDN) URL
        # 
        # > If the mezzanine file is stored in a bucket of the in type, only an OSS URL is returned.
        self.output_type = output_type  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMezzanineInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addition_type is not None:
            result['AdditionType'] = self.addition_type
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionType') is not None:
            self.addition_type = m.get('AdditionType')
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetMezzanineInfoResponseBodyMezzanineAudioStreamList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The output layout of the sound channels. Valid values:
        # 
        # *   **mono**\
        # *   **stereo**\
        self.channel_layout = channel_layout  # type: str
        # The number of sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration of the audio file.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language.
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate of the audio stream.
        self.sample_rate = sample_rate  # type: str
        # The beginning of the time range during which the data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The time base of the audio stream.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMezzanineInfoResponseBodyMezzanineAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMezzanineInfoResponseBodyMezzanineVideoStreamList(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, hdrtype=None, has_bframes=None,
                 height=None, index=None, lang=None, level=None, num_frames=None, pix_fmt=None, profile=None, rotate=None,
                 sar=None, start_time=None, timebase=None, width=None):
        # The average frame rate.
        self.avg_fps = avg_fps  # type: str
        # The bitrate. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The display aspect ratio (DAR) of the video stream.
        self.dar = dar  # type: str
        # The duration of the audio file.
        self.duration = duration  # type: str
        # The frame rate of the output file.
        self.fps = fps  # type: str
        # The HDR type of the video stream.
        self.hdrtype = hdrtype  # type: str
        # Indicates whether the video stream contains B-frames.
        self.has_bframes = has_bframes  # type: str
        # The height of the video stream.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language.
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The pixel format.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The rotation angle of the video. Valid values: **\[0,360)**.
        self.rotate = rotate  # type: str
        # The sample aspect ratio (SAR) of the video stream.
        self.sar = sar  # type: str
        # The beginning of the time range during which the data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The time base of the audio stream.
        self.timebase = timebase  # type: str
        # The width of the video in pixels.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMezzanineInfoResponseBodyMezzanineVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMezzanineInfoResponseBodyMezzanine(TeaModel):
    def __init__(self, audio_stream_list=None, bitrate=None, creation_time=None, duration=None, file_name=None,
                 file_url=None, fps=None, height=None, output_type=None, restore_expiration=None, restore_status=None,
                 size=None, status=None, storage_class=None, video_id=None, video_stream_list=None, width=None):
        # The codec time base.
        self.audio_stream_list = audio_stream_list  # type: list[GetMezzanineInfoResponseBodyMezzanineAudioStreamList]
        # The bitrate of the file. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The time when the file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The duration of the file. Unit: seconds.
        self.duration = duration  # type: str
        # The name of the file.
        self.file_name = file_name  # type: str
        # The URL of the file.
        self.file_url = file_url  # type: str
        # The frame rate of the file. Unit: frames per second.
        self.fps = fps  # type: str
        # The height of the file. Unit: pixel.
        self.height = height  # type: long
        # The type of the mezzanine file URL. Valid values:
        # 
        # - **oss**: OSS URL
        # - **cdn** (default): CDN URL
        # 
        # > If you specify an OSS URL for the video stream, the video stream must be in the MP4 format.
        self.output_type = output_type  # type: str
        # The period of time in which the object remains in the restored state.
        self.restore_expiration = restore_expiration  # type: str
        # The restoration status of the audio or video file. Valid values:
        # 
        # *   **Processing**\
        # *   **Success**\
        # *   **Failed**\
        self.restore_status = restore_status  # type: str
        # The size of the file. Unit: byte.
        self.size = size  # type: long
        # The status of the file. Valid values:
        # 
        # *   **Uploading**: The file is being uploaded. This is the initial status.
        # *   **Normal**: The file is uploaded.
        # *   **UploadFail**: The file fails to be uploaded.
        # *   **Deleted**: The file is deleted.
        self.status = status  # type: str
        # The storage class of the audio file. Valid values:
        # 
        # *   **Standard**: All media resources are stored as Standard objects.
        # *   **IA**: All media resources are stored as IA objects.
        # *   **Archive**: All media resources are stored as Archive objects.
        # *   **ColdArchive**: All media resources are stored as Cold Archive objects.
        # *   **SourceIA**: Only the source files are IA objects.
        # *   **SourceArchive**: Only the source files are Archive objects.
        # *   **SourceColdArchive**: Only the source files are Cold Archive objects.
        # *   **Changing**: The storage class of the audio file is being changed.
        # *   **SourceChanging**: The storage class of the source file is being changed.
        self.storage_class = storage_class  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str
        # The HDR type of the video stream.
        self.video_stream_list = video_stream_list  # type: list[GetMezzanineInfoResponseBodyMezzanineVideoStreamList]
        # The width of the file. Unit: pixel.
        self.width = width  # type: long

    def validate(self):
        if self.audio_stream_list:
            for k in self.audio_stream_list:
                if k:
                    k.validate()
        if self.video_stream_list:
            for k in self.video_stream_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMezzanineInfoResponseBodyMezzanine, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamList'] = []
        if self.audio_stream_list is not None:
            for k in self.audio_stream_list:
                result['AudioStreamList'].append(k.to_map() if k else None)
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.restore_expiration is not None:
            result['RestoreExpiration'] = self.restore_expiration
        if self.restore_status is not None:
            result['RestoreStatus'] = self.restore_status
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        result['VideoStreamList'] = []
        if self.video_stream_list is not None:
            for k in self.video_stream_list:
                result['VideoStreamList'].append(k.to_map() if k else None)
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_list = []
        if m.get('AudioStreamList') is not None:
            for k in m.get('AudioStreamList'):
                temp_model = GetMezzanineInfoResponseBodyMezzanineAudioStreamList()
                self.audio_stream_list.append(temp_model.from_map(k))
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('RestoreExpiration') is not None:
            self.restore_expiration = m.get('RestoreExpiration')
        if m.get('RestoreStatus') is not None:
            self.restore_status = m.get('RestoreStatus')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        self.video_stream_list = []
        if m.get('VideoStreamList') is not None:
            for k in m.get('VideoStreamList'):
                temp_model = GetMezzanineInfoResponseBodyMezzanineVideoStreamList()
                self.video_stream_list.append(temp_model.from_map(k))
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMezzanineInfoResponseBody(TeaModel):
    def __init__(self, mezzanine=None, request_id=None):
        # The information about the source file.
        self.mezzanine = mezzanine  # type: GetMezzanineInfoResponseBodyMezzanine
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.mezzanine:
            self.mezzanine.validate()

    def to_map(self):
        _map = super(GetMezzanineInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mezzanine is not None:
            result['Mezzanine'] = self.mezzanine.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Mezzanine') is not None:
            temp_model = GetMezzanineInfoResponseBodyMezzanine()
            self.mezzanine = temp_model.from_map(m['Mezzanine'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMezzanineInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMezzanineInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMezzanineInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMezzanineInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPlayInfoRequest(TeaModel):
    def __init__(self, addition_type=None, auth_timeout=None, definition=None, digital_watermark_type=None,
                 formats=None, output_type=None, play_config=None, re_auth_info=None, result_type=None, stream_type=None,
                 trace=None, video_id=None):
        # The URL of the masked live comment data. Set the value to **danmu**.
        # 
        # > This parameter takes effect only when the outputType parameter is set to **cdn**.
        self.addition_type = addition_type  # type: str
        # The validity period of the playback URL. Unit: seconds.
        # 
        # *   If you set OutputType to **cdn**:
        # 
        #     *   The playback URL has a validity period only if URL signing is enabled. Otherwise, the playback URL is permanently valid. For more information about how to enable and configure URL signing, see [URL signing](~~86090~~).
        #     *   Minimum value: **1**.
        #     *   Maximum value: unlimited.
        #     *   Default value: The default validity period that is specified in URL signing is used.
        # 
        # *   If you set OutputType to **oss**:
        # 
        #     *   This parameter takes effect only when the ACL of the Object Storage Service (OSS) bucket is private. Otherwise, the playback URL does not expire.
        #     *   Minimum value: **1**.
        #     *   Maximum value: If the media file is stored in the VOD bucket, the maximum validity period is **2592000** (30 days). If the media file is stored in an OSS bucket, the maximum validity period is **129600** (36 hours). This limit is imposed to reduce security risks of the origin server. If you require a longer validity period, set OutputType to **cdn** and configure URL signing to specify a longer validity period.
        #     *   Default value: **3600**.
        self.auth_timeout = auth_timeout  # type: long
        # The quality of the video stream. Separate multiple qualities with commas (,). Valid values:
        # 
        # *   **FD**: low definition
        # *   **LD**: standard definition
        # *   **SD**: high definition
        # *   **HD**: ultra-high definition
        # *   **OD**: original definition
        # *   **2K**: 2K
        # *   **4K**: 4K
        # *   **SQ**: standard sound quality
        # *   **HQ**: high sound quality
        # *   **AUTO**: adaptive bitrate
        # 
        # > By default, ApsaraVideo VOD returns video streams in all preceding qualities. However, video streams for adaptive bitrate streaming are returned only if the PackageSetting parameter is specified in the transcoding template. For more information, see the [PackageSetting parameter in the TranscodeTemplate](~~52839~~) table.
        self.definition = definition  # type: str
        # The type of the digital watermark. Valid values:
        # 
        # *   TraceMark: tracing watermark
        # *   CopyrightMark: copyright watermark
        self.digital_watermark_type = digital_watermark_type  # type: str
        # The format of the media stream. Separate multiple formats with commas (,). Valid values:
        # 
        # *   **mp4**\
        # *   **m3u8**\
        # *   **mp3**\
        # *   **mpd**\
        # 
        # > By default, ApsaraVideo VOD returns video streams in all the preceding formats. However, video streams in the MPD format are returned only if the MPD container format is specified in the transcoding template. For more information, see the [Container parameter in the TranscodeTemplate](~~52839~~) table.
        self.formats = formats  # type: str
        # The type of the output URL. Default value: oss. Valid values:
        # 
        # *   **oss**\
        # *   **cdn**\
        self.output_type = output_type  # type: str
        # The custom playback configuration. The value is a JSON string. For more information, see [PlayConfig](~~86952~~).
        # 
        # >-   If you do not specify PlayConfig or `PlayDomain` in PlayConfig, the default domain name configured in ApsaraVideo VOD is used in this operation. If no default domain name is configured, the domain names are queried in reverse chronological order based on the time when the domain names were modified. The domain name that was last modified is used as the streaming domain name. To prevent domain name issues, we recommend that you specify the default streaming domain name. You can log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com) and choose **Configuration Management** > **Media Management** > **Storage** > **Manage** > **Origin Domain Name** to set the default streaming domain name.
        # >-   If the `EncryptType` parameter in PlayConfig is set to `AliyunVoDEncryption`, the playback URL of the stream encrypted by using proprietary cryptography is not returned to ensure video security. If you want to return such URL, you must set the `ResultType` parameter to `Multiple`.
        self.play_config = play_config  # type: str
        # The CDN reauthentication configuration. The value is a JSON string. If CDN reauthentication is enabled, you can use this parameter to specify the UID and rand fields for URL authentication. For more information, see [URL authentication](~~57007~~).
        self.re_auth_info = re_auth_info  # type: str
        # The type of the data to return. Default value: Single. Valid values:
        # 
        # *   **Single**: Only one latest transcoded stream is returned for each quality and format.
        # *   **Multiple**: All transcoded streams are returned for each quality and format.
        self.result_type = result_type  # type: str
        # The type of the media stream. Separate multiple types with commas (,). Valid values:
        # 
        # *   **video**\
        # *   **audio**\
        # 
        # By default, video and audio streams are returned.
        self.stream_type = stream_type  # type: str
        # The custom digital watermark.
        # 
        # *   If you set `DigitalWatermarkType` to `TraceMark`, specify this parameter to configure the video tracing watermark and return the video stream that contains the watermark. The value can be up to 1,024 characters in length and can contain letters and digits.
        # *   If you set `DigitalWatermarkType` to `CopyrightMark`, specify the **watermark text** that you created for the watermark template for this parameter.`` You can specify this parameter to query and return the video stream that contains the specified watermark text.
        self.trace = trace  # type: str
        # The ID of the media file. You can specify only one ID. You can use one of the following methods to obtain the media ID:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, you can view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of the VideoId parameter from the response to the [CreateUploadVideo](~~55407~~) operation.
        # *   Obtain the value of the VideoId parameter from the response to the [SearchMedia](~~86044~~) operation. This method is applicable to files that have been uploaded.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addition_type is not None:
            result['AdditionType'] = self.addition_type
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.digital_watermark_type is not None:
            result['DigitalWatermarkType'] = self.digital_watermark_type
        if self.formats is not None:
            result['Formats'] = self.formats
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.play_config is not None:
            result['PlayConfig'] = self.play_config
        if self.re_auth_info is not None:
            result['ReAuthInfo'] = self.re_auth_info
        if self.result_type is not None:
            result['ResultType'] = self.result_type
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.trace is not None:
            result['Trace'] = self.trace
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionType') is not None:
            self.addition_type = m.get('AdditionType')
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('DigitalWatermarkType') is not None:
            self.digital_watermark_type = m.get('DigitalWatermarkType')
        if m.get('Formats') is not None:
            self.formats = m.get('Formats')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('PlayConfig') is not None:
            self.play_config = m.get('PlayConfig')
        if m.get('ReAuthInfo') is not None:
            self.re_auth_info = m.get('ReAuthInfo')
        if m.get('ResultType') is not None:
            self.result_type = m.get('ResultType')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('Trace') is not None:
            self.trace = m.get('Trace')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetPlayInfoResponseBodyPlayInfoListPlayInfo(TeaModel):
    def __init__(self, bit_depth=None, bitrate=None, creation_time=None, definition=None, duration=None,
                 encrypt=None, encrypt_type=None, format=None, fps=None, hdrtype=None, height=None, job_ext=None, job_id=None,
                 job_type=None, modification_time=None, narrow_band_type=None, play_url=None, size=None, specification=None,
                 status=None, stream_type=None, watermark_id=None, width=None):
        # The color depth. This value is an integer.
        self.bit_depth = bit_depth  # type: int
        # The bitrate of the media stream. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The time when the audio or video stream was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The quality of the media stream. Valid values:
        # 
        # *   **FD**: low definition
        # *   **LD**: standard definition
        # *   **SD**: high definition
        # *   **HD**: ultra-high definition
        # *   **OD**: original definition
        # *   **2K**: 2K
        # *   **4K**: 4K
        # *   **SQ**: standard sound quality
        # *   **HQ**: high sound quality
        # *   **AUTO**: adaptive bitrate
        self.definition = definition  # type: str
        # The duration of the media stream. Unit: seconds. 86,400 seconds is equivalent to 24 hours.
        self.duration = duration  # type: str
        # Indicates whether the media stream is encrypted. Valid values:
        # 
        # *   **0**: The media stream is not encrypted.
        # *   **1**: The media stream is encrypted.
        self.encrypt = encrypt  # type: long
        # The encryption type of the media stream. Valid values:
        # 
        # *   **AliyunVoDEncryption**: Alibaba Cloud proprietary cryptography
        # *   **HLSEncryption**: HTTP Live Streaming (HLS) encryption
        # 
        # >  If the encryption type is AliyunVoDEncryption, only ApsaraVideo Player SDK can be used to play videos.
        self.encrypt_type = encrypt_type  # type: str
        # The format of the media stream.
        # 
        # *   If the media file is a video file, the valid values are **mp4** and **m3u8**.
        # *   If the media file is an audio-only file, the value is **mp3**.
        self.format = format  # type: str
        # The frame rate of the media stream. Unit: frames per second.
        self.fps = fps  # type: str
        # The HDR type of the media stream. Valid values:
        # 
        # *   HDR
        # *   HDR10
        # *   HLG
        # *   DolbyVision
        # *   HDRVivid
        # *   SDR+\
        self.hdrtype = hdrtype  # type: str
        # The height of the media stream. Unit: pixels.
        self.height = height  # type: long
        # The custom watermark information of the copyright watermark. This parameter is returned if you set `JobType` to `2`.
        self.job_ext = job_ext  # type: str
        # The job ID for transcoding the media stream. This ID uniquely identifies a media stream.
        self.job_id = job_id  # type: str
        # The type of the digital watermark. Valid values:
        # 
        # *   **1**: tracing watermark
        # *   **2**: copyright watermark
        self.job_type = job_type  # type: int
        # The time when the audio or video file was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The type of Narrowband HD transcoding. Valid values:
        # 
        # *   **0**: normal transcoding
        # *   **1.0**: Narrowband HD 1.0
        # *   **2.0**: Narrowband HD 2.0
        # 
        # This parameter is returned only when a quality that is available in the built-in Narrowband HD 1.0 transcoding template is specified. For more information, see the [Definition parameter in the TranscodeTemplate](~~52839~~) table.
        self.narrow_band_type = narrow_band_type  # type: str
        # The playback URL of the media stream.
        self.play_url = play_url  # type: str
        # The size of the media stream. Unit: bytes.
        self.size = size  # type: long
        # The specifications of transcoded audio and video streams. For more information about the valid values, see [Output specifications](~~124671~~).
        self.specification = specification  # type: str
        # The status of the audio or video stream. Valid values:
        # 
        # *   **Normal**: The latest transcoded stream in each quality and format is in the Normal status.
        # *   **Invisible**: If multiple streams are transcoded in the same quality and format, the latest transcoded stream is in the Normal status and other streams are in the Invisible status.
        self.status = status  # type: str
        # The type of the media stream. If the media stream is a video stream, the value is **video**. If the media stream is an audio-only stream, the value is **audio**.
        self.stream_type = stream_type  # type: str
        # The ID of the watermark that is associated with the media stream.
        self.watermark_id = watermark_id  # type: str
        # The width of the media stream. Unit: pixels.
        self.width = width  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoResponseBodyPlayInfoListPlayInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_depth is not None:
            result['BitDepth'] = self.bit_depth
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.height is not None:
            result['Height'] = self.height
        if self.job_ext is not None:
            result['JobExt'] = self.job_ext
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.narrow_band_type is not None:
            result['NarrowBandType'] = self.narrow_band_type
        if self.play_url is not None:
            result['PlayURL'] = self.play_url
        if self.size is not None:
            result['Size'] = self.size
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BitDepth') is not None:
            self.bit_depth = m.get('BitDepth')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('JobExt') is not None:
            self.job_ext = m.get('JobExt')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('NarrowBandType') is not None:
            self.narrow_band_type = m.get('NarrowBandType')
        if m.get('PlayURL') is not None:
            self.play_url = m.get('PlayURL')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPlayInfoResponseBodyPlayInfoList(TeaModel):
    def __init__(self, play_info=None):
        self.play_info = play_info  # type: list[GetPlayInfoResponseBodyPlayInfoListPlayInfo]

    def validate(self):
        if self.play_info:
            for k in self.play_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPlayInfoResponseBodyPlayInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PlayInfo'] = []
        if self.play_info is not None:
            for k in self.play_info:
                result['PlayInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.play_info = []
        if m.get('PlayInfo') is not None:
            for k in m.get('PlayInfo'):
                temp_model = GetPlayInfoResponseBodyPlayInfoListPlayInfo()
                self.play_info.append(temp_model.from_map(k))
        return self


class GetPlayInfoResponseBodyVideoBase(TeaModel):
    def __init__(self, cover_url=None, creation_time=None, dan_mu_url=None, duration=None, media_type=None,
                 status=None, storage_class=None, title=None, video_id=None):
        # The thumbnail URL of the audio or video file.
        self.cover_url = cover_url  # type: str
        # The time when the audio or video file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The URL of the masked live comment data.
        self.dan_mu_url = dan_mu_url  # type: str
        # The duration of the audio or video file. Unit: seconds.
        self.duration = duration  # type: str
        # The type of the media file. Valid values:
        # 
        # *   **video**\
        # *   **audio**\
        self.media_type = media_type  # type: str
        # The status of the audio or video file. For more information about the value range and description, see the [Status](~~52839~~) table.
        self.status = status  # type: str
        # The storage class of the audio or video file. Valid values:
        # 
        # *   **Standard**: All media resources are stored as Standard objects.
        # *   **IA**: All media resources are stored as IA objects.
        # *   **Archive**: All media resources are stored as Archive objects.
        # *   **ColdArchive**: All media resources are stored as Cold Archive objects.
        # *   **SourceIA**: Only the source files are IA objects.
        # *   **SourceArchive**: Only the source files are Archive objects.
        # *   **SourceColdArchive**: Only the source files are Cold Archive objects.
        # *   **Changing**: The storage class of the audio or video file is being changed.
        # *   **SourceChanging**: The storage class of the source file is being changed.
        self.storage_class = storage_class  # type: str
        # The title of the audio or video file.
        self.title = title  # type: str
        # The ID of the media file.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoResponseBodyVideoBase, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.dan_mu_url is not None:
            result['DanMuURL'] = self.dan_mu_url
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DanMuURL') is not None:
            self.dan_mu_url = m.get('DanMuURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetPlayInfoResponseBody(TeaModel):
    def __init__(self, play_info_list=None, request_id=None, video_base=None):
        # The information about the audio or video stream.
        self.play_info_list = play_info_list  # type: GetPlayInfoResponseBodyPlayInfoList
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The basic information about the audio or video file.
        self.video_base = video_base  # type: GetPlayInfoResponseBodyVideoBase

    def validate(self):
        if self.play_info_list:
            self.play_info_list.validate()
        if self.video_base:
            self.video_base.validate()

    def to_map(self):
        _map = super(GetPlayInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.play_info_list is not None:
            result['PlayInfoList'] = self.play_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.video_base is not None:
            result['VideoBase'] = self.video_base.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PlayInfoList') is not None:
            temp_model = GetPlayInfoResponseBodyPlayInfoList()
            self.play_info_list = temp_model.from_map(m['PlayInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VideoBase') is not None:
            temp_model = GetPlayInfoResponseBodyVideoBase()
            self.video_base = temp_model.from_map(m['VideoBase'])
        return self


class GetPlayInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPlayInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPlayInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTranscodeSummaryRequest(TeaModel):
    def __init__(self, video_ids=None):
        # The ID of the audio or video file. You can specify up to 10 IDs. Separate the IDs with commas (,). You can use one of the following methods to obtain the ID:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you call to obtain the upload URL and credential.
        # *   Obtain the value of VideoId by calling the [SearchMedia](~~86044~~) operation. This method is applicable to files that have been uploaded.
        self.video_ids = video_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_ids is not None:
            result['VideoIds'] = self.video_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoIds') is not None:
            self.video_ids = m.get('VideoIds')
        return self


class GetTranscodeSummaryResponseBodyTranscodeSummaryListTranscodeJobInfoSummaryList(TeaModel):
    def __init__(self, bitrate=None, complete_time=None, creation_time=None, duration=None, error_code=None,
                 error_message=None, filesize=None, format=None, fps=None, height=None, transcode_job_status=None,
                 transcode_progress=None, transcode_template_id=None, watermark_id_list=None, width=None):
        # The average bitrate of the output video. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The time when the transcoding job was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the transcoding job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The duration of the output video. Unit: seconds.
        self.duration = duration  # type: str
        # The error code returned when the transcoding job failed.
        self.error_code = error_code  # type: str
        # The error message returned when the transcoding job failed.
        self.error_message = error_message  # type: str
        # The size of the output video. Unit: bytes.
        self.filesize = filesize  # type: long
        # The container format of the output video.
        self.format = format  # type: str
        # The frame rate of the output video. Unit: frames per second.
        self.fps = fps  # type: str
        # The height of the output video. Unit: pixels.
        self.height = height  # type: str
        # The status of the transcoding job. Valid values:
        # *   **Transcoding**\
        # *   **TranscodeSuccess**\
        # *   **TranscodeFail**\
        self.transcode_job_status = transcode_job_status  # type: str
        # The transcoding progress. Valid values: `[0,100]`.
        self.transcode_progress = transcode_progress  # type: long
        # The ID of the transcoding template.
        self.transcode_template_id = transcode_template_id  # type: str
        # The IDs of the watermarks that are applied to the output video.
        self.watermark_id_list = watermark_id_list  # type: list[str]
        # The width of the output video. Unit: pixels.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeSummaryResponseBodyTranscodeSummaryListTranscodeJobInfoSummaryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.filesize is not None:
            result['Filesize'] = self.filesize
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.transcode_job_status is not None:
            result['TranscodeJobStatus'] = self.transcode_job_status
        if self.transcode_progress is not None:
            result['TranscodeProgress'] = self.transcode_progress
        if self.transcode_template_id is not None:
            result['TranscodeTemplateId'] = self.transcode_template_id
        if self.watermark_id_list is not None:
            result['WatermarkIdList'] = self.watermark_id_list
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Filesize') is not None:
            self.filesize = m.get('Filesize')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('TranscodeJobStatus') is not None:
            self.transcode_job_status = m.get('TranscodeJobStatus')
        if m.get('TranscodeProgress') is not None:
            self.transcode_progress = m.get('TranscodeProgress')
        if m.get('TranscodeTemplateId') is not None:
            self.transcode_template_id = m.get('TranscodeTemplateId')
        if m.get('WatermarkIdList') is not None:
            self.watermark_id_list = m.get('WatermarkIdList')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeSummaryResponseBodyTranscodeSummaryList(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, transcode_job_info_summary_list=None,
                 transcode_status=None, transcode_template_group_id=None, video_id=None):
        # The time when the transcoding task was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the transcoding task was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The summaries of transcoding jobs.
        self.transcode_job_info_summary_list = transcode_job_info_summary_list  # type: list[GetTranscodeSummaryResponseBodyTranscodeSummaryListTranscodeJobInfoSummaryList]
        # The status of the transcoding task. Valid values:
        # *   **Processing**: In progress.
        # *   **Partial**: Some transcoding jobs were complete.
        # *   **CompleteAllSucc**: All transcoding jobs were successful.
        # *   **CompleteAllFail**: All transcoding jobs failed. If an exception occurs in the source file, no transcoding job is initiated and the transcoding task fails.
        # *   **CompletePartialSucc**: All transcoding jobs were complete but only some were successful.
        self.transcode_status = transcode_status  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The ID of the audio or video file.
        self.video_id = video_id  # type: str

    def validate(self):
        if self.transcode_job_info_summary_list:
            for k in self.transcode_job_info_summary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeSummaryResponseBodyTranscodeSummaryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        result['TranscodeJobInfoSummaryList'] = []
        if self.transcode_job_info_summary_list is not None:
            for k in self.transcode_job_info_summary_list:
                result['TranscodeJobInfoSummaryList'].append(k.to_map() if k else None)
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        self.transcode_job_info_summary_list = []
        if m.get('TranscodeJobInfoSummaryList') is not None:
            for k in m.get('TranscodeJobInfoSummaryList'):
                temp_model = GetTranscodeSummaryResponseBodyTranscodeSummaryListTranscodeJobInfoSummaryList()
                self.transcode_job_info_summary_list.append(temp_model.from_map(k))
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetTranscodeSummaryResponseBody(TeaModel):
    def __init__(self, non_exist_video_ids=None, request_id=None, transcode_summary_list=None):
        # The IDs of the audio or video files that do not exist.
        self.non_exist_video_ids = non_exist_video_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The transcoding summary of the file.
        self.transcode_summary_list = transcode_summary_list  # type: list[GetTranscodeSummaryResponseBodyTranscodeSummaryList]

    def validate(self):
        if self.transcode_summary_list:
            for k in self.transcode_summary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_video_ids is not None:
            result['NonExistVideoIds'] = self.non_exist_video_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TranscodeSummaryList'] = []
        if self.transcode_summary_list is not None:
            for k in self.transcode_summary_list:
                result['TranscodeSummaryList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExistVideoIds') is not None:
            self.non_exist_video_ids = m.get('NonExistVideoIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.transcode_summary_list = []
        if m.get('TranscodeSummaryList') is not None:
            for k in m.get('TranscodeSummaryList'):
                temp_model = GetTranscodeSummaryResponseBodyTranscodeSummaryList()
                self.transcode_summary_list.append(temp_model.from_map(k))
        return self


class GetTranscodeSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTranscodeSummaryResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTranscodeSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTranscodeSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTranscodeTaskRequest(TeaModel):
    def __init__(self, transcode_task_id=None):
        # The ID of the transcoding task. You can use one of the following methods to obtain the ID:
        # 
        # *   Obtain the value of TranscodeTaskId from the response to the [SubmitTranscodeJobs](~~68570~~) operation.
        # *   Obtain the value of TranscodeTaskId from the response to the [ListTranscodeTask](~~109120~~) operation.
        self.transcode_task_id = transcode_task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.transcode_task_id is not None:
            result['TranscodeTaskId'] = self.transcode_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TranscodeTaskId') is not None:
            self.transcode_task_id = m.get('TranscodeTaskId')
        return self


class GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoListOutputFile(TeaModel):
    def __init__(self, audio_stream_list=None, bitrate=None, duration=None, encryption=None, filesize=None,
                 format=None, fps=None, height=None, output_file_url=None, subtitle_stream_list=None,
                 video_stream_list=None, watermark_id_list=None, width=None):
        # The audio streams.
        self.audio_stream_list = audio_stream_list  # type: str
        # The average bitrate of the output file. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The length of the output file. Unit: seconds.
        self.duration = duration  # type: str
        # The encryption method of the output file. Valid values:
        # 
        # *   **AliyunVoDEncryption**: Alibaba Cloud proprietary cryptography
        # *   **HLSEncryption**: HTTP Live Streaming (HLS) encryption
        self.encryption = encryption  # type: str
        # The size of the output file. Unit: byte.
        self.filesize = filesize  # type: long
        # The container format of the output file.
        self.format = format  # type: str
        # The frame rate of the output file. Unit: frames per second.
        self.fps = fps  # type: str
        # The height of the output video. Unit: pixels.
        self.height = height  # type: str
        # The OSS URL of the output file.
        self.output_file_url = output_file_url  # type: str
        # The subtitle streams.
        self.subtitle_stream_list = subtitle_stream_list  # type: str
        # The video streams.
        self.video_stream_list = video_stream_list  # type: str
        # The IDs of the watermarks used by the output file.
        self.watermark_id_list = watermark_id_list  # type: list[str]
        # The width of the output video. Unit: pixels.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoListOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encryption is not None:
            result['Encryption'] = self.encryption
        if self.filesize is not None:
            result['Filesize'] = self.filesize
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.output_file_url is not None:
            result['OutputFileUrl'] = self.output_file_url
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list
        if self.watermark_id_list is not None:
            result['WatermarkIdList'] = self.watermark_id_list
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            self.audio_stream_list = m.get('AudioStreamList')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encryption') is not None:
            self.encryption = m.get('Encryption')
        if m.get('Filesize') is not None:
            self.filesize = m.get('Filesize')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OutputFileUrl') is not None:
            self.output_file_url = m.get('OutputFileUrl')
        if m.get('SubtitleStreamList') is not None:
            self.subtitle_stream_list = m.get('SubtitleStreamList')
        if m.get('VideoStreamList') is not None:
            self.video_stream_list = m.get('VideoStreamList')
        if m.get('WatermarkIdList') is not None:
            self.watermark_id_list = m.get('WatermarkIdList')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoList(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, definition=None, error_code=None, error_message=None,
                 input_file_url=None, output_file=None, priority=None, transcode_job_id=None, transcode_job_status=None,
                 transcode_progress=None, transcode_template_id=None):
        # The time when the transcoding job was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the transcoding job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The video resolution. Valid values:
        # 
        # *   **LD**: low definition
        # *   **SD**: standard definition
        # *   **HD**: high definition
        # *   **FHD**: ultra high definition
        # *   **OD**: original definition
        # *   **2K**: 2K
        # *   **4K**: 4K
        # *   **SQ**: standard sound quality
        # *   **HQ**: high sound quality
        # *   **AUTO**: adaptive bitrate Adaptive bitrate streams are returned only if PackageSetting is set in the transcoding template. For more information, see [Basic structures](~~52839~~).
        # 
        # > This parameter indicates the definition that is configured in the transcoding template and does not indicate the actual resolution of the output video.
        self.definition = definition  # type: str
        # The error code returned when the transcoding job failed.
        self.error_code = error_code  # type: str
        # The error message returned when the transcoding job failed.
        self.error_message = error_message  # type: str
        # The Object Storage Service (OSS) URL of the input file.
        self.input_file_url = input_file_url  # type: str
        # The information about the output file.
        self.output_file = output_file  # type: GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoListOutputFile
        # The priority of the transcoding job.
        self.priority = priority  # type: str
        # The ID of the transcoding job.
        self.transcode_job_id = transcode_job_id  # type: str
        # The status of the transcoding job.
        # 
        # *   **Transcoding**\
        # *   **TranscodeSuccess**\
        # *   **TranscodeFail**\
        self.transcode_job_status = transcode_job_status  # type: str
        # The progress of the transcoding job. Valid values: `[0,100]`.
        self.transcode_progress = transcode_progress  # type: long
        # The ID of the transcoding template.
        self.transcode_template_id = transcode_template_id  # type: str

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super(GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.input_file_url is not None:
            result['InputFileUrl'] = self.input_file_url
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.transcode_job_id is not None:
            result['TranscodeJobId'] = self.transcode_job_id
        if self.transcode_job_status is not None:
            result['TranscodeJobStatus'] = self.transcode_job_status
        if self.transcode_progress is not None:
            result['TranscodeProgress'] = self.transcode_progress
        if self.transcode_template_id is not None:
            result['TranscodeTemplateId'] = self.transcode_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InputFileUrl') is not None:
            self.input_file_url = m.get('InputFileUrl')
        if m.get('OutputFile') is not None:
            temp_model = GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoListOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TranscodeJobId') is not None:
            self.transcode_job_id = m.get('TranscodeJobId')
        if m.get('TranscodeJobStatus') is not None:
            self.transcode_job_status = m.get('TranscodeJobStatus')
        if m.get('TranscodeProgress') is not None:
            self.transcode_progress = m.get('TranscodeProgress')
        if m.get('TranscodeTemplateId') is not None:
            self.transcode_template_id = m.get('TranscodeTemplateId')
        return self


class GetTranscodeTaskResponseBodyTranscodeTask(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, task_status=None, transcode_job_info_list=None,
                 transcode_task_id=None, transcode_template_group_id=None, trigger=None, video_id=None):
        # The time when the transcoding task was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the transcoding task was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The status of the transcoding task. Valid values:
        # 
        # *   **Processing**: In progress.
        # *   **Partial**: Some transcoding jobs were complete.
        # *   **CompleteAllSucc**: All transcoding jobs were successful.
        # *   **CompleteAllFail**: All transcoding jobs failed. If an exception occurs in the source file, no transcoding job is initiated and the transcoding task fails.
        # *   **CompletePartialSucc**: All transcoding jobs were complete but only some were successful.
        self.task_status = task_status  # type: str
        # Details about transcoding jobs.
        self.transcode_job_info_list = transcode_job_info_list  # type: list[GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoList]
        # The ID of the transcoding task.
        self.transcode_task_id = transcode_task_id  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The mode in which the transcoding task is triggered. Valid values:
        # 
        # *   **Auto**: The transcoding task is automatically triggered when the video is uploaded.
        # *   **Manual**: The transcoding task is triggered by calling the SubmitTranscodeJobs operation.
        self.trigger = trigger  # type: str
        # The ID of the audio or video file.
        self.video_id = video_id  # type: str

    def validate(self):
        if self.transcode_job_info_list:
            for k in self.transcode_job_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeTaskResponseBodyTranscodeTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        result['TranscodeJobInfoList'] = []
        if self.transcode_job_info_list is not None:
            for k in self.transcode_job_info_list:
                result['TranscodeJobInfoList'].append(k.to_map() if k else None)
        if self.transcode_task_id is not None:
            result['TranscodeTaskId'] = self.transcode_task_id
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        if self.trigger is not None:
            result['Trigger'] = self.trigger
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        self.transcode_job_info_list = []
        if m.get('TranscodeJobInfoList') is not None:
            for k in m.get('TranscodeJobInfoList'):
                temp_model = GetTranscodeTaskResponseBodyTranscodeTaskTranscodeJobInfoList()
                self.transcode_job_info_list.append(temp_model.from_map(k))
        if m.get('TranscodeTaskId') is not None:
            self.transcode_task_id = m.get('TranscodeTaskId')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        if m.get('Trigger') is not None:
            self.trigger = m.get('Trigger')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetTranscodeTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_task=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Details about transcoding tasks.
        self.transcode_task = transcode_task  # type: GetTranscodeTaskResponseBodyTranscodeTask

    def validate(self):
        if self.transcode_task:
            self.transcode_task.validate()

    def to_map(self):
        _map = super(GetTranscodeTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_task is not None:
            result['TranscodeTask'] = self.transcode_task.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeTask') is not None:
            temp_model = GetTranscodeTaskResponseBodyTranscodeTask()
            self.transcode_task = temp_model.from_map(m['TranscodeTask'])
        return self


class GetTranscodeTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTranscodeTaskResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTranscodeTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTranscodeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTranscodeTemplateGroupRequest(TeaModel):
    def __init__(self, transcode_template_group_id=None):
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeTemplateGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        return self


class GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupTranscodeTemplateList(TeaModel):
    def __init__(self, audio=None, clip=None, container=None, copyright_mark=None, definition=None,
                 encrypt_setting=None, mux_config=None, package_setting=None, rotate=None, subtitle_list=None, template_name=None,
                 trace_mark=None, trans_config=None, transcode_file_regular=None, transcode_template_id=None, type=None,
                 video=None, watermark_ids=None):
        # The transcoding configurations of the audio stream. The value is a JSON string.
        self.audio = audio  # type: str
        # The video cropping configurations. The value is a JSON string. For example, you can set this parameter to extract 5 seconds of content from a video to generate a new video.
        self.clip = clip  # type: str
        # The format of the container that is used to encapsulate audio and video streams. The value is a JSON string.
        self.container = container  # type: str
        # CopyrightMark.
        self.copyright_mark = copyright_mark  # type: str
        # Valid values for the definition of a common transcoding template:
        # 
        # *   **LD**: low definition.
        # *   **SD**: standard definition.
        # *   **HD**: high definition.
        # *   **FHD**: ultra high definition.
        # *   **OD**: original quality.
        # *   **2K**\
        # *   **4K**\
        # *   **SQ**: standard sound quality.
        # *   **HQ**: high sound quality.
        # 
        # Valid values for the definition of a Narrowband HD™ 1.0 transcoding template:
        # 
        # *   **LD-NBV1**: low definition.
        # *   **SD-NBV1**: standard definition.
        # *   **HD-NBV1**: high definition.
        # *   **FHD-NBV1**: ultra high definition.
        # *   **2K-NBV1**\
        # *   **4K-NBV1**\
        # 
        # > *   You cannot change the definition of a transcoding template.
        # >*   You cannot modify the system parameters of Narrowband HD™ 1.0 transcoding templates such as the video resolution, audio resolution, and bitrate.
        # >*   You can create only Narrowband HD™ 1.0 transcoding templates that support the FLV, M3U8 (HLS), and MP4 output formats.
        self.definition = definition  # type: str
        # The encryption configuration for transcoding.
        self.encrypt_setting = encrypt_setting  # type: str
        # The transcoding segment configurations. This parameter is used when you transcode a media stream into an HLS file. The value is a JSON string.
        self.mux_config = mux_config  # type: str
        # The packaging configuration. Only HTTP-Live-Streaming (HLS) packaging and DASH packaging are supported. The value is a JSON string.
        self.package_setting = package_setting  # type: str
        # The video rotation identifier. This parameter is used to control the image rotation angle. For example, if you set this parameter to 180, the video image is turned upside down. Valid values: `[0,360]`.
        self.rotate = rotate  # type: str
        # The subtitle configurations. The value is a JSON string.
        self.subtitle_list = subtitle_list  # type: str
        # The name of the transcoding template.
        self.template_name = template_name  # type: str
        # TraceMark.
        self.trace_mark = trace_mark  # type: str
        # The conditional transcoding configurations. This parameter is used if you want to determine the basic logic based on the bitrate and resolution of the source file before the transcoded video is generated. The value is a JSON string.
        self.trans_config = trans_config  # type: str
        # The custom path used to store the output files.
        self.transcode_file_regular = transcode_file_regular  # type: str
        # The ID of the transcoding template.
        self.transcode_template_id = transcode_template_id  # type: str
        # The type of the transcoding template. Valid values:
        # 
        # *   **Normal** (default): a common transcoding template. You cannot set the PackageSetting parameter for this type of template.
        # *   **VideoPackage**: a video stream package template. If this type of template is used, ApsaraVideo VOD transcodes a video into video streams in different bitrates and creates a multi-bitrate video package. You must set the PackageSetting parameter for this type of template.
        # *   **SubtitlePackage**: a subtitle package template. If this type of template is used, ApsaraVideo VOD adds the subtitle information to the output file that is generated by packaging the multi-bitrate video streams of the corresponding video. You must set the PackageSetting parameter for a subtitle packaging template and associate the subtitle packaging template with a video stream packaging template. You can configure only one subtitle packaging template in a template group.
        self.type = type  # type: str
        # The transcoding configurations of the video stream. The value is a JSON string.
        self.video = video  # type: str
        # The IDs of associated watermarks.
        self.watermark_ids = watermark_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupTranscodeTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio
        if self.clip is not None:
            result['Clip'] = self.clip
        if self.container is not None:
            result['Container'] = self.container
        if self.copyright_mark is not None:
            result['CopyrightMark'] = self.copyright_mark
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.encrypt_setting is not None:
            result['EncryptSetting'] = self.encrypt_setting
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config
        if self.package_setting is not None:
            result['PackageSetting'] = self.package_setting
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.trace_mark is not None:
            result['TraceMark'] = self.trace_mark
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config
        if self.transcode_file_regular is not None:
            result['TranscodeFileRegular'] = self.transcode_file_regular
        if self.transcode_template_id is not None:
            result['TranscodeTemplateId'] = self.transcode_template_id
        if self.type is not None:
            result['Type'] = self.type
        if self.video is not None:
            result['Video'] = self.video
        if self.watermark_ids is not None:
            result['WatermarkIds'] = self.watermark_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            self.audio = m.get('Audio')
        if m.get('Clip') is not None:
            self.clip = m.get('Clip')
        if m.get('Container') is not None:
            self.container = m.get('Container')
        if m.get('CopyrightMark') is not None:
            self.copyright_mark = m.get('CopyrightMark')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EncryptSetting') is not None:
            self.encrypt_setting = m.get('EncryptSetting')
        if m.get('MuxConfig') is not None:
            self.mux_config = m.get('MuxConfig')
        if m.get('PackageSetting') is not None:
            self.package_setting = m.get('PackageSetting')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleList') is not None:
            self.subtitle_list = m.get('SubtitleList')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TraceMark') is not None:
            self.trace_mark = m.get('TraceMark')
        if m.get('TransConfig') is not None:
            self.trans_config = m.get('TransConfig')
        if m.get('TranscodeFileRegular') is not None:
            self.transcode_file_regular = m.get('TranscodeFileRegular')
        if m.get('TranscodeTemplateId') is not None:
            self.transcode_template_id = m.get('TranscodeTemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Video') is not None:
            self.video = m.get('Video')
        if m.get('WatermarkIds') is not None:
            self.watermark_ids = m.get('WatermarkIds')
        return self


class GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroup(TeaModel):
    def __init__(self, app_id=None, creation_time=None, is_default=None, locked=None, modify_time=None, name=None,
                 transcode_template_group_id=None, transcode_template_list=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The time when the transcoding template group was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template group is the default one. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # Indicates whether the template group is locked. Valid values:
        # 
        # *   **Disabled**: The template group is not locked.
        # *   **Enabled**: The template group is locked.
        self.locked = locked  # type: str
        # The time when the transcoding template group was last modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The name of the transcoding template group.
        self.name = name  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The information about the transcoding templates.
        self.transcode_template_list = transcode_template_list  # type: list[GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupTranscodeTemplateList]

    def validate(self):
        if self.transcode_template_list:
            for k in self.transcode_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.locked is not None:
            result['Locked'] = self.locked
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        result['TranscodeTemplateList'] = []
        if self.transcode_template_list is not None:
            for k in self.transcode_template_list:
                result['TranscodeTemplateList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Locked') is not None:
            self.locked = m.get('Locked')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        self.transcode_template_list = []
        if m.get('TranscodeTemplateList') is not None:
            for k in m.get('TranscodeTemplateList'):
                temp_model = GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupTranscodeTemplateList()
                self.transcode_template_list.append(temp_model.from_map(k))
        return self


class GetTranscodeTemplateGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_template_group=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The information about the transcoding template group.
        self.transcode_template_group = transcode_template_group  # type: GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroup

    def validate(self):
        if self.transcode_template_group:
            self.transcode_template_group.validate()

    def to_map(self):
        _map = super(GetTranscodeTemplateGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_template_group is not None:
            result['TranscodeTemplateGroup'] = self.transcode_template_group.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeTemplateGroup') is not None:
            temp_model = GetTranscodeTemplateGroupResponseBodyTranscodeTemplateGroup()
            self.transcode_template_group = temp_model.from_map(m['TranscodeTemplateGroup'])
        return self


class GetTranscodeTemplateGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTranscodeTemplateGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTranscodeTemplateGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTranscodeTemplateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetURLUploadInfosRequest(TeaModel):
    def __init__(self, job_ids=None, upload_urls=None):
        # The one or more IDs of upload jobs. You can obtain the job IDs in the response parameter JobId of the [UploadMediaByURL](~~86311~~) operation.
        # 
        # - You can specify a maximum of 10 IDs.
        # - Separate multiple IDs with commas (,).
        # 
        # > You must set one of the JobIds and the UploadURLs parameters. If you set both the JobIds and UploadURLs parameters, only the value of the JobIds parameter takes effect.
        self.job_ids = job_ids  # type: str
        # The one or more upload URLs of the source files. Separate multiple URLs with commas (,). You can specify a maximum of 10 URLs.
        # 
        # > * You must encode the URLs before you use the URLs.
        # > * If a media file is uploaded multiple times, pass the URL of the media file to this parameter only once.
        # > * You must set one of the JobIds and the UploadURLs parameters. If you set both the JobIds and UploadURLs parameters, only the value of the JobIds parameter takes effect.
        self.upload_urls = upload_urls  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetURLUploadInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.upload_urls is not None:
            result['UploadURLs'] = self.upload_urls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('UploadURLs') is not None:
            self.upload_urls = m.get('UploadURLs')
        return self


class GetURLUploadInfosResponseBodyURLUploadInfoList(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, error_code=None, error_message=None, file_size=None,
                 job_id=None, media_id=None, status=None, upload_url=None, user_data=None):
        # The time when the upload job was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the upload job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The error code returned.
        self.error_code = error_code  # type: str
        # The error message returned.
        self.error_message = error_message  # type: str
        # The size of the uploaded media file. Unit: byte.
        self.file_size = file_size  # type: str
        # The ID of the upload job.
        self.job_id = job_id  # type: str
        # The ID of the uploaded media file.
        self.media_id = media_id  # type: str
        # The status of the URL-based upload job. For more information about the valid values and value description of the parameter, see the "Status: the status of a video" section of the [Basic structures](~~52839~~) topic.
        self.status = status  # type: str
        # The upload URL of the source file.
        # 
        # > A maximum of 100 URLs can be returned.
        self.upload_url = upload_url  # type: str
        # The custom configurations. The value is a JSON string. For more information, see the "UserData: specifies the custom configurations for media upload" section of the [Request parameters](~~86952~~) topic.
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetURLUploadInfosResponseBodyURLUploadInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.status is not None:
            result['Status'] = self.status
        if self.upload_url is not None:
            result['UploadURL'] = self.upload_url
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UploadURL') is not None:
            self.upload_url = m.get('UploadURL')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetURLUploadInfosResponseBody(TeaModel):
    def __init__(self, non_exists=None, request_id=None, urlupload_info_list=None):
        # The job IDs or upload URLs that do not exist.
        self.non_exists = non_exists  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about URL-based upload jobs. For more information, see the "URLUploadInfo: the information about a URL-based upload job" section of the [Basic structures](~~52839~~) topic.
        self.urlupload_info_list = urlupload_info_list  # type: list[GetURLUploadInfosResponseBodyURLUploadInfoList]

    def validate(self):
        if self.urlupload_info_list:
            for k in self.urlupload_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetURLUploadInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exists is not None:
            result['NonExists'] = self.non_exists
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['URLUploadInfoList'] = []
        if self.urlupload_info_list is not None:
            for k in self.urlupload_info_list:
                result['URLUploadInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExists') is not None:
            self.non_exists = m.get('NonExists')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.urlupload_info_list = []
        if m.get('URLUploadInfoList') is not None:
            for k in m.get('URLUploadInfoList'):
                temp_model = GetURLUploadInfosResponseBodyURLUploadInfoList()
                self.urlupload_info_list.append(temp_model.from_map(k))
        return self


class GetURLUploadInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetURLUploadInfosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetURLUploadInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetURLUploadInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUploadDetailsRequest(TeaModel):
    def __init__(self, media_ids=None, media_type=None):
        # The ID of the media file, namely, the audio or video ID. You can specify a maximum of 20 IDs. Separate multiple IDs with commas (,). You can use one of the following methods to obtain the audio or video ID:
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, you can view the audio or video ID. Use this method if the audio or video file is uploaded by using the ApsaraVideo VOD console.
        # *   View the value of the VideoId parameter returned by the [CreateUploadVideo](~~55407~~) operation that you called to obtain an upload URL and credential.
        # *   View the value of the VideoId parameter returned by the [SearchMedia](~~86044~~) operation that you called to query media information after the audio or video file is uploaded.
        self.media_ids = media_ids  # type: str
        # The type of the media file. Set the value to **video**, which indicates audio and video files.
        self.media_type = media_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUploadDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class GetUploadDetailsResponseBodyUploadDetails(TeaModel):
    def __init__(self, completion_time=None, creation_time=None, device_model=None, file_size=None, media_id=None,
                 modification_time=None, status=None, title=None, upload_ip=None, upload_ratio=None, upload_size=None,
                 upload_source=None, upload_status=None):
        # The time when the upload job was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.completion_time = completion_time  # type: str
        # The time when the upload job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The device model.
        self.device_model = device_model  # type: str
        # The size of the uploaded file. Unit: byte.
        self.file_size = file_size  # type: long
        # The ID of the uploaded audio or video.
        self.media_id = media_id  # type: str
        # The time when the information about the media file was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The status of the video. For more information about the valid values and value description of the parameter, see the "Status: the status of a video" section of the [Basic structures](~~52839~~) topic.
        self.status = status  # type: str
        # The title of the media file.
        self.title = title  # type: str
        # The IP address of the server that uploads the media file.
        self.upload_ip = upload_ip  # type: str
        # The upload ratio.
        self.upload_ratio = upload_ratio  # type: float
        # The upload size. Unit: byte.
        self.upload_size = upload_size  # type: long
        # The method that is used to upload the media file.
        self.upload_source = upload_source  # type: str
        # The status of the upload job. For more information about the valid values and value description of the parameter, see the "Status: the status of a URL-based upload job" section of the [Basic structures](~~52839~~) topic.
        self.upload_status = upload_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUploadDetailsResponseBodyUploadDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.completion_time is not None:
            result['CompletionTime'] = self.completion_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.upload_ip is not None:
            result['UploadIP'] = self.upload_ip
        if self.upload_ratio is not None:
            result['UploadRatio'] = self.upload_ratio
        if self.upload_size is not None:
            result['UploadSize'] = self.upload_size
        if self.upload_source is not None:
            result['UploadSource'] = self.upload_source
        if self.upload_status is not None:
            result['UploadStatus'] = self.upload_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompletionTime') is not None:
            self.completion_time = m.get('CompletionTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UploadIP') is not None:
            self.upload_ip = m.get('UploadIP')
        if m.get('UploadRatio') is not None:
            self.upload_ratio = m.get('UploadRatio')
        if m.get('UploadSize') is not None:
            self.upload_size = m.get('UploadSize')
        if m.get('UploadSource') is not None:
            self.upload_source = m.get('UploadSource')
        if m.get('UploadStatus') is not None:
            self.upload_status = m.get('UploadStatus')
        return self


class GetUploadDetailsResponseBody(TeaModel):
    def __init__(self, forbidden_media_ids=None, non_exist_media_ids=None, request_id=None, upload_details=None):
        # The IDs of the media files that cannot be accessed.
        self.forbidden_media_ids = forbidden_media_ids  # type: list[str]
        # The IDs of the media files that do not exist.
        self.non_exist_media_ids = non_exist_media_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The upload details.
        self.upload_details = upload_details  # type: list[GetUploadDetailsResponseBodyUploadDetails]

    def validate(self):
        if self.upload_details:
            for k in self.upload_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetUploadDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_media_ids is not None:
            result['ForbiddenMediaIds'] = self.forbidden_media_ids
        if self.non_exist_media_ids is not None:
            result['NonExistMediaIds'] = self.non_exist_media_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UploadDetails'] = []
        if self.upload_details is not None:
            for k in self.upload_details:
                result['UploadDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForbiddenMediaIds') is not None:
            self.forbidden_media_ids = m.get('ForbiddenMediaIds')
        if m.get('NonExistMediaIds') is not None:
            self.non_exist_media_ids = m.get('NonExistMediaIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.upload_details = []
        if m.get('UploadDetails') is not None:
            for k in m.get('UploadDetails'):
                temp_model = GetUploadDetailsResponseBodyUploadDetails()
                self.upload_details.append(temp_model.from_map(k))
        return self


class GetUploadDetailsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetUploadDetailsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUploadDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUploadDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoInfoRequest(TeaModel):
    def __init__(self, video_id=None):
        # The ID of the media file. You can use one of the following methods to obtain the ID of the file:
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you called to obtain an upload URL and credential.
        # *   Obtain the value of VideoId from the response to the [SearchMedia](~~86044~~) operation that you called to query the media ID after the media file is uploaded.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoInfoResponseBodyVideoSnapshots(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoInfoResponseBodyVideoSnapshots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot is not None:
            result['Snapshot'] = self.snapshot
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Snapshot') is not None:
            self.snapshot = m.get('Snapshot')
        return self


class GetVideoInfoResponseBodyVideo(TeaModel):
    def __init__(self, app_id=None, audit_status=None, cate_id=None, cate_name=None, cover_url=None,
                 creation_time=None, custom_media_info=None, description=None, duration=None, modification_time=None,
                 region_id=None, restore_expiration=None, restore_status=None, size=None, snapshots=None, status=None,
                 storage_class=None, storage_location=None, tags=None, template_group_id=None, title=None, video_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The review status of the video. Valid values:
        # 
        # *   **Normal**: pass
        # *   **Blocked**: failed
        self.audit_status = audit_status  # type: str
        # The category ID of the media file.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        self.cate_name = cate_name  # type: str
        # The thumbnail URL of the media file.
        self.cover_url = cover_url  # type: str
        # The time when the media file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The custom information about the media file.\n\n> This parameter has been deprecated. This parameter is no longer returned after you call the operation.
        self.custom_media_info = custom_media_info  # type: str
        # The description of the media file.
        self.description = description  # type: str
        # The duration of the media file. Unit: seconds.
        self.duration = duration  # type: float
        # The time when the media file was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The region where the media file is stored.
        self.region_id = region_id  # type: str
        # The period of time in which the object remains in the restored state.
        self.restore_expiration = restore_expiration  # type: str
        # The restoration status of the audio or video file. Valid values:
        # 
        # *   **Processing**\
        # *   **Success**\
        # *   **Failed**\
        self.restore_status = restore_status  # type: str
        # The size of the source file. Unit: bytes.
        self.size = size  # type: long
        # The video snapshot URLs.
        self.snapshots = snapshots  # type: GetVideoInfoResponseBodyVideoSnapshots
        # The status of the video. For information about the operations that can be performed on videos in different statuses and limits, see the Status: the status of a video section of the [Basic data types](~~52839~~) topic. Valid values:
        # 
        # *   **Uploading**: The video is being uploaded.
        # *   **UploadFail**: The video failed to be uploaded.
        # *   **UploadSucc**: The video has been uploaded.
        # *   **Transcoding**: The video is being transcoded.
        # *   **TranscodeFail**: The video failed to be transcoded.
        # *   **Blocked**: The video is blocked.
        # *   **Normal**: The video is normal.
        self.status = status  # type: str
        # The storage class of the audio or video file. Valid values:
        # 
        # *   **Standard**: All media resources are stored as Standard objects.
        # *   **IA**: All media resources are stored as IA objects.
        # *   **Archive**: All media resources are stored as Archive objects.
        # *   **ColdArchive**: All media resources are stored as Cold Archive objects.
        # *   **SourceIA**: Only the source files are IA objects.
        # *   **SourceArchive**: Only the source files are Archive objects.
        # *   **SourceColdArchive**: Only the source files are Cold Archive objects.
        # *   **Changing**: The storage class of the audio or video file is being changed.
        # *   **SourceChanging**: The storage class of the source file is being changed.
        self.storage_class = storage_class  # type: str
        # The storage address of the media file.
        self.storage_location = storage_location  # type: str
        # The tags of the media file. Multiple tags are separated by commas (,).
        self.tags = tags  # type: str
        # The ID of the transcoding template group.
        self.template_group_id = template_group_id  # type: str
        # The title of the media file.
        self.title = title  # type: str
        # The ID of the media file.
        self.video_id = video_id  # type: str

    def validate(self):
        if self.snapshots:
            self.snapshots.validate()

    def to_map(self):
        _map = super(GetVideoInfoResponseBodyVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.audit_status is not None:
            result['AuditStatus'] = self.audit_status
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.custom_media_info is not None:
            result['CustomMediaInfo'] = self.custom_media_info
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.restore_expiration is not None:
            result['RestoreExpiration'] = self.restore_expiration
        if self.restore_status is not None:
            result['RestoreStatus'] = self.restore_status
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.template_group_id is not None:
            result['TemplateGroupId'] = self.template_group_id
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AuditStatus') is not None:
            self.audit_status = m.get('AuditStatus')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CustomMediaInfo') is not None:
            self.custom_media_info = m.get('CustomMediaInfo')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RestoreExpiration') is not None:
            self.restore_expiration = m.get('RestoreExpiration')
        if m.get('RestoreStatus') is not None:
            self.restore_status = m.get('RestoreStatus')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            temp_model = GetVideoInfoResponseBodyVideoSnapshots()
            self.snapshots = temp_model.from_map(m['Snapshots'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TemplateGroupId') is not None:
            self.template_group_id = m.get('TemplateGroupId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, video=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the audio or video file.
        self.video = video  # type: GetVideoInfoResponseBodyVideo

    def validate(self):
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(GetVideoInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Video') is not None:
            temp_model = GetVideoInfoResponseBodyVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class GetVideoInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoInfosRequest(TeaModel):
    def __init__(self, video_ids=None):
        # The list of video IDs. Separate multiple IDs with commas (,). A maximum of 20 IDs can be specified.
        self.video_ids = video_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_ids is not None:
            result['VideoIds'] = self.video_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoIds') is not None:
            self.video_ids = m.get('VideoIds')
        return self


class GetVideoInfosResponseBodyVideoList(TeaModel):
    def __init__(self, app_id=None, cate_id=None, cate_name=None, cover_url=None, creation_time=None,
                 description=None, duration=None, modification_time=None, restore_expiration=None, restore_status=None,
                 size=None, snapshots=None, status=None, storage_class=None, storage_location=None, tags=None,
                 template_group_id=None, title=None, video_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The ID of the category.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        self.cate_name = cate_name  # type: str
        # The thumbnail URL of the audio or video file.
        self.cover_url = cover_url  # type: str
        # The time when the audio or video file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the audio or video file.
        self.description = description  # type: str
        # The duration of the audio or video file. Unit: seconds. 86,400 seconds is equivalent to 24 hours.
        self.duration = duration  # type: float
        # The time when the audio or video file was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The period of time in which the audio or video file remains in the restored state.
        self.restore_expiration = restore_expiration  # type: str
        # The restoration status of the audio or video file. Valid values:
        # 
        # *   **Processing**\
        # *   **Success**\
        # *   **Failed**\
        self.restore_status = restore_status  # type: str
        # The size of the source file. Unit: bytes.
        self.size = size  # type: long
        # The URL array of video snapshots.
        self.snapshots = snapshots  # type: list[str]
        # The status of the video. Valid values:
        # 
        # *   **Uploading**: The video is being uploaded.
        # *   **UploadFail**: The video failed to be uploaded.
        # *   **UploadSucc**: The video is uploaded.
        # *   **Transcoding**: The video is being transcoded.
        # *   **TranscodeFail**: The video failed to be transcoded.
        # *   **Blocked**: The video is blocked.
        # *   **Normal**: The video is normal.
        self.status = status  # type: str
        # The storage class of the audio or video file. Valid values:
        # 
        # *   **Standard**: All media resources are stored as Standard objects.
        # *   **IA**: All media resources are stored as IA objects.
        # *   **Archive**: All media resources are stored as Archive objects.
        # *   **ColdArchive**: All media resources are stored as Cold Archive objects.
        # *   **SourceIA**: Only the source files are IA objects.
        # *   **SourceArchive**: Only the source files are Archive objects.
        # *   **SourceColdArchive**: Only the source files are Cold Archive objects.
        # *   **Changing**: The storage class of the audio or video file is being changed.
        # *   **SourceChanging**: The storage class of the source file is being changed.
        self.storage_class = storage_class  # type: str
        # The storage address of the audio or video file.
        self.storage_location = storage_location  # type: str
        # The tags of the audio or video file. Multiple tags are separated by commas (,).
        self.tags = tags  # type: str
        # The ID of the transcoding template group.
        self.template_group_id = template_group_id  # type: str
        # The title of the audio or video file.
        self.title = title  # type: str
        # The ID of the audio or video file.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoInfosResponseBodyVideoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.restore_expiration is not None:
            result['RestoreExpiration'] = self.restore_expiration
        if self.restore_status is not None:
            result['RestoreStatus'] = self.restore_status
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.template_group_id is not None:
            result['TemplateGroupId'] = self.template_group_id
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('RestoreExpiration') is not None:
            self.restore_expiration = m.get('RestoreExpiration')
        if m.get('RestoreStatus') is not None:
            self.restore_status = m.get('RestoreStatus')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TemplateGroupId') is not None:
            self.template_group_id = m.get('TemplateGroupId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoInfosResponseBody(TeaModel):
    def __init__(self, non_exist_video_ids=None, request_id=None, video_list=None):
        # The IDs of the videos that do not exist.
        self.non_exist_video_ids = non_exist_video_ids  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the audio or video files.
        self.video_list = video_list  # type: list[GetVideoInfosResponseBodyVideoList]

    def validate(self):
        if self.video_list:
            for k in self.video_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetVideoInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_video_ids is not None:
            result['NonExistVideoIds'] = self.non_exist_video_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VideoList'] = []
        if self.video_list is not None:
            for k in self.video_list:
                result['VideoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExistVideoIds') is not None:
            self.non_exist_video_ids = m.get('NonExistVideoIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.video_list = []
        if m.get('VideoList') is not None:
            for k in m.get('VideoList'):
                temp_model = GetVideoInfosResponseBodyVideoList()
                self.video_list.append(temp_model.from_map(k))
        return self


class GetVideoInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoInfosResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoListRequest(TeaModel):
    def __init__(self, cate_id=None, end_time=None, page_no=None, page_size=None, sort_by=None, start_time=None,
                 status=None, storage_location=None):
        # The ID of the category. You can use one of the following methods to obtain the category ID:
        # 
        # *   Log on to the [ApsaraVideo VOD console](https://vod.console.aliyun.com). In the left-side navigation pane, choose **Configuration Management** > **Media Management** > **Categories** to view the category ID.
        # *   Obtain the value of CateId from the response to the [AddCategory](~~56401~~) operation.
        # *   Obtain the value of CateId from the response to the [GetCategories](~~56406~~) operation.
        self.cate_id = cate_id  # type: long
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The number of the page to return. Default value: **1**.
        self.page_no = page_no  # type: int
        # The number of entries to return on each page. Default value: **10**. Maximum value: **100**.
        self.page_size = page_size  # type: int
        # The sorting method of the results. Valid values:
        # 
        # *   **CreationTime:Desc** (default): The results are sorted in reverse chronological order based on the creation time.
        # *   **CreationTime:Asc**: The results are sorted in chronological order based on the creation time.
        self.sort_by = sort_by  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The status of the video. You can specify multiple video statuses and separate them with commas (,). Valid values:
        # 
        # *   **Uploading**: The video is being uploaded.
        # *   **UploadFail**: The video failed to be uploaded.
        # *   **UploadSucc**: The video has been uploaded.
        # *   **Transcoding**: The video is being transcoded.
        # *   **TranscodeFail**: The video failed to be transcoded.
        # *   **checking**: The video is being reviewed.
        # *   **Blocked**: The video is blocked.
        # *   **Normal**: The video is normal.
        # *   **ProduceFail**: The video failed to be produced.
        # 
        # For more information about each video status, see the "Status: the status of a video" section of the [Basic data types](~~52839#section-p7c-jgy-070~~) topic.
        self.status = status  # type: str
        # The storage address of the media file.
        self.storage_location = storage_location  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        return self


class GetVideoListResponseBodyVideoListVideoSnapshots(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoListResponseBodyVideoListVideoSnapshots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot is not None:
            result['Snapshot'] = self.snapshot
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Snapshot') is not None:
            self.snapshot = m.get('Snapshot')
        return self


class GetVideoListResponseBodyVideoListVideo(TeaModel):
    def __init__(self, app_id=None, cate_id=None, cate_name=None, cover_url=None, creation_time=None,
                 description=None, duration=None, modification_time=None, restore_expiration=None, restore_status=None,
                 size=None, snapshots=None, status=None, storage_class=None, storage_location=None, tags=None, title=None,
                 video_id=None):
        # The ID of the application. Default value: **app-1000000**.
        self.app_id = app_id  # type: str
        # The category ID of the audio or video file.
        self.cate_id = cate_id  # type: long
        # The name of the category.
        self.cate_name = cate_name  # type: str
        # The thumbnail URL of the audio or video file.
        self.cover_url = cover_url  # type: str
        # The time when the audio or video file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the audio or video file.
        self.description = description  # type: str
        # The duration of the audio or video file. Unit: seconds. 86,400 seconds is equivalent to 24 hours.
        self.duration = duration  # type: float
        # The time when the video was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The period of time in which the audio or video file remains in the restored state.
        self.restore_expiration = restore_expiration  # type: str
        # The restoration status of the audio or video file. Valid values:
        # 
        # *   **Processing**\
        # *   **Success**\
        # *   **Failed**\
        self.restore_status = restore_status  # type: str
        # The size of the source file. Unit: bytes.
        self.size = size  # type: long
        # The URL array of video snapshots.
        self.snapshots = snapshots  # type: GetVideoListResponseBodyVideoListVideoSnapshots
        # The status of the audio or video file. Valid values:
        # 
        # *   **Uploading**: The video is being uploaded.
        # *   **UploadFail**: The video failed to be uploaded.
        # *   **UploadSucc**: The video is uploaded.
        # *   **Transcoding**: The video is being transcoded.
        # *   **TranscodeFail**: The video failed to be transcoded.
        # *   **checking**: The video is being reviewed.
        # *   **Blocked**: The video is blocked.
        # *   **Normal**: The video is normal.
        # *   **ProduceFail**: The video failed to be produced.
        # 
        # For more information about each video status, see the "Status: the status of a video" section of the [Basic data types](~~52839#section-p7c-jgy-070~~) topic.
        self.status = status  # type: str
        # The storage class of the audio or video file. Valid values:
        # 
        # *   **Standard**: All media resources are stored as Standard objects.
        # *   **IA**: All media resources are stored as IA objects.
        # *   **Archive**: All media resources are stored as Archive objects.
        # *   **ColdArchive**: All media resources are stored as Cold Archive objects.
        # *   **SourceIA**: Only the source files are IA objects.
        # *   **SourceArchive**: Only the source files are Archive objects.
        # *   **SourceColdArchive**: Only the source files are Cold Archive objects.
        # *   **Changing**: The storage class of the audio or video file is being changed.
        # *   **SourceChanging**: The storage class of the source file is being changed.
        self.storage_class = storage_class  # type: str
        # The storage address of the audio or video file.
        self.storage_location = storage_location  # type: str
        # The tags of the audio or video file. Multiple tags are separated by commas (,).
        self.tags = tags  # type: str
        # The title of the audio or video file.
        self.title = title  # type: str
        # The ID of the audio or video file.
        self.video_id = video_id  # type: str

    def validate(self):
        if self.snapshots:
            self.snapshots.validate()

    def to_map(self):
        _map = super(GetVideoListResponseBodyVideoListVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.restore_expiration is not None:
            result['RestoreExpiration'] = self.restore_expiration
        if self.restore_status is not None:
            result['RestoreStatus'] = self.restore_status
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('RestoreExpiration') is not None:
            self.restore_expiration = m.get('RestoreExpiration')
        if m.get('RestoreStatus') is not None:
            self.restore_status = m.get('RestoreStatus')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            temp_model = GetVideoListResponseBodyVideoListVideoSnapshots()
            self.snapshots = temp_model.from_map(m['Snapshots'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoListResponseBodyVideoList(TeaModel):
    def __init__(self, video=None):
        self.video = video  # type: list[GetVideoListResponseBodyVideoListVideo]

    def validate(self):
        if self.video:
            for k in self.video:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetVideoListResponseBodyVideoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Video'] = []
        if self.video is not None:
            for k in self.video:
                result['Video'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video = []
        if m.get('Video') is not None:
            for k in m.get('Video'):
                temp_model = GetVideoListResponseBodyVideoListVideo()
                self.video.append(temp_model.from_map(k))
        return self


class GetVideoListResponseBody(TeaModel):
    def __init__(self, request_id=None, total=None, video_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of media files returned.
        self.total = total  # type: int
        # The information about the audio or video files. Information about a maximum of 5,000 audio or video files can be returned.
        self.video_list = video_list  # type: GetVideoListResponseBodyVideoList

    def validate(self):
        if self.video_list:
            self.video_list.validate()

    def to_map(self):
        _map = super(GetVideoListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.video_list is not None:
            result['VideoList'] = self.video_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('VideoList') is not None:
            temp_model = GetVideoListResponseBodyVideoList()
            self.video_list = temp_model.from_map(m['VideoList'])
        return self


class GetVideoListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoListResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoPlayAuthRequest(TeaModel):
    def __init__(self, api_version=None, auth_info_timeout=None, video_id=None):
        # The API version. Set the value to **1.0.0**.
        self.api_version = api_version  # type: str
        # The validity period of the playback credential. Unit: **seconds**. You cannot obtain the playback URL of a video by using a credential that has expired. A new credential is required.
        # 
        # *   Default value: **100**.
        # *   Valid values: `[100,3000]`.
        self.auth_info_timeout = auth_info_timeout  # type: long
        # The ID of the media file. You can specify only one ID. You can use one of the following methods to obtain the ID of the file:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the media file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of the VideoId parameter from the response to the [CreateUploadVideo](~~55407~~) operation.
        # *   Obtain the value of the VideoId parameter from the response to the [SearchMedia](~~86044~~) operation. This method is applicable to files that have been uploaded.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoPlayAuthRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['ApiVersion'] = self.api_version
        if self.auth_info_timeout is not None:
            result['AuthInfoTimeout'] = self.auth_info_timeout
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiVersion') is not None:
            self.api_version = m.get('ApiVersion')
        if m.get('AuthInfoTimeout') is not None:
            self.auth_info_timeout = m.get('AuthInfoTimeout')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoPlayAuthResponseBodyVideoMeta(TeaModel):
    def __init__(self, cover_url=None, duration=None, status=None, title=None, video_id=None):
        # The thumbnail URL of the media file.
        self.cover_url = cover_url  # type: str
        # The duration of the media file. Unit: seconds.
        self.duration = duration  # type: float
        # The status of the media file. For more information about the value range and description, see [Status: the status of a video](~~52839~~).
        self.status = status  # type: str
        # The title of the media file.
        self.title = title  # type: str
        # The ID of the media file.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoPlayAuthResponseBodyVideoMeta, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class GetVideoPlayAuthResponseBody(TeaModel):
    def __init__(self, play_auth=None, request_id=None, video_meta=None):
        # The credential for media playback.
        self.play_auth = play_auth  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The metadata of the media file.
        self.video_meta = video_meta  # type: GetVideoPlayAuthResponseBodyVideoMeta

    def validate(self):
        if self.video_meta:
            self.video_meta.validate()

    def to_map(self):
        _map = super(GetVideoPlayAuthResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.play_auth is not None:
            result['PlayAuth'] = self.play_auth
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.video_meta is not None:
            result['VideoMeta'] = self.video_meta.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PlayAuth') is not None:
            self.play_auth = m.get('PlayAuth')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VideoMeta') is not None:
            temp_model = GetVideoPlayAuthResponseBodyVideoMeta()
            self.video_meta = temp_model.from_map(m['VideoMeta'])
        return self


class GetVideoPlayAuthResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoPlayAuthResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoPlayAuthResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoPlayAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVodTemplateRequest(TeaModel):
    def __init__(self, vod_template_id=None):
        # The ID of the snapshot template.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVodTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class GetVodTemplateResponseBodyVodTemplateInfo(TeaModel):
    def __init__(self, creation_time=None, is_default=None, modify_time=None, name=None, template_config=None,
                 template_type=None, vod_template_id=None):
        # The time when the template was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template is the default one. Valid values:
        # 
        # *   **Default**: The template is the default one.
        # *   **NotDefault**: The template is not the default one.
        self.is_default = is_default  # type: str
        # The time when the template was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The name of the template.
        self.name = name  # type: str
        # The detailed configurations of the template. The value is a JSON-formatted string. For more information about the data structure, see the "SnapshotTemplateConfig" section of the [Media processing parameters](~~98618~~) topic.
        self.template_config = template_config  # type: str
        # The type of the template. Valid values:
        # 
        # *   **Snapshot**\
        # *   **DynamicImage**\
        self.template_type = template_type  # type: str
        # The ID of the template.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVodTemplateResponseBodyVodTemplateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class GetVodTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, vod_template_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the snapshot template.
        self.vod_template_info = vod_template_info  # type: GetVodTemplateResponseBodyVodTemplateInfo

    def validate(self):
        if self.vod_template_info:
            self.vod_template_info.validate()

    def to_map(self):
        _map = super(GetVodTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vod_template_info is not None:
            result['VodTemplateInfo'] = self.vod_template_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VodTemplateInfo') is not None:
            temp_model = GetVodTemplateResponseBodyVodTemplateInfo()
            self.vod_template_info = temp_model.from_map(m['VodTemplateInfo'])
        return self


class GetVodTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVodTemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVodTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVodTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWatermarkRequest(TeaModel):
    def __init__(self, watermark_id=None):
        # The ID of the watermark.
        self.watermark_id = watermark_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        return self


class GetWatermarkResponseBodyWatermarkInfo(TeaModel):
    def __init__(self, app_id=None, creation_time=None, file_url=None, is_default=None, name=None, type=None,
                 watermark_config=None, watermark_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The time when the watermark was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The Object Storage Service (OSS) URL or CDN URL of the watermark file. A text watermark does not have a file URL.
        self.file_url = file_url  # type: str
        # Indicates whether the watermark is the default one. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # The name of the watermark.
        self.name = name  # type: str
        # The type of the watermark. Valid values:
        # 
        # *   **Image**\
        # *   **Text**\
        self.type = type  # type: str
        # The configuration information such as the position and effect about the text watermark or image watermark. The value is a JSON string. For more information about the data structure, see the "WatermarkConfig: specifies the watermark configurations" section of the [Parameters for media processing](~~98618~~) topic.
        self.watermark_config = watermark_config  # type: str
        # The ID of the watermark.
        self.watermark_id = watermark_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetWatermarkResponseBodyWatermarkInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.watermark_config is not None:
            result['WatermarkConfig'] = self.watermark_config
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WatermarkConfig') is not None:
            self.watermark_config = m.get('WatermarkConfig')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        return self


class GetWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None, watermark_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the watermark.
        self.watermark_info = watermark_info  # type: GetWatermarkResponseBodyWatermarkInfo

    def validate(self):
        if self.watermark_info:
            self.watermark_info.validate()

    def to_map(self):
        _map = super(GetWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.watermark_info is not None:
            result['WatermarkInfo'] = self.watermark_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WatermarkInfo') is not None:
            temp_model = GetWatermarkResponseBodyWatermarkInfo()
            self.watermark_info = temp_model.from_map(m['WatermarkInfo'])
        return self


class GetWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetWatermarkResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAIImageInfoRequest(TeaModel):
    def __init__(self, video_id=None):
        # The ID of the video. You can use one of the following methods to obtain the ID:
        # 
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you call to upload media files.
        # *   Obtain the value of VideoId from the response to the [SearchMedia](~~86044~~) operation after you upload media files.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAIImageInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListAIImageInfoResponseBodyAIImageInfoList(TeaModel):
    def __init__(self, aiimage_info_id=None, creation_time=None, file_url=None, format=None, job_id=None, score=None,
                 version=None, video_id=None):
        # The ID of the image information.
        self.aiimage_info_id = aiimage_info_id  # type: str
        # The time when the file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The URL of the image file.
        self.file_url = file_url  # type: str
        # The format of the image. Valid values: **gif** and **png**.
        self.format = format  # type: str
        # The ID of the image AI processing job.
        self.job_id = job_id  # type: str
        # The score of the image.
        self.score = score  # type: str
        # The data version ID.
        self.version = version  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAIImageInfoResponseBodyAIImageInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiimage_info_id is not None:
            result['AIImageInfoId'] = self.aiimage_info_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.format is not None:
            result['Format'] = self.format
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.score is not None:
            result['Score'] = self.score
        if self.version is not None:
            result['Version'] = self.version
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIImageInfoId') is not None:
            self.aiimage_info_id = m.get('AIImageInfoId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListAIImageInfoResponseBody(TeaModel):
    def __init__(self, aiimage_info_list=None, request_id=None):
        # The image files that are uploaded for AI processing.
        self.aiimage_info_list = aiimage_info_list  # type: list[ListAIImageInfoResponseBodyAIImageInfoList]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aiimage_info_list:
            for k in self.aiimage_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAIImageInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AIImageInfoList'] = []
        if self.aiimage_info_list is not None:
            for k in self.aiimage_info_list:
                result['AIImageInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aiimage_info_list = []
        if m.get('AIImageInfoList') is not None:
            for k in m.get('AIImageInfoList'):
                temp_model = ListAIImageInfoResponseBodyAIImageInfoList()
                self.aiimage_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAIImageInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAIImageInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAIImageInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAIImageInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAIJobRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The list of job IDs. You can obtain the job ID from the PlayInfo parameter in the response to the [GetPlayInfo](~~56124~~) operation.
        # 
        # >  You can specify a maximum of 10 job IDs in a request. Separate multiple IDs with commas (,).
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAIJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListAIJobResponseBodyAIJobListAIJob(TeaModel):
    def __init__(self, code=None, complete_time=None, creation_time=None, data=None, job_id=None, media_id=None,
                 message=None, status=None, type=None):
        # The error code. This parameter is returned if the value of Status is fail.
        self.code = code  # type: str
        # The time when the job was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The returned data. The value is a JSON string. For more information, see [AITemplateConfig](~~89863~~).
        self.data = data  # type: str
        # The job ID.
        self.job_id = job_id  # type: str
        # The ID of the video file.
        self.media_id = media_id  # type: str
        # The error message. This parameter is returned if the value of Status is fail.
        self.message = message  # type: str
        # The status of the job. Valid values:
        # 
        # *   **success**: The job is successful.
        # *   **fail**: The job failed.
        # *   **init**: The job is being initialized.
        # *   **Processing**: The job is in progress.
        self.status = status  # type: str
        # The type of the job. Valid values:
        # 
        # *   **AIMediaDNA**: video fingerprinting
        # *   **AIVideoTag**: smart tagging
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAIJobResponseBodyAIJobListAIJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data is not None:
            result['Data'] = self.data
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAIJobResponseBodyAIJobList(TeaModel):
    def __init__(self, aijob=None):
        self.aijob = aijob  # type: list[ListAIJobResponseBodyAIJobListAIJob]

    def validate(self):
        if self.aijob:
            for k in self.aijob:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAIJobResponseBodyAIJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AIJob'] = []
        if self.aijob is not None:
            for k in self.aijob:
                result['AIJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aijob = []
        if m.get('AIJob') is not None:
            for k in m.get('AIJob'):
                temp_model = ListAIJobResponseBodyAIJobListAIJob()
                self.aijob.append(temp_model.from_map(k))
        return self


class ListAIJobResponseBodyNonExistAIJobIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAIJobResponseBodyNonExistAIJobIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class ListAIJobResponseBody(TeaModel):
    def __init__(self, aijob_list=None, non_exist_aijob_ids=None, request_id=None):
        # The list of jobs.
        self.aijob_list = aijob_list  # type: ListAIJobResponseBodyAIJobList
        # The IDs of the jobs that do not exist.
        self.non_exist_aijob_ids = non_exist_aijob_ids  # type: ListAIJobResponseBodyNonExistAIJobIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aijob_list:
            self.aijob_list.validate()
        if self.non_exist_aijob_ids:
            self.non_exist_aijob_ids.validate()

    def to_map(self):
        _map = super(ListAIJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aijob_list is not None:
            result['AIJobList'] = self.aijob_list.to_map()
        if self.non_exist_aijob_ids is not None:
            result['NonExistAIJobIds'] = self.non_exist_aijob_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AIJobList') is not None:
            temp_model = ListAIJobResponseBodyAIJobList()
            self.aijob_list = temp_model.from_map(m['AIJobList'])
        if m.get('NonExistAIJobIds') is not None:
            temp_model = ListAIJobResponseBodyNonExistAIJobIds()
            self.non_exist_aijob_ids = temp_model.from_map(m['NonExistAIJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAIJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAIJobResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAIJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAIJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAITemplateRequest(TeaModel):
    def __init__(self, template_type=None):
        # The type of the AI template. Valid values:
        # 
        # *   **AIMediaAudit**: automated review
        # *   **AIImage**: smart thumbnail
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAITemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class ListAITemplateResponseBodyTemplateInfoList(TeaModel):
    def __init__(self, creation_time=None, is_default=None, modify_time=None, source=None, template_config=None,
                 template_id=None, template_name=None, template_type=None):
        # The time when the AI template was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template is the default AI template. Valid values:
        # 
        # *   **Default**\
        # *   **NotDefault**\
        self.is_default = is_default  # type: str
        # The time when the AI template was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The source of the AI template. Valid values:
        # 
        # *   **System**\
        # *   **Custom**\
        self.source = source  # type: str
        # The detailed configurations of the AI template. The value is a JSON string. For more information, see [AITemplateConfig](~~89863#title-vd3-499-o36~~).
        self.template_config = template_config  # type: str
        # The ID of the AI template.
        self.template_id = template_id  # type: str
        # The name of the AI template.
        self.template_name = template_name  # type: str
        # The type of the AI template. Valid values:
        # 
        # *   **AIMediaAudit**: automated review
        # *   **AIImage**: smart thumbnail
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAITemplateResponseBodyTemplateInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.source is not None:
            result['Source'] = self.source
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class ListAITemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_info_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the AI templates.
        self.template_info_list = template_info_list  # type: list[ListAITemplateResponseBodyTemplateInfoList]

    def validate(self):
        if self.template_info_list:
            for k in self.template_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAITemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TemplateInfoList'] = []
        if self.template_info_list is not None:
            for k in self.template_info_list:
                result['TemplateInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.template_info_list = []
        if m.get('TemplateInfoList') is not None:
            for k in m.get('TemplateInfoList'):
                temp_model = ListAITemplateResponseBodyTemplateInfoList()
                self.template_info_list.append(temp_model.from_map(k))
        return self


class ListAITemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAITemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAITemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAITemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAppInfoRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, status=None):
        # The number of the page to return. By default, pages start from page 1.
        self.page_no = page_no  # type: int
        # The number of entries to return on each page. Default value: **10**. Maximum value: **100**.
        self.page_size = page_size  # type: int
        # The status of the application. After an application is created, it enters the **Normal** state. Valid values:
        # 
        # *   **Normal**\
        # *   **Disable**\
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAppInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAppInfoResponseBodyAppInfoList(TeaModel):
    def __init__(self, app_id=None, app_name=None, creation_time=None, description=None, modification_time=None,
                 status=None, type=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The name of the application.
        self.app_name = app_name  # type: str
        # The time when the application was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the application.
        self.description = description  # type: str
        # The last time when the application was modified. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The status of the application. Valid values:
        # 
        # *   **Normal**\
        # *   **Disable**\
        self.status = status  # type: str
        # The type of the application. Valid values:
        # 
        # *   **System**\
        # *   **Custom**\
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAppInfoResponseBodyAppInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAppInfoResponseBody(TeaModel):
    def __init__(self, app_info_list=None, request_id=None, total=None):
        # The details of each application.
        self.app_info_list = app_info_list  # type: list[ListAppInfoResponseBodyAppInfoList]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total = total  # type: int

    def validate(self):
        if self.app_info_list:
            for k in self.app_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAppInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AppInfoList'] = []
        if self.app_info_list is not None:
            for k in self.app_info_list:
                result['AppInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.app_info_list = []
        if m.get('AppInfoList') is not None:
            for k in m.get('AppInfoList'):
                temp_model = ListAppInfoResponseBodyAppInfoList()
                self.app_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListAppInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAppInfoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAppInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAppInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAppPoliciesForIdentityRequest(TeaModel):
    def __init__(self, app_id=None, identity_name=None, identity_type=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The name of the identity.
        # 
        # *   Specifies the ID of the RAM user when the IdentityType parameter is set to RamUser.
        # *   Specifies the name of the RAM role when the IdentityType parameter is set to RamRole.
        self.identity_name = identity_name  # type: str
        # The type of the identity. Valid values:
        # 
        # *   **RamUser**: a RAM user.
        # *   **RamRole**: a RAM role.
        self.identity_type = identity_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAppPoliciesForIdentityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.identity_name is not None:
            result['IdentityName'] = self.identity_name
        if self.identity_type is not None:
            result['IdentityType'] = self.identity_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('IdentityName') is not None:
            self.identity_name = m.get('IdentityName')
        if m.get('IdentityType') is not None:
            self.identity_type = m.get('IdentityType')
        return self


class ListAppPoliciesForIdentityResponseBodyAppPolicyList(TeaModel):
    def __init__(self, app_id=None, creation_time=None, description=None, modification_time=None, policy_name=None,
                 policy_type=None, policy_value=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The time when the application policy was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the policy.
        self.description = description  # type: str
        # The last time when the application policy was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The name of the policy.
        self.policy_name = policy_name  # type: str
        # The type of the policy. Valid values:
        # 
        # *   **System**\
        # *   **Custom**\
        self.policy_type = policy_type  # type: str
        # The content of the policy.
        self.policy_value = policy_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAppPoliciesForIdentityResponseBodyAppPolicyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.policy_value is not None:
            result['PolicyValue'] = self.policy_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('PolicyValue') is not None:
            self.policy_value = m.get('PolicyValue')
        return self


class ListAppPoliciesForIdentityResponseBody(TeaModel):
    def __init__(self, app_policy_list=None, request_id=None):
        # The details of each policy.
        # 
        # > A maximum of 100 entries can be returned.
        self.app_policy_list = app_policy_list  # type: list[ListAppPoliciesForIdentityResponseBodyAppPolicyList]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.app_policy_list:
            for k in self.app_policy_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAppPoliciesForIdentityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AppPolicyList'] = []
        if self.app_policy_list is not None:
            for k in self.app_policy_list:
                result['AppPolicyList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.app_policy_list = []
        if m.get('AppPolicyList') is not None:
            for k in m.get('AppPolicyList'):
                temp_model = ListAppPoliciesForIdentityResponseBodyAppPolicyList()
                self.app_policy_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAppPoliciesForIdentityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAppPoliciesForIdentityResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAppPoliciesForIdentityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAppPoliciesForIdentityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAuditSecurityIpRequest(TeaModel):
    def __init__(self, security_group_name=None):
        # The name of the review security group in which you want to query IP addresses. If you do not specify this parameter, IP addresses in all review security groups are queried.
        self.security_group_name = security_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAuditSecurityIpRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        return self


class ListAuditSecurityIpResponseBodySecurityIpList(TeaModel):
    def __init__(self, creation_time=None, ips=None, modification_time=None, security_group_name=None):
        # The time when the review security group was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The IP addresses in the review security group.
        self.ips = ips  # type: str
        # The time when the review security group was last modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modification_time = modification_time  # type: str
        # The name of the review security group.
        self.security_group_name = security_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAuditSecurityIpResponseBodySecurityIpList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.ips is not None:
            result['Ips'] = self.ips
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Ips') is not None:
            self.ips = m.get('Ips')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        return self


class ListAuditSecurityIpResponseBody(TeaModel):
    def __init__(self, request_id=None, security_ip_list=None):
        # The request ID.
        self.request_id = request_id  # type: str
        # The details of the review security group.
        self.security_ip_list = security_ip_list  # type: list[ListAuditSecurityIpResponseBodySecurityIpList]

    def validate(self):
        if self.security_ip_list:
            for k in self.security_ip_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAuditSecurityIpResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityIpList'] = []
        if self.security_ip_list is not None:
            for k in self.security_ip_list:
                result['SecurityIpList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_ip_list = []
        if m.get('SecurityIpList') is not None:
            for k in m.get('SecurityIpList'):
                temp_model = ListAuditSecurityIpResponseBodySecurityIpList()
                self.security_ip_list.append(temp_model.from_map(k))
        return self


class ListAuditSecurityIpResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAuditSecurityIpResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAuditSecurityIpResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAuditSecurityIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicImageRequest(TeaModel):
    def __init__(self, video_id=None):
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDynamicImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListDynamicImageResponseBodyDynamicImageList(TeaModel):
    def __init__(self, creation_time=None, duration=None, dynamic_image_id=None, file_size=None, file_url=None,
                 format=None, fps=None, height=None, job_id=None, video_id=None, width=None):
        # The time when the animated sticker was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The duration of the animated sticker. Unit: seconds.
        self.duration = duration  # type: str
        # The ID of the animated sticker.
        self.dynamic_image_id = dynamic_image_id  # type: str
        # The size of the animated sticker file. Unit: byte.
        self.file_size = file_size  # type: str
        # The URL of the animated sticker file.
        self.file_url = file_url  # type: str
        # The format of the animated sticker. Valid values: gif and webp.
        self.format = format  # type: str
        # The frame rate of the animated sticker. Unit: frames per second.
        self.fps = fps  # type: str
        # The height of the animated sticker. Unit: pixel.
        self.height = height  # type: str
        # The job ID for creating the animated sticker.
        self.job_id = job_id  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str
        # The width of the animated sticker. Unit: pixel.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDynamicImageResponseBodyDynamicImageList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.dynamic_image_id is not None:
            result['DynamicImageId'] = self.dynamic_image_id
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('DynamicImageId') is not None:
            self.dynamic_image_id = m.get('DynamicImageId')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListDynamicImageResponseBody(TeaModel):
    def __init__(self, dynamic_image_list=None, request_id=None):
        # The list of animated stickers.
        self.dynamic_image_list = dynamic_image_list  # type: list[ListDynamicImageResponseBodyDynamicImageList]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dynamic_image_list:
            for k in self.dynamic_image_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDynamicImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DynamicImageList'] = []
        if self.dynamic_image_list is not None:
            for k in self.dynamic_image_list:
                result['DynamicImageList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dynamic_image_list = []
        if m.get('DynamicImageList') is not None:
            for k in m.get('DynamicImageList'):
                temp_model = ListDynamicImageResponseBodyDynamicImageList()
                self.dynamic_image_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDynamicImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDynamicImageResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDynamicImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRecordVideoRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, page_no=None, page_size=None, sort_by=None,
                 start_time=None, stream_name=None):
        # The name of the application that was used to record the live stream.
        self.app_name = app_name  # type: str
        # The domain name of the recorded live stream.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The query is performed based on the time range during which the required live streams were recorded. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The number of the page to return. Default value: **1**.
        self.page_no = page_no  # type: int
        # The number of entries to return on each page. Maximum value: **100**. Default value: **10**.
        self.page_size = page_size  # type: int
        # The sorting rule of results. Valid values:
        # *   **CreationTime:Desc**: sorts the results based on the creation time in descending order. This is the default value.
        # *   **CreationTime:Asc**: sorts the results based on the creation time in ascending order.
        self.sort_by = sort_by  # type: str
        # The beginning of the time range to query. The query is performed based on the time range during which the required live streams were recorded. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The name of the recorded live stream.
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordVideoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideoSnapshots(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideoSnapshots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.snapshot is not None:
            result['Snapshot'] = self.snapshot
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Snapshot') is not None:
            self.snapshot = m.get('Snapshot')
        return self


class ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideo(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, cover_url=None, creation_time=None, description=None,
                 duration=None, modify_time=None, size=None, snapshots=None, status=None, tags=None, template_group_id=None,
                 title=None, video_id=None):
        # The ID of the video category.
        self.cate_id = cate_id  # type: int
        # The name of the video category.
        self.cate_name = cate_name  # type: str
        # The thumbnail URL of the video.
        self.cover_url = cover_url  # type: str
        # The time when the video was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the video.
        self.description = description  # type: str
        # The duration of the video. Unit: seconds.
        self.duration = duration  # type: float
        # The last time when the video was updated. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The size of the mezzanine file. Unit: byte.
        self.size = size  # type: long
        # The array of video snapshot URLs.
        self.snapshots = snapshots  # type: ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideoSnapshots
        # The status of the video. Valid values:
        # *   **Uploading:**: indicates that the video is being uploaded.
        # *   **UploadFail**: indicates that the video failed to be uploaded.
        # *   **UploadSucces**: indicates that the video was uploaded.
        # *   **Transcoding**: indicates that the video is being transcoded.
        # *   **TranscodeFail**: indicates that the video failed to be transcoded.
        # *   **Blocked**: indicates that the video is blocked.
        # *   **Normal**: indicates that the video is in a normal state.
        self.status = status  # type: str
        # The tags of the video. Separate multiple tags with commas (,).
        self.tags = tags  # type: str
        # The ID of the transcoding template group.
        self.template_group_id = template_group_id  # type: str
        # The title of the video.
        self.title = title  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        if self.snapshots:
            self.snapshots.validate()

    def to_map(self):
        _map = super(ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.template_group_id is not None:
            result['TemplateGroupId'] = self.template_group_id
        if self.title is not None:
            result['Title'] = self.title
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Snapshots') is not None:
            temp_model = ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideoSnapshots()
            self.snapshots = temp_model.from_map(m['Snapshots'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TemplateGroupId') is not None:
            self.template_group_id = m.get('TemplateGroupId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideo(TeaModel):
    def __init__(self, app_name=None, domain_name=None, playlist_id=None, record_end_time=None,
                 record_start_time=None, stream_name=None, video=None):
        # The name of the application.
        self.app_name = app_name  # type: str
        # The domain name.
        self.domain_name = domain_name  # type: str
        # The ID of the playlist.
        self.playlist_id = playlist_id  # type: str
        # The end of the time range in which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.record_end_time = record_end_time  # type: str
        # The beginning of the time range in which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.record_start_time = record_start_time  # type: str
        # The name of the live stream.
        self.stream_name = stream_name  # type: str
        # The information about the video.
        self.video = video  # type: ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideo

    def validate(self):
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.playlist_id is not None:
            result['PlaylistId'] = self.playlist_id
        if self.record_end_time is not None:
            result['RecordEndTime'] = self.record_end_time
        if self.record_start_time is not None:
            result['RecordStartTime'] = self.record_start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PlaylistId') is not None:
            self.playlist_id = m.get('PlaylistId')
        if m.get('RecordEndTime') is not None:
            self.record_end_time = m.get('RecordEndTime')
        if m.get('RecordStartTime') is not None:
            self.record_start_time = m.get('RecordStartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Video') is not None:
            temp_model = ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideoVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class ListLiveRecordVideoResponseBodyLiveRecordVideoList(TeaModel):
    def __init__(self, live_record_video=None):
        self.live_record_video = live_record_video  # type: list[ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideo]

    def validate(self):
        if self.live_record_video:
            for k in self.live_record_video:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveRecordVideoResponseBodyLiveRecordVideoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveRecordVideo'] = []
        if self.live_record_video is not None:
            for k in self.live_record_video:
                result['LiveRecordVideo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_record_video = []
        if m.get('LiveRecordVideo') is not None:
            for k in m.get('LiveRecordVideo'):
                temp_model = ListLiveRecordVideoResponseBodyLiveRecordVideoListLiveRecordVideo()
                self.live_record_video.append(temp_model.from_map(k))
        return self


class ListLiveRecordVideoResponseBody(TeaModel):
    def __init__(self, live_record_video_list=None, request_id=None, total=None):
        # The list of videos.
        self.live_record_video_list = live_record_video_list  # type: ListLiveRecordVideoResponseBodyLiveRecordVideoList
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of videos returned.
        self.total = total  # type: int

    def validate(self):
        if self.live_record_video_list:
            self.live_record_video_list.validate()

    def to_map(self):
        _map = super(ListLiveRecordVideoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_record_video_list is not None:
            result['LiveRecordVideoList'] = self.live_record_video_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveRecordVideoList') is not None:
            temp_model = ListLiveRecordVideoResponseBodyLiveRecordVideoList()
            self.live_record_video_list = temp_model.from_map(m['LiveRecordVideoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListLiveRecordVideoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveRecordVideoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveRecordVideoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveRecordVideoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSnapshotsRequest(TeaModel):
    def __init__(self, auth_timeout=None, page_no=None, page_size=None, snapshot_type=None, video_id=None):
        # The validity period of the snapshot URL. Unit: seconds. Default value: **3600**. Minimum value: **3600**.
        # 
        # *   This parameter only takes effect when [URL authentication](~~57007~~) is enabled.
        # *   If the specified validity period is less than **3600** seconds, the default value is **3600**.
        # *   If an Object Storage Service (OSS) URL is returned, the maximum validity period is limited to **2592000** seconds (30 days) to reduce security risks of the origin.
        self.auth_timeout = auth_timeout  # type: str
        # The number of the page to turn. Default value: **1**.
        self.page_no = page_no  # type: str
        # The number of entries to return on each page. Default value: **20**. Maximum value: **100**.
        self.page_size = page_size  # type: str
        # The type of snapshots that are returned. Valid values:
        # 
        # *   **CoverSnapshot**: thumbnail snapshot
        # *   **NormalSnapshot**: normal snapshot
        # *   **SpriteSnapshot**: sprite snapshot
        # *   **SpriteOriginSnapshot**: sprite source snapshot
        # *   **WebVttSnapshot**: WebVTT snapshot
        self.snapshot_type = snapshot_type  # type: str
        # The ID of the video.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSnapshotsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.snapshot_type is not None:
            result['SnapshotType'] = self.snapshot_type
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SnapshotType') is not None:
            self.snapshot_type = m.get('SnapshotType')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListSnapshotsResponseBodyMediaSnapshotSnapshotsSnapshot(TeaModel):
    def __init__(self, index=None, url=None):
        # The index of the snapshot.
        self.index = index  # type: long
        # The URL of the snapshot.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSnapshotsResponseBodyMediaSnapshotSnapshotsSnapshot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListSnapshotsResponseBodyMediaSnapshotSnapshots(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[ListSnapshotsResponseBodyMediaSnapshotSnapshotsSnapshot]

    def validate(self):
        if self.snapshot:
            for k in self.snapshot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSnapshotsResponseBodyMediaSnapshotSnapshots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Snapshot'] = []
        if self.snapshot is not None:
            for k in self.snapshot:
                result['Snapshot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.snapshot = []
        if m.get('Snapshot') is not None:
            for k in m.get('Snapshot'):
                temp_model = ListSnapshotsResponseBodyMediaSnapshotSnapshotsSnapshot()
                self.snapshot.append(temp_model.from_map(k))
        return self


class ListSnapshotsResponseBodyMediaSnapshot(TeaModel):
    def __init__(self, creation_time=None, job_id=None, regular=None, snapshots=None, total=None):
        # The time when the snapshot job was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The ID of the snapshot job.
        self.job_id = job_id  # type: str
        # The rule for generating snapshot URLs.
        self.regular = regular  # type: str
        # The snapshot data.
        self.snapshots = snapshots  # type: ListSnapshotsResponseBodyMediaSnapshotSnapshots
        # The total number of snapshots.
        self.total = total  # type: long

    def validate(self):
        if self.snapshots:
            self.snapshots.validate()

    def to_map(self):
        _map = super(ListSnapshotsResponseBodyMediaSnapshot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.regular is not None:
            result['Regular'] = self.regular
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Regular') is not None:
            self.regular = m.get('Regular')
        if m.get('Snapshots') is not None:
            temp_model = ListSnapshotsResponseBodyMediaSnapshotSnapshots()
            self.snapshots = temp_model.from_map(m['Snapshots'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSnapshotsResponseBody(TeaModel):
    def __init__(self, media_snapshot=None, request_id=None):
        # The snapshot data of the media.
        self.media_snapshot = media_snapshot  # type: ListSnapshotsResponseBodyMediaSnapshot
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_snapshot:
            self.media_snapshot.validate()

    def to_map(self):
        _map = super(ListSnapshotsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_snapshot is not None:
            result['MediaSnapshot'] = self.media_snapshot.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaSnapshot') is not None:
            temp_model = ListSnapshotsResponseBodyMediaSnapshot()
            self.media_snapshot = temp_model.from_map(m['MediaSnapshot'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSnapshotsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListSnapshotsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSnapshotsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSnapshotsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTranscodeTaskRequest(TeaModel):
    def __init__(self, end_time=None, page_no=None, page_size=None, start_time=None, video_id=None):
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The number of the page to return. You can specify a page number to return data from the specified page. Default value: **1**.
        self.page_no = page_no  # type: int
        # The number of entries to return on each page. Maximum value: **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The ID of the audio or video file. You can use one of the following methods to obtain the ID of the file:
        # *   Log on to the [ApsaraVideo VOD](https://vod.console.aliyun.com) console. In the left-side navigation pane, choose **Media Files** > **Audio/Video**. On the Video and Audio page, view the ID of the audio or video file. This method is applicable to files that are uploaded by using the ApsaraVideo VOD console.
        # *   Obtain the value of VideoId from the response to the [CreateUploadVideo](~~55407~~) operation that you call to obtain the upload URL and credential.
        # *   Obtain the value of VideoId by calling the [SearchMedia](~~86044~~) operation. This method is applicable to files that have been uploaded.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListTranscodeTaskResponseBodyTranscodeTaskList(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, task_status=None, transcode_task_id=None,
                 transcode_template_group_id=None, trigger=None, video_id=None):
        # The time when the transcoding task was complete. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.complete_time = complete_time  # type: str
        # The time when the transcoding task was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The status of the transcoding task. Valid values:
        # *   **Processing**: In progress.
        # *   **Partial**: Some transcoding jobs were complete.
        # *   **CompleteAllSucc**: All transcoding jobs were successful.
        # *   **CompleteAllFail**: All transcoding jobs failed. If an exception occurs in the source file, no transcoding job is initiated and the transcoding task fails.
        # *   **CompletePartialSucc**: All transcoding jobs were complete but only some were successful.
        self.task_status = task_status  # type: str
        # The ID of the transcoding task.
        self.transcode_task_id = transcode_task_id  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str
        # The mode in which the transcoding task is triggered. Valid values:
        # *   **Auto**: The transcoding task is automatically triggered when the video is uploaded.
        # *   **Manual**: The transcoding task is triggered by calling the SubmitTranscodeJobs operation.
        self.trigger = trigger  # type: str
        # The ID of the audio or video file.
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeTaskResponseBodyTranscodeTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.transcode_task_id is not None:
            result['TranscodeTaskId'] = self.transcode_task_id
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        if self.trigger is not None:
            result['Trigger'] = self.trigger
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TranscodeTaskId') is not None:
            self.transcode_task_id = m.get('TranscodeTaskId')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        if m.get('Trigger') is not None:
            self.trigger = m.get('Trigger')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class ListTranscodeTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_task_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Details about transcoding tasks.
        self.transcode_task_list = transcode_task_list  # type: list[ListTranscodeTaskResponseBodyTranscodeTaskList]

    def validate(self):
        if self.transcode_task_list:
            for k in self.transcode_task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTranscodeTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TranscodeTaskList'] = []
        if self.transcode_task_list is not None:
            for k in self.transcode_task_list:
                result['TranscodeTaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.transcode_task_list = []
        if m.get('TranscodeTaskList') is not None:
            for k in m.get('TranscodeTaskList'):
                temp_model = ListTranscodeTaskResponseBodyTranscodeTaskList()
                self.transcode_task_list.append(temp_model.from_map(k))
        return self


class ListTranscodeTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTranscodeTaskResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTranscodeTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTranscodeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTranscodeTemplateGroupRequest(TeaModel):
    def __init__(self, app_id=None):
        # The ID of the application. Default value: **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeTemplateGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class ListTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupList(TeaModel):
    def __init__(self, app_id=None, creation_time=None, is_default=None, locked=None, modify_time=None, name=None,
                 transcode_template_group_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The time when the template group was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template group is the default one. Valid values:
        # 
        # *   **Default**: The template group is the default one.
        # *   **NotDefault**: The template group is not the default one.
        self.is_default = is_default  # type: str
        # The lock status of the transcoding template group. Valid values:
        # 
        # *   **Disabled**: The template group is not locked.
        # *   **Enabled**: The template group is locked.
        self.locked = locked  # type: str
        # The time when the template group was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The name of the template group.
        self.name = name  # type: str
        # The ID of the transcoding template group.
        self.transcode_template_group_id = transcode_template_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.locked is not None:
            result['Locked'] = self.locked
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.transcode_template_group_id is not None:
            result['TranscodeTemplateGroupId'] = self.transcode_template_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Locked') is not None:
            self.locked = m.get('Locked')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TranscodeTemplateGroupId') is not None:
            self.transcode_template_group_id = m.get('TranscodeTemplateGroupId')
        return self


class ListTranscodeTemplateGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_template_group_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The transcoding template groups.
        self.transcode_template_group_list = transcode_template_group_list  # type: list[ListTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupList]

    def validate(self):
        if self.transcode_template_group_list:
            for k in self.transcode_template_group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTranscodeTemplateGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TranscodeTemplateGroupList'] = []
        if self.transcode_template_group_list is not None:
            for k in self.transcode_template_group_list:
                result['TranscodeTemplateGroupList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.transcode_template_group_list = []
        if m.get('TranscodeTemplateGroupList') is not None:
            for k in m.get('TranscodeTemplateGroupList'):
                temp_model = ListTranscodeTemplateGroupResponseBodyTranscodeTemplateGroupList()
                self.transcode_template_group_list.append(temp_model.from_map(k))
        return self


class ListTranscodeTemplateGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTranscodeTemplateGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTranscodeTemplateGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTranscodeTemplateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListVodTemplateRequest(TeaModel):
    def __init__(self, app_id=None, template_type=None):
        # The ID of the application. Set the value to **app-1000000**. For more information, see [Overview](~~113600~~).
        self.app_id = app_id  # type: str
        # The type of the template. Set the value to **Snapshot**.
        self.template_type = template_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVodTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class ListVodTemplateResponseBodyVodTemplateInfoList(TeaModel):
    def __init__(self, app_id=None, creation_time=None, is_default=None, modify_time=None, name=None,
                 template_config=None, template_type=None, vod_template_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The time when the template was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # Indicates whether the template is the default one. Valid values:
        # 
        # *   **Default**: The template is the default one.
        # *   **NotDefault**: The template is not the default one.
        self.is_default = is_default  # type: str
        # The time when the template was modified. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.modify_time = modify_time  # type: str
        # The name of the template.
        self.name = name  # type: str
        # The detailed configurations of the template. The value is a JSON-formatted string. For more information about the data structure, see the "SnapshotTemplateConfig" section of the [Media processing parameters](~~98618~~) topic.
        self.template_config = template_config  # type: str
        # The type of the template. Valid values:
        # 
        # *   **Snapshot**\
        # *   **DynamicImage**\
        self.template_type = template_type  # type: str
        # The ID of the template.
        self.vod_template_id = vod_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVodTemplateResponseBodyVodTemplateInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.vod_template_id is not None:
            result['VodTemplateId'] = self.vod_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VodTemplateId') is not None:
            self.vod_template_id = m.get('VodTemplateId')
        return self


class ListVodTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, vod_template_info_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The snapshot templates.
        self.vod_template_info_list = vod_template_info_list  # type: list[ListVodTemplateResponseBodyVodTemplateInfoList]

    def validate(self):
        if self.vod_template_info_list:
            for k in self.vod_template_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListVodTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VodTemplateInfoList'] = []
        if self.vod_template_info_list is not None:
            for k in self.vod_template_info_list:
                result['VodTemplateInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vod_template_info_list = []
        if m.get('VodTemplateInfoList') is not None:
            for k in m.get('VodTemplateInfoList'):
                temp_model = ListVodTemplateResponseBodyVodTemplateInfoList()
                self.vod_template_info_list.append(temp_model.from_map(k))
        return self


class ListVodTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListVodTemplateResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListVodTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListVodTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListWatermarkRequest(TeaModel):
    def __init__(self, app_id=None):
        self.app_id = app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class ListWatermarkResponseBodyWatermarkInfos(TeaModel):
    def __init__(self, app_id=None, creation_time=None, file_url=None, is_default=None, name=None, type=None,
                 watermark_config=None, watermark_id=None):
        self.app_id = app_id  # type: str
        self.creation_time = creation_time  # type: str
        self.file_url = file_url  # type: str
        self.is_default = is_default  # type: str
        self.name = name  # type: str
        self.type = type  # type: str
        self.watermark_config = watermark_config  # type: str
        self.watermark_id = watermark_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListWatermarkResponseBodyWatermarkInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.watermark_config is not None:
            result['WatermarkConfig'] = self.watermark_config
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WatermarkConfig') is not None:
            self.watermark_config = m.get('WatermarkConfig')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        return self


class ListWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None, watermark_infos=None):
        self.request_id = request_id  # type: str
        self.watermark_infos = watermark_infos  # type: list[ListWatermarkResponseBodyWatermarkInfos]

    def validate(self):
        if self.watermark_infos:
            for k in self.watermark_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['WatermarkInfos'] = []
        if self.watermark_infos is not None:
            for k in self.watermark_infos:
                result['WatermarkInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.watermark_infos = []
        if m.get('WatermarkInfos') is not None:
            for k in m.get('WatermarkInfos'):
                temp_model = ListWatermarkResponseBodyWatermarkInfos()
                self.watermark_infos.append(temp_model.from_map(k))
        return self


class ListWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListWatermarkResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MoveAppResourceRequest(TeaModel):
    def __init__(self, resource_ids=None, resource_type=None, target_app_id=None):
        # The resource ID. You can specify a maximum of 20 IDs at a time. Separate multiple IDs with commas (,).
        self.resource_ids = resource_ids  # type: str
        # The resource type. Valid values:
        # 
        # *   **video**: video files.
        # *   **image**: image files.
        # *   **attached**: auxiliary media assets.
        self.resource_type = resource_type  # type: str
        # The ID of the application to which resources are migrated. Default value: **app-1000000**. For more information, see [Use the multi-application service](~~113600~~).
        self.target_app_id = target_app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MoveAppResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.target_app_id is not None:
            result['TargetAppId'] = self.target_app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TargetAppId') is not None:
            self.target_app_id = m.get('TargetAppId')
        return self


class MoveAppResourceResponseBody(TeaModel):
    def __init__(self, failed_resource_ids=None, non_exist_resource_ids=None, request_id=None):
        # The IDs of the resources that failed to be migrated.
        self.failed_resource_ids = failed_resource_ids  # type: list[str]
        # The IDs of the resources that were not found.
        self.non_exist_resource_ids = non_exist_resource_ids  # type: list[str]
        # The request ID.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MoveAppResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_resource_ids is not None:
            result['FailedResourceIds'] = self.failed_resource_ids
        if self.non_exist_resource_ids is not None:
            result['NonExistResourceIds'] = self.non_exist_resource_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedResourceIds') is not None:
            self.failed_resource_ids = m.get('FailedResourceIds')
        if m.get('NonExistResourceIds') is not None:
            self.non_exist_resource_ids = m.get('NonExistResourceIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MoveAppResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: MoveAppResourceResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MoveAppResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MoveAppResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PreloadVodObjectCachesRequest(TeaModel):
    def __init__(self, object_path=None, owner_id=None, security_token=None):
        # The URL of the file to be prefetched. Separate multiple URLs with line breaks (\n or \r\n).
        self.object_path = object_path  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreloadVodObjectCachesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class PreloadVodObjectCachesResponseBody(TeaModel):
    def __init__(self, preload_task_id=None, request_id=None):
        # The ID of the prefetch task. Separate multiple task IDs with commas (,).
        self.preload_task_id = preload_task_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreloadVodObjectCachesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_task_id is not None:
            result['PreloadTaskId'] = self.preload_task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreloadTaskId') is not None:
            self.preload_task_id = m.get('PreloadTaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PreloadVodObjectCachesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: PreloadVodObjectCachesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PreloadVodObjectCachesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    de