# Generated by Django 3.1.3 on 2020-11-08 16:14

import django.contrib.sites.managers
import django.db.models.deletion
from django.db import migrations, models

import aleksis.apps.csv_import.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("sites", "0002_alter_domain_unique"),
        ("core", "0003_drop_image_cropping"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImportTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                (
                    "name",
                    models.CharField(max_length=255, unique=True, verbose_name="Name"),
                ),
                ("verbose_name", models.CharField(max_length=255, verbose_name="Name")),
                (
                    "has_header_row",
                    models.BooleanField(
                        default=True, verbose_name="Has the CSV file an own header row?"
                    ),
                ),
                (
                    "separator",
                    models.CharField(
                        default=",",
                        help_text="For whitespace use \\\\s+, for tab \\\\t",
                        max_length=255,
                        verbose_name="CSV separator",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=aleksis.apps.csv_import.models.get_allowed_content_types_query,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                        verbose_name="Content type",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        blank=True,
                        help_text="If imported objects are persons, they all will be members of this group after import.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="core.group",
                        verbose_name="Base group",
                    ),
                ),
                (
                    "group_type",
                    models.ForeignKey(
                        blank=True,
                        help_text="If imported objects are groups, they all will get this group type after import.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="core.grouptype",
                        verbose_name="Gruppentyp",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        default=1,
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Import template",
                "verbose_name_plural": "Import templates",
                "ordering": ["name"],
            },
            managers=[("objects", django.contrib.sites.managers.CurrentSiteManager()),],
        ),
        migrations.CreateModel(
            name="ImportTemplateField",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                ("index", models.IntegerField(verbose_name="Index")),
                (
                    "field_type",
                    models.CharField(
                        choices=[
                            ("unique_reference", "Unique reference"),
                            ("is_active", "Is active? (0/1)"),
                            ("name", "Name"),
                            ("first_name", "Vorname"),
                            ("last_name", "Nachname"),
                            ("additional_name", "Additional name"),
                            ("short_name", "Kurzname"),
                            ("email", "E-Mail-Adresse"),
                            ("date_of_birth", "Geburtsdatum"),
                            ("sex", "Geschlecht"),
                            ("street", "Straße"),
                            ("housenumber", "Housenumber"),
                            ("postal_code", "Postleitzahl"),
                            ("place", "Ort"),
                            ("phone_number", "Telefonnummer"),
                            ("mobile_number", "Mobile number"),
                            ("ignore", "Ignore data in this field"),
                            ("departments", "Comma-seperated list of departments"),
                            ("group_subject_short_name", "Short name of the subject"),
                            ("class_range", "Class range (e. g. 7a-d)"),
                            (
                                "primary_group_short_name",
                                "Short name of the person's primary group",
                            ),
                            (
                                "group_owner_short_name",
                                "Short name of a single group owner",
                            ),
                            (
                                "group_membership_short_name",
                                "Short name of the group the person is a member of",
                            ),
                            (
                                "child_by_unique_reference",
                                "Child by unique reference (from students import)",
                            ),
                        ],
                        max_length=255,
                        verbose_name="Field type",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        default=1,
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fields",
                        to="csv_import.importtemplate",
                        verbose_name="Import template",
                    ),
                ),
            ],
            options={
                "verbose_name": "Import template field",
                "verbose_name_plural": "Import template fields",
                "ordering": ["template", "index"],
                "unique_together": {("template", "index")},
            },
            managers=[("objects", django.contrib.sites.managers.CurrentSiteManager()),],
        ),
    ]
