# dbt Connector

This connector extracts technical metadata from a [dbt project](https://docs.getdbt.com/docs/building-a-dbt-project/projects) by parsing the `manifest.json` & `catalog.json` files generated by `dbt docs generate` or `dbt run`command.

## Setup

There is no special setup needed to run the connector as a CLI. However, we recommend running it as part of your dbt project's CI/CD workflow so that the metadata is refreshed automatically with each commit. Please refer to [Metaphor dbt GitHub Action](https://github.com/MetaphorData/dbt-action) for more details.

The remaining sections are for those who intend to run the connector manually as a CLI or to integrate it into a different CI/CD environment.

## Config File

Create a YAML config file based the following template.

# Required Configurations

```yaml
manifest: <path_to_manifest_json>
catalog: <path_to_catalog_json>
account: <snowflake_account>
output:
  file:
    directory: <output_directory>
```

See [Common Configurations](../common/README.md) for more information on `output`.

# Optional Configurations

You can optionally provide the `docsBaseUrl` (base URL serving the dbt generated docs) and `projectSourceUrl` (source code URL pointing to the project root directory). Those will help us to generate links to a model's docs and source code.

```yaml
docsBaseUrl: <docs_base_url>
projectSourceUrl: <project_dir_source_code_url>
```

## Testing

Follow the [Installation](../../README.md) instructions to install `metaphor-connectors` in your environment (or virtualenv). Make sure to include either `all` or `dbt` extra.

To test the connector locally, change the config file to output to a local path and run the following command

```
python -m metaphor.dbt <config_file>
```

Manually verify the output after the run finishes.
