"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const owner_regexp_1 = require("./owner-regexp");
const provider_1 = require("./provider");
/**
 * (experimental) Define an IAM Role that can be assumed by Github Actions workflow via Github OpenID Connect Identity Provider.
 *
 * Besides `GithubConfiguration`, you may pass in any `iam.RoleProps` except `assumedBy`
 * which will be defined by this construct (CDK will fail if you do).
 *
 * @experimental
 * @example
 *
 * const uploadRole = new GithubActionsRole(scope, "UploadRole", {
 *   provider: GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider"),
 *   owner: 'octo-org',
 *   repo: 'octo-repo',
 *   filter: 'ref:refs/tags/v*',
 *   roleName: 'MyUploadRole',
 * });
 *
 * myBucket.grantWrite(uploadRole);
 */
class GithubActionsRole extends iam.Role {
    /**
     * (experimental) Define an IAM Role that can be assumed by Github Actions workflow via Github OpenID Connect Identity Provider.
     *
     * Besides `GithubConfiguration`, you may pass in any `iam.RoleProps` except `assumedBy`
     * which will be defined by this construct (CDK will fail if you do).
     *
     * @experimental
     * @example
     *
     * const uploadRole = new GithubActionsRole(scope, "UploadRole", {
     *   provider: GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider"),
     *   owner: 'octo-org',
     *   repo: 'octo-repo',
     *   filter: 'ref:refs/tags/v*',
     *   roleName: 'MyUploadRole',
     * });
     *
     * myBucket.grantWrite(uploadRole);
     */
    constructor(scope, id, props) {
        const { provider, owner, repo } = props;
        // Perform validations
        GithubActionsRole.validateOwner(scope, owner);
        GithubActionsRole.validateRepo(scope, repo);
        // Prepare values
        const subject = GithubActionsRole.formatSubject(props);
        const roleProps = GithubActionsRole.extractRoleProps(props);
        // The actual IAM Role creation
        super(scope, id, {
            ...roleProps,
            assumedBy: new iam.WebIdentityPrincipal(provider.openIdConnectProviderArn, {
                StringLike: {
                    // Only allow specified subjects to assume this role
                    [`${provider_1.GithubActionsIdentityProvider.issuer}:sub`]: subject,
                },
                StringEquals: {
                    // Audience is always sts.amazonaws.com with AWS official Github Action
                    // https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services#adding-the-identity-provider-to-aws
                    [`${provider_1.GithubActionsIdentityProvider.issuer}:aud`]: 'sts.amazonaws.com',
                },
            }),
        });
    }
    /**
     * Extracts props given for the created IAM Role Construct.
     * @param props for the GithubActionsRole
     * @returns for the IAM Role
     */
    static extractRoleProps(props) {
        const extractProps = props;
        delete extractProps.provider;
        delete extractProps.owner;
        delete extractProps.repo;
        delete extractProps.filter;
        return extractProps;
    }
    /** Validates the Github owner (organization or user) name. */
    static validateOwner(scope, owner) {
        if (owner_regexp_1.default.test(owner) !== true) {
            cdk.Annotations.of(scope).addError(`Invalid Github Repository Owner "${owner}". Must only contain alphanumeric characters or hyphens, cannot have multiple consecutive hyphens, cannot begin or end with a hypen and maximum lenght is 39 characters.`);
        }
    }
    /** Validates the Github repository name (without owner). */
    static validateRepo(scope, repo) {
        if (repo === '') {
            cdk.Annotations.of(scope).addError(`Invalid Github Repository Name "${repo}". May not be empty string.`);
        }
    }
    /** Formats the `sub` value used in trust policy. */
    static formatSubject(props) {
        const { owner, repo, filter = '*' } = props;
        return `repo:${owner}/${repo}:${filter}`;
    }
}
exports.GithubActionsRole = GithubActionsRole;
_a = JSII_RTTI_SYMBOL_1;
GithubActionsRole[_a] = { fqn: "aws-cdk-github-oidc.GithubActionsRole", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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