import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceChromePolicySchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/chrome_policy_schema#id DataGoogleworkspaceChromePolicySchema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The full qualified name of the policy schema
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/chrome_policy_schema#schema_name DataGoogleworkspaceChromePolicySchema#schema_name}
    */
    readonly schemaName: string;
}
export interface DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNames {
}
export declare function dataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNamesToTerraform(struct?: DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNames): any;
export declare class DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNames | undefined;
    set internalValue(value: DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNames | undefined);
    get key(): string;
    get keyDescription(): string;
}
export declare class DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNamesOutputReference;
}
export interface DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValue {
}
export declare function dataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValueToTerraform(struct?: DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValue): any;
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValue | undefined;
    set internalValue(value: DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValue | undefined);
    get name(): string;
    get number(): number;
}
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValueList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValueOutputReference;
}
export interface DataGoogleworkspaceChromePolicySchemaDefinitionEnumType {
}
export declare function dataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeToTerraform(struct?: DataGoogleworkspaceChromePolicySchemaDefinitionEnumType): any;
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceChromePolicySchemaDefinitionEnumType | undefined;
    set internalValue(value: DataGoogleworkspaceChromePolicySchemaDefinitionEnumType | undefined);
    get name(): string;
    private _value;
    get value(): DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeValueList;
}
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeOutputReference;
}
export interface DataGoogleworkspaceChromePolicySchemaDefinition {
}
export declare function dataGoogleworkspaceChromePolicySchemaDefinitionToTerraform(struct?: DataGoogleworkspaceChromePolicySchemaDefinition): any;
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceChromePolicySchemaDefinition | undefined;
    set internalValue(value: DataGoogleworkspaceChromePolicySchemaDefinition | undefined);
    private _enumType;
    get enumType(): DataGoogleworkspaceChromePolicySchemaDefinitionEnumTypeList;
    get messageType(): string;
    get name(): string;
    get package(): string;
    get syntax(): string;
}
export declare class DataGoogleworkspaceChromePolicySchemaDefinitionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceChromePolicySchemaDefinitionOutputReference;
}
export interface DataGoogleworkspaceChromePolicySchemaNotices {
}
export declare function dataGoogleworkspaceChromePolicySchemaNoticesToTerraform(struct?: DataGoogleworkspaceChromePolicySchemaNotices): any;
export declare class DataGoogleworkspaceChromePolicySchemaNoticesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceChromePolicySchemaNotices | undefined;
    set internalValue(value: DataGoogleworkspaceChromePolicySchemaNotices | undefined);
    get acknowledgementRequired(): cdktf.IResolvable;
    get field(): string;
    get noticeMessage(): string;
    get noticeValue(): string;
}
export declare class DataGoogleworkspaceChromePolicySchemaNoticesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceChromePolicySchemaNoticesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/chrome_policy_schema googleworkspace_chrome_policy_schema}
*/
export declare class DataGoogleworkspaceChromePolicySchema extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_chrome_policy_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/chrome_policy_schema googleworkspace_chrome_policy_schema} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceChromePolicySchemaConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceChromePolicySchemaConfig);
    get accessRestrictions(): string[];
    private _additionalTargetKeyNames;
    get additionalTargetKeyNames(): DataGoogleworkspaceChromePolicySchemaAdditionalTargetKeyNamesList;
    private _definition;
    get definition(): DataGoogleworkspaceChromePolicySchemaDefinitionList;
    get fieldDescriptions(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _notices;
    get notices(): DataGoogleworkspaceChromePolicySchemaNoticesList;
    get policyDescription(): string;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    get supportUri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
