# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetShareResult',
    'AwaitableGetShareResult',
    'get_share',
    'get_share_output',
]

@pulumi.output_type
class GetShareResult:
    """
    A collection of values returned by getShare.
    """
    def __init__(__self__, created_at=None, created_by=None, id=None, name=None, objects=None):
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> int:
        """
        Time when the share was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The principal that created the share.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Full name of the object being shared.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetShareObjectResult']:
        """
        arrays containing details of each object in the share.
        """
        return pulumi.get(self, "objects")


class AwaitableGetShareResult(GetShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShareResult(
            created_at=self.created_at,
            created_by=self.created_by,
            id=self.id,
            name=self.name,
            objects=self.objects)


def get_share(created_at: Optional[int] = None,
              created_by: Optional[str] = None,
              name: Optional[str] = None,
              objects: Optional[Sequence[pulumi.InputType['GetShareObjectArgs']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShareResult:
    """
    ## Example Usage

    Getting details of an existing share in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_share(name="this")
    pulumi.export("createdBy", this.created_by)
    ```
    ## Related Resources

    The following resources are used in the same context:

    * Share to create Delta Sharing shares.
    * Recipient to create Delta Sharing recipients.
    * Grants to manage Delta Sharing permissions.


    :param int created_at: Time when the share was created.
    :param str created_by: The principal that created the share.
    :param str name: The name of the share
    :param Sequence[pulumi.InputType['GetShareObjectArgs']] objects: arrays containing details of each object in the share.
    """
    __args__ = dict()
    __args__['createdAt'] = created_at
    __args__['createdBy'] = created_by
    __args__['name'] = name
    __args__['objects'] = objects
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getShare:getShare', __args__, opts=opts, typ=GetShareResult).value

    return AwaitableGetShareResult(
        created_at=__ret__.created_at,
        created_by=__ret__.created_by,
        id=__ret__.id,
        name=__ret__.name,
        objects=__ret__.objects)


@_utilities.lift_output_func(get_share)
def get_share_output(created_at: Optional[pulumi.Input[Optional[int]]] = None,
                     created_by: Optional[pulumi.Input[Optional[str]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     objects: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetShareObjectArgs']]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetShareResult]:
    """
    ## Example Usage

    Getting details of an existing share in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_share(name="this")
    pulumi.export("createdBy", this.created_by)
    ```
    ## Related Resources

    The following resources are used in the same context:

    * Share to create Delta Sharing shares.
    * Recipient to create Delta Sharing recipients.
    * Grants to manage Delta Sharing permissions.


    :param int created_at: Time when the share was created.
    :param str created_by: The principal that created the share.
    :param str name: The name of the share
    :param Sequence[pulumi.InputType['GetShareObjectArgs']] objects: arrays containing details of each object in the share.
    """
    ...
