# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MwsWorkspacesArgs', 'MwsWorkspaces']

@pulumi.input_type
class MwsWorkspacesArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 workspace_name: pulumi.Input[str],
                 aws_region: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 cloud_resource_container: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 deployment_name: Optional[pulumi.Input[str]] = None,
                 external_customer_info: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']] = None,
                 gcp_managed_network_config: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']] = None,
                 gke_config: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input['MwsWorkspacesTokenArgs']] = None,
                 workspace_id: Optional[pulumi.Input[int]] = None,
                 workspace_status: Optional[pulumi.Input[str]] = None,
                 workspace_status_message: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MwsWorkspaces resource.
        :param pulumi.Input[str] account_id: Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[str] aws_region: region of VPC.
        :param pulumi.Input['MwsWorkspacesCloudResourceContainerArgs'] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input['MwsWorkspacesGkeConfigArgs'] gke_config: A block that specifies GKE configuration for the Databricks workspace:
        :param pulumi.Input[str] location: region of the subnet.
        :param pulumi.Input[str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[str] network_id: `network_id` from networks.
        :param pulumi.Input[str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[str] storage_configuration_id: `storage_configuration_id` from storage configuration.
        :param pulumi.Input[str] workspace_status: (String) workspace status
        :param pulumi.Input[str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[str] workspace_url: (String) URL of the workspace
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "workspace_name", workspace_name)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_resource_container is not None:
            pulumi.set(__self__, "cloud_resource_container", cloud_resource_container)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if customer_managed_key_id is not None:
            warnings.warn("""Use managed_services_customer_managed_key_id instead""", DeprecationWarning)
            pulumi.log.warn("""customer_managed_key_id is deprecated: Use managed_services_customer_managed_key_id instead""")
        if customer_managed_key_id is not None:
            pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)
        if external_customer_info is not None:
            pulumi.set(__self__, "external_customer_info", external_customer_info)
        if gcp_managed_network_config is not None:
            pulumi.set(__self__, "gcp_managed_network_config", gcp_managed_network_config)
        if gke_config is not None:
            pulumi.set(__self__, "gke_config", gke_config)
        if is_no_public_ip_enabled is not None:
            pulumi.set(__self__, "is_no_public_ip_enabled", is_no_public_ip_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_services_customer_managed_key_id is not None:
            pulumi.set(__self__, "managed_services_customer_managed_key_id", managed_services_customer_managed_key_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if pricing_tier is not None:
            pulumi.set(__self__, "pricing_tier", pricing_tier)
        if private_access_settings_id is not None:
            pulumi.set(__self__, "private_access_settings_id", private_access_settings_id)
        if storage_configuration_id is not None:
            pulumi.set(__self__, "storage_configuration_id", storage_configuration_id)
        if storage_customer_managed_key_id is not None:
            pulumi.set(__self__, "storage_customer_managed_key_id", storage_customer_managed_key_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_status is not None:
            pulumi.set(__self__, "workspace_status", workspace_status)
        if workspace_status_message is not None:
            pulumi.set(__self__, "workspace_status_message", workspace_status_message)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[str]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_name", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @cloud_resource_container.setter
    def cloud_resource_container(self, value: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]):
        pulumi.set(self, "cloud_resource_container", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_key_id", value)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_name", value)

    @property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]:
        return pulumi.get(self, "external_customer_info")

    @external_customer_info.setter
    def external_customer_info(self, value: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]):
        pulumi.set(self, "external_customer_info", value)

    @property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @gcp_managed_network_config.setter
    def gcp_managed_network_config(self, value: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]):
        pulumi.set(self, "gcp_managed_network_config", value)

    @property
    @pulumi.getter(name="gkeConfig")
    def gke_config(self) -> Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]:
        """
        A block that specifies GKE configuration for the Databricks workspace:
        """
        return pulumi.get(self, "gke_config")

    @gke_config.setter
    def gke_config(self, value: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]):
        pulumi.set(self, "gke_config", value)

    @property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @is_no_public_ip_enabled.setter
    def is_no_public_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_no_public_ip_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @managed_services_customer_managed_key_id.setter
    def managed_services_customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_services_customer_managed_key_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_tier", value)

    @property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> Optional[pulumi.Input[str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @private_access_settings_id.setter
    def private_access_settings_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_access_settings_id", value)

    @property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        `storage_configuration_id` from storage configuration.
        """
        return pulumi.get(self, "storage_configuration_id")

    @storage_configuration_id.setter
    def storage_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_configuration_id", value)

    @property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "storage_customer_managed_key_id")

    @storage_customer_managed_key_id.setter
    def storage_customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_customer_managed_key_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input['MwsWorkspacesTokenArgs']]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input['MwsWorkspacesTokenArgs']]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> Optional[pulumi.Input[str]]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @workspace_status.setter
    def workspace_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_status", value)

    @property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> Optional[pulumi.Input[str]]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @workspace_status_message.setter
    def workspace_status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_status_message", value)

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[str]]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.input_type
class _MwsWorkspacesState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 cloud_resource_container: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 deployment_name: Optional[pulumi.Input[str]] = None,
                 external_customer_info: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']] = None,
                 gcp_managed_network_config: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']] = None,
                 gke_config: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input['MwsWorkspacesTokenArgs']] = None,
                 workspace_id: Optional[pulumi.Input[int]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 workspace_status: Optional[pulumi.Input[str]] = None,
                 workspace_status_message: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MwsWorkspaces resources.
        :param pulumi.Input[str] account_id: Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[str] aws_region: region of VPC.
        :param pulumi.Input['MwsWorkspacesCloudResourceContainerArgs'] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input['MwsWorkspacesGkeConfigArgs'] gke_config: A block that specifies GKE configuration for the Databricks workspace:
        :param pulumi.Input[str] location: region of the subnet.
        :param pulumi.Input[str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[str] network_id: `network_id` from networks.
        :param pulumi.Input[str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[str] storage_configuration_id: `storage_configuration_id` from storage configuration.
        :param pulumi.Input[str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[str] workspace_status: (String) workspace status
        :param pulumi.Input[str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[str] workspace_url: (String) URL of the workspace
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_resource_container is not None:
            pulumi.set(__self__, "cloud_resource_container", cloud_resource_container)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if customer_managed_key_id is not None:
            warnings.warn("""Use managed_services_customer_managed_key_id instead""", DeprecationWarning)
            pulumi.log.warn("""customer_managed_key_id is deprecated: Use managed_services_customer_managed_key_id instead""")
        if customer_managed_key_id is not None:
            pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)
        if external_customer_info is not None:
            pulumi.set(__self__, "external_customer_info", external_customer_info)
        if gcp_managed_network_config is not None:
            pulumi.set(__self__, "gcp_managed_network_config", gcp_managed_network_config)
        if gke_config is not None:
            pulumi.set(__self__, "gke_config", gke_config)
        if is_no_public_ip_enabled is not None:
            pulumi.set(__self__, "is_no_public_ip_enabled", is_no_public_ip_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_services_customer_managed_key_id is not None:
            pulumi.set(__self__, "managed_services_customer_managed_key_id", managed_services_customer_managed_key_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if pricing_tier is not None:
            pulumi.set(__self__, "pricing_tier", pricing_tier)
        if private_access_settings_id is not None:
            pulumi.set(__self__, "private_access_settings_id", private_access_settings_id)
        if storage_configuration_id is not None:
            pulumi.set(__self__, "storage_configuration_id", storage_configuration_id)
        if storage_customer_managed_key_id is not None:
            pulumi.set(__self__, "storage_customer_managed_key_id", storage_customer_managed_key_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)
        if workspace_status is not None:
            pulumi.set(__self__, "workspace_status", workspace_status)
        if workspace_status_message is not None:
            pulumi.set(__self__, "workspace_status_message", workspace_status_message)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @cloud_resource_container.setter
    def cloud_resource_container(self, value: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]):
        pulumi.set(self, "cloud_resource_container", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_key_id", value)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_name", value)

    @property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]:
        return pulumi.get(self, "external_customer_info")

    @external_customer_info.setter
    def external_customer_info(self, value: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]):
        pulumi.set(self, "external_customer_info", value)

    @property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @gcp_managed_network_config.setter
    def gcp_managed_network_config(self, value: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]):
        pulumi.set(self, "gcp_managed_network_config", value)

    @property
    @pulumi.getter(name="gkeConfig")
    def gke_config(self) -> Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]:
        """
        A block that specifies GKE configuration for the Databricks workspace:
        """
        return pulumi.get(self, "gke_config")

    @gke_config.setter
    def gke_config(self, value: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]):
        pulumi.set(self, "gke_config", value)

    @property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @is_no_public_ip_enabled.setter
    def is_no_public_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_no_public_ip_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @managed_services_customer_managed_key_id.setter
    def managed_services_customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_services_customer_managed_key_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_tier", value)

    @property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> Optional[pulumi.Input[str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @private_access_settings_id.setter
    def private_access_settings_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_access_settings_id", value)

    @property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        `storage_configuration_id` from storage configuration.
        """
        return pulumi.get(self, "storage_configuration_id")

    @storage_configuration_id.setter
    def storage_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_configuration_id", value)

    @property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "storage_customer_managed_key_id")

    @storage_customer_managed_key_id.setter
    def storage_customer_managed_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_customer_managed_key_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input['MwsWorkspacesTokenArgs']]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input['MwsWorkspacesTokenArgs']]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_name", value)

    @property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> Optional[pulumi.Input[str]]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @workspace_status.setter
    def workspace_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_status", value)

    @property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> Optional[pulumi.Input[str]]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @workspace_status_message.setter
    def workspace_status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_status_message", value)

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[str]]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_url", value)


class MwsWorkspaces(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 cloud_resource_container: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesCloudResourceContainerArgs']]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 deployment_name: Optional[pulumi.Input[str]] = None,
                 external_customer_info: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesExternalCustomerInfoArgs']]] = None,
                 gcp_managed_network_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGcpManagedNetworkConfigArgs']]] = None,
                 gke_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGkeConfigArgs']]] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesTokenArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[int]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 workspace_status: Optional[pulumi.Input[str]] = None,
                 workspace_status_message: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[str] aws_region: region of VPC.
        :param pulumi.Input[pulumi.InputType['MwsWorkspacesCloudResourceContainerArgs']] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[pulumi.InputType['MwsWorkspacesGkeConfigArgs']] gke_config: A block that specifies GKE configuration for the Databricks workspace:
        :param pulumi.Input[str] location: region of the subnet.
        :param pulumi.Input[str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[str] network_id: `network_id` from networks.
        :param pulumi.Input[str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[str] storage_configuration_id: `storage_configuration_id` from storage configuration.
        :param pulumi.Input[str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[str] workspace_status: (String) workspace status
        :param pulumi.Input[str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[str] workspace_url: (String) URL of the workspace
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsWorkspacesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param MwsWorkspacesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsWorkspacesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 cloud_resource_container: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesCloudResourceContainerArgs']]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 credentials_id: Optional[pulumi.Input[str]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 deployment_name: Optional[pulumi.Input[str]] = None,
                 external_customer_info: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesExternalCustomerInfoArgs']]] = None,
                 gcp_managed_network_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGcpManagedNetworkConfigArgs']]] = None,
                 gke_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGkeConfigArgs']]] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesTokenArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[int]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 workspace_status: Optional[pulumi.Input[str]] = None,
                 workspace_status_message: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsWorkspacesArgs.__new__(MwsWorkspacesArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = None if account_id is None else pulumi.Output.secret(account_id)
            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["cloud_resource_container"] = cloud_resource_container
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["credentials_id"] = credentials_id
            if customer_managed_key_id is not None and not opts.urn:
                warnings.warn("""Use managed_services_customer_managed_key_id instead""", DeprecationWarning)
                pulumi.log.warn("""customer_managed_key_id is deprecated: Use managed_services_customer_managed_key_id instead""")
            __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
            __props__.__dict__["deployment_name"] = deployment_name
            __props__.__dict__["external_customer_info"] = external_customer_info
            __props__.__dict__["gcp_managed_network_config"] = gcp_managed_network_config
            __props__.__dict__["gke_config"] = gke_config
            __props__.__dict__["is_no_public_ip_enabled"] = is_no_public_ip_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_services_customer_managed_key_id"] = managed_services_customer_managed_key_id
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["pricing_tier"] = pricing_tier
            __props__.__dict__["private_access_settings_id"] = private_access_settings_id
            __props__.__dict__["storage_configuration_id"] = storage_configuration_id
            __props__.__dict__["storage_customer_managed_key_id"] = storage_customer_managed_key_id
            __props__.__dict__["token"] = token
            __props__.__dict__["workspace_id"] = workspace_id
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["workspace_status"] = workspace_status
            __props__.__dict__["workspace_status_message"] = workspace_status_message
            __props__.__dict__["workspace_url"] = workspace_url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MwsWorkspaces, __self__).__init__(
            'databricks:index/mwsWorkspaces:MwsWorkspaces',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            aws_region: Optional[pulumi.Input[str]] = None,
            cloud: Optional[pulumi.Input[str]] = None,
            cloud_resource_container: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesCloudResourceContainerArgs']]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            credentials_id: Optional[pulumi.Input[str]] = None,
            customer_managed_key_id: Optional[pulumi.Input[str]] = None,
            deployment_name: Optional[pulumi.Input[str]] = None,
            external_customer_info: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesExternalCustomerInfoArgs']]] = None,
            gcp_managed_network_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGcpManagedNetworkConfigArgs']]] = None,
            gke_config: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesGkeConfigArgs']]] = None,
            is_no_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            managed_services_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            pricing_tier: Optional[pulumi.Input[str]] = None,
            private_access_settings_id: Optional[pulumi.Input[str]] = None,
            storage_configuration_id: Optional[pulumi.Input[str]] = None,
            storage_customer_managed_key_id: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[pulumi.InputType['MwsWorkspacesTokenArgs']]] = None,
            workspace_id: Optional[pulumi.Input[int]] = None,
            workspace_name: Optional[pulumi.Input[str]] = None,
            workspace_status: Optional[pulumi.Input[str]] = None,
            workspace_status_message: Optional[pulumi.Input[str]] = None,
            workspace_url: Optional[pulumi.Input[str]] = None) -> 'MwsWorkspaces':
        """
        Get an existing MwsWorkspaces resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[str] aws_region: region of VPC.
        :param pulumi.Input[pulumi.InputType['MwsWorkspacesCloudResourceContainerArgs']] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[pulumi.InputType['MwsWorkspacesGkeConfigArgs']] gke_config: A block that specifies GKE configuration for the Databricks workspace:
        :param pulumi.Input[str] location: region of the subnet.
        :param pulumi.Input[str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[str] network_id: `network_id` from networks.
        :param pulumi.Input[str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[str] storage_configuration_id: `storage_configuration_id` from storage configuration.
        :param pulumi.Input[str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[str] workspace_status: (String) workspace status
        :param pulumi.Input[str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[str] workspace_url: (String) URL of the workspace
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsWorkspacesState.__new__(_MwsWorkspacesState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["cloud_resource_container"] = cloud_resource_container
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["credentials_id"] = credentials_id
        __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
        __props__.__dict__["deployment_name"] = deployment_name
        __props__.__dict__["external_customer_info"] = external_customer_info
        __props__.__dict__["gcp_managed_network_config"] = gcp_managed_network_config
        __props__.__dict__["gke_config"] = gke_config
        __props__.__dict__["is_no_public_ip_enabled"] = is_no_public_ip_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_services_customer_managed_key_id"] = managed_services_customer_managed_key_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["pricing_tier"] = pricing_tier
        __props__.__dict__["private_access_settings_id"] = private_access_settings_id
        __props__.__dict__["storage_configuration_id"] = storage_configuration_id
        __props__.__dict__["storage_customer_managed_key_id"] = storage_customer_managed_key_id
        __props__.__dict__["token"] = token
        __props__.__dict__["workspace_id"] = workspace_id
        __props__.__dict__["workspace_name"] = workspace_name
        __props__.__dict__["workspace_status"] = workspace_status
        __props__.__dict__["workspace_status_message"] = workspace_status_message
        __props__.__dict__["workspace_url"] = workspace_url
        return MwsWorkspaces(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Account Id that could be found in the bottom left corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[Optional[str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesCloudResourceContainer']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "credentials_id")

    @property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> pulumi.Output[Optional[str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesExternalCustomerInfo']]:
        return pulumi.get(self, "external_customer_info")

    @property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesGcpManagedNetworkConfig']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @property
    @pulumi.getter(name="gkeConfig")
    def gke_config(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesGkeConfig']]:
        """
        A block that specifies GKE configuration for the Databricks workspace:
        """
        return pulumi.get(self, "gke_config")

    @property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "pricing_tier")

    @property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> pulumi.Output[Optional[str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> pulumi.Output[Optional[str]]:
        """
        `storage_configuration_id` from storage configuration.
        """
        return pulumi.get(self, "storage_configuration_id")

    @property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "storage_customer_managed_key_id")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesToken']]:
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Output[str]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> pulumi.Output[str]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> pulumi.Output[str]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> pulumi.Output[str]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

