"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloudsearch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
 *
 * @experimental
 */
class Cloudsearch extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'cloudsearch';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Tagging: [
                'AddTags',
                'RemoveTags'
            ],
            Write: [
                'BuildSuggesters',
                'CreateDomain',
                'DefineAnalysisScheme',
                'DefineExpression',
                'DefineIndexField',
                'DefineSuggester',
                'DeleteAnalysisScheme',
                'DeleteDomain',
                'DeleteExpression',
                'DeleteIndexField',
                'DeleteSuggester',
                'IndexDocuments',
                'UpdateAvailabilityOptions',
                'UpdateDomainEndpointOptions',
                'UpdateScalingParameters',
                'document'
            ],
            Read: [
                'DescribeAnalysisSchemes',
                'DescribeAvailabilityOptions',
                'DescribeDomainEndpointOptions',
                'DescribeExpressions',
                'DescribeIndexFields',
                'DescribeScalingParameters',
                'DescribeServiceAccessPolicies',
                'DescribeSuggesters',
                'ListTags',
                'search',
                'suggest'
            ],
            List: [
                'DescribeDomains',
                'ListDomainNames'
            ],
            'Permissions management': [
                'UpdateServiceAccessPolicies'
            ]
        };
    }
    /**
     * (experimental) Attaches resource tags to an Amazon CloudSearch domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_AddTags.html
     *
     * @experimental
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * (experimental) Indexes the search suggestions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_BuildSuggesters.html
     *
     * @experimental
     */
    toBuildSuggesters() {
        return this.to('BuildSuggesters');
    }
    /**
     * (experimental) Creates a new search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_CreateDomain.html
     *
     * @experimental
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * (experimental) Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineAnalysisScheme.html
     *
     * @experimental
     */
    toDefineAnalysisScheme() {
        return this.to('DefineAnalysisScheme');
    }
    /**
     * (experimental) Configures an Expression for the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineExpression.html
     *
     * @experimental
     */
    toDefineExpression() {
        return this.to('DefineExpression');
    }
    /**
     * (experimental) Configures an IndexField for the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineIndexField.html
     *
     * @experimental
     */
    toDefineIndexField() {
        return this.to('DefineIndexField');
    }
    /**
     * (experimental) Configures a suggester for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineSuggester.html
     *
     * @experimental
     */
    toDefineSuggester() {
        return this.to('DefineSuggester');
    }
    /**
     * (experimental) Deletes an analysis scheme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteAnalysisScheme.html
     *
     * @experimental
     */
    toDeleteAnalysisScheme() {
        return this.to('DeleteAnalysisScheme');
    }
    /**
     * (experimental) Permanently deletes a search domain and all of its data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteDomain.html
     *
     * @experimental
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * (experimental) Removes an Expression from the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteExpression.html
     *
     * @experimental
     */
    toDeleteExpression() {
        return this.to('DeleteExpression');
    }
    /**
     * (experimental) Removes an IndexField from the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteIndexField.html
     *
     * @experimental
     */
    toDeleteIndexField() {
        return this.to('DeleteIndexField');
    }
    /**
     * (experimental) Deletes a suggester.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteSuggester.html
     *
     * @experimental
     */
    toDeleteSuggester() {
        return this.to('DeleteSuggester');
    }
    /**
     * (experimental) Gets the analysis schemes configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAnalysisSchemes.html
     *
     * @experimental
     */
    toDescribeAnalysisSchemes() {
        return this.to('DescribeAnalysisSchemes');
    }
    /**
     * (experimental) Gets the availability options configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAvailabilityOptions.html
     *
     * @experimental
     */
    toDescribeAvailabilityOptions() {
        return this.to('DescribeAvailabilityOptions');
    }
    /**
     * (experimental) Gets the domain endpoint options configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomainEndpointOptions.html
     *
     * @experimental
     */
    toDescribeDomainEndpointOptions() {
        return this.to('DescribeDomainEndpointOptions');
    }
    /**
     * (experimental) Gets information about the search domains owned by this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomains.html
     *
     * @experimental
     */
    toDescribeDomains() {
        return this.to('DescribeDomains');
    }
    /**
     * (experimental) Gets the expressions configured for the search domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeExpressions.html
     *
     * @experimental
     */
    toDescribeExpressions() {
        return this.to('DescribeExpressions');
    }
    /**
     * (experimental) Gets information about the index fields configured for the search domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeIndexFields.html
     *
     * @experimental
     */
    toDescribeIndexFields() {
        return this.to('DescribeIndexFields');
    }
    /**
     * (experimental) Gets the scaling parameters configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeScalingParameters.html
     *
     * @experimental
     */
    toDescribeScalingParameters() {
        return this.to('DescribeScalingParameters');
    }
    /**
     * (experimental) Gets information about the access policies that control access to the domain's document and search endpoints.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeServiceAccessPolicies.html
     *
     * @experimental
     */
    toDescribeServiceAccessPolicies() {
        return this.to('DescribeServiceAccessPolicies');
    }
    /**
     * (experimental) Gets the suggesters configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeSuggesters.html
     *
     * @experimental
     */
    toDescribeSuggesters() {
        return this.to('DescribeSuggesters');
    }
    /**
     * (experimental) Tells the search domain to start indexing its documents using the latest indexing options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_IndexDocuments.html
     *
     * @experimental
     */
    toIndexDocuments() {
        return this.to('IndexDocuments');
    }
    /**
     * (experimental) Lists all search domains owned by an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListDomainNames.html
     *
     * @experimental
     */
    toListDomainNames() {
        return this.to('ListDomainNames');
    }
    /**
     * (experimental) Displays all of the resource tags for an Amazon CloudSearch domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListTags.html
     *
     * @experimental
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * (experimental) Removes the specified resource tags from an Amazon ES domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_RemoveTags.html
     *
     * @experimental
     */
    toRemoveTags() {
        return this.to('RemoveTags');
    }
    /**
     * (experimental) Configures the availability options for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateAvailabilityOptions.html
     *
     * @experimental
     */
    toUpdateAvailabilityOptions() {
        return this.to('UpdateAvailabilityOptions');
    }
    /**
     * (experimental) Configures the domain endpoint options for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateDomainEndpointOptions.html
     *
     * @experimental
     */
    toUpdateDomainEndpointOptions() {
        return this.to('UpdateDomainEndpointOptions');
    }
    /**
     * (experimental) Configures scaling parameters for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateScalingParameters.html
     *
     * @experimental
     */
    toUpdateScalingParameters() {
        return this.to('UpdateScalingParameters');
    }
    /**
     * (experimental) Configures the access rules that control access to the domain's document and search endpoints.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateServiceAccessPolicies.html
     *
     * @experimental
     */
    toUpdateServiceAccessPolicies() {
        return this.to('UpdateServiceAccessPolicies');
    }
    /**
     * (experimental) Allows access to the document service operations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     *
     * @experimental
     */
    toDocument() {
        return this.to('document');
    }
    /**
     * (experimental) Allows access to the search operations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     *
     * @experimental
     */
    toSearch() {
        return this.to('search');
    }
    /**
     * (experimental) Allows access to the suggest operations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     *
     * @experimental
     */
    toSuggest() {
        return this.to('suggest');
    }
    /**
     * (experimental) Adds a resource of type domain to the statement.
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDomain(domainName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:cloudsearch:${region || '*'}:${account || '*'}:domain/${domainName}`);
    }
}
exports.Cloudsearch = Cloudsearch;
_a = JSII_RTTI_SYMBOL_1;
Cloudsearch[_a] = { fqn: "iam-floyd.Cloudsearch", version: "0.301.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRzZWFyY2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZHNlYXJjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0Qzs7Ozs7O0FBRzVDLE1BQWEsV0FBWSxTQUFRLHdCQUFlOzs7Ozs7O0lBSTlDLFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Ozs7OztRQUpOLGtCQUFhLEdBQUcsYUFBYSxDQUFDOzs7O1FBdUszQixvQkFBZSxHQUFvQjtZQUMzQyxPQUFPLEVBQUU7Z0JBQ1AsU0FBUztnQkFDVCxZQUFZO2FBQ2I7WUFDRCxLQUFLLEVBQUU7Z0JBQ0wsaUJBQWlCO2dCQUNqQixjQUFjO2dCQUNkLHNCQUFzQjtnQkFDdEIsa0JBQWtCO2dCQUNsQixrQkFBa0I7Z0JBQ2xCLGlCQUFpQjtnQkFDakIsc0JBQXNCO2dCQUN0QixjQUFjO2dCQUNkLGtCQUFrQjtnQkFDbEIsa0JBQWtCO2dCQUNsQixpQkFBaUI7Z0JBQ2pCLGdCQUFnQjtnQkFDaEIsMkJBQTJCO2dCQUMzQiw2QkFBNkI7Z0JBQzdCLHlCQUF5QjtnQkFDekIsVUFBVTthQUNYO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHlCQUF5QjtnQkFDekIsNkJBQTZCO2dCQUM3QiwrQkFBK0I7Z0JBQy9CLHFCQUFxQjtnQkFDckIscUJBQXFCO2dCQUNyQiwyQkFBMkI7Z0JBQzNCLCtCQUErQjtnQkFDL0Isb0JBQW9CO2dCQUNwQixVQUFVO2dCQUNWLFFBQVE7Z0JBQ1IsU0FBUzthQUNWO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLGlCQUFpQjtnQkFDakIsaUJBQWlCO2FBQ2xCO1lBQ0Qsd0JBQXdCLEVBQUU7Z0JBQ3hCLDZCQUE2QjthQUM5QjtTQUNGLENBQUM7SUE3TUYsQ0FBQzs7Ozs7Ozs7OztJQUdNLFNBQVM7UUFDZCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUIsQ0FBQzs7Ozs7Ozs7OztJQUdNLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDOzs7Ozs7Ozs7O0lBR00sY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7Ozs7Ozs7O0lBR00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDOzs7Ozs7Ozs7O0lBR00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDOzs7Ozs7Ozs7O0lBR00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDOzs7Ozs7Ozs7O0lBR00saUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7Ozs7O0lBR00sMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7Ozs7Ozs7SUFHTSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7Ozs7O0lBR00sZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7Ozs7Ozs7Ozs7SUFHTSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQzs7Ozs7Ozs7OztJQUdNLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7Ozs7SUFHTSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLDZCQUE2QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNoRCxDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQzs7Ozs7Ozs7OztJQUdNLFFBQVE7UUFDYixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0IsQ0FBQzs7Ozs7Ozs7OztJQUdNLFNBQVM7UUFDZCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUIsQ0FBQzs7Ozs7Ozs7Ozs7O0lBZ0RNLFFBQVEsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3ZGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLGdCQUFpQixNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLFdBQVksVUFBVyxFQUFFLENBQUMsQ0FBQztJQUMxSCxDQUFDOztBQXhOSCxrQ0F5TkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENsb3Vkc2VhcmNoIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnY2xvdWRzZWFyY2gnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9BZGRUYWdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBZGRUYWdzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9CdWlsZFN1Z2dlc3RlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0J1aWxkU3VnZ2VzdGVycycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlRG9tYWluKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVEb21haW4nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWZpbmVBbmFseXNpc1NjaGVtZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVmaW5lQW5hbHlzaXNTY2hlbWUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVmaW5lRXhwcmVzc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVmaW5lRXhwcmVzc2lvbicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWZpbmVJbmRleEZpZWxkKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWZpbmVJbmRleEZpZWxkJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlZmluZVN1Z2dlc3RlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVmaW5lU3VnZ2VzdGVyJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlQW5hbHlzaXNTY2hlbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUFuYWx5c2lzU2NoZW1lJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlRG9tYWluKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVEb21haW4nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZUV4cHJlc3Npb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUV4cHJlc3Npb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZUluZGV4RmllbGQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUluZGV4RmllbGQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVTdWdnZXN0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVN1Z2dlc3RlcicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZUFuYWx5c2lzU2NoZW1lcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVBbmFseXNpc1NjaGVtZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZUF2YWlsYWJpbGl0eU9wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQXZhaWxhYmlsaXR5T3B0aW9ucycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVEb21haW5FbmRwb2ludE9wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRG9tYWluRW5kcG9pbnRPcHRpb25zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlRG9tYWlucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVEb21haW5zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlRXhwcmVzc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRXhwcmVzc2lvbnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlSW5kZXhGaWVsZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlSW5kZXhGaWVsZHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlU2NhbGluZ1BhcmFtZXRlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlU2NhbGluZ1BhcmFtZXRlcnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZVNlcnZpY2VBY2Nlc3NQb2xpY2llcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTZXJ2aWNlQWNjZXNzUG9saWNpZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlU3VnZ2VzdGVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTdWdnZXN0ZXJzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvSW5kZXhEb2N1bWVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0luZGV4RG9jdW1lbnRzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdERvbWFpbk5hbWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RG9tYWluTmFtZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VGFncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRhZ3MnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1JlbW92ZVRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlbW92ZVRhZ3MnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVBdmFpbGFiaWxpdHlPcHRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVBdmFpbGFiaWxpdHlPcHRpb25zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVEb21haW5FbmRwb2ludE9wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZURvbWFpbkVuZHBvaW50T3B0aW9ucycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVTY2FsaW5nUGFyYW1ldGVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlU2NhbGluZ1BhcmFtZXRlcnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlU2VydmljZUFjY2Vzc1BvbGljaWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlQWNjZXNzUG9saWNpZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9Eb2N1bWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnZG9jdW1lbnQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2VhcmNoKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdzZWFyY2gnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1N1Z2dlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ3N1Z2dlc3QnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnQWRkVGFncycsXG4gICAgICAnUmVtb3ZlVGFncydcbiAgICBdLFxuICAgIFdyaXRlOiBbXG4gICAgICAnQnVpbGRTdWdnZXN0ZXJzJyxcbiAgICAgICdDcmVhdGVEb21haW4nLFxuICAgICAgJ0RlZmluZUFuYWx5c2lzU2NoZW1lJyxcbiAgICAgICdEZWZpbmVFeHByZXNzaW9uJyxcbiAgICAgICdEZWZpbmVJbmRleEZpZWxkJyxcbiAgICAgICdEZWZpbmVTdWdnZXN0ZXInLFxuICAgICAgJ0RlbGV0ZUFuYWx5c2lzU2NoZW1lJyxcbiAgICAgICdEZWxldGVEb21haW4nLFxuICAgICAgJ0RlbGV0ZUV4cHJlc3Npb24nLFxuICAgICAgJ0RlbGV0ZUluZGV4RmllbGQnLFxuICAgICAgJ0RlbGV0ZVN1Z2dlc3RlcicsXG4gICAgICAnSW5kZXhEb2N1bWVudHMnLFxuICAgICAgJ1VwZGF0ZUF2YWlsYWJpbGl0eU9wdGlvbnMnLFxuICAgICAgJ1VwZGF0ZURvbWFpbkVuZHBvaW50T3B0aW9ucycsXG4gICAgICAnVXBkYXRlU2NhbGluZ1BhcmFtZXRlcnMnLFxuICAgICAgJ2RvY3VtZW50J1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0Rlc2NyaWJlQW5hbHlzaXNTY2hlbWVzJyxcbiAgICAgICdEZXNjcmliZUF2YWlsYWJpbGl0eU9wdGlvbnMnLFxuICAgICAgJ0Rlc2NyaWJlRG9tYWluRW5kcG9pbnRPcHRpb25zJyxcbiAgICAgICdEZXNjcmliZUV4cHJlc3Npb25zJyxcbiAgICAgICdEZXNjcmliZUluZGV4RmllbGRzJyxcbiAgICAgICdEZXNjcmliZVNjYWxpbmdQYXJhbWV0ZXJzJyxcbiAgICAgICdEZXNjcmliZVNlcnZpY2VBY2Nlc3NQb2xpY2llcycsXG4gICAgICAnRGVzY3JpYmVTdWdnZXN0ZXJzJyxcbiAgICAgICdMaXN0VGFncycsXG4gICAgICAnc2VhcmNoJyxcbiAgICAgICdzdWdnZXN0J1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0Rlc2NyaWJlRG9tYWlucycsXG4gICAgICAnTGlzdERvbWFpbk5hbWVzJ1xuICAgIF0sXG4gICAgJ1Blcm1pc3Npb25zIG1hbmFnZW1lbnQnOiBbXG4gICAgICAnVXBkYXRlU2VydmljZUFjY2Vzc1BvbGljaWVzJ1xuICAgIF1cbiAgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBvbkRvbWFpbihkb21haW5OYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpjbG91ZHNlYXJjaDokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpkb21haW4vJHsgZG9tYWluTmFtZSB9YCk7XG4gIH1cbn1cbiJdfQ==