import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
 *
 * @experimental
 */
export declare class Dbqms extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a new favorite query.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     *
     * @experimental
     */
    toCreateFavoriteQuery(): this;
    /**
     * (experimental) Grants permission to add a query to the history.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateQueryHistory(): this;
    /**
     * (experimental) Grants permission to create a new query tab.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateTab
     *
     * @experimental
     */
    toCreateTab(): this;
    /**
     * (experimental) Grants permission to delete saved queries.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     *
     * @experimental
     */
    toDeleteFavoriteQueries(): this;
    /**
     * (experimental) Grants permission to delete a historical query.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     *
     * @experimental
     */
    toDeleteQueryHistory(): this;
    /**
     * (experimental) Grants permission to delete query tab.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteTab
     *
     * @experimental
     */
    toDeleteTab(): this;
    /**
     * (experimental) Grants permission to list saved queries and associated metadata.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     *
     * @experimental
     */
    toDescribeFavoriteQueries(): this;
    /**
     * (experimental) Grants permission to list history of queries that were run.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     *
     * @experimental
     */
    toDescribeQueryHistory(): this;
    /**
     * (experimental) Grants permission to list query tabs and associated metadata.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeTabs
     *
     * @experimental
     */
    toDescribeTabs(): this;
    /**
     * (experimental) Grants permission to retrieve favorite or history query string by id.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     *
     * @experimental
     */
    toGetQueryString(): this;
    /**
     * (experimental) Grants permission to update saved query and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     *
     * @experimental
     */
    toUpdateFavoriteQuery(): this;
    /**
     * (experimental) Grants permission to update the query history.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     *
     * @experimental
     */
    toUpdateQueryHistory(): this;
    /**
     * (experimental) Grants permission to update query tab.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateTab
     *
     * @experimental
     */
    toUpdateTab(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
