import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [elasticloadbalancing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elasticloadbalancing.html).
 *
 * @experimental
 */
export declare class Elasticloadbalancing extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [elasticloadbalancing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elasticloadbalancing.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_AddTags.html
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Associates one or more security groups with your load balancer in a virtual private cloud (VPC).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_ApplySecurityGroupsToLoadBalancer.html
     *
     * @experimental
     */
    toApplySecurityGroupsToLoadBalancer(): this;
    /**
     * (experimental) Adds one or more subnets to the set of configured subnets for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_AttachLoadBalancerToSubnets.html
     *
     * @experimental
     */
    toAttachLoadBalancerToSubnets(): this;
    /**
     * (experimental) Specifies the health check settings to use when evaluating the health state of your back-end instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_ConfigureHealthCheck.html
     *
     * @experimental
     */
    toConfigureHealthCheck(): this;
    /**
     * (experimental) Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_CreateAppCookieStickinessPolicy.html
     *
     * @experimental
     */
    toCreateAppCookieStickinessPolicy(): this;
    /**
     * (experimental) Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_CreateLBCookieStickinessPolicy.html
     *
     * @experimental
     */
    toCreateLBCookieStickinessPolicy(): this;
    /**
     * (experimental) Creates a load balancer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_CreateLoadBalancer.html
     *
     * @experimental
     */
    toCreateLoadBalancer(): this;
    /**
     * (experimental) Creates one or more listeners for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_CreateLoadBalancerListeners.html
     *
     * @experimental
     */
    toCreateLoadBalancerListeners(): this;
    /**
     * (experimental) Creates a policy with the specified attributes for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_CreateLoadBalancerPolicy.html
     *
     * @experimental
     */
    toCreateLoadBalancerPolicy(): this;
    /**
     * (experimental) Deletes the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DeleteLoadBalancer.html
     *
     * @experimental
     */
    toDeleteLoadBalancer(): this;
    /**
     * (experimental) Deletes the specified listeners from the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DeleteLoadBalancerListeners.html
     *
     * @experimental
     */
    toDeleteLoadBalancerListeners(): this;
    /**
     * (experimental) Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DeleteLoadBalancerPolicy.html
     *
     * @experimental
     */
    toDeleteLoadBalancerPolicy(): this;
    /**
     * (experimental) Deregisters the specified instances from the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DeregisterInstancesFromLoadBalancer.html
     *
     * @experimental
     */
    toDeregisterInstancesFromLoadBalancer(): this;
    /**
     * (experimental) Describes the state of the specified instances with respect to the specified load balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeInstanceHealth.html
     *
     * @experimental
     */
    toDescribeInstanceHealth(): this;
    /**
     * (experimental) Describes the attributes for the specified load balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancerAttributes.html
     *
     * @experimental
     */
    toDescribeLoadBalancerAttributes(): this;
    /**
     * (experimental) Describes the specified policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancerPolicies.html
     *
     * @experimental
     */
    toDescribeLoadBalancerPolicies(): this;
    /**
     * (experimental) Describes the specified load balancer policy types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancerPolicyTypes.html
     *
     * @experimental
     */
    toDescribeLoadBalancerPolicyTypes(): this;
    /**
     * (experimental) Describes the specified the load balancers.
     *
     * If no load balancers are specified, the call describes all of your load balancers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html
     *
     * @experimental
     */
    toDescribeLoadBalancers(): this;
    /**
     * (experimental) Describes the tags associated with the specified load balancers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Removes the specified subnets from the set of configured subnets for the load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DetachLoadBalancerFromSubnets.html
     *
     * @experimental
     */
    toDetachLoadBalancerFromSubnets(): this;
    /**
     * (experimental) Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DisableAvailabilityZonesForLoadBalancer.html
     *
     * @experimental
     */
    toDisableAvailabilityZonesForLoadBalancer(): this;
    /**
     * (experimental) Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_EnableAvailabilityZonesForLoadBalancer.html
     *
     * @experimental
     */
    toEnableAvailabilityZonesForLoadBalancer(): this;
    /**
     * (experimental) Modifies the attributes of the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_ModifyLoadBalancerAttributes.html
     *
     * @experimental
     */
    toModifyLoadBalancerAttributes(): this;
    /**
     * (experimental) Adds the specified instances to the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_RegisterInstancesWithLoadBalancer.html
     *
     * @experimental
     */
    toRegisterInstancesWithLoadBalancer(): this;
    /**
     * (experimental) Removes one or more tags from the specified load balancer.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_RemoveTags.html
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Sets the certificate that terminates the specified listener's SSL connections.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_SetLoadBalancerListenerSSLCertificate.html
     *
     * @experimental
     */
    toSetLoadBalancerListenerSSLCertificate(): this;
    /**
     * (experimental) Replaces the set of policies associated with the specified port on which the back-end server is listening with a new set of policies.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_SetLoadBalancerPoliciesForBackendServer.html
     *
     * @experimental
     */
    toSetLoadBalancerPoliciesForBackendServer(): this;
    /**
     * (experimental) Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_SetLoadBalancerPoliciesOfListener.html
     *
     * @experimental
     */
    toSetLoadBalancerPoliciesOfListener(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type loadbalancer to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/what-is-load-balancing.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLoadbalancer(loadBalancerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) The preface string for a tag key and value pair attached to a resource.
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTagExists(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) A tag key and value pair.
     *
     * Applies to resource types:
     * - loadbalancer
     *
     * @param tagKey The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
}
