import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
 *
 * @experimental
 */
export declare class Iotroborunner extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateAction.html
     *
     * @experimental
     */
    toCreateAction(): this;
    /**
     * (experimental) Grants permission to create an action template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActionTemplate.html
     *
     * @experimental
     */
    toCreateActionTemplate(): this;
    /**
     * (experimental) Grants permission to create an action template dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActionTemplateDependency.html
     *
     * @experimental
     */
    toCreateActionTemplateDependency(): this;
    /**
     * (experimental) Grants permission to create an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActivity.html
     *
     * @experimental
     */
    toCreateActivity(): this;
    /**
     * (experimental) Grants permission to create an activity dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActivityDependency.html
     *
     * @experimental
     */
    toCreateActivityDependency(): this;
    /**
     * (experimental) Grants permission to create a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateDestination.html
     *
     * @experimental
     */
    toCreateDestination(): this;
    /**
     * (experimental) Grants permission to create a destination relationship.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateDestinationRelationship.html
     *
     * @experimental
     */
    toCreateDestinationRelationship(): this;
    /**
     * (experimental) Grants permission to create a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateSite.html
     *
     * @experimental
     */
    toCreateSite(): this;
    /**
     * (experimental) Grants permission to create a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateTask.html
     *
     * @experimental
     */
    toCreateTask(): this;
    /**
     * (experimental) Grants permission to create a task dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateTaskDependency.html
     *
     * @experimental
     */
    toCreateTaskDependency(): this;
    /**
     * (experimental) Grants permission to create a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateWorker.html
     *
     * @experimental
     */
    toCreateWorker(): this;
    /**
     * (experimental) Grants permission to create a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateWorkerFleet.html
     *
     * @experimental
     */
    toCreateWorkerFleet(): this;
    /**
     * (experimental) Grants permission to delete an action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteAction.html
     *
     * @experimental
     */
    toDeleteAction(): this;
    /**
     * (experimental) Grants permission to delete an action template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActionTemplate.html
     *
     * @experimental
     */
    toDeleteActionTemplate(): this;
    /**
     * (experimental) Grants permission to delete an action template dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActionTemplateDependency.html
     *
     * @experimental
     */
    toDeleteActionTemplateDependency(): this;
    /**
     * (experimental) Grants permission to delete an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActivity.html
     *
     * @experimental
     */
    toDeleteActivity(): this;
    /**
     * (experimental) Grants permission to delete an activity dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActivityDependency.html
     *
     * @experimental
     */
    toDeleteActivityDependency(): this;
    /**
     * (experimental) Grants permission to delete a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteDestination.html
     *
     * @experimental
     */
    toDeleteDestination(): this;
    /**
     * (experimental) Grants permission to delete a destination relationship.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteDestinationRelationship.html
     *
     * @experimental
     */
    toDeleteDestinationRelationship(): this;
    /**
     * (experimental) Grants permission to delete a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteSite.html
     *
     * @experimental
     */
    toDeleteSite(): this;
    /**
     * (experimental) Grants permission to delete a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteTask.html
     *
     * @experimental
     */
    toDeleteTask(): this;
    /**
     * (experimental) Grants permission to delete a task dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteTaskDependency.html
     *
     * @experimental
     */
    toDeleteTaskDependency(): this;
    /**
     * (experimental) Grants permission to delete a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteWorker.html
     *
     * @experimental
     */
    toDeleteWorker(): this;
    /**
     * (experimental) Grants permission to delete a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteWorkerFleet.html
     *
     * @experimental
     */
    toDeleteWorkerFleet(): this;
    /**
     * (experimental) Grants permission to get an action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetAction.html
     *
     * @experimental
     */
    toGetAction(): this;
    /**
     * (experimental) Grants permission to get an action template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetActionTemplate.html
     *
     * @experimental
     */
    toGetActionTemplate(): this;
    /**
     * (experimental) Grants permission to get an activity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetActivity.html
     *
     * @experimental
     */
    toGetActivity(): this;
    /**
     * (experimental) Grants permission to get a destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetDestination.html
     *
     * @experimental
     */
    toGetDestination(): this;
    /**
     * (experimental) Grants permission to get a destination relationship.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetDestinationRelationship.html
     *
     * @experimental
     */
    toGetDestinationRelationship(): this;
    /**
     * (experimental) Grants permission to get a site.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetSite.html
     *
     * @experimental
     */
    toGetSite(): this;
    /**
     * (experimental) Grants permission to get a task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetTask.html
     *
     * @experimental
     */
    toGetTask(): this;
    /**
     * (experimental) Grants permission to get a worker.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetWorker.html
     *
     * @experimental
     */
    toGetWorker(): this;
    /**
     * (experimental) Grants permission to get a worker fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetWorkerFleet.html
     *
     * @experimental
     */
    toGetWorkerFleet(): this;
    /**
     * (experimental) Grants permission to list action templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActionTemplates.html
     *
     * @experimental
     */
    toListActionTemplates(): this;
    /**
     * (experimental) Grants permission to list actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActions.html
     *
     * @experimental
     */
    toListActions(): this;
    /**
     * (experimental) Grants permission to list activities.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActivities.html
     *
     * @experimental
     */
    toListActivities(): this;
    /**
     * (experimental) Grants permission to list destination relationships.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListDestinationRelationships.html
     *
     * @experimental
     */
    toListDestinationRelationships(): this;
    /**
     * (experimental) Grants permission to list destinations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListDestinations.html
     *
     * @experimental
     */
    toListDestinations(): this;
    /**
     * (experimental) Grants permission to list sites.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListSites.html
     *
     * @experimental
     */
    toListSites(): this;
    /**
     * (experimental) Grants permission to list tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListTasks.html
     *
     * @experimental
     */
    toListTasks(): this;
    /**
     * (experimental) Grants permission to list worker fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListWorkerFleets.html
     *
     * @experimental
     */
    toListWorkerFleets(): this;
    /**
     * (experimental) Grants permission to list workers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListWorkers.html
     *
     * @experimental
     */
    toListWorkers(): this;
    /**
     * (experimental) Grants permission to update an action's state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateActionState.html
     *
     * @experimental
     */
    toUpdateActionState(): this;
    /**
     * (experimental) Grants permission to update an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateActivity.html
     *
     * @experimental
     */
    toUpdateActivity(): this;
    /**
     * (experimental) Grants permission to update a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateDestination.html
     *
     * @experimental
     */
    toUpdateDestination(): this;
    /**
     * (experimental) Grants permission to update a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateSite.html
     *
     * @experimental
     */
    toUpdateSite(): this;
    /**
     * (experimental) Grants permission to update a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateTask.html
     *
     * @experimental
     */
    toUpdateTask(): this;
    /**
     * (experimental) Grants permission to update a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateWorker.html
     *
     * @experimental
     */
    toUpdateWorker(): this;
    /**
     * (experimental) Grants permission to update a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateWorkerFleet.html
     *
     * @experimental
     */
    toUpdateWorkerFleet(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type ActionResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param actionId - Identifier for the actionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActionResource(actionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ActionTemplateResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param actionTemplateId - Identifier for the actionTemplateId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActionTemplateResource(actionTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ActivityResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param activityId - Identifier for the activityId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActivityResource(activityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DestinationRelationshipResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param destinationRelationshipId - Identifier for the destinationRelationshipId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestinationRelationshipResource(destinationRelationshipId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DestinationResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param destinationId - Identifier for the destinationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestinationResource(destinationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type SiteResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSiteResource(siteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type TaggingResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTaggingResource(tagKey: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type TaskResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param taskId - Identifier for the taskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTaskResource(taskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WorkerFleetResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkerFleetResource(workerFleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WorkerResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param workerId - Identifier for the workerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkerResource(workerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the action's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Action
     *
     * Applies to resource types:
     * - ActionResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActionResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the action template's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#ActionTemplate
     *
     * Applies to resource types:
     * - ActionTemplateResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActionTemplateResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the activity's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Activity
     *
     * Applies to resource types:
     * - ActivityResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActivityResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the destination relationship's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#DestinationRelationship
     *
     * Applies to resource types:
     * - DestinationRelationshipResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifDestinationRelationshipResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the destination's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Destination
     *
     * Applies to resource types:
     * - DestinationResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifDestinationResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the site's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Site
     *
     * Applies to resource types:
     * - SiteResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSiteResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the metadata tag name.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Tagging
     *
     * Applies to resource types:
     * - TaggingResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTaggingResourceTagKey(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the task's identifer.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Task
     *
     * Applies to resource types:
     * - TaskResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTaskResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the worker fleet's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#WorkerFleet
     *
     * Applies to resource types:
     * - WorkerFleetResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifWorkerFleetResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the workers identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Worker
     *
     * Applies to resource types:
     * - WorkerResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifWorkerResourceId(value: string | string[], operator?: Operator | string): this;
}
