import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
 *
 * @experimental
 */
export declare class SsmContacts extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to accept a page.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_AcceptPage.html
     *
     * @experimental
     */
    toAcceptPage(): this;
    /**
     * (experimental) Grants permission to activate a contact's contact channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ActivateContactChannel.html
     *
     * @experimental
     */
    toActivateContactChannel(): this;
    /**
     * (experimental) Grants permission to use a contact in an escalation plan.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_AssociateContact.html
     *
     * @experimental
     */
    toAssociateContact(): this;
    /**
     * (experimental) Grants permission to create a contact.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateContact.html
     *
     * @experimental
     */
    toCreateContact(): this;
    /**
     * (experimental) Grants permission to create a contact channel for a contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateContactChannel.html
     *
     * @experimental
     */
    toCreateContactChannel(): this;
    /**
     * (experimental) Grants permission to deactivate a contact's contact channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeactivateContactChannel.html
     *
     * @experimental
     */
    toDeactivateContactChannel(): this;
    /**
     * (experimental) Grants permission to delete a contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteContact.html
     *
     * @experimental
     */
    toDeleteContact(): this;
    /**
     * (experimental) Grants permission to delete a contact's contact channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteContactChannel.html
     *
     * @experimental
     */
    toDeleteContactChannel(): this;
    /**
     * (experimental) Grants permission to delete a contact's resource policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteContactPolicy.html
     *
     * @experimental
     */
    toDeleteContactPolicy(): this;
    /**
     * (experimental) Grants permission to describe an engagement.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DescribeEngagement.html
     *
     * @experimental
     */
    toDescribeEngagement(): this;
    /**
     * (experimental) Grants permission to describe a page.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DescribePage.html
     *
     * @experimental
     */
    toDescribePage(): this;
    /**
     * (experimental) Grants permission to get a contact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetContact.html
     *
     * @experimental
     */
    toGetContact(): this;
    /**
     * (experimental) Grants permission to get a contact's contact channel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetContactChannel.html
     *
     * @experimental
     */
    toGetContactChannel(): this;
    /**
     * (experimental) Grants permission to get a contact's resource policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetContactPolicy.html
     *
     * @experimental
     */
    toGetContactPolicy(): this;
    /**
     * (experimental) Grants permission to list all of a contact's contact channels.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListContactChannels.html
     *
     * @experimental
     */
    toListContactChannels(): this;
    /**
     * (experimental) Grants permission to list all contacts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListContacts.html
     *
     * @experimental
     */
    toListContacts(): this;
    /**
     * (experimental) Grants permission to list all engagements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListEngagements.html
     *
     * @experimental
     */
    toListEngagements(): this;
    /**
     * (experimental) Grants permission to list all receipts of a page.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListPageReceipts.html
     *
     * @experimental
     */
    toListPageReceipts(): this;
    /**
     * (experimental) Grants permission to list all pages sent to a contact.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListPagesByContacts.html
     *
     * @experimental
     */
    toListPagesByContact(): this;
    /**
     * (experimental) Grants permission to list all pages created in an engagement.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListPagesByEngagement.html
     *
     * @experimental
     */
    toListPagesByEngagement(): this;
    /**
     * (experimental) Grants permission to view a list of resource tags for a specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to add a resource policy to a contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_PutContactPolicy.html
     *
     * @experimental
     */
    toPutContactPolicy(): this;
    /**
     * (experimental) Grants permission to send the activation code of a contact's contact channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SendActivationCode.html
     *
     * @experimental
     */
    toSendActivationCode(): this;
    /**
     * (experimental) Grants permission to start an engagement.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_StartEngagement.html
     *
     * @experimental
     */
    toStartEngagement(): this;
    /**
     * (experimental) Grants permission to stop an engagement.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_StopEngagement.html
     *
     * @experimental
     */
    toStopEngagement(): this;
    /**
     * (experimental) Grants permission to add tags to a response plan.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a response plan.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a contact.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateContact.html
     *
     * @experimental
     */
    toUpdateContact(): this;
    /**
     * (experimental) Grants permission to update a contact's contact channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateContactChannel.html
     *
     * @experimental
     */
    toUpdateContactChannel(): this;
    /**
     * (experimental) Grants permission to update a contact's resource policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateContactPolicy.html
     *
     * @experimental
     */
    toUpdateContactPolicy(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type contact to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onContact(contactAlias: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type contactchannel to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param contactChannelId - Identifier for the contactChannelId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onContactchannel(contactAlias: string, contactChannelId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type engagement to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/escalation.html
     *
     * @param engagementId - Identifier for the engagementId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEngagement(engagementId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type page to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/escalation.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param pageId - Identifier for the pageId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPage(contactAlias: string, pageId: string, account?: string, region?: string, partition?: string): this;
}
