# Generated by Django 1.10.8 on 2018-03-26 16:05
import django.contrib.gis.db.models.fields
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import mptt.fields
from django.db import migrations, models

from unicef_locations.libs import get_random_color


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CartoDBTable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('domain', models.CharField(max_length=254, verbose_name='Domain')),
                ('api_key', models.CharField(max_length=254, verbose_name='API Key')),
                ('table_name', models.CharField(max_length=254, verbose_name='Table Name')),
                ('display_name', models.CharField(blank=True, max_length=254, null=True, verbose_name='Display Name')),
                ('name_col', models.CharField(default='name', max_length=254, verbose_name='Name Column')),
                ('pcode_col', models.CharField(default='pcode', max_length=254, verbose_name='Pcode Column')),
                ('parent_code_col', models.CharField(blank=True, max_length=254,
                                                     null=True,
                                                     verbose_name='Parent Code Column')),
                ('color', models.CharField(blank=True, default=get_random_color,
                                           max_length=7, null=True, verbose_name='Color')),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GatewayType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('admin_level', models.PositiveSmallIntegerField(null=True, unique=True, verbose_name='Admin Level')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Location Type',
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254, verbose_name='Name')),
                ('latitude', models.FloatField(blank=True, null=True, verbose_name='Latitude')),
                ('longitude', models.FloatField(blank=True, null=True, verbose_name='Longitude')),
                ('p_code', models.CharField(blank=True, max_length=32, null=True, verbose_name='P Code')),
                ('geom', django.contrib.gis.db.models.fields.MultiPolygonField(
                    blank=True, null=True, srid=4326, verbose_name='Geo Point')),
                ('point', django.contrib.gis.db.models.fields.PointField(
                    blank=True, null=True, srid=4326, verbose_name='Point')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('gateway', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                              to='locations.GatewayType', verbose_name='Location Type')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True,
                                                      on_delete=django.db.models.deletion.CASCADE,
                                                      related_name='children',
                                                      to='locations.Location', verbose_name='Parent')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='cartodbtable',
            name='location_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='locations.GatewayType', verbose_name='Location Type'),
        ),
        migrations.AddField(
            model_name='cartodbtable',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, null=True,
                                             on_delete=django.db.models.deletion.CASCADE,
                                             related_name='children',
                                             to='locations.CartoDBTable', verbose_name='Parent'),
        ),
        migrations.AlterUniqueTogether(
            name='location',
            unique_together=set([('name', 'gateway', 'p_code')]),
        ),
    ]
