# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *
import pulumi_aws

__all__ = [
    'DockerBuildArgs',
    'FunctionScheduleArgs',
    'FunctionUrlArgs',
]

@pulumi.input_type
class DockerBuildArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[str]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] architecture: Architecture, either `X86_64` or `ARM64`. Defaults to `X86_64`
        :param pulumi.Input[str] context: The path to the build context to use.
        :param pulumi.Input[str] dockerfile: The path to the Dockerfile to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env: Environment variables to set on the invocation of docker build, for example to support DOCKER_BUILDKIT=1 docker build.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extra_options: A bag of extra options to pass on to the docker SDK.
        :param pulumi.Input[str] target: The target of the Dockerfile to build
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if extra_options is not None:
            pulumi.set(__self__, "extra_options", extra_options)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Architecture, either `X86_64` or `ARM64`. Defaults to `X86_64`
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the build context to use.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the Dockerfile to use.
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables to set on the invocation of docker build, for example to support DOCKER_BUILDKIT=1 docker build.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="extraOptions")
    def extra_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A bag of extra options to pass on to the docker SDK.
        """
        return pulumi.get(self, "extra_options")

    @extra_options.setter
    def extra_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extra_options", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The target of the Dockerfile to build
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class FunctionScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[str],
                 schedule_input: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] schedule_expression: Expression for creating a cloudwatch event rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] schedule_input: Input for cloudwatch event target.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_input is not None:
            pulumi.set(__self__, "schedule_input", schedule_input)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[str]:
        """
        Expression for creating a cloudwatch event rule.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="scheduleInput")
    def schedule_input(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Input for cloudwatch event target.
        """
        return pulumi.get(self, "schedule_input")

    @schedule_input.setter
    def schedule_input(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "schedule_input", value)


@pulumi.input_type
class FunctionUrlArgs:
    def __init__(__self__, *,
                 cors_configuration: Optional[pulumi.Input['pulumi_aws.lambda_.FunctionUrlCorsArgs']] = None,
                 url_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['pulumi_aws.lambda_.FunctionUrlCorsArgs'] cors_configuration: CORS Configuration.
        :param pulumi.Input[bool] url_enabled: Use Lambda URL. Defaults to `false`
        """
        if cors_configuration is not None:
            pulumi.set(__self__, "cors_configuration", cors_configuration)
        if url_enabled is not None:
            pulumi.set(__self__, "url_enabled", url_enabled)

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> Optional[pulumi.Input['pulumi_aws.lambda_.FunctionUrlCorsArgs']]:
        """
        CORS Configuration.
        """
        return pulumi.get(self, "cors_configuration")

    @cors_configuration.setter
    def cors_configuration(self, value: Optional[pulumi.Input['pulumi_aws.lambda_.FunctionUrlCorsArgs']]):
        pulumi.set(self, "cors_configuration", value)

    @property
    @pulumi.getter(name="urlEnabled")
    def url_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Use Lambda URL. Defaults to `false`
        """
        return pulumi.get(self, "url_enabled")

    @url_enabled.setter
    def url_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "url_enabled", value)


