# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 expire_in_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[int] expire_in_days: Number of days for expiring images using LifecyclePolicy.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] name_prefix: Name prefix as an alternative to name and adds random suffix at the end.
        """
        if expire_in_days is not None:
            pulumi.set(__self__, "expire_in_days", expire_in_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)

    @property
    @pulumi.getter(name="expireInDays")
    def expire_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days for expiring images using LifecyclePolicy.
        """
        return pulumi.get(self, "expire_in_days")

    @expire_in_days.setter
    def expire_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire_in_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Name prefix as an alternative to name and adds random suffix at the end.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)


class Repository(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expire_in_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates ECR Repository with a lifecycle policy. `url` output of this component can be used within container function to push your images.

        ## Example Usage
        ### Basic Example

        ```python
        import pulumi_nuage as nuage
        
        repository = nuage.aws.Repository(
            "foo",
            name="repository",
            expire_in_days=30,
        )
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] expire_in_days: Number of days for expiring images using LifecyclePolicy.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] name_prefix: Name prefix as an alternative to name and adds random suffix at the end.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RepositoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates ECR Repository with a lifecycle policy. `url` output of this component can be used within container function to push your images.

        ## Example Usage
        ### Basic Example

        ```python
        import pulumi_nuage as nuage
        
        repository = nuage.aws.Repository(
            "foo",
            name="repository",
            expire_in_days=30,
        )
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expire_in_days: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["expire_in_days"] = expire_in_days
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["arn"] = None
            __props__.__dict__["id"] = None
            __props__.__dict__["registry_id"] = None
            __props__.__dict__["url"] = None
        super(Repository, __self__).__init__(
            'nuage:aws:Repository',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN (Amazon Resource Name) of the repository
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> pulumi.Output[str]:
        """
        Id of the repository
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the repository
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def registry_id(self) -> pulumi.Output[str]:
        """
        Registry id of the repository
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL of the repository
        """
        return pulumi.get(self, "url")

