# Generated by Django 2.2.9 on 2020-04-09 18:24

import uuid

import django.db.models.deletion
import django.utils.timezone
import jsonfield.encoder
import jsonfield.fields
import model_utils.fields
from django.conf import settings
from django.db import migrations, models

import submissions.models


class Migration(migrations.Migration):

    replaces = [
        ('submissions', '0001_initial'),
        ('submissions', '0002_auto_20151119_0913'),
        ('submissions', '0003_submission_status'),
        ('submissions', '0004_remove_django_extensions'),
        ('submissions', '0005_CreateTeamModel')
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Score',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('points_earned', models.PositiveIntegerField(default=0)),
                ('points_possible', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(
                    db_index=True, default=django.utils.timezone.now, editable=False)),
                ('reset', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='StudentItem',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('student_id', submissions.models.AnonymizedUserIDField()),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('item_id', models.CharField(db_index=True, max_length=255)),
                ('item_type', models.CharField(max_length=100)),
            ],
            options={
                'unique_together': {('course_id', 'student_id', 'item_id')},
            },
        ),
        migrations.CreateModel(
            name='Submission',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4)),
                ('attempt_number', models.PositiveIntegerField()),
                ('submitted_at', models.DateTimeField(
                    db_index=True, default=django.utils.timezone.now)),
                ('created_at', models.DateTimeField(
                    db_index=True, default=django.utils.timezone.now, editable=False)),
                ('answer', jsonfield.fields.JSONField(
                    blank=True,
                    db_column='raw_answer',)),
                ('student_item', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='submissions.StudentItem')),
                ('status', models.CharField(choices=[('D', 'Deleted'), ('A', 'Active')], default='A', max_length=1)),
            ],
            options={
                'ordering': ['-submitted_at', '-id'],
            },
        ),
        migrations.CreateModel(
            name='ScoreSummary',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('highest', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, related_name='+', to='submissions.Score')),
                ('latest', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, related_name='+', to='submissions.Score')),
                ('student_item', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE, to='submissions.StudentItem')),
            ],
            options={
                'verbose_name_plural': 'Score Summaries',
            },
        ),
        migrations.AddField(
            model_name='score',
            name='student_item',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='submissions.StudentItem'),
        ),
        migrations.AddField(
            model_name='score',
            name='submission',
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to='submissions.Submission'),
        ),
        migrations.CreateModel(
            name='ScoreAnnotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('annotation_type', models.CharField(db_index=True, max_length=255)),
                ('creator', submissions.models.AnonymizedUserIDField()),
                ('reason', models.TextField()),
                ('score', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='submissions.Score')),
            ],
        ),
        migrations.CreateModel(
            name='TeamSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4)),
                ('attempt_number', models.PositiveIntegerField()),
                ('submitted_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('item_id', models.CharField(db_index=True, max_length=255)),
                ('team_id', models.CharField(db_index=True, max_length=255)),
                ('status', models.CharField(choices=[('D', 'Deleted'), ('A', 'Active')], default='A', max_length=1)),
                ('submitted_by', models.ForeignKey(
                    null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-submitted_at', '-id'],
            },
        ),
        migrations.AddField(
            model_name='submission',
            name='team_submission',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='submissions',
                to='submissions.TeamSubmission'
            ),
        ),
    ]
