"""
Main interface for iotanalytics service.

Usage::

    import boto3
    from mypy_boto3.iotanalytics import (
        Client,
        IoTAnalyticsClient,
        ListChannelsPaginator,
        ListDatasetContentsPaginator,
        ListDatasetsPaginator,
        ListDatastoresPaginator,
        ListPipelinesPaginator,
        )

    session = boto3.Session()

    client: IoTAnalyticsClient = boto3.client("iotanalytics")
    session_client: IoTAnalyticsClient = session.client("iotanalytics")

    list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
    list_dataset_contents_paginator: ListDatasetContentsPaginator = client.get_paginator("list_dataset_contents")
    list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
    list_datastores_paginator: ListDatastoresPaginator = client.get_paginator("list_datastores")
    list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
"""
from mypy_boto3_iotanalytics.client import IoTAnalyticsClient, IoTAnalyticsClient as Client
from mypy_boto3_iotanalytics.paginator import (
    ListChannelsPaginator,
    ListDatasetContentsPaginator,
    ListDatasetsPaginator,
    ListDatastoresPaginator,
    ListPipelinesPaginator,
)


__all__ = (
    "Client",
    "IoTAnalyticsClient",
    "ListChannelsPaginator",
    "ListDatasetContentsPaginator",
    "ListDatasetsPaginator",
    "ListDatastoresPaginator",
    "ListPipelinesPaginator",
)
