--
-- PostgreSQL database dump
--

-- Dumped from database version 12.9 (Debian 12.9-1.pgdg110+1)
-- Dumped by pg_dump version 12.9 (Ubuntu 12.9-0ubuntu0.20.04.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: agdc; Type: SCHEMA; Schema: -; Owner: agdc_admin
--

CREATE SCHEMA agdc;


ALTER SCHEMA agdc OWNER TO agdc_admin;

--
-- Name: tiger; Type: SCHEMA; Schema: -; Owner: localuser
--

CREATE SCHEMA tiger;


ALTER SCHEMA tiger OWNER TO localuser;

--
-- Name: tiger_data; Type: SCHEMA; Schema: -; Owner: localuser
--

CREATE SCHEMA tiger_data;


ALTER SCHEMA tiger_data OWNER TO localuser;

--
-- Name: topology; Type: SCHEMA; Schema: -; Owner: localuser
--

CREATE SCHEMA topology;


ALTER SCHEMA topology OWNER TO localuser;

--
-- Name: SCHEMA topology; Type: COMMENT; Schema: -; Owner: localuser
--

COMMENT ON SCHEMA topology IS 'PostGIS Topology schema';


--
-- Name: wms; Type: SCHEMA; Schema: -; Owner: localuser
--

CREATE SCHEMA wms;


ALTER SCHEMA wms OWNER TO localuser;

--
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- Name: postgis_tiger_geocoder; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_tiger_geocoder WITH SCHEMA tiger;


--
-- Name: EXTENSION postgis_tiger_geocoder; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_tiger_geocoder IS 'PostGIS tiger geocoder and reverse geocoder';


--
-- Name: postgis_topology; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_topology WITH SCHEMA topology;


--
-- Name: EXTENSION postgis_topology; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_topology IS 'PostGIS topology spatial types and functions';


--
-- Name: float8range; Type: TYPE; Schema: agdc; Owner: agdc_admin
--

CREATE TYPE agdc.float8range AS RANGE (
    subtype = double precision,
    subtype_diff = float8mi
);


ALTER TYPE agdc.float8range OWNER TO agdc_admin;

--
-- Name: common_timestamp(text); Type: FUNCTION; Schema: agdc; Owner: agdc_admin
--

CREATE FUNCTION agdc.common_timestamp(text) RETURNS timestamp with time zone
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$
select ($1)::timestamp at time zone 'utc';
$_$;


ALTER FUNCTION agdc.common_timestamp(text) OWNER TO agdc_admin;

--
-- Name: set_row_update_time(); Type: FUNCTION; Schema: agdc; Owner: agdc_admin
--

CREATE FUNCTION agdc.set_row_update_time() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
begin
  new.updated = now();
  return new;
end;
$$;


ALTER FUNCTION agdc.set_row_update_time() OWNER TO agdc_admin;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: dataset; Type: TABLE; Schema: agdc; Owner: agdc_admin
--

CREATE TABLE agdc.dataset (
    id uuid NOT NULL,
    metadata_type_ref smallint NOT NULL,
    dataset_type_ref smallint NOT NULL,
    metadata jsonb NOT NULL,
    archived timestamp with time zone,
    added timestamp with time zone DEFAULT now() NOT NULL,
    added_by name DEFAULT CURRENT_USER NOT NULL,
    updated timestamp with time zone
);


ALTER TABLE agdc.dataset OWNER TO agdc_admin;

--
-- Name: dataset_location; Type: TABLE; Schema: agdc; Owner: agdc_admin
--

CREATE TABLE agdc.dataset_location (
    id integer NOT NULL,
    dataset_ref uuid NOT NULL,
    uri_scheme character varying NOT NULL,
    uri_body character varying NOT NULL,
    added timestamp with time zone DEFAULT now() NOT NULL,
    added_by name DEFAULT CURRENT_USER NOT NULL,
    archived timestamp with time zone
);


ALTER TABLE agdc.dataset_location OWNER TO agdc_admin;

--
-- Name: dataset_location_id_seq; Type: SEQUENCE; Schema: agdc; Owner: agdc_admin
--

CREATE SEQUENCE agdc.dataset_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agdc.dataset_location_id_seq OWNER TO agdc_admin;

--
-- Name: dataset_location_id_seq; Type: SEQUENCE OWNED BY; Schema: agdc; Owner: agdc_admin
--

ALTER SEQUENCE agdc.dataset_location_id_seq OWNED BY agdc.dataset_location.id;


--
-- Name: dataset_source; Type: TABLE; Schema: agdc; Owner: agdc_admin
--

CREATE TABLE agdc.dataset_source (
    dataset_ref uuid NOT NULL,
    classifier character varying NOT NULL,
    source_dataset_ref uuid NOT NULL
);


ALTER TABLE agdc.dataset_source OWNER TO agdc_admin;

--
-- Name: dataset_type; Type: TABLE; Schema: agdc; Owner: agdc_admin
--

CREATE TABLE agdc.dataset_type (
    id smallint NOT NULL,
    name character varying NOT NULL,
    metadata jsonb NOT NULL,
    metadata_type_ref smallint NOT NULL,
    definition jsonb NOT NULL,
    added timestamp with time zone DEFAULT now() NOT NULL,
    added_by name DEFAULT CURRENT_USER NOT NULL,
    updated timestamp with time zone,
    CONSTRAINT ck_dataset_type_alphanumeric_name CHECK (((name)::text ~* '^\w+$'::text))
);


ALTER TABLE agdc.dataset_type OWNER TO agdc_admin;

--
-- Name: dataset_type_id_seq; Type: SEQUENCE; Schema: agdc; Owner: agdc_admin
--

CREATE SEQUENCE agdc.dataset_type_id_seq
    AS smallint
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agdc.dataset_type_id_seq OWNER TO agdc_admin;

--
-- Name: dataset_type_id_seq; Type: SEQUENCE OWNED BY; Schema: agdc; Owner: agdc_admin
--

ALTER SEQUENCE agdc.dataset_type_id_seq OWNED BY agdc.dataset_type.id;


--
-- Name: metadata_type; Type: TABLE; Schema: agdc; Owner: agdc_admin
--

CREATE TABLE agdc.metadata_type (
    id smallint NOT NULL,
    name character varying NOT NULL,
    definition jsonb NOT NULL,
    added timestamp with time zone DEFAULT now() NOT NULL,
    added_by name DEFAULT CURRENT_USER NOT NULL,
    updated timestamp with time zone,
    CONSTRAINT ck_metadata_type_alphanumeric_name CHECK (((name)::text ~* '^\w+$'::text))
);


ALTER TABLE agdc.metadata_type OWNER TO agdc_admin;

--
-- Name: dv_eo3_dataset; Type: VIEW; Schema: agdc; Owner: localuser
--

CREATE VIEW agdc.dv_eo3_dataset AS
 SELECT dataset.id,
    dataset.added AS indexed_time,
    dataset.added_by AS indexed_by,
    dataset_type.name AS product,
    dataset.dataset_type_ref AS dataset_type_id,
    metadata_type.name AS metadata_type,
    dataset.metadata_type_ref AS metadata_type_id,
    dataset.metadata AS metadata_doc,
    agdc.common_timestamp((dataset.metadata #>> '{properties,odc:processing_datetime}'::text[])) AS creation_time,
    (dataset.metadata #>> '{properties,odc:file_format}'::text[]) AS format,
    (dataset.metadata #>> '{label}'::text[]) AS label,
    agdc.float8range(((dataset.metadata #>> '{extent,lat,begin}'::text[]))::double precision, ((dataset.metadata #>> '{extent,lat,end}'::text[]))::double precision, '[]'::text) AS lat,
    agdc.float8range(((dataset.metadata #>> '{extent,lon,begin}'::text[]))::double precision, ((dataset.metadata #>> '{extent,lon,end}'::text[]))::double precision, '[]'::text) AS lon,
    tstzrange(LEAST(agdc.common_timestamp((dataset.metadata #>> '{properties,dtr:start_datetime}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{properties,datetime}'::text[]))), GREATEST(agdc.common_timestamp((dataset.metadata #>> '{properties,dtr:end_datetime}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{properties,datetime}'::text[]))), '[]'::text) AS "time",
    (dataset.metadata #>> '{properties,eo:platform}'::text[]) AS platform,
    (dataset.metadata #>> '{properties,eo:instrument}'::text[]) AS instrument,
    ((dataset.metadata #>> '{properties,eo:cloud_cover}'::text[]))::double precision AS cloud_cover,
    (dataset.metadata #>> '{properties,odc:region_code}'::text[]) AS region_code,
    (dataset.metadata #>> '{properties,odc:product_family}'::text[]) AS product_family,
    (dataset.metadata #>> '{properties,dea:dataset_maturity}'::text[]) AS dataset_maturity
   FROM ((agdc.dataset
     JOIN agdc.dataset_type ON ((dataset_type.id = dataset.dataset_type_ref)))
     JOIN agdc.metadata_type ON ((metadata_type.id = dataset_type.metadata_type_ref)))
  WHERE ((dataset.archived IS NULL) AND (dataset.metadata_type_ref = 1));


ALTER TABLE agdc.dv_eo3_dataset OWNER TO localuser;

--
-- Name: dv_eo_dataset; Type: VIEW; Schema: agdc; Owner: localuser
--

CREATE VIEW agdc.dv_eo_dataset AS
 SELECT dataset.id,
    dataset.added AS indexed_time,
    dataset.added_by AS indexed_by,
    dataset_type.name AS product,
    dataset.dataset_type_ref AS dataset_type_id,
    metadata_type.name AS metadata_type,
    dataset.metadata_type_ref AS metadata_type_id,
    dataset.metadata AS metadata_doc,
    agdc.common_timestamp((dataset.metadata #>> '{creation_dt}'::text[])) AS creation_time,
    (dataset.metadata #>> '{format,name}'::text[]) AS format,
    (dataset.metadata #>> '{ga_label}'::text[]) AS label,
    agdc.float8range(LEAST(((dataset.metadata #>> '{extent,coord,ur,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,lr,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ul,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ll,lat}'::text[]))::double precision), GREATEST(((dataset.metadata #>> '{extent,coord,ur,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,lr,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ul,lat}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ll,lat}'::text[]))::double precision), '[]'::text) AS lat,
    agdc.float8range(LEAST(((dataset.metadata #>> '{extent,coord,ul,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ur,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ll,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,lr,lon}'::text[]))::double precision), GREATEST(((dataset.metadata #>> '{extent,coord,ul,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ur,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,ll,lon}'::text[]))::double precision, ((dataset.metadata #>> '{extent,coord,lr,lon}'::text[]))::double precision), '[]'::text) AS lon,
    tstzrange(LEAST(agdc.common_timestamp((dataset.metadata #>> '{extent,from_dt}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{extent,center_dt}'::text[]))), GREATEST(agdc.common_timestamp((dataset.metadata #>> '{extent,to_dt}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{extent,center_dt}'::text[]))), '[]'::text) AS "time",
    (dataset.metadata #>> '{platform,code}'::text[]) AS platform,
    (dataset.metadata #>> '{instrument,name}'::text[]) AS instrument,
    (dataset.metadata #>> '{product_type}'::text[]) AS product_type
   FROM ((agdc.dataset
     JOIN agdc.dataset_type ON ((dataset_type.id = dataset.dataset_type_ref)))
     JOIN agdc.metadata_type ON ((metadata_type.id = dataset_type.metadata_type_ref)))
  WHERE ((dataset.archived IS NULL) AND (dataset.metadata_type_ref = 2));


ALTER TABLE agdc.dv_eo_dataset OWNER TO localuser;

--
-- Name: dv_s2_l2a_dataset; Type: VIEW; Schema: agdc; Owner: localuser
--

CREATE VIEW agdc.dv_s2_l2a_dataset AS
 SELECT dataset.id,
    dataset.added AS indexed_time,
    dataset.added_by AS indexed_by,
    dataset_type.name AS product,
    dataset.dataset_type_ref AS dataset_type_id,
    metadata_type.name AS metadata_type,
    dataset.metadata_type_ref AS metadata_type_id,
    dataset.metadata AS metadata_doc,
    agdc.common_timestamp((dataset.metadata #>> '{properties,odc:processing_datetime}'::text[])) AS creation_time,
    (dataset.metadata #>> '{properties,odc:file_format}'::text[]) AS format,
    (dataset.metadata #>> '{label}'::text[]) AS label,
    agdc.float8range(((dataset.metadata #>> '{extent,lat,begin}'::text[]))::double precision, ((dataset.metadata #>> '{extent,lat,end}'::text[]))::double precision, '[]'::text) AS lat,
    agdc.float8range(((dataset.metadata #>> '{extent,lon,begin}'::text[]))::double precision, ((dataset.metadata #>> '{extent,lon,end}'::text[]))::double precision, '[]'::text) AS lon,
    tstzrange(LEAST(agdc.common_timestamp((dataset.metadata #>> '{properties,dtr:start_datetime}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{properties,datetime}'::text[]))), GREATEST(agdc.common_timestamp((dataset.metadata #>> '{properties,dtr:end_datetime}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{properties,datetime}'::text[]))), '[]'::text) AS "time",
    (dataset.metadata #>> '{properties,eo:platform}'::text[]) AS platform,
    (dataset.metadata #>> '{properties,eo:instrument}'::text[]) AS instrument,
    ((dataset.metadata #>> '{properties,eo:cloud_cover}'::text[]))::double precision AS cloud_cover,
    (dataset.metadata #>> '{properties,odc:region_code}'::text[]) AS region_code,
    (dataset.metadata #>> '{properties,odc:product_family}'::text[]) AS product_family,
    (dataset.metadata #>> '{properties,dea:dataset_maturity}'::text[]) AS dataset_maturity
   FROM ((agdc.dataset
     JOIN agdc.dataset_type ON ((dataset_type.id = dataset.dataset_type_ref)))
     JOIN agdc.metadata_type ON ((metadata_type.id = dataset_type.metadata_type_ref)))
  WHERE ((dataset.archived IS NULL) AND (dataset.dataset_type_ref = 1));


ALTER TABLE agdc.dv_s2_l2a_dataset OWNER TO localuser;

--
-- Name: dv_telemetry_dataset; Type: VIEW; Schema: agdc; Owner: localuser
--

CREATE VIEW agdc.dv_telemetry_dataset AS
 SELECT dataset.id,
    dataset.added AS indexed_time,
    dataset.added_by AS indexed_by,
    dataset_type.name AS product,
    dataset.dataset_type_ref AS dataset_type_id,
    metadata_type.name AS metadata_type,
    dataset.metadata_type_ref AS metadata_type_id,
    dataset.metadata AS metadata_doc,
    agdc.common_timestamp((dataset.metadata #>> '{creation_dt}'::text[])) AS creation_time,
    (dataset.metadata #>> '{format,name}'::text[]) AS format,
    (dataset.metadata #>> '{ga_label}'::text[]) AS label,
    (dataset.metadata #>> '{acquisition,groundstation,code}'::text[]) AS gsi,
    tstzrange(agdc.common_timestamp((dataset.metadata #>> '{acquisition,aos}'::text[])), agdc.common_timestamp((dataset.metadata #>> '{acquisition,los}'::text[])), '[]'::text) AS "time",
    ((dataset.metadata #>> '{acquisition,platform_orbit}'::text[]))::integer AS orbit,
    numrange((((dataset.metadata #>> '{image,satellite_ref_point_start,y}'::text[]))::integer)::numeric, (GREATEST(((dataset.metadata #>> '{image,satellite_ref_point_end,y}'::text[]))::integer, ((dataset.metadata #>> '{image,satellite_ref_point_start,y}'::text[]))::integer))::numeric, '[]'::text) AS sat_row,
    (dataset.metadata #>> '{platform,code}'::text[]) AS platform,
    numrange((((dataset.metadata #>> '{image,satellite_ref_point_start,x}'::text[]))::integer)::numeric, (GREATEST(((dataset.metadata #>> '{image,satellite_ref_point_end,x}'::text[]))::integer, ((dataset.metadata #>> '{image,satellite_ref_point_start,x}'::text[]))::integer))::numeric, '[]'::text) AS sat_path,
    (dataset.metadata #>> '{instrument,name}'::text[]) AS instrument,
    (dataset.metadata #>> '{product_type}'::text[]) AS product_type
   FROM ((agdc.dataset
     JOIN agdc.dataset_type ON ((dataset_type.id = dataset.dataset_type_ref)))
     JOIN agdc.metadata_type ON ((metadata_type.id = dataset_type.metadata_type_ref)))
  WHERE ((dataset.archived IS NULL) AND (dataset.metadata_type_ref = 3));


ALTER TABLE agdc.dv_telemetry_dataset OWNER TO localuser;

--
-- Name: metadata_type_id_seq; Type: SEQUENCE; Schema: agdc; Owner: agdc_admin
--

CREATE SEQUENCE agdc.metadata_type_id_seq
    AS smallint
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agdc.metadata_type_id_seq OWNER TO agdc_admin;

--
-- Name: metadata_type_id_seq; Type: SEQUENCE OWNED BY; Schema: agdc; Owner: agdc_admin
--

ALTER SEQUENCE agdc.metadata_type_id_seq OWNED BY agdc.metadata_type.id;


--
-- Name: space_view; Type: MATERIALIZED VIEW; Schema: public; Owner: localuser
--

CREATE MATERIALIZED VIEW public.space_view AS
 WITH metadata_lookup AS (
         SELECT metadata_type.id,
            metadata_type.name
           FROM agdc.metadata_type
        ), ranges AS (
         SELECT dataset.id,
            (dataset.metadata #>> '{extent,lat,begin}'::text[]) AS lat_begin,
            (dataset.metadata #>> '{extent,lat,end}'::text[]) AS lat_end,
            (dataset.metadata #>> '{extent,lon,begin}'::text[]) AS lon_begin,
            (dataset.metadata #>> '{extent,lon,end}'::text[]) AS lon_end
           FROM agdc.dataset
          WHERE ((dataset.metadata_type_ref IN ( SELECT metadata_lookup.id
                   FROM metadata_lookup
                  WHERE ((metadata_lookup.name)::text = 'eo3'::text))) AND (dataset.archived IS NULL))
        ), corners AS (
         SELECT dataset.id,
            (dataset.metadata #>> '{extent,coord,ll,lat}'::text[]) AS ll_lat,
            (dataset.metadata #>> '{extent,coord,ll,lon}'::text[]) AS ll_lon,
            (dataset.metadata #>> '{extent,coord,lr,lat}'::text[]) AS lr_lat,
            (dataset.metadata #>> '{extent,coord,lr,lon}'::text[]) AS lr_lon,
            (dataset.metadata #>> '{extent,coord,ul,lat}'::text[]) AS ul_lat,
            (dataset.metadata #>> '{extent,coord,ul,lon}'::text[]) AS ul_lon,
            (dataset.metadata #>> '{extent,coord,ur,lat}'::text[]) AS ur_lat,
            (dataset.metadata #>> '{extent,coord,ur,lon}'::text[]) AS ur_lon
           FROM agdc.dataset
          WHERE ((dataset.metadata_type_ref IN ( SELECT metadata_lookup.id
                   FROM metadata_lookup
                  WHERE ((metadata_lookup.name)::text = ANY ((ARRAY['eo'::character varying, 'eo_s2_nrt'::character varying, 'gqa_eo'::character varying, 'eo_plus'::character varying, 'boku'::character varying])::text[])))) AND (dataset.archived IS NULL))
        )
 SELECT ranges.id,
    (format('POLYGON(( %s %s, %s %s, %s %s, %s %s, %s %s))'::text, ranges.lon_begin, ranges.lat_begin, ranges.lon_end, ranges.lat_begin, ranges.lon_end, ranges.lat_end, ranges.lon_begin, ranges.lat_end, ranges.lon_begin, ranges.lat_begin))::public.geometry AS spatial_extent
   FROM ranges
UNION
 SELECT corners.id,
    (format('POLYGON(( %s %s, %s %s, %s %s, %s %s, %s %s))'::text, corners.ll_lon, corners.ll_lat, corners.lr_lon, corners.lr_lat, corners.ur_lon, corners.ur_lat, corners.ul_lon, corners.ul_lat, corners.ll_lon, corners.ll_lat))::public.geometry AS spatial_extent
   FROM corners
UNION
 SELECT dataset.id,
    public.st_transform(public.st_setsrid(public.st_geomfromgeojson((dataset.metadata #>> '{geometry}'::text[])), (substr((dataset.metadata #>> '{crs}'::text[]), 6))::integer), 4326) AS spatial_extent
   FROM agdc.dataset
  WHERE ((dataset.metadata_type_ref IN ( SELECT metadata_lookup.id
           FROM metadata_lookup
          WHERE ((metadata_lookup.name)::text = 'eo3_landsat_ard'::text))) AND (dataset.archived IS NULL))
  WITH NO DATA;


ALTER TABLE public.space_view OWNER TO localuser;

--
-- Name: time_view; Type: MATERIALIZED VIEW; Schema: public; Owner: localuser
--

CREATE MATERIALIZED VIEW public.time_view AS
 WITH metadata_lookup AS (
         SELECT metadata_type.id,
            metadata_type.name
           FROM agdc.metadata_type
        )
 SELECT dataset.dataset_type_ref,
    dataset.id,
        CASE
            WHEN (((dataset.metadata -> 'extent'::text) ->> 'from_dt'::text) IS NULL) THEN tstzrange(((((dataset.metadata -> 'extent'::text) ->> 'center_dt'::text))::timestamp without time zone)::timestamp with time zone, ((((dataset.metadata -> 'extent'::text) ->> 'center_dt'::text))::timestamp without time zone)::timestamp with time zone, '[]'::text)
            ELSE tstzrange(((((dataset.metadata -> 'extent'::text) ->> 'from_dt'::text))::timestamp without time zone)::timestamp with time zone, ((((dataset.metadata -> 'extent'::text) ->> 'to_dt'::text))::timestamp without time zone)::timestamp with time zone, '[]'::text)
        END AS temporal_extent
   FROM agdc.dataset
  WHERE ((dataset.metadata_type_ref IN ( SELECT metadata_lookup.id
           FROM metadata_lookup
          WHERE ((metadata_lookup.name)::text = ANY ((ARRAY['eo'::character varying, 'eo_s2_nrt'::character varying, 'gqa_eo'::character varying, 'eo_plus'::character varying])::text[])))) AND (dataset.archived IS NULL))
UNION
 SELECT dataset.dataset_type_ref,
    dataset.id,
    tstzrange(((COALESCE(((dataset.metadata -> 'properties'::text) ->> 'dtr:start_datetime'::text), ((dataset.metadata -> 'properties'::text) ->> 'datetime'::text)))::timestamp without time zone)::timestamp with time zone, (COALESCE((((dataset.metadata -> 'properties'::text) ->> 'dtr:end_datetime'::text))::timestamp without time zone, (((dataset.metadata -> 'properties'::text) ->> 'datetime'::text))::timestamp without time zone))::timestamp with time zone, '[]'::text) AS temporal_extent
   FROM agdc.dataset
  WHERE ((dataset.metadata_type_ref IN ( SELECT metadata_lookup.id
           FROM metadata_lookup
          WHERE ((metadata_lookup.name)::text = ANY ((ARRAY['eo3_landsat_ard'::character varying, 'eo3'::character varying])::text[])))) AND (dataset.archived IS NULL))
  WITH NO DATA;


ALTER TABLE public.time_view OWNER TO localuser;

--
-- Name: space_time_view; Type: MATERIALIZED VIEW; Schema: public; Owner: localuser
--

CREATE MATERIALIZED VIEW public.space_time_view AS
 SELECT space_view.id,
    time_view.dataset_type_ref,
    space_view.spatial_extent,
    time_view.temporal_extent
   FROM (public.space_view
     JOIN public.time_view ON ((space_view.id = time_view.id)))
  WITH NO DATA;


ALTER TABLE public.space_time_view OWNER TO localuser;

--
-- Name: multiproduct_ranges; Type: TABLE; Schema: wms; Owner: localuser
--

CREATE TABLE wms.multiproduct_ranges (
    wms_product_name character varying(128) NOT NULL,
    lat_min numeric NOT NULL,
    lat_max numeric NOT NULL,
    lon_min numeric NOT NULL,
    lon_max numeric NOT NULL,
    dates jsonb NOT NULL,
    bboxes jsonb NOT NULL
);


ALTER TABLE wms.multiproduct_ranges OWNER TO localuser;

--
-- Name: product_ranges; Type: TABLE; Schema: wms; Owner: localuser
--

CREATE TABLE wms.product_ranges (
    id smallint NOT NULL,
    lat_min numeric NOT NULL,
    lat_max numeric NOT NULL,
    lon_min numeric NOT NULL,
    lon_max numeric NOT NULL,
    dates jsonb NOT NULL,
    bboxes jsonb NOT NULL
);


ALTER TABLE wms.product_ranges OWNER TO localuser;

--
-- Name: sub_product_ranges; Type: TABLE; Schema: wms; Owner: localuser
--

CREATE TABLE wms.sub_product_ranges (
    product_id smallint NOT NULL,
    sub_product_id smallint NOT NULL,
    lat_min numeric NOT NULL,
    lat_max numeric NOT NULL,
    lon_min numeric NOT NULL,
    lon_max numeric NOT NULL,
    dates jsonb NOT NULL,
    bboxes jsonb NOT NULL
);


ALTER TABLE wms.sub_product_ranges OWNER TO localuser;

--
-- Name: dataset_location id; Type: DEFAULT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_location ALTER COLUMN id SET DEFAULT nextval('agdc.dataset_location_id_seq'::regclass);


--
-- Name: dataset_type id; Type: DEFAULT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_type ALTER COLUMN id SET DEFAULT nextval('agdc.dataset_type_id_seq'::regclass);


--
-- Name: metadata_type id; Type: DEFAULT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.metadata_type ALTER COLUMN id SET DEFAULT nextval('agdc.metadata_type_id_seq'::regclass);


--
-- Data for Name: dataset; Type: TABLE DATA; Schema: agdc; Owner: agdc_admin
--

COPY agdc.dataset (id, metadata_type_ref, dataset_type_ref, metadata, archived, added, added_by, updated) FROM stdin;
f100ac07-34f6-5744-81b4-20c828d566dc	1	1	{"id": "f100ac07-34f6-5744-81b4-20c828d566dc", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXD_20211231T035247", "extent": {"lat": {"end": -14.464246588370704, "begin": -15.46304701291189}, "lon": {"end": 124.95536475477229, "begin": 123.92789738058742}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:14:10.888Z", "updated": "2021-12-31T06:14:10.888Z", "datetime": "2021-12-31T02:01:38Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 40.72, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXD_20211231T035247", "sentinel:grid_square": "XD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:14:10.888Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XD/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8290240.0}, "lr": {"x": 709800.0, "y": 8290240.0}, "ul": {"x": 600000.0, "y": 8400040.0}, "ur": {"x": 709800.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.391216+00	localuser	\N
0559e840-6372-55d3-83b3-4749e8c7afc6	1	1	{"id": "0559e840-6372-55d3-83b3-4749e8c7afc6", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYE_20211231T035247", "extent": {"lat": {"end": -13.552058584450984, "begin": -14.553888007970453}, "lon": {"end": 125.87420997110432, "begin": 124.84791209279844}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:14:47.737Z", "updated": "2021-12-31T06:14:47.737Z", "datetime": "2021-12-31T02:01:20Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 33.54, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYE_20211231T035247", "sentinel:grid_square": "YE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:14:47.737Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.407614+00	localuser	\N
3675321d-92e9-5d5e-9df0-9e1b1939d7e5	1	1	{"id": "3675321d-92e9-5d5e-9df0-9e1b1939d7e5", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXF_20211231T035247", "extent": {"lat": {"end": -12.657006390818566, "begin": -13.655153200298894}, "lon": {"end": 124.93951216306945, "begin": 123.92116847063227}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591822.0], [601924.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:13:41.340Z", "updated": "2021-12-31T06:13:41.340Z", "datetime": "2021-12-31T02:01:09Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 79.21, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXF_20211231T035247", "sentinel:grid_square": "XF", "sentinel:data_coverage": 99.93, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:13:41.340Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591822.0], [601924.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.427527+00	localuser	\N
b394a831-1818-5e89-be4b-4a5b77aff92c	1	1	{"id": "b394a831-1818-5e89-be4b-4a5b77aff92c", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXE_20211231T035247", "extent": {"lat": {"end": -13.560932176423318, "begin": -14.559406653491093}, "lon": {"end": 124.94716787178676, "begin": 123.92427299922684}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:10:10.523Z", "updated": "2021-12-31T06:10:10.523Z", "datetime": "2021-12-31T02:01:23Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 45.03, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LXE_20211231T035247", "sentinel:grid_square": "XE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:10:10.523Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.433738+00	localuser	\N
2e41f815-502f-55d1-a619-33b7dee5137a	1	1	{"id": "2e41f815-502f-55d1-a619-33b7dee5137a", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWD_20211231T035247", "extent": {"lat": {"end": -14.470091817549374, "begin": -15.46483636147493}, "lon": {"end": 124.02331555793114, "begin": 123.27578475841808}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[529584.0, 8290241.0], [555223.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529584.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:08:19.535Z", "updated": "2021-12-31T06:08:19.535Z", "datetime": "2021-12-31T02:01:41Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 11.79, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWD_20211231T035247", "sentinel:grid_square": "WD", "sentinel:data_coverage": 61.36, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:08:19.535Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WD/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[529584.0, 8290241.0], [555223.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529584.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8290240.0}, "lr": {"x": 609780.0, "y": 8290240.0}, "ul": {"x": 499980.0, "y": 8400040.0}, "ur": {"x": 609780.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.435527+00	localuser	\N
0c231856-2813-5d15-86cf-934bd7b797bd	1	1	{"id": "0c231856-2813-5d15-86cf-934bd7b797bd", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYF_20211231T035247", "extent": {"lat": {"end": -12.648743894609575, "begin": -13.649990562209084}, "lon": {"end": 125.86291959423936, "begin": 124.84117523973727}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:10:50.947Z", "updated": "2021-12-31T06:10:50.947Z", "datetime": "2021-12-31T02:01:06Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYF_20211231T035247", "sentinel:grid_square": "YF", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:10:50.947Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YF/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8490220.0}, "lr": {"x": 809760.0, "y": 8490220.0}, "ul": {"x": 699960.0, "y": 8600020.0}, "ur": {"x": 809760.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.440596+00	localuser	\N
082027ee-135d-5610-849a-b3344ca9133a	1	1	{"id": "082027ee-135d-5610-849a-b3344ca9133a", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWE_20211231T035247", "extent": {"lat": {"end": -13.566398424069876, "begin": -14.56073221375927}, "lon": {"end": 124.0190234178553, "begin": 123.49128821317358}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[552924.0, 8390201.0], [578583.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [552924.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:06:05.445Z", "updated": "2021-12-31T06:06:05.445Z", "datetime": "2021-12-31T02:01:26Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 49.37, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWE_20211231T035247", "sentinel:grid_square": "WE", "sentinel:data_coverage": 40.1, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:06:05.445Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[552924.0, 8390201.0], [578583.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [552924.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.441096+00	localuser	\N
2598eefb-6741-5d20-bb8b-de87f0daee38	1	1	{"id": "2598eefb-6741-5d20-bb8b-de87f0daee38", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWF_20211231T035247", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.655872806088993}, "lon": {"end": 124.01501468065466, "begin": 123.7055256786934}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[576304.0, 8490221.0], [601923.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576304.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:03:24.629Z", "updated": "2021-12-31T06:03:24.629Z", "datetime": "2021-12-31T02:01:13Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 91.11, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LWF_20211231T035247", "sentinel:grid_square": "WF", "sentinel:data_coverage": 18.82, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:03:24.629Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[576304.0, 8490221.0], [601923.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576304.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.45651+00	localuser	\N
fc80c80d-b4e2-56a6-866b-e6cb53fec07c	1	1	{"id": "fc80c80d-b4e2-56a6-866b-e6cb53fec07c", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYD_20211231T035247", "extent": {"lat": {"end": -14.454757819240648, "begin": -15.457169776670924}, "lon": {"end": 125.88629831928218, "begin": 124.85515458012951}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-31T06:16:03.959Z", "updated": "2021-12-31T06:16:03.959Z", "datetime": "2021-12-31T02:01:35Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 62.23, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211231T015619_N0301_R117_T51LYD_20211231T035247", "sentinel:grid_square": "YD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-31T06:16:03.959Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/31/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/31/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YD/2021/12/31/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8290240.0}, "lr": {"x": 809760.0, "y": 8290240.0}, "ul": {"x": 699960.0, "y": 8400040.0}, "ur": {"x": 809760.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:16:30.451266+00	localuser	\N
eccac1bd-2e68-5f97-9f7a-f8b6a231ff5d	1	1	{"id": "eccac1bd-2e68-5f97-9f7a-f8b6a231ff5d", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWF_20220110T035000", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.655867014718263}, "lon": {"end": 124.01501468065466, "begin": 123.70755974353668}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[576524.0, 8490221.0], [602143.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576524.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T05:35:30.486Z", "updated": "2022-01-10T05:35:30.486Z", "datetime": "2022-01-10T02:01:13Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 8.33, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWF_20220110T035000", "sentinel:grid_square": "WF", "sentinel:data_coverage": 18.62, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T05:35:30.486Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[576524.0, 8490221.0], [602143.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576524.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.290884+00	localuser	\N
f20d08eb-48f5-5825-8dfd-834ecb11d76c	1	1	{"id": "f20d08eb-48f5-5825-8dfd-834ecb11d76c", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYD_20220110T035000", "extent": {"lat": {"end": -14.454757819240648, "begin": -15.457169776670924}, "lon": {"end": 125.88629831928218, "begin": 124.85515458012951}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T05:47:21.369Z", "updated": "2022-01-10T05:47:21.369Z", "datetime": "2022-01-10T02:01:35Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 5.24, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYD_20220110T035000", "sentinel:grid_square": "YD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T05:47:21.369Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YD/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8290240.0}, "lr": {"x": 809760.0, "y": 8290240.0}, "ul": {"x": 699960.0, "y": 8400040.0}, "ur": {"x": 809760.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.414968+00	localuser	\N
bab71dec-59bc-57ce-b998-49ef9af03dca	1	1	{"id": "bab71dec-59bc-57ce-b998-49ef9af03dca", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXD_20220110T035000", "extent": {"lat": {"end": -14.464246588370704, "begin": -15.46304701291189}, "lon": {"end": 124.95536475477229, "begin": 123.92789738058742}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T05:46:50.355Z", "updated": "2022-01-10T05:46:50.355Z", "datetime": "2022-01-10T02:01:38Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 3.76, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXD_20220110T035000", "sentinel:grid_square": "XD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T05:46:50.355Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XD/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8290240.0}, "lr": {"x": 709800.0, "y": 8290240.0}, "ul": {"x": 600000.0, "y": 8400040.0}, "ur": {"x": 709800.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.485353+00	localuser	\N
4a9ed666-e0e2-51ba-9afc-c5c994d828cd	1	1	{"id": "4a9ed666-e0e2-51ba-9afc-c5c994d828cd", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWD_20220110T035000", "extent": {"lat": {"end": -14.470091817549374, "begin": -15.464833331286973}, "lon": {"end": 124.02331555793114, "begin": 123.27820848181442}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[529844.0, 8290241.0], [555463.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529844.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T06:05:33.392Z", "updated": "2022-01-10T06:05:33.392Z", "datetime": "2022-01-10T02:01:41Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 1.8, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWD_20220110T035000", "sentinel:grid_square": "WD", "sentinel:data_coverage": 61.13, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T06:05:33.392Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WD/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[529844.0, 8290241.0], [555463.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529844.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8290240.0}, "lr": {"x": 609780.0, "y": 8290240.0}, "ul": {"x": 499980.0, "y": 8400040.0}, "ur": {"x": 609780.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.445054+00	localuser	\N
c5374f05-5a0d-58a7-addf-be6982496fac	1	1	{"id": "c5374f05-5a0d-58a7-addf-be6982496fac", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LXE_20220108T040036", "extent": {"lat": {"end": -13.566453749061319, "begin": -13.900874008100173}, "lon": {"end": 124.00093271931105, "begin": 123.92519717778804}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600111.0, 8463042.0], [600101.0, 8499999.0], [608296.0, 8499999.0], [600111.0, 8463042.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-08T06:03:06.901Z", "updated": "2022-01-08T06:03:06.901Z", "datetime": "2022-01-08T02:11:19Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 38.9, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LXE_20220108T040036", "sentinel:grid_square": "XE", "sentinel:data_coverage": 1.26, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-08T06:03:06.901Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/8/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/8/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2022/1/8/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600111.0, 8463042.0], [600101.0, 8499999.0], [608296.0, 8499999.0], [600111.0, 8463042.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.493526+00	localuser	\N
f1f53acc-7396-52f9-8f78-a56c21d98343	1	1	{"id": "f1f53acc-7396-52f9-8f78-a56c21d98343", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWD_20220105T034941", "extent": {"lat": {"end": -14.470091817549374, "begin": -15.464832628247612}, "lon": {"end": 124.02331555793114, "begin": 123.27876780252221}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[529904.0, 8290241.0], [555543.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529904.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:41:42.500Z", "updated": "2022-01-05T05:41:42.500Z", "datetime": "2022-01-05T02:01:47Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWD_20220105T034941", "sentinel:grid_square": "WD", "sentinel:data_coverage": 61.07, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:41:42.500Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WD/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[529904.0, 8290241.0], [555543.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529904.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8290240.0}, "lr": {"x": 609780.0, "y": 8290240.0}, "ul": {"x": 499980.0, "y": 8400040.0}, "ur": {"x": 609780.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.512513+00	localuser	\N
68c20d9e-89d7-5488-9bbe-f75b248b5000	1	1	{"id": "68c20d9e-89d7-5488-9bbe-f75b248b5000", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXE_20220110T035000", "extent": {"lat": {"end": -13.560932176423318, "begin": -14.559406653491093}, "lon": {"end": 124.94716787178676, "begin": 123.92427299922684}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T05:52:30.254Z", "updated": "2022-01-10T05:52:30.254Z", "datetime": "2022-01-10T02:01:24Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 0.91, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXE_20220110T035000", "sentinel:grid_square": "XE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T05:52:30.254Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.519212+00	localuser	\N
567cd3a2-8936-5d04-9770-3e81540e9b93	1	1	{"id": "567cd3a2-8936-5d04-9770-3e81540e9b93", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWE_20220110T035000", "extent": {"lat": {"end": -13.566398424069876, "begin": -14.56072713372194}, "lon": {"end": 124.0190234178553, "begin": 123.49370170353379}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[553184.0, 8390201.0], [578823.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [553184.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T06:00:58.339Z", "updated": "2022-01-10T06:00:58.339Z", "datetime": "2022-01-10T02:01:27Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 4.79, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LWE_20220110T035000", "sentinel:grid_square": "WE", "sentinel:data_coverage": 39.87, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T06:00:58.339Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[553184.0, 8390201.0], [578823.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [553184.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.508716+00	localuser	\N
76854c3e-bf74-5397-8ff6-1574252434bb	1	1	{"id": "76854c3e-bf74-5397-8ff6-1574252434bb", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYE_20220110T035000", "extent": {"lat": {"end": -13.552058584450984, "begin": -14.553888007970453}, "lon": {"end": 125.87420997110432, "begin": 124.84791209279844}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T06:09:20.862Z", "updated": "2022-01-10T06:09:20.862Z", "datetime": "2022-01-10T02:01:20Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 0.71, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYE_20220110T035000", "sentinel:grid_square": "YE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T06:09:20.862Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.534899+00	localuser	\N
13271824-8842-5f89-bb81-8441a4e03357	1	1	{"id": "13271824-8842-5f89-bb81-8441a4e03357", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXF_20220110T035000", "extent": {"lat": {"end": -12.657006390818566, "begin": -13.655153200298894}, "lon": {"end": 124.93951216306945, "begin": 123.92120054597787}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8590840.0], [602143.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T06:07:59.299Z", "updated": "2022-01-10T06:07:59.299Z", "datetime": "2022-01-10T02:01:09Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 4.98, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LXF_20220110T035000", "sentinel:grid_square": "XF", "sentinel:data_coverage": 99.91, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T06:07:59.299Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8590840.0], [602143.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.632174+00	localuser	\N
af6222af-8d37-5a15-973e-647771f52998	1	1	{"id": "af6222af-8d37-5a15-973e-647771f52998", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LXF_20220103T040426", "extent": {"lat": {"end": -12.661304150007803, "begin": -13.655153200298894}, "lon": {"end": 124.20150535104617, "begin": 123.92090167395953}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630476.0, 8600019.0], [606057.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-03T06:11:47.696Z", "updated": "2022-01-03T06:11:47.696Z", "datetime": "2022-01-03T02:11:03Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.98, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LXF_20220103T040426", "sentinel:grid_square": "XF", "sentinel:data_coverage": 16.63, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-03T06:11:47.696Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/3/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/3/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2022/1/3/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630476.0, 8600019.0], [606057.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.717651+00	localuser	\N
d755c733-7ec5-57c8-84fe-1ac1090085e9	1	1	{"id": "d755c733-7ec5-57c8-84fe-1ac1090085e9", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYF_20220110T035000", "extent": {"lat": {"end": -12.648743894609575, "begin": -13.649990562209084}, "lon": {"end": 125.86291959423936, "begin": 124.84117523973727}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-10T06:06:15.983Z", "updated": "2022-01-10T06:06:15.983Z", "datetime": "2022-01-10T02:01:06Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 1.34, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220110T015619_N0301_R117_T51LYF_20220110T035000", "sentinel:grid_square": "YF", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-10T06:06:15.983Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2022/1/10/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2022/1/10/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YF/2022/1/10/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8490220.0}, "lr": {"x": 809760.0, "y": 8490220.0}, "ul": {"x": 699960.0, "y": 8600020.0}, "ur": {"x": 809760.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.563286+00	localuser	\N
d687a43f-5685-5d2e-936d-585deb8fb179	1	1	{"id": "d687a43f-5685-5d2e-936d-585deb8fb179", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWE_20220105T034941", "extent": {"lat": {"end": -13.566398424069876, "begin": -14.560725957870591}, "lon": {"end": 124.0190234178553, "begin": 123.49425866271484}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[553244.0, 8390201.0], [578883.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [553244.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:42:52.090Z", "updated": "2022-01-05T05:42:52.090Z", "datetime": "2022-01-05T02:01:32Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWE_20220105T034941", "sentinel:grid_square": "WE", "sentinel:data_coverage": 39.81, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:42:52.090Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[553244.0, 8390201.0], [578883.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [553244.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.625036+00	localuser	\N
b16487a5-3ec5-5536-9bc3-3e52d498347d	1	1	{"id": "b16487a5-3ec5-5536-9bc3-3e52d498347d", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LWE_20220108T040036", "extent": {"lat": {"end": -13.566453749061319, "begin": -14.561247992924196}, "lon": {"end": 124.00093271931105, "begin": 122.99982362258439}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608296.0, 8499999.0], [583977.0, 8390201.0], [499981.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-08T06:15:01.659Z", "updated": "2022-01-08T06:15:01.659Z", "datetime": "2022-01-08T02:11:27Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 25.72, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LWE_20220108T040036", "sentinel:grid_square": "WE", "sentinel:data_coverage": 87.57, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-08T06:15:01.659Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/8/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/8/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2022/1/8/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608296.0, 8499999.0], [583977.0, 8390201.0], [499981.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.633651+00	localuser	\N
7d3c4c52-1eee-5916-9f52-4d0bbea64217	1	1	{"id": "7d3c4c52-1eee-5916-9f52-4d0bbea64217", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXD_20220105T034941", "extent": {"lat": {"end": -14.464246588370704, "begin": -15.46304701291189}, "lon": {"end": 124.95536475477229, "begin": 123.92789738058742}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:49:50.903Z", "updated": "2022-01-05T05:49:50.903Z", "datetime": "2022-01-05T02:01:44Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXD_20220105T034941", "sentinel:grid_square": "XD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:49:50.903Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XD/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8290240.0}, "lr": {"x": 709800.0, "y": 8290240.0}, "ul": {"x": 600000.0, "y": 8400040.0}, "ur": {"x": 709800.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.76812+00	localuser	\N
b86c7ae4-5868-51e6-b9f3-a7ee02408587	1	1	{"id": "b86c7ae4-5868-51e6-b9f3-a7ee02408587", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LXF_20220108T040036", "extent": {"lat": {"end": -12.661301239881922, "begin": -13.655153200298894}, "lon": {"end": 124.20214985553751, "begin": 123.92090167395953}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630546.0, 8600019.0], [606137.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-08T06:05:47.210Z", "updated": "2022-01-08T06:05:47.210Z", "datetime": "2022-01-08T02:11:08Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 97.44, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LXF_20220108T040036", "sentinel:grid_square": "XF", "sentinel:data_coverage": 16.7, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-08T06:05:47.210Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/8/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/8/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2022/1/8/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630546.0, 8600019.0], [606137.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.687217+00	localuser	\N
8b50107b-2489-5454-87f6-626adac36985	1	1	{"id": "8b50107b-2489-5454-87f6-626adac36985", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYE_20220105T034941", "extent": {"lat": {"end": -13.552058584450984, "begin": -14.553888007970453}, "lon": {"end": 125.87420997110432, "begin": 124.84791209279844}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:49:50.070Z", "updated": "2022-01-05T05:49:50.070Z", "datetime": "2022-01-05T02:01:26Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 96.76, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYE_20220105T034941", "sentinel:grid_square": "YE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:49:50.070Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.781894+00	localuser	\N
f9313945-9481-5131-aec6-f60db2592d37	1	1	{"id": "f9313945-9481-5131-aec6-f60db2592d37", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LXE_20220103T040426", "extent": {"lat": {"end": -13.566456341902722, "begin": -13.897456554521275}, "lon": {"end": 124.00028580959213, "begin": 123.92519717778804}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600111.0, 8463420.0], [600101.0, 8499999.0], [608226.0, 8499999.0], [600111.0, 8463420.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-03T06:04:57.106Z", "updated": "2022-01-03T06:04:57.106Z", "datetime": "2022-01-03T02:11:13Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.93, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LXE_20220103T040426", "sentinel:grid_square": "XE", "sentinel:data_coverage": 1.23, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-03T06:04:57.106Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/3/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/3/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2022/1/3/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600111.0, 8463420.0], [600101.0, 8499999.0], [608226.0, 8499999.0], [600111.0, 8463420.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.928518+00	localuser	\N
57ce5b73-4465-5bf8-a73c-acf1fbec6703	1	1	{"id": "57ce5b73-4465-5bf8-a73c-acf1fbec6703", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXE_20211226T034934", "extent": {"lat": {"end": -13.560932176423318, "begin": -14.559406653491093}, "lon": {"end": 124.94716787178676, "begin": 123.92427299922684}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:50:43.911Z", "updated": "2021-12-26T05:50:43.911Z", "datetime": "2021-12-26T02:01:29Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXE_20211226T034934", "sentinel:grid_square": "XE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:50:43.911Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.035976+00	localuser	\N
74062a17-91b4-5793-94b7-982a7d3e05d5	1	1	{"id": "74062a17-91b4-5793-94b7-982a7d3e05d5", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYD_20220105T034941", "extent": {"lat": {"end": -14.454757819240648, "begin": -15.457169776670924}, "lon": {"end": 125.88629831928218, "begin": 124.85515458012951}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:50:06.032Z", "updated": "2022-01-05T05:50:06.032Z", "datetime": "2022-01-05T02:01:40Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 97.13, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYD_20220105T034941", "sentinel:grid_square": "YD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:50:06.032Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YD/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8290240.0}, "lr": {"x": 809760.0, "y": 8290240.0}, "ul": {"x": 699960.0, "y": 8400040.0}, "ur": {"x": 809760.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.690993+00	localuser	\N
93d69f62-0198-59de-ab21-08545bda863c	1	1	{"id": "93d69f62-0198-59de-ab21-08545bda863c", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LXE_20211229T040442", "extent": {"lat": {"end": -13.566464479923951, "begin": -13.888325258465198}, "lon": {"end": 123.99825266388078, "begin": 123.92519717778804}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600111.0, 8464430.0], [600101.0, 8499999.0], [608006.0, 8499999.0], [600111.0, 8464430.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-29T05:41:46.796Z", "updated": "2021-12-29T05:41:46.796Z", "datetime": "2021-12-29T02:11:19Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 96.1, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LXE_20211229T040442", "sentinel:grid_square": "XE", "sentinel:data_coverage": 1.17, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-29T05:41:46.796Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/29/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/29/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/29/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600111.0, 8464430.0], [600101.0, 8499999.0], [608006.0, 8499999.0], [600111.0, 8464430.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.846503+00	localuser	\N
4ee9ab65-0ec4-5112-a5cc-0d50df818790	1	1	{"id": "4ee9ab65-0ec4-5112-a5cc-0d50df818790", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXD_20211226T034934", "extent": {"lat": {"end": -14.464246588370704, "begin": -15.46304701291189}, "lon": {"end": 124.95536475477229, "begin": 123.92789738058742}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:50:32.228Z", "updated": "2021-12-26T05:50:32.228Z", "datetime": "2021-12-26T02:01:44Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXD_20211226T034934", "sentinel:grid_square": "XD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:50:32.228Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XD/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8290240.0}, "lr": {"x": 709800.0, "y": 8290240.0}, "ul": {"x": 600000.0, "y": 8400040.0}, "ur": {"x": 709800.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.035118+00	localuser	\N
48e120d4-fe2c-57f9-a390-41bb97a6796f	1	1	{"id": "48e120d4-fe2c-57f9-a390-41bb97a6796f", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LXE_20211224T040221", "extent": {"lat": {"end": -13.56645671217185, "begin": -13.89726669596073}, "lon": {"end": 124.00019339390695, "begin": 123.92519717778804}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600111.0, 8463441.0], [600101.0, 8499999.0], [608216.0, 8499999.0], [600111.0, 8463441.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-24T05:53:19.150Z", "updated": "2021-12-24T05:53:19.150Z", "datetime": "2021-12-24T02:11:12Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.98, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LXE_20211224T040221", "sentinel:grid_square": "XE", "sentinel:data_coverage": 1.23, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-24T05:53:19.150Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/24/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/24/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/24/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600111.0, 8463441.0], [600101.0, 8499999.0], [608216.0, 8499999.0], [600111.0, 8463441.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.086302+00	localuser	\N
bccd8707-2e40-50bf-98b3-410fe3388dee	1	1	{"id": "bccd8707-2e40-50bf-98b3-410fe3388dee", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LWF_20220108T040036", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.656875751592967}, "lon": {"end": 124.01438468787009, "begin": 122.99982431658114}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506611.0], [606137.0, 8490221.0], [499981.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-08T06:15:19.668Z", "updated": "2022-01-08T06:15:19.668Z", "datetime": "2022-01-08T02:11:13Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 93.58, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220108T020451_N0301_R017_T51LWF_20220108T040036", "sentinel:grid_square": "WF", "sentinel:data_coverage": 99.75, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-08T06:15:19.668Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/8/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/8/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2022/1/8/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506611.0], [606137.0, 8490221.0], [499981.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.745603+00	localuser	\N
7d6ac641-8687-564f-86fb-019bbf5186f2	1	1	{"id": "7d6ac641-8687-564f-86fb-019bbf5186f2", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYF_20211226T034934", "extent": {"lat": {"end": -12.648743894609575, "begin": -13.649990562209084}, "lon": {"end": 125.86291959423936, "begin": 124.84117523973727}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:46:14.755Z", "updated": "2021-12-26T05:46:14.755Z", "datetime": "2021-12-26T02:01:11Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYF_20211226T034934", "sentinel:grid_square": "YF", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:46:14.755Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YF/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8490220.0}, "lr": {"x": 809760.0, "y": 8490220.0}, "ul": {"x": 699960.0, "y": 8600020.0}, "ur": {"x": 809760.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.992853+00	localuser	\N
2e1776b5-3e28-52bc-906b-5b51eddc5a79	1	1	{"id": "2e1776b5-3e28-52bc-906b-5b51eddc5a79", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYD_20211221T035024", "extent": {"lat": {"end": -14.454757819240648, "begin": -15.457169776670924}, "lon": {"end": 125.88629831928218, "begin": 124.85515458012951}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:05:04.911Z", "updated": "2021-12-21T06:05:04.911Z", "datetime": "2021-12-21T02:01:33Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 46.14, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYD", "eo:constellation": "sentinel-2", "sentinel:sequence": "1", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYD_20211221T035024", "sentinel:grid_square": "YD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:05:04.911Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/21/1/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/21/1/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YD/2021/12/21/1/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8290240.0}, "lr": {"x": 809760.0, "y": 8290240.0}, "ul": {"x": 699960.0, "y": 8400040.0}, "ur": {"x": 809760.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.125699+00	localuser	\N
82bf9be0-a6e6-5c5d-a859-c3c81b57c43e	1	1	{"id": "82bf9be0-a6e6-5c5d-a859-c3c81b57c43e", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXF_20211221T035336", "extent": {"lat": {"end": -12.657006390818566, "begin": -13.655153200298894}, "lon": {"end": 124.93951216306945, "begin": 123.92118806572519}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591222.0], [602064.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:04:21.304Z", "updated": "2021-12-21T06:04:21.304Z", "datetime": "2021-12-21T02:01:08Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 98.67, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXF_20211221T035336", "sentinel:grid_square": "XF", "sentinel:data_coverage": 99.92, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:04:21.304Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591222.0], [602064.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.168359+00	localuser	\N
15bee446-0e53-55ab-a4f5-57b13cd72062	1	1	{"id": "15bee446-0e53-55ab-a4f5-57b13cd72062", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYF_20220105T034941", "extent": {"lat": {"end": -12.648743894609575, "begin": -13.649990562209084}, "lon": {"end": 125.86291959423936, "begin": 124.84117523973727}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:47:12.581Z", "updated": "2022-01-05T05:47:12.582Z", "datetime": "2022-01-05T02:01:11Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.9, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LYF_20220105T034941", "sentinel:grid_square": "YF", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:47:12.581Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YF/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8490220.0}, "lr": {"x": 809760.0, "y": 8490220.0}, "ul": {"x": 699960.0, "y": 8600020.0}, "ur": {"x": 809760.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.792457+00	localuser	\N
2018d676-fd91-504b-9adf-9c8fa174200f	1	1	{"id": "2018d676-fd91-504b-9adf-9c8fa174200f", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWF_20220105T034941", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.655864904632331}, "lon": {"end": 124.01501468065466, "begin": 123.70829940324505}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[576604.0, 8490221.0], [602203.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576604.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:36:29.043Z", "updated": "2022-01-05T05:36:29.043Z", "datetime": "2022-01-05T02:01:19Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.99, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LWF_20220105T034941", "sentinel:grid_square": "WF", "sentinel:data_coverage": 18.56, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:36:29.043Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[576604.0, 8490221.0], [602203.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576604.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.804025+00	localuser	\N
410d4bee-9bb7-5675-9dbf-0cc8e0a69f02	1	1	{"id": "410d4bee-9bb7-5675-9dbf-0cc8e0a69f02", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LWE_20220103T040426", "extent": {"lat": {"end": -13.566456341902722, "begin": -14.561247992924196}, "lon": {"end": 124.00028580959213, "begin": 122.99982362258439}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608226.0, 8499999.0], [583887.0, 8390201.0], [499981.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-03T06:22:22.141Z", "updated": "2022-01-03T06:22:22.141Z", "datetime": "2022-01-03T02:11:22Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.97, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LWE_20220103T040426", "sentinel:grid_square": "WE", "sentinel:data_coverage": 87.5, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-03T06:22:22.141Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/3/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2022/1/3/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2022/1/3/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608226.0, 8499999.0], [583887.0, 8390201.0], [499981.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.838149+00	localuser	\N
866add98-cf7d-5b74-8d70-d1b1c6191920	1	1	{"id": "866add98-cf7d-5b74-8d70-d1b1c6191920", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LWF_20211229T040442", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.656875751592967}, "lon": {"end": 124.01433313239129, "begin": 122.99982431658114}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8507961.0], [605837.0, 8490221.0], [499981.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-29T05:52:07.713Z", "updated": "2021-12-29T05:52:07.713Z", "datetime": "2021-12-29T02:11:13Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 87, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LWF_20211229T040442", "sentinel:grid_square": "WF", "sentinel:data_coverage": 99.71, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-29T05:52:07.713Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/29/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/29/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2021/12/29/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8507961.0], [605837.0, 8490221.0], [499981.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.924025+00	localuser	\N
231bb494-de14-57fd-8dfa-939b5e38ec57	1	1	{"id": "231bb494-de14-57fd-8dfa-939b5e38ec57", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXE_20220105T034941", "extent": {"lat": {"end": -13.560932176423318, "begin": -14.559406653491093}, "lon": {"end": 124.94716787178676, "begin": 123.92427299922684}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:51:33.525Z", "updated": "2022-01-05T05:51:33.525Z", "datetime": "2022-01-05T02:01:29Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXE_20220105T034941", "sentinel:grid_square": "XE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:51:33.525Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.784412+00	localuser	\N
d2719a0a-023a-5d7a-bcc3-837cafed8a92	1	1	{"id": "d2719a0a-023a-5d7a-bcc3-837cafed8a92", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWF_20211226T034934", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.655872280289566}, "lon": {"end": 124.01501468065466, "begin": 123.70571059371821}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[576324.0, 8490221.0], [601983.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576324.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:39:30.170Z", "updated": "2021-12-26T05:39:30.170Z", "datetime": "2021-12-26T02:01:19Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWF_20211226T034934", "sentinel:grid_square": "WF", "sentinel:data_coverage": 18.78, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:39:30.170Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[576324.0, 8490221.0], [601983.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576324.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.097026+00	localuser	\N
68eed379-1182-5f2c-9ec4-84c049c53670	1	1	{"id": "68eed379-1182-5f2c-9ec4-84c049c53670", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LXF_20211224T040221", "extent": {"lat": {"end": -12.661304150007803, "begin": -13.655153200298894}, "lon": {"end": 124.20150535104617, "begin": 123.92090167395953}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630476.0, 8600019.0], [606057.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-24T05:57:28.763Z", "updated": "2021-12-24T05:57:28.763Z", "datetime": "2021-12-24T02:11:02Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.84, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LXF_20211224T040221", "sentinel:grid_square": "XF", "sentinel:data_coverage": 16.63, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-24T05:57:28.763Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/24/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/24/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2021/12/24/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630476.0, 8600019.0], [606057.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.139987+00	localuser	\N
82cdfaa4-bee5-59c7-b5fd-3226c4664ecd	1	1	{"id": "82cdfaa4-bee5-59c7-b5fd-3226c4664ecd", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXF_20220105T034941", "extent": {"lat": {"end": -12.657006390818566, "begin": -13.655153200298894}, "lon": {"end": 124.93951216306945, "begin": 123.92120835616724}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8590601.0], [602203.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-05T05:52:15.241Z", "updated": "2022-01-05T05:52:15.241Z", "datetime": "2022-01-05T02:01:15Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.95, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20220105T015621_N0301_R117_T51LXF_20220105T034941", "sentinel:grid_square": "XF", "sentinel:data_coverage": 99.91, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-05T05:52:15.241Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/5/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2022/1/5/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2022/1/5/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8590601.0], [602203.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.833553+00	localuser	\N
ad85c2f5-2c3a-562d-92f6-b443df798bca	1	1	{"id": "ad85c2f5-2c3a-562d-92f6-b443df798bca", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LWF_20220103T040426", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.656875751592967}, "lon": {"end": 124.0143713167392, "begin": 122.99982431658114}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506961.0], [606057.0, 8490221.0], [499981.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2022-01-03T06:23:32.366Z", "updated": "2022-01-03T06:23:32.366Z", "datetime": "2022-01-03T02:11:08Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20220103T020439_N0301_R017_T51LWF_20220103T040426", "sentinel:grid_square": "WF", "sentinel:data_coverage": 99.74, "sentinel:latitude_band": "L", "odc:processing_datetime": "2022-01-03T06:23:32.366Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/3/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2022/1/3/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2022/1/3/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506961.0], [606057.0, 8490221.0], [499981.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.933019+00	localuser	\N
2bee7eb8-1ad3-5253-a345-bdaffb4ac238	1	1	{"id": "2bee7eb8-1ad3-5253-a345-bdaffb4ac238", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYE_20211226T034934", "extent": {"lat": {"end": -13.552058584450984, "begin": -14.553888007970453}, "lon": {"end": 125.87420997110432, "begin": 124.84791209279844}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:49:48.279Z", "updated": "2021-12-26T05:49:48.279Z", "datetime": "2021-12-26T02:01:26Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYE_20211226T034934", "sentinel:grid_square": "YE", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:49:48.279Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.034407+00	localuser	\N
911bd536-acec-5bc4-8b32-c3e97d97a7c5	1	1	{"id": "911bd536-acec-5bc4-8b32-c3e97d97a7c5", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWF_20211221T035336", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.655869122599963}, "lon": {"end": 124.01501468065466, "begin": 123.70682008370308}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[576444.0, 8490221.0], [602063.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576444.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:54:46.045Z", "updated": "2021-12-21T05:54:46.045Z", "datetime": "2021-12-21T02:01:12Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 98.66, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWF_20211221T035336", "sentinel:grid_square": "WF", "sentinel:data_coverage": 18.69, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:54:46.045Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[576444.0, 8490221.0], [602063.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8490221.0], [576444.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.105999+00	localuser	\N
d6b40607-1b2c-55ed-a40a-4c2fa81e5a26	1	1	{"id": "d6b40607-1b2c-55ed-a40a-4c2fa81e5a26", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYF_20211221T035336", "extent": {"lat": {"end": -12.648743894609575, "begin": -13.649990562209084}, "lon": {"end": 125.86291959423936, "begin": 124.84117523973727}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:03:31.565Z", "updated": "2021-12-21T06:03:31.565Z", "datetime": "2021-12-21T02:01:04Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.59, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYF_20211221T035336", "sentinel:grid_square": "YF", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:03:31.565Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YF/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YF/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8490221.0], [699961.0, 8600019.0], [809759.0, 8600019.0], [809759.0, 8490221.0], [699961.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8490220.0}, "lr": {"x": 809760.0, "y": 8490220.0}, "ul": {"x": 699960.0, "y": 8600020.0}, "ur": {"x": 809760.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.173797+00	localuser	\N
be2c04e6-5f42-5c50-bc51-189adbc716d3	1	1	{"id": "be2c04e6-5f42-5c50-bc51-189adbc716d3", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LXF_20211229T040442", "extent": {"lat": {"end": -12.661314115741, "begin": -13.655153200298894}, "lon": {"end": 124.1992956201453, "begin": 123.92090167395953}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630236.0, 8600019.0], [605837.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-29T05:43:18.593Z", "updated": "2021-12-29T05:43:18.593Z", "datetime": "2021-12-29T02:11:08Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 97.47, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LXF_20211229T040442", "sentinel:grid_square": "XF", "sentinel:data_coverage": 16.43, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-29T05:43:18.593Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/29/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/29/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2021/12/29/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8600019.0], [630236.0, 8600019.0], [605837.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:03.946043+00	localuser	\N
366d6bac-efdc-5429-9219-8187450019c7	1	1	{"id": "366d6bac-efdc-5429-9219-8187450019c7", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LWE_20211229T040442", "extent": {"lat": {"end": -13.566464479923951, "begin": -14.561247992924196}, "lon": {"end": 123.99825266388078, "begin": 122.99982362258439}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608006.0, 8499999.0], [583647.0, 8390201.0], [499981.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-29T05:53:07.785Z", "updated": "2021-12-29T05:53:07.785Z", "datetime": "2021-12-29T02:11:28Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 78.91, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211229T020451_N0301_R017_T51LWE_20211229T040442", "sentinel:grid_square": "WE", "sentinel:data_coverage": 87.29, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-29T05:53:07.785Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/29/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/29/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/29/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608006.0, 8499999.0], [583647.0, 8390201.0], [499981.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.040272+00	localuser	\N
596a61db-c7a3-5f87-b95b-ad01826b07c2	1	1	{"id": "596a61db-c7a3-5f87-b95b-ad01826b07c2", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWE_20211226T034934", "extent": {"lat": {"end": -13.566398424069876, "begin": -14.560731043652362}, "lon": {"end": 124.0190234178553, "begin": 123.49184517257038}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[552984.0, 8390201.0], [578603.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [552984.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:42:44.205Z", "updated": "2021-12-26T05:42:44.205Z", "datetime": "2021-12-26T02:01:32Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWE_20211226T034934", "sentinel:grid_square": "WE", "sentinel:data_coverage": 40.06, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:42:44.205Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[552984.0, 8390201.0], [578603.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8390201.0], [552984.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.074383+00	localuser	\N
90948f43-381b-5e12-ac54-d9b8329eafc9	1	1	{"id": "90948f43-381b-5e12-ac54-d9b8329eafc9", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYD_20211226T034934", "extent": {"lat": {"end": -14.454757819240648, "begin": -15.457169776670924}, "lon": {"end": 125.88629831928218, "begin": 124.85515458012951}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:51:32.989Z", "updated": "2021-12-26T05:51:32.989Z", "datetime": "2021-12-26T02:01:40Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LYD_20211226T034934", "sentinel:grid_square": "YD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:51:32.989Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YD/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YD/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8290241.0], [699961.0, 8400039.0], [809759.0, 8400039.0], [809759.0, 8290241.0], [699961.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8290240.0}, "lr": {"x": 809760.0, "y": 8290240.0}, "ul": {"x": 699960.0, "y": 8400040.0}, "ur": {"x": 809760.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.106669+00	localuser	\N
05b7ba95-86aa-5f9e-8fa9-fd471e136d61	1	1	{"id": "05b7ba95-86aa-5f9e-8fa9-fd471e136d61", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXD_20211221T035024", "extent": {"lat": {"end": -14.464246588370704, "begin": -15.46304701291189}, "lon": {"end": 124.95536475477229, "begin": 123.92789738058742}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:42:58.832Z", "updated": "2021-12-21T05:42:58.832Z", "datetime": "2021-12-21T02:01:37Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 40.04, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXD_20211221T035024", "sentinel:grid_square": "XD", "sentinel:data_coverage": 100, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:42:58.832Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XD/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XD/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8290241.0], [600001.0, 8400039.0], [709799.0, 8400039.0], [709799.0, 8290241.0], [600001.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8290240.0}, "lr": {"x": 709800.0, "y": 8290240.0}, "ul": {"x": 600000.0, "y": 8400040.0}, "ur": {"x": 709800.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.082971+00	localuser	\N
06f5100e-20c0-543c-992e-d82a6c0aa6c9	1	1	{"id": "06f5100e-20c0-543c-992e-d82a6c0aa6c9", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWD_20211226T034934", "extent": {"lat": {"end": -14.470091817549374, "begin": -15.464835897017888}, "lon": {"end": 124.02331555793114, "begin": 123.2761576389753}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[529624.0, 8290241.0], [555263.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529624.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:47:45.936Z", "updated": "2021-12-26T05:47:45.936Z", "datetime": "2021-12-26T02:01:47Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 99.99, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LWD_20211226T034934", "sentinel:grid_square": "WD", "sentinel:data_coverage": 61.32, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:47:45.936Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WD/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[529624.0, 8290241.0], [555263.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529624.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8290240.0}, "lr": {"x": 609780.0, "y": 8290240.0}, "ul": {"x": 499980.0, "y": 8400040.0}, "ur": {"x": 609780.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.103778+00	localuser	\N
c1eb8e73-4d2c-58ca-8f22-46f8ae42175c	1	1	{"id": "c1eb8e73-4d2c-58ca-8f22-46f8ae42175c", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8400040, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8400040, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8400040, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8400040, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWD_20211221T035024", "extent": {"lat": {"end": -14.470091817549374, "begin": -15.464834266476407}, "lon": {"end": 124.02331555793114, "begin": 123.27746272082629}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[529764.0, 8290241.0], [555383.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529764.0, 8290241.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:04:18.353Z", "updated": "2021-12-21T06:04:18.353Z", "datetime": "2021-12-21T02:01:40Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 1.43, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWD", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWD_20211221T035024", "sentinel:grid_square": "WD", "sentinel:data_coverage": 61.21, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:04:18.353Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WD/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WD/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[529764.0, 8290241.0], [555383.0, 8400039.0], [609779.0, 8400039.0], [609779.0, 8290241.0], [529764.0, 8290241.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8290240.0}, "lr": {"x": 609780.0, "y": 8290240.0}, "ul": {"x": 499980.0, "y": 8400040.0}, "ur": {"x": 609780.0, "y": 8400040.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.119756+00	localuser	\N
e96894a0-f939-574a-aa98-43f397e86c73	1	1	{"id": "e96894a0-f939-574a-aa98-43f397e86c73", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXF_20211226T034934", "extent": {"lat": {"end": -12.657006390818566, "begin": -13.655153200298894}, "lon": {"end": 124.93951216306945, "begin": 123.92117696072926}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591562.0], [601984.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-26T05:49:38.854Z", "updated": "2021-12-26T05:49:38.854Z", "datetime": "2021-12-26T02:01:15Z", "proj:epsg": 32751, "eo:platform": "sentinel-2a", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2A_MSIL2A_20211226T015621_N0301_R117_T51LXF_20211226T034934", "sentinel:grid_square": "XF", "sentinel:data_coverage": 99.93, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-26T05:49:38.854Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/26/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XF/2021/12/26/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XF/2021/12/26/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8490221.0], [600001.0, 8591562.0], [601984.0, 8600019.0], [709799.0, 8600019.0], [709799.0, 8490221.0], [600001.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8490220.0}, "lr": {"x": 709800.0, "y": 8490220.0}, "ul": {"x": 600000.0, "y": 8600020.0}, "ur": {"x": 709800.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.154232+00	localuser	\N
0f9bc727-0cf6-50b4-9372-341b21d07b31	1	1	{"id": "0f9bc727-0cf6-50b4-9372-341b21d07b31", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LWE_20211224T040221", "extent": {"lat": {"end": -13.56645671217185, "begin": -14.561247992924196}, "lon": {"end": 124.00019339390695, "begin": 122.99982362258439}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608216.0, 8499999.0], [583897.0, 8390201.0], [499981.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-24T06:02:59.523Z", "updated": "2021-12-24T06:02:59.523Z", "datetime": "2021-12-24T02:11:21Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 100, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LWE_20211224T040221", "sentinel:grid_square": "WE", "sentinel:data_coverage": 87.5, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-24T06:02:59.523Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/24/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/24/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/24/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8390201.0], [499981.0, 8499999.0], [608216.0, 8499999.0], [583897.0, 8390201.0], [499981.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.124324+00	localuser	\N
9af18181-b3f9-5d96-94f6-8b30f7c5a7df	1	1	{"id": "9af18181-b3f9-5d96-94f6-8b30f7c5a7df", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8600020, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8600020, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8600020, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8600020, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LWF_20211224T040221", "extent": {"lat": {"end": -12.662096175849399, "begin": -13.656875751592967}, "lon": {"end": 124.0143713167392, "begin": 122.99982431658114}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506961.0], [606057.0, 8490221.0], [499981.0, 8490221.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-24T06:03:07.180Z", "updated": "2021-12-24T06:03:07.180Z", "datetime": "2021-12-24T02:11:07Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 95.17, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWF", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211224T020439_N0301_R017_T51LWF_20211224T040221", "sentinel:grid_square": "WF", "sentinel:data_coverage": 99.74, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-24T06:03:07.180Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/24/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WF/2021/12/24/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WF/2021/12/24/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[499981.0, 8490221.0], [499981.0, 8600019.0], [609779.0, 8600019.0], [609779.0, 8506961.0], [606057.0, 8490221.0], [499981.0, 8490221.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8490220.0}, "lr": {"x": 609780.0, "y": 8490220.0}, "ul": {"x": 499980.0, "y": 8600020.0}, "ur": {"x": 609780.0, "y": 8600020.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.152902+00	localuser	\N
e2a1cd69-1dbd-5b06-8816-1a821bda2f9d	1	1	{"id": "e2a1cd69-1dbd-5b06-8816-1a821bda2f9d", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYE_20211221T035024", "extent": {"lat": {"end": -14.132087128263727, "begin": -14.553888007970453}, "lon": {"end": 125.87420997110432, "begin": 124.85242572251619}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8436876.0], [714385.0, 8433554.0], [738522.0, 8427780.0], [755614.0, 8423602.0], [785199.0, 8416061.0], [806612.0, 8410323.0], [809759.0, 8409355.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:32:33.508Z", "updated": "2021-12-21T05:32:33.508Z", "datetime": "2021-12-21T02:01:25Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 86.67, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYE_20211221T035024", "sentinel:grid_square": "YE", "sentinel:data_coverage": 30.31, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:32:33.508Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[699961.0, 8390201.0], [699961.0, 8436876.0], [714385.0, 8433554.0], [738522.0, 8427780.0], [755614.0, 8423602.0], [785199.0, 8416061.0], [806612.0, 8410323.0], [809759.0, 8409355.0], [809759.0, 8390201.0], [699961.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.184773+00	localuser	\N
794ed4e9-07c0-5d09-bdf6-063040444b38	1	1	{"id": "794ed4e9-07c0-5d09-bdf6-063040444b38", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWE_20211221T035024", "extent": {"lat": {"end": -13.900684436468937, "begin": -14.560729090528321}, "lon": {"end": 124.0190234178553, "begin": 123.49277343812123}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[553084.0, 8390201.0], [570136.0, 8463162.0], [595727.0, 8458557.0], [609779.0, 8455937.0], [609779.0, 8390201.0], [553084.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:55:39.467Z", "updated": "2021-12-21T05:55:39.467Z", "datetime": "2021-12-21T02:01:28Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 39.84, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "1", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWE_20211221T035024", "sentinel:grid_square": "WE", "sentinel:data_coverage": 27.94, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:55:39.467Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/21/1/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/21/1/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/21/1/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[553084.0, 8390201.0], [570136.0, 8463162.0], [595727.0, 8458557.0], [609779.0, 8455937.0], [609779.0, 8390201.0], [553084.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.151213+00	localuser	\N
73bc0426-88aa-5492-800a-de05000d539e	1	1	{"id": "73bc0426-88aa-5492-800a-de05000d539e", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 499980, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 499980, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 499980, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 499980, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWE_20211221T035336", "extent": {"lat": {"end": -13.566398424069876, "begin": -14.139721906626619}, "lon": {"end": 124.01712921917797, "begin": 123.6093619227773}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[609779.0, 8436583.0], [589573.0, 8440096.0], [565787.0, 8444601.0], [578723.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8436583.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:55:04.856Z", "updated": "2021-12-21T05:55:04.856Z", "datetime": "2021-12-21T02:01:21Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 49.88, "odc:file_format": "GeoTIFF", "odc:region_code": "51LWE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LWE_20211221T035336", "sentinel:grid_square": "WE", "sentinel:data_coverage": 18.68, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:55:04.856Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/WE/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/WE/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[609779.0, 8436583.0], [589573.0, 8440096.0], [565787.0, 8444601.0], [578723.0, 8499999.0], [609779.0, 8499999.0], [609779.0, 8436583.0]]]}, "geo_ref_points": {"ll": {"x": 499980.0, "y": 8390200.0}, "lr": {"x": 609780.0, "y": 8390200.0}, "ul": {"x": 499980.0, "y": 8500000.0}, "ur": {"x": 609780.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.162364+00	localuser	\N
5a18267d-4106-5b5f-aa97-e14bb06a84b5	1	1	{"id": "5a18267d-4106-5b5f-aa97-e14bb06a84b5", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXE_20211221T035336", "extent": {"lat": {"end": -13.560932176423318, "begin": -14.329377520017378}, "lon": {"end": 124.94522199403758, "begin": 123.92427299922684}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[709799.0, 8414964.0], [600001.0, 8438382.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8414964.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:02:59.866Z", "updated": "2021-12-21T06:02:59.866Z", "datetime": "2021-12-21T02:01:19Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 94.92, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "1", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXE_20211221T035336", "sentinel:grid_square": "XE", "sentinel:data_coverage": 66.38, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:02:59.866Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/21/1/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/21/1/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/21/1/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[709799.0, 8414964.0], [600001.0, 8438382.0], [600001.0, 8499999.0], [709799.0, 8499999.0], [709799.0, 8414964.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.172132+00	localuser	\N
06455055-402b-52ef-91e4-53ab8e5bda44	1	1	{"id": "06455055-402b-52ef-91e4-53ab8e5bda44", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 600000, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 600000, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 600000, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 600000, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXE_20211221T035024", "extent": {"lat": {"end": -13.948478029477533, "begin": -14.559406653491093}, "lon": {"end": 124.94716787178676, "begin": 123.9257725221508}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8457777.0], [619930.0, 8453967.0], [659370.0, 8445840.0], [668040.0, 8443982.0], [697169.0, 8437485.0], [709799.0, 8434617.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T05:59:47.556Z", "updated": "2021-12-21T05:59:47.556Z", "datetime": "2021-12-21T02:01:26Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 85.15, "odc:file_format": "GeoTIFF", "odc:region_code": "51LXE", "eo:constellation": "sentinel-2", "sentinel:sequence": "0", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LXE_20211221T035024", "sentinel:grid_square": "XE", "sentinel:data_coverage": 51.23, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T05:59:47.556Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/21/0/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/XE/2021/12/21/0/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/XE/2021/12/21/0/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[600001.0, 8390201.0], [600001.0, 8457777.0], [619930.0, 8453967.0], [659370.0, 8445840.0], [668040.0, 8443982.0], [697169.0, 8437485.0], [709799.0, 8434617.0], [709799.0, 8390201.0], [600001.0, 8390201.0]]]}, "geo_ref_points": {"ll": {"x": 600000.0, "y": 8390200.0}, "lr": {"x": 709800.0, "y": 8390200.0}, "ul": {"x": 600000.0, "y": 8500000.0}, "ur": {"x": 709800.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.192125+00	localuser	\N
3cac59cc-706d-5860-b6ed-0b45062c20c7	1	1	{"id": "3cac59cc-706d-5860-b6ed-0b45062c20c7", "crs": "epsg:32751", "grids": {"g20m": {"shape": [5490, 5490], "transform": [20, 0, 699960, 0, -20, 8500000, 0, 0, 1]}, "g60m": {"shape": [1830, 1830], "transform": [60, 0, 699960, 0, -60, 8500000, 0, 0, 1]}, "g320m": {"shape": [343, 343], "transform": [320, 0, 699960, 0, -320, 8500000, 0, 0, 1]}, "default": {"shape": [10980, 10980], "transform": [10, 0, 699960, 0, -10, 8500000, 0, 0, 1]}}, "label": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYE_20211221T035336", "extent": {"lat": {"end": -13.552058584450984, "begin": -14.542693741701111}, "lon": {"end": 125.87419828331728, "begin": 124.84791209279844}}, "$schema": "https://schemas.opendatacube.org/dataset", "lineage": {"source_datasets": {}}, "product": {"name": "s2_l2a"}, "geometry": {"type": "Polygon", "coordinates": [[[809759.0, 8390301.0], [806917.0, 8390361.0], [699961.0, 8417223.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390301.0]]]}, "properties": {"eo:gsd": 10, "created": "2021-12-21T06:02:09.039Z", "updated": "2021-12-21T06:02:09.039Z", "datetime": "2021-12-21T02:01:18Z", "proj:epsg": 32751, "eo:platform": "sentinel-2b", "eo:off_nadir": 0, "eo:instrument": "MSI", "eo:cloud_cover": 96.96, "odc:file_format": "GeoTIFF", "odc:region_code": "51LYE", "eo:constellation": "sentinel-2", "sentinel:sequence": "1", "sentinel:utm_zone": 51, "sentinel:product_id": "S2B_MSIL2A_20211221T015619_N0301_R117_T51LYE_20211221T035336", "sentinel:grid_square": "YE", "sentinel:data_coverage": 87.49, "sentinel:latitude_band": "L", "odc:processing_datetime": "2021-12-21T06:02:09.039Z", "sentinel:valid_cloud_cover": true}, "accessories": {"info": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/21/1/tileInfo.json"}, "metadata": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l2a/tiles/51/L/YE/2021/12/21/1/metadata.xml"}, "thumbnail": {"path": "https://roda.sentinel-hub.com/sentinel-s2-l1c/tiles/51/L/YE/2021/12/21/1/preview.jpg"}}, "grid_spatial": {"projection": {"valid_data": {"type": "Polygon", "coordinates": [[[809759.0, 8390301.0], [806917.0, 8390361.0], [699961.0, 8417223.0], [699961.0, 8499999.0], [809759.0, 8499999.0], [809759.0, 8390301.0]]]}, "geo_ref_points": {"ll": {"x": 699960.0, "y": 8390200.0}, "lr": {"x": 809760.0, "y": 8390200.0}, "ul": {"x": 699960.0, "y": 8500000.0}, "ur": {"x": 809760.0, "y": 8500000.0}}, "spatial_reference": "epsg:32751"}}, "measurements": {"AOT": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/AOT.tif"}, "B01": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B01.tif"}, "B02": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B02.tif"}, "B03": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B03.tif"}, "B04": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B04.tif"}, "B05": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B05.tif"}, "B06": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B06.tif"}, "B07": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B07.tif"}, "B08": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B08.tif"}, "B09": {"grid": "g60m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B09.tif"}, "B11": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B11.tif"}, "B12": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B12.tif"}, "B8A": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/B8A.tif"}, "SCL": {"grid": "g20m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/SCL.tif"}, "WVP": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/WVP.tif"}, "visual": {"path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/TCI.tif"}, "overview": {"grid": "g320m", "path": "https://sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/L2A_PVI.tif"}}}	\N	2022-03-28 23:17:04.185269+00	localuser	\N
\.


--
-- Data for Name: dataset_location; Type: TABLE DATA; Schema: agdc; Owner: agdc_admin
--

COPY agdc.dataset_location (id, dataset_ref, uri_scheme, uri_body, added, added_by, archived) FROM stdin;
1	f100ac07-34f6-5744-81b4-20c828d566dc	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211231_0_L2A/S2B_51LXD_20211231_0_L2A.json	2022-03-28 23:16:30.391216+00	localuser	\N
2	0559e840-6372-55d3-83b3-4749e8c7afc6	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211231_0_L2A/S2B_51LYE_20211231_0_L2A.json	2022-03-28 23:16:30.407614+00	localuser	\N
3	3675321d-92e9-5d5e-9df0-9e1b1939d7e5	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211231_0_L2A/S2B_51LXF_20211231_0_L2A.json	2022-03-28 23:16:30.427527+00	localuser	\N
4	0c231856-2813-5d15-86cf-934bd7b797bd	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211231_0_L2A/S2B_51LYF_20211231_0_L2A.json	2022-03-28 23:16:30.440596+00	localuser	\N
5	2e41f815-502f-55d1-a619-33b7dee5137a	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211231_0_L2A/S2B_51LWD_20211231_0_L2A.json	2022-03-28 23:16:30.435527+00	localuser	\N
6	082027ee-135d-5610-849a-b3344ca9133a	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211231_0_L2A/S2B_51LWE_20211231_0_L2A.json	2022-03-28 23:16:30.441096+00	localuser	\N
7	b394a831-1818-5e89-be4b-4a5b77aff92c	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211231_0_L2A/S2B_51LXE_20211231_0_L2A.json	2022-03-28 23:16:30.433738+00	localuser	\N
8	fc80c80d-b4e2-56a6-866b-e6cb53fec07c	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211231_0_L2A/S2B_51LYD_20211231_0_L2A.json	2022-03-28 23:16:30.451266+00	localuser	\N
9	2598eefb-6741-5d20-bb8b-de87f0daee38	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211231_0_L2A/S2B_51LWF_20211231_0_L2A.json	2022-03-28 23:16:30.45651+00	localuser	\N
10	eccac1bd-2e68-5f97-9f7a-f8b6a231ff5d	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220110_0_L2A/S2B_51LWF_20220110_0_L2A.json	2022-03-28 23:17:03.290884+00	localuser	\N
11	f20d08eb-48f5-5825-8dfd-834ecb11d76c	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2B_51LYD_20220110_0_L2A/S2B_51LYD_20220110_0_L2A.json	2022-03-28 23:17:03.414968+00	localuser	\N
12	4a9ed666-e0e2-51ba-9afc-c5c994d828cd	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2B_51LWD_20220110_0_L2A/S2B_51LWD_20220110_0_L2A.json	2022-03-28 23:17:03.445054+00	localuser	\N
13	bab71dec-59bc-57ce-b998-49ef9af03dca	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2B_51LXD_20220110_0_L2A/S2B_51LXD_20220110_0_L2A.json	2022-03-28 23:17:03.485353+00	localuser	\N
14	f1f53acc-7396-52f9-8f78-a56c21d98343	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2022/1/S2A_51LWD_20220105_0_L2A/S2A_51LWD_20220105_0_L2A.json	2022-03-28 23:17:03.512513+00	localuser	\N
15	c5374f05-5a0d-58a7-addf-be6982496fac	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220108_0_L2A/S2A_51LXE_20220108_0_L2A.json	2022-03-28 23:17:03.493526+00	localuser	\N
16	68c20d9e-89d7-5488-9bbe-f75b248b5000	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220110_0_L2A/S2B_51LXE_20220110_0_L2A.json	2022-03-28 23:17:03.519212+00	localuser	\N
17	567cd3a2-8936-5d04-9770-3e81540e9b93	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220110_0_L2A/S2B_51LWE_20220110_0_L2A.json	2022-03-28 23:17:03.508716+00	localuser	\N
18	76854c3e-bf74-5397-8ff6-1574252434bb	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2B_51LYE_20220110_0_L2A/S2B_51LYE_20220110_0_L2A.json	2022-03-28 23:17:03.534899+00	localuser	\N
19	d755c733-7ec5-57c8-84fe-1ac1090085e9	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2B_51LYF_20220110_0_L2A/S2B_51LYF_20220110_0_L2A.json	2022-03-28 23:17:03.563286+00	localuser	\N
20	13271824-8842-5f89-bb81-8441a4e03357	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220110_0_L2A/S2B_51LXF_20220110_0_L2A.json	2022-03-28 23:17:03.632174+00	localuser	\N
21	d687a43f-5685-5d2e-936d-585deb8fb179	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220105_0_L2A/S2A_51LWE_20220105_0_L2A.json	2022-03-28 23:17:03.625036+00	localuser	\N
22	b16487a5-3ec5-5536-9bc3-3e52d498347d	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2A_51LWE_20220108_0_L2A/S2A_51LWE_20220108_0_L2A.json	2022-03-28 23:17:03.633651+00	localuser	\N
23	b86c7ae4-5868-51e6-b9f3-a7ee02408587	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220108_0_L2A/S2A_51LXF_20220108_0_L2A.json	2022-03-28 23:17:03.687217+00	localuser	\N
24	74062a17-91b4-5793-94b7-982a7d3e05d5	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2022/1/S2A_51LYD_20220105_0_L2A/S2A_51LYD_20220105_0_L2A.json	2022-03-28 23:17:03.690993+00	localuser	\N
25	af6222af-8d37-5a15-973e-647771f52998	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2B_51LXF_20220103_0_L2A/S2B_51LXF_20220103_0_L2A.json	2022-03-28 23:17:03.717651+00	localuser	\N
26	bccd8707-2e40-50bf-98b3-410fe3388dee	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220108_0_L2A/S2A_51LWF_20220108_0_L2A.json	2022-03-28 23:17:03.745603+00	localuser	\N
27	7d3c4c52-1eee-5916-9f52-4d0bbea64217	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2022/1/S2A_51LXD_20220105_0_L2A/S2A_51LXD_20220105_0_L2A.json	2022-03-28 23:17:03.76812+00	localuser	\N
28	15bee446-0e53-55ab-a4f5-57b13cd72062	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2022/1/S2A_51LYF_20220105_0_L2A/S2A_51LYF_20220105_0_L2A.json	2022-03-28 23:17:03.792457+00	localuser	\N
29	8b50107b-2489-5454-87f6-626adac36985	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2022/1/S2A_51LYE_20220105_0_L2A/S2A_51LYE_20220105_0_L2A.json	2022-03-28 23:17:03.781894+00	localuser	\N
30	2018d676-fd91-504b-9adf-9c8fa174200f	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2A_51LWF_20220105_0_L2A/S2A_51LWF_20220105_0_L2A.json	2022-03-28 23:17:03.804025+00	localuser	\N
31	231bb494-de14-57fd-8dfa-939b5e38ec57	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2A_51LXE_20220105_0_L2A/S2A_51LXE_20220105_0_L2A.json	2022-03-28 23:17:03.784412+00	localuser	\N
47	d2719a0a-023a-5d7a-bcc3-837cafed8a92	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211226_0_L2A/S2A_51LWF_20211226_0_L2A.json	2022-03-28 23:17:04.097026+00	localuser	\N
54	68eed379-1182-5f2c-9ec4-84c049c53670	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211224_0_L2A/S2B_51LXF_20211224_0_L2A.json	2022-03-28 23:17:04.139987+00	localuser	\N
32	410d4bee-9bb7-5675-9dbf-0cc8e0a69f02	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2022/1/S2B_51LWE_20220103_0_L2A/S2B_51LWE_20220103_0_L2A.json	2022-03-28 23:17:03.838149+00	localuser	\N
37	ad85c2f5-2c3a-562d-92f6-b443df798bca	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2022/1/S2B_51LWF_20220103_0_L2A/S2B_51LWF_20220103_0_L2A.json	2022-03-28 23:17:03.933019+00	localuser	\N
42	2bee7eb8-1ad3-5253-a345-bdaffb4ac238	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2A_51LYE_20211226_0_L2A/S2A_51LYE_20211226_0_L2A.json	2022-03-28 23:17:04.034407+00	localuser	\N
50	911bd536-acec-5bc4-8b32-c3e97d97a7c5	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211221_0_L2A/S2B_51LWF_20211221_0_L2A.json	2022-03-28 23:17:04.105999+00	localuser	\N
61	d6b40607-1b2c-55ed-a40a-4c2fa81e5a26	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2B_51LYF_20211221_0_L2A/S2B_51LYF_20211221_0_L2A.json	2022-03-28 23:17:04.173797+00	localuser	\N
33	82cdfaa4-bee5-59c7-b5fd-3226c4664ecd	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2022/1/S2A_51LXF_20220105_0_L2A/S2A_51LXF_20220105_0_L2A.json	2022-03-28 23:17:03.833553+00	localuser	\N
34	93d69f62-0198-59de-ab21-08545bda863c	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211229_0_L2A/S2A_51LXE_20211229_0_L2A.json	2022-03-28 23:17:03.846503+00	localuser	\N
41	4ee9ab65-0ec4-5112-a5cc-0d50df818790	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2A_51LXD_20211226_0_L2A/S2A_51LXD_20211226_0_L2A.json	2022-03-28 23:17:04.035118+00	localuser	\N
45	48e120d4-fe2c-57f9-a390-41bb97a6796f	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211224_0_L2A/S2B_51LXE_20211224_0_L2A.json	2022-03-28 23:17:04.086302+00	localuser	\N
53	0f9bc727-0cf6-50b4-9372-341b21d07b31	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211224_0_L2A/S2B_51LWE_20211224_0_L2A.json	2022-03-28 23:17:04.124324+00	localuser	\N
63	e2a1cd69-1dbd-5b06-8816-1a821bda2f9d	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_0_L2A/S2B_51LYE_20211221_0_L2A.json	2022-03-28 23:17:04.184773+00	localuser	\N
35	866add98-cf7d-5b74-8d70-d1b1c6191920	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2A_51LWF_20211229_0_L2A/S2A_51LWF_20211229_0_L2A.json	2022-03-28 23:17:03.924025+00	localuser	\N
36	f9313945-9481-5131-aec6-f60db2592d37	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2022/1/S2B_51LXE_20220103_0_L2A/S2B_51LXE_20220103_0_L2A.json	2022-03-28 23:17:03.928518+00	localuser	\N
43	57ce5b73-4465-5bf8-a73c-acf1fbec6703	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2A_51LXE_20211226_0_L2A/S2A_51LXE_20211226_0_L2A.json	2022-03-28 23:17:04.035976+00	localuser	\N
46	05b7ba95-86aa-5f9e-8fa9-fd471e136d61	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XD/2021/12/S2B_51LXD_20211221_0_L2A/S2B_51LXD_20211221_0_L2A.json	2022-03-28 23:17:04.082971+00	localuser	\N
58	73bc0426-88aa-5492-800a-de05000d539e	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_0_L2A/S2B_51LWE_20211221_0_L2A.json	2022-03-28 23:17:04.162364+00	localuser	\N
38	be2c04e6-5f42-5c50-bc51-189adbc716d3	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211229_0_L2A/S2A_51LXF_20211229_0_L2A.json	2022-03-28 23:17:03.946043+00	localuser	\N
40	366d6bac-efdc-5429-9219-8187450019c7	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211229_0_L2A/S2A_51LWE_20211229_0_L2A.json	2022-03-28 23:17:04.040272+00	localuser	\N
44	596a61db-c7a3-5f87-b95b-ad01826b07c2	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2A_51LWE_20211226_0_L2A/S2A_51LWE_20211226_0_L2A.json	2022-03-28 23:17:04.074383+00	localuser	\N
48	90948f43-381b-5e12-ac54-d9b8329eafc9	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2A_51LYD_20211226_0_L2A/S2A_51LYD_20211226_0_L2A.json	2022-03-28 23:17:04.106669+00	localuser	\N
55	794ed4e9-07c0-5d09-bdf6-063040444b38	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WE/2021/12/S2B_51LWE_20211221_1_L2A/S2B_51LWE_20211221_1_L2A.json	2022-03-28 23:17:04.151213+00	localuser	\N
39	7d6ac641-8687-564f-86fb-019bbf5186f2	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YF/2021/12/S2A_51LYF_20211226_0_L2A/S2A_51LYF_20211226_0_L2A.json	2022-03-28 23:17:03.992853+00	localuser	\N
49	c1eb8e73-4d2c-58ca-8f22-46f8ae42175c	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2B_51LWD_20211221_0_L2A/S2B_51LWD_20211221_0_L2A.json	2022-03-28 23:17:04.119756+00	localuser	\N
51	06f5100e-20c0-543c-992e-d82a6c0aa6c9	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WD/2021/12/S2A_51LWD_20211226_0_L2A/S2A_51LWD_20211226_0_L2A.json	2022-03-28 23:17:04.103778+00	localuser	\N
52	2e1776b5-3e28-52bc-906b-5b51eddc5a79	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YD/2021/12/S2B_51LYD_20211221_1_L2A/S2B_51LYD_20211221_1_L2A.json	2022-03-28 23:17:04.125699+00	localuser	\N
56	e96894a0-f939-574a-aa98-43f397e86c73	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2A_51LXF_20211226_0_L2A/S2A_51LXF_20211226_0_L2A.json	2022-03-28 23:17:04.154232+00	localuser	\N
57	9af18181-b3f9-5d96-94f6-8b30f7c5a7df	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/WF/2021/12/S2B_51LWF_20211224_0_L2A/S2B_51LWF_20211224_0_L2A.json	2022-03-28 23:17:04.152902+00	localuser	\N
59	82bf9be0-a6e6-5c5d-a859-c3c81b57c43e	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XF/2021/12/S2B_51LXF_20211221_0_L2A/S2B_51LXF_20211221_0_L2A.json	2022-03-28 23:17:04.168359+00	localuser	\N
60	5a18267d-4106-5b5f-aa97-e14bb06a84b5	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_1_L2A/S2B_51LXE_20211221_1_L2A.json	2022-03-28 23:17:04.172132+00	localuser	\N
62	3cac59cc-706d-5860-b6ed-0b45062c20c7	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/YE/2021/12/S2B_51LYE_20211221_1_L2A/S2B_51LYE_20211221_1_L2A.json	2022-03-28 23:17:04.185269+00	localuser	\N
64	06455055-402b-52ef-91e4-53ab8e5bda44	https	//sentinel-cogs.s3.us-west-2.amazonaws.com/sentinel-s2-l2a-cogs/51/L/XE/2021/12/S2B_51LXE_20211221_0_L2A/S2B_51LXE_20211221_0_L2A.json	2022-03-28 23:17:04.192125+00	localuser	\N
\.


--
-- Data for Name: dataset_source; Type: TABLE DATA; Schema: agdc; Owner: agdc_admin
--

COPY agdc.dataset_source (dataset_ref, classifier, source_dataset_ref) FROM stdin;
\.


--
-- Data for Name: dataset_type; Type: TABLE DATA; Schema: agdc; Owner: agdc_admin
--

COPY agdc.dataset_type (id, name, metadata, metadata_type_ref, definition, added, added_by, updated) FROM stdin;
1	s2_l2a	{"product": {"name": "s2_l2a"}}	1	{"name": "s2_l2a", "metadata": {"product": {"name": "s2_l2a"}}, "description": "Sentinel-2a and Sentinel-2b imagery, processed to Level 2A (Surface Reflectance) and converted to Cloud Optimized GeoTIFFs", "measurements": [{"name": "B01", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_01", "coastal_aerosol"]}, {"name": "B02", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_02", "blue"]}, {"name": "B03", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_03", "green"]}, {"name": "B04", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_04", "red"]}, {"name": "B05", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_05", "red_edge_1"]}, {"name": "B06", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_06", "red_edge_2"]}, {"name": "B07", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_07", "red_edge_3"]}, {"name": "B08", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_08", "nir", "nir_1"]}, {"name": "B8A", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_8a", "nir_narrow", "nir_2"]}, {"name": "B09", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_09", "water_vapour"]}, {"name": "B11", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_11", "swir_1", "swir_16"]}, {"name": "B12", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["band_12", "swir_2", "swir_22"]}, {"name": "SCL", "dtype": "uint8", "units": "1", "nodata": 0, "aliases": ["mask", "qa"], "flags_definition": {"qa": {"bits": [0, 1, 2, 3, 4, 5, 6, 7], "values": {"0": "no data", "1": "saturated or defective", "2": "dark area pixels", "3": "cloud shadows", "4": "vegetation", "5": "bare soils", "6": "water", "7": "unclassified", "8": "cloud medium probability", "9": "cloud high probability", "10": "thin cirrus", "11": "snow or ice"}, "description": "Sen2Cor Scene Classification"}}}, {"name": "AOT", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["aerosol_optical_thickness"]}, {"name": "WVP", "dtype": "uint16", "units": "1", "nodata": 0, "aliases": ["scene_average_water_vapour"]}], "metadata_type": "eo3"}	2022-03-28 23:05:01.269353+00	localuser	\N
\.


--
-- Data for Name: metadata_type; Type: TABLE DATA; Schema: agdc; Owner: agdc_admin
--

COPY agdc.metadata_type (id, name, definition, added, added_by, updated) FROM stdin;
1	eo3	{"name": "eo3", "dataset": {"id": ["id"], "label": ["label"], "format": ["properties", "odc:file_format"], "sources": ["lineage", "source_datasets"], "creation_dt": ["properties", "odc:processing_datetime"], "grid_spatial": ["grid_spatial", "projection"], "measurements": ["measurements"], "search_fields": {"lat": {"type": "double-range", "max_offset": [["extent", "lat", "end"]], "min_offset": [["extent", "lat", "begin"]], "description": "Latitude range"}, "lon": {"type": "double-range", "max_offset": [["extent", "lon", "end"]], "min_offset": [["extent", "lon", "begin"]], "description": "Longitude range"}, "time": {"type": "datetime-range", "max_offset": [["properties", "dtr:end_datetime"], ["properties", "datetime"]], "min_offset": [["properties", "dtr:start_datetime"], ["properties", "datetime"]], "description": "Acquisition time range"}, "platform": {"offset": ["properties", "eo:platform"], "indexed": false, "description": "Platform code"}, "instrument": {"offset": ["properties", "eo:instrument"], "indexed": false, "description": "Instrument name"}, "cloud_cover": {"type": "double", "offset": ["properties", "eo:cloud_cover"], "indexed": false, "description": "Cloud cover percentage [0, 100]"}, "region_code": {"offset": ["properties", "odc:region_code"], "description": "Spatial reference code from the provider. For Landsat region_code is a scene path row:\\n        '{:03d}{:03d}.format(path,row)'.\\nFor Sentinel it is MGRS code. In general it is a unique string identifier that datasets covering roughly the same spatial region share.\\n"}, "product_family": {"offset": ["properties", "odc:product_family"], "indexed": false, "description": "Product family code"}, "dataset_maturity": {"offset": ["properties", "dea:dataset_maturity"], "indexed": false, "description": "One of - final|interim|nrt  (near real time)"}}}, "description": "Default EO3 with no custom fields"}	2022-03-28 23:04:37.209712+00	localuser	\N
2	eo	{"name": "eo", "dataset": {"id": ["id"], "label": ["ga_label"], "format": ["format", "name"], "sources": ["lineage", "source_datasets"], "creation_dt": ["creation_dt"], "grid_spatial": ["grid_spatial", "projection"], "measurements": ["image", "bands"], "search_fields": {"lat": {"type": "double-range", "max_offset": [["extent", "coord", "ur", "lat"], ["extent", "coord", "lr", "lat"], ["extent", "coord", "ul", "lat"], ["extent", "coord", "ll", "lat"]], "min_offset": [["extent", "coord", "ur", "lat"], ["extent", "coord", "lr", "lat"], ["extent", "coord", "ul", "lat"], ["extent", "coord", "ll", "lat"]], "description": "Latitude range"}, "lon": {"type": "double-range", "max_offset": [["extent", "coord", "ul", "lon"], ["extent", "coord", "ur", "lon"], ["extent", "coord", "ll", "lon"], ["extent", "coord", "lr", "lon"]], "min_offset": [["extent", "coord", "ul", "lon"], ["extent", "coord", "ur", "lon"], ["extent", "coord", "ll", "lon"], ["extent", "coord", "lr", "lon"]], "description": "Longitude range"}, "time": {"type": "datetime-range", "max_offset": [["extent", "to_dt"], ["extent", "center_dt"]], "min_offset": [["extent", "from_dt"], ["extent", "center_dt"]], "description": "Acquisition time"}, "platform": {"offset": ["platform", "code"], "description": "Platform code"}, "instrument": {"offset": ["instrument", "name"], "description": "Instrument name"}, "product_type": {"offset": ["product_type"], "description": "Product code"}}}, "description": "Earth Observation datasets.\\n\\nExpected metadata structure produced by the eodatasets library, as used internally at GA.\\n\\nhttps://github.com/GeoscienceAustralia/eo-datasets\\n"}	2022-03-28 23:04:37.245343+00	localuser	\N
3	telemetry	{"name": "telemetry", "dataset": {"id": ["id"], "label": ["ga_label"], "sources": ["lineage", "source_datasets"], "creation_dt": ["creation_dt"], "search_fields": {"gsi": {"offset": ["acquisition", "groundstation", "code"], "indexed": false, "description": "Ground Station Identifier (eg. ASA)"}, "time": {"type": "datetime-range", "max_offset": [["acquisition", "los"]], "min_offset": [["acquisition", "aos"]], "description": "Acquisition time"}, "orbit": {"type": "integer", "offset": ["acquisition", "platform_orbit"], "description": "Orbit number"}, "sat_row": {"type": "integer-range", "max_offset": [["image", "satellite_ref_point_end", "y"], ["image", "satellite_ref_point_start", "y"]], "min_offset": [["image", "satellite_ref_point_start", "y"]], "description": "Landsat row"}, "platform": {"offset": ["platform", "code"], "description": "Platform code"}, "sat_path": {"type": "integer-range", "max_offset": [["image", "satellite_ref_point_end", "x"], ["image", "satellite_ref_point_start", "x"]], "min_offset": [["image", "satellite_ref_point_start", "x"]], "description": "Landsat path"}, "instrument": {"offset": ["instrument", "name"], "description": "Instrument name"}, "product_type": {"offset": ["product_type"], "description": "Product code"}}}, "description": "Satellite telemetry datasets.\\n\\nExpected metadata structure produced by telemetry datasets from the eodatasets library, as used internally at GA.\\n\\nhttps://github.com/GeoscienceAustralia/eo-datasets\\n"}	2022-03-28 23:04:37.277776+00	localuser	\N
\.


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: localuser
--

COPY public.spatial_ref_sys (srid, auth_name, auth_srid, srtext, proj4text) FROM stdin;
\.


--
-- Data for Name: geocode_settings; Type: TABLE DATA; Schema: tiger; Owner: localuser
--

COPY tiger.geocode_settings (name, setting, unit, category, short_desc) FROM stdin;
\.


--
-- Data for Name: pagc_gaz; Type: TABLE DATA; Schema: tiger; Owner: localuser
--

COPY tiger.pagc_gaz (id, seq, word, stdword, token, is_custom) FROM stdin;
\.


--
-- Data for Name: pagc_lex; Type: TABLE DATA; Schema: tiger; Owner: localuser
--

COPY tiger.pagc_lex (id, seq, word, stdword, token, is_custom) FROM stdin;
\.


--
-- Data for Name: pagc_rules; Type: TABLE DATA; Schema: tiger; Owner: localuser
--

COPY tiger.pagc_rules (id, rule, is_custom) FROM stdin;
\.


--
-- Data for Name: topology; Type: TABLE DATA; Schema: topology; Owner: localuser
--

COPY topology.topology (id, name, srid, "precision", hasz) FROM stdin;
\.


--
-- Data for Name: layer; Type: TABLE DATA; Schema: topology; Owner: localuser
--

COPY topology.layer (topology_id, layer_id, schema_name, table_name, feature_column, feature_type, level, child_id) FROM stdin;
\.


--
-- Data for Name: multiproduct_ranges; Type: TABLE DATA; Schema: wms; Owner: localuser
--

COPY wms.multiproduct_ranges (wms_product_name, lat_min, lat_max, lon_min, lon_max, dates, bboxes) FROM stdin;
\.


--
-- Data for Name: product_ranges; Type: TABLE DATA; Schema: wms; Owner: localuser
--

COPY wms.product_ranges (id, lat_min, lat_max, lon_min, lon_max, dates, bboxes) FROM stdin;
1	-15.4648363614749	-12.6487438946096	122.999823622584	125.886298319282	["2021-12-21", "2021-12-24", "2021-12-26", "2021-12-29", "2021-12-31", "2022-01-03", "2022-01-05", "2022-01-08", "2022-01-10"]	{"EPSG:3577": {"top": -1350906.5414784672, "left": -993726.392797221, "right": -660599.4568739075, "bottom": -1676860.504621191}, "EPSG:3857": {"top": -1419630.208578022, "left": 13692277.733328514, "right": 14013598.626752604, "bottom": -1742829.7660742048}, "EPSG:4326": {"top": -12.6487438946096, "left": 122.999823622584, "right": 125.886298319282, "bottom": -15.4648363614749}}
\.


--
-- Data for Name: sub_product_ranges; Type: TABLE DATA; Schema: wms; Owner: localuser
--

COPY wms.sub_product_ranges (product_id, sub_product_id, lat_min, lat_max, lon_min, lon_max, dates, bboxes) FROM stdin;
\.


--
-- Name: dataset_location_id_seq; Type: SEQUENCE SET; Schema: agdc; Owner: agdc_admin
--

SELECT pg_catalog.setval('agdc.dataset_location_id_seq', 64, true);


--
-- Name: dataset_type_id_seq; Type: SEQUENCE SET; Schema: agdc; Owner: agdc_admin
--

SELECT pg_catalog.setval('agdc.dataset_type_id_seq', 1, true);


--
-- Name: metadata_type_id_seq; Type: SEQUENCE SET; Schema: agdc; Owner: agdc_admin
--

SELECT pg_catalog.setval('agdc.metadata_type_id_seq', 3, true);


--
-- Name: dataset pk_dataset; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset
    ADD CONSTRAINT pk_dataset PRIMARY KEY (id);


--
-- Name: dataset_location pk_dataset_location; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_location
    ADD CONSTRAINT pk_dataset_location PRIMARY KEY (id);


--
-- Name: dataset_source pk_dataset_source; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_source
    ADD CONSTRAINT pk_dataset_source PRIMARY KEY (dataset_ref, classifier);


--
-- Name: dataset_type pk_dataset_type; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_type
    ADD CONSTRAINT pk_dataset_type PRIMARY KEY (id);


--
-- Name: metadata_type pk_metadata_type; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.metadata_type
    ADD CONSTRAINT pk_metadata_type PRIMARY KEY (id);


--
-- Name: dataset_location uq_dataset_location_uri_scheme; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_location
    ADD CONSTRAINT uq_dataset_location_uri_scheme UNIQUE (uri_scheme, uri_body, dataset_ref);


--
-- Name: dataset_source uq_dataset_source_source_dataset_ref; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_source
    ADD CONSTRAINT uq_dataset_source_source_dataset_ref UNIQUE (source_dataset_ref, dataset_ref);


--
-- Name: dataset_type uq_dataset_type_name; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_type
    ADD CONSTRAINT uq_dataset_type_name UNIQUE (name);


--
-- Name: metadata_type uq_metadata_type_name; Type: CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.metadata_type
    ADD CONSTRAINT uq_metadata_type_name UNIQUE (name);


--
-- Name: multiproduct_ranges multiproduct_ranges_pkey; Type: CONSTRAINT; Schema: wms; Owner: localuser
--

ALTER TABLE ONLY wms.multiproduct_ranges
    ADD CONSTRAINT multiproduct_ranges_pkey PRIMARY KEY (wms_product_name);


--
-- Name: sub_product_ranges pk_sub_product_ranges; Type: CONSTRAINT; Schema: wms; Owner: localuser
--

ALTER TABLE ONLY wms.sub_product_ranges
    ADD CONSTRAINT pk_sub_product_ranges PRIMARY KEY (product_id, sub_product_id);


--
-- Name: product_ranges product_ranges_pkey; Type: CONSTRAINT; Schema: wms; Owner: localuser
--

ALTER TABLE ONLY wms.product_ranges
    ADD CONSTRAINT product_ranges_pkey PRIMARY KEY (id);


--
-- Name: dix_s2_l2a_lat_lon_time; Type: INDEX; Schema: agdc; Owner: agdc_admin
--

CREATE INDEX dix_s2_l2a_lat_lon_time ON agdc.dataset USING gist (agdc.float8range(((metadata #>> '{extent,lat,begin}'::text[]))::double precision, ((metadata #>> '{extent,lat,end}'::text[]))::double precision, '[]'::text), agdc.float8range(((metadata #>> '{extent,lon,begin}'::text[]))::double precision, ((metadata #>> '{extent,lon,end}'::text[]))::double precision, '[]'::text), tstzrange(LEAST(agdc.common_timestamp((metadata #>> '{properties,dtr:start_datetime}'::text[])), agdc.common_timestamp((metadata #>> '{properties,datetime}'::text[]))), GREATEST(agdc.common_timestamp((metadata #>> '{properties,dtr:end_datetime}'::text[])), agdc.common_timestamp((metadata #>> '{properties,datetime}'::text[]))), '[]'::text)) WHERE ((archived IS NULL) AND (dataset_type_ref = 1));


--
-- Name: dix_s2_l2a_region_code; Type: INDEX; Schema: agdc; Owner: agdc_admin
--

CREATE INDEX dix_s2_l2a_region_code ON agdc.dataset USING btree (((metadata #>> '{properties,odc:region_code}'::text[]))) WHERE ((archived IS NULL) AND (dataset_type_ref = 1));


--
-- Name: dix_s2_l2a_time_lat_lon; Type: INDEX; Schema: agdc; Owner: agdc_admin
--

CREATE INDEX dix_s2_l2a_time_lat_lon ON agdc.dataset USING gist (tstzrange(LEAST(agdc.common_timestamp((metadata #>> '{properties,dtr:start_datetime}'::text[])), agdc.common_timestamp((metadata #>> '{properties,datetime}'::text[]))), GREATEST(agdc.common_timestamp((metadata #>> '{properties,dtr:end_datetime}'::text[])), agdc.common_timestamp((metadata #>> '{properties,datetime}'::text[]))), '[]'::text), agdc.float8range(((metadata #>> '{extent,lat,begin}'::text[]))::double precision, ((metadata #>> '{extent,lat,end}'::text[]))::double precision, '[]'::text), agdc.float8range(((metadata #>> '{extent,lon,begin}'::text[]))::double precision, ((metadata #>> '{extent,lon,end}'::text[]))::double precision, '[]'::text)) WHERE ((archived IS NULL) AND (dataset_type_ref = 1));


--
-- Name: ix_agdc_dataset_dataset_type_ref; Type: INDEX; Schema: agdc; Owner: agdc_admin
--

CREATE INDEX ix_agdc_dataset_dataset_type_ref ON agdc.dataset USING btree (dataset_type_ref);


--
-- Name: ix_agdc_dataset_location_dataset_ref; Type: INDEX; Schema: agdc; Owner: agdc_admin
--

CREATE INDEX ix_agdc_dataset_location_dataset_ref ON agdc.dataset_location USING btree (dataset_ref);


--
-- Name: space_time_view_ds_idx; Type: INDEX; Schema: public; Owner: localuser
--

CREATE INDEX space_time_view_ds_idx ON public.space_time_view USING btree (dataset_type_ref);


--
-- Name: space_time_view_geom_idx; Type: INDEX; Schema: public; Owner: localuser
--

CREATE INDEX space_time_view_geom_idx ON public.space_time_view USING gist (spatial_extent);


--
-- Name: space_time_view_idx; Type: INDEX; Schema: public; Owner: localuser
--

CREATE UNIQUE INDEX space_time_view_idx ON public.space_time_view USING btree (id);


--
-- Name: space_time_view_time_idx; Type: INDEX; Schema: public; Owner: localuser
--

CREATE INDEX space_time_view_time_idx ON public.space_time_view USING spgist (temporal_extent);


--
-- Name: dataset row_update_time_dataset; Type: TRIGGER; Schema: agdc; Owner: agdc_admin
--

CREATE TRIGGER row_update_time_dataset BEFORE UPDATE ON agdc.dataset FOR EACH ROW EXECUTE FUNCTION agdc.set_row_update_time();


--
-- Name: dataset_type row_update_time_dataset_type; Type: TRIGGER; Schema: agdc; Owner: agdc_admin
--

CREATE TRIGGER row_update_time_dataset_type BEFORE UPDATE ON agdc.dataset_type FOR EACH ROW EXECUTE FUNCTION agdc.set_row_update_time();


--
-- Name: metadata_type row_update_time_metadata_type; Type: TRIGGER; Schema: agdc; Owner: agdc_admin
--

CREATE TRIGGER row_update_time_metadata_type BEFORE UPDATE ON agdc.metadata_type FOR EACH ROW EXECUTE FUNCTION agdc.set_row_update_time();


--
-- Name: dataset fk_dataset_dataset_type_ref_dataset_type; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset
    ADD CONSTRAINT fk_dataset_dataset_type_ref_dataset_type FOREIGN KEY (dataset_type_ref) REFERENCES agdc.dataset_type(id);


--
-- Name: dataset_location fk_dataset_location_dataset_ref_dataset; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_location
    ADD CONSTRAINT fk_dataset_location_dataset_ref_dataset FOREIGN KEY (dataset_ref) REFERENCES agdc.dataset(id);


--
-- Name: dataset fk_dataset_metadata_type_ref_metadata_type; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset
    ADD CONSTRAINT fk_dataset_metadata_type_ref_metadata_type FOREIGN KEY (metadata_type_ref) REFERENCES agdc.metadata_type(id);


--
-- Name: dataset_source fk_dataset_source_dataset_ref_dataset; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_source
    ADD CONSTRAINT fk_dataset_source_dataset_ref_dataset FOREIGN KEY (dataset_ref) REFERENCES agdc.dataset(id);


--
-- Name: dataset_source fk_dataset_source_source_dataset_ref_dataset; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_source
    ADD CONSTRAINT fk_dataset_source_source_dataset_ref_dataset FOREIGN KEY (source_dataset_ref) REFERENCES agdc.dataset(id);


--
-- Name: dataset_type fk_dataset_type_metadata_type_ref_metadata_type; Type: FK CONSTRAINT; Schema: agdc; Owner: agdc_admin
--

ALTER TABLE ONLY agdc.dataset_type
    ADD CONSTRAINT fk_dataset_type_metadata_type_ref_metadata_type FOREIGN KEY (metadata_type_ref) REFERENCES agdc.metadata_type(id);


--
-- Name: product_ranges product_ranges_id_fkey; Type: FK CONSTRAINT; Schema: wms; Owner: localuser
--

ALTER TABLE ONLY wms.product_ranges
    ADD CONSTRAINT product_ranges_id_fkey FOREIGN KEY (id) REFERENCES agdc.dataset_type(id);


--
-- Name: sub_product_ranges sub_product_ranges_product_id_fkey; Type: FK CONSTRAINT; Schema: wms; Owner: localuser
--

ALTER TABLE ONLY wms.sub_product_ranges
    ADD CONSTRAINT sub_product_ranges_product_id_fkey FOREIGN KEY (product_id) REFERENCES agdc.dataset_type(id);


--
-- Name: SCHEMA agdc; Type: ACL; Schema: -; Owner: agdc_admin
--

GRANT USAGE ON SCHEMA agdc TO agdc_user;
GRANT CREATE ON SCHEMA agdc TO agdc_manage;


--
-- Name: FUNCTION common_timestamp(text); Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT ALL ON FUNCTION agdc.common_timestamp(text) TO agdc_user;


--
-- Name: TABLE dataset; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT ON TABLE agdc.dataset TO agdc_user;
GRANT INSERT ON TABLE agdc.dataset TO agdc_ingest;


--
-- Name: TABLE dataset_location; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT ON TABLE agdc.dataset_location TO agdc_user;
GRANT INSERT ON TABLE agdc.dataset_location TO agdc_ingest;


--
-- Name: SEQUENCE dataset_location_id_seq; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT,USAGE ON SEQUENCE agdc.dataset_location_id_seq TO agdc_ingest;


--
-- Name: TABLE dataset_source; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT ON TABLE agdc.dataset_source TO agdc_user;
GRANT INSERT ON TABLE agdc.dataset_source TO agdc_ingest;


--
-- Name: TABLE dataset_type; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT ON TABLE agdc.dataset_type TO agdc_user;
GRANT INSERT,DELETE ON TABLE agdc.dataset_type TO agdc_manage;


--
-- Name: SEQUENCE dataset_type_id_seq; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT,USAGE ON SEQUENCE agdc.dataset_type_id_seq TO agdc_ingest;


--
-- Name: TABLE metadata_type; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT ON TABLE agdc.metadata_type TO agdc_user;
GRANT INSERT,DELETE ON TABLE agdc.metadata_type TO agdc_manage;


--
-- Name: SEQUENCE metadata_type_id_seq; Type: ACL; Schema: agdc; Owner: agdc_admin
--

GRANT SELECT,USAGE ON SEQUENCE agdc.metadata_type_id_seq TO agdc_ingest;


--
-- Name: TABLE space_time_view; Type: ACL; Schema: public; Owner: localuser
--

GRANT SELECT ON TABLE public.space_time_view TO PUBLIC;


--
-- Name: space_view; Type: MATERIALIZED VIEW DATA; Schema: public; Owner: localuser
--

REFRESH MATERIALIZED VIEW public.space_view;


--
-- Name: time_view; Type: MATERIALIZED VIEW DATA; Schema: public; Owner: localuser
--

REFRESH MATERIALIZED VIEW public.time_view;


--
-- Name: space_time_view; Type: MATERIALIZED VIEW DATA; Schema: public; Owner: localuser
--

REFRESH MATERIALIZED VIEW public.space_time_view;


--
-- PostgreSQL database dump complete
--

