import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableAppProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique name of the app profile in the form '[_a-zA-Z0-9][-_.a-zA-Z0-9]*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#app_profile_id BigtableAppProfile#app_profile_id}
    */
    readonly appProfileId: string;
    /**
    * Long form description of the use case for this app profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#description BigtableAppProfile#description}
    */
    readonly description?: string;
    /**
    * If true, ignore safety checks when deleting/updating the app profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#ignore_warnings BigtableAppProfile#ignore_warnings}
    */
    readonly ignoreWarnings?: boolean | cdktf.IResolvable;
    /**
    * The name of the instance to create the app profile within.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#instance BigtableAppProfile#instance}
    */
    readonly instance?: string;
    /**
    * If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available
  in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
  consistency to improve availability.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#multi_cluster_routing_use_any BigtableAppProfile#multi_cluster_routing_use_any}
    */
    readonly multiClusterRoutingUseAny?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#project BigtableAppProfile#project}
    */
    readonly project?: string;
    /**
    * single_cluster_routing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#single_cluster_routing BigtableAppProfile#single_cluster_routing}
    */
    readonly singleClusterRouting?: BigtableAppProfileSingleClusterRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#timeouts BigtableAppProfile#timeouts}
    */
    readonly timeouts?: BigtableAppProfileTimeouts;
}
export interface BigtableAppProfileSingleClusterRouting {
    /**
    * If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
  It is unsafe to send these requests to the same table/row/column in multiple clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#allow_transactional_writes BigtableAppProfile#allow_transactional_writes}
    */
    readonly allowTransactionalWrites?: boolean | cdktf.IResolvable;
    /**
    * The cluster to which read/write requests should be routed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#cluster_id BigtableAppProfile#cluster_id}
    */
    readonly clusterId: string;
}
export declare function bigtableAppProfileSingleClusterRoutingToTerraform(struct?: BigtableAppProfileSingleClusterRoutingOutputReference | BigtableAppProfileSingleClusterRouting): any;
export declare class BigtableAppProfileSingleClusterRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigtableAppProfileSingleClusterRouting | undefined;
    set internalValue(value: BigtableAppProfileSingleClusterRouting | undefined);
    private _allowTransactionalWrites?;
    get allowTransactionalWrites(): boolean | cdktf.IResolvable;
    set allowTransactionalWrites(value: boolean | cdktf.IResolvable);
    resetAllowTransactionalWrites(): void;
    get allowTransactionalWritesInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
}
export interface BigtableAppProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#create BigtableAppProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#delete BigtableAppProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile#update BigtableAppProfile#update}
    */
    readonly update?: string;
}
export declare function bigtableAppProfileTimeoutsToTerraform(struct?: BigtableAppProfileTimeoutsOutputReference | BigtableAppProfileTimeouts | cdktf.IResolvable): any;
export declare class BigtableAppProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigtableAppProfileTimeouts | undefined;
    set internalValue(value: BigtableAppProfileTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile google_bigtable_app_profile}
*/
export declare class BigtableAppProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_app_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile google_bigtable_app_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigtableAppProfileConfig
    */
    constructor(scope: Construct, id: string, config: BigtableAppProfileConfig);
    private _appProfileId?;
    get appProfileId(): string;
    set appProfileId(value: string);
    get appProfileIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _ignoreWarnings?;
    get ignoreWarnings(): boolean | cdktf.IResolvable;
    set ignoreWarnings(value: boolean | cdktf.IResolvable);
    resetIgnoreWarnings(): void;
    get ignoreWarningsInput(): boolean | cdktf.IResolvable | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _multiClusterRoutingUseAny?;
    get multiClusterRoutingUseAny(): boolean | cdktf.IResolvable;
    set multiClusterRoutingUseAny(value: boolean | cdktf.IResolvable);
    resetMultiClusterRoutingUseAny(): void;
    get multiClusterRoutingUseAnyInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _singleClusterRouting;
    get singleClusterRouting(): BigtableAppProfileSingleClusterRoutingOutputReference;
    putSingleClusterRouting(value: BigtableAppProfileSingleClusterRouting): void;
    resetSingleClusterRouting(): void;
    get singleClusterRoutingInput(): BigtableAppProfileSingleClusterRouting | undefined;
    private _timeouts;
    get timeouts(): BigtableAppProfileTimeoutsOutputReference;
    putTimeouts(value: BigtableAppProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigtableAppProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
