"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfunctionsFunction = exports.CloudfunctionsFunctionTimeoutsOutputReference = exports.cloudfunctionsFunctionTimeoutsToTerraform = exports.CloudfunctionsFunctionSourceRepositoryOutputReference = exports.cloudfunctionsFunctionSourceRepositoryToTerraform = exports.CloudfunctionsFunctionEventTriggerOutputReference = exports.cloudfunctionsFunctionEventTriggerToTerraform = exports.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference = exports.cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        retry: cdktf.booleanToTerraform(struct.retry),
    };
}
exports.cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform = cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform;
class CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._retry !== undefined) {
            hasAnyValues = true;
            internalValueResult.retry = this._retry;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._retry = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._retry = value.retry;
        }
    }
    get retry() {
        return this.getBooleanAttribute('retry');
    }
    set retry(value) {
        this._retry = value;
    }
    // Temporarily expose input value. Use with caution.
    get retryInput() {
        return this._retry;
    }
}
exports.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference = CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference[_a] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference", version: "0.7.1" };
function cloudfunctionsFunctionEventTriggerToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        event_type: cdktf.stringToTerraform(struct.eventType),
        resource: cdktf.stringToTerraform(struct.resource),
        failure_policy: cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct.failurePolicy),
    };
}
exports.cloudfunctionsFunctionEventTriggerToTerraform = cloudfunctionsFunctionEventTriggerToTerraform;
class CloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // failure_policy - computed: false, optional: true, required: false
        this._failurePolicy = new CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference(this, "failure_policy");
    }
    get internalValue() {
        var _f, _g;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._eventType !== undefined) {
            hasAnyValues = true;
            internalValueResult.eventType = this._eventType;
        }
        if (this._resource !== undefined) {
            hasAnyValues = true;
            internalValueResult.resource = this._resource;
        }
        if (((_f = this._failurePolicy) === null || _f === void 0 ? void 0 : _f.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.failurePolicy = (_g = this._failurePolicy) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._eventType = undefined;
            this._resource = undefined;
            this._failurePolicy.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._eventType = value.eventType;
            this._resource = value.resource;
            this._failurePolicy.internalValue = value.failurePolicy;
        }
    }
    get eventType() {
        return this.getStringAttribute('event_type');
    }
    set eventType(value) {
        this._eventType = value;
    }
    // Temporarily expose input value. Use with caution.
    get eventTypeInput() {
        return this._eventType;
    }
    get resource() {
        return this.getStringAttribute('resource');
    }
    set resource(value) {
        this._resource = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceInput() {
        return this._resource;
    }
    get failurePolicy() {
        return this._failurePolicy;
    }
    putFailurePolicy(value) {
        this._failurePolicy.internalValue = value;
    }
    resetFailurePolicy() {
        this._failurePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failurePolicyInput() {
        return this._failurePolicy.internalValue;
    }
}
exports.CloudfunctionsFunctionEventTriggerOutputReference = CloudfunctionsFunctionEventTriggerOutputReference;
_b = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionEventTriggerOutputReference[_b] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionEventTriggerOutputReference", version: "0.7.1" };
function cloudfunctionsFunctionSourceRepositoryToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        url: cdktf.stringToTerraform(struct.url),
    };
}
exports.cloudfunctionsFunctionSourceRepositoryToTerraform = cloudfunctionsFunctionSourceRepositoryToTerraform;
class CloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._url !== undefined) {
            hasAnyValues = true;
            internalValueResult.url = this._url;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._url = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._url = value.url;
        }
    }
    // deployed_url - computed: true, optional: false, required: false
    get deployedUrl() {
        return this.getStringAttribute('deployed_url');
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
}
exports.CloudfunctionsFunctionSourceRepositoryOutputReference = CloudfunctionsFunctionSourceRepositoryOutputReference;
_c = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionSourceRepositoryOutputReference[_c] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionSourceRepositoryOutputReference", version: "0.7.1" };
function cloudfunctionsFunctionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.cloudfunctionsFunctionTimeoutsToTerraform = cloudfunctionsFunctionTimeoutsToTerraform;
class CloudfunctionsFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.CloudfunctionsFunctionTimeoutsOutputReference = CloudfunctionsFunctionTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionTimeoutsOutputReference", version: "0.7.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function}
*/
class CloudfunctionsFunction extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudfunctionsFunctionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_cloudfunctions_function',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '3.90.1',
                providerVersionConstraint: '~> 3.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // event_trigger - computed: false, optional: true, required: false
        this._eventTrigger = new CloudfunctionsFunctionEventTriggerOutputReference(this, "event_trigger");
        // source_repository - computed: false, optional: true, required: false
        this._sourceRepository = new CloudfunctionsFunctionSourceRepositoryOutputReference(this, "source_repository");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new CloudfunctionsFunctionTimeoutsOutputReference(this, "timeouts");
        this._availableMemoryMb = config.availableMemoryMb;
        this._buildEnvironmentVariables = config.buildEnvironmentVariables;
        this._description = config.description;
        this._entryPoint = config.entryPoint;
        this._environmentVariables = config.environmentVariables;
        this._httpsTriggerUrl = config.httpsTriggerUrl;
        this._ingressSettings = config.ingressSettings;
        this._labels = config.labels;
        this._maxInstances = config.maxInstances;
        this._name = config.name;
        this._project = config.project;
        this._region = config.region;
        this._runtime = config.runtime;
        this._serviceAccountEmail = config.serviceAccountEmail;
        this._sourceArchiveBucket = config.sourceArchiveBucket;
        this._sourceArchiveObject = config.sourceArchiveObject;
        this._timeout = config.timeout;
        this._triggerHttp = config.triggerHttp;
        this._vpcConnector = config.vpcConnector;
        this._vpcConnectorEgressSettings = config.vpcConnectorEgressSettings;
        this._eventTrigger.internalValue = config.eventTrigger;
        this._sourceRepository.internalValue = config.sourceRepository;
        this._timeouts.internalValue = config.timeouts;
    }
    get availableMemoryMb() {
        return this.getNumberAttribute('available_memory_mb');
    }
    set availableMemoryMb(value) {
        this._availableMemoryMb = value;
    }
    resetAvailableMemoryMb() {
        this._availableMemoryMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availableMemoryMbInput() {
        return this._availableMemoryMb;
    }
    get buildEnvironmentVariables() {
        return this.getStringMapAttribute('build_environment_variables');
    }
    set buildEnvironmentVariables(value) {
        this._buildEnvironmentVariables = value;
    }
    resetBuildEnvironmentVariables() {
        this._buildEnvironmentVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildEnvironmentVariablesInput() {
        return this._buildEnvironmentVariables;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get entryPoint() {
        return this.getStringAttribute('entry_point');
    }
    set entryPoint(value) {
        this._entryPoint = value;
    }
    resetEntryPoint() {
        this._entryPoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get entryPointInput() {
        return this._entryPoint;
    }
    get environmentVariables() {
        return this.getStringMapAttribute('environment_variables');
    }
    set environmentVariables(value) {
        this._environmentVariables = value;
    }
    resetEnvironmentVariables() {
        this._environmentVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentVariablesInput() {
        return this._environmentVariables;
    }
    get httpsTriggerUrl() {
        return this.getStringAttribute('https_trigger_url');
    }
    set httpsTriggerUrl(value) {
        this._httpsTriggerUrl = value;
    }
    resetHttpsTriggerUrl() {
        this._httpsTriggerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpsTriggerUrlInput() {
        return this._httpsTriggerUrl;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ingressSettings() {
        return this.getStringAttribute('ingress_settings');
    }
    set ingressSettings(value) {
        this._ingressSettings = value;
    }
    resetIngressSettings() {
        this._ingressSettings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressSettingsInput() {
        return this._ingressSettings;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get maxInstances() {
        return this.getNumberAttribute('max_instances');
    }
    set maxInstances(value) {
        this._maxInstances = value;
    }
    resetMaxInstances() {
        this._maxInstances = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxInstancesInput() {
        return this._maxInstances;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get runtime() {
        return this.getStringAttribute('runtime');
    }
    set runtime(value) {
        this._runtime = value;
    }
    // Temporarily expose input value. Use with caution.
    get runtimeInput() {
        return this._runtime;
    }
    get serviceAccountEmail() {
        return this.getStringAttribute('service_account_email');
    }
    set serviceAccountEmail(value) {
        this._serviceAccountEmail = value;
    }
    resetServiceAccountEmail() {
        this._serviceAccountEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountEmailInput() {
        return this._serviceAccountEmail;
    }
    get sourceArchiveBucket() {
        return this.getStringAttribute('source_archive_bucket');
    }
    set sourceArchiveBucket(value) {
        this._sourceArchiveBucket = value;
    }
    resetSourceArchiveBucket() {
        this._sourceArchiveBucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceArchiveBucketInput() {
        return this._sourceArchiveBucket;
    }
    get sourceArchiveObject() {
        return this.getStringAttribute('source_archive_object');
    }
    set sourceArchiveObject(value) {
        this._sourceArchiveObject = value;
    }
    resetSourceArchiveObject() {
        this._sourceArchiveObject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceArchiveObjectInput() {
        return this._sourceArchiveObject;
    }
    get timeout() {
        return this.getNumberAttribute('timeout');
    }
    set timeout(value) {
        this._timeout = value;
    }
    resetTimeout() {
        this._timeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutInput() {
        return this._timeout;
    }
    get triggerHttp() {
        return this.getBooleanAttribute('trigger_http');
    }
    set triggerHttp(value) {
        this._triggerHttp = value;
    }
    resetTriggerHttp() {
        this._triggerHttp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggerHttpInput() {
        return this._triggerHttp;
    }
    get vpcConnector() {
        return this.getStringAttribute('vpc_connector');
    }
    set vpcConnector(value) {
        this._vpcConnector = value;
    }
    resetVpcConnector() {
        this._vpcConnector = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcConnectorInput() {
        return this._vpcConnector;
    }
    get vpcConnectorEgressSettings() {
        return this.getStringAttribute('vpc_connector_egress_settings');
    }
    set vpcConnectorEgressSettings(value) {
        this._vpcConnectorEgressSettings = value;
    }
    resetVpcConnectorEgressSettings() {
        this._vpcConnectorEgressSettings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcConnectorEgressSettingsInput() {
        return this._vpcConnectorEgressSettings;
    }
    get eventTrigger() {
        return this._eventTrigger;
    }
    putEventTrigger(value) {
        this._eventTrigger.internalValue = value;
    }
    resetEventTrigger() {
        this._eventTrigger.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventTriggerInput() {
        return this._eventTrigger.internalValue;
    }
    get sourceRepository() {
        return this._sourceRepository;
    }
    putSourceRepository(value) {
        this._sourceRepository.internalValue = value;
    }
    resetSourceRepository() {
        this._sourceRepository.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceRepositoryInput() {
        return this._sourceRepository.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            available_memory_mb: cdktf.numberToTerraform(this._availableMemoryMb),
            build_environment_variables: cdktf.hashMapper(cdktf.stringToTerraform)(this._buildEnvironmentVariables),
            description: cdktf.stringToTerraform(this._description),
            entry_point: cdktf.stringToTerraform(this._entryPoint),
            environment_variables: cdktf.hashMapper(cdktf.stringToTerraform)(this._environmentVariables),
            https_trigger_url: cdktf.stringToTerraform(this._httpsTriggerUrl),
            ingress_settings: cdktf.stringToTerraform(this._ingressSettings),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            max_instances: cdktf.numberToTerraform(this._maxInstances),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            region: cdktf.stringToTerraform(this._region),
            runtime: cdktf.stringToTerraform(this._runtime),
            service_account_email: cdktf.stringToTerraform(this._serviceAccountEmail),
            source_archive_bucket: cdktf.stringToTerraform(this._sourceArchiveBucket),
            source_archive_object: cdktf.stringToTerraform(this._sourceArchiveObject),
            timeout: cdktf.numberToTerraform(this._timeout),
            trigger_http: cdktf.booleanToTerraform(this._triggerHttp),
            vpc_connector: cdktf.stringToTerraform(this._vpcConnector),
            vpc_connector_egress_settings: cdktf.stringToTerraform(this._vpcConnectorEgressSettings),
            event_trigger: cloudfunctionsFunctionEventTriggerToTerraform(this._eventTrigger.internalValue),
            source_repository: cloudfunctionsFunctionSourceRepositoryToTerraform(this._sourceRepository.internalValue),
            timeouts: cloudfunctionsFunctionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.CloudfunctionsFunction = CloudfunctionsFunction;
_e = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunction[_e] = { fqn: "@cdktf/provider-google.CloudfunctionsFunction", version: "0.7.1" };
// =================
// STATIC PROPERTIES
// =================
CloudfunctionsFunction.tfResourceType = "google_cloudfunctions_function";
//# sourceMappingURL=data:application/json;base64,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