import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Lifetime of cookies in seconds if session_affinity is
  GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
  only until the end of the browser session (or equivalent). The
  maximum allowed value for TTL is one day.
  
  When the load balancing scheme is INTERNAL, this field is not used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#affinity_cookie_ttl_sec ComputeRegionBackendService#affinity_cookie_ttl_sec}
    */
    readonly affinityCookieTtlSec?: number;
    /**
    * Time for which instance will be drained (not accept new
  connections, but still work to finish started).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#connection_draining_timeout_sec ComputeRegionBackendService#connection_draining_timeout_sec}
    */
    readonly connectionDrainingTimeoutSec?: number;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#description ComputeRegionBackendService#description}
    */
    readonly description?: string;
    /**
    * If true, enable Cloud CDN for this RegionBackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#enable_cdn ComputeRegionBackendService#enable_cdn}
    */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
    * The set of URLs to HealthCheck resources for health checking
  this RegionBackendService. Currently at most one health
  check can be specified.
  
  A health check must be specified unless the backend service uses an internet
  or serverless NEG as a backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#health_checks ComputeRegionBackendService#health_checks}
    */
    readonly healthChecks?: string[];
    /**
    * Indicates what kind of load balancing this regional backend service
  will be used for. A backend service created for one type of load
  balancing cannot be used with the other(s). Default value: "INTERNAL" Possible values: ["EXTERNAL", "INTERNAL", "INTERNAL_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#load_balancing_scheme ComputeRegionBackendService#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * The load balancing algorithm used within the scope of the locality.
  The possible values are -
  
  * ROUND_ROBIN - This is a simple policy in which each healthy backend
                  is selected in round robin order.
  
  * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
                    hosts and picks the host which has fewer active requests.
  
  * RING_HASH - The ring/modulo hash load balancer implements consistent
                hashing to backends. The algorithm has the property that the
                addition/removal of a host from a set of N hosts only affects
                1/N of the requests.
  
  * RANDOM - The load balancer selects a random healthy host.
  
  * ORIGINAL_DESTINATION - Backend host is selected based on the client
                           connection metadata, i.e., connections are opened
                           to the same address as the destination address of
                           the incoming connection before the connection
                           was redirected to the load balancer.
  
  * MAGLEV - used as a drop in replacement for the ring hash load balancer.
             Maglev is not as stable as ring hash but has faster table lookup
             build times and host selection times. For more information about
             Maglev, refer to https://ai.google/research/pubs/pub44824
  
  This field is applicable only when the 'load_balancing_scheme' is set to
  INTERNAL_MANAGED and the 'protocol' is set to HTTP, HTTPS, or HTTP2. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#locality_lb_policy ComputeRegionBackendService#locality_lb_policy}
    */
    readonly localityLbPolicy?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#name ComputeRegionBackendService#name}
    */
    readonly name: string;
    /**
    * The URL of the network to which this backend service belongs.
  This field can only be specified when the load balancing scheme is set to INTERNAL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#network ComputeRegionBackendService#network}
    */
    readonly network?: string;
    /**
    * A named port on a backend instance group representing the port for
  communication to the backend VMs in that group. Required when the
  loadBalancingScheme is EXTERNAL, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
  and the backends are instance groups. The named port must be defined on each
  backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
  default of "http" if not given.
  Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#port_name ComputeRegionBackendService#port_name}
    */
    readonly portName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#project ComputeRegionBackendService#project}
    */
    readonly project?: string;
    /**
    * The protocol this RegionBackendService uses to communicate with backends.
  The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
  types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "SSL", "TCP", "UDP", "GRPC", "UNSPECIFIED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#protocol ComputeRegionBackendService#protocol}
    */
    readonly protocol?: string;
    /**
    * The Region in which the created backend service should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#region ComputeRegionBackendService#region}
    */
    readonly region?: string;
    /**
    * Type of session affinity to use. The default is NONE. Session affinity is
  not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE", "CLIENT_IP_NO_DESTINATION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#session_affinity ComputeRegionBackendService#session_affinity}
    */
    readonly sessionAffinity?: string;
    /**
    * How many seconds to wait for the backend before considering it a
  failed request. Default is 30 seconds. Valid range is [1, 86400].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#timeout_sec ComputeRegionBackendService#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#backend ComputeRegionBackendService#backend}
    */
    readonly backend?: ComputeRegionBackendServiceBackend[] | cdktf.IResolvable;
    /**
    * cdn_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#cdn_policy ComputeRegionBackendService#cdn_policy}
    */
    readonly cdnPolicy?: ComputeRegionBackendServiceCdnPolicy;
    /**
    * circuit_breakers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#circuit_breakers ComputeRegionBackendService#circuit_breakers}
    */
    readonly circuitBreakers?: ComputeRegionBackendServiceCircuitBreakers;
    /**
    * consistent_hash block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#consistent_hash ComputeRegionBackendService#consistent_hash}
    */
    readonly consistentHash?: ComputeRegionBackendServiceConsistentHash;
    /**
    * failover_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#failover_policy ComputeRegionBackendService#failover_policy}
    */
    readonly failoverPolicy?: ComputeRegionBackendServiceFailoverPolicy;
    /**
    * iap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#iap ComputeRegionBackendService#iap}
    */
    readonly iap?: ComputeRegionBackendServiceIap;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#log_config ComputeRegionBackendService#log_config}
    */
    readonly logConfig?: ComputeRegionBackendServiceLogConfig;
    /**
    * outlier_detection block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#outlier_detection ComputeRegionBackendService#outlier_detection}
    */
    readonly outlierDetection?: ComputeRegionBackendServiceOutlierDetection;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#timeouts ComputeRegionBackendService#timeouts}
    */
    readonly timeouts?: ComputeRegionBackendServiceTimeouts;
}
export interface ComputeRegionBackendServiceBackend {
    /**
    * Specifies the balancing mode for this backend. Default value: "CONNECTION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#balancing_mode ComputeRegionBackendService#balancing_mode}
    */
    readonly balancingMode?: string;
    /**
    * A multiplier applied to the group's maximum servicing capacity
  (based on UTILIZATION, RATE or CONNECTION).
  
  ~>**NOTE**: This field cannot be set for
  INTERNAL region backend services (default loadBalancingScheme),
  but is required for non-INTERNAL backend service. The total
  capacity_scaler for all backends must be non-zero.
  
  A setting of 0 means the group is completely drained, offering
  0% of its available Capacity. Valid range is [0.0,1.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#capacity_scaler ComputeRegionBackendService#capacity_scaler}
    */
    readonly capacityScaler?: number;
    /**
    * An optional description of this resource.
  Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#description ComputeRegionBackendService#description}
    */
    readonly description?: string;
    /**
    * This field designates whether this is a failover backend. More
  than one failover backend can be configured for a given RegionBackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#failover ComputeRegionBackendService#failover}
    */
    readonly failover?: boolean | cdktf.IResolvable;
    /**
    * The fully-qualified URL of an Instance Group or Network Endpoint
  Group resource. In case of instance group this defines the list
  of instances that serve traffic. Member virtual machine
  instances from each instance group must live in the same zone as
  the instance group itself. No two backends in a backend service
  are allowed to use same Instance Group resource.
  
  For Network Endpoint Groups this defines list of endpoints. All
  endpoints of Network Endpoint Group must be hosted on instances
  located in the same zone as the Network Endpoint Group.
  
  Backend services cannot mix Instance Group and
  Network Endpoint Group backends.
  
  When the 'load_balancing_scheme' is INTERNAL, only instance groups
  are supported.
  
  Note that you must specify an Instance Group or Network Endpoint
  Group resource using the fully-qualified URL, rather than a
  partial URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#group ComputeRegionBackendService#group}
    */
    readonly group: string;
    /**
    * The max number of simultaneous connections for the group. Can
  be used with either CONNECTION or UTILIZATION balancing modes.
  Cannot be set for INTERNAL backend services.
  
  For CONNECTION mode, either maxConnections or one
  of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
  as appropriate for group type, must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_connections ComputeRegionBackendService#max_connections}
    */
    readonly maxConnections?: number;
    /**
    * The max number of simultaneous connections that a single backend
  network endpoint can handle. Cannot be set
  for INTERNAL backend services.
  
  This is used to calculate the capacity of the group. Can be
  used in either CONNECTION or UTILIZATION balancing modes. For
  CONNECTION mode, either maxConnections or
  maxConnectionsPerEndpoint must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_connections_per_endpoint ComputeRegionBackendService#max_connections_per_endpoint}
    */
    readonly maxConnectionsPerEndpoint?: number;
    /**
    * The max number of simultaneous connections that a single
  backend instance can handle. Cannot be set for INTERNAL backend
  services.
  
  This is used to calculate the capacity of the group.
  Can be used in either CONNECTION or UTILIZATION balancing modes.
  For CONNECTION mode, either maxConnections or
  maxConnectionsPerInstance must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_connections_per_instance ComputeRegionBackendService#max_connections_per_instance}
    */
    readonly maxConnectionsPerInstance?: number;
    /**
    * The max requests per second (RPS) of the group. Cannot be set
  for INTERNAL backend services.
  
  Can be used with either RATE or UTILIZATION balancing modes,
  but required if RATE mode. Either maxRate or one
  of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
  group type, must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_rate ComputeRegionBackendService#max_rate}
    */
    readonly maxRate?: number;
    /**
    * The max requests per second (RPS) that a single backend network
  endpoint can handle. This is used to calculate the capacity of
  the group. Can be used in either balancing mode. For RATE mode,
  either maxRate or maxRatePerEndpoint must be set. Cannot be set
  for INTERNAL backend services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_rate_per_endpoint ComputeRegionBackendService#max_rate_per_endpoint}
    */
    readonly maxRatePerEndpoint?: number;
    /**
    * The max requests per second (RPS) that a single backend
  instance can handle. This is used to calculate the capacity of
  the group. Can be used in either balancing mode. For RATE mode,
  either maxRate or maxRatePerInstance must be set. Cannot be set
  for INTERNAL backend services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_rate_per_instance ComputeRegionBackendService#max_rate_per_instance}
    */
    readonly maxRatePerInstance?: number;
    /**
    * Used when balancingMode is UTILIZATION. This ratio defines the
  CPU utilization target for the group. Valid range is [0.0, 1.0].
  Cannot be set for INTERNAL backend services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_utilization ComputeRegionBackendService#max_utilization}
    */
    readonly maxUtilization?: number;
}
export declare function computeRegionBackendServiceBackendToTerraform(struct?: ComputeRegionBackendServiceBackend | cdktf.IResolvable): any;
export interface ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy {
    /**
    * If true requests to different hosts will be cached separately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#include_host ComputeRegionBackendService#include_host}
    */
    readonly includeHost?: boolean | cdktf.IResolvable;
    /**
    * If true, http and https requests will be cached separately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#include_protocol ComputeRegionBackendService#include_protocol}
    */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
    * If true, include query string parameters in the cache key
  according to query_string_whitelist and
  query_string_blacklist. If neither is set, the entire query
  string will be included.
  
  If false, the query string will be excluded from the cache
  key entirely.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#include_query_string ComputeRegionBackendService#include_query_string}
    */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
    * Names of query string parameters to exclude in cache keys.
  
  All other parameters will be included. Either specify
  query_string_whitelist or query_string_blacklist, not both.
  '&' and '=' will be percent encoded and not treated as
  delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#query_string_blacklist ComputeRegionBackendService#query_string_blacklist}
    */
    readonly queryStringBlacklist?: string[];
    /**
    * Names of query string parameters to include in cache keys.
  
  All other parameters will be excluded. Either specify
  query_string_whitelist or query_string_blacklist, not both.
  '&' and '=' will be percent encoded and not treated as
  delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#query_string_whitelist ComputeRegionBackendService#query_string_whitelist}
    */
    readonly queryStringWhitelist?: string[];
}
export declare function computeRegionBackendServiceCdnPolicyCacheKeyPolicyToTerraform(struct?: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicyOutputReference | ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy): any;
export declare class ComputeRegionBackendServiceCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy | undefined);
    private _includeHost?;
    get includeHost(): boolean | cdktf.IResolvable;
    set includeHost(value: boolean | cdktf.IResolvable);
    resetIncludeHost(): void;
    get includeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _includeProtocol?;
    get includeProtocol(): boolean | cdktf.IResolvable;
    set includeProtocol(value: boolean | cdktf.IResolvable);
    resetIncludeProtocol(): void;
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQueryString?;
    get includeQueryString(): boolean | cdktf.IResolvable;
    set includeQueryString(value: boolean | cdktf.IResolvable);
    resetIncludeQueryString(): void;
    get includeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringBlacklist?;
    get queryStringBlacklist(): string[];
    set queryStringBlacklist(value: string[]);
    resetQueryStringBlacklist(): void;
    get queryStringBlacklistInput(): string[] | undefined;
    private _queryStringWhitelist?;
    get queryStringWhitelist(): string[];
    set queryStringWhitelist(value: string[]);
    resetQueryStringWhitelist(): void;
    get queryStringWhitelistInput(): string[] | undefined;
}
export interface ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy {
    /**
    * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
  can be specified as values, and you cannot specify a status code more than once.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#code ComputeRegionBackendService#code}
    */
    readonly code?: number;
}
export declare function computeRegionBackendServiceCdnPolicyNegativeCachingPolicyToTerraform(struct?: ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy | cdktf.IResolvable): any;
export interface ComputeRegionBackendServiceCdnPolicy {
    /**
    * Specifies the cache setting for all responses from this backend.
  The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#cache_mode ComputeRegionBackendService#cache_mode}
    */
    readonly cacheMode?: string;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#client_ttl ComputeRegionBackendService#client_ttl}
    */
    readonly clientTtl?: number;
    /**
    * Specifies the default TTL for cached content served by this origin for responses
  that do not have an existing valid TTL (max-age or s-max-age).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#default_ttl ComputeRegionBackendService#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_ttl ComputeRegionBackendService#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#negative_caching ComputeRegionBackendService#negative_caching}
    */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
    * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#serve_while_stale ComputeRegionBackendService#serve_while_stale}
    */
    readonly serveWhileStale?: number;
    /**
    * Maximum number of seconds the response to a signed URL request
  will be considered fresh, defaults to 1hr (3600s). After this
  time period, the response will be revalidated before
  being served.
  
  When serving responses to signed URL requests, Cloud CDN will
  internally behave as though all responses from this backend had a
  "Cache-Control: public, max-age=[TTL]" header, regardless of any
  existing Cache-Control header. The actual headers served in
  responses will not be altered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#signed_url_cache_max_age_sec ComputeRegionBackendService#signed_url_cache_max_age_sec}
    */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
    * cache_key_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#cache_key_policy ComputeRegionBackendService#cache_key_policy}
    */
    readonly cacheKeyPolicy?: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy;
    /**
    * negative_caching_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#negative_caching_policy ComputeRegionBackendService#negative_caching_policy}
    */
    readonly negativeCachingPolicy?: ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
}
export declare function computeRegionBackendServiceCdnPolicyToTerraform(struct?: ComputeRegionBackendServiceCdnPolicyOutputReference | ComputeRegionBackendServiceCdnPolicy): any;
export declare class ComputeRegionBackendServiceCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceCdnPolicy | undefined;
    set internalValue(value: ComputeRegionBackendServiceCdnPolicy | undefined);
    private _cacheMode?;
    get cacheMode(): string;
    set cacheMode(value: string);
    resetCacheMode(): void;
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    get clientTtl(): number;
    set clientTtl(value: number);
    resetClientTtl(): void;
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    get negativeCaching(): boolean | cdktf.IResolvable;
    set negativeCaching(value: boolean | cdktf.IResolvable);
    resetNegativeCaching(): void;
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    get serveWhileStale(): number;
    set serveWhileStale(value: number);
    resetServeWhileStale(): void;
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    get signedUrlCacheMaxAgeSec(): number;
    set signedUrlCacheMaxAgeSec(value: number);
    resetSignedUrlCacheMaxAgeSec(): void;
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): ComputeRegionBackendServiceCdnPolicyCacheKeyPolicyOutputReference;
    putCacheKeyPolicy(value: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy): void;
    resetCacheKeyPolicy(): void;
    get cacheKeyPolicyInput(): ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    private _negativeCachingPolicy?;
    get negativeCachingPolicy(): ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
    set negativeCachingPolicy(value: ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable);
    resetNegativeCachingPolicy(): void;
    get negativeCachingPolicyInput(): cdktf.IResolvable | ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined;
}
export interface ComputeRegionBackendServiceCircuitBreakers {
    /**
    * The maximum number of connections to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_connections ComputeRegionBackendService#max_connections}
    */
    readonly maxConnections?: number;
    /**
    * The maximum number of pending requests to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_pending_requests ComputeRegionBackendService#max_pending_requests}
    */
    readonly maxPendingRequests?: number;
    /**
    * The maximum number of parallel requests to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_requests ComputeRegionBackendService#max_requests}
    */
    readonly maxRequests?: number;
    /**
    * Maximum requests for a single backend connection. This parameter
  is respected by both the HTTP/1.1 and HTTP/2 implementations. If
  not specified, there is no limit. Setting this parameter to 1
  will effectively disable keep alive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_requests_per_connection ComputeRegionBackendService#max_requests_per_connection}
    */
    readonly maxRequestsPerConnection?: number;
    /**
    * The maximum number of parallel retries to the backend cluster.
  Defaults to 3.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_retries ComputeRegionBackendService#max_retries}
    */
    readonly maxRetries?: number;
}
export declare function computeRegionBackendServiceCircuitBreakersToTerraform(struct?: ComputeRegionBackendServiceCircuitBreakersOutputReference | ComputeRegionBackendServiceCircuitBreakers): any;
export declare class ComputeRegionBackendServiceCircuitBreakersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceCircuitBreakers | undefined;
    set internalValue(value: ComputeRegionBackendServiceCircuitBreakers | undefined);
    private _maxConnections?;
    get maxConnections(): number;
    set maxConnections(value: number);
    resetMaxConnections(): void;
    get maxConnectionsInput(): number | undefined;
    private _maxPendingRequests?;
    get maxPendingRequests(): number;
    set maxPendingRequests(value: number);
    resetMaxPendingRequests(): void;
    get maxPendingRequestsInput(): number | undefined;
    private _maxRequests?;
    get maxRequests(): number;
    set maxRequests(value: number);
    resetMaxRequests(): void;
    get maxRequestsInput(): number | undefined;
    private _maxRequestsPerConnection?;
    get maxRequestsPerConnection(): number;
    set maxRequestsPerConnection(value: number);
    resetMaxRequestsPerConnection(): void;
    get maxRequestsPerConnectionInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
}
export interface ComputeRegionBackendServiceConsistentHashHttpCookieTtl {
    /**
    * Span of time that's a fraction of a second at nanosecond
  resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must
  be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#nanos ComputeRegionBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
  Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#seconds ComputeRegionBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeRegionBackendServiceConsistentHashHttpCookieTtlToTerraform(struct?: ComputeRegionBackendServiceConsistentHashHttpCookieTtlOutputReference | ComputeRegionBackendServiceConsistentHashHttpCookieTtl): any;
export declare class ComputeRegionBackendServiceConsistentHashHttpCookieTtlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceConsistentHashHttpCookieTtl | undefined;
    set internalValue(value: ComputeRegionBackendServiceConsistentHashHttpCookieTtl | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeRegionBackendServiceConsistentHashHttpCookie {
    /**
    * Name of the cookie.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#name ComputeRegionBackendService#name}
    */
    readonly name?: string;
    /**
    * Path to set for the cookie.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#path ComputeRegionBackendService#path}
    */
    readonly path?: string;
    /**
    * ttl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#ttl ComputeRegionBackendService#ttl}
    */
    readonly ttl?: ComputeRegionBackendServiceConsistentHashHttpCookieTtl;
}
export declare function computeRegionBackendServiceConsistentHashHttpCookieToTerraform(struct?: ComputeRegionBackendServiceConsistentHashHttpCookieOutputReference | ComputeRegionBackendServiceConsistentHashHttpCookie): any;
export declare class ComputeRegionBackendServiceConsistentHashHttpCookieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceConsistentHashHttpCookie | undefined;
    set internalValue(value: ComputeRegionBackendServiceConsistentHashHttpCookie | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _ttl;
    get ttl(): ComputeRegionBackendServiceConsistentHashHttpCookieTtlOutputReference;
    putTtl(value: ComputeRegionBackendServiceConsistentHashHttpCookieTtl): void;
    resetTtl(): void;
    get ttlInput(): ComputeRegionBackendServiceConsistentHashHttpCookieTtl | undefined;
}
export interface ComputeRegionBackendServiceConsistentHash {
    /**
    * The hash based on the value of the specified header field.
  This field is applicable if the sessionAffinity is set to HEADER_FIELD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#http_header_name ComputeRegionBackendService#http_header_name}
    */
    readonly httpHeaderName?: string;
    /**
    * The minimum number of virtual nodes to use for the hash ring.
  Larger ring sizes result in more granular load
  distributions. If the number of hosts in the load balancing pool
  is larger than the ring size, each host will be assigned a single
  virtual node.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#minimum_ring_size ComputeRegionBackendService#minimum_ring_size}
    */
    readonly minimumRingSize?: number;
    /**
    * http_cookie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#http_cookie ComputeRegionBackendService#http_cookie}
    */
    readonly httpCookie?: ComputeRegionBackendServiceConsistentHashHttpCookie;
}
export declare function computeRegionBackendServiceConsistentHashToTerraform(struct?: ComputeRegionBackendServiceConsistentHashOutputReference | ComputeRegionBackendServiceConsistentHash): any;
export declare class ComputeRegionBackendServiceConsistentHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceConsistentHash | undefined;
    set internalValue(value: ComputeRegionBackendServiceConsistentHash | undefined);
    private _httpHeaderName?;
    get httpHeaderName(): string;
    set httpHeaderName(value: string);
    resetHttpHeaderName(): void;
    get httpHeaderNameInput(): string | undefined;
    private _minimumRingSize?;
    get minimumRingSize(): number;
    set minimumRingSize(value: number);
    resetMinimumRingSize(): void;
    get minimumRingSizeInput(): number | undefined;
    private _httpCookie;
    get httpCookie(): ComputeRegionBackendServiceConsistentHashHttpCookieOutputReference;
    putHttpCookie(value: ComputeRegionBackendServiceConsistentHashHttpCookie): void;
    resetHttpCookie(): void;
    get httpCookieInput(): ComputeRegionBackendServiceConsistentHashHttpCookie | undefined;
}
export interface ComputeRegionBackendServiceFailoverPolicy {
    /**
    * On failover or failback, this field indicates whether connection drain
  will be honored. Setting this to true has the following effect: connections
  to the old active pool are not drained. Connections to the new active pool
  use the timeout of 10 min (currently fixed). Setting to false has the
  following effect: both old and new connections will have a drain timeout
  of 10 min.
  This can be set to true only if the protocol is TCP.
  The default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#disable_connection_drain_on_failover ComputeRegionBackendService#disable_connection_drain_on_failover}
    */
    readonly disableConnectionDrainOnFailover?: boolean | cdktf.IResolvable;
    /**
    * This option is used only when no healthy VMs are detected in the primary
  and backup instance groups. When set to true, traffic is dropped. When
  set to false, new connections are sent across all VMs in the primary group.
  The default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#drop_traffic_if_unhealthy ComputeRegionBackendService#drop_traffic_if_unhealthy}
    */
    readonly dropTrafficIfUnhealthy?: boolean | cdktf.IResolvable;
    /**
    * The value of the field must be in [0, 1]. If the ratio of the healthy
  VMs in the primary backend is at or below this number, traffic arriving
  at the load-balanced IP will be directed to the failover backend.
  In case where 'failoverRatio' is not set or all the VMs in the backup
  backend are unhealthy, the traffic will be directed back to the primary
  backend in the "force" mode, where traffic will be spread to the healthy
  VMs with the best effort, or to all VMs when no VM is healthy.
  This field is only used with l4 load balancing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#failover_ratio ComputeRegionBackendService#failover_ratio}
    */
    readonly failoverRatio?: number;
}
export declare function computeRegionBackendServiceFailoverPolicyToTerraform(struct?: ComputeRegionBackendServiceFailoverPolicyOutputReference | ComputeRegionBackendServiceFailoverPolicy): any;
export declare class ComputeRegionBackendServiceFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceFailoverPolicy | undefined;
    set internalValue(value: ComputeRegionBackendServiceFailoverPolicy | undefined);
    private _disableConnectionDrainOnFailover?;
    get disableConnectionDrainOnFailover(): boolean | cdktf.IResolvable;
    set disableConnectionDrainOnFailover(value: boolean | cdktf.IResolvable);
    resetDisableConnectionDrainOnFailover(): void;
    get disableConnectionDrainOnFailoverInput(): boolean | cdktf.IResolvable | undefined;
    private _dropTrafficIfUnhealthy?;
    get dropTrafficIfUnhealthy(): boolean | cdktf.IResolvable;
    set dropTrafficIfUnhealthy(value: boolean | cdktf.IResolvable);
    resetDropTrafficIfUnhealthy(): void;
    get dropTrafficIfUnhealthyInput(): boolean | cdktf.IResolvable | undefined;
    private _failoverRatio?;
    get failoverRatio(): number;
    set failoverRatio(value: number);
    resetFailoverRatio(): void;
    get failoverRatioInput(): number | undefined;
}
export interface ComputeRegionBackendServiceIap {
    /**
    * OAuth2 Client ID for IAP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#oauth2_client_id ComputeRegionBackendService#oauth2_client_id}
    */
    readonly oauth2ClientId: string;
    /**
    * OAuth2 Client Secret for IAP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#oauth2_client_secret ComputeRegionBackendService#oauth2_client_secret}
    */
    readonly oauth2ClientSecret: string;
}
export declare function computeRegionBackendServiceIapToTerraform(struct?: ComputeRegionBackendServiceIapOutputReference | ComputeRegionBackendServiceIap): any;
export declare class ComputeRegionBackendServiceIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceIap | undefined;
    set internalValue(value: ComputeRegionBackendServiceIap | undefined);
    private _oauth2ClientId?;
    get oauth2ClientId(): string;
    set oauth2ClientId(value: string);
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    get oauth2ClientSecret(): string;
    set oauth2ClientSecret(value: string);
    get oauth2ClientSecretInput(): string | undefined;
    get oauth2ClientSecretSha256(): string;
}
export interface ComputeRegionBackendServiceLogConfig {
    /**
    * Whether to enable logging for the load balancer traffic served by this backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#enable ComputeRegionBackendService#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * This field can only be specified if logging is enabled for this backend service. The value of
  the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
  where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
  The default value is 1.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#sample_rate ComputeRegionBackendService#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function computeRegionBackendServiceLogConfigToTerraform(struct?: ComputeRegionBackendServiceLogConfigOutputReference | ComputeRegionBackendServiceLogConfig): any;
export declare class ComputeRegionBackendServiceLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceLogConfig | undefined;
    set internalValue(value: ComputeRegionBackendServiceLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
export interface ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#nanos ComputeRegionBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#seconds ComputeRegionBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeRegionBackendServiceOutlierDetectionBaseEjectionTimeToTerraform(struct?: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTimeOutputReference | ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime): any;
export declare class ComputeRegionBackendServiceOutlierDetectionBaseEjectionTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    set internalValue(value: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeRegionBackendServiceOutlierDetectionInterval {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#nanos ComputeRegionBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#seconds ComputeRegionBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeRegionBackendServiceOutlierDetectionIntervalToTerraform(struct?: ComputeRegionBackendServiceOutlierDetectionIntervalOutputReference | ComputeRegionBackendServiceOutlierDetectionInterval): any;
export declare class ComputeRegionBackendServiceOutlierDetectionIntervalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceOutlierDetectionInterval | undefined;
    set internalValue(value: ComputeRegionBackendServiceOutlierDetectionInterval | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeRegionBackendServiceOutlierDetection {
    /**
    * Number of errors before a host is ejected from the connection pool. When the
  backend host is accessed over HTTP, a 5xx return code qualifies as an error.
  Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#consecutive_errors ComputeRegionBackendService#consecutive_errors}
    */
    readonly consecutiveErrors?: number;
    /**
    * The number of consecutive gateway failures (502, 503, 504 status or connection
  errors that are mapped to one of those status codes) before a consecutive
  gateway failure ejection occurs. Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#consecutive_gateway_failure ComputeRegionBackendService#consecutive_gateway_failure}
    */
    readonly consecutiveGatewayFailure?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through consecutive 5xx. This setting can be used to disable
  ejection or to ramp it up slowly. Defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#enforcing_consecutive_errors ComputeRegionBackendService#enforcing_consecutive_errors}
    */
    readonly enforcingConsecutiveErrors?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through consecutive gateway failures. This setting can be
  used to disable ejection or to ramp it up slowly. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#enforcing_consecutive_gateway_failure ComputeRegionBackendService#enforcing_consecutive_gateway_failure}
    */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through success rate statistics. This setting can be used to
  disable ejection or to ramp it up slowly. Defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#enforcing_success_rate ComputeRegionBackendService#enforcing_success_rate}
    */
    readonly enforcingSuccessRate?: number;
    /**
    * Maximum percentage of hosts in the load balancing pool for the backend service
  that can be ejected. Defaults to 10%.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#max_ejection_percent ComputeRegionBackendService#max_ejection_percent}
    */
    readonly maxEjectionPercent?: number;
    /**
    * The number of hosts in a cluster that must have enough request volume to detect
  success rate outliers. If the number of hosts is less than this setting, outlier
  detection via success rate statistics is not performed for any host in the
  cluster. Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#success_rate_minimum_hosts ComputeRegionBackendService#success_rate_minimum_hosts}
    */
    readonly successRateMinimumHosts?: number;
    /**
    * The minimum number of total requests that must be collected in one interval (as
  defined by the interval duration above) to include this host in success rate
  based outlier detection. If the volume is lower than this setting, outlier
  detection via success rate statistics is not performed for that host. Defaults
  to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#success_rate_request_volume ComputeRegionBackendService#success_rate_request_volume}
    */
    readonly successRateRequestVolume?: number;
    /**
    * This factor is used to determine the ejection threshold for success rate outlier
  ejection. The ejection threshold is the difference between the mean success
  rate, and the product of this factor and the standard deviation of the mean
  success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
  by a thousand to get a double. That is, if the desired factor is 1.9, the
  runtime value should be 1900. Defaults to 1900.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#success_rate_stdev_factor ComputeRegionBackendService#success_rate_stdev_factor}
    */
    readonly successRateStdevFactor?: number;
    /**
    * base_ejection_time block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#base_ejection_time ComputeRegionBackendService#base_ejection_time}
    */
    readonly baseEjectionTime?: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime;
    /**
    * interval block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#interval ComputeRegionBackendService#interval}
    */
    readonly interval?: ComputeRegionBackendServiceOutlierDetectionInterval;
}
export declare function computeRegionBackendServiceOutlierDetectionToTerraform(struct?: ComputeRegionBackendServiceOutlierDetectionOutputReference | ComputeRegionBackendServiceOutlierDetection): any;
export declare class ComputeRegionBackendServiceOutlierDetectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceOutlierDetection | undefined;
    set internalValue(value: ComputeRegionBackendServiceOutlierDetection | undefined);
    private _consecutiveErrors?;
    get consecutiveErrors(): number;
    set consecutiveErrors(value: number);
    resetConsecutiveErrors(): void;
    get consecutiveErrorsInput(): number | undefined;
    private _consecutiveGatewayFailure?;
    get consecutiveGatewayFailure(): number;
    set consecutiveGatewayFailure(value: number);
    resetConsecutiveGatewayFailure(): void;
    get consecutiveGatewayFailureInput(): number | undefined;
    private _enforcingConsecutiveErrors?;
    get enforcingConsecutiveErrors(): number;
    set enforcingConsecutiveErrors(value: number);
    resetEnforcingConsecutiveErrors(): void;
    get enforcingConsecutiveErrorsInput(): number | undefined;
    private _enforcingConsecutiveGatewayFailure?;
    get enforcingConsecutiveGatewayFailure(): number;
    set enforcingConsecutiveGatewayFailure(value: number);
    resetEnforcingConsecutiveGatewayFailure(): void;
    get enforcingConsecutiveGatewayFailureInput(): number | undefined;
    private _enforcingSuccessRate?;
    get enforcingSuccessRate(): number;
    set enforcingSuccessRate(value: number);
    resetEnforcingSuccessRate(): void;
    get enforcingSuccessRateInput(): number | undefined;
    private _maxEjectionPercent?;
    get maxEjectionPercent(): number;
    set maxEjectionPercent(value: number);
    resetMaxEjectionPercent(): void;
    get maxEjectionPercentInput(): number | undefined;
    private _successRateMinimumHosts?;
    get successRateMinimumHosts(): number;
    set successRateMinimumHosts(value: number);
    resetSuccessRateMinimumHosts(): void;
    get successRateMinimumHostsInput(): number | undefined;
    private _successRateRequestVolume?;
    get successRateRequestVolume(): number;
    set successRateRequestVolume(value: number);
    resetSuccessRateRequestVolume(): void;
    get successRateRequestVolumeInput(): number | undefined;
    private _successRateStdevFactor?;
    get successRateStdevFactor(): number;
    set successRateStdevFactor(value: number);
    resetSuccessRateStdevFactor(): void;
    get successRateStdevFactorInput(): number | undefined;
    private _baseEjectionTime;
    get baseEjectionTime(): ComputeRegionBackendServiceOutlierDetectionBaseEjectionTimeOutputReference;
    putBaseEjectionTime(value: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime): void;
    resetBaseEjectionTime(): void;
    get baseEjectionTimeInput(): ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    private _interval;
    get interval(): ComputeRegionBackendServiceOutlierDetectionIntervalOutputReference;
    putInterval(value: ComputeRegionBackendServiceOutlierDetectionInterval): void;
    resetInterval(): void;
    get intervalInput(): ComputeRegionBackendServiceOutlierDetectionInterval | undefined;
}
export interface ComputeRegionBackendServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#create ComputeRegionBackendService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#delete ComputeRegionBackendService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service#update ComputeRegionBackendService#update}
    */
    readonly update?: string;
}
export declare function computeRegionBackendServiceTimeoutsToTerraform(struct?: ComputeRegionBackendServiceTimeoutsOutputReference | ComputeRegionBackendServiceTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionBackendServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionBackendServiceTimeouts | undefined;
    set internalValue(value: ComputeRegionBackendServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service google_compute_region_backend_service}
*/
export declare class ComputeRegionBackendService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_backend_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service google_compute_region_backend_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionBackendServiceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionBackendServiceConfig);
    private _affinityCookieTtlSec?;
    get affinityCookieTtlSec(): number;
    set affinityCookieTtlSec(value: number);
    resetAffinityCookieTtlSec(): void;
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    get connectionDrainingTimeoutSec(): number;
    set connectionDrainingTimeoutSec(value: number);
    resetConnectionDrainingTimeoutSec(): void;
    get connectionDrainingTimeoutSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    get enableCdn(): boolean | cdktf.IResolvable;
    set enableCdn(value: boolean | cdktf.IResolvable);
    resetEnableCdn(): void;
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    get fingerprint(): string;
    private _healthChecks?;
    get healthChecks(): string[];
    set healthChecks(value: string[]);
    resetHealthChecks(): void;
    get healthChecksInput(): string[] | undefined;
    get id(): string;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    get localityLbPolicy(): string;
    set localityLbPolicy(value: string);
    resetLocalityLbPolicy(): void;
    get localityLbPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _sessionAffinity?;
    get sessionAffinity(): string;
    set sessionAffinity(value: string);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _backend?;
    get backend(): ComputeRegionBackendServiceBackend[] | cdktf.IResolvable;
    set backend(value: ComputeRegionBackendServiceBackend[] | cdktf.IResolvable);
    resetBackend(): void;
    get backendInput(): cdktf.IResolvable | ComputeRegionBackendServiceBackend[] | undefined;
    private _cdnPolicy;
    get cdnPolicy(): ComputeRegionBackendServiceCdnPolicyOutputReference;
    putCdnPolicy(value: ComputeRegionBackendServiceCdnPolicy): void;
    resetCdnPolicy(): void;
    get cdnPolicyInput(): ComputeRegionBackendServiceCdnPolicy | undefined;
    private _circuitBreakers;
    get circuitBreakers(): ComputeRegionBackendServiceCircuitBreakersOutputReference;
    putCircuitBreakers(value: ComputeRegionBackendServiceCircuitBreakers): void;
    resetCircuitBreakers(): void;
    get circuitBreakersInput(): ComputeRegionBackendServiceCircuitBreakers | undefined;
    private _consistentHash;
    get consistentHash(): ComputeRegionBackendServiceConsistentHashOutputReference;
    putConsistentHash(value: ComputeRegionBackendServiceConsistentHash): void;
    resetConsistentHash(): void;
    get consistentHashInput(): ComputeRegionBackendServiceConsistentHash | undefined;
    private _failoverPolicy;
    get failoverPolicy(): ComputeRegionBackendServiceFailoverPolicyOutputReference;
    putFailoverPolicy(value: ComputeRegionBackendServiceFailoverPolicy): void;
    resetFailoverPolicy(): void;
    get failoverPolicyInput(): ComputeRegionBackendServiceFailoverPolicy | undefined;
    private _iap;
    get iap(): ComputeRegionBackendServiceIapOutputReference;
    putIap(value: ComputeRegionBackendServiceIap): void;
    resetIap(): void;
    get iapInput(): ComputeRegionBackendServiceIap | undefined;
    private _logConfig;
    get logConfig(): ComputeRegionBackendServiceLogConfigOutputReference;
    putLogConfig(value: ComputeRegionBackendServiceLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeRegionBackendServiceLogConfig | undefined;
    private _outlierDetection;
    get outlierDetection(): ComputeRegionBackendServiceOutlierDetectionOutputReference;
    putOutlierDetection(value: ComputeRegionBackendServiceOutlierDetection): void;
    resetOutlierDetection(): void;
    get outlierDetectionInput(): ComputeRegionBackendServiceOutlierDetection | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionBackendServiceTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionBackendServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionBackendServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
