import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-defined name of the function. Function names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function#name DataGoogleCloudfunctionsFunction#name}
    */
    readonly name: string;
    /**
    * Project of the function. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function#project DataGoogleCloudfunctionsFunction#project}
    */
    readonly project?: string;
    /**
    * Region of function. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function#region DataGoogleCloudfunctionsFunction#region}
    */
    readonly region?: string;
}
export interface DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy {
}
export declare function dataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct?: DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy): any;
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined);
    get retry(): cdktf.IResolvable;
}
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionEventTrigger {
}
export declare function dataGoogleCloudfunctionsFunctionEventTriggerToTerraform(struct?: DataGoogleCloudfunctionsFunctionEventTrigger): any;
export declare class DataGoogleCloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionEventTrigger | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionEventTrigger | undefined);
    get eventType(): string;
    private _failurePolicy;
    get failurePolicy(): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyList;
    get resource(): string;
}
export declare class DataGoogleCloudfunctionsFunctionEventTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionEventTriggerOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionSourceRepository {
}
export declare function dataGoogleCloudfunctionsFunctionSourceRepositoryToTerraform(struct?: DataGoogleCloudfunctionsFunctionSourceRepository): any;
export declare class DataGoogleCloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionSourceRepository | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionSourceRepository | undefined);
    get deployedUrl(): string;
    get url(): string;
}
export declare class DataGoogleCloudfunctionsFunctionSourceRepositoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionSourceRepositoryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function google_cloudfunctions_function}
*/
export declare class DataGoogleCloudfunctionsFunction extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloudfunctions_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function google_cloudfunctions_function} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudfunctionsFunctionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudfunctionsFunctionConfig);
    get availableMemoryMb(): number;
    buildEnvironmentVariables(key: string): string | cdktf.IResolvable;
    get description(): string;
    get entryPoint(): string;
    environmentVariables(key: string): string | cdktf.IResolvable;
    private _eventTrigger;
    get eventTrigger(): DataGoogleCloudfunctionsFunctionEventTriggerList;
    get httpsTriggerUrl(): string;
    get id(): string;
    get ingressSettings(): string;
    labels(key: string): string | cdktf.IResolvable;
    get maxInstances(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get runtime(): string;
    get serviceAccountEmail(): string;
    get sourceArchiveBucket(): string;
    get sourceArchiveObject(): string;
    private _sourceRepository;
    get sourceRepository(): DataGoogleCloudfunctionsFunctionSourceRepositoryList;
    get timeout(): number;
    get triggerHttp(): cdktf.IResolvable;
    get vpcConnector(): string;
    get vpcConnectorEgressSettings(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
