import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. The name must be 1-63 characters long, and
  comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
  which means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#name DataGoogleComputeRouter#name}
    */
    readonly name: string;
    /**
    * A reference to the network to which this router belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#network DataGoogleComputeRouter#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#project DataGoogleComputeRouter#project}
    */
    readonly project?: string;
    /**
    * Region where the router resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#region DataGoogleComputeRouter#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeRouterBgpAdvertisedIpRanges {
}
export declare function dataGoogleComputeRouterBgpAdvertisedIpRangesToTerraform(struct?: DataGoogleComputeRouterBgpAdvertisedIpRanges): any;
export declare class DataGoogleComputeRouterBgpAdvertisedIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterBgpAdvertisedIpRanges | undefined;
    set internalValue(value: DataGoogleComputeRouterBgpAdvertisedIpRanges | undefined);
    get description(): string;
    get range(): string;
}
export declare class DataGoogleComputeRouterBgpAdvertisedIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterBgpAdvertisedIpRangesOutputReference;
}
export interface DataGoogleComputeRouterBgp {
}
export declare function dataGoogleComputeRouterBgpToTerraform(struct?: DataGoogleComputeRouterBgp): any;
export declare class DataGoogleComputeRouterBgpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterBgp | undefined;
    set internalValue(value: DataGoogleComputeRouterBgp | undefined);
    get advertiseMode(): string;
    get advertisedGroups(): string[];
    private _advertisedIpRanges;
    get advertisedIpRanges(): DataGoogleComputeRouterBgpAdvertisedIpRangesList;
    get asn(): number;
}
export declare class DataGoogleComputeRouterBgpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterBgpOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router}
*/
export declare class DataGoogleComputeRouter extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_router";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRouterConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRouterConfig);
    private _bgp;
    get bgp(): DataGoogleComputeRouterBgpList;
    get creationTimestamp(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
