import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#location DataGoogleContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#name DataGoogleContainerCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#project DataGoogleContainerCluster#project}
    */
    readonly project?: string;
}
export interface DataGoogleContainerClusterAddonsConfigCloudrunConfig {
}
export declare function dataGoogleContainerClusterAddonsConfigCloudrunConfigToTerraform(struct?: DataGoogleContainerClusterAddonsConfigCloudrunConfig): any;
export declare class DataGoogleContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAddonsConfigCloudrunConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterAddonsConfigCloudrunConfig | undefined);
    get disabled(): cdktf.IResolvable;
    get loadBalancerType(): string;
}
export declare class DataGoogleContainerClusterAddonsConfigCloudrunConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAddonsConfigCloudrunConfigOutputReference;
}
export interface DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling {
}
export declare function dataGoogleContainerClusterAddonsConfigHorizontalPodAutoscalingToTerraform(struct?: DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
export declare class DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    set internalValue(value: DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined);
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
}
export interface DataGoogleContainerClusterAddonsConfigHttpLoadBalancing {
}
export declare function dataGoogleContainerClusterAddonsConfigHttpLoadBalancingToTerraform(struct?: DataGoogleContainerClusterAddonsConfigHttpLoadBalancing): any;
export declare class DataGoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    set internalValue(value: DataGoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined);
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfigHttpLoadBalancingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
}
export interface DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig {
}
export declare function dataGoogleContainerClusterAddonsConfigNetworkPolicyConfigToTerraform(struct?: DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig): any;
export declare class DataGoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined);
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfigNetworkPolicyConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
}
export interface DataGoogleContainerClusterAddonsConfig {
}
export declare function dataGoogleContainerClusterAddonsConfigToTerraform(struct?: DataGoogleContainerClusterAddonsConfig): any;
export declare class DataGoogleContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAddonsConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterAddonsConfig | undefined);
    private _cloudrunConfig;
    get cloudrunConfig(): DataGoogleContainerClusterAddonsConfigCloudrunConfigList;
    private _horizontalPodAutoscaling;
    get horizontalPodAutoscaling(): DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscalingList;
    private _httpLoadBalancing;
    get httpLoadBalancing(): DataGoogleContainerClusterAddonsConfigHttpLoadBalancingList;
    private _networkPolicyConfig;
    get networkPolicyConfig(): DataGoogleContainerClusterAddonsConfigNetworkPolicyConfigList;
}
export declare class DataGoogleContainerClusterAddonsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAddonsConfigOutputReference;
}
export interface DataGoogleContainerClusterAuthenticatorGroupsConfig {
}
export declare function dataGoogleContainerClusterAuthenticatorGroupsConfigToTerraform(struct?: DataGoogleContainerClusterAuthenticatorGroupsConfig): any;
export declare class DataGoogleContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterAuthenticatorGroupsConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterAuthenticatorGroupsConfig | undefined);
    get securityGroup(): string;
}
export declare class DataGoogleContainerClusterAuthenticatorGroupsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterAuthenticatorGroupsConfigOutputReference;
}
export interface DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults {
}
export declare function dataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsToTerraform(struct?: DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
export declare class DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    set internalValue(value: DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined);
    get oauthScopes(): string[];
    get serviceAccount(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
}
export interface DataGoogleContainerClusterClusterAutoscalingResourceLimits {
}
export declare function dataGoogleContainerClusterClusterAutoscalingResourceLimitsToTerraform(struct?: DataGoogleContainerClusterClusterAutoscalingResourceLimits): any;
export declare class DataGoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterClusterAutoscalingResourceLimits | undefined;
    set internalValue(value: DataGoogleContainerClusterClusterAutoscalingResourceLimits | undefined);
    get maximum(): number;
    get minimum(): number;
    get resourceType(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference;
}
export interface DataGoogleContainerClusterClusterAutoscaling {
}
export declare function dataGoogleContainerClusterClusterAutoscalingToTerraform(struct?: DataGoogleContainerClusterClusterAutoscaling): any;
export declare class DataGoogleContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterClusterAutoscaling | undefined;
    set internalValue(value: DataGoogleContainerClusterClusterAutoscaling | undefined);
    private _autoProvisioningDefaults;
    get autoProvisioningDefaults(): DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsList;
    get enabled(): cdktf.IResolvable;
    private _resourceLimits;
    get resourceLimits(): DataGoogleContainerClusterClusterAutoscalingResourceLimitsList;
}
export declare class DataGoogleContainerClusterClusterAutoscalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterClusterAutoscalingOutputReference;
}
export interface DataGoogleContainerClusterDatabaseEncryption {
}
export declare function dataGoogleContainerClusterDatabaseEncryptionToTerraform(struct?: DataGoogleContainerClusterDatabaseEncryption): any;
export declare class DataGoogleContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterDatabaseEncryption | undefined;
    set internalValue(value: DataGoogleContainerClusterDatabaseEncryption | undefined);
    get keyName(): string;
    get state(): string;
}
export declare class DataGoogleContainerClusterDatabaseEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterDatabaseEncryptionOutputReference;
}
export interface DataGoogleContainerClusterDefaultSnatStatus {
}
export declare function dataGoogleContainerClusterDefaultSnatStatusToTerraform(struct?: DataGoogleContainerClusterDefaultSnatStatus): any;
export declare class DataGoogleContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterDefaultSnatStatus | undefined;
    set internalValue(value: DataGoogleContainerClusterDefaultSnatStatus | undefined);
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterDefaultSnatStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterDefaultSnatStatusOutputReference;
}
export interface DataGoogleContainerClusterIpAllocationPolicy {
}
export declare function dataGoogleContainerClusterIpAllocationPolicyToTerraform(struct?: DataGoogleContainerClusterIpAllocationPolicy): any;
export declare class DataGoogleContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterIpAllocationPolicy | undefined;
    set internalValue(value: DataGoogleContainerClusterIpAllocationPolicy | undefined);
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
}
export declare class DataGoogleContainerClusterIpAllocationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterIpAllocationPolicyOutputReference;
}
export interface DataGoogleContainerClusterLoggingConfig {
}
export declare function dataGoogleContainerClusterLoggingConfigToTerraform(struct?: DataGoogleContainerClusterLoggingConfig): any;
export declare class DataGoogleContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterLoggingConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterLoggingConfig | undefined);
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterLoggingConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterLoggingConfigOutputReference;
}
export interface DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow {
}
export declare function dataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowToTerraform(struct?: DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
export declare class DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined);
    get duration(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
}
export interface DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion {
}
export declare function dataGoogleContainerClusterMaintenancePolicyMaintenanceExclusionToTerraform(struct?: DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion): any;
export declare class DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion | undefined;
    set internalValue(value: DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion | undefined);
    get endTime(): string;
    get exclusionName(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference;
}
export interface DataGoogleContainerClusterMaintenancePolicyRecurringWindow {
}
export declare function dataGoogleContainerClusterMaintenancePolicyRecurringWindowToTerraform(struct?: DataGoogleContainerClusterMaintenancePolicyRecurringWindow): any;
export declare class DataGoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMaintenancePolicyRecurringWindow | undefined;
    set internalValue(value: DataGoogleContainerClusterMaintenancePolicyRecurringWindow | undefined);
    get endTime(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyRecurringWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference;
}
export interface DataGoogleContainerClusterMaintenancePolicy {
}
export declare function dataGoogleContainerClusterMaintenancePolicyToTerraform(struct?: DataGoogleContainerClusterMaintenancePolicy): any;
export declare class DataGoogleContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMaintenancePolicy | undefined;
    set internalValue(value: DataGoogleContainerClusterMaintenancePolicy | undefined);
    private _dailyMaintenanceWindow;
    get dailyMaintenanceWindow(): DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowList;
    private _maintenanceExclusion;
    get maintenanceExclusion(): DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusionList;
    private _recurringWindow;
    get recurringWindow(): DataGoogleContainerClusterMaintenancePolicyRecurringWindowList;
}
export declare class DataGoogleContainerClusterMaintenancePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMaintenancePolicyOutputReference;
}
export interface DataGoogleContainerClusterMasterAuthClientCertificateConfig {
}
export declare function dataGoogleContainerClusterMasterAuthClientCertificateConfigToTerraform(struct?: DataGoogleContainerClusterMasterAuthClientCertificateConfig): any;
export declare class DataGoogleContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMasterAuthClientCertificateConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterMasterAuthClientCertificateConfig | undefined);
    get issueClientCertificate(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterMasterAuthClientCertificateConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMasterAuthClientCertificateConfigOutputReference;
}
export interface DataGoogleContainerClusterMasterAuth {
}
export declare function dataGoogleContainerClusterMasterAuthToTerraform(struct?: DataGoogleContainerClusterMasterAuth): any;
export declare class DataGoogleContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMasterAuth | undefined;
    set internalValue(value: DataGoogleContainerClusterMasterAuth | undefined);
    get clientCertificate(): string;
    private _clientCertificateConfig;
    get clientCertificateConfig(): DataGoogleContainerClusterMasterAuthClientCertificateConfigList;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get password(): string;
    get username(): string;
}
export declare class DataGoogleContainerClusterMasterAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMasterAuthOutputReference;
}
export interface DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
}
export declare function dataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks): any;
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | undefined;
    set internalValue(value: DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | undefined);
    get cidrBlock(): string;
    get displayName(): string;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface DataGoogleContainerClusterMasterAuthorizedNetworksConfig {
}
export declare function dataGoogleContainerClusterMasterAuthorizedNetworksConfigToTerraform(struct?: DataGoogleContainerClusterMasterAuthorizedNetworksConfig): any;
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterMasterAuthorizedNetworksConfig | undefined);
    private _cidrBlocks;
    get cidrBlocks(): DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference;
}
export interface DataGoogleContainerClusterMonitoringConfig {
}
export declare function dataGoogleContainerClusterMonitoringConfigToTerraform(struct?: DataGoogleContainerClusterMonitoringConfig): any;
export declare class DataGoogleContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterMonitoringConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterMonitoringConfig | undefined);
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterMonitoringConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterMonitoringConfigOutputReference;
}
export interface DataGoogleContainerClusterNetworkPolicy {
}
export declare function dataGoogleContainerClusterNetworkPolicyToTerraform(struct?: DataGoogleContainerClusterNetworkPolicy): any;
export declare class DataGoogleContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNetworkPolicy | undefined;
    set internalValue(value: DataGoogleContainerClusterNetworkPolicy | undefined);
    get enabled(): cdktf.IResolvable;
    get provider(): string;
}
export declare class DataGoogleContainerClusterNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNetworkPolicyOutputReference;
}
export interface DataGoogleContainerClusterNodeConfigGuestAccelerator {
}
export declare function dataGoogleContainerClusterNodeConfigGuestAcceleratorToTerraform(struct?: DataGoogleContainerClusterNodeConfigGuestAccelerator): any;
export declare class DataGoogleContainerClusterNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodeConfigGuestAccelerator | undefined;
    set internalValue(value: DataGoogleContainerClusterNodeConfigGuestAccelerator | undefined);
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodeConfigGuestAcceleratorOutputReference;
}
export interface DataGoogleContainerClusterNodeConfigShieldedInstanceConfig {
}
export declare function dataGoogleContainerClusterNodeConfigShieldedInstanceConfigToTerraform(struct?: DataGoogleContainerClusterNodeConfigShieldedInstanceConfig): any;
export declare class DataGoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined);
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodeConfigShieldedInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
}
export interface DataGoogleContainerClusterNodeConfigTaint {
}
export declare function dataGoogleContainerClusterNodeConfigTaintToTerraform(struct?: DataGoogleContainerClusterNodeConfigTaint): any;
export declare class DataGoogleContainerClusterNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodeConfigTaint | undefined;
    set internalValue(value: DataGoogleContainerClusterNodeConfigTaint | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodeConfigTaintOutputReference;
}
export interface DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig {
}
export declare function dataGoogleContainerClusterNodeConfigWorkloadMetadataConfigToTerraform(struct?: DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig): any;
export declare class DataGoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined);
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodeConfigWorkloadMetadataConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
}
export interface DataGoogleContainerClusterNodeConfig {
}
export declare function dataGoogleContainerClusterNodeConfigToTerraform(struct?: DataGoogleContainerClusterNodeConfig): any;
export declare class DataGoogleContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodeConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodeConfig | undefined);
    get diskSizeGb(): number;
    get diskType(): string;
    private _guestAccelerator;
    get guestAccelerator(): DataGoogleContainerClusterNodeConfigGuestAcceleratorList;
    get imageType(): string;
    labels(key: string): string | cdktf.IResolvable;
    get localSsdCount(): number;
    get machineType(): string;
    metadata(key: string): string | cdktf.IResolvable;
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): cdktf.IResolvable;
    get serviceAccount(): string;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataGoogleContainerClusterNodeConfigShieldedInstanceConfigList;
    get tags(): string[];
    private _taint;
    get taint(): DataGoogleContainerClusterNodeConfigTaintList;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): DataGoogleContainerClusterNodeConfigWorkloadMetadataConfigList;
}
export declare class DataGoogleContainerClusterNodeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodeConfigOutputReference;
}
export interface DataGoogleContainerClusterNodePoolAutoscaling {
}
export declare function dataGoogleContainerClusterNodePoolAutoscalingToTerraform(struct?: DataGoogleContainerClusterNodePoolAutoscaling): any;
export declare class DataGoogleContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolAutoscaling | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolAutoscaling | undefined);
    get maxNodeCount(): number;
    get minNodeCount(): number;
}
export declare class DataGoogleContainerClusterNodePoolAutoscalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolAutoscalingOutputReference;
}
export interface DataGoogleContainerClusterNodePoolManagement {
}
export declare function dataGoogleContainerClusterNodePoolManagementToTerraform(struct?: DataGoogleContainerClusterNodePoolManagement): any;
export declare class DataGoogleContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolManagement | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolManagement | undefined);
    get autoRepair(): cdktf.IResolvable;
    get autoUpgrade(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolManagementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolManagementOutputReference;
}
export interface DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator {
}
export declare function dataGoogleContainerClusterNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator): any;
export declare class DataGoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator | undefined);
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
}
export declare function dataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined);
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
}
export interface DataGoogleContainerClusterNodePoolNodeConfigTaint {
}
export declare function dataGoogleContainerClusterNodePoolNodeConfigTaintToTerraform(struct?: DataGoogleContainerClusterNodePoolNodeConfigTaint): any;
export declare class DataGoogleContainerClusterNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolNodeConfigTaint | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolNodeConfigTaint | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolNodeConfigTaintOutputReference;
}
export interface DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
}
export declare function dataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
}
export interface DataGoogleContainerClusterNodePoolNodeConfig {
}
export declare function dataGoogleContainerClusterNodePoolNodeConfigToTerraform(struct?: DataGoogleContainerClusterNodePoolNodeConfig): any;
export declare class DataGoogleContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolNodeConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolNodeConfig | undefined);
    get diskSizeGb(): number;
    get diskType(): string;
    private _guestAccelerator;
    get guestAccelerator(): DataGoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList;
    get imageType(): string;
    labels(key: string): string | cdktf.IResolvable;
    get localSsdCount(): number;
    get machineType(): string;
    metadata(key: string): string | cdktf.IResolvable;
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): cdktf.IResolvable;
    get serviceAccount(): string;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigList;
    get tags(): string[];
    private _taint;
    get taint(): DataGoogleContainerClusterNodePoolNodeConfigTaintList;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigList;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolNodeConfigOutputReference;
}
export interface DataGoogleContainerClusterNodePoolUpgradeSettings {
}
export declare function dataGoogleContainerClusterNodePoolUpgradeSettingsToTerraform(struct?: DataGoogleContainerClusterNodePoolUpgradeSettings): any;
export declare class DataGoogleContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePoolUpgradeSettings | undefined);
    get maxSurge(): number;
    get maxUnavailable(): number;
}
export declare class DataGoogleContainerClusterNodePoolUpgradeSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolUpgradeSettingsOutputReference;
}
export interface DataGoogleContainerClusterNodePool {
}
export declare function dataGoogleContainerClusterNodePoolToTerraform(struct?: DataGoogleContainerClusterNodePool): any;
export declare class DataGoogleContainerClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterNodePool | undefined;
    set internalValue(value: DataGoogleContainerClusterNodePool | undefined);
    private _autoscaling;
    get autoscaling(): DataGoogleContainerClusterNodePoolAutoscalingList;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    private _management;
    get management(): DataGoogleContainerClusterNodePoolManagementList;
    get maxPodsPerNode(): number;
    get name(): string;
    get namePrefix(): string;
    private _nodeConfig;
    get nodeConfig(): DataGoogleContainerClusterNodePoolNodeConfigList;
    get nodeCount(): number;
    get nodeLocations(): string[];
    private _upgradeSettings;
    get upgradeSettings(): DataGoogleContainerClusterNodePoolUpgradeSettingsList;
    get version(): string;
}
export declare class DataGoogleContainerClusterNodePoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterNodePoolOutputReference;
}
export interface DataGoogleContainerClusterPodSecurityPolicyConfig {
}
export declare function dataGoogleContainerClusterPodSecurityPolicyConfigToTerraform(struct?: DataGoogleContainerClusterPodSecurityPolicyConfig): any;
export declare class DataGoogleContainerClusterPodSecurityPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterPodSecurityPolicyConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterPodSecurityPolicyConfig | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterPodSecurityPolicyConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterPodSecurityPolicyConfigOutputReference;
}
export interface DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
}
export declare function dataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigToTerraform(struct?: DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
export declare class DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
}
export interface DataGoogleContainerClusterPrivateClusterConfig {
}
export declare function dataGoogleContainerClusterPrivateClusterConfigToTerraform(struct?: DataGoogleContainerClusterPrivateClusterConfig): any;
export declare class DataGoogleContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterPrivateClusterConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterPrivateClusterConfig | undefined);
    get enablePrivateEndpoint(): cdktf.IResolvable;
    get enablePrivateNodes(): cdktf.IResolvable;
    private _masterGlobalAccessConfig;
    get masterGlobalAccessConfig(): DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigList;
    get masterIpv4CidrBlock(): string;
    get peeringName(): string;
    get privateEndpoint(): string;
    get publicEndpoint(): string;
}
export declare class DataGoogleContainerClusterPrivateClusterConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterPrivateClusterConfigOutputReference;
}
export interface DataGoogleContainerClusterReleaseChannel {
}
export declare function dataGoogleContainerClusterReleaseChannelToTerraform(struct?: DataGoogleContainerClusterReleaseChannel): any;
export declare class DataGoogleContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterReleaseChannel | undefined;
    set internalValue(value: DataGoogleContainerClusterReleaseChannel | undefined);
    get channel(): string;
}
export declare class DataGoogleContainerClusterReleaseChannelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterReleaseChannelOutputReference;
}
export interface DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination {
}
export declare function dataGoogleContainerClusterResourceUsageExportConfigBigqueryDestinationToTerraform(struct?: DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination): any;
export declare class DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
    set internalValue(value: DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined);
    get datasetId(): string;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
}
export interface DataGoogleContainerClusterResourceUsageExportConfig {
}
export declare function dataGoogleContainerClusterResourceUsageExportConfigToTerraform(struct?: DataGoogleContainerClusterResourceUsageExportConfig): any;
export declare class DataGoogleContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterResourceUsageExportConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterResourceUsageExportConfig | undefined);
    private _bigqueryDestination;
    get bigqueryDestination(): DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestinationList;
    get enableNetworkEgressMetering(): cdktf.IResolvable;
    get enableResourceConsumptionMetering(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterResourceUsageExportConfigOutputReference;
}
export interface DataGoogleContainerClusterVerticalPodAutoscaling {
}
export declare function dataGoogleContainerClusterVerticalPodAutoscalingToTerraform(struct?: DataGoogleContainerClusterVerticalPodAutoscaling): any;
export declare class DataGoogleContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterVerticalPodAutoscaling | undefined;
    set internalValue(value: DataGoogleContainerClusterVerticalPodAutoscaling | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterVerticalPodAutoscalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterVerticalPodAutoscalingOutputReference;
}
export interface DataGoogleContainerClusterWorkloadIdentityConfig {
}
export declare function dataGoogleContainerClusterWorkloadIdentityConfigToTerraform(struct?: DataGoogleContainerClusterWorkloadIdentityConfig): any;
export declare class DataGoogleContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleContainerClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: DataGoogleContainerClusterWorkloadIdentityConfig | undefined);
    get identityNamespace(): string;
    get workloadPool(): string;
}
export declare class DataGoogleContainerClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleContainerClusterWorkloadIdentityConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/container_cluster google_container_cluster}
*/
export declare class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_cluster google_container_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleContainerClusterConfig);
    private _addonsConfig;
    get addonsConfig(): DataGoogleContainerClusterAddonsConfigList;
    private _authenticatorGroupsConfig;
    get authenticatorGroupsConfig(): DataGoogleContainerClusterAuthenticatorGroupsConfigList;
    private _clusterAutoscaling;
    get clusterAutoscaling(): DataGoogleContainerClusterClusterAutoscalingList;
    get clusterIpv4Cidr(): string;
    private _databaseEncryption;
    get databaseEncryption(): DataGoogleContainerClusterDatabaseEncryptionList;
    get datapathProvider(): string;
    get defaultMaxPodsPerNode(): number;
    private _defaultSnatStatus;
    get defaultSnatStatus(): DataGoogleContainerClusterDefaultSnatStatusList;
    get description(): string;
    get enableAutopilot(): cdktf.IResolvable;
    get enableBinaryAuthorization(): cdktf.IResolvable;
    get enableIntranodeVisibility(): cdktf.IResolvable;
    get enableKubernetesAlpha(): cdktf.IResolvable;
    get enableLegacyAbac(): cdktf.IResolvable;
    get enableShieldedNodes(): cdktf.IResolvable;
    get enableTpu(): cdktf.IResolvable;
    get endpoint(): string;
    get id(): string;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): DataGoogleContainerClusterIpAllocationPolicyList;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingConfig;
    get loggingConfig(): DataGoogleContainerClusterLoggingConfigList;
    get loggingService(): string;
    private _maintenancePolicy;
    get maintenancePolicy(): DataGoogleContainerClusterMaintenancePolicyList;
    private _masterAuth;
    get masterAuth(): DataGoogleContainerClusterMasterAuthList;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): DataGoogleContainerClusterMasterAuthorizedNetworksConfigList;
    get masterVersion(): string;
    get minMasterVersion(): string;
    private _monitoringConfig;
    get monitoringConfig(): DataGoogleContainerClusterMonitoringConfigList;
    get monitoringService(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _networkPolicy;
    get networkPolicy(): DataGoogleContainerClusterNetworkPolicyList;
    get networkingMode(): string;
    private _nodeConfig;
    get nodeConfig(): DataGoogleContainerClusterNodeConfigList;
    get nodeLocations(): string[];
    private _nodePool;
    get nodePool(): DataGoogleContainerClusterNodePoolList;
    get nodeVersion(): string;
    get operation(): string;
    private _podSecurityPolicyConfig;
    get podSecurityPolicyConfig(): DataGoogleContainerClusterPodSecurityPolicyConfigList;
    private _privateClusterConfig;
    get privateClusterConfig(): DataGoogleContainerClusterPrivateClusterConfigList;
    get privateIpv6GoogleAccess(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannel;
    get releaseChannel(): DataGoogleContainerClusterReleaseChannelList;
    get removeDefaultNodePool(): cdktf.IResolvable;
    resourceLabels(key: string): string | cdktf.IResolvable;
    private _resourceUsageExportConfig;
    get resourceUsageExportConfig(): DataGoogleContainerClusterResourceUsageExportConfigList;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    get subnetwork(): string;
    get tpuIpv4CidrBlock(): string;
    private _verticalPodAutoscaling;
    get verticalPodAutoscaling(): DataGoogleContainerClusterVerticalPodAutoscalingList;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): DataGoogleContainerClusterWorkloadIdentityConfigList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
