import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsKeyRingConfig extends cdktf.TerraformMetaArguments {
    /**
    * The location for the KeyRing.
  A full list of valid locations can be found by running 'gcloud kms locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_key_ring#location DataGoogleKmsKeyRing#location}
    */
    readonly location: string;
    /**
    * The resource name for the KeyRing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_key_ring#name DataGoogleKmsKeyRing#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_key_ring#project DataGoogleKmsKeyRing#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_key_ring google_kms_key_ring}
*/
export declare class DataGoogleKmsKeyRing extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_key_ring";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_key_ring google_kms_key_ring} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsKeyRingConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsKeyRingConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
