import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleRedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#name DataGoogleRedisInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#project DataGoogleRedisInstance#project}
    */
    readonly project?: string;
    /**
    * The name of the Redis region of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#region DataGoogleRedisInstance#region}
    */
    readonly region?: string;
}
export interface DataGoogleRedisInstanceServerCaCerts {
}
export declare function dataGoogleRedisInstanceServerCaCertsToTerraform(struct?: DataGoogleRedisInstanceServerCaCerts): any;
export declare class DataGoogleRedisInstanceServerCaCertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceServerCaCerts | undefined;
    set internalValue(value: DataGoogleRedisInstanceServerCaCerts | undefined);
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleRedisInstanceServerCaCertsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceServerCaCertsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance}
*/
export declare class DataGoogleRedisInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_redis_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleRedisInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleRedisInstanceConfig);
    get alternativeLocationId(): string;
    get authEnabled(): cdktf.IResolvable;
    get authString(): string;
    get authorizedNetwork(): string;
    get connectMode(): string;
    get createTime(): string;
    get currentLocationId(): string;
    get displayName(): string;
    get host(): string;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    get locationId(): string;
    get memorySizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    redisConfigs(key: string): string | cdktf.IResolvable;
    get redisVersion(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get reservedIpRange(): string;
    private _serverCaCerts;
    get serverCaCerts(): DataGoogleRedisInstanceServerCaCertsList;
    get tier(): string;
    get transitEncryptionMode(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
