import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket#name DataGoogleStorageBucket#name}
    */
    readonly name: string;
}
export interface DataGoogleStorageBucketCors {
}
export declare function dataGoogleStorageBucketCorsToTerraform(struct?: DataGoogleStorageBucketCors): any;
export declare class DataGoogleStorageBucketCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketCors | undefined;
    set internalValue(value: DataGoogleStorageBucketCors | undefined);
    get maxAgeSeconds(): number;
    get method(): string[];
    get origin(): string[];
    get responseHeader(): string[];
}
export declare class DataGoogleStorageBucketCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketCorsOutputReference;
}
export interface DataGoogleStorageBucketEncryption {
}
export declare function dataGoogleStorageBucketEncryptionToTerraform(struct?: DataGoogleStorageBucketEncryption): any;
export declare class DataGoogleStorageBucketEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketEncryption | undefined;
    set internalValue(value: DataGoogleStorageBucketEncryption | undefined);
    get defaultKmsKeyName(): string;
}
export declare class DataGoogleStorageBucketEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketEncryptionOutputReference;
}
export interface DataGoogleStorageBucketLifecycleRuleAction {
}
export declare function dataGoogleStorageBucketLifecycleRuleActionToTerraform(struct?: DataGoogleStorageBucketLifecycleRuleAction): any;
export declare class DataGoogleStorageBucketLifecycleRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketLifecycleRuleAction | undefined;
    set internalValue(value: DataGoogleStorageBucketLifecycleRuleAction | undefined);
    get storageClass(): string;
    get type(): string;
}
export declare class DataGoogleStorageBucketLifecycleRuleActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketLifecycleRuleActionOutputReference;
}
export interface DataGoogleStorageBucketLifecycleRuleCondition {
}
export declare function dataGoogleStorageBucketLifecycleRuleConditionToTerraform(struct?: DataGoogleStorageBucketLifecycleRuleCondition): any;
export declare class DataGoogleStorageBucketLifecycleRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketLifecycleRuleCondition | undefined;
    set internalValue(value: DataGoogleStorageBucketLifecycleRuleCondition | undefined);
    get age(): number;
    get createdBefore(): string;
    get customTimeBefore(): string;
    get daysSinceCustomTime(): number;
    get daysSinceNoncurrentTime(): number;
    get matchesStorageClass(): string[];
    get noncurrentTimeBefore(): string;
    get numNewerVersions(): number;
    get withState(): string;
}
export declare class DataGoogleStorageBucketLifecycleRuleConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketLifecycleRuleConditionOutputReference;
}
export interface DataGoogleStorageBucketLifecycleRule {
}
export declare function dataGoogleStorageBucketLifecycleRuleToTerraform(struct?: DataGoogleStorageBucketLifecycleRule): any;
export declare class DataGoogleStorageBucketLifecycleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketLifecycleRule | undefined;
    set internalValue(value: DataGoogleStorageBucketLifecycleRule | undefined);
    private _action;
    get action(): DataGoogleStorageBucketLifecycleRuleActionList;
    private _condition;
    get condition(): DataGoogleStorageBucketLifecycleRuleConditionList;
}
export declare class DataGoogleStorageBucketLifecycleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketLifecycleRuleOutputReference;
}
export interface DataGoogleStorageBucketLogging {
}
export declare function dataGoogleStorageBucketLoggingToTerraform(struct?: DataGoogleStorageBucketLogging): any;
export declare class DataGoogleStorageBucketLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketLogging | undefined;
    set internalValue(value: DataGoogleStorageBucketLogging | undefined);
    get logBucket(): string;
    get logObjectPrefix(): string;
}
export declare class DataGoogleStorageBucketLoggingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketLoggingOutputReference;
}
export interface DataGoogleStorageBucketRetentionPolicy {
}
export declare function dataGoogleStorageBucketRetentionPolicyToTerraform(struct?: DataGoogleStorageBucketRetentionPolicy): any;
export declare class DataGoogleStorageBucketRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketRetentionPolicy | undefined;
    set internalValue(value: DataGoogleStorageBucketRetentionPolicy | undefined);
    get isLocked(): cdktf.IResolvable;
    get retentionPeriod(): number;
}
export declare class DataGoogleStorageBucketRetentionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketRetentionPolicyOutputReference;
}
export interface DataGoogleStorageBucketVersioning {
}
export declare function dataGoogleStorageBucketVersioningToTerraform(struct?: DataGoogleStorageBucketVersioning): any;
export declare class DataGoogleStorageBucketVersioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketVersioning | undefined;
    set internalValue(value: DataGoogleStorageBucketVersioning | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleStorageBucketVersioningList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketVersioningOutputReference;
}
export interface DataGoogleStorageBucketWebsite {
}
export declare function dataGoogleStorageBucketWebsiteToTerraform(struct?: DataGoogleStorageBucketWebsite): any;
export declare class DataGoogleStorageBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketWebsite | undefined;
    set internalValue(value: DataGoogleStorageBucketWebsite | undefined);
    get mainPageSuffix(): string;
    get notFoundPage(): string;
}
export declare class DataGoogleStorageBucketWebsiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketWebsiteOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket google_storage_bucket}
*/
export declare class DataGoogleStorageBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_bucket";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket google_storage_bucket} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageBucketConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleStorageBucketConfig);
    get bucketPolicyOnly(): cdktf.IResolvable;
    private _cors;
    get cors(): DataGoogleStorageBucketCorsList;
    get defaultEventBasedHold(): cdktf.IResolvable;
    private _encryption;
    get encryption(): DataGoogleStorageBucketEncryptionList;
    get forceDestroy(): cdktf.IResolvable;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    private _lifecycleRule;
    get lifecycleRule(): DataGoogleStorageBucketLifecycleRuleList;
    get location(): string;
    private _logging;
    get logging(): DataGoogleStorageBucketLoggingList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get project(): string;
    get requesterPays(): cdktf.IResolvable;
    private _retentionPolicy;
    get retentionPolicy(): DataGoogleStorageBucketRetentionPolicyList;
    get selfLink(): string;
    get storageClass(): string;
    get uniformBucketLevelAccess(): cdktf.IResolvable;
    get url(): string;
    private _versioning;
    get versioning(): DataGoogleStorageBucketVersioningList;
    private _website;
    get website(): DataGoogleStorageBucketWebsiteList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
