import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FilestoreInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#description FilestoreInstance#description}
    */
    readonly description?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#labels FilestoreInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#name FilestoreInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#project FilestoreInstance#project}
    */
    readonly project?: string;
    /**
    * The service tier of the instance. Possible values: ["TIER_UNSPECIFIED", "STANDARD", "PREMIUM", "BASIC_HDD", "BASIC_SSD", "HIGH_SCALE_SSD"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#tier FilestoreInstance#tier}
    */
    readonly tier: string;
    /**
    * The name of the Filestore zone of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#zone FilestoreInstance#zone}
    */
    readonly zone: string;
    /**
    * file_shares block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#file_shares FilestoreInstance#file_shares}
    */
    readonly fileShares: FilestoreInstanceFileShares;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#networks FilestoreInstance#networks}
    */
    readonly networks: FilestoreInstanceNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#timeouts FilestoreInstance#timeouts}
    */
    readonly timeouts?: FilestoreInstanceTimeouts;
}
export interface FilestoreInstanceFileShares {
    /**
    * File share capacity in GiB. This must be at least 1024 GiB
  for the standard tier, or 2560 GiB for the premium tier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#capacity_gb FilestoreInstance#capacity_gb}
    */
    readonly capacityGb: number;
    /**
    * The name of the fileshare (16 characters or less)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#name FilestoreInstance#name}
    */
    readonly name: string;
}
export declare function filestoreInstanceFileSharesToTerraform(struct?: FilestoreInstanceFileSharesOutputReference | FilestoreInstanceFileShares): any;
export declare class FilestoreInstanceFileSharesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FilestoreInstanceFileShares | undefined;
    set internalValue(value: FilestoreInstanceFileShares | undefined);
    private _capacityGb?;
    get capacityGb(): number;
    set capacityGb(value: number);
    get capacityGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface FilestoreInstanceNetworks {
    /**
    * IP versions for which the instance has
  IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#modes FilestoreInstance#modes}
    */
    readonly modes: string[];
    /**
    * The name of the GCE VPC network to which the
  instance is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#network FilestoreInstance#network}
    */
    readonly network: string;
    /**
    * A /29 CIDR block that identifies the range of IP
  addresses reserved for this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#reserved_ip_range FilestoreInstance#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
}
export declare function filestoreInstanceNetworksToTerraform(struct?: FilestoreInstanceNetworks | cdktf.IResolvable): any;
export interface FilestoreInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#create FilestoreInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#delete FilestoreInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#update FilestoreInstance#update}
    */
    readonly update?: string;
}
export declare function filestoreInstanceTimeoutsToTerraform(struct?: FilestoreInstanceTimeoutsOutputReference | FilestoreInstanceTimeouts | cdktf.IResolvable): any;
export declare class FilestoreInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FilestoreInstanceTimeouts | undefined;
    set internalValue(value: FilestoreInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/filestore_instance google_filestore_instance}
*/
export declare class FilestoreInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_filestore_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/filestore_instance google_filestore_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FilestoreInstanceConfig
    */
    constructor(scope: Construct, id: string, config: FilestoreInstanceConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _fileShares;
    get fileShares(): FilestoreInstanceFileSharesOutputReference;
    putFileShares(value: FilestoreInstanceFileShares): void;
    get fileSharesInput(): FilestoreInstanceFileShares | undefined;
    private _networks?;
    get networks(): FilestoreInstanceNetworks[] | cdktf.IResolvable;
    set networks(value: FilestoreInstanceNetworks[] | cdktf.IResolvable);
    get networksInput(): cdktf.IResolvable | FilestoreInstanceNetworks[] | undefined;
    private _timeouts;
    get timeouts(): FilestoreInstanceTimeoutsOutputReference;
    putTimeouts(value: FilestoreInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FilestoreInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
