import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#folder FolderIamAuditConfig#folder}
    */
    readonly folder: string;
    /**
    * Service which will be enabled for audit logging. The special value allServices covers all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#service FolderIamAuditConfig#service}
    */
    readonly service: string;
    /**
    * audit_log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#audit_log_config FolderIamAuditConfig#audit_log_config}
    */
    readonly auditLogConfig: FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
}
export interface FolderIamAuditConfigAuditLogConfig {
    /**
    * Identities that do not cause logging for this type of permission. Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#exempted_members FolderIamAuditConfig#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#log_type FolderIamAuditConfig#log_type}
    */
    readonly logType: string;
}
export declare function folderIamAuditConfigAuditLogConfigToTerraform(struct?: FolderIamAuditConfigAuditLogConfig | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config google_folder_iam_audit_config}
*/
export declare class FolderIamAuditConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_iam_audit_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config google_folder_iam_audit_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FolderIamAuditConfigConfig
    */
    constructor(scope: Construct, id: string, config: FolderIamAuditConfigConfig);
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _auditLogConfig?;
    get auditLogConfig(): FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
    set auditLogConfig(value: FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable);
    get auditLogConfigInput(): cdktf.IResolvable | FolderIamAuditConfigAuditLogConfig[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
