import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapWebIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#members IapWebIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#project IapWebIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#role IapWebIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#condition IapWebIamBinding#condition}
    */
    readonly condition?: IapWebIamBindingCondition;
}
export interface IapWebIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#description IapWebIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#expression IapWebIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding#title IapWebIamBinding#title}
    */
    readonly title: string;
}
export declare function iapWebIamBindingConditionToTerraform(struct?: IapWebIamBindingConditionOutputReference | IapWebIamBindingCondition): any;
export declare class IapWebIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IapWebIamBindingCondition | undefined;
    set internalValue(value: IapWebIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding google_iap_web_iam_binding}
*/
export declare class IapWebIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_web_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_web_iam_binding google_iap_web_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapWebIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: IapWebIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): IapWebIamBindingConditionOutputReference;
    putCondition(value: IapWebIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): IapWebIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
