import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubLiteTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#name PubsubLiteTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#project PubsubLiteTopic#project}
    */
    readonly project?: string;
    /**
    * The region of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#region PubsubLiteTopic#region}
    */
    readonly region?: string;
    /**
    * The zone of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#zone PubsubLiteTopic#zone}
    */
    readonly zone?: string;
    /**
    * partition_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#partition_config PubsubLiteTopic#partition_config}
    */
    readonly partitionConfig?: PubsubLiteTopicPartitionConfig;
    /**
    * reservation_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#reservation_config PubsubLiteTopic#reservation_config}
    */
    readonly reservationConfig?: PubsubLiteTopicReservationConfig;
    /**
    * retention_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#retention_config PubsubLiteTopic#retention_config}
    */
    readonly retentionConfig?: PubsubLiteTopicRetentionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#timeouts PubsubLiteTopic#timeouts}
    */
    readonly timeouts?: PubsubLiteTopicTimeouts;
}
export interface PubsubLiteTopicPartitionConfigCapacity {
    /**
    * Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#publish_mib_per_sec PubsubLiteTopic#publish_mib_per_sec}
    */
    readonly publishMibPerSec: number;
    /**
    * Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#subscribe_mib_per_sec PubsubLiteTopic#subscribe_mib_per_sec}
    */
    readonly subscribeMibPerSec: number;
}
export declare function pubsubLiteTopicPartitionConfigCapacityToTerraform(struct?: PubsubLiteTopicPartitionConfigCapacityOutputReference | PubsubLiteTopicPartitionConfigCapacity): any;
export declare class PubsubLiteTopicPartitionConfigCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubLiteTopicPartitionConfigCapacity | undefined;
    set internalValue(value: PubsubLiteTopicPartitionConfigCapacity | undefined);
    private _publishMibPerSec?;
    get publishMibPerSec(): number;
    set publishMibPerSec(value: number);
    get publishMibPerSecInput(): number | undefined;
    private _subscribeMibPerSec?;
    get subscribeMibPerSec(): number;
    set subscribeMibPerSec(value: number);
    get subscribeMibPerSecInput(): number | undefined;
}
export interface PubsubLiteTopicPartitionConfig {
    /**
    * The number of partitions in the topic. Must be at least 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#count PubsubLiteTopic#count}
    */
    readonly count: number;
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#capacity PubsubLiteTopic#capacity}
    */
    readonly capacity?: PubsubLiteTopicPartitionConfigCapacity;
}
export declare function pubsubLiteTopicPartitionConfigToTerraform(struct?: PubsubLiteTopicPartitionConfigOutputReference | PubsubLiteTopicPartitionConfig): any;
export declare class PubsubLiteTopicPartitionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubLiteTopicPartitionConfig | undefined;
    set internalValue(value: PubsubLiteTopicPartitionConfig | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _capacity;
    get capacity(): PubsubLiteTopicPartitionConfigCapacityOutputReference;
    putCapacity(value: PubsubLiteTopicPartitionConfigCapacity): void;
    resetCapacity(): void;
    get capacityInput(): PubsubLiteTopicPartitionConfigCapacity | undefined;
}
export interface PubsubLiteTopicReservationConfig {
    /**
    * The Reservation to use for this topic's throughput capacity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#throughput_reservation PubsubLiteTopic#throughput_reservation}
    */
    readonly throughputReservation?: string;
}
export declare function pubsubLiteTopicReservationConfigToTerraform(struct?: PubsubLiteTopicReservationConfigOutputReference | PubsubLiteTopicReservationConfig): any;
export declare class PubsubLiteTopicReservationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubLiteTopicReservationConfig | undefined;
    set internalValue(value: PubsubLiteTopicReservationConfig | undefined);
    private _throughputReservation?;
    get throughputReservation(): string;
    set throughputReservation(value: string);
    resetThroughputReservation(): void;
    get throughputReservationInput(): string | undefined;
}
export interface PubsubLiteTopicRetentionConfig {
    /**
    * The provisioned storage, in bytes, per partition. If the number of bytes stored
  in any of the topic's partitions grows beyond this value, older messages will be
  dropped to make room for newer ones, regardless of the value of period.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#per_partition_bytes PubsubLiteTopic#per_partition_bytes}
    */
    readonly perPartitionBytes: string;
    /**
    * How long a published message is retained. If unset, messages will be retained as
  long as the bytes retained for each partition is below perPartitionBytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#period PubsubLiteTopic#period}
    */
    readonly period?: string;
}
export declare function pubsubLiteTopicRetentionConfigToTerraform(struct?: PubsubLiteTopicRetentionConfigOutputReference | PubsubLiteTopicRetentionConfig): any;
export declare class PubsubLiteTopicRetentionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubLiteTopicRetentionConfig | undefined;
    set internalValue(value: PubsubLiteTopicRetentionConfig | undefined);
    private _perPartitionBytes?;
    get perPartitionBytes(): string;
    set perPartitionBytes(value: string);
    get perPartitionBytesInput(): string | undefined;
    private _period?;
    get period(): string;
    set period(value: string);
    resetPeriod(): void;
    get periodInput(): string | undefined;
}
export interface PubsubLiteTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#create PubsubLiteTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#delete PubsubLiteTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic#update PubsubLiteTopic#update}
    */
    readonly update?: string;
}
export declare function pubsubLiteTopicTimeoutsToTerraform(struct?: PubsubLiteTopicTimeoutsOutputReference | PubsubLiteTopicTimeouts | cdktf.IResolvable): any;
export declare class PubsubLiteTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubLiteTopicTimeouts | undefined;
    set internalValue(value: PubsubLiteTopicTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic google_pubsub_lite_topic}
*/
export declare class PubsubLiteTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_lite_topic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic google_pubsub_lite_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubLiteTopicConfig
    */
    constructor(scope: Construct, id: string, config: PubsubLiteTopicConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _partitionConfig;
    get partitionConfig(): PubsubLiteTopicPartitionConfigOutputReference;
    putPartitionConfig(value: PubsubLiteTopicPartitionConfig): void;
    resetPartitionConfig(): void;
    get partitionConfigInput(): PubsubLiteTopicPartitionConfig | undefined;
    private _reservationConfig;
    get reservationConfig(): PubsubLiteTopicReservationConfigOutputReference;
    putReservationConfig(value: PubsubLiteTopicReservationConfig): void;
    resetReservationConfig(): void;
    get reservationConfigInput(): PubsubLiteTopicReservationConfig | undefined;
    private _retentionConfig;
    get retentionConfig(): PubsubLiteTopicRetentionConfigOutputReference;
    putRetentionConfig(value: PubsubLiteTopicRetentionConfig): void;
    resetRetentionConfig(): void;
    get retentionConfigInput(): PubsubLiteTopicRetentionConfig | undefined;
    private _timeouts;
    get timeouts(): PubsubLiteTopicTimeoutsOutputReference;
    putTimeouts(value: PubsubLiteTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubLiteTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
