from __future__ import annotations

from typing import TYPE_CHECKING

from . import app_info, base, client_server, client_server_2, friends, leaderboards, login, ucm, user_stats
from .emsg import *

if TYPE_CHECKING:
    from collections.abc import Mapping

    import betterproto

    from ..enums import IntEnum

__all__ = ("PROTOBUFS",)


PROTOBUFS: Mapping[IntEnum, type[betterproto.Message]] = {
    EMsg.Multi: base.CMsgMulti,
    EMsg.ClientToGC: client_server_2.CMsgGcClient,
    EMsg.ClientFromGC: client_server_2.CMsgGcClient,
    EMsg.ClientGetNumberOfCurrentPlayersDP: client_server_2.CMsgDpGetNumberOfCurrentPlayers,
    EMsg.ClientGetNumberOfCurrentPlayersDPResponse: client_server_2.CMsgDpGetNumberOfCurrentPlayersResponse,
    EMsg.ClientLogonGameServer: login.CMsgClientLogon,
    EMsg.ClientCurrentUIMode: client_server_2.CMsgClientUiMode,
    EMsg.ClientChatOfflineMessageNotification: client_server_2.CMsgClientOfflineMessageNotification,
    EMsg.ClientTicketAuthComplete: client_server.CMsgClientTicketAuthComplete,
    EMsg.ClientCMList: client_server.CMsgClientCmList,
    EMsg.ClientP2PConnectionInfo: client_server.CMsgClientP2PConnectionInfo,
    EMsg.ClientP2PConnectionFailInfo: client_server.CMsgClientP2PConnectionFailInfo,
    EMsg.ClientNetworkingCertRequest: client_server.CMsgClientNetworkingCertRequest,
    EMsg.ClientNetworkingMobileCertRequest: client_server.CMsgClientNetworkingMobileCertRequest,
    EMsg.ClientGetAppOwnershipTicket: client_server.CMsgClientGetAppOwnershipTicket,
    EMsg.ClientGetAppOwnershipTicketResponse: client_server.CMsgClientGetAppOwnershipTicketResponse,
    EMsg.ClientSessionToken: client_server.CMsgClientSessionToken,
    EMsg.ClientGameConnectTokens: client_server.CMsgClientGameConnectTokens,
    EMsg.ClientGamesPlayed: client_server.CMsgClientGamesPlayed,
    EMsg.GSApprove: client_server.CMsgGsApprove,
    EMsg.GSDeny: client_server.CMsgGsDeny,
    EMsg.GSKick: client_server.CMsgGsKick,
    EMsg.ClientAuthList: client_server.CMsgClientAuthList,
    EMsg.ClientAuthListAck: client_server.CMsgClientAuthListAck,
    EMsg.ClientLicenseList: client_server.CMsgClientLicenseList,
    EMsg.ClientGamesPlayedWithDataBlob: client_server.CMsgClientGamesPlayed,
    EMsg.ClientIsLimitedAccount: client_server.CMsgClientIsLimitedAccount,
    EMsg.ClientRequestedClientStats: client_server.CMsgClientRequestedClientStats,
    EMsg.ClientStat2: client_server.CMsgClientStat2,
    EMsg.ClientInviteToGame: client_server.CMsgClientInviteToGame,
    EMsg.ClientChatInvite: client_server.CMsgClientChatInvite,
    EMsg.ClientConnectionStats: client_server.CMsgClientConnectionStats,
    EMsg.ClientServersAvailable: client_server.CMsgClientServersAvailable,
    EMsg.ClientGetUserStats: user_stats.CMsgClientGetUserStats,
    EMsg.ClientGetUserStatsResponse: user_stats.CMsgClientGetUserStatsResponse,
    EMsg.ClientStoreUserStatsResponse: user_stats.CMsgClientStoreUserStatsResponse,
    EMsg.ClientStoreUserStats2: user_stats.CMsgClientStoreUserStats2,
    EMsg.ClientStatsUpdated: user_stats.CMsgClientStatsUpdated,
    EMsg.ClientStoreUserStats: user_stats.CMsgClientStoreUserStats,
    EMsg.ClientReportOverlayDetourFailure: client_server.CMsgClientReportOverlayDetourFailure,
    EMsg.ClientWalletInfoUpdate: client_server.CMsgClientWalletInfoUpdate,
    EMsg.ClientPICSChangesSinceRequest: app_info.CMsgClientPicsChangesSinceRequest,
    EMsg.ClientPICSChangesSinceResponse: app_info.CMsgClientPicsChangesSinceResponse,
    EMsg.ClientPICSProductInfoRequest: app_info.CMsgClientPicsProductInfoRequest,
    EMsg.ClientPICSProductInfoResponse: app_info.CMsgClientPicsProductInfoResponse,
    EMsg.ClientPICSAccessTokenRequest: app_info.CMsgClientPicsAccessTokenRequest,
    EMsg.ClientPICSAccessTokenResponse: app_info.CMsgClientPicsAccessTokenResponse,
    EMsg.ClientDeregisterWithServer: client_server.CMsgClientDeregisterWithServer,
    EMsg.ClientClanState: client_server.CMsgClientClanState,
    EMsg.ClientScreenshotsChanged: ucm.CMsgClientScreenshotsChanged,
    EMsg.ClientUpdateUserGameInfo: client_server_2.CMsgClientUpdateUserGameInfo,
    EMsg.ClientRichPresenceUpload: client_server_2.CMsgClientRichPresenceUpload,
    EMsg.ClientRichPresenceRequest: client_server_2.CMsgClientRichPresenceRequest,
    EMsg.ClientRichPresenceInfo: client_server_2.CMsgClientRichPresenceInfo,
    EMsg.ClientReadMachineAuth: client_server_2.CMsgClientReadMachineAuth,
    EMsg.ClientReadMachineAuthResponse: client_server_2.CMsgClientReadMachineAuthResponse,
    EMsg.ClientUpdateMachineAuthResponse: client_server_2.CMsgClientUpdateMachineAuthResponse,
    EMsg.ClientRequestMachineAuth: client_server_2.CMsgClientRequestMachineAuth,
    EMsg.ClientRequestMachineAuthResponse: client_server_2.CMsgClientRequestMachineAuthResponse,
    EMsg.ClientRegisterKey: client_server_2.CMsgClientRegisterKey,
    EMsg.ClientPurchaseResponse: client_server_2.CMsgClientPurchaseResponse,
    EMsg.ClientActivateOEMLicense: client_server_2.CMsgClientActivateOemLicense,
    EMsg.ClientRegisterOEMMachine: client_server_2.CMsgClientRegisterOemMachine,
    EMsg.ClientRegisterOEMMachineResponse: client_server_2.CMsgClientRegisterOemMachineResponse,
    EMsg.ClientPurchaseWithMachineID: client_server_2.CMsgClientPurchaseWithMachineId,
    EMsg.ClientGetCDNAuthToken: client_server_2.CMsgClientGetCdnAuthToken,
    EMsg.ClientGetDepotDecryptionKey: client_server_2.CMsgClientGetDepotDecryptionKey,
    EMsg.ClientGetDepotDecryptionKeyResponse: client_server_2.CMsgClientGetDepotDecryptionKeyResponse,
    EMsg.ClientCheckAppBetaPassword: client_server_2.CMsgClientCheckAppBetaPassword,
    EMsg.ClientCheckAppBetaPasswordResponse: client_server_2.CMsgClientCheckAppBetaPasswordResponse,
    EMsg.ClientDPContentStatsReport: client_server_2.CMsgClientDpContentStatsReport,
    EMsg.ClientGetCDNAuthTokenResponse: client_server_2.CMsgClientGetCdnAuthTokenResponse,
    EMsg.ClientRequestAccountData: client_server_2.CMsgClientRequestAccountData,
    EMsg.ClientRequestAccountDataResponse: client_server_2.CMsgClientRequestAccountDataResponse,
    EMsg.ClientRedeemGuestPass: client_server_2.CMsgClientRedeemGuestPass,
    EMsg.ClientRedeemGuestPassResponse: client_server_2.CMsgClientRedeemGuestPassResponse,
    EMsg.ClientGetClanActivityCounts: client_server_2.CMsgClientGetClanActivityCounts,
    EMsg.ClientGetClanActivityCountsResponse: client_server_2.CMsgClientGetClanActivityCountsResponse,
    EMsg.ClientOGSReportString: client_server_2.CMsgClientOgsReportString,
    EMsg.ClientOGSReportBug: client_server_2.CMsgClientOgsReportBug,
    EMsg.ClientSentLogs: client_server_2.CMsgClientSentLogs,
    EMsg.ClientRequestFreeLicense: client_server_2.CMsgClientRequestFreeLicense,
    EMsg.ClientRequestFreeLicenseResponse: client_server_2.CMsgClientRequestFreeLicenseResponse,
    EMsg.ClientRequestForgottenPasswordEmail: client_server_2.CMsgClientRequestForgottenPasswordEmail,
    EMsg.ClientRequestForgottenPasswordEmailResponse: client_server_2.CMsgClientRequestForgottenPasswordEmailResponse,
    EMsg.ClientItemAnnouncements: client_server_2.CMsgClientItemAnnouncements,
    EMsg.ClientRequestItemAnnouncements: client_server_2.CMsgClientRequestItemAnnouncements,
    EMsg.ClientUserNotifications: client_server_2.CMsgClientUserNotifications,
    EMsg.ClientCommentNotifications: client_server_2.CMsgClientCommentNotifications,
    EMsg.ClientRequestCommentNotifications: client_server_2.CMsgClientRequestCommentNotifications,
    EMsg.ClientChatGetFriendMessageHistory: client_server_2.CMsgClientChatGetFriendMessageHistory,
    EMsg.ClientChatGetFriendMessageHistoryResponse: client_server_2.CMsgClientChatGetFriendMessageHistoryResponse,
    EMsg.ClientChatGetFriendMessageHistoryForOfflineMessages: client_server_2.CMsgClientChatGetFriendMessageHistoryForOfflineMessages,
    EMsg.ClientFSGetFriendsSteamLevels: client_server_2.CMsgClientFsGetFriendsSteamLevels,
    EMsg.ClientFSGetFriendsSteamLevelsResponse: client_server_2.CMsgClientFsGetFriendsSteamLevelsResponse,
    EMsg.ClientEmailAddrInfo: client_server_2.CMsgClientEmailAddrInfo,
    EMsg.ClientFriendUserStatusPublished: client_server_2.CMsgClientFriendUserStatusPublished,
    EMsg.ClientServiceMethodLegacy: client_server_2.CMsgClientServiceMethodLegacy,
    EMsg.ClientServiceMethodLegacyResponse: client_server_2.CMsgClientServiceMethodLegacyResponse,
    EMsg.ClientAuthorizeLocalDeviceRequest: client_server_2.CMsgClientAuthorizeLocalDeviceRequest,
    EMsg.ClientAuthorizeLocalDeviceNotification: client_server_2.CMsgClientAuthorizeLocalDeviceNotification,
    EMsg.ClientDeauthorizeDeviceRequest: client_server_2.CMsgClientDeauthorizeDeviceRequest,
    EMsg.ClientDeauthorizeDevice: client_server_2.CMsgClientDeauthorizeDevice,
    EMsg.ClientUseLocalDeviceAuthorizations: client_server_2.CMsgClientUseLocalDeviceAuthorizations,
    EMsg.ClientGetAuthorizedDevices: client_server_2.CMsgClientGetAuthorizedDevices,
    EMsg.ClientGetAuthorizedDevicesResponse: client_server_2.CMsgClientGetAuthorizedDevicesResponse,
    EMsg.ClientSharedLibraryLockStatus: client_server_2.CMsgClientSharedLibraryLockStatus,
    EMsg.ClientSharedLibraryStopPlaying: client_server_2.CMsgClientSharedLibraryStopPlaying,
    EMsg.ClientServiceCall: client_server_2.CMsgClientServiceCall,
    EMsg.ClientServiceModule: client_server_2.CMsgClientServiceModule,
    EMsg.ClientServiceCallResponse: client_server_2.CMsgClientServiceCallResponse,
    EMsg.ClientPlayingSessionState: client_server_2.CMsgClientPlayingSessionState,
    EMsg.ClientKickPlayingSession: client_server_2.CMsgClientKickPlayingSession,
    EMsg.ClientVoiceCallPreAuthorizeResponse: client_server_2.CMsgClientVoiceCallPreAuthorizeResponse,
    EMsg.BadgeCraftedNotification: client_server_2.CMsgBadgeCraftedNotification,
    EMsg.ClientFriendMsg: friends.CMsgClientFriendMsg,
    EMsg.ClientFriendMsgIncoming: friends.CMsgClientFriendMsgIncoming,
    EMsg.ClientAddFriend: friends.CMsgClientAddFriend,
    EMsg.ClientAddFriendResponse: friends.CMsgClientAddFriendResponse,
    EMsg.ClientRemoveFriend: friends.CMsgClientRemoveFriend,
    EMsg.ClientHideFriend: friends.CMsgClientHideFriend,
    EMsg.ClientFriendsList: friends.CMsgClientFriendsList,
    EMsg.ClientFriendsGroupsList: friends.CMsgClientFriendsGroupsList,
    EMsg.ClientRequestFriendData: friends.CMsgClientRequestFriendData,
    EMsg.ClientChangeStatus: friends.CMsgClientChangeStatus,
    EMsg.ClientPersonaState: friends.CMsgClientPersonaState,
    EMsg.ClientFriendProfileInfo: friends.CMsgClientFriendProfileInfo,
    EMsg.ClientFriendProfileInfoResponse: friends.CMsgClientFriendProfileInfoResponse,
    EMsg.ClientGetEmoticonList: friends.CMsgClientGetEmoticonList,
    EMsg.ClientEmoticonList: friends.CMsgClientEmoticonList,
    EMsg.ClientHeartBeat: login.CMsgClientHeartBeat,
    EMsg.ClientServerTimestampRequest: login.CMsgClientServerTimestampRequest,
    EMsg.ClientServerTimestampResponse: login.CMsgClientServerTimestampResponse,
    EMsg.ClientLogon: login.CMsgClientLogon,
    EMsg.ClientLogOnResponse: login.CMsgClientLogonResponse,
    EMsg.ClientLogOff: login.CMsgClientLogOff,
    EMsg.ClientLoggedOff: login.CMsgClientLoggedOff,
    EMsg.ClientNewLoginKey: login.CMsgClientNewLoginKey,
    EMsg.ClientNewLoginKeyAccepted: login.CMsgClientNewLoginKeyAccepted,
    EMsg.ClientAccountInfo: login.CMsgClientAccountInfo,
    EMsg.ClientChallengeRequest: login.CMsgClientChallengeRequest,
    EMsg.ClientChallengeResponse: login.CMsgClientChallengeResponse,
    EMsg.ClientLBSFindOrCreateLB: leaderboards.CMsgClientLbsFindOrCreateLb,
    EMsg.ClientLBSFindOrCreateLBResponse: leaderboards.CMsgClientLbsFindOrCreateLbResponse,
    EMsg.ClientLBSGetLBEntries: leaderboards.CMsgClientLbsGetLbEntries,
    EMsg.ClientLBSGetLBEntriesResponse: leaderboards.CMsgClientLbsGetLbEntriesResponse,
}
