# BSD 3-Clause License; see https://github.com/scikit-hep/awkward-1.0/blob/main/LICENSE

import pytest  # noqa: F401
import numpy as np  # noqa: F401
import awkward as ak  # noqa: F401


def test():
    assert ak.sum([[[], [1, 2]], [[], [3, 4]]], axis=0).tolist() == [[], [4, 6]]
    assert ak.sum([[[], [], [1, 2]], [[], [], [3, 4]]], axis=0).tolist() == [
        [],
        [],
        [4, 6],
    ]
    assert ak.sum([[[], [], [], [1, 2]], [[], [], [], [3, 4]]], axis=0).tolist() == [
        [],
        [],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [], [], [4, 6]]

    assert ak.sum([[[10], [1, 2]], [[], [3, 4]]], axis=0).tolist() == [[10], [4, 6]]
    assert ak.sum([[[10], [], [1, 2]], [[], [], [3, 4]]], axis=0).tolist() == [
        [10],
        [],
        [4, 6],
    ]
    assert ak.sum([[[10], [], [], [1, 2]], [[], [], [], [3, 4]]], axis=0).tolist() == [
        [10],
        [],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[10], [], [], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[10], [], [], [], [4, 6]]

    assert ak.sum([[[], [1, 2]], [[10], [3, 4]]], axis=0).tolist() == [[10], [4, 6]]
    assert ak.sum([[[], [], [1, 2]], [[10], [], [3, 4]]], axis=0).tolist() == [
        [10],
        [],
        [4, 6],
    ]
    assert ak.sum([[[], [], [], [1, 2]], [[10], [], [], [3, 4]]], axis=0).tolist() == [
        [10],
        [],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[10], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[10], [], [], [], [4, 6]]

    assert ak.sum([[[], [10], [1, 2]], [[], [], [3, 4]]], axis=0).tolist() == [
        [],
        [10],
        [4, 6],
    ]
    assert ak.sum([[[], [10], [], [1, 2]], [[], [], [], [3, 4]]], axis=0).tolist() == [
        [],
        [10],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [10], [], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [10], [], [], [4, 6]]

    assert ak.sum([[[], [], [1, 2]], [[], [10], [3, 4]]], axis=0).tolist() == [
        [],
        [10],
        [4, 6],
    ]
    assert ak.sum([[[], [], [], [1, 2]], [[], [10], [], [3, 4]]], axis=0).tolist() == [
        [],
        [10],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [10], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [10], [], [], [4, 6]]

    assert ak.sum([[[], [], [10], [1, 2]], [[], [], [], [3, 4]]], axis=0).tolist() == [
        [],
        [],
        [10],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [10], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [10], [], [4, 6]]

    assert ak.sum([[[], [], [], [1, 2]], [[], [], [10], [3, 4]]], axis=0).tolist() == [
        [],
        [],
        [10],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [], [10], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [10], [], [4, 6]]

    assert ak.sum(
        [[[], [], [], [10], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [], [10], [4, 6]]

    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [], [], [10], [3, 4]]], axis=0
    ).tolist() == [[], [], [], [10], [4, 6]]

    assert ak.sum([[[None], [1, 2]], [[], [3, 4]]], axis=0).tolist() == [[0], [4, 6]]
    assert ak.sum([[[None], [], [1, 2]], [[], [], [3, 4]]], axis=0).tolist() == [
        [0],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[None], [], [], [1, 2]], [[], [], [], [3, 4]]], axis=0
    ).tolist() == [[0], [], [], [4, 6]]
    assert ak.sum(
        [[[None], [], [], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[0], [], [], [], [4, 6]]

    assert ak.sum([[[], [1, 2]], [[None], [3, 4]]], axis=0).tolist() == [[0], [4, 6]]
    assert ak.sum([[[], [], [1, 2]], [[None], [], [3, 4]]], axis=0).tolist() == [
        [0],
        [],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [1, 2]], [[None], [], [], [3, 4]]], axis=0
    ).tolist() == [[0], [], [], [4, 6]]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[None], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[0], [], [], [], [4, 6]]

    assert ak.sum([[[], [None], [1, 2]], [[], [], [3, 4]]], axis=0).tolist() == [
        [],
        [0],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [None], [], [1, 2]], [[], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [0], [], [4, 6]]
    assert ak.sum(
        [[[], [None], [], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [0], [], [], [4, 6]]

    assert ak.sum([[[], [], [1, 2]], [[], [None], [3, 4]]], axis=0).tolist() == [
        [],
        [0],
        [4, 6],
    ]
    assert ak.sum(
        [[[], [], [], [1, 2]], [[], [None], [], [3, 4]]], axis=0
    ).tolist() == [[], [0], [], [4, 6]]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [None], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [0], [], [], [4, 6]]

    assert ak.sum(
        [[[], [], [None], [1, 2]], [[], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [0], [4, 6]]
    assert ak.sum(
        [[[], [], [None], [], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [0], [], [4, 6]]

    assert ak.sum(
        [[[], [], [], [1, 2]], [[], [], [None], [3, 4]]], axis=0
    ).tolist() == [[], [], [0], [4, 6]]
    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [], [None], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [0], [], [4, 6]]

    assert ak.sum(
        [[[], [], [], [None], [1, 2]], [[], [], [], [], [3, 4]]], axis=0
    ).tolist() == [[], [], [], [0], [4, 6]]

    assert ak.sum(
        [[[], [], [], [], [1, 2]], [[], [], [], [None], [3, 4]]], axis=0
    ).tolist() == [[], [], [], [0], [4, 6]]
