# BSD 3-Clause License; see https://github.com/scikit-hep/awkward-1.0/blob/main/LICENSE

import pytest  # noqa: F401
import numpy as np  # noqa: F401
import awkward as ak  # noqa: F401

numba = pytest.importorskip("numba")

ak._v2.numba.register_and_check()


def test():
    @numba.njit
    def do_something(array):
        out = np.zeros(len(array), np.bool_)
        for i, x in enumerate(array):
            if x:
                out[i] = x
        return out

    array = ak._v2.highlevel.Array([True, False, False])
    assert do_something(array).tolist() == [True, False, False]
