import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The resource name must be 1-63 characters long, and comply
     * with RFC1035. Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
     * first character must be a lowercase letter, and all following characters
     * must be a dash, lowercase letter, or digit, except the last character,
     * which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#name DataGoogleComputeResourcePolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#project DataGoogleComputeResourcePolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where resource policy resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#region DataGoogleComputeResourcePolicy#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicyGroupPlacementPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get availabilityDomainCount(): number;
    /**
     * @stability stable
     */
    get collocation(): string;
    /**
     * @stability stable
     */
    get vmCount(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get schedule(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get schedule(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    get vmStartSchedule(): any;
    /**
     * @stability stable
     */
    get vmStopSchedule(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxRetentionDays(): number;
    /**
     * @stability stable
     */
    get onSourceDiskDelete(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get daysInCycle(): number;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hoursInCycle(): number;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get day(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dayOfWeeks(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dailySchedule(): any;
    /**
     * @stability stable
     */
    get hourlySchedule(): any;
    /**
     * @stability stable
     */
    get weeklySchedule(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get guestFlush(): any;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get storageLocations(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get retentionPolicy(): any;
    /**
     * @stability stable
     */
    get schedule(): any;
    /**
     * @stability stable
     */
    get snapshotProperties(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html google_compute_resource_policy}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeResourcePolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html google_compute_resource_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeResourcePolicyConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    groupPlacementPolicy(index: string): DataGoogleComputeResourcePolicyGroupPlacementPolicy;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    instanceSchedulePolicy(index: string): DataGoogleComputeResourcePolicyInstanceSchedulePolicy;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    snapshotSchedulePolicy(index: string): DataGoogleComputeResourcePolicySnapshotSchedulePolicy;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
