import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TagsTagValueIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#member TagsTagValueIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#role TagsTagValueIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#tag_value TagsTagValueIamMember#tag_value}.
     *
     * @stability stable
     */
    readonly tagValue: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#condition TagsTagValueIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: TagsTagValueIamMemberCondition;
}
/**
 * @stability stable
 */
export interface TagsTagValueIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#description TagsTagValueIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#expression TagsTagValueIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html#title TagsTagValueIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * @stability stable
 */
export declare class TagsTagValueIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html google_tags_tag_value_iam_member}.
 *
 * @stability stable
 */
export declare class TagsTagValueIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_member.html google_tags_tag_value_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TagsTagValueIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _tagValue?;
    /**
     * @stability stable
     */
    get tagValue(): string;
    /**
     * @stability stable
     */
    set tagValue(value: string);
    /**
     * @stability stable
     */
    get tagValueInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    /**
     * @stability stable
     */
    get condition(): TagsTagValueIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: TagsTagValueIamMemberCondition | undefined): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): TagsTagValueIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
