from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="ultranlp",
    version="1.0.4",
    author="Dushyant",
    author_email="dushyantkv508@gmail.com",
    description="Ultra-fast, comprehensive NLP preprocessing library with advanced tokenization",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/dushyantzz/UltraNLP",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Text Processing :: Linguistic",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
    python_requires=">=3.8",
    install_requires=[
        "beautifulsoup4>=4.9.0",
    ],
    extras_require={
        "dev": ["pytest>=6.0", "black", "flake8", "mypy"],
        "benchmark": ["matplotlib", "pandas", "seaborn"],
    },
    keywords="nlp, text-processing, tokenization, preprocessing, machine-learning, natural-language-processing",
)
