import clr, abc
from System import ReadOnlySpan_1, Half, Span_1

class BinaryPrimitives(abc.ABC):
    @staticmethod
    def ReadDoubleBigEndian(source: ReadOnlySpan_1[int]) -> float: ...
    @staticmethod
    def ReadDoubleLittleEndian(source: ReadOnlySpan_1[int]) -> float: ...
    @staticmethod
    def ReadHalfBigEndian(source: ReadOnlySpan_1[int]) -> Half: ...
    @staticmethod
    def ReadHalfLittleEndian(source: ReadOnlySpan_1[int]) -> Half: ...
    @staticmethod
    def ReadInt16BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadInt16LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadInt32BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadInt32LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadInt64BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadInt64LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadSingleBigEndian(source: ReadOnlySpan_1[int]) -> float: ...
    @staticmethod
    def ReadSingleLittleEndian(source: ReadOnlySpan_1[int]) -> float: ...
    @staticmethod
    def ReadUInt16BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadUInt16LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadUInt32BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadUInt32LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadUInt64BigEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def ReadUInt64LittleEndian(source: ReadOnlySpan_1[int]) -> int: ...
    @staticmethod
    def TryReadDoubleBigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[float]) -> bool: ...
    @staticmethod
    def TryReadDoubleLittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[float]) -> bool: ...
    @staticmethod
    def TryReadHalfBigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[Half]) -> bool: ...
    @staticmethod
    def TryReadHalfLittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[Half]) -> bool: ...
    @staticmethod
    def TryReadInt16BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadInt16LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadInt32BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadInt32LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadInt64BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadInt64LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadSingleBigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[float]) -> bool: ...
    @staticmethod
    def TryReadSingleLittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[float]) -> bool: ...
    @staticmethod
    def TryReadUInt16BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadUInt16LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadUInt32BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadUInt32LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadUInt64BigEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryReadUInt64LittleEndian(source: ReadOnlySpan_1[int], value: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryWriteDoubleBigEndian(destination: Span_1[int], value: float) -> bool: ...
    @staticmethod
    def TryWriteDoubleLittleEndian(destination: Span_1[int], value: float) -> bool: ...
    @staticmethod
    def TryWriteHalfBigEndian(destination: Span_1[int], value: Half) -> bool: ...
    @staticmethod
    def TryWriteHalfLittleEndian(destination: Span_1[int], value: Half) -> bool: ...
    @staticmethod
    def TryWriteInt16BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteInt16LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteInt32BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteInt32LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteInt64BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteInt64LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteSingleBigEndian(destination: Span_1[int], value: float) -> bool: ...
    @staticmethod
    def TryWriteSingleLittleEndian(destination: Span_1[int], value: float) -> bool: ...
    @staticmethod
    def TryWriteUInt16BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteUInt16LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteUInt32BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteUInt32LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteUInt64BigEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def TryWriteUInt64LittleEndian(destination: Span_1[int], value: int) -> bool: ...
    @staticmethod
    def WriteDoubleBigEndian(destination: Span_1[int], value: float) -> None: ...
    @staticmethod
    def WriteDoubleLittleEndian(destination: Span_1[int], value: float) -> None: ...
    @staticmethod
    def WriteHalfBigEndian(destination: Span_1[int], value: Half) -> None: ...
    @staticmethod
    def WriteHalfLittleEndian(destination: Span_1[int], value: Half) -> None: ...
    @staticmethod
    def WriteInt16BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteInt16LittleEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteInt32BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteInt32LittleEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteInt64BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteInt64LittleEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteSingleBigEndian(destination: Span_1[int], value: float) -> None: ...
    @staticmethod
    def WriteSingleLittleEndian(destination: Span_1[int], value: float) -> None: ...
    @staticmethod
    def WriteUInt16BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteUInt16LittleEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteUInt32BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteUInt32LittleEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteUInt64BigEndian(destination: Span_1[int], value: int) -> None: ...
    @staticmethod
    def WriteUInt64LittleEndian(destination: Span_1[int], value: int) -> None: ...
    # Skipped ReverseEndianness due to it being static, abstract and generic.

    ReverseEndianness : ReverseEndianness_MethodGroup
    class ReverseEndianness_MethodGroup:
        def __call__(self, value: int) -> int:...
        # Method ReverseEndianness(value : Int16) was skipped since it collides with above method
        # Method ReverseEndianness(value : Int32) was skipped since it collides with above method
        # Method ReverseEndianness(value : Int64) was skipped since it collides with above method
        # Method ReverseEndianness(value : Byte) was skipped since it collides with above method
        # Method ReverseEndianness(value : UInt16) was skipped since it collides with above method
        # Method ReverseEndianness(value : UInt32) was skipped since it collides with above method
        # Method ReverseEndianness(value : UInt64) was skipped since it collides with above method


