import typing, clr, abc
from System import ICloneable, Array_1, DateTime, DayOfWeek, ReadOnlySpan_1, Span_1, IFormatProvider, ArgumentException, Exception, TimeSpan, StringComparer, IEquatable_1, Guid
from System.Runtime.Serialization import IDeserializationCallback, SerializationInfo, StreamingContext
from System.Reflection import Assembly, MethodBase
from System.Text import Rune
from System.Collections import IDictionary, IEnumerator

class Calendar(ICloneable, abc.ABC):
    CurrentEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddDays(self, time: DateTime, days: int) -> DateTime: ...
    def AddHours(self, time: DateTime, hours: int) -> DateTime: ...
    def AddMilliseconds(self, time: DateTime, milliseconds: float) -> DateTime: ...
    def AddMinutes(self, time: DateTime, minutes: int) -> DateTime: ...
    @abc.abstractmethod
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddSeconds(self, time: DateTime, seconds: int) -> DateTime: ...
    def AddWeeks(self, time: DateTime, weeks: int) -> DateTime: ...
    @abc.abstractmethod
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def Clone(self) -> typing.Any: ...
    @abc.abstractmethod
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    @abc.abstractmethod
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    @abc.abstractmethod
    def GetDayOfYear(self, time: DateTime) -> int: ...
    @abc.abstractmethod
    def GetEra(self, time: DateTime) -> int: ...
    def GetHour(self, time: DateTime) -> int: ...
    def GetMilliseconds(self, time: DateTime) -> float: ...
    def GetMinute(self, time: DateTime) -> int: ...
    @abc.abstractmethod
    def GetMonth(self, time: DateTime) -> int: ...
    def GetSecond(self, time: DateTime) -> int: ...
    def GetWeekOfYear(self, time: DateTime, rule: CalendarWeekRule, firstDayOfWeek: DayOfWeek) -> int: ...
    @abc.abstractmethod
    def GetYear(self, time: DateTime) -> int: ...
    @staticmethod
    def ReadOnly(calendar: Calendar) -> Calendar: ...
    def ToFourDigitYear(self, year: int) -> int: ...
    # Skipped GetDaysInMonth due to it being static, abstract and generic.

    GetDaysInMonth : GetDaysInMonth_MethodGroup
    class GetDaysInMonth_MethodGroup:
        @typing.overload
        def __call__(self, year: int, month: int) -> int:...
        @typing.overload
        def __call__(self, year: int, month: int, era: int) -> int:...

    # Skipped GetDaysInYear due to it being static, abstract and generic.

    GetDaysInYear : GetDaysInYear_MethodGroup
    class GetDaysInYear_MethodGroup:
        @typing.overload
        def __call__(self, year: int) -> int:...
        @typing.overload
        def __call__(self, year: int, era: int) -> int:...

    # Skipped GetLeapMonth due to it being static, abstract and generic.

    GetLeapMonth : GetLeapMonth_MethodGroup
    class GetLeapMonth_MethodGroup:
        @typing.overload
        def __call__(self, year: int) -> int:...
        @typing.overload
        def __call__(self, year: int, era: int) -> int:...

    # Skipped GetMonthsInYear due to it being static, abstract and generic.

    GetMonthsInYear : GetMonthsInYear_MethodGroup
    class GetMonthsInYear_MethodGroup:
        @typing.overload
        def __call__(self, year: int) -> int:...
        @typing.overload
        def __call__(self, year: int, era: int) -> int:...

    # Skipped IsLeapDay due to it being static, abstract and generic.

    IsLeapDay : IsLeapDay_MethodGroup
    class IsLeapDay_MethodGroup:
        @typing.overload
        def __call__(self, year: int, month: int, day: int) -> bool:...
        @typing.overload
        def __call__(self, year: int, month: int, day: int, era: int) -> bool:...

    # Skipped IsLeapMonth due to it being static, abstract and generic.

    IsLeapMonth : IsLeapMonth_MethodGroup
    class IsLeapMonth_MethodGroup:
        @typing.overload
        def __call__(self, year: int, month: int) -> bool:...
        @typing.overload
        def __call__(self, year: int, month: int, era: int) -> bool:...

    # Skipped IsLeapYear due to it being static, abstract and generic.

    IsLeapYear : IsLeapYear_MethodGroup
    class IsLeapYear_MethodGroup:
        @typing.overload
        def __call__(self, year: int) -> bool:...
        @typing.overload
        def __call__(self, year: int, era: int) -> bool:...

    # Skipped ToDateTime due to it being static, abstract and generic.

    ToDateTime : ToDateTime_MethodGroup
    class ToDateTime_MethodGroup:
        @typing.overload
        def __call__(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int) -> DateTime:...
        @typing.overload
        def __call__(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime:...



class CalendarAlgorithmType(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Unknown : CalendarAlgorithmType # 0
    SolarCalendar : CalendarAlgorithmType # 1
    LunarCalendar : CalendarAlgorithmType # 2
    LunisolarCalendar : CalendarAlgorithmType # 3


class CalendarWeekRule(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    FirstDay : CalendarWeekRule # 0
    FirstFullWeek : CalendarWeekRule # 1
    FirstFourDayWeek : CalendarWeekRule # 2


class CharUnicodeInfo(abc.ABC):
    # Skipped GetDecimalDigitValue due to it being static, abstract and generic.

    GetDecimalDigitValue : GetDecimalDigitValue_MethodGroup
    class GetDecimalDigitValue_MethodGroup:
        @typing.overload
        def __call__(self, ch: str) -> int:...
        @typing.overload
        def __call__(self, s: str, index: int) -> int:...

    # Skipped GetDigitValue due to it being static, abstract and generic.

    GetDigitValue : GetDigitValue_MethodGroup
    class GetDigitValue_MethodGroup:
        @typing.overload
        def __call__(self, ch: str) -> int:...
        @typing.overload
        def __call__(self, s: str, index: int) -> int:...

    # Skipped GetNumericValue due to it being static, abstract and generic.

    GetNumericValue : GetNumericValue_MethodGroup
    class GetNumericValue_MethodGroup:
        @typing.overload
        def __call__(self, ch: str) -> float:...
        @typing.overload
        def __call__(self, s: str, index: int) -> float:...

    # Skipped GetUnicodeCategory due to it being static, abstract and generic.

    GetUnicodeCategory : GetUnicodeCategory_MethodGroup
    class GetUnicodeCategory_MethodGroup:
        @typing.overload
        def __call__(self, ch: str) -> UnicodeCategory:...
        @typing.overload
        def __call__(self, codePoint: int) -> UnicodeCategory:...
        @typing.overload
        def __call__(self, s: str, index: int) -> UnicodeCategory:...



class ChineseLunisolarCalendar(EastAsianLunisolarCalendar):
    def __init__(self) -> None: ...
    ChineseEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...


class CompareInfo(IDeserializationCallback):
    @property
    def LCID(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def Version(self) -> SortVersion: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetSortKeyLength(self, source: ReadOnlySpan_1[str], options: CompareOptions = ...) -> int: ...
    def ToString(self) -> str: ...
    # Skipped Compare due to it being static, abstract and generic.

    Compare : Compare_MethodGroup
    class Compare_MethodGroup:
        @typing.overload
        def __call__(self, string1: str, string2: str) -> int:...
        @typing.overload
        def __call__(self, string1: ReadOnlySpan_1[str], string2: ReadOnlySpan_1[str], options: CompareOptions = ...) -> int:...
        @typing.overload
        def __call__(self, string1: str, string2: str, options: CompareOptions) -> int:...
        @typing.overload
        def __call__(self, string1: str, offset1: int, string2: str, offset2: int) -> int:...
        @typing.overload
        def __call__(self, string1: str, offset1: int, string2: str, offset2: int, options: CompareOptions) -> int:...
        @typing.overload
        def __call__(self, string1: str, offset1: int, length1: int, string2: str, offset2: int, length2: int) -> int:...
        @typing.overload
        def __call__(self, string1: str, offset1: int, length1: int, string2: str, offset2: int, length2: int, options: CompareOptions) -> int:...

    # Skipped GetCompareInfo due to it being static, abstract and generic.

    GetCompareInfo : GetCompareInfo_MethodGroup
    class GetCompareInfo_MethodGroup:
        @typing.overload
        def __call__(self, culture: int) -> CompareInfo:...
        @typing.overload
        def __call__(self, name: str) -> CompareInfo:...
        @typing.overload
        def __call__(self, culture: int, assembly: Assembly) -> CompareInfo:...
        @typing.overload
        def __call__(self, name: str, assembly: Assembly) -> CompareInfo:...

    # Skipped GetHashCode due to it being static, abstract and generic.

    GetHashCode : GetHashCode_MethodGroup
    class GetHashCode_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], options: CompareOptions) -> int:...
        @typing.overload
        def __call__(self, source: str, options: CompareOptions) -> int:...

    # Skipped GetSortKey due to it being static, abstract and generic.

    GetSortKey : GetSortKey_MethodGroup
    class GetSortKey_MethodGroup:
        @typing.overload
        def __call__(self, source: str) -> SortKey:...
        @typing.overload
        def __call__(self, source: str, options: CompareOptions) -> SortKey:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], destination: Span_1[int], options: CompareOptions = ...) -> int:...

    # Skipped IndexOf due to it being static, abstract and generic.

    IndexOf : IndexOf_MethodGroup
    class IndexOf_MethodGroup:
        @typing.overload
        def __call__(self, source: str, value: str) -> int:...
        # Method IndexOf(source : String, value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: ReadOnlySpan_1[str], options: CompareOptions = ...) -> int:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: Rune, options: CompareOptions = ...) -> int:...
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int) -> int:...
        # Method IndexOf(source : String, value : String, startIndex : Int32) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, options: CompareOptions) -> int:...
        # Method IndexOf(source : String, value : String, options : CompareOptions) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: ReadOnlySpan_1[str], options: CompareOptions, matchLength: clr.Reference[int]) -> int:...
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, count: int) -> int:...
        # Method IndexOf(source : String, value : String, startIndex : Int32, count : Int32) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, options: CompareOptions) -> int:...
        # Method IndexOf(source : String, value : String, startIndex : Int32, options : CompareOptions) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, count: int, options: CompareOptions) -> int:...
        # Method IndexOf(source : String, value : String, startIndex : Int32, count : Int32, options : CompareOptions) was skipped since it collides with above method

    # Skipped IsPrefix due to it being static, abstract and generic.

    IsPrefix : IsPrefix_MethodGroup
    class IsPrefix_MethodGroup:
        @typing.overload
        def __call__(self, source: str, prefix: str) -> bool:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], prefix: ReadOnlySpan_1[str], options: CompareOptions = ...) -> bool:...
        @typing.overload
        def __call__(self, source: str, prefix: str, options: CompareOptions) -> bool:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], prefix: ReadOnlySpan_1[str], options: CompareOptions, matchLength: clr.Reference[int]) -> bool:...

    # Skipped IsSortable due to it being static, abstract and generic.

    IsSortable : IsSortable_MethodGroup
    class IsSortable_MethodGroup:
        @typing.overload
        def __call__(self, ch: str) -> bool:...
        @typing.overload
        def __call__(self, text: ReadOnlySpan_1[str]) -> bool:...
        # Method IsSortable(text : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Rune) -> bool:...

    # Skipped IsSuffix due to it being static, abstract and generic.

    IsSuffix : IsSuffix_MethodGroup
    class IsSuffix_MethodGroup:
        @typing.overload
        def __call__(self, source: str, suffix: str) -> bool:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], suffix: ReadOnlySpan_1[str], options: CompareOptions = ...) -> bool:...
        @typing.overload
        def __call__(self, source: str, suffix: str, options: CompareOptions) -> bool:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], suffix: ReadOnlySpan_1[str], options: CompareOptions, matchLength: clr.Reference[int]) -> bool:...

    # Skipped LastIndexOf due to it being static, abstract and generic.

    LastIndexOf : LastIndexOf_MethodGroup
    class LastIndexOf_MethodGroup:
        @typing.overload
        def __call__(self, source: str, value: str) -> int:...
        # Method LastIndexOf(source : String, value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: ReadOnlySpan_1[str], options: CompareOptions = ...) -> int:...
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: Rune, options: CompareOptions = ...) -> int:...
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int) -> int:...
        # Method LastIndexOf(source : String, value : String, startIndex : Int32) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, options: CompareOptions) -> int:...
        # Method LastIndexOf(source : String, value : String, options : CompareOptions) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: ReadOnlySpan_1[str], value: ReadOnlySpan_1[str], options: CompareOptions, matchLength: clr.Reference[int]) -> int:...
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, count: int) -> int:...
        # Method LastIndexOf(source : String, value : String, startIndex : Int32, count : Int32) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, options: CompareOptions) -> int:...
        # Method LastIndexOf(source : String, value : String, startIndex : Int32, options : CompareOptions) was skipped since it collides with above method
        @typing.overload
        def __call__(self, source: str, value: str, startIndex: int, count: int, options: CompareOptions) -> int:...
        # Method LastIndexOf(source : String, value : String, startIndex : Int32, count : Int32, options : CompareOptions) was skipped since it collides with above method



class CompareOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : CompareOptions # 0
    IgnoreCase : CompareOptions # 1
    IgnoreNonSpace : CompareOptions # 2
    IgnoreSymbols : CompareOptions # 4
    IgnoreKanaType : CompareOptions # 8
    IgnoreWidth : CompareOptions # 16
    OrdinalIgnoreCase : CompareOptions # 268435456
    StringSort : CompareOptions # 536870912
    Ordinal : CompareOptions # 1073741824


class CultureInfo(ICloneable, IFormatProvider):
    @typing.overload
    def __init__(self, culture: int) -> None: ...
    @typing.overload
    def __init__(self, culture: int, useUserOverride: bool) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, name: str, useUserOverride: bool) -> None: ...
    @property
    def Calendar(self) -> Calendar: ...
    @property
    def CompareInfo(self) -> CompareInfo: ...
    @property
    def CultureTypes(self) -> CultureTypes: ...
    @classmethod
    @property
    def CurrentCulture(cls) -> CultureInfo: ...
    @classmethod
    @CurrentCulture.setter
    def CurrentCulture(cls, value: CultureInfo) -> CultureInfo: ...
    @classmethod
    @property
    def CurrentUICulture(cls) -> CultureInfo: ...
    @classmethod
    @CurrentUICulture.setter
    def CurrentUICulture(cls, value: CultureInfo) -> CultureInfo: ...
    @property
    def DateTimeFormat(self) -> DateTimeFormatInfo: ...
    @DateTimeFormat.setter
    def DateTimeFormat(self, value: DateTimeFormatInfo) -> DateTimeFormatInfo: ...
    @classmethod
    @property
    def DefaultThreadCurrentCulture(cls) -> CultureInfo: ...
    @classmethod
    @DefaultThreadCurrentCulture.setter
    def DefaultThreadCurrentCulture(cls, value: CultureInfo) -> CultureInfo: ...
    @classmethod
    @property
    def DefaultThreadCurrentUICulture(cls) -> CultureInfo: ...
    @classmethod
    @DefaultThreadCurrentUICulture.setter
    def DefaultThreadCurrentUICulture(cls, value: CultureInfo) -> CultureInfo: ...
    @property
    def DisplayName(self) -> str: ...
    @property
    def EnglishName(self) -> str: ...
    @property
    def IetfLanguageTag(self) -> str: ...
    @classmethod
    @property
    def InstalledUICulture(cls) -> CultureInfo: ...
    @classmethod
    @property
    def InvariantCulture(cls) -> CultureInfo: ...
    @property
    def IsNeutralCulture(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def KeyboardLayoutId(self) -> int: ...
    @property
    def LCID(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def NativeName(self) -> str: ...
    @property
    def NumberFormat(self) -> NumberFormatInfo: ...
    @NumberFormat.setter
    def NumberFormat(self, value: NumberFormatInfo) -> NumberFormatInfo: ...
    @property
    def OptionalCalendars(self) -> Array_1[Calendar]: ...
    @property
    def Parent(self) -> CultureInfo: ...
    @property
    def TextInfo(self) -> TextInfo: ...
    @property
    def ThreeLetterISOLanguageName(self) -> str: ...
    @property
    def ThreeLetterWindowsLanguageName(self) -> str: ...
    @property
    def TwoLetterISOLanguageName(self) -> str: ...
    @property
    def UseUserOverride(self) -> bool: ...
    def ClearCachedData(self) -> None: ...
    def Clone(self) -> typing.Any: ...
    @staticmethod
    def CreateSpecificCulture(name: str) -> CultureInfo: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetConsoleFallbackUICulture(self) -> CultureInfo: ...
    @staticmethod
    def GetCultureInfoByIetfLanguageTag(name: str) -> CultureInfo: ...
    @staticmethod
    def GetCultures(types: CultureTypes) -> Array_1[CultureInfo]: ...
    def GetFormat(self, formatType: typing.Type[typing.Any]) -> typing.Any: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def ReadOnly(ci: CultureInfo) -> CultureInfo: ...
    def ToString(self) -> str: ...
    # Skipped GetCultureInfo due to it being static, abstract and generic.

    GetCultureInfo : GetCultureInfo_MethodGroup
    class GetCultureInfo_MethodGroup:
        @typing.overload
        def __call__(self, culture: int) -> CultureInfo:...
        @typing.overload
        def __call__(self, name: str) -> CultureInfo:...
        @typing.overload
        def __call__(self, name: str, altName: str) -> CultureInfo:...
        @typing.overload
        def __call__(self, name: str, predefinedOnly: bool) -> CultureInfo:...



class CultureNotFoundException(ArgumentException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, invalidCultureId: int, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, invalidCultureName: str, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, paramName: str, invalidCultureId: int, message: str) -> None: ...
    @typing.overload
    def __init__(self, paramName: str, invalidCultureName: str, message: str) -> None: ...
    @typing.overload
    def __init__(self, paramName: str, message: str) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def InvalidCultureId(self) -> typing.Optional[int]: ...
    @property
    def InvalidCultureName(self) -> str: ...
    @property
    def Message(self) -> str: ...
    @property
    def ParamName(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...


class CultureTypes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    NeutralCultures : CultureTypes # 1
    SpecificCultures : CultureTypes # 2
    InstalledWin32Cultures : CultureTypes # 4
    AllCultures : CultureTypes # 7
    UserCustomCulture : CultureTypes # 8
    ReplacementCultures : CultureTypes # 16
    WindowsOnlyCultures : CultureTypes # 32
    FrameworkCultures : CultureTypes # 64


class DateTimeFormatInfo(ICloneable, IFormatProvider):
    def __init__(self) -> None: ...
    @property
    def AbbreviatedDayNames(self) -> Array_1[str]: ...
    @AbbreviatedDayNames.setter
    def AbbreviatedDayNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def AbbreviatedMonthGenitiveNames(self) -> Array_1[str]: ...
    @AbbreviatedMonthGenitiveNames.setter
    def AbbreviatedMonthGenitiveNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def AbbreviatedMonthNames(self) -> Array_1[str]: ...
    @AbbreviatedMonthNames.setter
    def AbbreviatedMonthNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def AMDesignator(self) -> str: ...
    @AMDesignator.setter
    def AMDesignator(self, value: str) -> str: ...
    @property
    def Calendar(self) -> Calendar: ...
    @Calendar.setter
    def Calendar(self, value: Calendar) -> Calendar: ...
    @property
    def CalendarWeekRule(self) -> CalendarWeekRule: ...
    @CalendarWeekRule.setter
    def CalendarWeekRule(self, value: CalendarWeekRule) -> CalendarWeekRule: ...
    @classmethod
    @property
    def CurrentInfo(cls) -> DateTimeFormatInfo: ...
    @property
    def DateSeparator(self) -> str: ...
    @DateSeparator.setter
    def DateSeparator(self, value: str) -> str: ...
    @property
    def DayNames(self) -> Array_1[str]: ...
    @DayNames.setter
    def DayNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def FirstDayOfWeek(self) -> DayOfWeek: ...
    @FirstDayOfWeek.setter
    def FirstDayOfWeek(self, value: DayOfWeek) -> DayOfWeek: ...
    @property
    def FullDateTimePattern(self) -> str: ...
    @FullDateTimePattern.setter
    def FullDateTimePattern(self, value: str) -> str: ...
    @classmethod
    @property
    def InvariantInfo(cls) -> DateTimeFormatInfo: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def LongDatePattern(self) -> str: ...
    @LongDatePattern.setter
    def LongDatePattern(self, value: str) -> str: ...
    @property
    def LongTimePattern(self) -> str: ...
    @LongTimePattern.setter
    def LongTimePattern(self, value: str) -> str: ...
    @property
    def MonthDayPattern(self) -> str: ...
    @MonthDayPattern.setter
    def MonthDayPattern(self, value: str) -> str: ...
    @property
    def MonthGenitiveNames(self) -> Array_1[str]: ...
    @MonthGenitiveNames.setter
    def MonthGenitiveNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def MonthNames(self) -> Array_1[str]: ...
    @MonthNames.setter
    def MonthNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def NativeCalendarName(self) -> str: ...
    @property
    def PMDesignator(self) -> str: ...
    @PMDesignator.setter
    def PMDesignator(self, value: str) -> str: ...
    @property
    def RFC1123Pattern(self) -> str: ...
    @property
    def ShortDatePattern(self) -> str: ...
    @ShortDatePattern.setter
    def ShortDatePattern(self, value: str) -> str: ...
    @property
    def ShortestDayNames(self) -> Array_1[str]: ...
    @ShortestDayNames.setter
    def ShortestDayNames(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def ShortTimePattern(self) -> str: ...
    @ShortTimePattern.setter
    def ShortTimePattern(self, value: str) -> str: ...
    @property
    def SortableDateTimePattern(self) -> str: ...
    @property
    def TimeSeparator(self) -> str: ...
    @TimeSeparator.setter
    def TimeSeparator(self, value: str) -> str: ...
    @property
    def UniversalSortableDateTimePattern(self) -> str: ...
    @property
    def YearMonthPattern(self) -> str: ...
    @YearMonthPattern.setter
    def YearMonthPattern(self, value: str) -> str: ...
    def Clone(self) -> typing.Any: ...
    def GetAbbreviatedDayName(self, dayofweek: DayOfWeek) -> str: ...
    def GetAbbreviatedEraName(self, era: int) -> str: ...
    def GetAbbreviatedMonthName(self, month: int) -> str: ...
    def GetDayName(self, dayofweek: DayOfWeek) -> str: ...
    def GetEra(self, eraName: str) -> int: ...
    def GetEraName(self, era: int) -> str: ...
    def GetFormat(self, formatType: typing.Type[typing.Any]) -> typing.Any: ...
    @staticmethod
    def GetInstance(provider: IFormatProvider) -> DateTimeFormatInfo: ...
    def GetMonthName(self, month: int) -> str: ...
    def GetShortestDayName(self, dayOfWeek: DayOfWeek) -> str: ...
    @staticmethod
    def ReadOnly(dtfi: DateTimeFormatInfo) -> DateTimeFormatInfo: ...
    def SetAllDateTimePatterns(self, patterns: Array_1[str], format: str) -> None: ...
    # Skipped GetAllDateTimePatterns due to it being static, abstract and generic.

    GetAllDateTimePatterns : GetAllDateTimePatterns_MethodGroup
    class GetAllDateTimePatterns_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[str]:...
        @typing.overload
        def __call__(self, format: str) -> Array_1[str]:...



class DateTimeStyles(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : DateTimeStyles # 0
    AllowLeadingWhite : DateTimeStyles # 1
    AllowTrailingWhite : DateTimeStyles # 2
    AllowInnerWhite : DateTimeStyles # 4
    AllowWhiteSpaces : DateTimeStyles # 7
    NoCurrentDateDefault : DateTimeStyles # 8
    AdjustToUniversal : DateTimeStyles # 16
    AssumeLocal : DateTimeStyles # 32
    AssumeUniversal : DateTimeStyles # 64
    RoundtripKind : DateTimeStyles # 128


class DaylightTime:
    def __init__(self, start: DateTime, end: DateTime, delta: TimeSpan) -> None: ...
    @property
    def Delta(self) -> TimeSpan: ...
    @property
    def End(self) -> DateTime: ...
    @property
    def Start(self) -> DateTime: ...


class DigitShapes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Context : DigitShapes # 0
    None_ : DigitShapes # 1
    NativeNational : DigitShapes # 2


class EastAsianLunisolarCalendar(Calendar):
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetCelestialStem(self, sexagenaryYear: int) -> int: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetSexagenaryYear(self, time: DateTime) -> int: ...
    def GetTerrestrialBranch(self, sexagenaryYear: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class GlobalizationExtensions(abc.ABC):
    @staticmethod
    def GetStringComparer(compareInfo: CompareInfo, options: CompareOptions) -> StringComparer: ...


class GregorianCalendar(Calendar):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: GregorianCalendarTypes) -> None: ...
    ADEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def CalendarType(self) -> GregorianCalendarTypes: ...
    @CalendarType.setter
    def CalendarType(self, value: GregorianCalendarTypes) -> GregorianCalendarTypes: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class GregorianCalendarTypes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Localized : GregorianCalendarTypes # 1
    USEnglish : GregorianCalendarTypes # 2
    MiddleEastFrench : GregorianCalendarTypes # 9
    Arabic : GregorianCalendarTypes # 10
    TransliteratedEnglish : GregorianCalendarTypes # 11
    TransliteratedFrench : GregorianCalendarTypes # 12


class HebrewCalendar(Calendar):
    def __init__(self) -> None: ...
    HebrewEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class HijriCalendar(Calendar):
    def __init__(self) -> None: ...
    HijriEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def HijriAdjustment(self) -> int: ...
    @HijriAdjustment.setter
    def HijriAdjustment(self, value: int) -> int: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class IdnMapping:
    def __init__(self) -> None: ...
    @property
    def AllowUnassigned(self) -> bool: ...
    @AllowUnassigned.setter
    def AllowUnassigned(self, value: bool) -> bool: ...
    @property
    def UseStd3AsciiRules(self) -> bool: ...
    @UseStd3AsciiRules.setter
    def UseStd3AsciiRules(self, value: bool) -> bool: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    # Skipped GetAscii due to it being static, abstract and generic.

    GetAscii : GetAscii_MethodGroup
    class GetAscii_MethodGroup:
        @typing.overload
        def __call__(self, unicode: str) -> str:...
        @typing.overload
        def __call__(self, unicode: str, index: int) -> str:...
        @typing.overload
        def __call__(self, unicode: str, index: int, count: int) -> str:...

    # Skipped GetUnicode due to it being static, abstract and generic.

    GetUnicode : GetUnicode_MethodGroup
    class GetUnicode_MethodGroup:
        @typing.overload
        def __call__(self, ascii: str) -> str:...
        @typing.overload
        def __call__(self, ascii: str, index: int) -> str:...
        @typing.overload
        def __call__(self, ascii: str, index: int, count: int) -> str:...



class ISOWeek(abc.ABC):
    @staticmethod
    def GetWeekOfYear(date: DateTime) -> int: ...
    @staticmethod
    def GetWeeksInYear(year: int) -> int: ...
    @staticmethod
    def GetYear(date: DateTime) -> int: ...
    @staticmethod
    def GetYearEnd(year: int) -> DateTime: ...
    @staticmethod
    def GetYearStart(year: int) -> DateTime: ...
    @staticmethod
    def ToDateTime(year: int, week: int, dayOfWeek: DayOfWeek) -> DateTime: ...


class JapaneseCalendar(Calendar):
    def __init__(self) -> None: ...
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetWeekOfYear(self, time: DateTime, rule: CalendarWeekRule, firstDayOfWeek: DayOfWeek) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class JapaneseLunisolarCalendar(EastAsianLunisolarCalendar):
    def __init__(self) -> None: ...
    JapaneseEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...


class JulianCalendar(Calendar):
    def __init__(self) -> None: ...
    JulianEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class KoreanCalendar(Calendar):
    def __init__(self) -> None: ...
    KoreanEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetWeekOfYear(self, time: DateTime, rule: CalendarWeekRule, firstDayOfWeek: DayOfWeek) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class KoreanLunisolarCalendar(EastAsianLunisolarCalendar):
    def __init__(self) -> None: ...
    GregorianEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...


class NumberFormatInfo(ICloneable, IFormatProvider):
    def __init__(self) -> None: ...
    @property
    def CurrencyDecimalDigits(self) -> int: ...
    @CurrencyDecimalDigits.setter
    def CurrencyDecimalDigits(self, value: int) -> int: ...
    @property
    def CurrencyDecimalSeparator(self) -> str: ...
    @CurrencyDecimalSeparator.setter
    def CurrencyDecimalSeparator(self, value: str) -> str: ...
    @property
    def CurrencyGroupSeparator(self) -> str: ...
    @CurrencyGroupSeparator.setter
    def CurrencyGroupSeparator(self, value: str) -> str: ...
    @property
    def CurrencyGroupSizes(self) -> Array_1[int]: ...
    @CurrencyGroupSizes.setter
    def CurrencyGroupSizes(self, value: Array_1[int]) -> Array_1[int]: ...
    @property
    def CurrencyNegativePattern(self) -> int: ...
    @CurrencyNegativePattern.setter
    def CurrencyNegativePattern(self, value: int) -> int: ...
    @property
    def CurrencyPositivePattern(self) -> int: ...
    @CurrencyPositivePattern.setter
    def CurrencyPositivePattern(self, value: int) -> int: ...
    @property
    def CurrencySymbol(self) -> str: ...
    @CurrencySymbol.setter
    def CurrencySymbol(self, value: str) -> str: ...
    @classmethod
    @property
    def CurrentInfo(cls) -> NumberFormatInfo: ...
    @property
    def DigitSubstitution(self) -> DigitShapes: ...
    @DigitSubstitution.setter
    def DigitSubstitution(self, value: DigitShapes) -> DigitShapes: ...
    @classmethod
    @property
    def InvariantInfo(cls) -> NumberFormatInfo: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def NaNSymbol(self) -> str: ...
    @NaNSymbol.setter
    def NaNSymbol(self, value: str) -> str: ...
    @property
    def NativeDigits(self) -> Array_1[str]: ...
    @NativeDigits.setter
    def NativeDigits(self, value: Array_1[str]) -> Array_1[str]: ...
    @property
    def NegativeInfinitySymbol(self) -> str: ...
    @NegativeInfinitySymbol.setter
    def NegativeInfinitySymbol(self, value: str) -> str: ...
    @property
    def NegativeSign(self) -> str: ...
    @NegativeSign.setter
    def NegativeSign(self, value: str) -> str: ...
    @property
    def NumberDecimalDigits(self) -> int: ...
    @NumberDecimalDigits.setter
    def NumberDecimalDigits(self, value: int) -> int: ...
    @property
    def NumberDecimalSeparator(self) -> str: ...
    @NumberDecimalSeparator.setter
    def NumberDecimalSeparator(self, value: str) -> str: ...
    @property
    def NumberGroupSeparator(self) -> str: ...
    @NumberGroupSeparator.setter
    def NumberGroupSeparator(self, value: str) -> str: ...
    @property
    def NumberGroupSizes(self) -> Array_1[int]: ...
    @NumberGroupSizes.setter
    def NumberGroupSizes(self, value: Array_1[int]) -> Array_1[int]: ...
    @property
    def NumberNegativePattern(self) -> int: ...
    @NumberNegativePattern.setter
    def NumberNegativePattern(self, value: int) -> int: ...
    @property
    def PercentDecimalDigits(self) -> int: ...
    @PercentDecimalDigits.setter
    def PercentDecimalDigits(self, value: int) -> int: ...
    @property
    def PercentDecimalSeparator(self) -> str: ...
    @PercentDecimalSeparator.setter
    def PercentDecimalSeparator(self, value: str) -> str: ...
    @property
    def PercentGroupSeparator(self) -> str: ...
    @PercentGroupSeparator.setter
    def PercentGroupSeparator(self, value: str) -> str: ...
    @property
    def PercentGroupSizes(self) -> Array_1[int]: ...
    @PercentGroupSizes.setter
    def PercentGroupSizes(self, value: Array_1[int]) -> Array_1[int]: ...
    @property
    def PercentNegativePattern(self) -> int: ...
    @PercentNegativePattern.setter
    def PercentNegativePattern(self, value: int) -> int: ...
    @property
    def PercentPositivePattern(self) -> int: ...
    @PercentPositivePattern.setter
    def PercentPositivePattern(self, value: int) -> int: ...
    @property
    def PercentSymbol(self) -> str: ...
    @PercentSymbol.setter
    def PercentSymbol(self, value: str) -> str: ...
    @property
    def PerMilleSymbol(self) -> str: ...
    @PerMilleSymbol.setter
    def PerMilleSymbol(self, value: str) -> str: ...
    @property
    def PositiveInfinitySymbol(self) -> str: ...
    @PositiveInfinitySymbol.setter
    def PositiveInfinitySymbol(self, value: str) -> str: ...
    @property
    def PositiveSign(self) -> str: ...
    @PositiveSign.setter
    def PositiveSign(self, value: str) -> str: ...
    def Clone(self) -> typing.Any: ...
    def GetFormat(self, formatType: typing.Type[typing.Any]) -> typing.Any: ...
    @staticmethod
    def GetInstance(formatProvider: IFormatProvider) -> NumberFormatInfo: ...
    @staticmethod
    def ReadOnly(nfi: NumberFormatInfo) -> NumberFormatInfo: ...


class NumberStyles(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : NumberStyles # 0
    AllowLeadingWhite : NumberStyles # 1
    AllowTrailingWhite : NumberStyles # 2
    AllowLeadingSign : NumberStyles # 4
    Integer : NumberStyles # 7
    AllowTrailingSign : NumberStyles # 8
    AllowParentheses : NumberStyles # 16
    AllowDecimalPoint : NumberStyles # 32
    AllowThousands : NumberStyles # 64
    Number : NumberStyles # 111
    AllowExponent : NumberStyles # 128
    Float : NumberStyles # 167
    AllowCurrencySymbol : NumberStyles # 256
    Currency : NumberStyles # 383
    Any : NumberStyles # 511
    AllowHexSpecifier : NumberStyles # 512
    HexNumber : NumberStyles # 515


class PersianCalendar(Calendar):
    def __init__(self) -> None: ...
    PersianEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class RegionInfo:
    @typing.overload
    def __init__(self, culture: int) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @property
    def CurrencyEnglishName(self) -> str: ...
    @property
    def CurrencyNativeName(self) -> str: ...
    @property
    def CurrencySymbol(self) -> str: ...
    @classmethod
    @property
    def CurrentRegion(cls) -> RegionInfo: ...
    @property
    def DisplayName(self) -> str: ...
    @property
    def EnglishName(self) -> str: ...
    @property
    def GeoId(self) -> int: ...
    @property
    def IsMetric(self) -> bool: ...
    @property
    def ISOCurrencySymbol(self) -> str: ...
    @property
    def Name(self) -> str: ...
    @property
    def NativeName(self) -> str: ...
    @property
    def ThreeLetterISORegionName(self) -> str: ...
    @property
    def ThreeLetterWindowsRegionName(self) -> str: ...
    @property
    def TwoLetterISORegionName(self) -> str: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def ToString(self) -> str: ...


class SortKey:
    @property
    def KeyData(self) -> Array_1[int]: ...
    @property
    def OriginalString(self) -> str: ...
    @staticmethod
    def Compare(sortkey1: SortKey, sortkey2: SortKey) -> int: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    def ToString(self) -> str: ...


class SortVersion(IEquatable_1[SortVersion]):
    def __init__(self, fullVersion: int, sortId: Guid) -> None: ...
    @property
    def FullVersion(self) -> int: ...
    @property
    def SortId(self) -> Guid: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: SortVersion, right: SortVersion) -> bool: ...
    def __ne__(self, left: SortVersion, right: SortVersion) -> bool: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: SortVersion) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class StringInfo:
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, value: str) -> None: ...
    @property
    def LengthInTextElements(self) -> int: ...
    @property
    def String(self) -> str: ...
    @String.setter
    def String(self, value: str) -> str: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def ParseCombiningCharacters(str: str) -> Array_1[int]: ...
    # Skipped GetNextTextElement due to it being static, abstract and generic.

    GetNextTextElement : GetNextTextElement_MethodGroup
    class GetNextTextElement_MethodGroup:
        @typing.overload
        def __call__(self, str: str) -> str:...
        @typing.overload
        def __call__(self, str: str, index: int) -> str:...

    # Skipped GetNextTextElementLength due to it being static, abstract and generic.

    GetNextTextElementLength : GetNextTextElementLength_MethodGroup
    class GetNextTextElementLength_MethodGroup:
        @typing.overload
        def __call__(self, str: ReadOnlySpan_1[str]) -> int:...
        @typing.overload
        def __call__(self, str: str) -> int:...
        @typing.overload
        def __call__(self, str: str, index: int) -> int:...

    # Skipped GetTextElementEnumerator due to it being static, abstract and generic.

    GetTextElementEnumerator : GetTextElementEnumerator_MethodGroup
    class GetTextElementEnumerator_MethodGroup:
        @typing.overload
        def __call__(self, str: str) -> TextElementEnumerator:...
        @typing.overload
        def __call__(self, str: str, index: int) -> TextElementEnumerator:...

    # Skipped SubstringByTextElements due to it being static, abstract and generic.

    SubstringByTextElements : SubstringByTextElements_MethodGroup
    class SubstringByTextElements_MethodGroup:
        @typing.overload
        def __call__(self, startingTextElement: int) -> str:...
        @typing.overload
        def __call__(self, startingTextElement: int, lengthInTextElements: int) -> str:...



class TaiwanCalendar(Calendar):
    def __init__(self) -> None: ...
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetWeekOfYear(self, time: DateTime, rule: CalendarWeekRule, firstDayOfWeek: DayOfWeek) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class TaiwanLunisolarCalendar(EastAsianLunisolarCalendar):
    def __init__(self) -> None: ...
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...


class TextElementEnumerator(IEnumerator):
    @property
    def Current(self) -> typing.Any: ...
    @property
    def ElementIndex(self) -> int: ...
    def GetTextElement(self) -> str: ...
    def MoveNext(self) -> bool: ...
    def Reset(self) -> None: ...


class TextInfo(IDeserializationCallback, ICloneable):
    @property
    def ANSICodePage(self) -> int: ...
    @property
    def CultureName(self) -> str: ...
    @property
    def EBCDICCodePage(self) -> int: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsRightToLeft(self) -> bool: ...
    @property
    def LCID(self) -> int: ...
    @property
    def ListSeparator(self) -> str: ...
    @ListSeparator.setter
    def ListSeparator(self, value: str) -> str: ...
    @property
    def MacCodePage(self) -> int: ...
    @property
    def OEMCodePage(self) -> int: ...
    def Clone(self) -> typing.Any: ...
    def Equals(self, obj: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def ReadOnly(textInfo: TextInfo) -> TextInfo: ...
    def ToString(self) -> str: ...
    def ToTitleCase(self, str: str) -> str: ...
    # Skipped ToLower due to it being static, abstract and generic.

    ToLower : ToLower_MethodGroup
    class ToLower_MethodGroup:
        def __call__(self, c: str) -> str:...
        # Method ToLower(str : String) was skipped since it collides with above method

    # Skipped ToUpper due to it being static, abstract and generic.

    ToUpper : ToUpper_MethodGroup
    class ToUpper_MethodGroup:
        def __call__(self, c: str) -> str:...
        # Method ToUpper(str : String) was skipped since it collides with above method



class ThaiBuddhistCalendar(Calendar):
    def __init__(self) -> None: ...
    ThaiBuddhistEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetWeekOfYear(self, time: DateTime, rule: CalendarWeekRule, firstDayOfWeek: DayOfWeek) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class TimeSpanStyles(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : TimeSpanStyles # 0
    AssumeNegative : TimeSpanStyles # 1


class UmAlQuraCalendar(Calendar):
    def __init__(self) -> None: ...
    UmAlQuraEra : int
    @property
    def AlgorithmType(self) -> CalendarAlgorithmType: ...
    @property
    def Eras(self) -> Array_1[int]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def MaxSupportedDateTime(self) -> DateTime: ...
    @property
    def MinSupportedDateTime(self) -> DateTime: ...
    @property
    def TwoDigitYearMax(self) -> int: ...
    @TwoDigitYearMax.setter
    def TwoDigitYearMax(self, value: int) -> int: ...
    def AddMonths(self, time: DateTime, months: int) -> DateTime: ...
    def AddYears(self, time: DateTime, years: int) -> DateTime: ...
    def GetDayOfMonth(self, time: DateTime) -> int: ...
    def GetDayOfWeek(self, time: DateTime) -> DayOfWeek: ...
    def GetDayOfYear(self, time: DateTime) -> int: ...
    def GetDaysInMonth(self, year: int, month: int, era: int) -> int: ...
    def GetDaysInYear(self, year: int, era: int) -> int: ...
    def GetEra(self, time: DateTime) -> int: ...
    def GetLeapMonth(self, year: int, era: int) -> int: ...
    def GetMonth(self, time: DateTime) -> int: ...
    def GetMonthsInYear(self, year: int, era: int) -> int: ...
    def GetYear(self, time: DateTime) -> int: ...
    def IsLeapDay(self, year: int, month: int, day: int, era: int) -> bool: ...
    def IsLeapMonth(self, year: int, month: int, era: int) -> bool: ...
    def IsLeapYear(self, year: int, era: int) -> bool: ...
    def ToDateTime(self, year: int, month: int, day: int, hour: int, minute: int, second: int, millisecond: int, era: int) -> DateTime: ...
    def ToFourDigitYear(self, year: int) -> int: ...


class UnicodeCategory(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    UppercaseLetter : UnicodeCategory # 0
    LowercaseLetter : UnicodeCategory # 1
    TitlecaseLetter : UnicodeCategory # 2
    ModifierLetter : UnicodeCategory # 3
    OtherLetter : UnicodeCategory # 4
    NonSpacingMark : UnicodeCategory # 5
    SpacingCombiningMark : UnicodeCategory # 6
    EnclosingMark : UnicodeCategory # 7
    DecimalDigitNumber : UnicodeCategory # 8
    LetterNumber : UnicodeCategory # 9
    OtherNumber : UnicodeCategory # 10
    SpaceSeparator : UnicodeCategory # 11
    LineSeparator : UnicodeCategory # 12
    ParagraphSeparator : UnicodeCategory # 13
    Control : UnicodeCategory # 14
    Format : UnicodeCategory # 15
    Surrogate : UnicodeCategory # 16
    PrivateUse : UnicodeCategory # 17
    ConnectorPunctuation : UnicodeCategory # 18
    DashPunctuation : UnicodeCategory # 19
    OpenPunctuation : UnicodeCategory # 20
    ClosePunctuation : UnicodeCategory # 21
    InitialQuotePunctuation : UnicodeCategory # 22
    FinalQuotePunctuation : UnicodeCategory # 23
    OtherPunctuation : UnicodeCategory # 24
    MathSymbol : UnicodeCategory # 25
    CurrencySymbol : UnicodeCategory # 26
    ModifierSymbol : UnicodeCategory # 27
    OtherSymbol : UnicodeCategory # 28
    OtherNotAssigned : UnicodeCategory # 29

