import typing, clr, abc
from System.IO import FileAttributes, FileSystemInfo, EnumerationOptions
from System import DateTimeOffset, ReadOnlySpan_1, MulticastDelegate, IAsyncResult, AsyncCallback
from System.Collections.Generic import IEnumerable_1, IEnumerator_1
from System.Reflection import MethodInfo
from System.Runtime.ConstrainedExecution import CriticalFinalizerObject

class FileSystemEntry:
    @property
    def Attributes(self) -> FileAttributes: ...
    @property
    def CreationTimeUtc(self) -> DateTimeOffset: ...
    @property
    def Directory(self) -> ReadOnlySpan_1[str]: ...
    @Directory.setter
    def Directory(self, value: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]: ...
    @property
    def FileName(self) -> ReadOnlySpan_1[str]: ...
    @property
    def IsDirectory(self) -> bool: ...
    @property
    def IsHidden(self) -> bool: ...
    @property
    def LastAccessTimeUtc(self) -> DateTimeOffset: ...
    @property
    def LastWriteTimeUtc(self) -> DateTimeOffset: ...
    @property
    def Length(self) -> int: ...
    @property
    def OriginalRootDirectory(self) -> ReadOnlySpan_1[str]: ...
    @OriginalRootDirectory.setter
    def OriginalRootDirectory(self, value: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]: ...
    @property
    def RootDirectory(self) -> ReadOnlySpan_1[str]: ...
    @RootDirectory.setter
    def RootDirectory(self, value: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]: ...
    def ToFileSystemInfo(self) -> FileSystemInfo: ...
    def ToFullPath(self) -> str: ...
    def ToSpecifiedFullPath(self) -> str: ...


class FileSystemEnumerable_GenericClasses(abc.ABCMeta):
    Generic_FileSystemEnumerable_GenericClasses_FileSystemEnumerable_1_TResult = typing.TypeVar('Generic_FileSystemEnumerable_GenericClasses_FileSystemEnumerable_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_FileSystemEnumerable_GenericClasses_FileSystemEnumerable_1_TResult]) -> typing.Type[FileSystemEnumerable_1[Generic_FileSystemEnumerable_GenericClasses_FileSystemEnumerable_1_TResult]]: ...

FileSystemEnumerable : FileSystemEnumerable_GenericClasses

FileSystemEnumerable_1_TResult = typing.TypeVar('FileSystemEnumerable_1_TResult')
class FileSystemEnumerable_1(typing.Generic[FileSystemEnumerable_1_TResult], IEnumerable_1[FileSystemEnumerable_1_TResult]):
    def __init__(self, directory: str, transform: FileSystemEnumerable_1.FindTransform_1[FileSystemEnumerable_1_TResult], options: EnumerationOptions = ...) -> None: ...
    @property
    def ShouldIncludePredicate(self) -> FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]: ...
    @ShouldIncludePredicate.setter
    def ShouldIncludePredicate(self, value: FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]) -> FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]: ...
    @property
    def ShouldRecursePredicate(self) -> FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]: ...
    @ShouldRecursePredicate.setter
    def ShouldRecursePredicate(self, value: FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]) -> FileSystemEnumerable_1.FindPredicate_1[FileSystemEnumerable_1_TResult]: ...
    def GetEnumerator(self) -> IEnumerator_1[FileSystemEnumerable_1_TResult]: ...

    FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult = typing.TypeVar('FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult')
    class FindPredicate_GenericClasses(typing.Generic[FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult], abc.ABCMeta):
        FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult = FileSystemEnumerable_1.FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult
        def __call__(self) -> FileSystemEnumerable_1.FindPredicate_1[FindPredicate_GenericClasses_FileSystemEnumerable_1_TResult]: ...

    FindPredicate : FindPredicate_GenericClasses[FileSystemEnumerable_1_TResult]

    FindPredicate_1_TResult = typing.TypeVar('FindPredicate_1_TResult')
    class FindPredicate_1(typing.Generic[FindPredicate_1_TResult], MulticastDelegate):
        FindPredicate_1_TResult = FileSystemEnumerable_1.FindPredicate_1_TResult
        def __init__(self, object: typing.Any, method: int) -> None: ...
        @property
        def Method(self) -> MethodInfo: ...
        @property
        def Target(self) -> typing.Any: ...
        def BeginInvoke(self, entry: clr.Reference[FileSystemEntry], callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
        def EndInvoke(self, entry: clr.Reference[FileSystemEntry], result: IAsyncResult) -> bool: ...
        def Invoke(self, entry: clr.Reference[FileSystemEntry]) -> bool: ...


    FindTransform_GenericClasses_FileSystemEnumerable_1_TResult = typing.TypeVar('FindTransform_GenericClasses_FileSystemEnumerable_1_TResult')
    class FindTransform_GenericClasses(typing.Generic[FindTransform_GenericClasses_FileSystemEnumerable_1_TResult], abc.ABCMeta):
        FindTransform_GenericClasses_FileSystemEnumerable_1_TResult = FileSystemEnumerable_1.FindTransform_GenericClasses_FileSystemEnumerable_1_TResult
        def __call__(self) -> FileSystemEnumerable_1.FindTransform_1[FindTransform_GenericClasses_FileSystemEnumerable_1_TResult]: ...

    FindTransform : FindTransform_GenericClasses[FileSystemEnumerable_1_TResult]

    FindTransform_1_TResult = typing.TypeVar('FindTransform_1_TResult')
    class FindTransform_1(typing.Generic[FindTransform_1_TResult], MulticastDelegate):
        FindTransform_1_TResult = FileSystemEnumerable_1.FindTransform_1_TResult
        def __init__(self, object: typing.Any, method: int) -> None: ...
        @property
        def Method(self) -> MethodInfo: ...
        @property
        def Target(self) -> typing.Any: ...
        def BeginInvoke(self, entry: clr.Reference[FileSystemEntry], callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
        def EndInvoke(self, entry: clr.Reference[FileSystemEntry], result: IAsyncResult) -> FindTransform_1_TResult: ...
        def Invoke(self, entry: clr.Reference[FileSystemEntry]) -> FindTransform_1_TResult: ...



class FileSystemEnumerator_GenericClasses(abc.ABCMeta):
    Generic_FileSystemEnumerator_GenericClasses_FileSystemEnumerator_1_TResult = typing.TypeVar('Generic_FileSystemEnumerator_GenericClasses_FileSystemEnumerator_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_FileSystemEnumerator_GenericClasses_FileSystemEnumerator_1_TResult]) -> typing.Type[FileSystemEnumerator_1[Generic_FileSystemEnumerator_GenericClasses_FileSystemEnumerator_1_TResult]]: ...

FileSystemEnumerator : FileSystemEnumerator_GenericClasses

FileSystemEnumerator_1_TResult = typing.TypeVar('FileSystemEnumerator_1_TResult')
class FileSystemEnumerator_1(typing.Generic[FileSystemEnumerator_1_TResult], CriticalFinalizerObject, IEnumerator_1[FileSystemEnumerator_1_TResult]):
    def __init__(self, directory: str, options: EnumerationOptions = ...) -> None: ...
    @property
    def Current(self) -> FileSystemEnumerator_1_TResult: ...
    def Dispose(self) -> None: ...
    def MoveNext(self) -> bool: ...
    def Reset(self) -> None: ...


class FileSystemName(abc.ABC):
    @staticmethod
    def MatchesSimpleExpression(expression: ReadOnlySpan_1[str], name: ReadOnlySpan_1[str], ignoreCase: bool = ...) -> bool: ...
    @staticmethod
    def MatchesWin32Expression(expression: ReadOnlySpan_1[str], name: ReadOnlySpan_1[str], ignoreCase: bool = ...) -> bool: ...
    @staticmethod
    def TranslateWin32Expression(expression: str) -> str: ...

