import typing, clr, abc
from TransformsAI.Animo.Objects import Item, Character, TypeIds, ItemTypes
from TransformsAI.Animo.Numerics import Vector3Int
from TransformsAI.Animo.Grid import VoxelGrid, GridObject, GridTransform
from System import Guid, Func_2, IEquatable_1, Array_1
from TransformsAI.Animo.Simulation.Intents import CharacterIntent, Intent
from System.Collections.Generic import List_1, IEnumerable_1, HashSet_1, Dictionary_2
from TransformsAI.Animo.Objects.Resolutions import BounceResolution
from TransformsAI.Animo.Learning.Rewards import InteractionHolder, IntrinsicCategories, Interaction

class AppleInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    PlantOn : AppleInteractions # 0
    PlantBeside : AppleInteractions # 1
    Destroy : AppleInteractions # 2


class AppleItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    WasPlanted : bool
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class AppleTreeInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Shake : AppleTreeInteractions # 0
    Destroy : AppleTreeInteractions # 1


class AppleTreeItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    MaxApplesToSpawnOnDestroy : int
    MinApplesToSpawnOnDestroy : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def Destroy(self) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def OnSlashed(self, source: GridObject, causer: Character) -> bool: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class AxeInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    ChopTarget : AxeInteractions # 0
    SwingMiss : AxeInteractions # 1
    Destroy : AxeInteractions # 2


class AxeItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def HitCharacterId(self) -> typing.Optional[int]: ...
    @HitCharacterId.setter
    def HitCharacterId(self, value: typing.Optional[int]) -> typing.Optional[int]: ...
    @property
    def HitObjectType(self) -> typing.Type[typing.Any]: ...
    @HitObjectType.setter
    def HitObjectType(self, value: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class BallHit:
    def __init__(self, ball: BallItem) -> None: ...
    def PrepareHit(self, intent: Intent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject]) -> bool: ...


class BallInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Kick : BallInteractions # 0
    Throw : BallInteractions # 1
    Catch : BallInteractions # 2
    HitTarget : BallInteractions # 3
    LandOn : BallInteractions # 4
    BounceOn : BallInteractions # 5
    Destroy : BallInteractions # 6


class BallItem(Item):
    def __init__(self) -> None: ...
    BounceRange : int
    FireDamage : int
    Info : ObjectInfo
    KickRange : int
    ThrowRange : int
    WasLaunched : bool
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BounceResolution(self) -> BounceResolution: ...
    @BounceResolution.setter
    def BounceResolution(self, value: BounceResolution) -> BounceResolution: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Hit(self) -> BallHit: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsCarryingFire(self) -> bool: ...
    @IsCarryingFire.setter
    def IsCarryingFire(self, value: bool) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Physics(self) -> BallItem.BallPhysics: ...
    @Physics.setter
    def Physics(self, value: BallItem.BallPhysics) -> BallItem.BallPhysics: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Result(self) -> BallItem.BallResult: ...
    @Result.setter
    def Result(self, value: BallItem.BallResult) -> BallItem.BallResult: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ApplyFire(self, position: Vector3Int, source: Character) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def PrepareBounceLanding(self, physics: BallItem.BallPhysics, aimDirection: Vector3Int, startPosition: Vector3Int, willLand: Func_2[Vector3Int, bool]) -> None: ...
    def PrepareFire(self, physics: BallItem.BallPhysics, position: Vector3Int) -> None: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def TryNotifyHit(self, physics: BallItem.BallPhysics, source: Character) -> None: ...

    class BallPhysics:
        def __init__(self) -> None: ...
        AirDirection : typing.Optional[Vector3Int]
        AirPosition : typing.Optional[Vector3Int]
        BouncePosition : typing.Optional[Vector3Int]
        FirePositions : List_1[Vector3Int]
        LandPosition : typing.Optional[Vector3Int]
        PushDirection : typing.Optional[Vector3Int]
        PushPosition : typing.Optional[Vector3Int]
        StartPosition : Vector3Int
        WasOnGrid : bool
        WentOutOfBounds : bool


    class BallResult(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        None_ : BallItem.BallResult # 0
        BounceBack : BallItem.BallResult # 1
        BounceFirst : BallItem.BallResult # 2
        BounceRepeat : BallItem.BallResult # 3
        Land : BallItem.BallResult # 4
        Pushed : BallItem.BallResult # 5



class BatInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    HitTarget : BatInteractions # 0
    HitTargetOnto : BatInteractions # 1
    SwingMiss : BatInteractions # 2
    Destroy : BatInteractions # 3


class BatItem(Item):
    def __init__(self) -> None: ...
    HitCharacterId : typing.Optional[int]
    HitObjectType : typing.Type[typing.Any]
    Info : ObjectInfo
    NonPushableItems : HashSet_1[typing.Type[typing.Any]]
    StunDuration : int
    UserDirection : Vector3Int
    UserPosition : typing.Optional[Vector3Int]
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class BlockMakerInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    MakeBlock : BlockMakerInteractions # 0
    MakeBlockBeside : BlockMakerInteractions # 1
    MakeBlockUnder : BlockMakerInteractions # 2
    MakeBlockAtHeight : BlockMakerInteractions # 3
    FailMakeBlock : BlockMakerInteractions # 4
    Destroy : BlockMakerInteractions # 5


class BlockMakerItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class CrystalInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Collect : CrystalInteractions # 0


class CrystalItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    WasCollected : bool
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...


class DestructibleItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...


class DestructibleItemInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Destroy : DestructibleItemInteractions # 0


class FakeAgentInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Hug : FakeAgentInteractions # 0
    Destroy : FakeAgentInteractions # 1


class FakeAgentItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class FireGunInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    SprayTarget : FireGunInteractions # 0
    Destroy : FireGunInteractions # 1


class FireGunItem(Item):
    def __init__(self) -> None: ...
    EndPosition : typing.Optional[Vector3Int]
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class FireInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Extinguish : FireInteractions # 0


class FireItem(Item):
    def __init__(self) -> None: ...
    Damage : int
    Info : ObjectInfo
    Intensity : int
    ItemBurnInterval : int
    ItemBurnTimer : int
    MaximumIntensity : int
    SpreadInterval : int
    SpreadTimer : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def OnSlashed(self, source: GridObject, causer: Character) -> bool: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...


class FlowerInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Gift : FlowerInteractions # 0
    Wilt : FlowerInteractions # 1
    Destroy : FlowerInteractions # 2


class FlowerItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    IsWilted : bool
    Result : FlowerItem.Results
    WasStoodUpon : bool
    WiltDelay : int
    WiltTimer : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...

    class Results(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        None_ : FlowerItem.Results # 0
        Spawn : FlowerItem.Results # 1
        Wilt : FlowerItem.Results # 2
        Gift : FlowerItem.Results # 3



class FlowerSeedInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    PlantOn : FlowerSeedInteractions # 0
    PlantBeside : FlowerSeedInteractions # 1
    Destroy : FlowerSeedInteractions # 2


class FlowerSeedItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    WasPlanted : bool
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class FluteInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Play : FluteInteractions # 0
    Hypnotize : FluteInteractions # 1
    Destroy : FluteInteractions # 2


class FluteItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    RemainingDuration : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def CanMoveWhileUsing(self, position: Vector3Int, moveTarget: Vector3Int) -> bool: ...
    def CanTurnWhileUsing(self, rotationOffset: Vector3Int, rotationTarget: Vector3Int) -> bool: ...
    def ContinueUsing(self, toRecalculate: List_1[GridObject]) -> None: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def TryStopUsing(self, willForce: bool) -> bool: ...


class LargeSnowballInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    PushTowards : LargeSnowballInteractions # 0
    PushAway : LargeSnowballInteractions # 1
    PushOnto : LargeSnowballInteractions # 2
    Destroy : LargeSnowballInteractions # 3


class LargeSnowballItem(Item):
    def __init__(self) -> None: ...
    DidPushFail : bool
    Info : ObjectInfo
    OldPosition : Vector3Int
    TargetPosition : Vector3Int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class NPCObstacleItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...


class ObjectInfo(IEquatable_1[ObjectInfo]):
    def __init__(self) -> None: ...
    @property
    def BasePriority(self) -> int: ...
    @property
    def CanBurn(self) -> bool: ...
    @CanBurn.setter
    def CanBurn(self, value: bool) -> bool: ...
    @property
    def CreatesItems(self) -> Array_1[TypeIds]: ...
    @CreatesItems.setter
    def CreatesItems(self, value: Array_1[TypeIds]) -> Array_1[TypeIds]: ...
    @property
    def Interactions(self) -> InteractionHolder: ...
    @Interactions.setter
    def Interactions(self, value: InteractionHolder) -> InteractionHolder: ...
    @property
    def IsDestroyedInDeepWater(self) -> bool: ...
    @IsDestroyedInDeepWater.setter
    def IsDestroyedInDeepWater(self, value: bool) -> bool: ...
    @property
    def IsDestructible(self) -> bool: ...
    @IsDestructible.setter
    def IsDestructible(self, value: bool) -> bool: ...
    @property
    def IsDroppedWhenUsed(self) -> bool: ...
    @IsDroppedWhenUsed.setter
    def IsDroppedWhenUsed(self, value: bool) -> bool: ...
    @property
    def IsGrabbable(self) -> bool: ...
    @IsGrabbable.setter
    def IsGrabbable(self, value: bool) -> bool: ...
    @property
    def IsLightweight(self) -> bool: ...
    @IsLightweight.setter
    def IsLightweight(self, value: bool) -> bool: ...
    @property
    def IsOccupier(self) -> bool: ...
    @IsOccupier.setter
    def IsOccupier(self, value: bool) -> bool: ...
    @property
    def IsUsableOnGrid(self) -> bool: ...
    @IsUsableOnGrid.setter
    def IsUsableOnGrid(self, value: bool) -> bool: ...
    @property
    def IsUsableWhileHeld(self) -> bool: ...
    @IsUsableWhileHeld.setter
    def IsUsableWhileHeld(self, value: bool) -> bool: ...
    @property
    def ItemType(self) -> ItemTypes: ...
    @ItemType.setter
    def ItemType(self, value: ItemTypes) -> ItemTypes: ...
    @property
    def MaximumBurnAmount(self) -> int: ...
    @MaximumBurnAmount.setter
    def MaximumBurnAmount(self, value: int) -> int: ...
    @property
    def TurnsInto(self) -> Array_1[TypeIds]: ...
    @TurnsInto.setter
    def TurnsInto(self, value: Array_1[TypeIds]) -> Array_1[TypeIds]: ...
    @property
    def Type(self) -> typing.Type[typing.Any]: ...
    @Type.setter
    def Type(self, value: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @TypeId.setter
    def TypeId(self, value: TypeIds) -> TypeIds: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: ObjectInfo, right: ObjectInfo) -> bool: ...
    def __ne__(self, left: ObjectInfo, right: ObjectInfo) -> bool: ...
    def ToString(self) -> str: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: ObjectInfo) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class ObjectInfos(abc.ABC):
    AllObjectInfos : Array_1[ObjectInfo]
    IntrinsicInteractions : Dictionary_2[IntrinsicCategories, InteractionHolder]
    @staticmethod
    def CreateInstance(typeId: TypeIds) -> GridObject: ...
    @staticmethod
    def ToType(typeId: typing.Optional[TypeIds]) -> typing.Type[typing.Any]: ...
    @staticmethod
    def ToTypeId(type: typing.Type[typing.Any]) -> TypeIds: ...
    # Skipped GetInfo due to it being static, abstract and generic.

    GetInfo : GetInfo_MethodGroup
    class GetInfo_MethodGroup:
        @typing.overload
        def __call__(self, typeId: TypeIds) -> ObjectInfo:...
        @typing.overload
        def __call__(self, typeId: typing.Optional[TypeIds]) -> ObjectInfo:...
        @typing.overload
        def __call__(self, type: typing.Type[typing.Any]) -> ObjectInfo:...

    # Skipped GetInteraction due to it being static, abstract and generic.

    GetInteraction : GetInteraction_MethodGroup
    class GetInteraction_MethodGroup:
        def __getitem__(self, t:typing.Type[GetInteraction_1_T1]) -> GetInteraction_1[GetInteraction_1_T1]: ...

        GetInteraction_1_T1 = typing.TypeVar('GetInteraction_1_T1')
        class GetInteraction_1(typing.Generic[GetInteraction_1_T1]):
            GetInteraction_1_T = ObjectInfos.GetInteraction_MethodGroup.GetInteraction_1_T1
            @typing.overload
            def __call__(self, typeId: TypeIds, key: GetInteraction_1_T) -> Interaction:...
            @typing.overload
            def __call__(self, typeId: typing.Optional[TypeIds], key: GetInteraction_1_T) -> Interaction:...




class ObstacleItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...


class PlantedFlowerSeedInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Wither : PlantedFlowerSeedInteractions # 0
    MakeGrow : PlantedFlowerSeedInteractions # 1
    Destroy : PlantedFlowerSeedInteractions # 2


class PlantedFlowerSeedItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def Grow(self) -> None: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...


class ShovelInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Destroy : ShovelInteractions # 0


class ShovelItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DestroyedBlockPosition(self) -> typing.Optional[Vector3Int]: ...
    @DestroyedBlockPosition.setter
    def DestroyedBlockPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def DidDestroyBlock(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class SmallSnowballInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    HitTarget : SmallSnowballInteractions # 0
    Throw : SmallSnowballInteractions # 1
    Destroy : SmallSnowballInteractions # 2


class SmallSnowballItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    Range : int
    StunDuration : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def EndPosition(self) -> Vector3Int: ...
    @EndPosition.setter
    def EndPosition(self, value: Vector3Int) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Result(self) -> SmallSnowballItem.Results: ...
    @Result.setter
    def Result(self, value: SmallSnowballItem.Results) -> SmallSnowballItem.Results: ...
    @property
    def StartPosition(self) -> Vector3Int: ...
    @StartPosition.setter
    def StartPosition(self, value: Vector3Int) -> Vector3Int: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteLaunch(self, intent: Intent) -> GridObject: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def LaunchIntent(self, source: GridObject) -> Intent: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...

    class Results(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        None_ : SmallSnowballItem.Results # 0
        OffGrid : SmallSnowballItem.Results # 1
        Land : SmallSnowballItem.Results # 2
        Hit : SmallSnowballItem.Results # 3



class SnowballHeapInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    GetSnowball : SnowballHeapInteractions # 0
    Destroy : SnowballHeapInteractions # 1


class SnowballHeapItem(Item):
    def __init__(self) -> None: ...
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...


class SproutInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    MakeGrow : SproutInteractions # 0
    Destroy : SproutInteractions # 1


class SproutItem(Item):
    def __init__(self) -> None: ...
    GrowthThreshold : int
    GrowthTimer : int
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...


class TreeInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    MakeGrow : TreeInteractions # 0
    Destroy : TreeInteractions # 1


class TreeItem(Item):
    def __init__(self) -> None: ...
    GrowthThreshold : int
    GrowthTimer : int
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...


class WaterGunInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    SprayTarget : WaterGunInteractions # 0
    Destroy : WaterGunInteractions # 1


class WaterGunItem(Item):
    def __init__(self) -> None: ...
    EndPosition : typing.Optional[Vector3Int]
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...

