import typing
from TransformsAI.Animo.Objects import Character, Item, TypeIds
from TransformsAI.Animo.Grid import GroundMaterials, GridObject
from TransformsAI.Animo.Numerics import Vector3Int

class EventIds(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventIds # 0
    SteppedOnto : EventIds # 1
    Collected : EventIds # 2
    DestroyedObject : EventIds # 3
    DestroyedBlock : EventIds # 4
    Created : EventIds # 5
    CreatedBlock : EventIds # 6
    Used : EventIds # 7
    FellInDeepWater : EventIds # 8
    StunnedOther : EventIds # 9
    StayedOnSameBlock : EventIds # 10
    MovedSelf : EventIds # 11
    TurnedSelf : EventIds # 12
    MovedObject : EventIds # 13
    Planted : EventIds # 14
    Ignited : EventIds # 15
    HitWithBat : EventIds # 16
    SprayedWaterOn : EventIds # 17
    Ate : EventIds # 18
    Kicked : EventIds # 19
    Threw : EventIds # 20
    HitWithProjectile : EventIds # 21
    Hurt : EventIds # 22
    Silenced : EventIds # 23
    Fed : EventIds # 24
    TurnPassed : EventIds # 25
    PushFailed : EventIds # 26
    HitWithSnowball : EventIds # 27
    SteppedOff : EventIds # 28
    MovedSelfFail : EventIds # 29
    PickedUp : EventIds # 30
    Dropped : EventIds # 31
    PickupFailed : EventIds # 32
    DropFailed : EventIds # 33
    UseFailed : EventIds # 34
    StateChanged : EventIds # 35
    Landed : EventIds # 36
    BouncedOn : EventIds # 37
    FailMakeBlock : EventIds # 38
    MadeGrow : EventIds # 39
    Wilted : EventIds # 40
    CausedStateChange : EventIds # 41


class SimulationEvent:
    @property
    def Causer(self) -> Character: ...
    @Causer.setter
    def Causer(self, value: Character) -> Character: ...
    @property
    def DidTargetBlock(self) -> bool: ...
    @DidTargetBlock.setter
    def DidTargetBlock(self, value: bool) -> bool: ...
    @property
    def EventId(self) -> EventIds: ...
    @EventId.setter
    def EventId(self, value: EventIds) -> EventIds: ...
    @property
    def GroundTarget(self) -> GroundMaterials: ...
    @GroundTarget.setter
    def GroundTarget(self, value: GroundMaterials) -> GroundMaterials: ...
    @property
    def Source(self) -> Item: ...
    @Source.setter
    def Source(self, value: Item) -> Item: ...
    @property
    def Target(self) -> GridObject: ...
    @Target.setter
    def Target(self, value: GridObject) -> GridObject: ...
    @property
    def TargetTypeId(self) -> TypeIds: ...
    @property
    def VectorData(self) -> Vector3Int: ...
    @VectorData.setter
    def VectorData(self, value: Vector3Int) -> Vector3Int: ...
    def Is(self, eventId: EventIds) -> bool: ...
    @staticmethod
    def ReportAte(character: Character, target: Item) -> None: ...
    @staticmethod
    def ReportBouncedOn(character: Character, source: Item, target: GridObject) -> None: ...
    @staticmethod
    def ReportCausedStateChange(character: Character, other: Character) -> None: ...
    @staticmethod
    def ReportCollected(character: Character, target: Item) -> None: ...
    @staticmethod
    def ReportCreateBlockFailed(character: Character) -> None: ...
    @staticmethod
    def ReportCreatedBlock(character: Character, blockPosition: Vector3Int, materialBeforeCreation: GroundMaterials) -> None: ...
    @staticmethod
    def ReportCreatedObject(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportDestroyedBlock(character: Character, blockPosition: Vector3Int) -> None: ...
    @staticmethod
    def ReportDestroyedObject(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportDropFailed(character: Character) -> None: ...
    @staticmethod
    def ReportDropped(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportFed(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportFellInDeepWater(character: Character) -> None: ...
    @staticmethod
    def ReportHitWithBat(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportHitWithSnowball(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportHurt(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportIgnited(character: Character, target: Item) -> None: ...
    @staticmethod
    def ReportKicked(character: Character, source: Item) -> None: ...
    @staticmethod
    def ReportMadeGrow(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportMovedObject(character: Character, target: GridObject, oldPosition: Vector3Int) -> None: ...
    @staticmethod
    def ReportMovedSelf(character: Character, oldPosition: Vector3Int) -> None: ...
    @staticmethod
    def ReportPickedUp(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportPickupFailed(character: Character) -> None: ...
    @staticmethod
    def ReportPlanted(character: Character, target: Item, position: Vector3Int) -> None: ...
    @staticmethod
    def ReportPushFailed(character: Character, target: Item) -> None: ...
    @staticmethod
    def ReportSilenced(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportSprayedWaterOn(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportStateChanged(character: Character) -> None: ...
    @staticmethod
    def ReportStayedOnSameBlock(character: Character) -> None: ...
    @staticmethod
    def ReportStunnedOther(character: Character, target: GridObject) -> None: ...
    @staticmethod
    def ReportThrew(character: Character, source: Item) -> None: ...
    @staticmethod
    def ReportTurnedSelf(character: Character, oldDirection: Vector3Int) -> None: ...
    @staticmethod
    def ReportTurnPassed(character: Character) -> None: ...
    @staticmethod
    def ReportUseFailed(character: Character) -> None: ...
    # Skipped ReportHitWithProjectile due to it being static, abstract and generic.

    ReportHitWithProjectile : ReportHitWithProjectile_MethodGroup
    class ReportHitWithProjectile_MethodGroup:
        @typing.overload
        def __call__(self, character: Character, source: Item, blockPosition: Vector3Int) -> None:...
        @typing.overload
        def __call__(self, character: Character, source: Item, target: GridObject) -> None:...

    # Skipped ReportLanded due to it being static, abstract and generic.

    ReportLanded : ReportLanded_MethodGroup
    class ReportLanded_MethodGroup:
        @typing.overload
        def __call__(self, character: Character, source: Item, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, character: Character, source: Item, target: GridObject) -> None:...

    # Skipped ReportSteppedOff due to it being static, abstract and generic.

    ReportSteppedOff : ReportSteppedOff_MethodGroup
    class ReportSteppedOff_MethodGroup:
        @typing.overload
        def __call__(self, character: Character, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, character: Character, target: GridObject) -> None:...

    # Skipped ReportSteppedOnto due to it being static, abstract and generic.

    ReportSteppedOnto : ReportSteppedOnto_MethodGroup
    class ReportSteppedOnto_MethodGroup:
        @typing.overload
        def __call__(self, character: Character, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, character: Character, target: GridObject) -> None:...

    # Skipped ReportUsed due to it being static, abstract and generic.

    ReportUsed : ReportUsed_MethodGroup
    class ReportUsed_MethodGroup:
        @typing.overload
        def __call__(self, character: Character, source: Item, target: GridObject) -> None:...
        @typing.overload
        def __call__(self, character: Character, source: Item, vectorData: Vector3Int, didTargetBlock: bool) -> None:...


