# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'CloudProjectContainerRegistryPlanArgs',
    'CloudProjectContainerRegistryPlanFeatureArgs',
    'CloudProjectContainerRegistryPlanRegistryLimitArgs',
    'CloudProjectDatabaseEndpointArgs',
    'CloudProjectDatabaseNodeArgs',
    'CloudProjectKubeNodePoolTemplateArgs',
    'CloudProjectKubeNodePoolTemplateMetadataArgs',
    'CloudProjectKubeNodePoolTemplateSpecArgs',
    'CloudProjectKubePrivateNetworkConfigurationArgs',
    'CloudProjectNetworkPrivateRegionsAttributeArgs',
    'CloudProjectNetworkPrivateRegionsStatusArgs',
    'CloudProjectNetworkPrivateSubnetIpPoolArgs',
    'CloudProjectOrderArgs',
    'CloudProjectOrderDetailArgs',
    'CloudProjectPlanArgs',
    'CloudProjectPlanConfigurationArgs',
    'CloudProjectPlanOptionArgs',
    'CloudProjectPlanOptionConfigurationArgs',
    'CloudProjectUserRoleArgs',
    'DbaasLogsInputConfigurationArgs',
    'DbaasLogsInputConfigurationFlowggerArgs',
    'DbaasLogsInputConfigurationLogstashArgs',
    'DedicatedServiceInstallTaskDetailsArgs',
    'DomainZoneOrderArgs',
    'DomainZoneOrderDetailArgs',
    'DomainZonePlanArgs',
    'DomainZonePlanConfigurationArgs',
    'DomainZonePlanOptionArgs',
    'DomainZonePlanOptionConfigurationArgs',
    'IpLoadBalancingHttpFarmProbeArgs',
    'IpLoadBalancingHttpRouteActionArgs',
    'IpLoadBalancingHttpRouteRuleArgs',
    'IpLoadBalancingOrderArgs',
    'IpLoadBalancingOrderDetailArgs',
    'IpLoadBalancingOrderableZoneArgs',
    'IpLoadBalancingPlanArgs',
    'IpLoadBalancingPlanConfigurationArgs',
    'IpLoadBalancingPlanOptionArgs',
    'IpLoadBalancingPlanOptionConfigurationArgs',
    'IpLoadBalancingTcpFarmProbeArgs',
    'IpLoadBalancingTcpRouteActionArgs',
    'IpLoadBalancingTcpRouteRuleArgs',
    'IpServiceOrderArgs',
    'IpServiceOrderDetailArgs',
    'IpServicePlanArgs',
    'IpServicePlanConfigurationArgs',
    'IpServicePlanOptionArgs',
    'IpServicePlanOptionConfigurationArgs',
    'IpServiceRoutedToArgs',
    'VrackOrderArgs',
    'VrackOrderDetailArgs',
    'VrackPlanArgs',
    'VrackPlanConfigurationArgs',
    'VrackPlanOptionArgs',
    'VrackPlanOptionConfigurationArgs',
]

@pulumi.input_type
class CloudProjectContainerRegistryPlanArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanFeatureArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 registry_limits: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanRegistryLimitArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] code: Plan code from the catalog
        :param pulumi.Input[str] created_at: Plan creation date
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanFeatureArgs']]] features: Features of the plan
        :param pulumi.Input[str] id: Plan ID
        :param pulumi.Input[str] name: Registry name
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanRegistryLimitArgs']]] registry_limits: Container registry limits
        :param pulumi.Input[str] updated_at: Registry last update date
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_limits is not None:
            pulumi.set(__self__, "registry_limits", registry_limits)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanFeatureArgs']]]]:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanRegistryLimitArgs']]]]:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @registry_limits.setter
    def registry_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectContainerRegistryPlanRegistryLimitArgs']]]]):
        pulumi.set(self, "registry_limits", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class CloudProjectContainerRegistryPlanFeatureArgs:
    def __init__(__self__, *,
                 vulnerability: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] vulnerability: Vulnerability scanning
        """
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> Optional[pulumi.Input[bool]]:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")

    @vulnerability.setter
    def vulnerability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability", value)


@pulumi.input_type
class CloudProjectContainerRegistryPlanRegistryLimitArgs:
    def __init__(__self__, *,
                 image_storage: Optional[pulumi.Input[int]] = None,
                 parallel_request: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] image_storage: Docker image storage limits in bytes
        :param pulumi.Input[int] parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        if image_storage is not None:
            pulumi.set(__self__, "image_storage", image_storage)
        if parallel_request is not None:
            pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> Optional[pulumi.Input[int]]:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @image_storage.setter
    def image_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_storage", value)

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> Optional[pulumi.Input[int]]:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")

    @parallel_request.setter
    def parallel_request(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_request", value)


@pulumi.input_type
class CloudProjectDatabaseEndpointArgs:
    def __init__(__self__, *,
                 component: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 scheme: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] component: Type of component the URI relates to.
        :param pulumi.Input[str] domain: Domain of the cluster.
        :param pulumi.Input[str] path: Path of the endpoint.
        :param pulumi.Input[int] port: Connection port for the endpoint.
        :param pulumi.Input[str] scheme: Scheme used to generate the URI.
        :param pulumi.Input[bool] ssl: Defines whether the endpoint uses SSL.
        :param pulumi.Input[str] ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param pulumi.Input[str] uri: URI of the endpoint.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> Optional[pulumi.Input[str]]:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @component.setter
    def component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class CloudProjectDatabaseNodeArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] region: Public cloud region in which the node should be deployed.
               Ex: "GRA'.
        :param pulumi.Input[str] network_id: Private network id in which the node should be deployed.
        :param pulumi.Input[str] subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "region", region)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Public cloud region in which the node should be deployed.
        Ex: "GRA'.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private network id in which the node should be deployed.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class CloudProjectKubeNodePoolTemplateArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateMetadataArgs']] = None,
                 spec: Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateSpecArgs']] = None):
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateSpecArgs']]:
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['CloudProjectKubeNodePoolTemplateSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class CloudProjectKubeNodePoolTemplateMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class CloudProjectKubeNodePoolTemplateSpecArgs:
    def __init__(__self__, *,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None):
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unschedulable", value)


@pulumi.input_type
class CloudProjectKubePrivateNetworkConfigurationArgs:
    def __init__(__self__, *,
                 default_vrack_gateway: pulumi.Input[str],
                 private_network_routing_as_default: pulumi.Input[bool]):
        pulumi.set(__self__, "default_vrack_gateway", default_vrack_gateway)
        pulumi.set(__self__, "private_network_routing_as_default", private_network_routing_as_default)

    @property
    @pulumi.getter(name="defaultVrackGateway")
    def default_vrack_gateway(self) -> pulumi.Input[str]:
        return pulumi.get(self, "default_vrack_gateway")

    @default_vrack_gateway.setter
    def default_vrack_gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_vrack_gateway", value)

    @property
    @pulumi.getter(name="privateNetworkRoutingAsDefault")
    def private_network_routing_as_default(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "private_network_routing_as_default")

    @private_network_routing_as_default.setter
    def private_network_routing_as_default(self, value: pulumi.Input[bool]):
        pulumi.set(self, "private_network_routing_as_default", value)


@pulumi.input_type
class CloudProjectNetworkPrivateRegionsAttributeArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 openstackid: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if openstackid is not None:
            pulumi.set(__self__, "openstackid", openstackid)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def openstackid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "openstackid")

    @openstackid.setter
    def openstackid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "openstackid", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class CloudProjectNetworkPrivateRegionsStatusArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class CloudProjectNetworkPrivateSubnetIpPoolArgs:
    def __init__(__self__, *,
                 dhcp: Optional[pulumi.Input[bool]] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] dhcp: Enable DHCP.
               Changing this forces a new resource to be created. Defaults to false.
               _
        :param pulumi.Input[str] end: Last ip for this region.
               Changing this value recreates the subnet.
        :param pulumi.Input[str] network: Global network in CIDR format.
               Changing this value recreates the subnet
        :param pulumi.Input[str] region: The region in which the network subnet will be created.
               Ex.: "GRA1". Changing this value recreates the resource.
        :param pulumi.Input[str] start: First ip for this region.
               Changing this value recreates the subnet.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DHCP.
        Changing this forces a new resource to be created. Defaults to false.
        _
        """
        return pulumi.get(self, "dhcp")

    @dhcp.setter
    def dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Last ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Global network in CIDR format.
        Changing this value recreates the subnet
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the network subnet will be created.
        Ex.: "GRA1". Changing this value recreates the resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        First ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class CloudProjectOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class CloudProjectOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class CloudProjectPlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class CloudProjectPlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CloudProjectPlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudProjectPlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class CloudProjectPlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CloudProjectUserRoleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[str] id: id of the role
        :param pulumi.Input[str] name: name of the role
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: list of permissions associated with the role
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class DbaasLogsInputConfigurationArgs:
    def __init__(__self__, *,
                 flowgger: Optional[pulumi.Input['DbaasLogsInputConfigurationFlowggerArgs']] = None,
                 logstash: Optional[pulumi.Input['DbaasLogsInputConfigurationLogstashArgs']] = None):
        """
        :param pulumi.Input['DbaasLogsInputConfigurationFlowggerArgs'] flowgger: Flowgger configuration
        :param pulumi.Input['DbaasLogsInputConfigurationLogstashArgs'] logstash: Logstash configuration
        """
        if flowgger is not None:
            pulumi.set(__self__, "flowgger", flowgger)
        if logstash is not None:
            pulumi.set(__self__, "logstash", logstash)

    @property
    @pulumi.getter
    def flowgger(self) -> Optional[pulumi.Input['DbaasLogsInputConfigurationFlowggerArgs']]:
        """
        Flowgger configuration
        """
        return pulumi.get(self, "flowgger")

    @flowgger.setter
    def flowgger(self, value: Optional[pulumi.Input['DbaasLogsInputConfigurationFlowggerArgs']]):
        pulumi.set(self, "flowgger", value)

    @property
    @pulumi.getter
    def logstash(self) -> Optional[pulumi.Input['DbaasLogsInputConfigurationLogstashArgs']]:
        """
        Logstash configuration
        """
        return pulumi.get(self, "logstash")

    @logstash.setter
    def logstash(self, value: Optional[pulumi.Input['DbaasLogsInputConfigurationLogstashArgs']]):
        pulumi.set(self, "logstash", value)


@pulumi.input_type
class DbaasLogsInputConfigurationFlowggerArgs:
    def __init__(__self__, *,
                 log_format: pulumi.Input[str],
                 log_framing: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_format: Type of format to decode. One of "RFC5424", "LTSV", "GELF", "CAPNP"
        :param pulumi.Input[str] log_framing: Indicates how messages are delimited. One of "LINE", "NUL", "SYSLEN", "CAPNP"
        """
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_framing", log_framing)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> pulumi.Input[str]:
        """
        Type of format to decode. One of "RFC5424", "LTSV", "GELF", "CAPNP"
        """
        return pulumi.get(self, "log_format")

    @log_format.setter
    def log_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_format", value)

    @property
    @pulumi.getter(name="logFraming")
    def log_framing(self) -> pulumi.Input[str]:
        """
        Indicates how messages are delimited. One of "LINE", "NUL", "SYSLEN", "CAPNP"
        """
        return pulumi.get(self, "log_framing")

    @log_framing.setter
    def log_framing(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_framing", value)


@pulumi.input_type
class DbaasLogsInputConfigurationLogstashArgs:
    def __init__(__self__, *,
                 input_section: pulumi.Input[str],
                 filter_section: Optional[pulumi.Input[str]] = None,
                 pattern_section: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] input_section: The filter section of logstash.conf
        :param pulumi.Input[str] filter_section: The filter section of logstash.conf
        :param pulumi.Input[str] pattern_section: The list of customs Grok patterns
        """
        pulumi.set(__self__, "input_section", input_section)
        if filter_section is not None:
            pulumi.set(__self__, "filter_section", filter_section)
        if pattern_section is not None:
            pulumi.set(__self__, "pattern_section", pattern_section)

    @property
    @pulumi.getter(name="inputSection")
    def input_section(self) -> pulumi.Input[str]:
        """
        The filter section of logstash.conf
        """
        return pulumi.get(self, "input_section")

    @input_section.setter
    def input_section(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_section", value)

    @property
    @pulumi.getter(name="filterSection")
    def filter_section(self) -> Optional[pulumi.Input[str]]:
        """
        The filter section of logstash.conf
        """
        return pulumi.get(self, "filter_section")

    @filter_section.setter
    def filter_section(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_section", value)

    @property
    @pulumi.getter(name="patternSection")
    def pattern_section(self) -> Optional[pulumi.Input[str]]:
        """
        The list of customs Grok patterns
        """
        return pulumi.get(self, "pattern_section")

    @pattern_section.setter
    def pattern_section(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_section", value)


@pulumi.input_type
class DedicatedServiceInstallTaskDetailsArgs:
    def __init__(__self__, *,
                 change_log: Optional[pulumi.Input[str]] = None,
                 custom_hostname: Optional[pulumi.Input[str]] = None,
                 disk_group_id: Optional[pulumi.Input[int]] = None,
                 install_rtm: Optional[pulumi.Input[bool]] = None,
                 install_sql_server: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 no_raid: Optional[pulumi.Input[bool]] = None,
                 post_installation_script_link: Optional[pulumi.Input[str]] = None,
                 post_installation_script_return: Optional[pulumi.Input[str]] = None,
                 reset_hw_raid: Optional[pulumi.Input[bool]] = None,
                 soft_raid_devices: Optional[pulumi.Input[int]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 use_distrib_kernel: Optional[pulumi.Input[bool]] = None,
                 use_spla: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] change_log: Template change log details.
        :param pulumi.Input[str] custom_hostname: Set up the server using the provided hostname instead of the default hostname.
        :param pulumi.Input[int] disk_group_id: Disk group id.
        :param pulumi.Input[bool] install_rtm: set to true to install RTM.
        :param pulumi.Input[bool] install_sql_server: set to true to install sql server (Windows template only).
        :param pulumi.Input[str] language: language.
        :param pulumi.Input[bool] no_raid: set to true to disable RAID.
        :param pulumi.Input[str] post_installation_script_link: Indicate the URL where your postinstall customisation script is located.
        :param pulumi.Input[str] post_installation_script_return: Indicate the string returned by your postinstall customisation script on successful execution. Advice: your script should return a unique validation string in case of succes. A good example is 'loh1Xee7eo OK OK OK UGh8Ang1Gu'.
        :param pulumi.Input[bool] reset_hw_raid: set to true to make a hardware raid reset.
        :param pulumi.Input[int] soft_raid_devices: soft raid devices.
        :param pulumi.Input[str] ssh_key_name: Name of the ssh key that should be installed. Password login will be disabled.
        :param pulumi.Input[bool] use_distrib_kernel: Use the distribution's native kernel instead of the recommended OVH Kernel.
        :param pulumi.Input[bool] use_spla: set to true to use SPLA.
        """
        if change_log is not None:
            warnings.warn("""field is not used anymore""", DeprecationWarning)
            pulumi.log.warn("""change_log is deprecated: field is not used anymore""")
        if change_log is not None:
            pulumi.set(__self__, "change_log", change_log)
        if custom_hostname is not None:
            pulumi.set(__self__, "custom_hostname", custom_hostname)
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if install_rtm is not None:
            pulumi.set(__self__, "install_rtm", install_rtm)
        if install_sql_server is not None:
            pulumi.set(__self__, "install_sql_server", install_sql_server)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if no_raid is not None:
            pulumi.set(__self__, "no_raid", no_raid)
        if post_installation_script_link is not None:
            pulumi.set(__self__, "post_installation_script_link", post_installation_script_link)
        if post_installation_script_return is not None:
            pulumi.set(__self__, "post_installation_script_return", post_installation_script_return)
        if reset_hw_raid is not None:
            pulumi.set(__self__, "reset_hw_raid", reset_hw_raid)
        if soft_raid_devices is not None:
            pulumi.set(__self__, "soft_raid_devices", soft_raid_devices)
        if ssh_key_name is not None:
            pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if use_distrib_kernel is not None:
            pulumi.set(__self__, "use_distrib_kernel", use_distrib_kernel)
        if use_spla is not None:
            pulumi.set(__self__, "use_spla", use_spla)

    @property
    @pulumi.getter(name="changeLog")
    def change_log(self) -> Optional[pulumi.Input[str]]:
        """
        Template change log details.
        """
        return pulumi.get(self, "change_log")

    @change_log.setter
    def change_log(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "change_log", value)

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Set up the server using the provided hostname instead of the default hostname.
        """
        return pulumi.get(self, "custom_hostname")

    @custom_hostname.setter
    def custom_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_hostname", value)

    @property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Disk group id.
        """
        return pulumi.get(self, "disk_group_id")

    @disk_group_id.setter
    def disk_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_group_id", value)

    @property
    @pulumi.getter(name="installRtm")
    def install_rtm(self) -> Optional[pulumi.Input[bool]]:
        """
        set to true to install RTM.
        """
        return pulumi.get(self, "install_rtm")

    @install_rtm.setter
    def install_rtm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_rtm", value)

    @property
    @pulumi.getter(name="installSqlServer")
    def install_sql_server(self) -> Optional[pulumi.Input[bool]]:
        """
        set to true to install sql server (Windows template only).
        """
        return pulumi.get(self, "install_sql_server")

    @install_sql_server.setter
    def install_sql_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_sql_server", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        language.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="noRaid")
    def no_raid(self) -> Optional[pulumi.Input[bool]]:
        """
        set to true to disable RAID.
        """
        return pulumi.get(self, "no_raid")

    @no_raid.setter
    def no_raid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_raid", value)

    @property
    @pulumi.getter(name="postInstallationScriptLink")
    def post_installation_script_link(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate the URL where your postinstall customisation script is located.
        """
        return pulumi.get(self, "post_installation_script_link")

    @post_installation_script_link.setter
    def post_installation_script_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_installation_script_link", value)

    @property
    @pulumi.getter(name="postInstallationScriptReturn")
    def post_installation_script_return(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate the string returned by your postinstall customisation script on successful execution. Advice: your script should return a unique validation string in case of succes. A good example is 'loh1Xee7eo OK OK OK UGh8Ang1Gu'.
        """
        return pulumi.get(self, "post_installation_script_return")

    @post_installation_script_return.setter
    def post_installation_script_return(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_installation_script_return", value)

    @property
    @pulumi.getter(name="resetHwRaid")
    def reset_hw_raid(self) -> Optional[pulumi.Input[bool]]:
        """
        set to true to make a hardware raid reset.
        """
        return pulumi.get(self, "reset_hw_raid")

    @reset_hw_raid.setter
    def reset_hw_raid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_hw_raid", value)

    @property
    @pulumi.getter(name="softRaidDevices")
    def soft_raid_devices(self) -> Optional[pulumi.Input[int]]:
        """
        soft raid devices.
        """
        return pulumi.get(self, "soft_raid_devices")

    @soft_raid_devices.setter
    def soft_raid_devices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "soft_raid_devices", value)

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ssh key that should be installed. Password login will be disabled.
        """
        return pulumi.get(self, "ssh_key_name")

    @ssh_key_name.setter
    def ssh_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key_name", value)

    @property
    @pulumi.getter(name="useDistribKernel")
    def use_distrib_kernel(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the distribution's native kernel instead of the recommended OVH Kernel.
        """
        return pulumi.get(self, "use_distrib_kernel")

    @use_distrib_kernel.setter
    def use_distrib_kernel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_distrib_kernel", value)

    @property
    @pulumi.getter(name="useSpla")
    def use_spla(self) -> Optional[pulumi.Input[bool]]:
        """
        set to true to use SPLA.
        """
        return pulumi.get(self, "use_spla")

    @use_spla.setter
    def use_spla(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_spla", value)


@pulumi.input_type
class DomainZoneOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZoneOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['DomainZoneOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainZoneOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZoneOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class DomainZoneOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: description
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class DomainZonePlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['DomainZonePlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class DomainZonePlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DomainZonePlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['DomainZonePlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainZonePlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class DomainZonePlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpLoadBalancingHttpFarmProbeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 force_ssl: Optional[pulumi.Input[bool]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param pulumi.Input[bool] force_ssl: Force use of SSL (TLS)
        :param pulumi.Input[int] interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param pulumi.Input[str] match: What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param pulumi.Input[str] method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param pulumi.Input[bool] negate: Negate probe result
        :param pulumi.Input[str] pattern: Pattern to match against `match`
        :param pulumi.Input[int] port: Port for backends to recieve traffic on.
        :param pulumi.Input[str] url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @force_ssl.setter
    def force_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_ssl", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for backends to recieve traffic on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class IpLoadBalancingHttpRouteActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 status: Optional[pulumi.Input[int]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Action to trigger if all the rules of this route matches
        :param pulumi.Input[int] status: HTTP status code for "redirect" and "reject" actions
        :param pulumi.Input[str] target: Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        pulumi.set(__self__, "type", type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP status code for "redirect" and "reject" actions
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class IpLoadBalancingHttpRouteRuleArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[int]] = None,
                 sub_field: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param pulumi.Input[str] match: Matching operator. Not all operators are available for all fields. See "availableRules"
               * `negate`- Invert the matching operator effect
        :param pulumi.Input[str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[int] rule_id: Id of your rule
        :param pulumi.Input[str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        * `negate`- Invert the matching operator effect
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[int]]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.input_type
class IpLoadBalancingOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class IpLoadBalancingOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: description
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class IpLoadBalancingOrderableZoneArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 plan_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The zone three letter code
        :param pulumi.Input[str] plan_code: Plan code
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The zone three letter code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[pulumi.Input[str]]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_code", value)


@pulumi.input_type
class IpLoadBalancingPlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class IpLoadBalancingPlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpLoadBalancingPlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpLoadBalancingPlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class IpLoadBalancingPlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpLoadBalancingTcpFarmProbeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 force_ssl: Optional[pulumi.Input[bool]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param pulumi.Input[bool] force_ssl: Force use of SSL (TLS)
        :param pulumi.Input[int] interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param pulumi.Input[str] match: What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param pulumi.Input[str] method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param pulumi.Input[bool] negate: Negate probe result
        :param pulumi.Input[str] pattern: Pattern to match against `match`
        :param pulumi.Input[int] port: Port for backends to recieve traffic on.
        :param pulumi.Input[str] url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @force_ssl.setter
    def force_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_ssl", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for backends to recieve traffic on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class IpLoadBalancingTcpRouteActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 target: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Action to trigger if all the rules of this route matches
        :param pulumi.Input[str] target: Farm ID for "farm" action type, empty for others.
        """
        pulumi.set(__self__, "type", type)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Farm ID for "farm" action type, empty for others.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class IpLoadBalancingTcpRouteRuleArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[int]] = None,
                 sub_field: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param pulumi.Input[str] match: Matching operator. Not all operators are available for all fields. See "availableRules"
               * `negate`- Invert the matching operator effect
        :param pulumi.Input[str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[int] rule_id: Id of your rule
        :param pulumi.Input[str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        * `negate`- Invert the matching operator effect
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[int]]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.input_type
class IpServiceOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['IpServiceOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['IpServiceOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpServiceOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpServiceOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class IpServiceOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Custom description on your ip.
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Custom description on your ip.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class IpServicePlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['IpServicePlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class IpServicePlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpServicePlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['IpServicePlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpServicePlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class IpServicePlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpServiceRoutedToArgs:
    def __init__(__self__, *,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] service_name: Service where ip is routed to
               * `service_name`: service name
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service where ip is routed to
        * `service_name`: service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class VrackOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['VrackOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['VrackOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VrackOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VrackOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class VrackOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: yourvrackdescription
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        yourvrackdescription
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class VrackPlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['VrackPlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class VrackPlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VrackPlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['VrackPlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VrackPlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class VrackPlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


