# Forced photometry on MaDCoWS cluster positions

    nemoMass S18d_202003.yml -c externalCatalogChecks/mergeMaDCoWS/MADCOWSUnion.fits

# Re-creating the ACTPol two-season cluster catalog

Here is an example of how to re-create the cluster catalog presented 
in the [two-season ACTPol cluster catalog paper](http://adsabs.harvard.edu/abs/2017arXiv170905600H). 
This uses nemo's RealSpaceMatchedFilter method. Note that since nemo
has been updated since the time the ACTPol cluster catalog paper
was published, some results may not be exactly the same (most of this 
is due to changing the underlying code for calculating map power 
spectra from `flipper` to `pixell`, but the code for calculating the
selection function / completeness has also been completely re-written).

If you want to see an example .yml config file that breaks the map 
up into tiles and runs in parallel, see the [examples/AdvACT](../AdvACT/) 
directory instead. This also makes use of some features not used here
(e.g., multi-frequency filtering, non-azimuthally symmetric kernels 
etc.).

# Downloading ACT maps

This directory already contains some of the things needed - e.g, the
survey and point source masks (`surveyMask.fits.gz` and 
`pointSourceMask.fits.gz` respectively), the beam profile used (under 
`profiles_ACT/`; from ACT actually, but ACTPol is not significantly 
different for cluster-finding purposes), and the .yml config file, from
which nemo reads its settings (see below). However, the maps are too 
big to include in the github repository, so we need to get them from 
elsewhere.

For the ACTPol two-season cluster catalog, we combined the ACT+ACTPol
maps (which are available on LAMBDA). You can download the combined 
map and weight files (403 Mb) using:

```
wget http://www.acru.ukzn.ac.za/~mjh/equD56Maps.tar.gz
```

Extract this in the current directory (i.e., the same place as the 
equD56.yml file). 

# Making a cluster catalog

Run `nemo` using:

```
nemo equD56.yml
```

You can check the settings by opening the .yml file in a text editor.
This may take ~20-30 minutes to run, because a lot of different filter
scales are used (for a "cosmological sample", you would only need to
run the `'Arnaud_M2e14_z0p4'` filter, and could comment out with # the
other dictionaries defining each other filter in the mapFilters 
list - this is already done in the `equD56_quick.yml` file that you can
find in this directory).

Output is written to the `equD56` directory. Here you will find 
catalogs (.fits tables, e.g., `equD56_optimalCatalog.fits`), DS9 region
(.reg files), images (both in terms of y0 and signal-to-noise; under
`filteredMaps/`), and a bunch of other stuff under `diagnostics/`.

# Estimating cluster masses

If you want to measure masses, a .fits table that includes the columns
`redshift` and `redshiftErr` is needed. The `ACTPol_redshifts.fits` file
in this directory contains all redshifts that were assigned to 
cluster candidates on the web database at the time the ACTPol clusters
paper was submitted. You can specify the redshift catalog 
used for mass estimates with the `massOptions` key in the .yml file. 
Since this is already filled in, you can run the mass estimation 
script with:

```
nemoMass equD56.yml
```

Nemo will then infer the masses of clusters detected in the 
`equD56/equD56_optimalCatalog.fits` catalog generated by the previous 
step. You can give a path to another catalog (e.g., a mock - see 
below) by using the `-c` switch. If you provide a catalog that 
doesn't contain `fixed_y_c`, `fixed_err_y_c` columns, nemo will run 
in "forced photometry" mode, and measure the SZ observables and infer
masses at the positions given in the catalog (only the `name`, `RADeg`, 
`decDeg`, and `redshift` columns need to be present for this mode to
work).

`nemoMass` will take ~5 minutes to run (initially), as it calculates 
the filter mismatch function Q (the result of this is cached, so 
subsequent runs will be faster). The output is written as a 
.fits table, `equD56/equD56_M500.fits`.

If you're interested in measuring photo-zs for clusters detected with
`nemo`, check out `zCluster`: 

<https://github.com/ACTCollaboration/zCluster>

This can take the `equD56/equD56_optimalCatalog.fits` file as input.

# Calculating completeness

Steps 1-3 are all that are needed to recreate the two-season ACTPol
cluster catalog (though see the note at the top of this page). 
You can check the output by cross-matching against the 
`ACTPol_clusters.fits` catalog using, e.g., 
[TopCat](http://www.star.bris.ac.uk/%7Embt/topcat/).

If you wanted to run simulations to estimate completeness, you can use
the `nemoSelFn` script. You can run it with:

```
nemoSelFn equD56.yml
```

This will take ~30 minutes to run (again, subsequent runs will be 
faster, as some of the output is cached). The output for this script
is written in the `diagnostics/` directory, and includes a plot of
the 90% completeness limit, averaged over the survey (in this case
the E-D56 field), and an equivalent mass limit map, evaluated at 
z = 0.5 (a .fits image). It is making the latter that takes up most
of the time - this can be disabled by removing the `massLimitMaps`
key from the `selFnOptions` dictionary in the .yml file. 

Note that `nemoSelFn` has been completely rewritten and is different
to the version used for the ACTPol paper. Hence, the results are 
different (90% completeness mass limits are higher than quoted in
the paper).

A script that shows an example of how to use the selection function
can be found in this directory. You can run it with:

```
python selFnExample.py equD56.yml equD56/selFn
```

Here, the second argument gives the location of the `selFn` directory
made by `nemoSelFn` - this may be copied to a different location,
and should contain all of the information needed to estimate the 
completeness for a given `nemo` run. By default, this example uses
the full survey area, but you may optionally use the `-f` switch to
specify a different footprint to use (see the `selFnFootprints` 
dictionary in the .yml config file - this is commented out by 
default). Footprints can be used to calculate the
completeness within the intersection between the SZ survey and an
optical survey (e.g., DES, HSC, KiDS, SDSS etc.). The `-S` switch may
be used to change the signal-to-noise cut used to select the cluster
sample.

You can also take a look at the `nemoCosmo` script for more examples of
how to use the selection function routines. Note that `nemoCosmo` is 
experimental, and to date has been used for testing nemo rather than
for cosmological analyses.

# Generating mock catalogs

You can generate mock cluster catalogs using the output from nemo
by using the `nemoMock` script:

```
nemoMock equD56/selFn mocks
```

In this example, mock catalogs will be written into the `mocks` 
directory. You can use the `-N` switch or set the `makeMockCatalogs`
parameter in the config file to control the number of catalogs to 
be made. You can use the `-C` switch or set the `combineMocks`
config file parameter to True if you want to stitch all of the 
generated mocks together to form one giant oversampled catalog 
(be useful for some applications).

Mock catalogs assume the fixed cosmology and mass scaling relation 
parameters given in the `massOptions` dictionary in the config 
file - so for the Arnaud et al. (2010) based scaling relation, 
the number of clusters in the mocks will be larger than what is 
observed in reality.
