"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Geo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Geo extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'geo';
        this.accessLevelList = {
            Write: [
                'AssociateTrackerConsumer',
                'BatchDeleteDevicePositionHistory',
                'BatchDeleteGeofence',
                'BatchEvaluateGeofences',
                'BatchPutGeofence',
                'BatchUpdateDevicePosition',
                'CreateGeofenceCollection',
                'CreateMap',
                'CreatePlaceIndex',
                'CreateRouteCalculator',
                'CreateTracker',
                'DeleteGeofenceCollection',
                'DeleteMap',
                'DeletePlaceIndex',
                'DeleteRouteCalculator',
                'DeleteTracker',
                'DisassociateTrackerConsumer',
                'PutGeofence',
                'UpdateGeofenceCollection',
                'UpdateMap',
                'UpdatePlaceIndex',
                'UpdateRouteCalculator',
                'UpdateTracker'
            ],
            Read: [
                'BatchGetDevicePosition',
                'CalculateRoute',
                'CalculateRouteMatrix',
                'DescribeGeofenceCollection',
                'DescribeMap',
                'DescribePlaceIndex',
                'DescribeRouteCalculator',
                'DescribeTracker',
                'GetDevicePosition',
                'GetDevicePositionHistory',
                'GetGeofence',
                'GetMapGlyphs',
                'GetMapSprites',
                'GetMapStyleDescriptor',
                'GetMapTile',
                'ListDevicePositions',
                'ListGeofences',
                'ListTagsForResource',
                'ListTrackerConsumers',
                'SearchPlaceIndexForPosition',
                'SearchPlaceIndexForSuggestions',
                'SearchPlaceIndexForText'
            ],
            List: [
                'ListGeofenceCollections',
                'ListMaps',
                'ListPlaceIndexes',
                'ListRouteCalculators',
                'ListTrackers'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an association between a geofence-collection and a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_AssociateTrackerConsumer.html
     */
    toAssociateTrackerConsumer() {
        return this.to('AssociateTrackerConsumer');
    }
    /**
     * Grants permission to delete a batch of device position histories from a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteDevicePositionHistory.html
     */
    toBatchDeleteDevicePositionHistory() {
        return this.to('BatchDeleteDevicePositionHistory');
    }
    /**
     * Grants permission to delete a batch of geofences from a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteGeofence.html
     */
    toBatchDeleteGeofence() {
        return this.to('BatchDeleteGeofence');
    }
    /**
     * Grants permission to evaluate device positions against the position of geofences in a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchEvaluateGeofences.html
     */
    toBatchEvaluateGeofences() {
        return this.to('BatchEvaluateGeofences');
    }
    /**
     * Grants permission to send a batch request to retrieve device positions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchGetDevicePosition.html
     */
    toBatchGetDevicePosition() {
        return this.to('BatchGetDevicePosition');
    }
    /**
     * Grants permission to send a batch request for adding geofences into a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchPutGeofence.html
     */
    toBatchPutGeofence() {
        return this.to('BatchPutGeofence');
    }
    /**
     * Grants permission to upload a position update for one or more devices to a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchUpdateDevicePosition.html
     */
    toBatchUpdateDevicePosition() {
        return this.to('BatchUpdateDevicePosition');
    }
    /**
     * Grants permission to calculate routes using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRoute.html
     */
    toCalculateRoute() {
        return this.to('CalculateRoute');
    }
    /**
     * Grants permission to calculate a route matrix using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix() {
        return this.to('CalculateRouteMatrix');
    }
    /**
     * Grants permission to create a geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateGeofenceCollection.html
     */
    toCreateGeofenceCollection() {
        return this.to('CreateGeofenceCollection');
    }
    /**
     * Grants permission to create a map resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateMap.html
     */
    toCreateMap() {
        return this.to('CreateMap');
    }
    /**
     * Grants permission to create a place index resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreatePlaceIndex.html
     */
    toCreatePlaceIndex() {
        return this.to('CreatePlaceIndex');
    }
    /**
     * Grants permission to create a route calculator resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateRouteCalculator.html
     */
    toCreateRouteCalculator() {
        return this.to('CreateRouteCalculator');
    }
    /**
     * Grants permission to create a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateTracker.html
     */
    toCreateTracker() {
        return this.to('CreateTracker');
    }
    /**
     * Grants permission to delete a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteGeofenceCollection.html
     */
    toDeleteGeofenceCollection() {
        return this.to('DeleteGeofenceCollection');
    }
    /**
     * Grants permission to delete a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteMap.html
     */
    toDeleteMap() {
        return this.to('DeleteMap');
    }
    /**
     * Grants permission to delete a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeletePlaceIndex.html
     */
    toDeletePlaceIndex() {
        return this.to('DeletePlaceIndex');
    }
    /**
     * Grants permission to delete a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteRouteCalculator.html
     */
    toDeleteRouteCalculator() {
        return this.to('DeleteRouteCalculator');
    }
    /**
     * Grants permission to delete a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteTracker.html
     */
    toDeleteTracker() {
        return this.to('DeleteTracker');
    }
    /**
     * Grants permission to retrieve geofence collection details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeGeofenceCollection.html
     */
    toDescribeGeofenceCollection() {
        return this.to('DescribeGeofenceCollection');
    }
    /**
     * Grants permission to retrieve map resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeMap.html
     */
    toDescribeMap() {
        return this.to('DescribeMap');
    }
    /**
     * Grants permission to retrieve place-index resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribePlaceIndex.html
     */
    toDescribePlaceIndex() {
        return this.to('DescribePlaceIndex');
    }
    /**
     * Grants permission to retrieve route calculator resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeRouteCalculator.html
     */
    toDescribeRouteCalculator() {
        return this.to('DescribeRouteCalculator');
    }
    /**
     * Grants permission to retrieve a tracker resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeTracker.html
     */
    toDescribeTracker() {
        return this.to('DescribeTracker');
    }
    /**
     * Grants permission to remove the association between a tracker resource and a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DisassociateTrackerConsumer.html
     */
    toDisassociateTrackerConsumer() {
        return this.to('DisassociateTrackerConsumer');
    }
    /**
     * Grants permission to retrieve the latest device position
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePosition.html
     */
    toGetDevicePosition() {
        return this.to('GetDevicePosition');
    }
    /**
     * Grants permission to retrieve the device position history
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePositionHistory.html
     */
    toGetDevicePositionHistory() {
        return this.to('GetDevicePositionHistory');
    }
    /**
     * Grants permission to retrieve the geofence details from a geofence-collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetGeofence.html
     */
    toGetGeofence() {
        return this.to('GetGeofence');
    }
    /**
     * Grants permission to retrieve the glyph file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapGlyphs.html
     */
    toGetMapGlyphs() {
        return this.to('GetMapGlyphs');
    }
    /**
     * Grants permission to retrieve the sprite file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapSprites.html
     */
    toGetMapSprites() {
        return this.to('GetMapSprites');
    }
    /**
     * Grants permission to retrieve the map style descriptor from a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapStyleDescriptor.html
     */
    toGetMapStyleDescriptor() {
        return this.to('GetMapStyleDescriptor');
    }
    /**
     * Grants permission to retrieve the map tile from the map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapTile.html
     */
    toGetMapTile() {
        return this.to('GetMapTile');
    }
    /**
     * Grants permission to retrieve a list of devices and their latest positions from the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListDevicePositions.html
     */
    toListDevicePositions() {
        return this.to('ListDevicePositions');
    }
    /**
     * Grants permission to lists geofence-collections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofenceCollections.html
     */
    toListGeofenceCollections() {
        return this.to('ListGeofenceCollections');
    }
    /**
     * Grants permission to list geofences stored in a given geofence collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofences.html
     */
    toListGeofences() {
        return this.to('ListGeofences');
    }
    /**
     * Grants permission to list map resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListMaps.html
     */
    toListMaps() {
        return this.to('ListMaps');
    }
    /**
     * Grants permission to return a list of place index resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListPlaceIndexes.html
     */
    toListPlaceIndexes() {
        return this.to('ListPlaceIndexes');
    }
    /**
     * Grants permission to return a list of route calculator resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListRouteCalculators.html
     */
    toListRouteCalculators() {
        return this.to('ListRouteCalculators');
    }
    /**
     * Grants permission to list the tags (metadata) which you have assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackerConsumers.html
     */
    toListTrackerConsumers() {
        return this.to('ListTrackerConsumers');
    }
    /**
     * Grants permission to return a list of tracker resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackers.html
     */
    toListTrackers() {
        return this.to('ListTrackers');
    }
    /**
     * Grants permission to add a new geofence or update an existing geofence to a given geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_PutGeofence.html
     */
    toPutGeofence() {
        return this.to('PutGeofence');
    }
    /**
     * Grants permission to reverse geocodes a given coordinate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForPosition.html
     */
    toSearchPlaceIndexForPosition() {
        return this.to('SearchPlaceIndexForPosition');
    }
    /**
     * Grants permission to generate suggestions for addresses and points of interest based on partial or misspelled free-form text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForSuggestions.html
     */
    toSearchPlaceIndexForSuggestions() {
        return this.to('SearchPlaceIndexForSuggestions');
    }
    /**
     * Grants permission to geocode free-form text, such as an address, name, city or region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForText.html
     */
    toSearchPlaceIndexForText() {
        return this.to('SearchPlaceIndexForText');
    }
    /**
     * Grants permission to adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the given tags (metadata) from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateGeofenceCollection.html
     */
    toUpdateGeofenceCollection() {
        return this.to('UpdateGeofenceCollection');
    }
    /**
     * Grants permission to update a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateMap.html
     */
    toUpdateMap() {
        return this.to('UpdateMap');
    }
    /**
     * Grants permission to update a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdatePlaceIndex.html
     */
    toUpdatePlaceIndex() {
        return this.to('UpdatePlaceIndex');
    }
    /**
     * Grants permission to update a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateRouteCalculator.html
     */
    toUpdateRouteCalculator() {
        return this.to('UpdateRouteCalculator');
    }
    /**
     * Grants permission to update a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateTracker.html
     */
    toUpdateTracker() {
        return this.to('UpdateTracker');
    }
    /**
     * Adds a resource of type geofence-collection to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#geofence-overview
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGeofenceCollection(geofenceCollectionName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:geofence-collection/${geofenceCollectionName}`);
    }
    /**
     * Adds a resource of type map to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#map-overview
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMap(mapName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:map/${mapName}`);
    }
    /**
     * Adds a resource of type place-index to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#places-overview
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaceIndex(indexName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:place-index/${indexName}`);
    }
    /**
     * Adds a resource of type route-calculator to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#routes-overview
     *
     * @param calculatorName - Identifier for the calculatorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRouteCalculator(calculatorName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:route-calculator/${calculatorName}`);
    }
    /**
     * Adds a resource of type tracker to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#tracking-overview
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTracker(trackerName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:tracker/${trackerName}`);
    }
}
exports.Geo = Geo;
_a = JSII_RTTI_SYMBOL_1;
Geo[_a] = { fqn: "iam-floyd.Geo", version: "0.439.0" };
//# sourceMappingURL=data:application/json;base64,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